/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ShcItemPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ShcItemPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ShcItem.class)
public class ShcItemPointer extends StructurePointer {

	// NULL
	public static final ShcItemPointer NULL = new ShcItemPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ShcItemPointer(long address) {
		super(address);
	}

	public static ShcItemPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ShcItemPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ShcItemPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new ShcItemPointer(address);
	}

	public ShcItemPointer add(long count) {
		return ShcItemPointer.cast(address + (ShcItem.SIZEOF * count));
	}

	public ShcItemPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ShcItemPointer addOffset(long offset) {
		return ShcItemPointer.cast(address + offset);
	}

	public ShcItemPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ShcItemPointer sub(long count) {
		return ShcItemPointer.cast(address - (ShcItem.SIZEOF * count));
	}

	public ShcItemPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ShcItemPointer subOffset(long offset) {
		return ShcItemPointer.cast(address - offset);
	}

	public ShcItemPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ShcItemPointer untag(long mask) {
		return ShcItemPointer.cast(address & ~mask);
	}

	public ShcItemPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ShcItem.SIZEOF;
	}

	// Implementation methods

	// U32 dataLen
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dataLenOffset_", declaredType="U32")
	public UDATA dataLen() throws CorruptDataException {
		return new U32(getIntAtOffset(ShcItem._dataLenOffset_));
	}

	// U32 dataLen
	public UDATAPointer dataLenEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + ShcItem._dataLenOffset_);
	}

	// U16 dataType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dataTypeOffset_", declaredType="U16")
	public U16 dataType() throws CorruptDataException {
		return new U16(getShortAtOffset(ShcItem._dataTypeOffset_));
	}

	// U16 dataType
	public U16Pointer dataTypeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return U16Pointer.cast(address + ShcItem._dataTypeOffset_);
	}

	// U16 jvmID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jvmIDOffset_", declaredType="U16")
	public U16 jvmID() throws CorruptDataException {
		return new U16(getShortAtOffset(ShcItem._jvmIDOffset_));
	}

	// U16 jvmID
	public U16Pointer jvmIDEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return U16Pointer.cast(address + ShcItem._jvmIDOffset_);
	}

}
