/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: OMRCgroupMetricIteratorStatePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the OMRCgroupMetricIteratorStatePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=OMRCgroupMetricIteratorState.class)
public class OMRCgroupMetricIteratorStatePointer extends StructurePointer {

	// NULL
	public static final OMRCgroupMetricIteratorStatePointer NULL = new OMRCgroupMetricIteratorStatePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected OMRCgroupMetricIteratorStatePointer(long address) {
		super(address);
	}

	public static OMRCgroupMetricIteratorStatePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static OMRCgroupMetricIteratorStatePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static OMRCgroupMetricIteratorStatePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new OMRCgroupMetricIteratorStatePointer(address);
	}

	public OMRCgroupMetricIteratorStatePointer add(long count) {
		return OMRCgroupMetricIteratorStatePointer.cast(address + (OMRCgroupMetricIteratorState.SIZEOF * count));
	}

	public OMRCgroupMetricIteratorStatePointer add(Scalar count) {
		return add(count.longValue());
	}

	public OMRCgroupMetricIteratorStatePointer addOffset(long offset) {
		return OMRCgroupMetricIteratorStatePointer.cast(address + offset);
	}

	public OMRCgroupMetricIteratorStatePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public OMRCgroupMetricIteratorStatePointer sub(long count) {
		return OMRCgroupMetricIteratorStatePointer.cast(address - (OMRCgroupMetricIteratorState.SIZEOF * count));
	}

	public OMRCgroupMetricIteratorStatePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public OMRCgroupMetricIteratorStatePointer subOffset(long offset) {
		return OMRCgroupMetricIteratorStatePointer.cast(address - offset);
	}

	public OMRCgroupMetricIteratorStatePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public OMRCgroupMetricIteratorStatePointer untag(long mask) {
		return OMRCgroupMetricIteratorStatePointer.cast(address & ~mask);
	}

	public OMRCgroupMetricIteratorStatePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return OMRCgroupMetricIteratorState.SIZEOF;
	}

	// Implementation methods

	// U32 count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_countOffset_", declaredType="U32")
	public UDATA count() throws CorruptDataException {
		return new U32(getIntAtOffset(OMRCgroupMetricIteratorState._countOffset_));
	}

	// U32 count
	public UDATAPointer countEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + OMRCgroupMetricIteratorState._countOffset_);
	}

	// U8* fileContent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fileContentOffset_", declaredType="U8*")
	public U8Pointer fileContent() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(OMRCgroupMetricIteratorState._fileContentOffset_));
	}

	// U8* fileContent
	public PointerPointer fileContentEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + OMRCgroupMetricIteratorState._fileContentOffset_);
	}

	// I32 fileMetricCounter
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fileMetricCounterOffset_", declaredType="I32")
	public IDATA fileMetricCounter() throws CorruptDataException {
		return new I32(getIntAtOffset(OMRCgroupMetricIteratorState._fileMetricCounterOffset_));
	}

	// I32 fileMetricCounter
	public IDATAPointer fileMetricCounterEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return IDATAPointer.cast(address + OMRCgroupMetricIteratorState._fileMetricCounterOffset_);
	}

	// U32 numElements
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numElementsOffset_", declaredType="U32")
	public UDATA numElements() throws CorruptDataException {
		return new U32(getIntAtOffset(OMRCgroupMetricIteratorState._numElementsOffset_));
	}

	// U32 numElements
	public UDATAPointer numElementsEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + OMRCgroupMetricIteratorState._numElementsOffset_);
	}

	// U64 subsystemid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_subsystemidOffset_", declaredType="U64")
	public UDATA subsystemid() throws CorruptDataException {
		return new U64(getLongAtOffset(OMRCgroupMetricIteratorState._subsystemidOffset_));
	}

	// U64 subsystemid
	public UDATAPointer subsystemidEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + OMRCgroupMetricIteratorState._subsystemidOffset_);
	}

}
