/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_YieldCollaboratorPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_YieldCollaboratorPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_YieldCollaborator.class)
public class MM_YieldCollaboratorPointer extends MM_BaseNonVirtualPointer {

	// NULL
	public static final MM_YieldCollaboratorPointer NULL = new MM_YieldCollaboratorPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_YieldCollaboratorPointer(long address) {
		super(address);
	}

	public static MM_YieldCollaboratorPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_YieldCollaboratorPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_YieldCollaboratorPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new MM_YieldCollaboratorPointer(address);
	}

	public MM_YieldCollaboratorPointer add(long count) {
		return MM_YieldCollaboratorPointer.cast(address + (MM_YieldCollaborator.SIZEOF * count));
	}

	public MM_YieldCollaboratorPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_YieldCollaboratorPointer addOffset(long offset) {
		return MM_YieldCollaboratorPointer.cast(address + offset);
	}

	public MM_YieldCollaboratorPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_YieldCollaboratorPointer sub(long count) {
		return MM_YieldCollaboratorPointer.cast(address - (MM_YieldCollaborator.SIZEOF * count));
	}

	public MM_YieldCollaboratorPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_YieldCollaboratorPointer subOffset(long offset) {
		return MM_YieldCollaboratorPointer.cast(address - offset);
	}

	public MM_YieldCollaboratorPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_YieldCollaboratorPointer untag(long mask) {
		return MM_YieldCollaboratorPointer.cast(address & ~mask);
	}

	public MM_YieldCollaboratorPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_YieldCollaborator.SIZEOF;
	}

	// Implementation methods

	// volatile U64* _count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__countOffset_", declaredType="volatile U64*")
	public UDATAPointer _count() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(MM_YieldCollaborator.__countOffset_));
	}

	// volatile U64* _count
	public PointerPointer _countEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_YieldCollaborator.__countOffset_);
	}

	// omrthread_monitor_t* _mutex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__mutexOffset_", declaredType="omrthread_monitor_t*")
	public PointerPointer _mutex() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(MM_YieldCollaborator.__mutexOffset_));
	}

	// omrthread_monitor_t* _mutex
	public PointerPointer _mutexEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_YieldCollaborator.__mutexOffset_);
	}

	// MM_YieldCollaborator* _prev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__prevOffset_", declaredType="MM_YieldCollaborator*")
	public MM_YieldCollaboratorPointer _prev() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_YieldCollaborator.__prevOffset_);
		return MM_YieldCollaboratorPointer.cast(pointer);
	}

	// MM_YieldCollaborator* _prev
	public PointerPointer _prevEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_YieldCollaborator.__prevOffset_);
	}

	// MM_YieldCollaborator$ResumeEvent _resumeEvent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__resumeEventOffset_", declaredType="MM_YieldCollaborator$ResumeEvent")
	public long _resumeEvent() throws CorruptDataException {
			if (MM_YieldCollaborator$ResumeEvent.SIZEOF == 1) {
				return getByteAtOffset(MM_YieldCollaborator.__resumeEventOffset_);
			} else if (MM_YieldCollaborator$ResumeEvent.SIZEOF == 2) {
				return getShortAtOffset(MM_YieldCollaborator.__resumeEventOffset_);
			} else if (MM_YieldCollaborator$ResumeEvent.SIZEOF == 4) {
				return getIntAtOffset(MM_YieldCollaborator.__resumeEventOffset_);
			} else if (MM_YieldCollaborator$ResumeEvent.SIZEOF == 8) {
				return getLongAtOffset(MM_YieldCollaborator.__resumeEventOffset_);
			} else {
				throw new IllegalArgumentException("Unexpected ENUM size in core file");
			}
	}

	// MM_YieldCollaborator$ResumeEvent _resumeEvent
	public EnumPointer _resumeEventEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return EnumPointer.cast(address + MM_YieldCollaborator.__resumeEventOffset_, MM_YieldCollaborator$ResumeEvent.class);
	}

	// volatile U64 _yieldCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__yieldCountOffset_", declaredType="volatile U64")
	public UDATA _yieldCount() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_YieldCollaborator.__yieldCountOffset_));
	}

	// volatile U64 _yieldCount
	public UDATAPointer _yieldCountEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_YieldCollaborator.__yieldCountOffset_);
	}

	// volatile U64 _yieldIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__yieldIndexOffset_", declaredType="volatile U64")
	public UDATA _yieldIndex() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_YieldCollaborator.__yieldIndexOffset_));
	}

	// volatile U64 _yieldIndex
	public UDATAPointer _yieldIndexEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_YieldCollaborator.__yieldIndexOffset_);
	}

}
