/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_SegregatedGCPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_SegregatedGCPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_SegregatedGC.class)
public class MM_SegregatedGCPointer extends MM_GlobalCollectorPointer {

	// NULL
	public static final MM_SegregatedGCPointer NULL = new MM_SegregatedGCPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_SegregatedGCPointer(long address) {
		super(address);
	}

	public static MM_SegregatedGCPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_SegregatedGCPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_SegregatedGCPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new MM_SegregatedGCPointer(address);
	}

	public MM_SegregatedGCPointer add(long count) {
		return MM_SegregatedGCPointer.cast(address + (MM_SegregatedGC.SIZEOF * count));
	}

	public MM_SegregatedGCPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_SegregatedGCPointer addOffset(long offset) {
		return MM_SegregatedGCPointer.cast(address + offset);
	}

	public MM_SegregatedGCPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_SegregatedGCPointer sub(long count) {
		return MM_SegregatedGCPointer.cast(address - (MM_SegregatedGC.SIZEOF * count));
	}

	public MM_SegregatedGCPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_SegregatedGCPointer subOffset(long offset) {
		return MM_SegregatedGCPointer.cast(address - offset);
	}

	public MM_SegregatedGCPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_SegregatedGCPointer untag(long mask) {
		return MM_SegregatedGCPointer.cast(address & ~mask);
	}

	public MM_SegregatedGCPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_SegregatedGC.SIZEOF;
	}

	// Implementation methods

	// MM_CollectionStatisticsStandard _collectionStatistics
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__collectionStatisticsOffset_", declaredType="MM_CollectionStatisticsStandard")
	public MM_CollectionStatisticsStandardPointer _collectionStatistics() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return MM_CollectionStatisticsStandardPointer.cast(address + MM_SegregatedGC.__collectionStatisticsOffset_);
	}

	// MM_CollectionStatisticsStandard _collectionStatistics
	public PointerPointer _collectionStatisticsEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_SegregatedGC.__collectionStatisticsOffset_);
	}

	// MM_CycleState _cycleState
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__cycleStateOffset_", declaredType="MM_CycleState")
	public MM_CycleStatePointer _cycleState() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return MM_CycleStatePointer.cast(address + MM_SegregatedGC.__cycleStateOffset_);
	}

	// MM_CycleState _cycleState
	public PointerPointer _cycleStateEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_SegregatedGC.__cycleStateOffset_);
	}

	// MM_ParallelDispatcher* _dispatcher
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__dispatcherOffset_", declaredType="MM_ParallelDispatcher*")
	public MM_ParallelDispatcherPointer _dispatcher() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_SegregatedGC.__dispatcherOffset_);
		return MM_ParallelDispatcherPointer.cast(pointer);
	}

	// MM_ParallelDispatcher* _dispatcher
	public PointerPointer _dispatcherEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_SegregatedGC.__dispatcherOffset_);
	}

	// MM_GCExtensionsBase* _extensions
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__extensionsOffset_", declaredType="MM_GCExtensionsBase*")
	public MM_GCExtensionsBasePointer _extensions() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_SegregatedGC.__extensionsOffset_);
		return MM_GCExtensionsBasePointer.cast(pointer);
	}

	// MM_GCExtensionsBase* _extensions
	public PointerPointer _extensionsEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_SegregatedGC.__extensionsOffset_);
	}

	// MM_SegregatedMarkingScheme* _markingScheme
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__markingSchemeOffset_", declaredType="MM_SegregatedMarkingScheme*")
	public MM_SegregatedMarkingSchemePointer _markingScheme() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_SegregatedGC.__markingSchemeOffset_);
		return MM_SegregatedMarkingSchemePointer.cast(pointer);
	}

	// MM_SegregatedMarkingScheme* _markingScheme
	public PointerPointer _markingSchemeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_SegregatedGC.__markingSchemeOffset_);
	}

	// U64 _objectsMarked
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__objectsMarkedOffset_", declaredType="U64")
	public UDATA _objectsMarked() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_SegregatedGC.__objectsMarkedOffset_));
	}

	// U64 _objectsMarked
	public UDATAPointer _objectsMarkedEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_SegregatedGC.__objectsMarkedOffset_);
	}

	// OMRPortLibrary* _portLibrary
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__portLibraryOffset_", declaredType="OMRPortLibrary*")
	public OMRPortLibraryPointer _portLibrary() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_SegregatedGC.__portLibraryOffset_);
		return OMRPortLibraryPointer.cast(pointer);
	}

	// OMRPortLibrary* _portLibrary
	public PointerPointer _portLibraryEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_SegregatedGC.__portLibraryOffset_);
	}

	// U64 _scanBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__scanBytesOffset_", declaredType="U64")
	public UDATA _scanBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_SegregatedGC.__scanBytesOffset_));
	}

	// U64 _scanBytes
	public UDATAPointer _scanBytesEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_SegregatedGC.__scanBytesOffset_);
	}

	// MM_SweepSchemeSegregated* _sweepScheme
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sweepSchemeOffset_", declaredType="MM_SweepSchemeSegregated*")
	public MM_SweepSchemeSegregatedPointer _sweepScheme() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_SegregatedGC.__sweepSchemeOffset_);
		return MM_SweepSchemeSegregatedPointer.cast(pointer);
	}

	// MM_SweepSchemeSegregated* _sweepScheme
	public PointerPointer _sweepSchemeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_SegregatedGC.__sweepSchemeOffset_);
	}

}
