/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_RememberedSetCardListPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_RememberedSetCardListPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_RememberedSetCardList.class)
public class MM_RememberedSetCardListPointer extends MM_BaseVirtualPointer {

	// NULL
	public static final MM_RememberedSetCardListPointer NULL = new MM_RememberedSetCardListPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_RememberedSetCardListPointer(long address) {
		super(address);
	}

	public static MM_RememberedSetCardListPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_RememberedSetCardListPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_RememberedSetCardListPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new MM_RememberedSetCardListPointer(address);
	}

	public MM_RememberedSetCardListPointer add(long count) {
		return MM_RememberedSetCardListPointer.cast(address + (MM_RememberedSetCardList.SIZEOF * count));
	}

	public MM_RememberedSetCardListPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_RememberedSetCardListPointer addOffset(long offset) {
		return MM_RememberedSetCardListPointer.cast(address + offset);
	}

	public MM_RememberedSetCardListPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_RememberedSetCardListPointer sub(long count) {
		return MM_RememberedSetCardListPointer.cast(address - (MM_RememberedSetCardList.SIZEOF * count));
	}

	public MM_RememberedSetCardListPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_RememberedSetCardListPointer subOffset(long offset) {
		return MM_RememberedSetCardListPointer.cast(address - offset);
	}

	public MM_RememberedSetCardListPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_RememberedSetCardListPointer untag(long mask) {
		return MM_RememberedSetCardListPointer.cast(address & ~mask);
	}

	public MM_RememberedSetCardListPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_RememberedSetCardList.SIZEOF;
	}

	// Implementation methods

	// bool _beingRebuilt
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__beingRebuiltOffset_", declaredType="bool")
	public boolean _beingRebuilt() throws CorruptDataException {
		return getBoolAtOffset(MM_RememberedSetCardList.__beingRebuiltOffset_);
	}

	// bool _beingRebuilt
	public BoolPointer _beingRebuiltEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return BoolPointer.cast(address + MM_RememberedSetCardList.__beingRebuiltOffset_);
	}

	// MM_RememberedSetCardBucket* _bucketListHead
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bucketListHeadOffset_", declaredType="MM_RememberedSetCardBucket*")
	public MM_RememberedSetCardBucketPointer _bucketListHead() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_RememberedSetCardList.__bucketListHeadOffset_);
		return MM_RememberedSetCardBucketPointer.cast(pointer);
	}

	// MM_RememberedSetCardBucket* _bucketListHead
	public PointerPointer _bucketListHeadEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_RememberedSetCardList.__bucketListHeadOffset_);
	}

	// volatile UDATA _bufferCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bufferCountOffset_", declaredType="volatile UDATA")
	public UDATA _bufferCount() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(MM_RememberedSetCardList.__bufferCountOffset_));
	}

	// volatile UDATA _bufferCount
	public UDATAPointer _bufferCountEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_RememberedSetCardList.__bufferCountOffset_);
	}

	// UDATA _index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__indexOffset_", declaredType="UDATA")
	public UDATA _index() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(MM_RememberedSetCardList.__indexOffset_));
	}

	// UDATA _index
	public UDATAPointer _indexEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_RememberedSetCardList.__indexOffset_);
	}

	// volatile MM_RememberedSetCardList* _nonEmptyOverflowedNext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__nonEmptyOverflowedNextOffset_", declaredType="volatile MM_RememberedSetCardList*")
	public MM_RememberedSetCardListPointer _nonEmptyOverflowedNext() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_RememberedSetCardList.__nonEmptyOverflowedNextOffset_);
		return MM_RememberedSetCardListPointer.cast(pointer);
	}

	// volatile MM_RememberedSetCardList* _nonEmptyOverflowedNext
	public PointerPointer _nonEmptyOverflowedNextEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_RememberedSetCardList.__nonEmptyOverflowedNextOffset_);
	}

	// volatile UDATA _overflowed
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__overflowedOffset_", declaredType="volatile UDATA")
	public UDATA _overflowed() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(MM_RememberedSetCardList.__overflowedOffset_));
	}

	// volatile UDATA _overflowed
	public UDATAPointer _overflowedEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_RememberedSetCardList.__overflowedOffset_);
	}

	// bool _stable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__stableOffset_", declaredType="bool")
	public boolean _stable() throws CorruptDataException {
		return getBoolAtOffset(MM_RememberedSetCardList.__stableOffset_);
	}

	// bool _stable
	public BoolPointer _stableEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return BoolPointer.cast(address + MM_RememberedSetCardList.__stableOffset_);
	}

}
