/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_HeapMapIteratorPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_HeapMapIteratorPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_HeapMapIterator.class)
public class MM_HeapMapIteratorPointer extends StructurePointer {

	// NULL
	public static final MM_HeapMapIteratorPointer NULL = new MM_HeapMapIteratorPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_HeapMapIteratorPointer(long address) {
		super(address);
	}

	public static MM_HeapMapIteratorPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_HeapMapIteratorPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_HeapMapIteratorPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new MM_HeapMapIteratorPointer(address);
	}

	public MM_HeapMapIteratorPointer add(long count) {
		return MM_HeapMapIteratorPointer.cast(address + (MM_HeapMapIterator.SIZEOF * count));
	}

	public MM_HeapMapIteratorPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_HeapMapIteratorPointer addOffset(long offset) {
		return MM_HeapMapIteratorPointer.cast(address + offset);
	}

	public MM_HeapMapIteratorPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_HeapMapIteratorPointer sub(long count) {
		return MM_HeapMapIteratorPointer.cast(address - (MM_HeapMapIterator.SIZEOF * count));
	}

	public MM_HeapMapIteratorPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_HeapMapIteratorPointer subOffset(long offset) {
		return MM_HeapMapIteratorPointer.cast(address - offset);
	}

	public MM_HeapMapIteratorPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_HeapMapIteratorPointer untag(long mask) {
		return MM_HeapMapIteratorPointer.cast(address & ~mask);
	}

	public MM_HeapMapIteratorPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_HeapMapIterator.SIZEOF;
	}

	// Implementation methods

	// U64 _bitIndexHead
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bitIndexHeadOffset_", declaredType="U64")
	public UDATA _bitIndexHead() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_HeapMapIterator.__bitIndexHeadOffset_));
	}

	// U64 _bitIndexHead
	public UDATAPointer _bitIndexHeadEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_HeapMapIterator.__bitIndexHeadOffset_);
	}

	// const MM_GCExtensionsBase* _extensions
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__extensionsOffset_", declaredType="const MM_GCExtensionsBase*")
	public MM_GCExtensionsBasePointer _extensions() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_HeapMapIterator.__extensionsOffset_);
		return MM_GCExtensionsBasePointer.cast(pointer);
	}

	// const MM_GCExtensionsBase* _extensions
	public PointerPointer _extensionsEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_HeapMapIterator.__extensionsOffset_);
	}

	// U64* _heapChunkTop
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__heapChunkTopOffset_", declaredType="U64*")
	public UDATAPointer _heapChunkTop() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(MM_HeapMapIterator.__heapChunkTopOffset_));
	}

	// U64* _heapChunkTop
	public PointerPointer _heapChunkTopEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_HeapMapIterator.__heapChunkTopOffset_);
	}

	// U64* _heapMapSlotCurrent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__heapMapSlotCurrentOffset_", declaredType="U64*")
	public UDATAPointer _heapMapSlotCurrent() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(MM_HeapMapIterator.__heapMapSlotCurrentOffset_));
	}

	// U64* _heapMapSlotCurrent
	public PointerPointer _heapMapSlotCurrentEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_HeapMapIterator.__heapMapSlotCurrentOffset_);
	}

	// U64 _heapMapSlotValue
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__heapMapSlotValueOffset_", declaredType="U64")
	public UDATA _heapMapSlotValue() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_HeapMapIterator.__heapMapSlotValueOffset_));
	}

	// U64 _heapMapSlotValue
	public UDATAPointer _heapMapSlotValueEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_HeapMapIterator.__heapMapSlotValueOffset_);
	}

	// U64* _heapSlotCurrent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__heapSlotCurrentOffset_", declaredType="U64*")
	public UDATAPointer _heapSlotCurrent() throws CorruptDataException {
		return U64Pointer.cast(getPointerAtOffset(MM_HeapMapIterator.__heapSlotCurrentOffset_));
	}

	// U64* _heapSlotCurrent
	public PointerPointer _heapSlotCurrentEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_HeapMapIterator.__heapSlotCurrentOffset_);
	}

	// bool _useLargeObjectOptimization
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__useLargeObjectOptimizationOffset_", declaredType="bool")
	public boolean _useLargeObjectOptimization() throws CorruptDataException {
		return getBoolAtOffset(MM_HeapMapIterator.__useLargeObjectOptimizationOffset_);
	}

	// bool _useLargeObjectOptimization
	public BoolPointer _useLargeObjectOptimizationEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return BoolPointer.cast(address + MM_HeapMapIterator.__useLargeObjectOptimizationOffset_);
	}

}
