/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_GlobalMarkCardScrubberPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_GlobalMarkCardScrubberPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_GlobalMarkCardScrubber.class)
public class MM_GlobalMarkCardScrubberPointer extends MM_CardCleanerPointer {

	// NULL
	public static final MM_GlobalMarkCardScrubberPointer NULL = new MM_GlobalMarkCardScrubberPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_GlobalMarkCardScrubberPointer(long address) {
		super(address);
	}

	public static MM_GlobalMarkCardScrubberPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_GlobalMarkCardScrubberPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_GlobalMarkCardScrubberPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new MM_GlobalMarkCardScrubberPointer(address);
	}

	public MM_GlobalMarkCardScrubberPointer add(long count) {
		return MM_GlobalMarkCardScrubberPointer.cast(address + (MM_GlobalMarkCardScrubber.SIZEOF * count));
	}

	public MM_GlobalMarkCardScrubberPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_GlobalMarkCardScrubberPointer addOffset(long offset) {
		return MM_GlobalMarkCardScrubberPointer.cast(address + offset);
	}

	public MM_GlobalMarkCardScrubberPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_GlobalMarkCardScrubberPointer sub(long count) {
		return MM_GlobalMarkCardScrubberPointer.cast(address - (MM_GlobalMarkCardScrubber.SIZEOF * count));
	}

	public MM_GlobalMarkCardScrubberPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_GlobalMarkCardScrubberPointer subOffset(long offset) {
		return MM_GlobalMarkCardScrubberPointer.cast(address - offset);
	}

	public MM_GlobalMarkCardScrubberPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_GlobalMarkCardScrubberPointer untag(long mask) {
		return MM_GlobalMarkCardScrubberPointer.cast(address & ~mask);
	}

	public MM_GlobalMarkCardScrubberPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_GlobalMarkCardScrubber.SIZEOF;
	}

	// Implementation methods

	// UDATA _countBeforeYieldCheck
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__countBeforeYieldCheckOffset_", declaredType="UDATA")
	public UDATA _countBeforeYieldCheck() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(MM_GlobalMarkCardScrubber.__countBeforeYieldCheckOffset_));
	}

	// UDATA _countBeforeYieldCheck
	public UDATAPointer _countBeforeYieldCheckEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_GlobalMarkCardScrubber.__countBeforeYieldCheckOffset_);
	}

	// const MM_InterRegionRememberedSet* _interRegionRememberedSet
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__interRegionRememberedSetOffset_", declaredType="const MM_InterRegionRememberedSet*")
	public MM_InterRegionRememberedSetPointer _interRegionRememberedSet() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_GlobalMarkCardScrubber.__interRegionRememberedSetOffset_);
		return MM_InterRegionRememberedSetPointer.cast(pointer);
	}

	// const MM_InterRegionRememberedSet* _interRegionRememberedSet
	public PointerPointer _interRegionRememberedSetEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_GlobalMarkCardScrubber.__interRegionRememberedSetOffset_);
	}

	// const MM_HeapMap* _markMap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__markMapOffset_", declaredType="const MM_HeapMap*")
	public MM_HeapMapPointer _markMap() throws CorruptDataException {
		long pointer = getPointerAtOffset(MM_GlobalMarkCardScrubber.__markMapOffset_);
		return MM_HeapMapPointer.cast(pointer);
	}

	// const MM_HeapMap* _markMap
	public PointerPointer _markMapEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + MM_GlobalMarkCardScrubber.__markMapOffset_);
	}

	// UDATA _statistics._dirtyCards
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__statistics$_dirtyCardsOffset_", declaredType="UDATA")
	public UDATA _statistics$_dirtyCards() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(MM_GlobalMarkCardScrubber.__statistics$_dirtyCardsOffset_));
	}

	// UDATA _statistics._dirtyCards
	public UDATAPointer _statistics$_dirtyCardsEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_GlobalMarkCardScrubber.__statistics$_dirtyCardsOffset_);
	}

	// UDATA _statistics._gmpMustScanCards
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__statistics$_gmpMustScanCardsOffset_", declaredType="UDATA")
	public UDATA _statistics$_gmpMustScanCards() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(MM_GlobalMarkCardScrubber.__statistics$_gmpMustScanCardsOffset_));
	}

	// UDATA _statistics._gmpMustScanCards
	public UDATAPointer _statistics$_gmpMustScanCardsEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_GlobalMarkCardScrubber.__statistics$_gmpMustScanCardsOffset_);
	}

	// UDATA _statistics._scrubbedCards
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__statistics$_scrubbedCardsOffset_", declaredType="UDATA")
	public UDATA _statistics$_scrubbedCards() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(MM_GlobalMarkCardScrubber.__statistics$_scrubbedCardsOffset_));
	}

	// UDATA _statistics._scrubbedCards
	public UDATAPointer _statistics$_scrubbedCardsEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_GlobalMarkCardScrubber.__statistics$_scrubbedCardsOffset_);
	}

	// UDATA _statistics._scrubbedObjects
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__statistics$_scrubbedObjectsOffset_", declaredType="UDATA")
	public UDATA _statistics$_scrubbedObjects() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(MM_GlobalMarkCardScrubber.__statistics$_scrubbedObjectsOffset_));
	}

	// UDATA _statistics._scrubbedObjects
	public UDATAPointer _statistics$_scrubbedObjectsEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_GlobalMarkCardScrubber.__statistics$_scrubbedObjectsOffset_);
	}

	// const UDATA _yieldCheckFrequency
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__yieldCheckFrequencyOffset_", declaredType="const UDATA")
	public UDATA _yieldCheckFrequency() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(MM_GlobalMarkCardScrubber.__yieldCheckFrequencyOffset_));
	}

	// const UDATA _yieldCheckFrequency
	public UDATAPointer _yieldCheckFrequencyEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + MM_GlobalMarkCardScrubber.__yieldCheckFrequencyOffset_);
	}

}
