/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9SWFramePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9SWFramePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9SWFrame.class)
public class J9SWFramePointer extends StructurePointer {

	// NULL
	public static final J9SWFramePointer NULL = new J9SWFramePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9SWFramePointer(long address) {
		super(address);
	}

	public static J9SWFramePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9SWFramePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9SWFramePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new J9SWFramePointer(address);
	}

	public J9SWFramePointer add(long count) {
		return J9SWFramePointer.cast(address + (J9SWFrame.SIZEOF * count));
	}

	public J9SWFramePointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9SWFramePointer addOffset(long offset) {
		return J9SWFramePointer.cast(address + offset);
	}

	public J9SWFramePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9SWFramePointer sub(long count) {
		return J9SWFramePointer.cast(address - (J9SWFrame.SIZEOF * count));
	}

	public J9SWFramePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9SWFramePointer subOffset(long offset) {
		return J9SWFramePointer.cast(address - offset);
	}

	public J9SWFramePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9SWFramePointer untag(long mask) {
		return J9SWFramePointer.cast(address & ~mask);
	}

	public J9SWFramePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9SWFrame.SIZEOF;
	}

	// Implementation methods

	// UDATA argCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_argCountOffset_", declaredType="UDATA")
	public UDATA argCount() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(J9SWFrame._argCountOffset_));
	}

	// UDATA argCount
	public UDATAPointer argCountEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9SWFrame._argCountOffset_);
	}

	// UDATA* bottomSlot
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_bottomSlotOffset_", declaredType="UDATA*")
	public UDATAPointer bottomSlot() throws CorruptDataException {
		return UDATAPointer.cast(getPointerAtOffset(J9SWFrame._bottomSlotOffset_));
	}

	// UDATA* bottomSlot
	public PointerPointer bottomSlotEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9SWFrame._bottomSlotOffset_);
	}

	// UDATA* cp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cpOffset_", declaredType="UDATA*")
	public UDATAPointer cp() throws CorruptDataException {
		return UDATAPointer.cast(getPointerAtOffset(J9SWFrame._cpOffset_));
	}

	// UDATA* cp
	public PointerPointer cpEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9SWFrame._cpOffset_);
	}

	// UDATA frameFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_frameFlagsOffset_", declaredType="UDATA")
	public UDATA frameFlags() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(J9SWFrame._frameFlagsOffset_));
	}

	// UDATA frameFlags
	public UDATAPointer frameFlagsEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9SWFrame._frameFlagsOffset_);
	}

	// J9SWFrameTypeDescriptor ftd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ftdOffset_", declaredType="J9SWFrameTypeDescriptor")
	public J9SWFrameTypeDescriptorPointer ftd() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return J9SWFrameTypeDescriptorPointer.cast(address + J9SWFrame._ftdOffset_);
	}

	// J9SWFrameTypeDescriptor ftd
	public PointerPointer ftdEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9SWFrame._ftdOffset_);
	}

	// J9SWFrame* linkNext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_linkNextOffset_", declaredType="J9SWFrame*")
	public J9SWFramePointer linkNext() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9SWFrame._linkNextOffset_);
		return J9SWFramePointer.cast(pointer);
	}

	// J9SWFrame* linkNext
	public PointerPointer linkNextEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9SWFrame._linkNextOffset_);
	}

	// J9SWFrame* linkPrevious
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_linkPreviousOffset_", declaredType="J9SWFrame*")
	public J9SWFramePointer linkPrevious() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9SWFrame._linkPreviousOffset_);
		return J9SWFramePointer.cast(pointer);
	}

	// J9SWFrame* linkPrevious
	public PointerPointer linkPreviousEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9SWFrame._linkPreviousOffset_);
	}

	// UDATA literals
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_literalsOffset_", declaredType="UDATA")
	public UDATA literals() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(J9SWFrame._literalsOffset_));
	}

	// UDATA literals
	public UDATAPointer literalsEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9SWFrame._literalsOffset_);
	}

	// J9Method* method
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_methodOffset_", declaredType="J9Method*")
	public J9MethodPointer method() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9SWFrame._methodOffset_);
		return J9MethodPointer.cast(pointer);
	}

	// J9Method* method
	public PointerPointer methodEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9SWFrame._methodOffset_);
	}

	// U8* name
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nameOffset_", declaredType="U8*")
	public U8Pointer name() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9SWFrame._nameOffset_));
	}

	// U8* name
	public PointerPointer nameEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9SWFrame._nameOffset_);
	}

	// UDATA number
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_numberOffset_", declaredType="UDATA")
	public UDATA number() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(J9SWFrame._numberOffset_));
	}

	// UDATA number
	public UDATAPointer numberEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9SWFrame._numberOffset_);
	}

	// UDATA* pc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pcOffset_", declaredType="UDATA*")
	public UDATAPointer pc() throws CorruptDataException {
		return UDATAPointer.cast(getPointerAtOffset(J9SWFrame._pcOffset_));
	}

	// UDATA* pc
	public PointerPointer pcEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9SWFrame._pcOffset_);
	}

	// UDATA* topSlot
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_topSlotOffset_", declaredType="UDATA*")
	public UDATAPointer topSlot() throws CorruptDataException {
		return UDATAPointer.cast(getPointerAtOffset(J9SWFrame._topSlotOffset_));
	}

	// UDATA* topSlot
	public PointerPointer topSlotEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9SWFrame._topSlotOffset_);
	}

	// UDATA type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_typeOffset_", declaredType="UDATA")
	public UDATA type() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(J9SWFrame._typeOffset_));
	}

	// UDATA type
	public UDATAPointer typeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9SWFrame._typeOffset_);
	}

}
