/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9JImagePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9JImagePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9JImage.class)
public class J9JImagePointer extends StructurePointer {

	// NULL
	public static final J9JImagePointer NULL = new J9JImagePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9JImagePointer(long address) {
		super(address);
	}

	public static J9JImagePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9JImagePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9JImagePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new J9JImagePointer(address);
	}

	public J9JImagePointer add(long count) {
		return J9JImagePointer.cast(address + (J9JImage.SIZEOF * count));
	}

	public J9JImagePointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9JImagePointer addOffset(long offset) {
		return J9JImagePointer.cast(address + offset);
	}

	public J9JImagePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9JImagePointer sub(long count) {
		return J9JImagePointer.cast(address - (J9JImage.SIZEOF * count));
	}

	public J9JImagePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9JImagePointer subOffset(long offset) {
		return J9JImagePointer.cast(address - offset);
	}

	public J9JImagePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9JImagePointer untag(long mask) {
		return J9JImagePointer.cast(address & ~mask);
	}

	public J9JImagePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9JImage.SIZEOF;
	}

	// Implementation methods

	// IDATA fd
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fdOffset_", declaredType="IDATA")
	public IDATA fd() throws CorruptDataException {
		return new IDATA(getIDATAAtOffset(J9JImage._fdOffset_));
	}

	// IDATA fd
	public IDATAPointer fdEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return IDATAPointer.cast(address + J9JImage._fdOffset_);
	}

	// U64 fileLength
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fileLengthOffset_", declaredType="U64")
	public UDATA fileLength() throws CorruptDataException {
		return new U64(getLongAtOffset(J9JImage._fileLengthOffset_));
	}

	// U64 fileLength
	public UDATAPointer fileLengthEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9JImage._fileLengthOffset_);
	}

	// U8* fileName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fileNameOffset_", declaredType="U8*")
	public U8Pointer fileName() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9JImage._fileNameOffset_));
	}

	// U8* fileName
	public PointerPointer fileNameEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9JImage._fileNameOffset_);
	}

	// J9JImageHeader* j9jimageHeader
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_j9jimageHeaderOffset_", declaredType="J9JImageHeader*")
	public J9JImageHeaderPointer j9jimageHeader() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9JImage._j9jimageHeaderOffset_);
		return J9JImageHeaderPointer.cast(pointer);
	}

	// J9JImageHeader* j9jimageHeader
	public PointerPointer j9jimageHeaderEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9JImage._j9jimageHeaderOffset_);
	}

	// J9MmapHandle* jimageMmap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jimageMmapOffset_", declaredType="J9MmapHandle*")
	public J9MmapHandlePointer jimageMmap() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9JImage._jimageMmapOffset_);
		return J9MmapHandlePointer.cast(pointer);
	}

	// J9MmapHandle* jimageMmap
	public PointerPointer jimageMmapEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9JImage._jimageMmapOffset_);
	}

}
