/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9JImageHeaderPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9JImageHeaderPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9JImageHeader.class)
public class J9JImageHeaderPointer extends StructurePointer {

	// NULL
	public static final J9JImageHeaderPointer NULL = new J9JImageHeaderPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9JImageHeaderPointer(long address) {
		super(address);
	}

	public static J9JImageHeaderPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9JImageHeaderPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9JImageHeaderPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new J9JImageHeaderPointer(address);
	}

	public J9JImageHeaderPointer add(long count) {
		return J9JImageHeaderPointer.cast(address + (J9JImageHeader.SIZEOF * count));
	}

	public J9JImageHeaderPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9JImageHeaderPointer addOffset(long offset) {
		return J9JImageHeaderPointer.cast(address + offset);
	}

	public J9JImageHeaderPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9JImageHeaderPointer sub(long count) {
		return J9JImageHeaderPointer.cast(address - (J9JImageHeader.SIZEOF * count));
	}

	public J9JImageHeaderPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9JImageHeaderPointer subOffset(long offset) {
		return J9JImageHeaderPointer.cast(address - offset);
	}

	public J9JImageHeaderPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9JImageHeaderPointer untag(long mask) {
		return J9JImageHeaderPointer.cast(address & ~mask);
	}

	public J9JImageHeaderPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9JImageHeader.SIZEOF;
	}

	// Implementation methods

	// JImageHeader* jimageHeader
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jimageHeaderOffset_", declaredType="JImageHeader*")
	public JImageHeaderPointer jimageHeader() throws CorruptDataException {
		long pointer = getPointerAtOffset(J9JImageHeader._jimageHeaderOffset_);
		return JImageHeaderPointer.cast(pointer);
	}

	// JImageHeader* jimageHeader
	public PointerPointer jimageHeaderEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9JImageHeader._jimageHeaderOffset_);
	}

	// U8* locationsData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_locationsDataOffset_", declaredType="U8*")
	public U8Pointer locationsData() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9JImageHeader._locationsDataOffset_));
	}

	// U8* locationsData
	public PointerPointer locationsDataEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9JImageHeader._locationsDataOffset_);
	}

	// U32* locationsOffsetTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_locationsOffsetTableOffset_", declaredType="U32*")
	public UDATAPointer locationsOffsetTable() throws CorruptDataException {
		return U32Pointer.cast(getPointerAtOffset(J9JImageHeader._locationsOffsetTableOffset_));
	}

	// U32* locationsOffsetTable
	public PointerPointer locationsOffsetTableEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9JImageHeader._locationsOffsetTableOffset_);
	}

	// I32* redirectTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_redirectTableOffset_", declaredType="I32*")
	public IDATAPointer redirectTable() throws CorruptDataException {
		return I32Pointer.cast(getPointerAtOffset(J9JImageHeader._redirectTableOffset_));
	}

	// I32* redirectTable
	public PointerPointer redirectTableEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9JImageHeader._redirectTableOffset_);
	}

	// U64 resources
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_resourcesOffset_", declaredType="U64")
	public UDATA resources() throws CorruptDataException {
		return new U64(getLongAtOffset(J9JImageHeader._resourcesOffset_));
	}

	// U64 resources
	public UDATAPointer resourcesEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + J9JImageHeader._resourcesOffset_);
	}

	// U8* stringsData
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stringsDataOffset_", declaredType="U8*")
	public U8Pointer stringsData() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9JImageHeader._stringsDataOffset_));
	}

	// U8* stringsData
	public PointerPointer stringsDataEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9JImageHeader._stringsDataOffset_);
	}

}
