/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9HyperFunctionsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9HyperFunctionsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9HyperFunctions.class)
public class J9HyperFunctionsPointer extends StructurePointer {

	// NULL
	public static final J9HyperFunctionsPointer NULL = new J9HyperFunctionsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9HyperFunctionsPointer(long address) {
		super(address);
	}

	public static J9HyperFunctionsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9HyperFunctionsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9HyperFunctionsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new J9HyperFunctionsPointer(address);
	}

	public J9HyperFunctionsPointer add(long count) {
		return J9HyperFunctionsPointer.cast(address + (J9HyperFunctions.SIZEOF * count));
	}

	public J9HyperFunctionsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9HyperFunctionsPointer addOffset(long offset) {
		return J9HyperFunctionsPointer.cast(address + offset);
	}

	public J9HyperFunctionsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9HyperFunctionsPointer sub(long count) {
		return J9HyperFunctionsPointer.cast(address - (J9HyperFunctions.SIZEOF * count));
	}

	public J9HyperFunctionsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9HyperFunctionsPointer subOffset(long offset) {
		return J9HyperFunctionsPointer.cast(address - offset);
	}

	public J9HyperFunctionsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9HyperFunctionsPointer untag(long mask) {
		return J9HyperFunctionsPointer.cast(address & ~mask);
	}

	public J9HyperFunctionsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9HyperFunctions.SIZEOF;
	}

	// Implementation methods

	// void* get_guest_memory_usage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_get_guest_memory_usageOffset_", declaredType="void*")
	public VoidPointer get_guest_memory_usage() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9HyperFunctions._get_guest_memory_usageOffset_));
	}

	// void* get_guest_memory_usage
	public PointerPointer get_guest_memory_usageEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9HyperFunctions._get_guest_memory_usageOffset_);
	}

	// void* get_guest_processor_usage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_get_guest_processor_usageOffset_", declaredType="void*")
	public VoidPointer get_guest_processor_usage() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9HyperFunctions._get_guest_processor_usageOffset_));
	}

	// void* get_guest_processor_usage
	public PointerPointer get_guest_processor_usageEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9HyperFunctions._get_guest_processor_usageOffset_);
	}

	// void* hypervisor_impl_shutdown
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hypervisor_impl_shutdownOffset_", declaredType="void*")
	public VoidPointer hypervisor_impl_shutdown() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9HyperFunctions._hypervisor_impl_shutdownOffset_));
	}

	// void* hypervisor_impl_shutdown
	public PointerPointer hypervisor_impl_shutdownEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9HyperFunctions._hypervisor_impl_shutdownOffset_);
	}

}
