/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9CfrTypeAnnotationPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9CfrTypeAnnotationPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9CfrTypeAnnotation.class)
public class J9CfrTypeAnnotationPointer extends StructurePointer {

	// NULL
	public static final J9CfrTypeAnnotationPointer NULL = new J9CfrTypeAnnotationPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9CfrTypeAnnotationPointer(long address) {
		super(address);
	}

	public static J9CfrTypeAnnotationPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9CfrTypeAnnotationPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9CfrTypeAnnotationPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new J9CfrTypeAnnotationPointer(address);
	}

	public J9CfrTypeAnnotationPointer add(long count) {
		return J9CfrTypeAnnotationPointer.cast(address + (J9CfrTypeAnnotation.SIZEOF * count));
	}

	public J9CfrTypeAnnotationPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9CfrTypeAnnotationPointer addOffset(long offset) {
		return J9CfrTypeAnnotationPointer.cast(address + offset);
	}

	public J9CfrTypeAnnotationPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9CfrTypeAnnotationPointer sub(long count) {
		return J9CfrTypeAnnotationPointer.cast(address - (J9CfrTypeAnnotation.SIZEOF * count));
	}

	public J9CfrTypeAnnotationPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9CfrTypeAnnotationPointer subOffset(long offset) {
		return J9CfrTypeAnnotationPointer.cast(address - offset);
	}

	public J9CfrTypeAnnotationPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9CfrTypeAnnotationPointer untag(long mask) {
		return J9CfrTypeAnnotationPointer.cast(address & ~mask);
	}

	public J9CfrTypeAnnotationPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9CfrTypeAnnotation.SIZEOF;
	}

	// Implementation methods

	// J9CfrAnnotation annotation
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_annotationOffset_", declaredType="J9CfrAnnotation")
	public J9CfrAnnotationPointer annotation() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return J9CfrAnnotationPointer.cast(address + J9CfrTypeAnnotation._annotationOffset_);
	}

	// J9CfrAnnotation annotation
	public PointerPointer annotationEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9CfrTypeAnnotation._annotationOffset_);
	}

	// J9CfrTypeAnnotationTargetInfo targetInfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_targetInfoOffset_", declaredType="J9CfrTypeAnnotationTargetInfo")
	public J9CfrTypeAnnotationTargetInfoPointer targetInfo() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return J9CfrTypeAnnotationTargetInfoPointer.cast(address + J9CfrTypeAnnotation._targetInfoOffset_);
	}

	// J9CfrTypeAnnotationTargetInfo targetInfo
	public PointerPointer targetInfoEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9CfrTypeAnnotation._targetInfoOffset_);
	}

	// U8 targetType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_targetTypeOffset_", declaredType="U8")
	public U8 targetType() throws CorruptDataException {
		return new U8(getByteAtOffset(J9CfrTypeAnnotation._targetTypeOffset_));
	}

	// U8 targetType
	public U8Pointer targetTypeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return U8Pointer.cast(address + J9CfrTypeAnnotation._targetTypeOffset_);
	}

	// J9CfrTypePath typePath
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_typePathOffset_", declaredType="J9CfrTypePath")
	public J9CfrTypePathPointer typePath() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return J9CfrTypePathPointer.cast(address + J9CfrTypeAnnotation._typePathOffset_);
	}

	// J9CfrTypePath typePath
	public PointerPointer typePathEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + J9CfrTypeAnnotation._typePathOffset_);
	}

}
