/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: GC_HashTableIteratorPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the GC_HashTableIteratorPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=GC_HashTableIterator.class)
public class GC_HashTableIteratorPointer extends StructurePointer {

	// NULL
	public static final GC_HashTableIteratorPointer NULL = new GC_HashTableIteratorPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected GC_HashTableIteratorPointer(long address) {
		super(address);
	}

	public static GC_HashTableIteratorPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static GC_HashTableIteratorPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static GC_HashTableIteratorPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new GC_HashTableIteratorPointer(address);
	}

	public GC_HashTableIteratorPointer add(long count) {
		return GC_HashTableIteratorPointer.cast(address + (GC_HashTableIterator.SIZEOF * count));
	}

	public GC_HashTableIteratorPointer add(Scalar count) {
		return add(count.longValue());
	}

	public GC_HashTableIteratorPointer addOffset(long offset) {
		return GC_HashTableIteratorPointer.cast(address + offset);
	}

	public GC_HashTableIteratorPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public GC_HashTableIteratorPointer sub(long count) {
		return GC_HashTableIteratorPointer.cast(address - (GC_HashTableIterator.SIZEOF * count));
	}

	public GC_HashTableIteratorPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public GC_HashTableIteratorPointer subOffset(long offset) {
		return GC_HashTableIteratorPointer.cast(address - offset);
	}

	public GC_HashTableIteratorPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public GC_HashTableIteratorPointer untag(long mask) {
		return GC_HashTableIteratorPointer.cast(address & ~mask);
	}

	public GC_HashTableIteratorPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return GC_HashTableIterator.SIZEOF;
	}

	// Implementation methods

	// bool _firstIteration
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__firstIterationOffset_", declaredType="bool")
	public boolean _firstIteration() throws CorruptDataException {
		return getBoolAtOffset(GC_HashTableIterator.__firstIterationOffset_);
	}

	// bool _firstIteration
	public BoolPointer _firstIterationEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return BoolPointer.cast(address + GC_HashTableIterator.__firstIterationOffset_);
	}

	// J9HashTableState _handle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__handleOffset_", declaredType="J9HashTableState")
	public J9HashTableStatePointer _handle() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return J9HashTableStatePointer.cast(address + GC_HashTableIterator.__handleOffset_);
	}

	// J9HashTableState _handle
	public PointerPointer _handleEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + GC_HashTableIterator.__handleOffset_);
	}

	// J9HashTable* _hashTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__hashTableOffset_", declaredType="J9HashTable*")
	public J9HashTablePointer _hashTable() throws CorruptDataException {
		long pointer = getPointerAtOffset(GC_HashTableIterator.__hashTableOffset_);
		return J9HashTablePointer.cast(pointer);
	}

	// J9HashTable* _hashTable
	public PointerPointer _hashTableEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + GC_HashTableIterator.__hashTableOffset_);
	}

	// void** _vptr$GC_HashTableIterator
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__vptr$GC_HashTableIteratorOffset_", declaredType="void**")
	public PointerPointer _vptr$GC_HashTableIterator() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(GC_HashTableIterator.__vptr$GC_HashTableIteratorOffset_));
	}

	// void** _vptr$GC_HashTableIterator
	public PointerPointer _vptr$GC_HashTableIteratorEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + GC_HashTableIterator.__vptr$GC_HashTableIteratorOffset_);
	}

}
