/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: GCStatusPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the GCStatusPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=GCStatus.class)
public class GCStatusPointer extends StructurePointer {

	// NULL
	public static final GCStatusPointer NULL = new GCStatusPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected GCStatusPointer(long address) {
		super(address);
	}

	public static GCStatusPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static GCStatusPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static GCStatusPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new GCStatusPointer(address);
	}

	public GCStatusPointer add(long count) {
		return GCStatusPointer.cast(address + (GCStatus.SIZEOF * count));
	}

	public GCStatusPointer add(Scalar count) {
		return add(count.longValue());
	}

	public GCStatusPointer addOffset(long offset) {
		return GCStatusPointer.cast(address + offset);
	}

	public GCStatusPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public GCStatusPointer sub(long count) {
		return GCStatusPointer.cast(address - (GCStatus.SIZEOF * count));
	}

	public GCStatusPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public GCStatusPointer subOffset(long offset) {
		return GCStatusPointer.cast(address - offset);
	}

	public GCStatusPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public GCStatusPointer untag(long mask) {
		return GCStatusPointer.cast(address & ~mask);
	}

	public GCStatusPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return GCStatus.SIZEOF;
	}

	// Implementation methods

	// jint count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_countOffset_", declaredType="jint")
	public IDATA count() throws CorruptDataException {
		return new I32(getIntAtOffset(GCStatus._countOffset_));
	}

	// jint count
	public IDATAPointer countEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return IDATAPointer.cast(address + GCStatus._countOffset_);
	}

	// jlong freestorage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_freestorageOffset_", declaredType="jlong")
	public IDATA freestorage() throws CorruptDataException {
		return new I64(getLongAtOffset(GCStatus._freestorageOffset_));
	}

	// jlong freestorage
	public IDATAPointer freestorageEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return IDATAPointer.cast(address + GCStatus._freestorageOffset_);
	}

	// jint heap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_heapOffset_", declaredType="jint")
	public IDATA heap() throws CorruptDataException {
		return new I32(getIntAtOffset(GCStatus._heapOffset_));
	}

	// jint heap
	public IDATAPointer heapEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return IDATAPointer.cast(address + GCStatus._heapOffset_);
	}

	// jlong totalstorage
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_totalstorageOffset_", declaredType="jlong")
	public IDATA totalstorage() throws CorruptDataException {
		return new I64(getLongAtOffset(GCStatus._totalstorageOffset_));
	}

	// jlong totalstorage
	public IDATAPointer totalstorageEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return IDATAPointer.cast(address + GCStatus._totalstorageOffset_);
	}

}
