/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: BufferManagerPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the BufferManagerPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=BufferManager.class)
public class BufferManagerPointer extends StructurePointer {

	// NULL
	public static final BufferManagerPointer NULL = new BufferManagerPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected BufferManagerPointer(long address) {
		super(address);
	}

	public static BufferManagerPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static BufferManagerPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static BufferManagerPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new BufferManagerPointer(address);
	}

	public BufferManagerPointer add(long count) {
		return BufferManagerPointer.cast(address + (BufferManager.SIZEOF * count));
	}

	public BufferManagerPointer add(Scalar count) {
		return add(count.longValue());
	}

	public BufferManagerPointer addOffset(long offset) {
		return BufferManagerPointer.cast(address + offset);
	}

	public BufferManagerPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public BufferManagerPointer sub(long count) {
		return BufferManagerPointer.cast(address - (BufferManager.SIZEOF * count));
	}

	public BufferManagerPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public BufferManagerPointer subOffset(long offset) {
		return BufferManagerPointer.cast(address - offset);
	}

	public BufferManagerPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public BufferManagerPointer untag(long mask) {
		return BufferManagerPointer.cast(address & ~mask);
	}

	public BufferManagerPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return BufferManager.SIZEOF;
	}

	// Implementation methods

	// void** _buffer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bufferOffset_", declaredType="void**")
	public PointerPointer _buffer() throws CorruptDataException {
		return PointerPointer.cast(getPointerAtOffset(BufferManager.__bufferOffset_));
	}

	// void** _buffer
	public PointerPointer _bufferEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + BufferManager.__bufferOffset_);
	}

	// UDATA _bufferSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bufferSizeOffset_", declaredType="UDATA")
	public UDATA _bufferSize() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(BufferManager.__bufferSizeOffset_));
	}

	// UDATA _bufferSize
	public UDATAPointer _bufferSizeEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + BufferManager.__bufferSizeOffset_);
	}

	// void* _lastAllocation
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__lastAllocationOffset_", declaredType="void*")
	public VoidPointer _lastAllocation() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(BufferManager.__lastAllocationOffset_));
	}

	// void* _lastAllocation
	public PointerPointer _lastAllocationEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + BufferManager.__lastAllocationOffset_);
	}

	// J9PortLibrary* _portLibrary
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__portLibraryOffset_", declaredType="J9PortLibrary*")
	public J9PortLibraryPointer _portLibrary() throws CorruptDataException {
		long pointer = getPointerAtOffset(BufferManager.__portLibraryOffset_);
		return J9PortLibraryPointer.cast(pointer);
	}

	// J9PortLibrary* _portLibrary
	public PointerPointer _portLibraryEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + BufferManager.__portLibraryOffset_);
	}

	// UDATA _pos
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__posOffset_", declaredType="UDATA")
	public UDATA _pos() throws CorruptDataException {
		return new UDATA(getUDATAAtOffset(BufferManager.__posOffset_));
	}

	// UDATA _pos
	public UDATAPointer _posEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + BufferManager.__posOffset_);
	}

	// bool _shouldFreeBuffer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__shouldFreeBufferOffset_", declaredType="bool")
	public boolean _shouldFreeBuffer() throws CorruptDataException {
		return getBoolAtOffset(BufferManager.__shouldFreeBufferOffset_);
	}

	// bool _shouldFreeBuffer
	public BoolPointer _shouldFreeBufferEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return BoolPointer.cast(address + BufferManager.__shouldFreeBufferOffset_);
	}

}
