/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PackagePointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ModularityHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class DumpModuleCommand
extends Command {
    public DumpModuleCommand() {
        this.addCommand("dumpmodule", "[all|requires|exports|classes|packages] <moduleAddress>|help", "List details about a module");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        ModularityHelper.ClassIteratorFilter classFilter = null;
        ModularityHelper.ClassOutput classOutput = null;
        ModularityHelper.ModuleIteratorFilter moduleFilter = null;
        ModularityHelper.ModuleOutput moduleOutputter = null;
        ModularityHelper.PackageIteratorFilter packageFilter = null;
        ModularityHelper.PackageOutput packageOutputter = null;
        String filterArg = null;
        Subcommand subcommand = switch (args.length) {
            case 1 -> {
                switch (args[0]) {
                    case "help": {
                        yield Subcommand.HELP;
                    }
                }
                filterArg = args[0];
                yield Subcommand.ALL;
            }
            case 2 -> {
                filterArg = args[1];
                switch (args[0]) {
                    case "all": {
                        yield Subcommand.ALL;
                    }
                    case "requires": {
                        moduleFilter = DumpModuleCommand::filterModuleRequired;
                        moduleOutputter = ModularityHelper::printJ9Module;
                        yield Subcommand.MODULE;
                    }
                    case "exports": {
                        packageFilter = DumpModuleCommand::filterPackageModuleAndExport;
                        packageOutputter = ModularityHelper::printPackageExportVerbose;
                        yield Subcommand.PACKAGE;
                    }
                    case "classes": {
                        classFilter = DumpModuleCommand::filterClassByModule;
                        classOutput = ModularityHelper::printJ9Class;
                        yield Subcommand.CLASS;
                    }
                    case "packages": {
                        packageFilter = DumpModuleCommand::filterPackageModule;
                        packageOutputter = ModularityHelper::printJ9Package;
                        yield Subcommand.PACKAGE;
                    }
                }
                yield Subcommand.INVALID;
            }
            default -> Subcommand.INVALID;
        };
        try {
            J9ModulePointer modulePtr = null;
            J9ClassLoaderPointer classLoaderPtr = null;
            if (null != filterArg) {
                try {
                    modulePtr = J9ModulePointer.cast(Long.decode(filterArg));
                    classLoaderPtr = modulePtr.classLoader();
                }
                catch (NumberFormatException e) {
                    throw new DDRInteractiveCommandException("The argument \"" + filterArg + "\" is not a valid number. It should be the address of a J9Module.");
                }
                catch (NullPointerException e) {
                    throw new DDRInteractiveCommandException("The argument \"" + filterArg + "\" is not the address of a valid J9Module.");
                }
                catch (MemoryFault e) {
                    System.out.println(e.getMessage());
                    throw new DDRInteractiveCommandException("The argument \"" + filterArg + "\" is not the address of a valid J9Module.");
                }
            }
            switch (subcommand) {
                case CLASS: {
                    int result = ModularityHelper.iterateClassLoaderClasses(out, classFilter, classOutput, filterArg, classLoaderPtr);
                    System.out.printf("Found %d class%s%n", result, 1 == result ? "" : "es");
                    break;
                }
                case MODULE: {
                    int result = ModularityHelper.iterateModules(out, moduleFilter, moduleOutputter, filterArg);
                    System.out.printf("Found %d module%s%n", result, 1 == result ? "" : "s");
                    break;
                }
                case PACKAGE: {
                    int result = ModularityHelper.iterateClassLoaderPackages(out, packageFilter, packageOutputter, filterArg, classLoaderPtr);
                    System.out.printf("Found %d package%s%n", result, 1 == result ? "" : "s");
                    break;
                }
                case ALL: {
                    out.println("Module:");
                    ModularityHelper.printJ9Module(modulePtr, out);
                    out.println("Requires:");
                    moduleFilter = DumpModuleCommand::filterModuleRequired;
                    moduleOutputter = ModularityHelper::printJ9Module;
                    int result = ModularityHelper.iterateModules(out, moduleFilter, moduleOutputter, filterArg);
                    System.out.printf("Found %d required module%s%n", result, 1 == result ? "" : "s");
                    out.println("Exports:");
                    packageFilter = DumpModuleCommand::filterPackageModuleAndExport;
                    packageOutputter = ModularityHelper::printPackageExportVerbose;
                    result = ModularityHelper.iteratePackages(out, packageFilter, packageOutputter, filterArg);
                    System.out.printf("Found %d exported package%s%n", result, 1 == result ? "" : "s");
                    break;
                }
                case HELP: {
                    DumpModuleCommand.printHelp(out);
                    break;
                }
                default: {
                    out.println("Argument failed to parse or was parsed to an unhandled subcommand.");
                    DumpModuleCommand.printHelp(out);
                    break;
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private static boolean filterClassByModule(J9ClassPointer classPtr, String targetModuleAddress) throws CorruptDataException {
        String moduleAddress = classPtr.module().getHexAddress();
        return targetModuleAddress.equalsIgnoreCase(moduleAddress);
    }

    private static boolean filterModuleRequired(J9ModulePointer modulePtr, String targetModuleAddress) throws CorruptDataException {
        boolean result = false;
        J9HashTablePointer readTable = modulePtr.readAccessHashTable();
        HashTable<J9ModulePointer> readModuleHashTable = ModuleHashTable.fromJ9HashTable(readTable);
        Iterator readSlotIterator = readModuleHashTable.iterator();
        while (readSlotIterator.hasNext()) {
            J9ModulePointer readModulePtr = (J9ModulePointer)readSlotIterator.next();
            String readHexAddress = readModulePtr.getHexAddress();
            if (!targetModuleAddress.equals(readHexAddress)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean filterPackageExported(J9PackagePointer packagePtr, String arg) throws CorruptDataException {
        boolean result = false;
        if (packagePtr.exportToAll().isZero() && packagePtr.exportToAllUnnamed().isZero()) {
            J9HashTablePointer exportsHashTable = packagePtr.exportsHashTable();
            HashTable<J9ModulePointer> exportsModuleHashTable = ModuleHashTable.fromJ9HashTable(exportsHashTable);
            Iterator exportsSlotIterator = exportsModuleHashTable.iterator();
            if (exportsSlotIterator.hasNext()) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static boolean filterPackageModule(J9PackagePointer packagePtr, String targetModuleAddress) throws CorruptDataException {
        return packagePtr.module().getHexAddress().equals(targetModuleAddress);
    }

    private static boolean filterPackageModuleAndExport(J9PackagePointer packagePtr, String targetModuleAddress) throws CorruptDataException {
        return DumpModuleCommand.filterPackageModule(packagePtr, targetModuleAddress) && DumpModuleCommand.filterPackageExported(packagePtr, targetModuleAddress);
    }

    private static void printHelp(PrintStream out) {
        out.println("Usage:");
        out.println("  !dumpmodule <moduleAddress>");
        out.println("      Lists !dumpmodule all <moduleAddress>");
        out.println("  !dumpmodule all <moduleAddress>");
        out.println("      Lists the requires and exports of the target module");
        out.println("  !dumpmodule requires <moduleAddress>");
        out.println("      Lists all modules required by the target module");
        out.println("  !dumpmodule exports <moduleAddress>");
        out.println("      Lists all packages exported by the target module");
        out.println("  !dumpmodule classes <moduleAddress>");
        out.println("      Lists all loaded classes in the target module");
        out.println("  !dumpmodule packages <moduleAddress>");
        out.println("      Lists all packages in the target module");
    }

    static enum Subcommand {
        CLASS,
        MODULE,
        PACKAGE,
        ALL,
        HELP,
        INVALID;

    }
}

