/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.FlagStructureList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.stream.FileImageInputStream;

public final class ClassGenerator {
    private boolean badOptions = false;
    private String blobFile = null;
    private boolean helpRequested = false;
    private File outDir = null;
    private boolean verbose = false;

    private static void duplicateOption(String option) {
        System.out.printf("Duplicate option: %s.%n", option);
    }

    public static void main(String ... args) {
        ClassGenerator generator = new ClassGenerator();
        generator.configure(args);
        generator.run();
    }

    private static StructureReader readBlob(String fileName) throws IOException {
        try (FileImageInputStream image = new FileImageInputStream(new RandomAccessFile(fileName, "r")){};){
            StructureReader structureReader = new StructureReader(image);
            return structureReader;
        }
    }

    private ClassGenerator() {
    }

    private void configure(String[] args) {
        Pattern blobOption = Pattern.compile("--blob=(.+)");
        Pattern outDirOption = Pattern.compile("--out=(.+)");
        for (String arg : args) {
            String fileName;
            Matcher matcher = blobOption.matcher(arg);
            if (matcher.matches()) {
                fileName = matcher.group(1);
                if (this.blobFile == null) {
                    this.blobFile = fileName;
                    continue;
                }
                ClassGenerator.duplicateOption(fileName);
                this.badOptions = true;
                continue;
            }
            if ("--debug".equals(arg)) {
                this.verbose = true;
                continue;
            }
            if ("--help".equals(arg)) {
                this.helpRequested = true;
                continue;
            }
            matcher = outDirOption.matcher(arg);
            if (matcher.matches()) {
                fileName = matcher.group(1);
                if (this.outDir == null) {
                    this.outDir = new File(fileName);
                    continue;
                }
                ClassGenerator.duplicateOption(fileName);
                this.badOptions = true;
                continue;
            }
            System.out.printf("Invalid option: %s.%n", arg);
            this.badOptions = true;
        }
    }

    private void run() {
        if (this.badOptions || this.helpRequested || this.blobFile == null || this.outDir == null) {
            System.out.printf("Usage: java %s [options]%n", this.getClass().getName());
            System.out.printf("  options:%n", new Object[0]);
            System.out.printf("    --blob=<blob file>%n", new Object[0]);
            System.out.printf("    --debug%n", new Object[0]);
            System.out.printf("    --help%n", new Object[0]);
            System.out.printf("    --out=<output directory>%n", new Object[0]);
        } else {
            try {
                StructureReader reader = ClassGenerator.readBlob(this.blobFile);
                this.writeTo(reader, this.outDir);
            }
            catch (IOException e) {
                System.out.printf("Can't read blob: %s%n", e.getLocalizedMessage());
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(byte[] bytes, File directory, String name) throws IOException {
        File file = new File(directory, name + ".class");
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write(bytes);
            if (this.verbose) {
                System.out.printf("Wrote: %s%n", file.getPath());
            }
        }
    }

    private void writeTo(StructureReader reader, File rootDir) {
        File pointerDir = new File(rootDir, reader.getPackageName(StructureReader.PackageNameType.POINTER_PACKAGE_SLASH_NAME));
        File structureDir = new File(rootDir, reader.getPackageName(StructureReader.PackageNameType.STRUCTURE_PACKAGE_SLASH_NAME));
        pointerDir.mkdirs();
        structureDir.mkdirs();
        for (StructureReader.StructureDescriptor structure : reader.getStructures()) {
            String name = structure.getName();
            try {
                byte[] bytes;
                if (FlagStructureList.isFlagsStructure(name)) {
                    bytes = reader.getPointerClassBytes(name);
                    this.save(bytes, pointerDir, name);
                    continue;
                }
                bytes = reader.getStructureClassBytes(name);
                this.save(bytes, structureDir, name);
                name = structure.getPointerName();
                bytes = reader.getPointerClassBytes(name);
                this.save(bytes, pointerDir, name);
            }
            catch (ClassNotFoundException e) {
                System.out.printf("Can't generate %s: %s%n", name, e.getLocalizedMessage());
                System.exit(2);
            }
            catch (IOException e) {
                System.out.printf("Can't save %s: %s%n", name, e.getLocalizedMessage());
                System.exit(3);
            }
        }
    }
}

