/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.le;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa32_11Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa64_11Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CaaNotFound;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CaaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeedsaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeelcaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexdsaf;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexhcom32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexlaaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexsancTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexstkhTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeextvbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Edb;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.SmcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Ihartm2aTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhastcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Lse;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.RegisterSet;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Tcb;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ProgressMeter;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Caa {
    private long address;
    private Tcb tcb;
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private Edb edb;
    private DsaStackFrame currentFrame;
    private int stackdirection;
    private CaaTemplate caaTemplate;
    private long laa;
    private boolean is64bit;
    private static int hcomLength = new Ceexhcom32Template().length();
    private String whereFound;
    private RegisterSet failingRegisters;
    private RegisterSet registers;
    static final int CEECAASTACK_UP = 0;
    static final int CEECAASTACK_DOWN = 1;
    private static final int WARNING = 4;
    private static final int ERROR = 8;
    private static final long F1SA = -420355391L;
    private static final long F4SA = -420158783L;
    private static final long F5SA = -420093247L;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");
    private static int whereSkip = 0;

    public static Caa[] getCaas(AddressSpace space) {
        return Caa.getCaas(space, null);
    }

    public static Caa[] getCaas(AddressSpace space, Edb edb) {
        Tcb[] tcbs = Tcb.getTcbs(space);
        if (tcbs == null) {
            log.fine("no tcbs found in address space " + space);
            return new Caa[0];
        }
        log.fine("found " + tcbs.length + " tcbs for address space " + space);
        Vector<Caa> v = new Vector<Caa>();
        for (int i = 0; i < tcbs.length; ++i) {
            ProgressMeter.set("getting caas", i * 100 / tcbs.length);
            try {
                Caa caa = new Caa(tcbs[i]);
                if (edb != null && !caa.getEdb().equals(edb)) continue;
                v.add(caa);
                continue;
            }
            catch (CaaNotFound caaNotFound) {
                // empty catch block
            }
        }
        return v.toArray(new Caa[0]);
    }

    public Caa(Tcb tcb) throws CaaNotFound {
        log.finer("creating Caa for Tcb at address " + Caa.hex(tcb.address()));
        this.tcb = tcb;
        this.space = tcb.space();
        this.inputStream = this.space.getImageInputStream();
        if (this.is32bitCaa()) {
            int release;
            this.caaTemplate = new Caa32Template();
            String s = this.space.getDump().getProductRelease();
            if (s != null && (release = Integer.parseInt(s)) >= 11) {
                this.caaTemplate = new Caa32_11Template();
                log.fine("switched to new caa format");
            }
            log.fine("created 32-bit Caa " + Caa.hex(this.address) + " for Tcb at address " + Caa.hex(tcb.address()));
        } else if (this.is64bitCaa()) {
            int release;
            this.is64bit = true;
            this.space.setIs64bit(true);
            this.caaTemplate = new Caa64Template();
            String s = this.space.getDump().getProductRelease();
            if (s != null && (release = Integer.parseInt(s)) >= 11) {
                this.caaTemplate = new Caa64_11Template();
                log.fine("switched to new caa format");
            }
            log.fine("created 64-bit Caa " + Caa.hex(this.address) + " for Tcb at address " + Caa.hex(tcb.address()));
        } else if (this.is32bitCaaLastDitch()) {
            int release;
            this.caaTemplate = new Caa32Template();
            String s = this.space.getDump().getProductRelease();
            if (s != null && (release = Integer.parseInt(s)) >= 11) {
                this.caaTemplate = new Caa32_11Template();
                log.fine("switched to new caa format");
            }
            log.fine("created 32-bit Caa " + Caa.hex(this.address) + " for Tcb at address " + Caa.hex(tcb.address()) + " (last ditch)");
        } else {
            throw new CaaNotFound();
        }
    }

    private boolean is32bitCaa() {
        try {
            long celap = this.tcb.tcbcelap();
            log.finer("celap = 0x" + Caa.hex(celap));
            int celap0 = this.space.readInt(celap);
            log.finer("celap0 = 0x" + Caa.hex(celap0));
            if (celap0 == 0) {
                return false;
            }
            this.address = this.space.readInt(celap0 + 32);
            int xxx = this.space.readInt(celap0 + 8);
            log.finer("caa address = " + Caa.hex(this.address));
            return this.validate();
        }
        catch (IOException e) {
            log.finer("caught exception: " + e);
            return false;
        }
    }

    private boolean is64bitCaa() {
        try {
            long stcb = this.tcb.tcbstcb();
            log.finer("stcb = 0x" + Caa.hex(stcb));
            this.laa = IhastcbTemplate.getStcblaa(this.inputStream, stcb);
            log.finer("laa = 0x" + Caa.hex(this.laa));
            long lca = CeexlaaTemplate.getCeelaa_lca64(this.inputStream, this.laa);
            log.finer("lca = 0x" + Caa.hex(lca));
            this.address = CeelcaTemplate.getCeelca_caa(this.inputStream, lca);
            log.finer("caa address = " + Caa.hex(this.address));
            return this.validate();
        }
        catch (IOException e) {
            log.finer("caught exception: " + e);
            return false;
        }
    }

    private boolean is32bitCaaLastDitch() {
        try {
            this.address = this.space.readInt(this.tcb.address() + 96L);
            log.finer("tcb caa address = " + Caa.hex(this.address));
            if (this.address == 0L) {
                throw new IOException("oh");
            }
            return this.validate();
        }
        catch (IOException e) {
            log.finer("caught exception: " + e);
            return false;
        }
    }

    public boolean is64bit() {
        return this.is64bit;
    }

    public String whereFound() {
        return this.whereFound;
    }

    public RegisterSet getFailingRegisters() {
        this.getCurrentFrame();
        return this.failingRegisters;
    }

    public RegisterSet getRegisters() {
        this.getCurrentFrame();
        return this.registers;
    }

    private boolean validate() {
        try {
            int eye1 = this.space.readInt(this.address - 24L);
            int eye2 = this.space.readInt(this.address - 20L) & 0xFFFF0000;
            if (eye1 == -1010448957 && eye2 == -1044316160) {
                log.fine("found valid caa at " + Caa.hex(this.address));
                return true;
            }
        }
        catch (IOException e) {
            log.finer("caught exception: " + e);
        }
        return false;
    }

    public DsaStackFrame getCurrentFrame() {
        if (this.currentFrame == null) {
            log.finer("about to get top dsa for caa " + Caa.hex(this.address));
            Cel4rreg cel = new Cel4rreg();
            assert (cel.p_dsafmt != -1);
            RegisterSet regs = cel.regs;
            boolean isDownStack = cel.p_dsafmt == 1;
            long dsa = cel.p_dsaptr;
            if (dsa == 0L) {
                log.finer("dsa is zero for caa " + Caa.hex(this.address));
                return null;
            }
            try {
                this.currentFrame = new DsaStackFrame(dsa, isDownStack, regs, this.space, this);
            }
            catch (IOException e) {
                log.finer("exception getting top dsa: " + e);
            }
        }
        return this.currentFrame;
    }

    public long getPthreadId() throws IOException {
        return this.caaTemplate.getCeecaathdid(this.inputStream, this.address);
    }

    public boolean hasFailed() {
        throw new Error("tbc");
    }

    public RegisterSet getRegisterSet() {
        throw new Error("tbc");
    }

    public Edb getEdb() {
        if (this.edb == null) {
            try {
                Long edbkey = this.ceecaaedb();
                this.edb = (Edb)this.space.getUserMap().get(edbkey);
                if (this.edb == null) {
                    this.edb = new Edb(this.ceecaaedb(), this.space, this.is64bit);
                    this.space.getUserMap().put(edbkey, this.edb);
                }
            }
            catch (Exception e) {
                log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa", "getEdb", "Unexepected exception", e);
                throw new Error("Unexpected Exception: " + e);
            }
        }
        return this.edb;
    }

    public long address() {
        return this.address;
    }

    public AddressSpace space() {
        return this.space;
    }

    public Tcb getTcb() {
        return this.tcb;
    }

    public int ceecaalevel() throws IOException {
        return (int)this.caaTemplate.getCeecaalevel(this.inputStream, this.address);
    }

    public int ceecaa_stackdirection() throws IOException {
        if (this.ceecaalevel() < 13) {
            throw new Error("ceecaa_stackdirection is not available in this level of LE! " + this.ceecaalevel());
        }
        return (int)this.caaTemplate.getCeecaa_stackdirection(this.inputStream, this.address);
    }

    public long ceecaasmcb() throws IOException {
        if (this.caaTemplate instanceof Caa32Template) {
            return ((Caa32Template)this.caaTemplate).getCeecaasmcb(this.inputStream, this.address);
        }
        return ((Caa64Template)this.caaTemplate).getCeecaasmcb(this.inputStream, this.address);
    }

    public long ceecaarcb() throws IOException {
        return this.caaTemplate.getCeecaarcb(this.inputStream, this.address);
    }

    public long ceecaa_stackfloor() throws IOException {
        throw new Error("tbc");
    }

    public long ceecaavba() throws IOException {
        return this.caaTemplate.getCeecaavba(this.inputStream, this.address);
    }

    public long ceecaatcs() throws IOException {
        return this.caaTemplate.getCeecaatcs(this.inputStream, this.address);
    }

    public long pthread_getspecific_d8_np(long key) throws IOException {
        long ceecaavba = this.ceecaavba();
        if (ceecaavba == 0L) {
            log.finer("ceecaavba is zero in caa " + Caa.hex(this.address));
            return 0L;
        }
        long eyecatcher = 0L;
        try {
            eyecatcher = this.space.readInt(ceecaavba);
        }
        catch (IOException e) {
            log.fine("bad ceecaavba: " + Caa.hex(ceecaavba));
            return 0L;
        }
        if (eyecatcher == -471481792L) {
            long ceeedbdba = this.getEdb().ceeedbdba();
            log.finer("ceeedbdba = " + Caa.hex(ceeedbdba));
            assert (this.space.readInt(ceeedbdba) == -758857152);
            long ceekdb_bptr = this.space.readWord(ceeedbdba + 8L, this.is64bit);
            long keyIndex = (key - ceekdb_bptr) / 16L;
            int bucketNumber = (int)keyIndex / 32;
            int bucketIndex = (int)keyIndex % 32;
            log.fine("keyIndex = " + keyIndex + " bucketNumber = " + bucketNumber + " bucketIndex = " + bucketIndex);
            if (bucketNumber < 0 || bucketNumber > 31) {
                return 0L;
            }
            assert (bucketNumber < 32);
            int bucketLength = this.is64bit ? 8 : 4;
            long bucket = this.space.readWord(ceecaavba + (long)bucketLength + (long)(bucketNumber * bucketLength), this.is64bit);
            if (bucket == 0L) {
                return 0L;
            }
            log.finer("bucket = " + Caa.hex(bucket));
            long value = this.space.readWord(bucket + (long)bucketLength + (long)(bucketIndex * bucketLength), this.is64bit);
            log.finer("value = " + Caa.hex(value));
            return value;
        }
        long ceetvbcount = CeextvbTemplate.getCeetvbcount(this.inputStream, ceecaavba);
        log.finer("eye = " + Caa.hex(this.space.readInt(ceecaavba)));
        long ceetvbe = ceecaavba + (long)(this.is64bit ? 16 : 12);
        int i = 0;
        while ((long)i < ceetvbcount) {
            long ceetvbekey = this.space.readWord(ceetvbe);
            log.finer("key = " + Caa.hex(key) + " ceetvbekey = " + Caa.hex(ceetvbekey));
            if (key == ceetvbekey) {
                return this.space.readWord(ceetvbe + (long)(this.is64bit ? 8 : 4));
            }
            ceetvbe += (long)(this.is64bit ? 16 : 8);
            ++i;
        }
        return 0L;
    }

    public long ceecaaddsa() {
        try {
            return this.caaTemplate.getCeecaaddsa(this.inputStream, this.address);
        }
        catch (IOException e) {
            throw new Error("oops");
        }
    }

    public long ceecaaedb() throws IOException {
        return this.caaTemplate.getCeecaaedb(this.inputStream, this.address);
    }

    public long ceecaaerrcm() throws IOException {
        return this.caaTemplate.getCeecaaerrcm(this.inputStream, this.address);
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    public String toString() {
        return Caa.hex(this.address);
    }

    static {
        String s = System.getProperty("zebedee.where.skip");
        if (s != null) {
            whereSkip = Integer.parseInt(s);
        }
    }

    class Cel4rreg {
        long seghigh;
        long seglow;
        int p_dsafmt = -1;
        long p_dsaptr;
        RegisterSet regs;

        Cel4rreg() {
            String useSvcdump = System.getProperty("zebedee.use.svcdump");
            if (useSvcdump != null && useSvcdump.equals("true")) {
                this.getRegistersFromSvcdump();
                return;
            }
            int whereCount = 0;
            try {
                this.regs = this.getRegistersFromRTM2();
                if (this.regs != null && whereCount++ >= whereSkip) {
                    Caa.this.whereFound = "RTM2";
                    Caa.this.failingRegisters = this.regs;
                    Caa.this.registers = this.regs;
                    return;
                }
            }
            catch (IOException e) {
                throw new Error("oops: " + e);
            }
            try {
                this.regs = this.getRegistersFromBPXGMSTA();
                if (this.regs != null && whereCount++ >= whereSkip) {
                    Caa.this.whereFound = this.regs.whereFound();
                    if (Caa.this.whereFound == null) {
                        Caa.this.whereFound = "BPXGMSTA";
                    }
                    if (Caa.this.tcb.tcbcmp() != 0L) {
                        Caa.this.failingRegisters = this.regs;
                    }
                    Caa.this.registers = this.regs;
                    return;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.regs = this.getRegistersFromLinkageStack();
                if (this.regs != null && whereCount++ >= whereSkip) {
                    Caa.this.whereFound = "Linkage";
                    if (Caa.this.tcb.tcbcmp() != 0L) {
                        Caa.this.failingRegisters = this.regs;
                    }
                    Caa.this.registers = this.regs;
                    return;
                }
            }
            catch (IOException e) {
                log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa.Cel4rreg", "Cel4rreg", "Unexepected exception", e);
                throw new Error("Unexpected IOException: " + e);
            }
            try {
                this.regs = this.getRegistersFromTCB();
                if (this.regs != null && whereCount++ >= whereSkip) {
                    Caa.this.whereFound = "TCB";
                    if (Caa.this.tcb.tcbcmp() != 0L) {
                        Caa.this.failingRegisters = this.regs;
                    }
                    Caa.this.registers = this.regs;
                    return;
                }
            }
            catch (IOException e) {
                throw new Error("oops: " + e);
            }
            try {
                if (Caa.this.is64bit) {
                    long lca = CeexlaaTemplate.getCeelaa_lca64(Caa.this.inputStream, Caa.this.laa);
                    this.p_dsaptr = CeelcaTemplate.getCeelca_savstack(Caa.this.inputStream, lca);
                    log.fine("p_dsaptr from lca = " + Caa.hex(this.p_dsaptr));
                    Caa.this.stackdirection = 1;
                    this.p_dsafmt = 1;
                    if (this.validateDSA() == 0 && whereCount++ >= whereSkip) {
                        Caa.this.whereFound = "LCA";
                        return;
                    }
                }
            }
            catch (IOException e) {
                throw new Error("oops: " + e);
            }
            try {
                this.regs = this.getRegistersFromUsta();
                if (this.regs != null && whereCount++ >= whereSkip) {
                    Caa.this.whereFound = this.regs.whereFound();
                    if (Caa.this.tcb.tcbcmp() != 0L) {
                        Caa.this.failingRegisters = this.regs;
                    }
                    Caa.this.registers = this.regs;
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Caa.this.whereFound = "not found";
        }

        private RegisterSet getRegistersFromRTM2() throws IOException {
            long rtm2ptr;
            int level = Caa.this.ceecaalevel();
            log.finer("caa level is " + level);
            if (Caa.this.is64bit) {
                Caa.this.stackdirection = 1;
                log.finer("stack direction is down");
            } else if (level >= 13) {
                Caa.this.stackdirection = Caa.this.ceecaa_stackdirection();
                log.finer("stack direction is " + (Caa.this.stackdirection == 0 ? "up" : "down"));
            } else {
                Caa.this.stackdirection = 0;
                log.finer("stack direction is up");
            }
            if (Caa.this.stackdirection == 1 && !Caa.this.is64bit) {
                try {
                    long tempptr = Caa.this.ceecaasmcb();
                    this.seghigh = SmcbTemplate.getSmcb_dsbos(Caa.this.inputStream, tempptr);
                    this.seglow = CeexstkhTemplate.getStkh_stackfloor(Caa.this.inputStream, this.seghigh);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if ((rtm2ptr = Caa.this.tcb.tcbrtwa()) != 0L) {
                try {
                    log.finer("found some rtm2 registers");
                    RegisterSet regs = new RegisterSet();
                    long rtm2grs = rtm2ptr + (long)Ihartm2aTemplate.getRtm2ereg$offset();
                    long rtm2grshi = rtm2ptr + (long)Ihartm2aTemplate.getRtm2g64h$offset();
                    for (int i = 0; i < 16; ++i) {
                        long low = Caa.this.space.readUnsignedInt(rtm2grs + (long)(i * 4));
                        long high = Caa.this.is64bit ? Caa.this.space.readUnsignedInt(rtm2grshi + (long)(i * 4)) : 0L;
                        regs.setRegister(i, high << 32 | low);
                    }
                    long rtm2psw = rtm2ptr + (long)Ihartm2aTemplate.getRtm2apsw$offset();
                    regs.setPSW(Caa.this.space.readLong(rtm2psw));
                    if (this.registersValid(regs)) {
                        log.finer("found good dsa in rtm2");
                    } else {
                        log.finer("bad dsa in rtm2");
                        regs = null;
                    }
                    return regs;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new Error("oops: " + e);
                }
            }
            log.finer("failed to get registers from rtm2");
            return null;
        }

        private boolean registersValid(RegisterSet regs) throws IOException {
            if (regs == null) {
                return false;
            }
            this.p_dsafmt = Caa.this.stackdirection;
            if (this.p_dsafmt == 1) {
                this.p_dsaptr = regs.getRegisterAsAddress(4);
                log.finer("p_dsaptr from reg 4 = " + Caa.hex(this.p_dsaptr));
            } else {
                this.p_dsaptr = regs.getRegisterAsAddress(13);
                log.finer("p_dsaptr from reg 13 = " + Caa.hex(this.p_dsaptr));
            }
            int lastrc = this.validateDSA();
            if (lastrc == 0) {
                log.finer("found valid dsa");
                return true;
            }
            if (Caa.this.stackdirection == 1) {
                this.p_dsaptr = regs.getRegisterAsAddress(13);
                log.finer("p_dsaptr from reg 13 (again) = " + Caa.hex(this.p_dsaptr));
                this.p_dsafmt = 0;
                lastrc = this.validateDSA();
                if (lastrc == 4 && (lastrc = this.validateDSA()) == 0) {
                    log.finer("found valid dsa");
                    return true;
                }
            }
            log.finer("p_dsaptr invalid so reset: " + Caa.hex(this.p_dsaptr));
            this.p_dsaptr = 0L;
            return false;
        }

        private RegisterSet getRegistersFromBPXGMSTA() throws IOException {
            RegisterSet regs = Caa.this.tcb.getRegistersFromBPXGMSTA();
            if (Caa.this.is64bit) {
                Caa.this.stackdirection = 1;
            }
            if (this.registersValid(regs)) {
                log.finer("found good dsa in BPXGMSTA");
                return regs;
            }
            log.finer("BPX registers are invalid so keep looking");
            return null;
        }

        private RegisterSet getRegistersFromLinkageStack() throws IOException {
            log.finer("enter getRegistersFromLinkageStack");
            try {
                Lse[] linkageStack = Caa.this.tcb.getLinkageStack();
                if (linkageStack.length == 0) {
                    log.finer("empty linkage stack");
                    return null;
                }
                for (int i = 0; i < linkageStack.length; ++i) {
                    Lse lse = linkageStack[i];
                    if (lse.lses1pasn() == Caa.this.space.getAsid()) {
                        int j;
                        RegisterSet regs = new RegisterSet();
                        if (lse.isZArchitecture() && (lse.lses1typ7() == 13 || lse.lses1typ7() == 12)) {
                            log.finer("found some z arch registers");
                            regs.setPSW(lse.lses1pswh());
                            for (j = 0; j < 16; ++j) {
                                regs.setRegister(j, lse.lses1grs(j));
                            }
                        } else {
                            log.finer("found some non z arch registers");
                            regs.setPSW(lse.lsespsw());
                            for (j = 0; j < 16; ++j) {
                                regs.setRegister(j, lse.lsesgrs(j));
                            }
                        }
                        if (!this.registersValid(regs)) continue;
                        log.finer("found good dsa in linkage stack");
                        return regs;
                    }
                    log.finer("different asid: " + Caa.hex(lse.lses1pasn()));
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error("oops: " + e);
            }
            log.finer("could not find registers in linkage stack");
            return null;
        }

        private RegisterSet getRegistersFromTCB() throws IOException {
            log.finer("getRegistersFromTCB");
            RegisterSet regs = Caa.this.tcb.getRegisters();
            if (this.registersValid(regs)) {
                log.finer("found good dsa in TCB");
                return regs;
            }
            return null;
        }

        private RegisterSet getRegistersFromUsta() throws IOException {
            long dsaptr;
            boolean isDownStack;
            log.fine("enter getRegistersFromUsta");
            RegisterSet regs = Caa.this.tcb.getRegistersFromUsta();
            if (this.registersValid(regs)) {
                log.finer("found good dsa in Usta");
                return regs;
            }
            boolean bl = isDownStack = Caa.this.stackdirection == 1;
            if (isDownStack) {
                dsaptr = regs.getRegister(4);
                log.finer("p_dsaptr from reg 4 = " + Caa.hex(this.p_dsaptr));
            } else {
                dsaptr = regs.getRegister(13);
                log.finer("p_dsaptr from reg 13 = " + Caa.hex(this.p_dsaptr));
            }
            try {
                int count = 0;
                for (DsaStackFrame dsa = new DsaStackFrame(dsaptr, isDownStack, regs, Caa.this.space, Caa.this); dsa != null; dsa = dsa.getParentFrame()) {
                    if (++count <= 3) continue;
                    this.p_dsaptr = dsaptr;
                    this.p_dsafmt = Caa.this.stackdirection;
                    return regs;
                }
            }
            catch (IOException iOException) {
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            return null;
        }

        private void getRegistersFromSvcdump() {
        }

        private int validateDSA() {
            log.finer("attempt to validate " + Caa.hex(this.p_dsaptr) + " on " + (this.p_dsafmt == 1 ? "down" : "up") + " stack");
            try {
                if (Caa.this.is64bit) {
                    long sanc_user_stack;
                    assert (Caa.this.laa != 0L);
                    long l_sancptr = CeexlaaTemplate.getCeelaa_sanc64(Caa.this.inputStream, Caa.this.laa);
                    assert (l_sancptr != 0L);
                    long seghigh = CeexsancTemplate.getSanc_bos(Caa.this.inputStream, l_sancptr);
                    long seglow = 0L;
                    long sanc_stack = CeexsancTemplate.getSanc_stack(Caa.this.inputStream, l_sancptr);
                    seglow = sanc_stack == (sanc_user_stack = CeexsancTemplate.getSanc_user_stack(Caa.this.inputStream, l_sancptr)) ? CeexsancTemplate.getSanc_user_floor(Caa.this.inputStream, l_sancptr) : CeexlaaTemplate.getCeelaa_stackfloor64(Caa.this.inputStream, Caa.this.laa);
                    if (this.p_dsaptr < seghigh && this.p_dsaptr + 2048L >= seglow && (this.p_dsaptr & 0xFL) == 0L) {
                        log.finer("dsa " + Caa.hex(this.p_dsaptr) + " is within seglow = " + Caa.hex(seglow) + " seghigh = " + Caa.hex(seghigh));
                        return 0;
                    }
                    log.finer("dsa " + Caa.hex(this.p_dsaptr) + " is NOT within seglow = " + Caa.hex(seglow) + " seghigh = " + Caa.hex(seghigh));
                    return 8;
                }
                if (this.p_dsafmt != 1) {
                    if (Caa.this.is64bit) {
                        return 8;
                    }
                    long tptr = Caa.this.ceecaaerrcm();
                    if (this.p_dsaptr < tptr + (long)hcomLength && this.p_dsaptr >= tptr && (this.p_dsaptr & 7L) == 0L) {
                        log.finer("upstack dsa " + Caa.hex(this.p_dsaptr) + " is inside hcom");
                        return 0;
                    }
                }
                long ddsa = Caa.this.ceecaaddsa();
                long dsaptr = this.p_dsaptr;
                int dsafmt8 = this.p_dsafmt;
                long slowdsaptr = this.p_dsaptr;
                int slowdsafmt8 = this.p_dsafmt;
                boolean slow = false;
                while (true) {
                    long tptr;
                    Ceexdsaf dsaf = new Ceexdsaf(Caa.this.space, dsaptr, dsafmt8, Caa.this.is64bit);
                    log.finer("looping with dsa = " + Caa.hex(dsaptr));
                    if (Caa.this.stackdirection == 1 && this.p_dsafmt == 0 && dsaptr < this.seghigh && dsaptr >= this.seglow) {
                        this.p_dsaptr = CeedsaTemplate.getCeedsar4(Caa.this.inputStream, dsaptr);
                        this.p_dsafmt = 1;
                        log.finer("warning, try switching to down stack");
                        return 4;
                    }
                    long callers_dsaptr = dsaf.DSA_Prev;
                    dsafmt8 = dsaf.DSA_Format;
                    if (callers_dsaptr == 0L || callers_dsaptr == -420355391L) {
                        log.finer("cannot backchain futher because " + (callers_dsaptr == 0L ? "zero" : "linkage stack") + " found");
                        return 8;
                    }
                    if (callers_dsaptr == ddsa) {
                        log.finer("dummy dsa reached");
                        return 0;
                    }
                    if (dsafmt8 != this.p_dsafmt) {
                        log.finer("backchained across a stack transition");
                        return 0;
                    }
                    if (dsafmt8 == 0 && (tptr = CeedsaTemplate.getCeedsanab(Caa.this.inputStream, callers_dsaptr)) == dsaptr) {
                        log.finer("upstack DSA is good");
                        return 0;
                    }
                    dsaptr = callers_dsaptr;
                    if (slow) {
                        dsaf = new Ceexdsaf(Caa.this.space, slowdsaptr, slowdsafmt8, Caa.this.is64bit);
                        slowdsaptr = dsaf.DSA_Prev;
                        slowdsafmt8 = dsaf.DSA_Format;
                    }
                    if (dsaptr == slowdsaptr) {
                        log.finer("loop detected in DSA chain");
                        return 8;
                    }
                    slow = !slow;
                }
            }
            catch (IOException e) {
                log.logp(Level.FINER, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa.Cel4rreg", "validateDSA", "Bad read", e);
                return 8;
            }
            catch (Exception e) {
                log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa.Cel4rreg", "validateDSA", "Unexepected exception", e);
                throw new Error("Unexpected Exception:: " + e);
            }
        }
    }
}

