/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.BCNames;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.stackmap.DebugLocalMap;
import com.ibm.j9ddr.vm29.j9.stackmap.LocalMap;
import com.ibm.j9ddr.vm29.j9.stackmap.StackMap;
import com.ibm.j9ddr.vm29.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMSingleSlotConstantRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMStringRefPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9BCTranslationData;
import com.ibm.j9ddr.vm29.structure.J9ROMMethod;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.I8;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class ByteCodeDumper {
    private static final String nl = System.getProperty("line.separator");
    public static int BCT_ERR_NO_ERROR = 0;
    private static final int OPCODE_RELATIVE_BRANCHES = 1;
    private static final int LOCAL_MAP = 0;
    private static final int DEBUG_MAP = 1;
    private static final int STACK_MAP = 2;
    private static final int MAP_COUNT = 3;
    private static boolean bigEndian;
    private static U8Pointer bcIndex;

    public static IDATA dumpBytecodes(PrintStream out, J9ROMClassPointer romClass, J9ROMMethodPointer romMethod, U32 flags) throws Exception {
        out.append(String.format("  Argument Count: %d", romMethod.argCount().intValue()));
        out.append(nl);
        U16 temp = romMethod.tempCount();
        out.append(String.format("  Temp Count: %d", temp.intValue()));
        out.append(nl);
        out.append(nl);
        UDATA length = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod);
        if (length.eq(0L)) {
            return new IDATA(BCT_ERR_NO_ERROR);
        }
        return ByteCodeDumper.j9bcutil_dumpBytecodes(out, romClass, ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(romMethod), new UDATA(0L), length.sub(1L), flags, "");
    }

    private static IDATA j9bcutil_dumpBytecodes(PrintStream out, J9ROMClassPointer romClass, U8Pointer bytecodes, UDATA walkStartPC, UDATA walkEndPC, U32 flags, String indent) throws Exception {
        J9ROMConstantPoolItemPointer constantPool = J9ROMClassHelper.constantPool(romClass);
        bigEndian = flags.anyBitsIn(J9BCTranslationData.BCT_BigEndianOutput);
        UDATA index = new UDATA(0L);
        UDATA target = new UDATA(0L);
        J9ROMMethodPointer romMethod = J9ROMMethodPointer.cast(bytecodes.sub(J9ROMMethod.SIZEOF));
        U32 localsCount = new U32(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(romMethod).add(ROMHelp.J9_TEMP_COUNT_FROM_ROM_METHOD(romMethod)));
        int[] resultArray = new int[8192];
        String environment = System.getenv().get("j9bcutil_dumpBytecodes");
        Integer dumpBytecodes = environment != null ? Integer.valueOf(environment) : null;
        UDATA pc = new UDATA(walkStartPC);
        bcIndex = bytecodes.add(pc);
        while (pc.lte(walkEndPC)) {
            J9ROMNameAndSignaturePointer nameAndSig;
            I32 offset;
            int padding;
            J9ROMConstantPoolItemPointer info;
            int i;
            if (flags.anyBitsIn(J9BCTranslationData.BCT_DumpMaps)) {
                for (int j = 0; j < 3; ++j) {
                    if (dumpBytecodes != null && !pc.eq(dumpBytecodes.intValue())) continue;
                    boolean wrapLine = false;
                    UDATA outputCount = new UDATA(0L);
                    U8 mapChar = new U8(48L);
                    switch (j) {
                        case 0: {
                            int result = LocalMap.j9localmap_LocalBitsForPC(romMethod, pc, resultArray);
                            mapChar = new U8(108L);
                            outputCount = new UDATA(localsCount);
                            break;
                        }
                        case 1: {
                            int result = DebugLocalMap.j9localmap_DebugLocalBitsForPC(romMethod, pc, resultArray);
                            mapChar = new U8(100L);
                            outputCount = new UDATA(localsCount);
                            break;
                        }
                        case 2: {
                            int result = StackMap.j9stackmap_StackBitsForPC(pc, romClass, romMethod, null, 0);
                            mapChar = new U8(115L);
                            outputCount = new UDATA(result);
                        }
                    }
                    if (outputCount.eq(0L)) {
                        out.append(String.format("               %cmap [empty]", Character.valueOf((char)mapChar.intValue())));
                    } else {
                        out.append(String.format("               %cmap [%5d] =", Character.valueOf((char)mapChar.intValue()), outputCount.intValue()));
                    }
                    i = 0;
                    while (outputCount.gt(i)) {
                        int x = i / 32;
                        if (i % 8 == 0) {
                            out.append(" ");
                            if (wrapLine) {
                                out.append(nl);
                            }
                        }
                        out.append(String.format("%d ", resultArray[x] & 1));
                        int n = x;
                        resultArray[n] = resultArray[n] >> 1;
                        wrapLine = (i + 1) % 32 == 0;
                        ++i;
                    }
                    out.append(nl);
                }
            }
            UDATA bc = new UDATA(ByteCodeDumper._GETNEXT_U8());
            out.append(String.format("%s%5d %s ", indent, pc.intValue(), BCNames.getName(bc.intValue())));
            UDATA start = new UDATA(pc);
            pc = pc.add(1L);
            int bcIntVal = bc.intValue();
            if (bcIntVal == 16) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U8());
                out.append(String.format("%d\n", new I8(index).intValue()));
                pc = pc.add(1L);
                continue;
            }
            if (bcIntVal == 17) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                out.append(String.format("%d\n", new I16(index).intValue()));
                pc = pc.add(2L);
                continue;
            }
            if (bcIntVal == 18 || bcIntVal == 19) {
                if (bc.eq(18L)) {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U8());
                    pc = pc.add(1L);
                } else {
                    index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                    pc = pc.add(2L);
                }
                out.append(String.format("%d ", index.intValue()));
                info = constantPool.add(index);
                J9ROMSingleSlotConstantRefPointer romSingleSlotConstantRef = J9ROMSingleSlotConstantRefPointer.cast(info);
                if (!romSingleSlotConstantRef.cpType().eq(J9BCTranslationData.BCT_J9DescriptionCpTypeScalar)) {
                    if (romSingleSlotConstantRef.cpType().eq(J9BCTranslationData.BCT_J9DescriptionCpTypeClass)) {
                        out.append("(java.lang.Class) ");
                    } else {
                        out.append("(java.lang.String) ");
                    }
                    out.append(J9UTF8Helper.stringValue(J9ROMStringRefPointer.cast(info).utf8Data()));
                    out.append(nl);
                    continue;
                }
                out.append(String.format("(int/float) 0x%08X", romSingleSlotConstantRef.data().longValue()));
                out.append(nl);
                continue;
            }
            if (bcIntVal == 20) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                out.append(String.format("%d ", index.intValue()));
                info = constantPool.add(index);
                out.append(String.format("(long) 0x%08X%08X\n", bigEndian ? info.slot1().longValue() : info.slot2().longValue(), bigEndian ? info.slot2().longValue() : info.slot1().longValue()));
                pc = pc.add(2L);
                continue;
            }
            if (bcIntVal == BCNames.JBldc2dw) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                out.append(String.format("%d ", index.intValue()));
                info = constantPool.add(index);
                out.append(String.format("(double) 0x%08X%08X\n", bigEndian ? info.slot1().longValue() : info.slot2().longValue(), bigEndian ? info.slot2().longValue() : info.slot1().longValue()));
                pc = pc.add(2L);
                continue;
            }
            if (bcIntVal == 21 || bcIntVal == 22 || bcIntVal == 23 || bcIntVal == 24 || bcIntVal == 25 || bcIntVal == 54 || bcIntVal == 55 || bcIntVal == 56 || bcIntVal == 57 || bcIntVal == 58) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U8());
                pc = pc.add(1L);
                out.append(String.format("%d\n", index.intValue()));
                continue;
            }
            if (bcIntVal == BCNames.JBiloadw || bcIntVal == BCNames.JBlloadw || bcIntVal == BCNames.JBfloadw || bcIntVal == BCNames.JBdloadw || bcIntVal == BCNames.JBaloadw || bcIntVal == BCNames.JBistorew || bcIntVal == BCNames.JBlstorew || bcIntVal == BCNames.JBfstorew || bcIntVal == BCNames.JBdstorew || bcIntVal == BCNames.JBastorew) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                ByteCodeDumper.incIndex();
                pc = pc.add(3L);
                out.append(String.format("%d\n", index.intValue()));
                continue;
            }
            if (bcIntVal == 132) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U8());
                out.append(String.format("%d ", index.intValue()));
                target = new UDATA(ByteCodeDumper._GETNEXT_U8());
                out.append(String.format("%d\n", new I8(target).intValue()));
                pc = pc.add(2L);
                continue;
            }
            if (bcIntVal == BCNames.JBiincw) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                out.append(String.format("%d ", index.intValue()));
                index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                out.append(String.format("%d\n", new I16(index).intValue()));
                ByteCodeDumper.incIndex();
                pc = pc.add(5L);
                continue;
            }
            if (bcIntVal == 153 || bcIntVal == 154 || bcIntVal == 155 || bcIntVal == 156 || bcIntVal == 157 || bcIntVal == 158 || bcIntVal == 159 || bcIntVal == 160 || bcIntVal == 161 || bcIntVal == 162 || bcIntVal == 163 || bcIntVal == 164 || bcIntVal == 165 || bcIntVal == 166 || bcIntVal == 167 || bcIntVal == 198 || bcIntVal == 199) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                pc = pc.add(2L);
                target = start.add(new I16(index));
                out.append(String.format("%d\n", target.intValue()));
                continue;
            }
            if (bcIntVal == 170) {
                padding = ByteCodeDumper.switchPaddingSize(start);
                if (padding != 0) {
                    bcIndex = bcIndex.add(padding);
                    pc = pc.add(padding);
                }
                offset = ByteCodeDumper._GETNEXT_I32();
                I32 low = ByteCodeDumper._GETNEXT_I32();
                I32 high = ByteCodeDumper._GETNEXT_I32();
                pc = pc.add(12L);
                target = start.add(offset);
                out.append(String.format("low %d high %d\n", low.intValue(), high.intValue()));
                out.append(String.format("        default %10d\n", target.intValue()));
                I32 npairs = high.sub(low).add(1L);
                int i2 = 0;
                while (npairs.gt(i2)) {
                    offset = ByteCodeDumper._GETNEXT_I32();
                    target = start.add(offset);
                    out.append(String.format("     %10d %10d\n", low.add(i2).intValue(), target.intValue()));
                    pc = pc.add(4L);
                    ++i2;
                }
                continue;
            }
            if (bcIntVal == 171) {
                padding = ByteCodeDumper.switchPaddingSize(start);
                if (padding != 0) {
                    bcIndex = bcIndex.add(padding);
                    pc = pc.add(padding);
                }
                offset = ByteCodeDumper._GETNEXT_I32();
                I32 npairs = ByteCodeDumper._GETNEXT_I32();
                target = start.add(offset);
                out.append(String.format("pairs %d\n", npairs.intValue()));
                out.append(String.format("        default %10d\n", target.intValue()));
                pc = pc.add(8L);
                i = 0;
                while (npairs.gt(i)) {
                    I32 key = ByteCodeDumper._GETNEXT_I32();
                    offset = ByteCodeDumper._GETNEXT_I32();
                    target = start.add(offset);
                    out.append(String.format("     %10d %10d\n", key.intValue(), target.intValue()));
                    pc = pc.add(8L);
                    ++i;
                }
                continue;
            }
            if (bcIntVal == 178 || bcIntVal == 179 || bcIntVal == 180 || bcIntVal == BCNames.JBwithfield || bcIntVal == 181) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                info = constantPool.add(index);
                out.append(String.format("%d ", index.intValue()));
                J9ROMFieldRefPointer romFieldRef = J9ROMFieldRefPointer.cast(info);
                out.append(J9UTF8Helper.stringValue(J9ROMClassRefPointer.cast(constantPool.add(romFieldRef.classRefCPIndex())).name()));
                nameAndSig = romFieldRef.nameAndSignature();
                out.append(".");
                out.append(J9UTF8Helper.stringValue(nameAndSig.name()));
                out.append(" ");
                out.append(J9UTF8Helper.stringValue(nameAndSig.signature()));
                out.append(nl);
                pc = pc.add(2L);
                continue;
            }
            if (bcIntVal == 186) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                out.append(String.format("%d ", index.intValue()));
                long callSiteCount = romClass.callSiteCount().longValue();
                SelfRelativePointer callSiteData = SelfRelativePointer.cast(romClass.callSiteData());
                U16Pointer bsmIndices = U16Pointer.cast(callSiteData.addOffset(4L * callSiteCount));
                nameAndSig = J9ROMNameAndSignaturePointer.cast(callSiteData.add(index).get());
                out.append("bsm #" + bsmIndices.at(index).longValue());
                out.append(":");
                out.append(J9UTF8Helper.stringValue(nameAndSig.name()));
                out.append(J9UTF8Helper.stringValue(nameAndSig.signature()));
                out.append(nl);
                pc = pc.add(4L);
                continue;
            }
            if (bcIntVal == BCNames.JBinvokeinterface2) {
                ByteCodeDumper.incIndex();
                pc = pc.add(1L);
                out.append(nl);
                continue;
            }
            if (bcIntVal == BCNames.JBinvokehandle || bcIntVal == BCNames.JBinvokehandlegeneric || bcIntVal == 182 || bcIntVal == 183 || bcIntVal == 184 || bcIntVal == 185 || bcIntVal == BCNames.JBinvokespecialsplit || bcIntVal == BCNames.JBinvokestaticsplit) {
                if (bcIndex.longValue() == 0L) {
                    bcIndex = bcIndex.sub(1L);
                }
                index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                if (bc.intValue() == BCNames.JBinvokestaticsplit) {
                    index = new UDATA(romClass.staticSplitMethodRefIndexes().at(index));
                } else if (bc.intValue() == BCNames.JBinvokespecialsplit) {
                    index = new UDATA(romClass.specialSplitMethodRefIndexes().at(index));
                }
                info = constantPool.add(index);
                out.append(String.format("%d ", index.intValue()));
                J9ROMMethodRefPointer romMethodRef = J9ROMMethodRefPointer.cast(info);
                UDATA classRefCPIndex = romMethodRef.classRefCPIndex();
                J9ROMConstantPoolItemPointer cpItem = constantPool.add(classRefCPIndex);
                J9ROMClassRefPointer romClassRef = J9ROMClassRefPointer.cast(cpItem);
                String name = J9UTF8Helper.stringValue(romClassRef.name());
                out.append(name);
                nameAndSig = romMethodRef.nameAndSignature();
                out.append(".");
                out.append(J9UTF8Helper.stringValue(nameAndSig.name()));
                out.append(J9UTF8Helper.stringValue(nameAndSig.signature()));
                out.append(nl);
                pc = pc.add(2L);
                continue;
            }
            if (bcIntVal == 187 || bcIntVal == BCNames.JBnewdup || bcIntVal == BCNames.JBdefaultvalue || bcIntVal == 189 || bcIntVal == 192 || bcIntVal == 193) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                info = constantPool.add(index);
                out.append(String.format("%d ", index.intValue()));
                out.append(J9UTF8Helper.stringValue(J9ROMStringRefPointer.cast(info).utf8Data()));
                out.append(nl);
                pc = pc.add(2L);
                continue;
            }
            if (bcIntVal == 188) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U8());
                switch (index.intValue()) {
                    case 4: {
                        out.append("boolean\n");
                        break;
                    }
                    case 5: {
                        out.append("char\n");
                        break;
                    }
                    case 6: {
                        out.append("float\n");
                        break;
                    }
                    case 7: {
                        out.append("double\n");
                        break;
                    }
                    case 8: {
                        out.append("byte\n");
                        break;
                    }
                    case 9: {
                        out.append("short\n");
                        break;
                    }
                    case 10: {
                        out.append("int\n");
                        break;
                    }
                    case 11: {
                        out.append("long\n");
                        break;
                    }
                    default: {
                        out.append(String.format("(unknown type %d)\n", index.intValue()));
                    }
                }
                pc = pc.add(1L);
                continue;
            }
            if (bcIntVal == 197) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U16());
                info = constantPool.add(index);
                out.append(String.format("%d ", index.intValue()));
                index = new UDATA(ByteCodeDumper._GETNEXT_U8());
                out.append(String.format("dims %d ", index.intValue()));
                out.append(J9UTF8Helper.stringValue(J9ROMStringRefPointer.cast(info).utf8Data()));
                out.append(nl);
                pc = pc.add(3L);
                continue;
            }
            if (bcIntVal == 200) {
                index = new UDATA(ByteCodeDumper._GETNEXT_U32());
                pc = pc.add(4L);
                target = start.add(index);
                out.append(String.format("%d\n", target.intValue()));
                continue;
            }
            out.append(nl);
        }
        return new IDATA(BCT_ERR_NO_ERROR);
    }

    private static int switchPaddingSize(UDATA start) {
        return 3 - start.intValue() % 4;
    }

    private static void incIndex() {
        bcIndex = bcIndex.add(1L);
    }

    private static I32 _GETNEXT_I32() throws CorruptDataException {
        int a = bcIndex.at(0L).intValue();
        int b = bcIndex.at(1L).intValue();
        int c = bcIndex.at(2L).intValue();
        int d = bcIndex.at(3L).intValue();
        int value = bigEndian ? a << 24 | b << 16 | c << 8 | d : d << 24 | c << 16 | b << 8 | a;
        bcIndex = bcIndex.add(4L);
        return new I32(value);
    }

    private static U32 _GETNEXT_U32() throws CorruptDataException {
        if (bigEndian) {
            return ByteCodeDumper._NEXT_BE_U32();
        }
        return ByteCodeDumper._NEXT_LE_U32();
    }

    private static U32 _NEXT_BE_U32() throws CorruptDataException {
        U32 a = new U32(bcIndex.at(0L)).leftShift(24);
        U32 b = new U32(bcIndex.at(1L)).leftShift(16);
        U32 c = new U32(bcIndex.at(2L)).leftShift(8);
        U32 d = new U32(bcIndex.at(3L));
        U32 value = a.bitOr(b).bitOr(c).bitOr(d);
        bcIndex = bcIndex.add(4L);
        return value;
    }

    private static U32 _NEXT_LE_U32() throws CorruptDataException {
        U32 a = new U32(bcIndex.at(0L));
        U32 b = new U32(bcIndex.at(1L)).leftShift(8);
        U32 c = new U32(bcIndex.at(2L)).leftShift(16);
        U32 d = new U32(bcIndex.at(3L)).leftShift(24);
        U32 value = a.bitOr(b).bitOr(c).bitOr(d);
        bcIndex = bcIndex.add(4L);
        return value;
    }

    private static U16 _GETNEXT_U16() throws CorruptDataException {
        if (bigEndian) {
            return ByteCodeDumper._NEXT_BE_U16();
        }
        return ByteCodeDumper._NEXT_LE_U16();
    }

    private static U16 _NEXT_LE_U16() throws CorruptDataException {
        U16 a = new U16(bcIndex.at(0L));
        U16 b = new U16(bcIndex.at(1L)).leftShift(8);
        U16 value = a.bitOr(b);
        bcIndex = bcIndex.add(2L);
        return value;
    }

    private static U16 _NEXT_BE_U16() throws CorruptDataException {
        U16 a = new U16(bcIndex.at(0L)).leftShift(8);
        U16 b = new U16(bcIndex.at(1L));
        U16 value = a.bitOr(b);
        bcIndex = bcIndex.add(2L);
        return value;
    }

    private static U8 _GETNEXT_U8() throws CorruptDataException {
        U8 result = new U8(bcIndex.at(0L));
        ByteCodeDumper.incIndex();
        return result;
    }
}

