/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import java.io.PrintStream;
import java.util.NoSuchElementException;

public class FilteredROMClassesIterator
extends ROMClassesIterator {
    private final PatternString classPattern;
    J9ROMClassPointer nextClass;

    public FilteredROMClassesIterator(PrintStream out, J9MemorySegmentListPointer segmentList, PatternString classPattern) {
        super(out, segmentList);
        this.classPattern = classPattern;
        this.nextClass = null;
    }

    @Override
    public boolean hasNext() {
        if (null == this.nextClass) {
            this.nextClass = this.next();
        }
        return null != this.nextClass;
    }

    @Override
    public J9ROMClassPointer next() {
        J9ROMClassPointer candidateClass = this.nextClass;
        this.nextClass = null;
        try {
            while (null == candidateClass && super.hasNext()) {
                candidateClass = super.next();
                String className = J9UTF8Helper.stringValue(candidateClass.className());
                if (this.classPattern.isMatch(className)) continue;
                candidateClass = null;
            }
        }
        catch (CorruptDataException e) {
            throw new NoSuchElementException();
        }
        return candidateClass;
    }
}

