/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ru extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "JPY", "\u00a5" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PES", "PES" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "\u20bd" },
            { "RUR", "\u0440." },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "\u0422\u041c\u0422" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "\u20b4" },
            { "UGX", "UGX" },
            { "USD", "$" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "XXX", "XXXX" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "adp", "\u0410\u043d\u0434\u043e\u0440\u0440\u0441\u043a\u0430\u044f \u043f\u0435\u0441\u0435\u0442\u0430" },
            { "aed", "\u0434\u0438\u0440\u0445\u0430\u043c \u041e\u0410\u042d" },
            { "afa", "\u0410\u0444\u0433\u0430\u043d\u0438 (1927\u20132002)" },
            { "afn", "\u0430\u0444\u0433\u0430\u043d\u0438" },
            { "all", "\u0430\u043b\u0431\u0430\u043d\u0441\u043a\u0438\u0439 \u043b\u0435\u043a" },
            { "amd", "\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0438\u0439 \u0434\u0440\u0430\u043c" },
            { "ang", "\u043d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439 \u0430\u043d\u0442\u0438\u043b\u044c\u0441\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d" },
            { "aoa", "\u0430\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0430\u044f \u043a\u0432\u0430\u043d\u0437\u0430" },
            { "aok", "\u0410\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0430\u044f \u043a\u0432\u0430\u043d\u0437\u0430 (1977\u20131990)" },
            { "aon", "\u0410\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0430\u044f \u043d\u043e\u0432\u0430\u044f \u043a\u0432\u0430\u043d\u0437\u0430 (1990\u20132000)" },
            { "aor", "\u0410\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0430\u044f \u043a\u0432\u0430\u043d\u0437\u0430 \u0440\u0435\u044e\u0441\u0442\u0430\u0434\u043e (1995\u20131999)" },
            { "ara", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0441\u043a\u0438\u0439 \u0430\u0443\u0441\u0442\u0440\u0430\u043b" },
            { "arp", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0441\u043a\u043e\u0435 \u043f\u0435\u0441\u043e (1983\u20131985)" },
            { "ars", "\u0430\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0441\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "ats", "\u0410\u0432\u0441\u0442\u0440\u0438\u0439\u0441\u043a\u0438\u0439 \u0448\u0438\u043b\u043b\u0438\u043d\u0433" },
            { "aud", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "awg", "\u0430\u0440\u0443\u0431\u0430\u043d\u0441\u043a\u0438\u0439 \u0444\u043b\u043e\u0440\u0438\u043d" },
            { "azm", "\u0421\u0442\u0430\u0440\u044b\u0439 \u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442" },
            { "azn", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442" },
            { "bad", "\u0414\u0438\u043d\u0430\u0440 \u0411\u043e\u0441\u043d\u0438\u0438 \u0438 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u044b" },
            { "bam", "\u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u0430\u044f \u043c\u0430\u0440\u043a\u0430 \u0411\u043e\u0441\u043d\u0438\u0438 \u0438 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u044b" },
            { "bbd", "\u0431\u0430\u0440\u0431\u0430\u0434\u043e\u0441\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "bdt", "\u0431\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448\u0441\u043a\u0430\u044f \u0442\u0430\u043a\u0430" },
            { "bec", "\u0411\u0435\u043b\u044c\u0433\u0438\u0439\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a (\u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0439)" },
            { "bef", "\u0411\u0435\u043b\u044c\u0433\u0438\u0439\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "bel", "\u0411\u0435\u043b\u044c\u0433\u0438\u0439\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a (\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0439)" },
            { "bgl", "\u041b\u0435\u0432" },
            { "bgn", "\u0431\u043e\u043b\u0433\u0430\u0440\u0441\u043a\u0438\u0439 \u043b\u0435\u0432" },
            { "bhd", "\u0431\u0430\u0445\u0440\u0435\u0439\u043d\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "bif", "\u0431\u0443\u0440\u0443\u043d\u0434\u0438\u0439\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "bmd", "\u0431\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "bnd", "\u0431\u0440\u0443\u043d\u0435\u0439\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "bob", "\u0431\u043e\u043b\u0438\u0432\u0438\u0439\u0441\u043a\u0438\u0439 \u0431\u043e\u043b\u0438\u0432\u0438\u0430\u043d\u043e" },
            { "bop", "\u0411\u043e\u043b\u0438\u0432\u0438\u0439\u0441\u043a\u043e\u0435 \u043f\u0435\u0441\u043e" },
            { "bov", "\u0411\u043e\u043b\u0438\u0432\u0438\u0439\u0441\u043a\u0438\u0439 \u043c\u0432\u0434\u043e\u043b" },
            { "brb", "\u0411\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u043a\u0438\u0439 \u043d\u043e\u0432\u044b\u0439 \u043a\u0440\u0443\u0437\u0435\u0439\u0440\u043e (1967\u20131986)" },
            { "brc", "\u0411\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u043a\u043e\u0435 \u043a\u0440\u0443\u0437\u0430\u0434\u043e" },
            { "bre", "\u0411\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u0440\u0443\u0437\u0435\u0439\u0440\u043e (1990\u20131993)" },
            { "brl", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u043a\u0438\u0439 \u0440\u0435\u0430\u043b" },
            { "brn", "\u0411\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u043a\u043e\u0435 \u043d\u043e\u0432\u043e\u0435 \u043a\u0440\u0443\u0437\u0430\u0434\u043e" },
            { "brr", "\u0411\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u0440\u0443\u0437\u0435\u0439\u0440\u043e" },
            { "bsd", "\u0431\u0430\u0433\u0430\u043c\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "btn", "\u0431\u0443\u0442\u0430\u043d\u0441\u043a\u0438\u0439 \u043d\u0433\u0443\u043b\u0442\u0440\u0443\u043c" },
            { "buk", "\u0414\u0436\u0430" },
            { "bwp", "\u0431\u043e\u0442\u0441\u0432\u0430\u043d\u0441\u043a\u0430\u044f \u043f\u0443\u043b\u0430" },
            { "byb", "\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c (1994\u20131999)" },
            { "byn", "\u0431\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "byr", "\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c (2000\u20132016)" },
            { "bzd", "\u0431\u0435\u043b\u0438\u0437\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "cad", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "cdf", "\u043a\u043e\u043d\u0433\u043e\u043b\u0435\u0437\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "che", "WIR \u0435\u0432\u0440\u043e" },
            { "chf", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "chw", "WIR \u0444\u0440\u0430\u043d\u043a" },
            { "clf", "\u0423\u0441\u043b\u043e\u0432\u043d\u0430\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u0430\u044f \u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u0427\u0438\u043b\u0438" },
            { "clp", "\u0447\u0438\u043b\u0438\u0439\u0441\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "cnh", "\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0439 \u043e\u0444\u0448\u043e\u0440\u043d\u044b\u0439 \u044e\u0430\u043d\u044c" },
            { "cny", "\u043a\u0438\u0442\u0430\u0439\u0441\u043a\u0438\u0439 \u044e\u0430\u043d\u044c" },
            { "cop", "\u043a\u043e\u043b\u0443\u043c\u0431\u0438\u0439\u0441\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "cou", "\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0438" },
            { "crc", "\u043a\u043e\u0441\u0442\u0430\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u043a\u043e\u043b\u043e\u043d" },
            { "csd", "\u0421\u0442\u0430\u0440\u044b\u0439 \u0421\u0435\u0440\u0431\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "csk", "\u0427\u0435\u0445\u043e\u0441\u043b\u043e\u0432\u0430\u0446\u043a\u0430\u044f \u0442\u0432\u0435\u0440\u0434\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "cuc", "\u043a\u0443\u0431\u0438\u043d\u0441\u043a\u0438\u0439 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0439 \u043f\u0435\u0441\u043e" },
            { "cup", "\u043a\u0443\u0431\u0438\u043d\u0441\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "cve", "\u044d\u0441\u043a\u0443\u0434\u043e \u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "cyp", "\u041a\u0438\u043f\u0440\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "czk", "\u0447\u0435\u0448\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "ddm", "\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0430\u044f \u043c\u0430\u0440\u043a\u0430" },
            { "dem", "\u041d\u0435\u043c\u0435\u0446\u043a\u0430\u044f \u043c\u0430\u0440\u043a\u0430" },
            { "djf", "\u0444\u0440\u0430\u043d\u043a \u0414\u0436\u0438\u0431\u0443\u0442\u0438" },
            { "dkk", "\u0434\u0430\u0442\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "dop", "\u0434\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "dzd", "\u0430\u043b\u0436\u0438\u0440\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "ecs", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440\u0441\u043a\u0438\u0439 \u0441\u0443\u043a\u0440\u0435" },
            { "ecv", "\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u0430\u044f \u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u042d\u043a\u0432\u0430\u0434\u043e\u0440\u0430" },
            { "eek", "\u042d\u0441\u0442\u043e\u043d\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "egp", "\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "ern", "\u044d\u0440\u0438\u0442\u0440\u0435\u0439\u0441\u043a\u0430\u044f \u043d\u0430\u043a\u0444\u0430" },
            { "esa", "\u0418\u0441\u043f\u0430\u043d\u0441\u043a\u0430\u044f \u043f\u0435\u0441\u0435\u0442\u0430 (\u0410)" },
            { "esb", "\u0418\u0441\u043f\u0430\u043d\u0441\u043a\u0430\u044f \u043f\u0435\u0441\u0435\u0442\u0430 (\u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u0430\u044f)" },
            { "esp", "\u0418\u0441\u043f\u0430\u043d\u0441\u043a\u0430\u044f \u043f\u0435\u0441\u0435\u0442\u0430" },
            { "etb", "\u044d\u0444\u0438\u043e\u043f\u0441\u043a\u0438\u0439 \u0431\u044b\u0440" },
            { "eur", "\u0435\u0432\u0440\u043e" },
            { "fim", "\u0424\u0438\u043d\u0441\u043a\u0430\u044f \u043c\u0430\u0440\u043a\u0430" },
            { "fjd", "\u0434\u043e\u043b\u043b\u0430\u0440 \u0424\u0438\u0434\u0436\u0438" },
            { "fkp", "\u0444\u0443\u043d\u0442 \u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u0438\u0445 \u043e\u0441\u0442\u0440\u043e\u0432\u043e\u0432" },
            { "frf", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "gbp", "\u0431\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442 \u0441\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u043e\u0432" },
            { "gek", "\u0413\u0440\u0443\u0437\u0438\u043d\u0441\u043a\u0438\u0439 \u043a\u0443\u043f\u043e\u043d" },
            { "gel", "\u0433\u0440\u0443\u0437\u0438\u043d\u0441\u043a\u0438\u0439 \u043b\u0430\u0440\u0438" },
            { "ghc", "\u0413\u0430\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u0434\u0438 (1979\u20132007)" },
            { "ghs", "\u0433\u0430\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u0434\u0438" },
            { "gip", "\u0433\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "gmd", "\u0433\u0430\u043c\u0431\u0438\u0439\u0441\u043a\u0438\u0439 \u0434\u0430\u043b\u0430\u0441\u0438" },
            { "gnf", "\u0433\u0432\u0438\u043d\u0435\u0439\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "gns", "\u0413\u0432\u0438\u043d\u0435\u0439\u0441\u043a\u0430\u044f \u0441\u0438\u043b\u0438" },
            { "gqe", "\u042d\u043a\u0432\u0435\u043b\u0435 \u044d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b\u044c\u043d\u043e\u0439 \u0413\u0432\u0438\u043d\u0435\u0438" },
            { "grd", "\u0413\u0440\u0435\u0447\u0435\u0441\u043a\u0430\u044f \u0434\u0440\u0430\u0445\u043c\u0430" },
            { "gtq", "\u0433\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u0435\u0442\u0441\u0430\u043b\u044c" },
            { "gwe", "\u042d\u0441\u043a\u0443\u0434\u043e \u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u043e\u0439 \u0413\u0432\u0438\u043d\u0435\u0438" },
            { "gwp", "\u041f\u0435\u0441\u043e \u0413\u0432\u0438\u043d\u0435\u0438-\u0411\u0438\u0441\u0430\u0443" },
            { "gyd", "\u0433\u0430\u0439\u0430\u043d\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "hkd", "\u0433\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "hnl", "\u0433\u043e\u043d\u0434\u0443\u0440\u0430\u0441\u0441\u043a\u0430\u044f \u043b\u0435\u043c\u043f\u0438\u0440\u0430" },
            { "hrd", "\u0425\u043e\u0440\u0432\u0430\u0442\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "hrk", "\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u043a\u0430\u044f \u043a\u0443\u043d\u0430" },
            { "htg", "\u0433\u0430\u0438\u0442\u044f\u043d\u0441\u043a\u0438\u0439 \u0433\u0443\u0440\u0434" },
            { "huf", "\u0432\u0435\u043d\u0433\u0435\u0440\u0441\u043a\u0438\u0439 \u0444\u043e\u0440\u0438\u043d\u0442" },
            { "idr", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0439\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f" },
            { "iep", "\u0418\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "ilp", "\u0418\u0437\u0440\u0430\u0438\u043b\u044c\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "ils", "\u043d\u043e\u0432\u044b\u0439 \u0438\u0437\u0440\u0430\u0438\u043b\u044c\u0441\u043a\u0438\u0439 \u0448\u0435\u043a\u0435\u043b\u044c" },
            { "inr", "\u0438\u043d\u0434\u0438\u0439\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f" },
            { "iqd", "\u0438\u0440\u0430\u043a\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "irr", "\u0438\u0440\u0430\u043d\u0441\u043a\u0438\u0439 \u0440\u0438\u0430\u043b" },
            { "isk", "\u0438\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "itl", "\u0418\u0442\u0430\u043b\u044c\u044f\u043d\u0441\u043a\u0430\u044f \u043b\u0438\u0440\u0430" },
            { "jmd", "\u044f\u043c\u0430\u0439\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "jod", "\u0438\u043e\u0440\u0434\u0430\u043d\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "jpy", "\u044f\u043f\u043e\u043d\u0441\u043a\u0430\u044f \u0438\u0435\u043d\u0430" },
            { "kes", "\u043a\u0435\u043d\u0438\u0439\u0441\u043a\u0438\u0439 \u0448\u0438\u043b\u043b\u0438\u043d\u0433" },
            { "kgs", "\u043a\u0438\u0440\u0433\u0438\u0437\u0441\u043a\u0438\u0439 \u0441\u043e\u043c" },
            { "khr", "\u043a\u0430\u043c\u0431\u043e\u0434\u0436\u0438\u0439\u0441\u043a\u0438\u0439 \u0440\u0438\u0435\u043b\u044c" },
            { "kmf", "\u043a\u043e\u043c\u043e\u0440\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "kpw", "\u0441\u0435\u0432\u0435\u0440\u043e\u043a\u043e\u0440\u0435\u0439\u0441\u043a\u0430\u044f \u0432\u043e\u043d\u0430" },
            { "krw", "\u044e\u0436\u043d\u043e\u043a\u043e\u0440\u0435\u0439\u0441\u043a\u0430\u044f \u0432\u043e\u043d\u0430" },
            { "kwd", "\u043a\u0443\u0432\u0435\u0439\u0442\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "kyd", "\u0434\u043e\u043b\u043b\u0430\u0440 \u041e\u0441\u0442\u0440\u043e\u0432\u043e\u0432 \u041a\u0430\u0439\u043c\u0430\u043d" },
            { "kzt", "\u043a\u0430\u0437\u0430\u0445\u0441\u043a\u0438\u0439 \u0442\u0435\u043d\u0433\u0435" },
            { "lak", "\u043b\u0430\u043e\u0441\u0441\u043a\u0438\u0439 \u043a\u0438\u043f" },
            { "lbp", "\u043b\u0438\u0432\u0430\u043d\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "lkr", "\u0448\u0440\u0438-\u043b\u0430\u043d\u043a\u0438\u0439\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f" },
            { "lrd", "\u043b\u0438\u0431\u0435\u0440\u0438\u0439\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "lsl", "\u041b\u043e\u0442\u0438" },
            { "ltl", "\u041b\u0438\u0442\u043e\u0432\u0441\u043a\u0438\u0439 \u043b\u0438\u0442" },
            { "ltt", "\u041b\u0438\u0442\u043e\u0432\u0441\u043a\u0438\u0439 \u0442\u0430\u043b\u043e\u043d" },
            { "luc", "\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0439 \u0444\u0440\u0430\u043d\u043a \u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u0430" },
            { "luf", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "lul", "\u0424\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0439 \u0444\u0440\u0430\u043d\u043a \u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u0430" },
            { "lvl", "\u041b\u0430\u0442\u0432\u0438\u0439\u0441\u043a\u0438\u0439 \u043b\u0430\u0442" },
            { "lvr", "\u041b\u0430\u0442\u0432\u0438\u0439\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "lyd", "\u043b\u0438\u0432\u0438\u0439\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "mad", "\u043c\u0430\u0440\u043e\u043a\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u0434\u0438\u0440\u0445\u0430\u043c" },
            { "maf", "\u041c\u0430\u0440\u043e\u043a\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "mdl", "\u043c\u043e\u043b\u0434\u0430\u0432\u0441\u043a\u0438\u0439 \u043b\u0435\u0439" },
            { "mga", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0430\u0440\u0438\u0430\u0440\u0438" },
            { "mgf", "\u041c\u0430\u043b\u0430\u0433\u0430\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "mkd", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438\u0439 \u0434\u0435\u043d\u0430\u0440" },
            { "mlf", "\u041c\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "mmk", "\u043c\u044c\u044f\u043d\u043c\u0430\u043d\u0441\u043a\u0438\u0439 \u043a\u044c\u044f\u0442" },
            { "mnt", "\u043c\u043e\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0438\u0439 \u0442\u0443\u0433\u0440\u0438\u043a" },
            { "mop", "\u043f\u0430\u0442\u0430\u043a\u0430 \u041c\u0430\u043a\u0430\u043e" },
            { "mro", "\u043c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0443\u0433\u0438\u044f (1973\u20132017)" },
            { "mru", "\u043c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0443\u0433\u0438\u044f" },
            { "mtl", "\u041c\u0430\u043b\u044c\u0442\u0438\u0439\u0441\u043a\u0430\u044f \u043b\u0438\u0440\u0430" },
            { "mtp", "\u041c\u0430\u043b\u044c\u0442\u0438\u0439\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "mur", "\u043c\u0430\u0432\u0440\u0438\u043a\u0438\u0439\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f" },
            { "mvr", "\u043c\u0430\u043b\u044c\u0434\u0438\u0432\u0441\u043a\u0430\u044f \u0440\u0443\u0444\u0438\u044f" },
            { "mwk", "\u043c\u0430\u043b\u0430\u0432\u0438\u0439\u0441\u043a\u0430\u044f \u043a\u0432\u0430\u0447\u0430" },
            { "mxn", "\u043c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "mxp", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u043e\u0435 \u043f\u0435\u0441\u043e (1861\u20131992)" },
            { "mxv", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u043f\u0435\u0440\u0435\u0441\u0447\u0435\u0442\u043d\u0430\u044f \u0435\u0434\u0438\u043d\u0438\u0446\u0430 (UDI)" },
            { "myr", "\u043c\u0430\u043b\u0430\u0439\u0437\u0438\u0439\u0441\u043a\u0438\u0439 \u0440\u0438\u043d\u0433\u0433\u0438\u0442" },
            { "mze", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a\u0441\u043a\u043e\u0435 \u044d\u0441\u043a\u0443\u0434\u043e" },
            { "mzm", "\u0421\u0442\u0430\u0440\u044b\u0439 \u043c\u043e\u0437\u0430\u043c\u0431\u0438\u043a\u0441\u043a\u0438\u0439 \u043c\u0435\u0442\u0438\u043a\u0430\u043b" },
            { "mzn", "\u043c\u043e\u0437\u0430\u043c\u0431\u0438\u043a\u0441\u043a\u0438\u0439 \u043c\u0435\u0442\u0438\u043a\u0430\u043b" },
            { "nad", "\u0434\u043e\u043b\u043b\u0430\u0440 \u041d\u0430\u043c\u0438\u0431\u0438\u0438" },
            { "ngn", "\u043d\u0438\u0433\u0435\u0440\u0438\u0439\u0441\u043a\u0430\u044f \u043d\u0430\u0439\u0440\u0430" },
            { "nic", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430\u043d\u0441\u043a\u0430\u044f \u043a\u043e\u0440\u0434\u043e\u0431\u0430 (1988\u20131991)" },
            { "nio", "\u043d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430\u043d\u0441\u043a\u0430\u044f \u043a\u043e\u0440\u0434\u043e\u0431\u0430" },
            { "nlg", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d" },
            { "nok", "\u043d\u043e\u0440\u0432\u0435\u0436\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "npr", "\u043d\u0435\u043f\u0430\u043b\u044c\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f" },
            { "nzd", "\u043d\u043e\u0432\u043e\u0437\u0435\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "omr", "\u043e\u043c\u0430\u043d\u0441\u043a\u0438\u0439 \u0440\u0438\u0430\u043b" },
            { "pab", "\u043f\u0430\u043d\u0430\u043c\u0441\u043a\u0438\u0439 \u0431\u0430\u043b\u044c\u0431\u043e\u0430" },
            { "pei", "\u041f\u0435\u0440\u0443\u0430\u043d\u0441\u043a\u043e\u0435 \u0438\u043d\u0442\u0438" },
            { "pen", "\u043f\u0435\u0440\u0443\u0430\u043d\u0441\u043a\u0438\u0439 \u0441\u043e\u043b\u044c" },
            { "pes", "\u041f\u0435\u0440\u0443\u0430\u043d\u0441\u043a\u0438\u0439 \u0441\u043e\u043b\u044c (1863\u20131965)" },
            { "pgk", "\u043a\u0438\u043d\u0430 \u041f\u0430\u043f\u0443\u0430 \u2013 \u041d\u043e\u0432\u043e\u0439 \u0413\u0432\u0438\u043d\u0435\u0438" },
            { "php", "\u0444\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u0441\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "pkr", "\u043f\u0430\u043a\u0438\u0441\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f" },
            { "pln", "\u043f\u043e\u043b\u044c\u0441\u043a\u0438\u0439 \u0437\u043b\u043e\u0442\u044b\u0439" },
            { "plz", "\u0417\u043b\u043e\u0442\u044b\u0439" },
            { "pte", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u043e\u0435 \u044d\u0441\u043a\u0443\u0434\u043e" },
            { "pyg", "\u043f\u0430\u0440\u0430\u0433\u0432\u0430\u0439\u0441\u043a\u0438\u0439 \u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "qar", "\u043a\u0430\u0442\u0430\u0440\u0441\u043a\u0438\u0439 \u0440\u0438\u0430\u043b" },
            { "rhd", "\u0420\u043e\u0434\u0435\u0437\u0438\u0439\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "rol", "\u0421\u0442\u0430\u0440\u044b\u0439 \u0420\u0443\u043c\u044b\u043d\u0441\u043a\u0438\u0439 \u043b\u0435\u0439" },
            { "ron", "\u0440\u0443\u043c\u044b\u043d\u0441\u043a\u0438\u0439 \u043b\u0435\u0439" },
            { "rsd", "\u0441\u0435\u0440\u0431\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "rub", "\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "rur", "\u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c (1991\u20131998)" },
            { "rwf", "\u0444\u0440\u0430\u043d\u043a \u0420\u0443\u0430\u043d\u0434\u044b" },
            { "sar", "\u0441\u0430\u0443\u0434\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0438\u044f\u043b" },
            { "sbd", "\u0434\u043e\u043b\u043b\u0430\u0440 \u0421\u043e\u043b\u043e\u043c\u043e\u043d\u043e\u0432\u044b\u0445 \u041e\u0441\u0442\u0440\u043e\u0432\u043e\u0432" },
            { "scr", "\u0441\u0435\u0439\u0448\u0435\u043b\u044c\u0441\u043a\u0430\u044f \u0440\u0443\u043f\u0438\u044f" },
            { "sdd", "\u0421\u0443\u0434\u0430\u043d\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "sdg", "\u0441\u0443\u0434\u0430\u043d\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "sdp", "\u0421\u0442\u0430\u0440\u044b\u0439 \u0441\u0443\u0434\u0430\u043d\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "sek", "\u0448\u0432\u0435\u0434\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "sgd", "\u0441\u0438\u043d\u0433\u0430\u043f\u0443\u0440\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "shp", "\u0444\u0443\u043d\u0442 \u043e\u0441\u0442\u0440\u043e\u0432\u0430 \u0421\u0432\u044f\u0442\u043e\u0439 \u0415\u043b\u0435\u043d\u044b" },
            { "sit", "\u0421\u043b\u043e\u0432\u0435\u043d\u0441\u043a\u0438\u0439 \u0442\u043e\u043b\u0430\u0440" },
            { "skk", "\u0421\u043b\u043e\u0432\u0430\u0446\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430" },
            { "sll", "\u043b\u0435\u043e\u043d\u0435" },
            { "sos", "\u0441\u043e\u043c\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0439 \u0448\u0438\u043b\u043b\u0438\u043d\u0433" },
            { "srd", "\u0441\u0443\u0440\u0438\u043d\u0430\u043c\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "srg", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c\u0441\u043a\u0438\u0439 \u0433\u0443\u043b\u044c\u0434\u0435\u043d" },
            { "ssp", "\u044e\u0436\u043d\u043e\u0441\u0443\u0434\u0430\u043d\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "std", "\u0434\u043e\u0431\u0440\u0430 \u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438 (1977\u20132017)" },
            { "stn", "\u0434\u043e\u0431\u0440\u0430 \u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "sur", "\u0420\u0443\u0431\u043b\u044c \u0421\u0421\u0421\u0420" },
            { "svc", "\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440\u0441\u043a\u0438\u0439 \u043a\u043e\u043b\u043e\u043d" },
            { "syp", "\u0441\u0438\u0440\u0438\u0439\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442" },
            { "szl", "\u0441\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434\u0441\u043a\u0438\u0439 \u043b\u0438\u043b\u0430\u043d\u0433\u0435\u043d\u0438" },
            { "thb", "\u0442\u0430\u0438\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0439 \u0431\u0430\u0442" },
            { "tjr", "\u0422\u0430\u0434\u0436\u0438\u043a\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c" },
            { "tjs", "\u0442\u0430\u0434\u0436\u0438\u043a\u0441\u043a\u0438\u0439 \u0441\u043e\u043c\u043e\u043d\u0438" },
            { "tmm", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442" },
            { "tmt", "\u043d\u043e\u0432\u044b\u0439 \u0442\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u043a\u0438\u0439 \u043c\u0430\u043d\u0430\u0442" },
            { "tnd", "\u0442\u0443\u043d\u0438\u0441\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "top", "\u0442\u043e\u043d\u0433\u0430\u043d\u0441\u043a\u0430\u044f \u043f\u0430\u0430\u043d\u0433\u0430" },
            { "tpe", "\u0422\u0438\u043c\u043e\u0440\u0441\u043a\u043e\u0435 \u044d\u0441\u043a\u0443\u0434\u043e" },
            { "trl", "\u0422\u0443\u0440\u0435\u0446\u043a\u0430\u044f \u043b\u0438\u0440\u0430 (1922\u20132005)" },
            { "try", "\u0442\u0443\u0440\u0435\u0446\u043a\u0430\u044f \u043b\u0438\u0440\u0430" },
            { "ttd", "\u0434\u043e\u043b\u043b\u0430\u0440 \u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434\u0430 \u0438 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "twd", "\u043d\u043e\u0432\u044b\u0439 \u0442\u0430\u0439\u0432\u0430\u043d\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "tzs", "\u0442\u0430\u043d\u0437\u0430\u043d\u0438\u0439\u0441\u043a\u0438\u0439 \u0448\u0438\u043b\u043b\u0438\u043d\u0433" },
            { "uah", "\u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0430\u044f \u0433\u0440\u0438\u0432\u043d\u0430" },
            { "uak", "\u041a\u0430\u0440\u0431\u043e\u0432\u0430\u043d\u0435\u0446 (\u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0438\u0439)" },
            { "ugs", "\u0421\u0442\u0430\u0440\u044b\u0439 \u0443\u0433\u0430\u043d\u0434\u0438\u0439\u0441\u043a\u0438\u0439 \u0448\u0438\u043b\u043b\u0438\u043d\u0433" },
            { "ugx", "\u0443\u0433\u0430\u043d\u0434\u0438\u0439\u0441\u043a\u0438\u0439 \u0448\u0438\u043b\u043b\u0438\u043d\u0433" },
            { "usd", "\u0434\u043e\u043b\u043b\u0430\u0440 \u0421\u0428\u0410" },
            { "usn", "\u0414\u043e\u043b\u043b\u0430\u0440 \u0421\u0428\u0410 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0434\u043d\u044f" },
            { "uss", "\u0414\u043e\u043b\u043b\u0430\u0440 \u0421\u0428\u0410 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0434\u043d\u044f" },
            { "uyi", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u043a\u0438\u0439 \u043f\u0435\u0441\u043e (\u0438\u043d\u0434\u0435\u043a\u0441 \u0438\u043d\u0444\u043b\u044f\u0446\u0438\u0438)" },
            { "uyp", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u043a\u043e\u0435 \u0441\u0442\u0430\u0440\u043e\u0435 \u043f\u0435\u0441\u043e (1975\u20131993)" },
            { "uyu", "\u0443\u0440\u0443\u0433\u0432\u0430\u0439\u0441\u043a\u0438\u0439 \u043f\u0435\u0441\u043e" },
            { "uzs", "\u0443\u0437\u0431\u0435\u043a\u0441\u043a\u0438\u0439 \u0441\u0443\u043c" },
            { "veb", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u044c\u0441\u043a\u0438\u0439 \u0431\u043e\u043b\u0438\u0432\u0430\u0440 (1871\u20132008)" },
            { "vef", "\u0432\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u044c\u0441\u043a\u0438\u0439 \u0431\u043e\u043b\u0438\u0432\u0430\u0440 (2008\u20132018)" },
            { "ves", "\u0432\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u044c\u0441\u043a\u0438\u0439 \u0431\u043e\u043b\u0438\u0432\u0430\u0440" },
            { "vnd", "\u0432\u044c\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0438\u0439 \u0434\u043e\u043d\u0433" },
            { "vuv", "\u0432\u0430\u0442\u0443 \u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "wst", "\u0441\u0430\u043c\u043e\u0430\u043d\u0441\u043a\u0430\u044f \u0442\u0430\u043b\u0430" },
            { "xaf", "\u0444\u0440\u0430\u043d\u043a \u041a\u0424\u0410 BEAC" },
            { "xag", "\u0421\u0435\u0440\u0435\u0431\u0440\u043e" },
            { "xau", "\u0417\u043e\u043b\u043e\u0442\u043e" },
            { "xba", "\u0415\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430\u044f \u0441\u043e\u0441\u0442\u0430\u0432\u043d\u0430\u044f \u0435\u0434\u0438\u043d\u0438\u0446\u0430" },
            { "xbb", "\u0415\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430\u044f \u0434\u0435\u043d\u0435\u0436\u043d\u0430\u044f \u0435\u0434\u0438\u043d\u0438\u0446\u0430" },
            { "xbc", "\u0440\u0430\u0441\u0447\u0435\u0442\u043d\u0430\u044f \u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0433\u043e \u0432\u0430\u043b\u044e\u0442\u043d\u043e\u0433\u043e \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f (XBC)" },
            { "xbd", "\u0440\u0430\u0441\u0447\u0435\u0442\u043d\u0430\u044f \u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0433\u043e \u0432\u0430\u043b\u044e\u0442\u043d\u043e\u0433\u043e \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f (XBD)" },
            { "xcd", "\u0432\u043e\u0441\u0442\u043e\u0447\u043d\u043e-\u043a\u0430\u0440\u0438\u0431\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "xdr", "\u0421\u0414\u0420 (\u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0440\u0430\u0432\u0430 \u0437\u0430\u0438\u043c\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u0438\u044f)" },
            { "xeu", "\u042d\u041a\u042e (\u0435\u0434\u0438\u043d\u0438\u0446\u0430 \u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e\u0439 \u0432\u0430\u043b\u044e\u0442\u044b)" },
            { "xfo", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439 \u0437\u043e\u043b\u043e\u0442\u043e\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "xfu", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439 UIC-\u0444\u0440\u0430\u043d\u043a" },
            { "xof", "\u0444\u0440\u0430\u043d\u043a \u041a\u0424\u0410 \u0412\u0421\u0415\u0410\u041e" },
            { "xpd", "\u041f\u0430\u043b\u043b\u0430\u0434\u0438\u0439" },
            { "xpf", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0439 \u0442\u0438\u0445\u043e\u043e\u043a\u0435\u0430\u043d\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "xpt", "\u041f\u043b\u0430\u0442\u0438\u043d\u0430" },
            { "xre", "\u0435\u0434\u0438\u043d\u0438\u0446\u0430 RINET-\u0444\u043e\u043d\u0434\u043e\u0432" },
            { "xts", "\u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0432\u0430\u043b\u044e\u0442\u043d\u044b\u0439 \u043a\u043e\u0434" },
            { "xxx", "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u0432\u0430\u043b\u044e\u0442\u0430" },
            { "ydd", "\u0419\u0435\u043c\u0435\u043d\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "yer", "\u0439\u0435\u043c\u0435\u043d\u0441\u043a\u0438\u0439 \u0440\u0438\u0430\u043b" },
            { "yud", "\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u043a\u0438\u0439 \u0442\u0432\u0435\u0440\u0434\u044b\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "yum", "\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u043a\u0438\u0439 \u043d\u043e\u0432\u044b\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "yun", "\u042e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440" },
            { "zal", "\u042e\u0436\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u0440\u044d\u043d\u0434 (\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0439)" },
            { "zar", "\u044e\u0436\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0439 \u0440\u044d\u043d\u0434" },
            { "zmk", "\u041a\u0432\u0430\u0447\u0430 (\u0437\u0430\u043c\u0431\u0438\u0439\u0441\u043a\u0430\u044f) (1968\u20132012)" },
            { "zmw", "\u0437\u0430\u043c\u0431\u0438\u0439\u0441\u043a\u0430\u044f \u043a\u0432\u0430\u0447\u0430" },
            { "zrn", "\u041d\u043e\u0432\u044b\u0439 \u0437\u0430\u0438\u0440" },
            { "zrz", "\u0417\u0430\u0438\u0440" },
            { "zwd", "\u0414\u043e\u043b\u043b\u0430\u0440 \u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "zwl", "\u0414\u043e\u043b\u043b\u0430\u0440 \u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435 (2009)" },
        };
        return data;
    }
}
