/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.BytecodeGenerator;
import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureHeader;
import com.ibm.j9ddr.StructureTypeManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.stream.ImageInputStream;

public class StructureReader {
    public static final int VERSION = 1;
    public static final int J9_STRUCTURES_EYECATCHER = -87105864;
    private Map<String, StructureDescriptor> structures = null;
    private String packageDotBaseName;
    private String pointerDotName;
    private String pointerSlashName;
    private String structureDotName;
    private String structureSlashName;
    private static final Logger logger = Logger.getLogger("j9ddr.structure_reader");
    private StructureHeader header;
    public static final Class<?>[] STRUCTURE_CONSTRUCTOR_SIGNATURE = new Class[]{Long.TYPE};
    public static final byte BIT_FIELD_FORMAT_LITTLE_ENDIAN = 1;
    public static final byte BIT_FIELD_FORMAT_BIG_ENDIAN = 2;
    public static final int BIT_FIELD_CELL_SIZE = 32;
    private static final Pattern MULTI_LINE_COMMENT_PATTERN = Pattern.compile(Pattern.quote("/*") + ".*?" + Pattern.quote("*/"), 32);
    private static final Pattern SINGLE_LINE_COMMENT_PATTERN = Pattern.compile(Pattern.quote("//") + ".*$", 8);
    private static final Pattern MAP_PATTERN = Pattern.compile("(.*?)=(.*?)$", 8);
    private Long packageVersion;
    private String basePackage = "com.ibm.j9ddr.vm";
    private final StructureTypeManager typeManager;
    private static final Pattern CONTENTS_OF_ARRAY_PATTERN = Pattern.compile("(?<=\\[).*?(?=\\])");
    private static final Pattern SPACES_AFTER_SQUARE_BRACKETS_PATTERN = Pattern.compile("(?<=\\])\\s+");
    private static final Pattern SPACES_BEFORE_SQUARE_BRACKETS_PATTERN = Pattern.compile("\\s+(?=\\[)");
    private static final Pattern SPACES_AFTER_ASTERISKS_PATTERN = Pattern.compile("(?<=\\*)\\s+");
    private static final Pattern SPACES_BEFORE_ASTERISKS_PATTERN = Pattern.compile("\\s+(?=\\*)");
    private static final String VM_MAJOR_VERSION = "VM_MAJOR_VERSION";
    private static final String VM_MINOR_VERSION = "VM_MINOR_VERSION";
    private static final String ARM_SPLIT_DDR_HACK = "ARM_SPLIT_DDR_HACK";
    private static final String DDRALGORITHM_STRUCTURE_NAME = "DDRAlgorithmVersions";
    public static final String DDR_VERSIONED_PACKAGE_PREFIX = "com.ibm.j9ddr.vm";

    public StructureReader(ImageInputStream in) throws IOException {
        this.parse(in);
        this.setStream();
        this.applyAliases();
        this.typeManager = new StructureTypeManager(this.getStructures());
    }

    public StructureReader(InputStream in) throws IOException {
        this.parse(in);
        this.setStream();
        this.typeManager = new StructureTypeManager(this.getStructures());
    }

    public StructureHeader getHeader() {
        return this.header;
    }

    private void setStream() {
        StructureDescriptor version = this.structures.get(DDRALGORITHM_STRUCTURE_NAME);
        long vmMajorVersion = 2L;
        long vmMinorVersion = 3L;
        String versionFormat = "%2d";
        if (version != null) {
            for (ConstantDescriptor constant : version.getConstants()) {
                String constantName = constant.getName();
                if (constantName.equals(VM_MAJOR_VERSION)) {
                    vmMajorVersion = constant.getValue();
                    continue;
                }
                if (constantName.equals(VM_MINOR_VERSION)) {
                    vmMinorVersion = constant.getValue() / 10L;
                    continue;
                }
                if (!constantName.equals(ARM_SPLIT_DDR_HACK) || constant.getValue() != 1L) continue;
                versionFormat = "%2d_00";
            }
        }
        this.packageVersion = vmMajorVersion * 10L + vmMinorVersion;
        String versionSuffix = String.format(versionFormat, this.packageVersion);
        this.packageDotBaseName = DDR_VERSIONED_PACKAGE_PREFIX + versionSuffix;
        this.pointerDotName = this.packageDotBaseName + ".pointer.generated";
        this.pointerSlashName = this.pointerDotName.replace('.', '/') + "/";
        this.structureDotName = this.packageDotBaseName + ".structure";
        this.structureSlashName = this.structureDotName.replace('.', '/') + "/";
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public long getPackageVersion() {
        if (this.packageVersion == null) {
            throw new IllegalStateException("The DDR version information is not yet available");
        }
        return this.packageVersion;
    }

    public String getPackageName(PackageNameType type2) {
        if (this.packageVersion == null) {
            throw new IllegalStateException("The DDR version information is not yet available");
        }
        switch (type2) {
            case PACKAGE_DOT_BASE_NAME: {
                return this.packageDotBaseName;
            }
            case POINTER_PACKAGE_DOT_NAME: {
                return this.pointerDotName;
            }
            case POINTER_PACKAGE_SLASH_NAME: {
                return this.pointerSlashName;
            }
            case STRUCTURE_PACKAGE_DOT_NAME: {
                return this.structureDotName;
            }
            case STRUCTURE_PACKAGE_SLASH_NAME: {
                return this.structureSlashName;
            }
        }
        throw new IllegalStateException("Unexpected PackageNameType");
    }

    private void applyAliases() throws IOException {
        Map<String, String> aliasMap = this.loadAliasMap();
        for (StructureDescriptor thisStruct : this.structures.values()) {
            for (FieldDescriptor thisField : thisStruct.fields) {
                thisField.applyAliases(aliasMap);
            }
        }
    }

    private Map<String, String> loadAliasMap() throws IOException {
        String mapData = this.loadAliasMapData();
        mapData = StructureReader.stripComments(mapData);
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        Matcher mapMatcher = MAP_PATTERN.matcher(mapData);
        while (mapMatcher.find()) {
            String from = mapMatcher.group(1);
            String to = mapMatcher.group(2);
            aliasMap.put(from.trim(), to.trim());
        }
        return Collections.unmodifiableMap(aliasMap);
    }

    private static String stripComments(String mapData) {
        mapData = StructureReader.filterOutPattern(mapData, MULTI_LINE_COMMENT_PATTERN);
        mapData = StructureReader.filterOutPattern(mapData, SINGLE_LINE_COMMENT_PATTERN);
        return mapData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadAliasMapData() throws IOException {
        String streamAliasMapResource;
        InputStream is;
        String resourceNameFormat = "/com/ibm/j9ddr/StructureAliases%d%s.dat";
        String variant = "";
        if (this.packageVersion == 29L && !this.getBuildFlagValue("J9BuildFlags", "J9VM_OPT_USE_OMR_DDR", false)) {
            variant = "-edg";
        }
        if (null == (is = StructureReader.class.getResourceAsStream(streamAliasMapResource = String.format(resourceNameFormat, this.packageVersion, variant)))) {
            throw new RuntimeException("Failed to load alias map from resource: " + streamAliasMapResource + " - cannot continue");
        }
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            int read;
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[4096];
            while ((read = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, read);
            }
            String string = builder.toString();
            return string;
        }
    }

    public Set<String> getStructureNames() {
        return this.structures.keySet();
    }

    public boolean hasStructure(String name) {
        return this.structures.containsKey(name);
    }

    public int getStructureSizeOf(String structureName) {
        if (!this.hasStructure(structureName)) {
            return 0;
        }
        return this.structures.get(structureName).getSizeOf();
    }

    public Collection<StructureDescriptor> getStructures() {
        return this.structures.values();
    }

    public List<FieldDescriptor> getFields(String structureName) {
        StructureDescriptor structure = this.structures.get(structureName);
        if (structure == null) {
            throw new IllegalArgumentException("The structure [" + structureName + "] was not found");
        }
        return structure.fields;
    }

    public List<ConstantDescriptor> getConstants(String structureName) {
        StructureDescriptor structure = this.structures.get(structureName);
        if (structure == null) {
            throw new IllegalArgumentException("The structure [" + structureName + "] was not found");
        }
        return structure.constants;
    }

    private void parse(InputStream inputStream) throws IOException {
        this.header = new StructureHeader(inputStream);
        this.structures = new HashMap<String, StructureDescriptor>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = reader.readLine();
        StructureDescriptor structure = null;
        while (line != null) {
            if (line.isEmpty()) continue;
            char type2 = line.charAt(0);
            switch (type2) {
                case 'S': {
                    structure = new StructureDescriptor(line);
                    this.structures.put(structure.getName(), structure);
                    break;
                }
                case 'F': {
                    if (structure == null) {
                        throw new IllegalArgumentException("Superset stream is missing structure start line");
                    }
                    Collection<FieldDescriptor> fields = FieldDescriptor.inflate(line);
                    structure.fields.addAll(fields);
                    break;
                }
                case 'C': {
                    if (structure == null) {
                        throw new IllegalArgumentException("Superset stream is missing structure start line");
                    }
                    ConstantDescriptor constant = new ConstantDescriptor(line);
                    structure.constants.add(constant);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Superset stream contained unknown line: %s", line));
                }
            }
            line = reader.readLine();
        }
    }

    public void addStructures(ImageInputStream ddrStream) throws IOException {
        StructureHeader fragmentHeader = new StructureHeader(ddrStream);
        this.checkBlobVersion();
        if (this.header.getSizeofBool() != fragmentHeader.getSizeofBool()) {
            throw new IOException("Invalid fragment definition : size of boolean is not the same");
        }
        if (this.header.getSizeofUDATA() != fragmentHeader.getSizeofUDATA()) {
            throw new IOException("Invalid fragment definition : size of UDATA is not the same");
        }
        this.parseStructures(ddrStream, fragmentHeader);
    }

    private void parse(ImageInputStream ddrStream) throws IOException {
        logger.logp(Level.FINE, null, null, "Parsing structures. Start address = {0}", Long.toHexString(ddrStream.getStreamPosition()));
        this.header = new StructureHeader(ddrStream);
        this.checkBlobVersion();
        this.parseStructures(ddrStream, this.header);
    }

    private void checkBlobVersion() throws IOException {
        logger.logp(Level.FINE, null, null, "Stream core structure version = {0}", this.header.getCoreVersion());
        if (this.header.getCoreVersion() > 1) {
            throw new IOException("Core structure version " + this.header.getCoreVersion() + " > StructureReader version 1");
        }
    }

    private void parseStructures(ImageInputStream ddrStream, StructureHeader header) throws IOException {
        logger.logp(Level.FINER, (String)null, (String)null, "structDataSize={0}, stringTableDataSize={1}, structureCount={2}", new Object[]{header.getStructDataSize(), header.getStringTableDataSize(), header.getStructureCount()});
        long ddrStringTableStart = ddrStream.getStreamPosition() + (long)header.getStructDataSize();
        logger.logp(Level.FINER, null, null, "ddrStringTableStart=0x{0}", Long.toHexString(ddrStringTableStart));
        if (this.structures == null) {
            this.structures = new HashMap<String, StructureDescriptor>(header.getStructureCount());
        }
        for (int i = 0; i < header.getStructureCount(); ++i) {
            int j;
            logger.logp(Level.FINER, null, null, "Reading structure on iteration {0}", i);
            StructureDescriptor structure = new StructureDescriptor();
            structure.name = StructureReader.readString(ddrStream, ddrStringTableStart);
            if (structure.name == null) {
                logger.logp(Level.FINE, null, null, "Structure name was null for structure {0}", i);
                throw new IllegalArgumentException(String.format("Structure name was null for structure %d", i));
            }
            if (structure.name.isEmpty()) {
                logger.logp(Level.FINE, null, null, "Structure name was blank for structure {0}", i);
                throw new IllegalArgumentException(String.format("No name found for structure %d", i));
            }
            structure.name = structure.name.replace("__", "$");
            logger.logp(Level.FINE, null, null, "Reading structure {0}", structure.name);
            structure.pointerName = structure.name + "Pointer";
            structure.superName = StructureReader.readString(ddrStream, ddrStringTableStart);
            structure.superName = structure.superName.replace("__", "$");
            structure.sizeOf = ddrStream.readInt();
            int numberOfFields = ddrStream.readInt();
            structure.fields = new ArrayList<FieldDescriptor>(numberOfFields);
            int numberOfConstants = ddrStream.readInt();
            structure.constants = new ArrayList<ConstantDescriptor>(numberOfConstants);
            logger.logp(Level.FINER, (String)null, (String)null, "{0} super {1} sizeOf {2}", new Object[]{structure.name, structure.superName, structure.sizeOf});
            for (j = 0; j < numberOfFields; ++j) {
                String declaredName = StructureReader.readString(ddrStream, ddrStringTableStart);
                String name = declaredName.replace(".", "$");
                String declaredType = StructureReader.readString(ddrStream, ddrStringTableStart);
                if (name.equals("hashCode")) {
                    name = "_hashCode";
                }
                int offset = ddrStream.readInt();
                FieldDescriptor field = new FieldDescriptor(offset, declaredType, declaredType, name, declaredName);
                structure.fields.add(field);
                logger.logp(Level.FINEST, (String)null, (String)null, "Field: {0}.{1} offset {2}, declaredType {3}", new Object[]{structure.name, name, offset, declaredType, declaredType});
            }
            for (j = 0; j < numberOfConstants; ++j) {
                String name = StructureReader.readString(ddrStream, ddrStringTableStart);
                long value = ddrStream.readLong();
                ConstantDescriptor constant = new ConstantDescriptor(name, value);
                structure.constants.add(constant);
                logger.logp(Level.FINEST, (String)null, (String)null, "Constant: {0}.{1}={2}", new Object[]{structure.name, name, value});
            }
            this.structures.put(structure.name, structure);
        }
        logger.logp(Level.FINE, null, null, "Finished parsing structures");
    }

    private static String readString(ImageInputStream ddrStream, long ddrStringTableStart) {
        try {
            int stringOffset = ddrStream.readInt();
            if (stringOffset == -1) {
                return "";
            }
            long pos = ddrStream.getStreamPosition();
            long seekPos = ddrStringTableStart + (long)stringOffset;
            ddrStream.seek(seekPos);
            int length = ddrStream.readUnsignedShort();
            if (length > 200) {
                throw new IOException(String.format("Improbable string length: %d", length));
            }
            byte[] buffer = new byte[length];
            int read = ddrStream.read(buffer);
            if (read != length) {
                throw new IOException("StructureReader readString() Failed to read " + length + " at " + Long.toHexString(seekPos) + ". Result: " + read);
            }
            String result = new String(buffer, StandardCharsets.UTF_8);
            ddrStream.seek(pos);
            return result;
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            logger.logp(Level.FINE, null, null, sw.toString());
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getStructureClassBytes(String binaryName) throws ClassNotFoundException {
        String clazzName = binaryName.substring(binaryName.lastIndexOf(46) + 1);
        StructureDescriptor structure = this.structures.get(clazzName);
        if (structure == null) {
            throw new ClassNotFoundException(String.format("%s is not in core file.", clazzName));
        }
        String fullClassName = this.getPackageName(PackageNameType.STRUCTURE_PACKAGE_SLASH_NAME) + clazzName;
        return BytecodeGenerator.getStructureClassBytes(structure, fullClassName);
    }

    public byte[] getPointerClassBytes(String binaryName) throws ClassNotFoundException {
        String clazzName = binaryName.substring(binaryName.lastIndexOf(46) + 1);
        String structureName = clazzName.endsWith("Pointer") ? clazzName.substring(0, clazzName.length() - 7) : clazzName;
        StructureDescriptor structure = this.structures.get(structureName);
        if (structure == null) {
            throw new ClassNotFoundException(String.format("%s is not in core file.", clazzName));
        }
        String fullClassName = this.getPackageName(PackageNameType.POINTER_PACKAGE_SLASH_NAME) + clazzName;
        return BytecodeGenerator.getPointerClassBytes(this, this.typeManager, structure, fullClassName);
    }

    public long getConstantValue(String structureName, String constantName, long defaultValue) {
        if (constantName.equals("SIZEOF")) {
            return this.getStructureSizeOf(structureName);
        }
        for (ConstantDescriptor constant : this.getConstants(structureName)) {
            if (!constant.getName().equals(constantName)) continue;
            return constant.getValue();
        }
        return defaultValue;
    }

    public boolean getBuildFlagValue(String structureName, String constantName, boolean defaultValue) {
        long defaultLongValue = defaultValue ? 1L : 0L;
        long value = this.getConstantValue(structureName, constantName, defaultLongValue);
        return value != 0L;
    }

    public byte getSizeOfBool() {
        return this.header.getSizeofBool();
    }

    public byte getSizeOfUDATA() {
        return this.header.getSizeofUDATA();
    }

    public byte getBitFieldFormat() {
        return this.header.getBitfieldFormat();
    }

    public static String simplifyType(String type2) {
        String working = type2;
        working = StructureReader.filterOutPattern(working, CONTENTS_OF_ARRAY_PATTERN);
        working = StructureReader.filterOutPattern(working, SPACES_BEFORE_SQUARE_BRACKETS_PATTERN);
        working = StructureReader.filterOutPattern(working, SPACES_AFTER_SQUARE_BRACKETS_PATTERN);
        working = StructureReader.filterOutPattern(working, SPACES_BEFORE_ASTERISKS_PATTERN);
        working = StructureReader.filterOutPattern(working, SPACES_AFTER_ASTERISKS_PATTERN);
        return working;
    }

    static String filterOutPattern(String input, Pattern pattern) {
        return pattern.matcher(input).replaceAll("");
    }

    public static class FieldDescriptor
    implements Comparable<FieldDescriptor> {
        String type;
        String declaredType;
        String name;
        String declaredName;
        int offset;
        private static final Pattern QualifierPattern = Pattern.compile("\\s*\\b(const|volatile)\\b\\s*");
        private static final Pattern ScalarPattern = Pattern.compile("\\b([IU])_(?=\\d+|DATA\\b)");

        public FieldDescriptor(int offset, String type2, String declaredType, String name, String declaredName) {
            this.type = type2;
            this.declaredType = declaredType;
            this.name = name;
            this.offset = offset;
            this.declaredName = declaredName;
        }

        public void applyAliases(Map<String, String> aliasMap) {
            this.type = FieldDescriptor.unalias(this.declaredType, aliasMap);
            this.cleanUpTypes();
        }

        public void cleanUpTypes() {
            this.type = FieldDescriptor.stripUnderscore(this.type);
            this.type = FieldDescriptor.stripTypeQualifiers(this.type);
            this.declaredType = FieldDescriptor.stripUnderscore(this.declaredType);
        }

        private static String stripTypeQualifiers(String type2) {
            return StructureReader.filterOutPattern(type2, QualifierPattern).trim();
        }

        private static String stripUnderscore(String type2) {
            return ScalarPattern.matcher(type2).replaceAll("$1");
        }

        private static String unalias(String type2, Map<String, String> aliasMap) {
            CTypeParser parser = new CTypeParser(type2);
            String result = parser.getCoreType();
            if (aliasMap.containsKey(result)) {
                result = aliasMap.get(result);
            }
            return parser.getPrefix() + result + parser.getSuffix();
        }

        public String getName() {
            return this.name;
        }

        public String getDeclaredName() {
            return this.declaredName;
        }

        public String getType() {
            return this.type;
        }

        public String getDeclaredType() {
            return this.declaredType;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.type + " " + this.name + " Offset: " + this.offset;
        }

        @Override
        public int compareTo(FieldDescriptor o) {
            return this.getName().compareTo(o.getName());
        }

        public static Collection<FieldDescriptor> inflate(String line) {
            String[] parts = line.split("\\|");
            if (parts.length < 5 || (parts.length - 3) % 2 != 0) {
                throw new IllegalArgumentException(String.format("Superset file line is invalid: %s", line));
            }
            int count = (parts.length - 3) / 2;
            ArrayList<FieldDescriptor> result = new ArrayList<FieldDescriptor>(count);
            String declaredName = parts[2];
            for (int i = 0; i < count; ++i) {
                Object fieldName = parts[1];
                if (i > 0) {
                    fieldName = (String)fieldName + "_v" + i;
                }
                FieldDescriptor fd = new FieldDescriptor(0, parts[3 + i * 2], parts[4 + i * 2], (String)fieldName, declaredName);
                result.add(fd);
            }
            return result;
        }

        public String deflate() {
            StringBuilder result = new StringBuilder();
            result.append("F|");
            result.append(this.getName());
            result.append("|");
            result.append(this.getDeclaredName());
            result.append("|");
            result.append(StructureReader.simplifyType(this.getType()));
            result.append("|");
            result.append(StructureReader.simplifyType(this.getDeclaredType()));
            return result.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof FieldDescriptor)) {
                return false;
            }
            FieldDescriptor compareTo = (FieldDescriptor)obj;
            return compareTo.deflate().equals(this.deflate());
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class ConstantDescriptor
    implements Comparable<ConstantDescriptor> {
        String name;
        long value;

        public ConstantDescriptor(String name, long value) {
            this.name = name;
            this.value = value;
        }

        public ConstantDescriptor(String line) {
            this.inflate(line);
        }

        public String toString() {
            return this.name + " = " + this.value;
        }

        public String getName() {
            return this.name;
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public int compareTo(ConstantDescriptor o) {
            return this.getName().compareTo(o.getName());
        }

        private void inflate(String line) {
            String[] parts = line.split("\\|");
            if (parts.length != 2) {
                throw new IllegalArgumentException(String.format("Superset file line is invalid: %s", line));
            }
            this.name = parts[1];
        }

        public String deflate() {
            return "C|" + this.getName();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ConstantDescriptor)) {
                return false;
            }
            ConstantDescriptor compareTo = (ConstantDescriptor)obj;
            return this.name.equals(compareTo.name) && this.value == compareTo.value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class StructureDescriptor {
        String name;
        String superName;
        String pointerName;
        int sizeOf;
        List<FieldDescriptor> fields;
        List<ConstantDescriptor> constants;

        public StructureDescriptor() {
        }

        public StructureDescriptor(String line) {
            this.inflate(line);
        }

        public String toString() {
            if (this.superName == null || this.superName.isEmpty()) {
                return String.valueOf(this.name);
            }
            return this.name + " extends " + this.superName;
        }

        public String getPointerName() {
            return this.name + "Pointer";
        }

        public String getName() {
            return this.name;
        }

        public String getSuperName() {
            return this.superName;
        }

        public List<FieldDescriptor> getFields() {
            return this.fields;
        }

        public List<ConstantDescriptor> getConstants() {
            return this.constants;
        }

        public int getSizeOf() {
            return this.sizeOf;
        }

        private void inflate(String line) {
            String[] parts = line.split("\\|");
            if (parts.length < 3 || parts.length > 4) {
                throw new IllegalArgumentException(String.format("Superset file line is invalid: %s", line));
            }
            this.constants = new ArrayList<ConstantDescriptor>();
            this.fields = new ArrayList<FieldDescriptor>();
            this.name = parts[1];
            this.pointerName = parts[2];
            this.superName = parts.length == 4 ? parts[3] : "";
        }

        public String deflate() {
            StringBuilder result = new StringBuilder();
            result.append("S|");
            result.append(this.getName());
            result.append("|");
            result.append(this.getPointerName());
            result.append("|");
            result.append(this.getSuperName());
            return result.toString();
        }
    }

    public static enum PackageNameType {
        PACKAGE_DOT_BASE_NAME,
        POINTER_PACKAGE_DOT_NAME,
        POINTER_PACKAGE_SLASH_NAME,
        STRUCTURE_PACKAGE_DOT_NAME,
        STRUCTURE_PACKAGE_SLASH_NAME;

    }
}

