/*
 * Copyright (c) 1986-2007 Purdue University
 * All rights reserved.
 * 
 * Developed by:  Daniel Trinkle
 *                Department of Computer Science, Purdue University
 *                http://www.cs.purdue.edu/
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal with the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * o Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimers.
 * 
 * o Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimers in the
 *   documentation and/or other materials provided with the distribution.
 * 
 * o Neither the names of Daniel Trinkle, Purdue University, nor the
 *   names of its contributors may be used to endorse or promote products
 *   derived from this Software without specific prior written
 *   permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE SOFTWARE.
 */

/*
 * detex [-e environment-list] [-c] [-l] [-n] [-s] [-t] [-w] [-1] [file[.tex] ]
 *
 *	This program is used to remove TeX or LaTeX constructs from a text
 *	file.
 */

#include "detex.h"

#ifdef KPATHSEA

#include <c-auto.h>
#include <kpathsea/c-auto.h>
#include <kpathsea/config.h>
#include <kpathsea/c-memstr.h>
#include <kpathsea/c-pathmx.h>
#include <kpathsea/c-std.h>
#include <kpathsea/tex-file.h>

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#else /* KPATHSEA */

#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#define	strrchr rindex
#endif

#ifdef HAVE_LIMITS_H
#include <limits.h>
#else
#include <sys/param.h>
#ifndef PATH_MAX /* for old BSD */
#define PATH_MAX MAXPATHLEN
#endif
#endif /* HAVE_LIMITS_H */

#ifdef OS2
#include <stdlib.h>
#endif

#ifdef WIN32
#include <fcntl.h>
#include <io.h>
#endif

#endif /* KPATHSEA */

#line 91 "lex.yy.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 173
#define YY_END_OF_BUFFER 174
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[1361] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  144,  144,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  166,  166,    0,    0,    0,    0,    0,    0,
      139,  139,    0,    0,  174,  173,   92,   91,   90,  107,
      105,  107,  106,  107,  107,  119,  122,  121,  120,  128,
      130,  129,  113,  110,  109,  112,  113,  113,  158,  158,
      159,  158,  158,  108,    1,  158,  158,  158,  157,  158,
      146,  151,  154,  146,  155,  148,  145,  144,  142,  141,
      145,  145,  143,   12,   12,  173,   11,   12,  102,  100,

      101,  102,  102,   18,   16,   17,   15,   14,   15,   97,
       95,   96,   97,   97,  115,  117,  116,  124,  126,  125,
      164,  161,  162,  163,  166,  165,  170,  167,  168,  169,
      172,  171,    6,    6,    7,  139,   44,   43,   46,  104,
        0,    0,    0,    0,    0,    0,    0,  119,  121,  128,
      129,  111,    0,    0,    0,    0,    0,    0,    0,  160,
        0,  147,  103,    1,  152,  153,  149,  157,    0,  156,
      138,  136,   93,  135,  135,  135,  135,   98,  137,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  150,    0,    0,

        0,  144,  143,  141,  141,    0,  140,    0,    0,   11,
        0,    0,    0,    0,    0,   99,    0,    0,    0,    0,
        0,    0,    0,   16,   14,    0,   94,    0,    0,    0,
        0,    0,    0,    0,  115,  116,  124,  125,  163,  166,
        6,    0,   44,    0,   45,    0,  106,    0,    0,    0,
        0,    0,    0,    0,  112,    0,    0,    0,    0,    0,
        0,    0,  149,  156,  135,  135,  133,  133,  137,    0,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,

      135,  135,  135,  135,  135,    0,    0,    0,    0,    0,
        0,    0,    0,  101,    0,    0,    0,    0,    0,    0,
        0,    0,   96,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  132,
      132,    0,  137,  135,  135,  135,  135,  135,  135,   89,
      135,   71,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
       78,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   13,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  135,  135,  135,  135,  135,  135,  135,
      135,  135,   67,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,   57,  135,  135,
      135,  135,  135,  135,   33,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,   85,
      135,  135,   25,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   67,  135,  135,  135,  135,

        3,  135,  135,  135,  135,   48,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,   73,  127,    0,    0,
        0,    0,    0,   74,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,   57,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  131,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  106,    0,  112,    0,  135,  135,  135,
      135,  135,    0,    0,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,    0,    0,    0,    0,    0,

      135,  135,  135,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   19,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,   37,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,   35,  135,    0,
        0,    0,    0,    0,  135,    0,    0,    0,    0,    0,
      101,    0,   96,    0,    0,    0,    0,  135,  135,  135,
      135,  135,    0,    0,   64,  135,  135,   58,  135,  135,
      135,  135,  135,  135,  135,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   22,    0,    0,    0,

      135,  114,    0,   19,   19,  135,   75,  135,  135,  135,
      135,  135,  135,   76,  135,  135,  135,  135,  135,  135,
      135,   34,  135,   59,  135,  135,  135,  135,  135,  135,
      123,  135,  135,  135,  135,  135,  135,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   20,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  135,  135,  135,  135,  135,    0,  135,   66,   58,
       50,  135,  135,  135,   53,   83,  135,    0,   22,   22,
       22,   22,    0,    0,    0,    0,    0,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,   36,

      135,  135,  135,  135,   38,   59,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,    0,   20,
       20,   20,   20,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  135,  135,  135,  135,  135,    0,
      135,  135,  135,  135,   51,    0,   84,    0,    0,   22,
       22,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  135,  135,  135,  134,  135,  135,  135,
       26,  135,   52,   77,   62,  135,  135,   39,   41,  135,
       27,  135,  135,  135,  135,  135,  135,  135,   49,  135,
      135,    0,    0,   20,   20,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    8,
        9,    0,    4,    0,  135,  135,  135,  135,    0,    0,
        0,  135,  135,  135,  135,    0,    0,    0,   22,   22,
        0,    0,    0,    0,    0,   23,   72,  135,  135,    0,
       86,   81,  135,   32,   62,   40,  135,   39,   79,   31,
      135,   29,  135,  135,   60,  135,  135,   70,    0,    0,
       20,   20,    0,    0,    0,    0,    0,   21,   10,    0,
      135,  135,  135,   28,    0,    0,    0,    0,    0,    0,
      135,   47,  135,  135,    0,    0,    0,   22,   22,    0,
        0,    0,    0,  135,  118,    0,  135,  135,   30,   82,

      135,   60,  135,  135,    0,    0,   20,   20,    0,    0,
        0,    0,    0,  135,  135,   80,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   65,
      135,  135,    0,    0,   22,   22,    0,    0,    0,    0,
        0,    0,    0,    0,  135,  134,  135,   87,   63,  135,
      135,    0,    0,   20,   20,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  135,  135,    0,    0,    0,    0,
        0,   24,    0,   69,   68,    0,    0,   22,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   22,    0,    0,    0,    0,  135,  135,

       63,   61,   55,    0,    0,   20,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   20,    0,    0,    0,    0,    0,    5,  135,   54,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   22,    0,   22,
       22,   22,    0,    0,    0,    0,    0,    0,    0,    0,
      135,   88,   61,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   20,    0,   20,   20,   20,
        0,    0,    0,    0,    0,    0,    0,    0,   56,    0,
        0,    0,    0,    0,    2,    0,   22,   22,   22,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   42,    0,
       20,   20,   20,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    2,   22,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   42,   42,   20,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   22,    0,    0,    0,    0,   20,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   22,    0,   20,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   22,    0,   20,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    1,    1,    6,    7,    1,    8,    9,
       10,   11,   12,   13,   14,   15,    1,   16,   16,   16,
       16,   16,   17,   17,   17,   17,   17,    1,    1,   18,
       19,   20,   21,   22,   23,   24,   24,   24,   25,   24,
       24,   24,   24,   24,   24,   26,   24,   24,   27,   24,
       24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
       28,   29,   30,    1,    1,   31,   32,   33,   34,   35,

       36,   37,   38,   39,   40,   26,   41,   42,   43,   44,
       45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
       55,   56,   57,   58,   59,   60,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[61] =
    {   0,
        1,    2,    3,    2,    4,    1,    1,    5,    1,    1,
        1,    1,    6,    7,    1,    7,    7,    1,    7,    1,
        1,    8,    9,    9,    9,    9,    9,    1,   10,   11,
        7,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,   12,    1,   13,    1
    } ;

static const flex_int16_t yy_base[1415] =
    {   0,
        0,    0,    0,    1,    2,    6,   14,   26,   11,   30,
       43,   47,   96,    0,  156,    0,  216,    0,  274,  277,
      326,    0,    7,    8,  384,  387,  389,  392,  395,  406,
       20,  386, 3340, 3339,  398,  409,   39,   44,   16,   35,
     3352, 3351,   21,   25, 3366, 3371, 3371, 3371, 3371, 3371,
     3371, 3359, 3371,  241, 3313,    0, 3371, 3360, 3371,    0,
     3371, 3359, 3371, 3371, 3371, 3371,  272, 3310, 3371, 3358,
     3371, 3330, 3327, 3351,    0, 3348, 3342, 3340,   24, 3345,
      468, 3321,  403, 3371, 3371, 3371, 3371,  527, 3371,    0,
      294,    0, 3294, 3371,  530,  533,    0,  536, 3371, 3371,

     3371,  511, 3299, 3371,    0, 3371, 3371, 3346, 3312, 3371,
     3371, 3371,  418, 3296,    0, 3371, 3343,    0, 3371, 3342,
     3371, 3371, 3371, 3341,    0, 3371, 3371, 3371, 3371, 3371,
     3371, 3371,    0,    0, 3307, 3371,    0, 3371,   91, 3371,
     3306, 3297, 3304, 3307, 3302,    3, 3304,    0, 3333,    0,
     3332, 3371, 3298, 3289, 3296, 3299, 3294,   35, 3296, 3326,
     3293, 3371, 3371,    0, 3371, 3371, 3312,   43, 3317, 3316,
     3371, 3371, 3371,    0,   65,  540,  543, 3371,  271,  269,
       16,  279,  253, 3279,  266,  372,  554, 3286,  560,  255,
      567, 3289,  393,  572,  281, 3271,  273, 3371,  407,  414,

      425,  563, 3262,    0,    0,  558,    0,  572,  591,    0,
      607, 3278, 3277, 3284, 3279, 3371, 3278, 3269, 3276, 3279,
     3274,  360, 3276,    0, 3305, 3263, 3371, 3270, 3261, 3268,
     3271, 3266,  399, 3268,    0, 3297,    0, 3296, 3371,    0,
        0, 3254,    0,  578,  613, 3250, 3371, 3249, 3249, 3247,
     3250,  401, 3243, 3244, 3371, 3243, 3243, 3241, 3244,  515,
     3237, 3245, 3371, 3276,    0,  628,  633, 3371, 3255, 3252,
     3246, 3242, 3246, 3246, 3227, 3234, 3238, 3240, 3238, 3227,
      602,  418, 3225,  605, 3222, 3236, 3224, 3224, 3213,   43,
     3225,  611, 3214, 3211, 3217, 3229,  551, 3228, 3223, 3225,

     3203, 3216, 3219, 3206,  537,  608,  580, 3203, 3214, 3207,
     3217, 3201, 3201, 3371, 3200, 3200, 3198, 3201,  612, 3194,
     3207, 3194, 3371, 3193, 3193, 3191, 3194,  616, 3187, 3200,
     3185, 3184, 3183, 3195, 3181, 3180, 3179, 3191, 3176,  661,
     3371, 3195, 3371,  619, 3184,  510, 3177, 3186, 3176, 3180,
     3168,    0, 3176, 3175, 3166, 3165, 3174, 3181, 3176, 3169,
     3174, 3158, 3164, 3171, 3170, 3169,  632, 3168,  640, 3154,
     3160, 3165, 3160, 3167, 3162, 3143, 3154, 3145,  633, 3145,
     3147,  633, 3142, 3142,  643, 3157, 3149, 3156,  661, 3128,
     3134, 3131, 3117, 3125, 3108, 3107, 3104, 3116, 3371, 3102,

     3101, 3083, 3095,  682, 3080, 3078, 3066, 3033, 3032, 3036,
     3035, 3014, 3025, 3007, 3006, 3003, 2998, 3002, 2984, 2983,
     2972, 2965,    0, 2964, 2967, 2744, 2741, 2746, 2735, 2739,
     2736, 2747, 2732, 2728, 2724, 2727,  694, 2734, 2742, 2726,
     2728, 2727, 2734, 2737,  646, 2730, 2722, 2755, 2729, 2728,
     2710, 2706, 2711, 2727,    0, 2723, 2717, 2711, 2719, 2709,
     2714, 2718, 2711, 2718,  576, 2715, 2702, 2702, 2710,    0,
     2694, 2705, 3371, 2690, 2691, 2700, 2703, 2684, 2693, 2692,
     2677, 2676, 2689, 2688, 2673,  697,  700, 2677, 2671, 2670,
     2683, 2673, 2667, 2666, 2679, 3371, 2669, 2668,  671, 2665,

      712, 2674, 2664, 2653, 2671, 2673, 2669, 2668, 2655, 2666,
     2655, 2654,  715, 2662, 2648, 2661,    0,    0,  731,  709,
      705,  768,    0,    0, 2647, 2658,  685, 2641, 2648, 2639,
     2645, 2653, 2634, 2634, 2627, 3371, 2647, 2645, 2644, 2641,
     2640, 2626, 2637, 2624, 2617, 2623,  702,    0, 2621, 2623,
     2616, 2629, 2629, 2616, 2628, 2605, 2624,  747, 2621, 2619,
     2622,  754, 2603, 2607, 2601, 2600, 2613, 2603, 2597, 2596,
     2609,  763, 2608, 2607, 2594, 2604, 2592, 2588, 2587, 2591,
     2599, 2602,  771,  775, 2590, 2594, 2589, 2578, 2579, 2589,
     2578, 2588, 2588, 2583, 2568,  778,  771,  780,  827,    0,

      821, 2577, 2576,  783,  789,  802, 2565,  401, 2575, 2566,
     2564, 2564,  557, 2560,  818, 2569, 2567, 2560, 2558, 2561,
     2562, 2563, 2555, 2559, 2540, 2562,    0, 2548, 2542, 2546,
     2557, 2556, 2534, 2542, 2542, 2541, 2545, 2546, 2545, 2540,
     2528, 2542, 2545, 2526, 2526, 2532, 2535,    0, 2527,  835,
      818,  810,  877,    0,  880,  855, 2528,  883,  893, 2525,
     2528, 2516, 2526, 2514, 2512, 2508, 2506, 2516, 2514, 2499,
     2505, 2514,  896, 2502,    0, 2498, 2509, 2532, 2487, 2495,
     2489, 2492, 2501, 2501, 2498,  838,  824,  829, 2487,  618,
     2497, 2488, 2482, 2481,  822, 2477,  886,  899,  902,  931,

     2472,  771,  849,  905,  936, 2488,    0, 2487, 2468, 2465,
     2461, 2477, 2463,    0, 2465, 2460, 2449, 2469, 2458, 2446,
     2445,    0, 2435, 2470, 2430, 2428, 2431, 2431, 2435, 2424,
        0, 2424, 2421, 2424, 2414, 2413, 2415,  934,  852,  858,
     2396,  881, 2391, 2366, 2375, 2375,  891, 2369,  950,  959,
      962,  965,  968,  971, 2372,  981,    0, 2364, 2353, 2350,
     2363, 2343, 2350, 2340, 2345, 2345, 2346, 2346,    0, 3371,
        0, 2335,  584, 2322,    0,    0,  820,  902,  985,  998,
     1002, 1008,    0,  975,  911, 1053,    0, 2320, 2315, 2309,
     2311, 2303, 2310, 2300, 2305, 2294, 2290, 2300, 2296,    0,

     2288, 2287, 2275, 2274,    0, 3371, 2290, 2286, 2273, 2278,
     2264, 2263,  238,  243,  273,  340,  383,  415,  941, 1018,
     1030, 1034, 1063,    0,  998,  981, 1108,    0, 1021,    0,
     1056,  500, 1079,  606,  638,  659,  643,  662, 1088,  687,
      694,  697,  711,  718,    0,    0, 3371,  749,  749, 1115,
     1124, 1105,  991, 1001,  766,  952,  801,  828,  872,  879,
      996,  884, 1128,  890,  912,  913,  948,  943,  955,  982,
        0,  975,    0,    0, 1024,  985, 1008, 1032,    0,  999,
        0, 1013, 1014, 1023, 1027, 1039, 1028, 1025,    0, 1028,
     1043, 1044, 1043, 1133, 1160, 1165, 1078, 1081, 1054, 1070,

     1066, 1049, 1063, 1065, 1099, 1068, 1181, 1086, 1186, 3371,
     3371, 1189, 3371, 1079, 1085, 1089, 1104, 1107, 1192, 1205,
     1104, 1111, 1104, 1121, 1100, 1126, 1116, 1114, 1195, 1210,
     1152, 1226, 1233, 1240, 1160, 3371,    0, 1120, 1117, 1157,
        0,    0, 1135,    0, 3371,    0, 1142, 3371,    0,    0,
     1151,    0, 1156, 1159, 1199, 1175, 1161,    0, 1174, 1172,
     1258, 1248, 1209, 1262, 1271, 1285, 1191, 3371, 3371, 1192,
     1197, 1196, 1206,    0,    0, 1295, 1241, 1343,    0, 1219,
     1208,    0, 1218, 1226, 1213, 1220, 1228, 1320, 1391, 1238,
     1239, 1256, 1242, 1245,    0, 1260, 1259, 1263,    0,    0,

     1263, 3371, 1258, 1264, 1256, 1264, 1338, 1436, 1275, 1274,
     1289, 1286, 1275, 1279, 1272,    0, 1319, 1322, 1332, 1281,
     1309, 1297, 1296, 1307, 1310, 1320, 1309, 1369, 1312,    0,
     1308, 1325, 1313, 1407, 1429, 1414, 1381, 1348, 1481,    0,
     1323, 1317, 1334, 1342, 1335, 3371, 1336,    0, 1377, 1346,
     1363, 1351, 1452, 1459, 1488, 1410, 1385, 1533,    0, 1360,
     1362, 1419, 1437, 1497, 1370, 1393, 1477, 1500, 1537, 1549,
     1407, 3371, 1380,    0,    0, 1595,    0, 1558, 1490, 1492,
     1623,    0, 1495, 1502, 1506, 1389, 1444, 1407, 1429, 1436,
     1446, 1479, 1449, 1611, 1469, 1476, 1493, 1671, 1492, 1478,

     3371, 1521,    0, 1616,    0, 1619, 1548, 1528, 1710,    0,
     1555, 1538, 1541, 1492, 1541, 1512, 1520, 1533, 1535, 1552,
     1535, 1633, 1534, 1538, 1551, 1758, 1639, 3371, 1552,    0,
     1550, 1551, 1604, 1554, 1647,    0, 1662, 1600, 1630, 1557,
     1618, 1571, 1586, 1590, 1610, 1621, 1614, 1678, 1651, 1687,
     1690, 1699, 1615, 1693, 1764, 1745, 1700, 1702, 1803,    0,
     1621,    0, 3371,    0, 1719, 1704, 1707, 1638, 1694, 1664,
     1650, 1685, 1688, 1704, 1686, 1761, 1724, 1780, 1792, 1807,
     1702, 1812, 1851, 1799, 1815, 1741, 1879,    0,    0, 1708,
     1704, 1746, 1750, 1857, 1766, 1796, 1867, 1870, 1874, 1927,

        0, 1889, 1869, 1805, 1955,    0, 1872, 1817, 1840, 1725,
     1774, 1742, 1742, 1745, 1749, 1814, 1754, 1895, 2004, 1884,
     1900, 1903, 1906, 1949,    0, 2063, 1930, 1904, 2121,    0,
     1952, 1907, 1910, 1779, 1939, 1805, 1790, 1807, 1819, 1926,
     1829, 2067, 1828, 1841, 1934, 2169, 1908, 2070,    0, 1964,
     1917, 1920, 1894, 1941, 1920, 1919, 1933, 1942, 1952, 1941,
     2073, 1976, 2076, 2084, 2088,    0,    0, 2091,    0, 2066,
     1980, 1983, 1948, 2055, 1968, 2007, 2024, 2041, 2051, 2050,
     2100, 2083, 2137, 2146, 2172, 2048, 2204, 2220, 2197, 2099,
     2091, 2255,    0, 2224, 2095, 2188, 2191, 2249, 2260, 2101,

     2272, 2275, 2278, 2303,    0, 2281, 2129, 2113, 2339,    0,
     2136, 2146, 2149, 2059, 2126, 2085, 2079, 2114, 2125, 2153,
     2131, 2308, 2387, 2355, 2429, 2362,    0, 2229, 2162, 2194,
     2136, 2154, 2167, 2150, 2169, 2171, 2191, 2171, 2358, 2213,
     2366, 2391, 2408, 2471, 2420, 2513, 2433, 2222, 2425, 2436,
     2450, 2555, 2613, 2453, 2671, 2462, 2495, 2729, 2346, 3371,
     2788, 2801, 2814, 2827, 2840, 2853, 2866, 2879, 2892, 2905,
     2918, 2931, 2944, 2957, 2970, 2983, 2996, 3009, 3020, 3031,
     3040, 3049, 3058, 3060, 2233, 2239, 3069, 3080, 3091, 3104,
     3117, 3124, 3126, 3135, 2245, 2246, 2251, 3145, 2252, 2256,

     3151, 3160, 2257, 2259, 2260, 2277, 2278, 2285, 2287, 2288,
     2290, 3173, 2291, 2293
    } ;

static const flex_int16_t yy_def[1415] =
    {   0,
     1361, 1361, 1362, 1362, 1363, 1363, 1364, 1364, 1365, 1365,
     1366, 1366, 1360,   13, 1360,   15, 1360,   17, 1367, 1367,
     1360,   21, 1368, 1368, 1369, 1369, 1370, 1370, 1371, 1371,
     1372, 1372, 1373, 1373, 1374, 1374, 1375, 1375, 1376, 1376,
     1361, 1361, 1377, 1377, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1378, 1360, 1360, 1360, 1379,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1380, 1360, 1360, 1360, 1360, 1381,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1382,
     1383, 1384, 1360, 1360, 1360, 1360, 1385, 1360, 1360, 1360,

     1360, 1360, 1360, 1360, 1386, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1387, 1360, 1360, 1388, 1360, 1360,
     1360, 1360, 1360, 1360, 1389, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1390, 1390, 1360, 1360, 1391, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1378, 1360, 1379,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1380, 1360, 1360, 1360, 1360, 1392, 1381,
     1360, 1360, 1360, 1393, 1393, 1393, 1393, 1360, 1360, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1360, 1360, 1360,

     1360, 1360, 1360, 1382, 1382, 1383, 1384, 1360, 1360, 1385,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1386, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1387, 1360, 1388, 1360, 1360, 1389,
     1390, 1360, 1391, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1392, 1393, 1393, 1360, 1360, 1360, 1394,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,

     1393, 1393, 1393, 1393, 1393, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1394, 1360, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,

     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1393, 1393, 1393, 1393,

     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1360, 1360,
     1360, 1360, 1395, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1360, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1393, 1393, 1393,
     1393, 1393, 1360, 1360, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1360, 1360, 1360, 1360, 1396,

     1393, 1393, 1393,  522,  604, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1395, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1360,
     1360, 1360, 1360, 1397, 1393, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1393, 1393, 1393,
     1393, 1393, 1360, 1360, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393,  599,  686, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1396, 1360, 1360, 1360,

     1393, 1393,  604, 1360, 1360, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393,  653,  738, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1397, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1398, 1360, 1360, 1360,
     1360, 1393, 1393, 1393, 1393, 1393, 1360, 1393, 1393, 1360,
     1393, 1393, 1393, 1393, 1393, 1393, 1393,  686, 1360, 1360,
     1396, 1396,  700, 1360, 1360, 1360, 1399, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,

     1393, 1393, 1393, 1393, 1393, 1360, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,  738, 1360,
     1360, 1397, 1397,  752, 1360, 1360, 1360, 1400, 1360, 1401,
     1360, 1398, 1360, 1360, 1393, 1393, 1393, 1393, 1393, 1360,
     1393, 1393, 1393, 1393, 1393, 1402, 1360, 1360, 1360, 1396,
     1396,  786,  852, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1399, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1360, 1360, 1397, 1397,  827,  896, 1360, 1360, 1360,

     1360, 1360, 1360, 1360, 1360, 1360, 1400, 1401, 1360, 1360,
     1360, 1360, 1360, 1360, 1393, 1393, 1393, 1393, 1360, 1360,
     1360, 1393, 1393, 1393, 1393, 1402, 1360, 1360, 1396, 1396,
      852, 1360, 1360, 1399,  934, 1360, 1393, 1393, 1393, 1360,
     1393, 1393, 1393, 1393, 1360, 1393, 1393, 1360, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1360, 1360,
     1397, 1397,  896, 1360, 1360, 1400,  966, 1360, 1360, 1360,
     1393, 1393, 1393, 1393,  920, 1360, 1360, 1360, 1403, 1360,
     1393, 1393, 1393, 1393, 1360, 1360, 1360, 1396, 1396, 1360,
     1360,  934,  934, 1393, 1393, 1360, 1393, 1393, 1393, 1393,

     1393, 1360, 1393, 1393, 1360, 1360, 1397, 1397, 1360, 1360,
      966,  966, 1360, 1393, 1393, 1393,  978, 1017, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1403, 1360, 1393,
     1393, 1393, 1360, 1360,  989, 1034, 1360, 1360, 1360, 1404,
     1360, 1360,  934,  934, 1393, 1360, 1393, 1393, 1393, 1393,
     1393, 1360, 1360, 1008, 1053, 1360, 1360, 1360, 1405, 1360,
     1360,  966,  966, 1360, 1393, 1393, 1017, 1360, 1360, 1403,
     1070, 1360, 1360, 1393, 1393, 1360, 1034, 1076, 1360, 1360,
     1360, 1406, 1039, 1083, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1404, 1360, 1360,  934,  934, 1393, 1393,

     1360, 1393, 1393, 1360, 1053, 1104, 1360, 1360, 1360, 1407,
     1058, 1111, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1405, 1360, 1360,  966,  966, 1360, 1360, 1393, 1393,
     1360, 1360, 1070, 1070, 1360, 1076, 1081, 1137, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1406, 1083, 1360,
     1360, 1404, 1360, 1360, 1098, 1154, 1360, 1360, 1360, 1408,
     1393, 1393, 1360, 1104, 1109, 1165, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1407, 1111, 1360, 1360, 1405,
     1360, 1360, 1126, 1182, 1360, 1360, 1360, 1409, 1393, 1360,
     1360, 1070, 1070, 1360, 1360, 1137, 1360, 1360, 1404, 1360,

     1154, 1200, 1360, 1360, 1360, 1410, 1159, 1207, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1408, 1360, 1165,
     1360, 1360, 1405, 1360, 1182, 1224, 1360, 1360, 1360, 1411,
     1187, 1231, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1409, 1360, 1360, 1070, 1070, 1360, 1404, 1200, 1205,
     1250, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1410, 1207, 1360, 1360, 1408, 1412, 1219, 1405, 1224, 1229,
     1270, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1411, 1231, 1360, 1360, 1409, 1360, 1360, 1246, 1287, 1360,
     1360, 1360, 1413, 1404, 1250, 1360, 1360, 1408, 1405, 1270,

     1360, 1360, 1409, 1360, 1287, 1304, 1360, 1360, 1360, 1414,
     1292, 1311, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1413, 1404, 1408, 1405, 1409, 1304, 1309, 1328, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1414, 1311,
     1360, 1360, 1413, 1360, 1408, 1360, 1409, 1328, 1360, 1360,
     1413, 1408, 1409, 1413, 1360, 1224, 1413, 1413, 1306,    0,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,

     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360
    } ;

static const flex_int16_t yy_nxt[3432] =
    {   0,
     1360, 1360,   48,   48,   51, 1360, 1360,   52,   51,  108,
      108,   52,   61,   62,   61,   57,   58,   57,  134,   53,
       53,   53,   46,   53,   53,   53,   57,   57,   58,   57,
       54,   61,   62,   61,   54,  109,  109,  134,   57,  168,
      168,   46,  251, 1360,  135,   64,   46,  122,   65,   64,
       55,  272,   65,  252,   55,  273,   49,   49,  168,  168,
       66,   66,   66,  135,   66,   66,   66,   61,  132,   61,
       57,   67,   59,  132,  259,   67,  123,  138,  124,  139,
      368,  138,   57,  139,   59,  260,   61,  266,   61,  266,
      369,   68,  244,  245,  244,   68,   69,   70,   71,   72,

       73,   74,   75,   76,   69,   69,   69,   69,   77,   78,
       69,   79,   79,   69,   69,   69,   73,   69,   80,   80,
       80,   80,   80,   69,   81,   69,   82,   80,   80,   80,
       80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
       80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
       80,   80,   83,   84,   85,   86,   87,   88,   89,   88,
       87,   87,   87,   90,   87,   87,   87,   87,   87,   90,
       87,   91,   91,   87,   90,   87,   87,   91,   91,   91,
       91,   91,   91,   87,   92,   87,   90,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   91,   91,

       91,   91,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   93,   87,   87,   87,   94,   95,   96,   95,
       94,   94,   94,   94,   94,   94,   94,   94,   94,   94,
       94,   94,   94,   94,   94,   94,   94,   94,   97,   97,
       97,   97,   97,   94,   94,   94,   94,   97,   97,   97,
       97,   97,   97,   97,   97,   97,   97,   97,   97,   97,
       97,   97,   97,   97,   97,   97,   97,   97,   97,   97,
       97,   97,   98,   94,   94,   94,  100,  152,  141,  100,
      142,  269,  143,  144,  145,  886,  288,  887,  277,  146,
      289,  101,  101,  101,  101,  101,  101,  278,  270,  280,

      266,  205,  102,  271,  266,  102,  888,  205,  304,  153,
      281,  154,  205,  155,  156,  157,  301,  274,  275,  302,
      158,  305,  103,  276,  205,  103,  104,  104,   46,  104,
      104,  104,  104,  104,  104,  104,  104,  104,  104,  104,
      104,  104,  104,  104,  104,  104,  104,  104,  105,  105,
      105,  105,  105,  104,  104,  104,  104,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  104,  104,  106,  104,  111,  889,   46,  111,
      116,  117,  116,  116,  117,  116,  119,  120,  119,  318,

       46,  112,  112,  112,  112,  112,  112,  119,  120,  119,
      319,   46,  113,  122,  199,  113,  199,  200,  201,  201,
      282,  200,  201,  201,  291,  128,  283,  227,  292,  306,
      306,  890,  114,  332,  704,  114,  128,  293,  327,  307,
      201,  201,  123,  704,  124,  116,  333,  116,  116,  328,
      116,  119,  891,  119,  129,  228,  130,  229,  357,  230,
      231,  232,  119,  358,  119,  129,  233,  130,  171,  171,
      308,  172,  171,  171,  171,  171,  173,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  174,
      175,  174,  174,  176,  177,  178,  179,  171,  171,  180,

      181,  182,  183,  184,  185,  174,  186,  187,  188,  189,
      174,  190,  191,  192,  174,  193,  194,  195,  196,  197,
      174,  174,  174,  174,  171,  171,  171,  171,  202,  911,
      202,  208,  208,  208,  208,  208,  208,  211,  211,  211,
      216,  267,  268,  267,  267,  268,  267,  336,  217,  419,
      218,  420,  219,  220,  221,  267,  268,  267,  421,  222,
      337,  267,  268,  267,  202,  205,  202,  266,  267,  268,
      267,  205,  212,  208,  208,  208,  205,  387,  213,  244,
      245,  244,  388,  203,  378,  214,  209,  215,  205,  209,
      704,  286,  211,  211,  211,  389,  389,  284,  268,  287,

      379,  268,  266,  294,  295,  296,  704,  297,  211,  211,
      211,  552,  268,  298,  244,  245,  244,  843,  268,  203,
      266,  299,  300,  306,  306,  268,  553,  212,  209,  340,
      341,  340,  844,  213,  267,  268,  267,  914,  360,  361,
      214,  354,  215,  212,  396,  355,  356,  371,  401,  213,
      362,  779,  414,  308,  372,  415,  214,  397,  215,  373,
      779,  402,  340,  341,  340,  441,  458,  442,  416,  463,
      417,  446,  447,  443,  459,  468,  389,  389,  464,  531,
      444,  465,  460,  486,  486,  486,  341,  915,  469,  448,
      916,  268,  917,  532,  533,  519,  519,  519,  486,  486,

      486,  572,  572,  572,  580,  520,  308,  520,  521,  522,
      522,  918,  581,  583,  583,  583,  596,  596,  596,  341,
      604,  604,  523,  521,  522,  522,  597,  618,  597,  598,
      599,  599,  519,  519,  519,  619,  638,  921,  487,  922,
      639,  923,  520,  600,  520,  521,  522,  522,  650,  650,
      650,  573,  924,  487,  640,  658,  658,  658,  651,  523,
      651,  652,  653,  653,  572,  572,  572,  925,  584,  605,
      605,  605,  583,  583,  583,  654,  673,  673,  673,  596,
      596,  596,  606,  522,  522,  598,  599,  599,  927,  597,
      928,  597,  598,  599,  599,  686,  686, 1360,  604,  604,

      607,  608,  609,  610, 1360, 1360,  600,  611,  789,  674,
      612,  932,  659,  613,  573,  790,  614,  703,  703,  705,
      705,  705,  698,  698,  698,  738,  738,  584,  687,  687,
      687,  699,  652,  653,  653,  932,  650,  650,  650, 1360,
     1360,  688,  599,  599,  778,  778,  651,  846,  651,  652,
      653,  653, 1360,  686,  686,  779,  753,  753,  753,  689,
      690,  691,  692,  654,  703,  703,  693, 1360, 1360,  694,
      932,  779,  695,  819,  819,  696,  847,  700,  739,  739,
      739,  750,  750,  750,  658,  658,  658,  780,  780,  780,
      751,  740,  653,  653,  756,  756,  756,  673,  673,  673,

      698,  698,  698,  698,  698,  698,  705,  705,  705,  741,
      742,  743,  744,  754,  820,  932,  745,  778,  778,  746,
      757,  932,  747,  820,  820,  748,  852,  852,  781,  932,
      674,  782,  783,  783,  783,  937,  752,  705,  705,  705,
      820,  659,  784,  938,  784,  785,  786,  786, 1360,  738,
      738,  821,  821,  821,  939,  700,  819,  819,  700,  787,
      750,  750,  750,  750,  750,  750,  824,  824,  824,  753,
      753,  753,  829,  829,  829,  940,  825,  941,  825,  826,
      827,  827,  756,  756,  756,  932,  780,  780,  780,  785,
      786,  786,  822,  828,  932,  823,  896,  896,  830,  780,

      780,  780,  942,  780,  780,  780, 1360, 1360,  757,  780,
      780,  780,  826,  827,  827,  752,  931,  931,  752,  821,
      821,  821,  829,  829,  829,  943,  754,  848,  944,  932,
      849,  821,  821,  821,  945,  821,  821,  821,  946,  947,
      848,  850,  948,  849,  781,  932,  949,  782,  830,  851,
      781,  950,  951,  782,  853,  853,  853,  909,  909,  909,
      892,  952,  953,  893,  821,  821,  821,  854,  786,  786,
      954,  955,  892,  894,  956,  893,  822,  957,  958,  823,
      912,  912,  912,  959,  960,  855,  856,  857,  858,  919,
      919,  919,  859, 1360, 1360,  860,  963,  963,  861,  964,

      964,  862,  964,  964,  895,  822,  964,  964,  823,  897,
      897,  897,  964,  964,  910,  969,  780,  780,  780, 1360,
      852,  852,  898,  827,  827,  780,  780,  780,  970,  933,
      933,  933,  964,  971,  821,  821,  821,  913,  972,  973,
      899,  900,  901,  902,  920,  974,  980,  903,  964,  981,
      904,  982,  983,  905,  984,  985,  906,  781,  929,  986,
      782,  821,  821,  821,  987,  994,  781,  931,  931,  782,
      934,  995,  996,  935,  930,  822,  961,  997,  823, 1360,
      896,  896,  965,  965,  965,  998,  936,  909,  909,  909,
      912,  912,  912,  919,  919,  919,  780,  780,  780,  863,

      999,  993,  822, 1000, 1001,  823,  975,  975,  975, 1002,
      962,  780,  780,  780, 1003, 1004,  976, 1005,  976,  977,
      978,  978, 1006,  966,  963,  963,  967,  933,  933,  933,
      907, 1013, 1012,  979,  933,  933,  933,  781, 1014,  968,
      782,  933,  933,  933,  910,  988, 1015,  913,  920,  821,
      821,  821,  781, 1016, 1029,  782, 1017, 1017,  989,  821,
      821,  821, 1030,  965,  965,  965, 1031, 1032,  990,  847,
     1033,  991,  965,  965,  965,  990, 1034, 1041,  991,  992,
     1042,  863,  934, 1045,  936,  935,  965,  965,  965, 1046,
      822,  936, 1044,  823, 1047,  863, 1008, 1048,  936, 1043,

      822, 1049, 1050,  823, 1009, 1051, 1052, 1010, 1007,  977,
      978,  978, 1053, 1009, 1060, 1061, 1010, 1064, 1065, 1066,
      968,  780,  780,  780, 1011,  907, 1068,  966,  907,  968,
      967, 1068, 1062, 1360, 1017, 1017, 1063, 1360, 1360,  821,
      821,  821, 1068,  968, 1018, 1018, 1018, 1067, 1067, 1068,
     1068, 1068, 1068, 1068, 1068, 1073, 1074, 1019,  978,  978,
     1075, 1076,  781, 1083, 1083,  782, 1095, 1096, 1035, 1068,
     1069, 1069, 1069,  863, 1099, 1020, 1021, 1022, 1023, 1100,
      822,  863, 1024,  823, 1097, 1025, 1054, 1101, 1026, 1102,
     1098, 1027, 1036, 1036, 1036, 1038, 1039, 1039, 1103, 1104,

     1111, 1111, 1037, 1123, 1037, 1038, 1039, 1039, 1077, 1077,
     1077, 1070, 1124, 1129, 1071, 1036, 1036, 1036, 1037, 1040,
     1037, 1038, 1039, 1039, 1057, 1058, 1058, 1072, 1130, 1135,
     1078, 1078, 1078,  781, 1150, 1040,  782, 1055, 1055, 1055,
     1079, 1150, 1079, 1080, 1081, 1081, 1028, 1056, 1134, 1056,
     1057, 1058, 1058, 1105, 1105, 1105,  848, 1082,  907,  849,
     1106, 1106, 1106, 1056, 1059, 1056, 1057, 1058, 1058, 1125,
     1107, 1150, 1107, 1108, 1109, 1109,  907, 1150,  822, 1150,
     1059,  823, 1084, 1084, 1084, 1126, 1150, 1110, 1150, 1055,
     1055, 1055, 1067, 1067, 1150, 1085, 1039, 1039, 1127, 1127,

     1127, 1069, 1069, 1069, 1080, 1081, 1081, 1137, 1137, 1360,
     1083, 1083, 1150, 1086, 1087, 1088, 1089, 1360, 1360, 1153,
     1090, 1149, 1149, 1091, 1154, 1161, 1092, 1162, 1150, 1093,
      892, 1163,  863,  893, 1112, 1112, 1112, 1178, 1069, 1069,
     1069, 1155, 1131, 1165, 1165, 1132, 1178, 1113, 1058, 1058,
     1069, 1069, 1069, 1360, 1360, 1128, 1177, 1177, 1072, 1078,
     1078, 1078, 1108, 1109, 1109, 1114, 1115, 1116, 1117, 1360,
     1111, 1111, 1118, 1178, 1178, 1119, 1178, 1178, 1120, 1131,
     1178, 1121, 1132, 1178, 1181, 1178, 1182, 1189, 1133, 1190,
      907, 1070, 1191, 1028, 1071, 1072, 1136, 1136, 1136, 1183,

      848, 1178, 1197,  849, 1193, 1197, 1079, 1072, 1079, 1080,
     1081, 1081, 1151, 1151, 1151, 1360, 1360, 1164, 1164, 1164,
     1106, 1106, 1106, 1082, 1138, 1138, 1138, 1107, 1197, 1107,
     1108, 1109, 1109, 1197, 1179, 1179, 1179, 1139, 1081, 1081,
     1127, 1127, 1127, 1028, 1110, 1196, 1196, 1192, 1194, 1194,
     1194, 1197, 1197, 1152, 1197, 1140, 1141, 1142, 1143, 1197,
     1197,  892, 1144, 1200,  893, 1145, 1149, 1149, 1146, 1219,
     1197, 1147, 1156, 1156, 1156, 1180, 1360, 1137, 1137, 1198,
     1198, 1198, 1157, 1221, 1157, 1158, 1159, 1159, 1151, 1151,
     1151, 1151, 1151, 1151, 1201, 1201, 1201, 1128, 1221, 1160,

     1151, 1151, 1151, 1221, 1157, 1195, 1157, 1158, 1159, 1159,
      863, 1166, 1166, 1166, 1158, 1159, 1159, 1207, 1207, 1360,
     1360, 1160, 1220, 1220, 1167, 1109, 1109, 1221, 1221,  848,
     1221, 1221,  848, 1360, 1165, 1165, 1221, 1221, 1199, 1177,
     1177, 1152, 1168, 1169, 1170, 1171, 1156, 1156, 1156, 1172,
     1224, 1243, 1173, 1221, 1244, 1174, 1231, 1231, 1175, 1184,
     1184, 1184, 1222, 1222, 1222, 1202, 1202, 1202, 1247, 1185,
     1263, 1185, 1186, 1187, 1187, 1203, 1263, 1203, 1204, 1205,
     1205, 1179, 1179, 1179, 1263, 1028, 1188,  990, 1263, 1028,
      991, 1263, 1206, 1179, 1179, 1179, 1245,  907, 1246, 1263,

     1184, 1184, 1184,  936, 1208, 1208, 1208, 1263, 1179, 1179,
     1179, 1196, 1196, 1225, 1225, 1225, 1263, 1209, 1159, 1159,
     1250, 1250,  892, 1185, 1283, 1185, 1186, 1187, 1187, 1186,
     1187, 1187, 1360, 1360,  892, 1210, 1211, 1212, 1213, 1283,
     1188, 1009, 1214, 1283, 1010, 1215, 1223, 1263, 1216, 1180,
     1283, 1217, 1226, 1226, 1226, 1262, 1262,  968, 1194, 1194,
     1194, 1283, 1227, 1263, 1227, 1228, 1229, 1229, 1198, 1198,
     1198, 1198, 1198, 1198, 1283, 1151, 1151, 1151, 1286, 1230,
     1232, 1232, 1232, 1204, 1205, 1205, 1360, 1207, 1207, 1287,
     1202, 1202, 1202, 1233, 1187, 1187, 1264, 1264, 1264, 1220,

     1220, 1222, 1222, 1222, 1222, 1222, 1222, 1179, 1179, 1179,
     1247, 1234, 1235, 1236, 1237, 1195, 1152, 1248, 1238, 1270,
     1270, 1239, 1360, 1360, 1240, 1282, 1282, 1241, 1249, 1249,
     1249,  990, 1360, 1360,  991, 1295, 1295, 1265, 1203, 1296,
     1203, 1204, 1205, 1205, 1228, 1229, 1229,  936, 1180, 1268,
     1269, 1269, 1269,  936, 1296, 1206, 1251, 1251, 1251, 1283,
     1227, 1296, 1227, 1228, 1229, 1229, 1360, 1231, 1231, 1252,
     1205, 1205, 1283, 1028, 1296, 1283, 1296, 1230, 1360, 1250,
     1250, 1283, 1288, 1296, 1296, 1296, 1296, 1253, 1254, 1255,
     1256, 1262, 1262, 1301, 1257, 1360, 1360, 1258, 1300, 1300,

     1259, 1296, 1301, 1260, 1266, 1266, 1266, 1266, 1266, 1266,
     1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
     1266, 1266, 1266, 1266, 1266, 1267, 1267, 1267, 1267, 1267,
     1267, 1266, 1266, 1266, 1266, 1267, 1267, 1267, 1267, 1267,
     1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267,
     1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267,
     1301, 1266, 1266, 1266, 1226, 1226, 1226, 1301, 1284, 1284,
     1284, 1151, 1151, 1151, 1297, 1297, 1297, 1264, 1264, 1264,
     1360, 1270, 1270, 1301, 1301, 1264, 1264, 1264, 1301, 1264,
     1264, 1264, 1179, 1179, 1179, 1301, 1304, 1301, 1282, 1282,

     1301, 1302, 1302, 1302, 1341, 1009, 1311, 1311, 1010, 1285,
     1295, 1295, 1152, 1291, 1292, 1292, 1300, 1300,  990, 1341,
     1294,  968, 1271, 1271, 1271,  968,  990, 1298, 1328, 1328,
     1265,  936, 1341, 1180,  936, 1272, 1229, 1229, 1284, 1284,
     1284, 1299,  936, 1308, 1309, 1309,  936, 1284, 1284, 1284,
     1360, 1311, 1311, 1273, 1274, 1275, 1276, 1341,  968, 1341,
     1277, 1360, 1360, 1278, 1340, 1340, 1279, 1341, 1341, 1280,
     1289, 1289, 1289, 1284, 1284, 1284, 1341, 1360, 1360, 1009,
     1290, 1349, 1290, 1291, 1292, 1292, 1341, 1349, 1009, 1297,
     1297, 1297, 1297, 1297, 1297,  968, 1349, 1293, 1289, 1289,

     1289, 1349, 1341, 1349,  968, 1305, 1305, 1305, 1028, 1348,
     1348, 1303, 1349, 1349, 1285, 1290, 1349, 1290, 1291, 1292,
     1292, 1306, 1306, 1306, 1349, 1151, 1151, 1151, 1340, 1340,
      968, 1307, 1293, 1307, 1308, 1309, 1309, 1348, 1348, 1131,
     1349,  210, 1132, 1360, 1328, 1328,  936,  224, 1310,  936,
     1264, 1264, 1264,  615,  697, 1072, 1312, 1312, 1312,  749,
      863, 1179, 1179, 1179,  907, 1028, 1152, 1094, 1122, 1313,
     1292, 1292, 1323, 1302, 1302, 1302, 1302, 1302, 1302, 1284,
     1284, 1284, 1306, 1306, 1306, 1148, 1176, 1314, 1315, 1316,
     1317, 1265, 1324, 1218, 1318, 1242, 1261, 1319, 1281, 1322,

     1320, 1339, 1180, 1321, 1327, 1327, 1327,  936, 1325, 1342,
     1342, 1342,  885,  884, 1307,  883, 1307, 1308, 1309, 1309,
     1285, 1326,  882, 1131,  881,  880, 1132,  879,  878,  877,
      968, 1310,  876,  968,  875,  874,  968,  873,  872, 1072,
     1329, 1329, 1329,  871,  870,  869,  868, 1359, 1359, 1359,
     1343,  867,  866, 1330, 1309, 1309, 1264, 1264, 1264, 1350,
     1350, 1350,  865, 1284, 1284, 1284, 1072, 1342, 1342, 1342,
      864, 1331, 1332, 1333, 1334,  845,  842,  841, 1335,  840,
      839, 1336,  838,  837, 1337,  836,  835, 1338, 1344, 1344,
     1344, 1360, 1342, 1342, 1342,  834,  323, 1265, 1079,  314,

     1079, 1080, 1081, 1081, 1285, 1345,  833,  831, 1131, 1342,
     1342, 1342, 1347,  936,  820, 1082, 1072,  820,  820,  820,
      968, 1264, 1264, 1264, 1072,  820, 1350, 1350, 1350, 1152,
     1346, 1346, 1346, 1131, 1284, 1284, 1284, 1350, 1350, 1350,
     1107,  820, 1107, 1108, 1109, 1109,  818, 1351,  817, 1072,
     1343, 1342, 1342, 1342, 1342, 1342, 1342, 1110,  816,  815,
      814,  813, 1265, 1356, 1356, 1356, 1072,  812, 1352,  811,
      810, 1180, 1344, 1344, 1344, 1285,  809,  808,  936,  807,
      806, 1353, 1079, 1072, 1079, 1080, 1081, 1081,  805,  804,
      803,  968, 1343, 1354, 1072, 1343, 1342, 1342, 1342, 1082,

      802,  801,  800, 1357, 1009,  799,  798,  797, 1072,  796,
      795, 1072,  794,  848, 1346, 1346, 1346,  793,  792,  791,
      968,  788,  779,  779, 1107,  779, 1107, 1108, 1109, 1109,
      779,  779,  779,  777,  776,  775,  774, 1343,  773,  772,
      771, 1110,  770, 1358,  769,  768,  767,  766,  765,  764,
      763,  762,  255, 1072,  247,  892, 1355, 1355, 1355,  761,
      323,  760,  314,  759,  758,  755, 1203,  737, 1203, 1204,
     1205, 1205,  736,  735,  734,  733,  732,  731,  730,  729,
      728,  727,  726, 1206,  725,  724,  723,  722,  721,  720,
      719,  718,  717,  716,  715,  714,  713, 1265,  712,  711,

      710,  709,  708,  707,  706,  704,  704,  704,  704,  704,
      704,  702,  701,  936, 1356, 1356, 1356,  685,  684,  683,
      682,  681,  680,  679, 1227,  678, 1227, 1228, 1229, 1229,
      677,  676,  675,  672,  671,  670,  669,  668,  255,  667,
      247, 1230,  666,  665,  664,  323,  663,  323,  662,  314,
      661,  314,  660,  657,  656, 1285,  655,  649,  648,  647,
      646,  645,  644,  643,  642,  641,  637,  636,  635,  634,
      633,  968, 1355, 1355, 1355,  632,  631,  630,  629,  628,
      627,  626, 1203,  625, 1203, 1204, 1205, 1205,  624,  623,
      622,  621,  620,  617,  616,  603,  602,  601,  595, 1206,

      594,  593,  592,  591,  590,  589,  588,  587,  586,  585,
      582,  579,  578,  990,  577,  255,  576,  255,  575,  247,
      574,  247,  571,  570,  569,  568,  567,  566,  565,  936,
     1359, 1359, 1359,  564,  563,  562,  561,  560,  559,  558,
     1307,  557, 1307, 1308, 1309, 1309,  556,  555,  554,  551,
      550,  549,  548,  547,  546,  545,  544, 1310,  543,  542,
      541,  540,  539,  538,  537,  536,  535,  534,  530,  529,
      528, 1343,  527,  526,  525,  524,  518,  517,  516,  515,
      514,  513,  512,  511,  510,  509,  508, 1072,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,

       46,   47,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   47,   47,   47,   50,   50,   50,   50,   50,   50,
       50,   50,   50,   50,   50,   50,   50,   56,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,   99,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  107,  110,  110,  110,  110,  110,  110,  110,  110,

      110,  110,  110,  110,  110,  115,  115,  115,  115,  115,
      115,  115,  115,  115,  115,  115,  115,  115,  118,  118,
      118,  118,  118,  118,  118,  118,  118,  118,  118,  118,
      118,  121,  121,  121,  121,  121,  121,  121,  121,  121,
      121,  121,  121,  121,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  127,  127,  127,
      127,  127,  127,  127,  127,  127,  127,  127,  127,  127,
      131,  131,  131,  131,  131,  131,  131,  131,  131,  131,
      131,  131,  131,  133,  133,  133,  133,  133,  133,  133,
      133,  133,  133,  133,  133,  133,  137,  137,  137,  137,

      137,  137,  137,  137,  137,  137,  137,  137,  137,  148,
      507,  506,  148,  148,  505,  148,  148,  148,  148,  148,
      150,  504,  503,  150,  150,  150,  150,  150,  150,  150,
      150,  164,  164,  502,  164,  164,  164,  164,  164,  164,
      164,  164,  164,  164,  170,  501,  500,  499,  170,  204,
      498,  497,  204,  204,  204,  204,  204,  204,  204,  204,
      496,  204,  206,  495,  206,  206,  206,  207,  207,  235,
      494,  493,  235,  235,  235,  235,  235,  235,  235,  235,
      237,  492,  491,  237,  237,  237,  237,  237,  237,  237,
      237,  240,  240,  240,  240,  240,  240,  240,  240,  240,

      240,  490,  240,  240,  241,  241,  241,  241,  241,  241,
      241,  241,  241,  489,  241,  241,  241,  243,  243,  243,
      243,  243,  243,  243,  243,  243,  243,  243,  264,  488,
      485,  484,  264,  265,  265,  342,  342,  342,  342,  342,
      342,  342,  342,  342,  342,  342,  342,  342,  832,  483,
      482,  481,  480,  832,  908,  479,  478,  477,  476,  908,
      926,  926,  926,  926,  926,  926,  926,  926,  926,  926,
      475,  926,  926, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
     1266, 1266, 1266, 1266,  474, 1266,  473,  472,  471,  470,
      467,  466,  462,  461,  457,  456,  455,  454,  453,  452,

      451,  450,  449,  445,  440,  439,  438,  437,  436,  435,
      434,  433,  432,  431,  430,  429,  428,  427,  426,  425,
      424,  423,  422,  418,  343,  413,  412,  411,  410,  409,
      408,  407,  406,  405,  404,  403,  323,  323,  400,  323,
      323,  399,  398,  314,  314,  395,  314,  314,  394,  393,
      392,  391,  390,  386,  385,  384,  383,  382,  381,  380,
      377,  376,  375,  374,  370,  367,  366,  365,  364,  363,
      359,  353,  352,  351,  350,  349,  348,  347,  346,  345,
      344,  343,  270, 1360,  339,  338,  255,  255,  335,  255,
      255,  334,  247,  247,  331,  247,  247,  330,  238,  236,

      329,  326,  325,  324,  323,  322,  321,  225,  320,  317,
      316,  315,  314,  313,  312,  311,  310,  309,  203,  303,
      290,  285,  279,  169,  169,  263,  262,  160,  261,  258,
      257,  256,  255,  254,  151,  149,  253,  250,  249,  248,
      247,  246,  242,  239,  238,  236,  234,  226,  225,  223,
      203,  198,  169,  167,  166,  165,  163,  162,  161,  160,
      159,  151,  149,  147,  140, 1360,  136,  136,  126,  126,
       45, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,

     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360
    } ;

static const flex_int16_t yy_chk[3432] =
    {   0,
        0,    0,    3,    4,    5,    0,    0,    5,    6,   23,
       24,    6,    9,    9,    9,    7,    7,    7,   39,    5,
        5,    5,   31,    6,    6,    6,    7,    8,    8,    8,
        5,   10,   10,   10,    6,   23,   24,   40,    8,   79,
       79,   37,  146,    0,   39,   11,   38,   31,   11,   12,
        5,  181,   12,  146,    6,  181,    3,    4,  168,  168,
       11,   11,   11,   40,   12,   12,   12,    9,   37,    9,
        7,   11,    7,   38,  158,   12,   31,   43,   31,   43,
      290,   44,    8,   44,    8,  158,   10,  175,   10,  175,
      290,   11,  139,  139,  139,   12,   13,   13,   13,   13,

       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,

       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   19,   67,   54,   20,
       54,  179,   54,   54,   54,  813,  190,  814,  183,   54,
      190,   19,   19,   19,   20,   20,   20,  183,  179,  185,

      180,   91,   19,  180,  180,   20,  815,   91,  197,   67,
      185,   67,   91,   67,   67,   67,  195,  182,  182,  195,
       67,  197,   19,  182,   91,   20,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   25,  816,   32,   26,
       27,   27,   27,   28,   28,   28,   29,   29,   29,  222,

       35,   25,   25,   25,   26,   26,   26,   30,   30,   30,
      222,   36,   25,   32,   83,   26,   83,   83,   83,   83,
      186,  199,  199,  199,  193,   35,  186,  113,  193,  200,
      200,  817,   25,  252,  608,   26,   36,  193,  233,  201,
      201,  201,   32,  608,   32,   27,  252,   27,   28,  233,
       28,   29,  818,   29,   35,  113,   35,  113,  282,  113,
      113,  113,   30,  282,   30,   36,  113,   36,   81,   81,
      201,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,

       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   88,  832,
       88,   95,   95,   95,   96,   96,   96,   98,   98,   98,
      102,  176,  176,  176,  177,  177,  177,  260,  102,  346,
      102,  346,  102,  102,  102,  187,  187,  187,  346,  102,
      260,  189,  189,  189,  202,  206,  202,  177,  191,  191,
      191,  206,   98,  208,  208,  208,  206,  305,   98,  244,
      244,  244,  305,   88,  297,   98,   95,   98,  206,   96,
      613,  189,  209,  209,  209,  307,  307,  187,  176,  189,

      297,  177,  191,  194,  194,  194,  613,  194,  211,  211,
      211,  465,  187,  194,  245,  245,  245,  773,  189,  202,
      194,  194,  194,  306,  306,  191,  465,  209,  208,  266,
      266,  266,  773,  209,  267,  267,  267,  834,  284,  284,
      209,  281,  209,  211,  319,  281,  281,  292,  328,  211,
      284,  690,  344,  306,  292,  344,  211,  319,  211,  292,
      690,  328,  340,  340,  340,  367,  379,  367,  344,  382,
      344,  369,  369,  367,  379,  385,  389,  389,  382,  445,
      367,  382,  379,  404,  404,  404,  266,  835,  385,  369,
      836,  267,  837,  445,  445,  437,  437,  437,  486,  486,

      486,  487,  487,  487,  499,  437,  389,  437,  437,  437,
      437,  838,  499,  501,  501,  501,  513,  513,  513,  340,
      521,  521,  437,  520,  520,  520,  513,  527,  513,  513,
      513,  513,  519,  519,  519,  527,  547,  840,  404,  841,
      547,  842,  519,  513,  519,  519,  519,  519,  558,  558,
      558,  487,  843,  486,  547,  562,  562,  562,  558,  519,
      558,  558,  558,  558,  572,  572,  572,  844,  501,  522,
      522,  522,  583,  583,  583,  558,  584,  584,  584,  596,
      596,  596,  522,  522,  522,  597,  597,  597,  848,  596,
      849,  596,  596,  596,  596,  598,  598,  604,  604,  604,

      522,  522,  522,  522,  605,  605,  596,  522,  702,  584,
      522,  855,  562,  522,  572,  702,  522,  606,  606,  615,
      615,  615,  601,  601,  601,  652,  652,  583,  599,  599,
      599,  601,  651,  651,  651,  857,  650,  650,  650,  687,
      687,  599,  599,  599,  688,  688,  650,  777,  650,  650,
      650,  650,  686,  686,  686,  695,  656,  656,  656,  599,
      599,  599,  599,  650,  703,  703,  599,  739,  739,  599,
      858,  695,  599,  740,  740,  599,  777,  601,  653,  653,
      653,  655,  655,  655,  658,  658,  658,  697,  697,  697,
      655,  653,  653,  653,  659,  659,  659,  673,  673,  673,

      698,  698,  698,  699,  699,  699,  704,  704,  704,  653,
      653,  653,  653,  656,  742,  859,  653,  778,  778,  653,
      659,  860,  653,  742,  747,  653,  785,  785,  697,  862,
      673,  697,  700,  700,  700,  864,  655,  705,  705,  705,
      747,  658,  700,  865,  700,  700,  700,  700,  738,  738,
      738,  749,  749,  749,  866,  698,  819,  819,  699,  700,
      750,  750,  750,  751,  751,  751,  752,  752,  752,  753,
      753,  753,  754,  754,  754,  867,  752,  868,  752,  752,
      752,  752,  756,  756,  756,  856,  779,  779,  779,  784,
      784,  784,  749,  752,  856,  749,  826,  826,  754,  780,

      780,  780,  869,  781,  781,  781,  853,  853,  756,  782,
      782,  782,  825,  825,  825,  750,  854,  854,  751,  820,
      820,  820,  829,  829,  829,  870,  753,  779,  872,  861,
      779,  821,  821,  821,  875,  822,  822,  822,  876,  877,
      780,  781,  878,  780,  781,  861,  880,  781,  829,  782,
      782,  882,  883,  782,  786,  786,  786,  831,  831,  831,
      820,  884,  885,  820,  823,  823,  823,  786,  786,  786,
      886,  887,  821,  822,  888,  821,  822,  890,  891,  822,
      833,  833,  833,  892,  893,  786,  786,  786,  786,  839,
      839,  839,  786,  897,  897,  786,  898,  898,  786,  899,

      901,  786,  902,  900,  823,  823,  903,  904,  823,  827,
      827,  827,  900,  906,  831,  908,  850,  850,  850,  852,
      852,  852,  827,  827,  827,  851,  851,  851,  914,  863,
      863,  863,  905,  915,  894,  894,  894,  833,  916,  917,
      827,  827,  827,  827,  839,  918,  921,  827,  905,  922,
      827,  923,  924,  827,  925,  926,  827,  850,  850,  927,
      850,  895,  895,  895,  928,  938,  851,  931,  931,  851,
      863,  939,  940,  863,  851,  894,  894,  943,  894,  896,
      896,  896,  907,  907,  907,  947,  863,  909,  909,  909,
      912,  912,  912,  919,  919,  919,  929,  929,  929,  935,

      951,  935,  895,  953,  954,  895,  920,  920,  920,  955,
      895,  930,  930,  930,  956,  957,  920,  959,  920,  920,
      920,  920,  960,  907,  963,  963,  907,  932,  932,  932,
      967,  970,  967,  920,  933,  933,  933,  929,  971,  907,
      929,  934,  934,  934,  909,  929,  972,  912,  919,  962,
      962,  962,  930,  973,  980,  930,  977,  977,  930,  961,
      961,  961,  981,  964,  964,  964,  983,  984,  932,  985,
      986,  932,  965,  965,  965,  933,  987,  990,  933,  934,
      991,  993,  934,  994,  932,  934,  966,  966,  966,  996,
      962,  933,  993,  962,  997,  992,  962,  998,  934,  992,

      961, 1001, 1003,  961,  964, 1004, 1005,  964,  961,  976,
      976,  976, 1006,  965, 1009, 1010,  965, 1013, 1014, 1015,
      964,  988,  988,  988,  966, 1012, 1020,  966, 1011,  965,
      966, 1022, 1011, 1017, 1017, 1017, 1012, 1018, 1018, 1007,
     1007, 1007, 1021,  966,  978,  978,  978, 1019, 1019, 1023,
     1024, 1021, 1025, 1026, 1027, 1029, 1031,  978,  978,  978,
     1032, 1033,  988, 1038, 1038,  988, 1041, 1042,  988, 1026,
     1028, 1028, 1028, 1043, 1045,  978,  978,  978,  978, 1047,
     1007, 1044,  978, 1007, 1043,  978, 1007, 1049,  978, 1050,
     1044,  978,  989,  989,  989, 1037, 1037, 1037, 1051, 1052,

     1057, 1057,  989, 1060,  989,  989,  989,  989, 1034, 1034,
     1034, 1028, 1061, 1065, 1028, 1036, 1036, 1036, 1034,  989,
     1034, 1034, 1034, 1034, 1056, 1056, 1056, 1028, 1066, 1073,
     1035, 1035, 1035,  989, 1086, 1034,  989, 1008, 1008, 1008,
     1035, 1088, 1035, 1035, 1035, 1035, 1071, 1008, 1071, 1008,
     1008, 1008, 1008, 1053, 1053, 1053, 1036, 1035, 1062, 1036,
     1054, 1054, 1054, 1053, 1008, 1053, 1053, 1053, 1053, 1062,
     1054, 1089, 1054, 1054, 1054, 1054, 1063, 1087, 1008, 1090,
     1053, 1008, 1039, 1039, 1039, 1063, 1087, 1054, 1091, 1055,
     1055, 1055, 1067, 1067, 1093, 1039, 1039, 1039, 1064, 1064,

     1064, 1068, 1068, 1068, 1079, 1079, 1079, 1080, 1080, 1083,
     1083, 1083, 1092, 1039, 1039, 1039, 1039, 1084, 1084, 1095,
     1039, 1085, 1085, 1039, 1096, 1099, 1039, 1100, 1092, 1039,
     1055, 1102, 1097, 1055, 1058, 1058, 1058, 1114, 1069, 1069,
     1069, 1097, 1068, 1108, 1108, 1068, 1116, 1058, 1058, 1058,
     1070, 1070, 1070, 1112, 1112, 1064, 1113, 1113, 1068, 1078,
     1078, 1078, 1107, 1107, 1107, 1058, 1058, 1058, 1058, 1111,
     1111, 1111, 1058, 1117, 1115, 1058, 1118, 1119, 1058, 1069,
     1121, 1058, 1069, 1115, 1123, 1120, 1124, 1129, 1070, 1131,
     1125, 1070, 1132, 1134, 1070, 1069, 1076, 1076, 1076, 1125,

     1078, 1120, 1140, 1078, 1134, 1142, 1076, 1070, 1076, 1076,
     1076, 1076, 1094, 1094, 1094, 1138, 1138, 1104, 1104, 1104,
     1106, 1106, 1106, 1076, 1081, 1081, 1081, 1104, 1143, 1104,
     1104, 1104, 1104, 1144, 1122, 1122, 1122, 1081, 1081, 1081,
     1127, 1127, 1127, 1133, 1104, 1139, 1139, 1133, 1135, 1135,
     1135, 1141, 1145, 1094, 1146, 1081, 1081, 1081, 1081, 1147,
     1141, 1106, 1081, 1153, 1106, 1081, 1149, 1149, 1081, 1161,
     1146, 1081, 1098, 1098, 1098, 1122, 1137, 1137, 1137, 1148,
     1148, 1148, 1098, 1168, 1098, 1098, 1098, 1098, 1150, 1150,
     1150, 1151, 1151, 1151, 1154, 1154, 1154, 1127, 1170, 1098,

     1152, 1152, 1152, 1171, 1154, 1135, 1154, 1154, 1154, 1154,
     1098, 1109, 1109, 1109, 1157, 1157, 1157, 1158, 1158, 1166,
     1166, 1154, 1167, 1167, 1109, 1109, 1109, 1169, 1172, 1150,
     1173, 1175, 1151, 1165, 1165, 1165, 1169, 1174, 1152, 1177,
     1177, 1152, 1109, 1109, 1109, 1109, 1156, 1156, 1156, 1109,
     1181, 1190, 1109, 1174, 1191, 1109, 1186, 1186, 1109, 1126,
     1126, 1126, 1176, 1176, 1176, 1155, 1155, 1155, 1195, 1126,
     1210, 1126, 1126, 1126, 1126, 1155, 1212, 1155, 1155, 1155,
     1155, 1178, 1178, 1178, 1213, 1192, 1126, 1156, 1214, 1193,
     1156, 1215, 1155, 1179, 1179, 1179, 1192, 1126, 1193, 1217,

     1184, 1184, 1184, 1156, 1159, 1159, 1159, 1211, 1180, 1180,
     1180, 1196, 1196, 1182, 1182, 1182, 1211, 1159, 1159, 1159,
     1204, 1204, 1178, 1182, 1234, 1182, 1182, 1182, 1182, 1185,
     1185, 1185, 1208, 1208, 1179, 1159, 1159, 1159, 1159, 1236,
     1182, 1184, 1159, 1237, 1184, 1159, 1180, 1216, 1159, 1180,
     1238, 1159, 1183, 1183, 1183, 1209, 1209, 1184, 1194, 1194,
     1194, 1239, 1183, 1216, 1183, 1183, 1183, 1183, 1197, 1197,
     1197, 1198, 1198, 1198, 1241, 1199, 1199, 1199, 1243, 1183,
     1187, 1187, 1187, 1203, 1203, 1203, 1207, 1207, 1207, 1244,
     1202, 1202, 1202, 1187, 1187, 1187, 1218, 1218, 1218, 1220,

     1220, 1221, 1221, 1221, 1222, 1222, 1222, 1223, 1223, 1223,
     1247, 1187, 1187, 1187, 1187, 1194, 1199, 1199, 1187, 1228,
     1228, 1187, 1232, 1232, 1187, 1233, 1233, 1187, 1200, 1200,
     1200, 1202, 1251, 1251, 1202, 1252, 1252, 1218, 1200, 1253,
     1200, 1200, 1200, 1200, 1227, 1227, 1227, 1202, 1223, 1223,
     1224, 1224, 1224, 1218, 1255, 1200, 1205, 1205, 1205, 1240,
     1224, 1256, 1224, 1224, 1224, 1224, 1231, 1231, 1231, 1205,
     1205, 1205, 1235, 1245, 1254, 1240, 1257, 1224, 1250, 1250,
     1250, 1235, 1245, 1254, 1258, 1259, 1260, 1205, 1205, 1205,
     1205, 1262, 1262, 1273, 1205, 1271, 1271, 1205, 1272, 1272,

     1205, 1259, 1275, 1205, 1219, 1219, 1219, 1219, 1219, 1219,
     1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
     1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
     1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
     1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
     1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
     1276, 1219, 1219, 1219, 1226, 1226, 1226, 1277, 1242, 1242,
     1242, 1248, 1248, 1248, 1261, 1261, 1261, 1263, 1263, 1263,
     1270, 1270, 1270, 1278, 1279, 1264, 1264, 1264, 1274, 1265,
     1265, 1265, 1268, 1268, 1268, 1280, 1286, 1274, 1282, 1282,

     1279, 1281, 1281, 1281, 1314, 1226, 1291, 1291, 1226, 1242,
     1295, 1295, 1248, 1290, 1290, 1290, 1300, 1300, 1263, 1316,
     1248, 1226, 1229, 1229, 1229, 1242, 1264, 1265, 1308, 1308,
     1265, 1261, 1317, 1268, 1263, 1229, 1229, 1229, 1283, 1283,
     1283, 1268, 1264, 1307, 1307, 1307, 1265, 1284, 1284, 1284,
     1311, 1311, 1311, 1229, 1229, 1229, 1229, 1318, 1281, 1315,
     1229, 1312, 1312, 1229, 1313, 1313, 1229, 1319, 1315, 1229,
     1246, 1246, 1246, 1285, 1285, 1285, 1321, 1329, 1329, 1283,
     1246, 1331, 1246, 1246, 1246, 1246, 1320, 1332, 1284, 1296,
     1296, 1296, 1297, 1297, 1297, 1283, 1332, 1246, 1289, 1289,

     1289, 1333, 1320, 1334, 1284, 1287, 1287, 1287, 1246, 1330,
     1330, 1285, 1335, 1336, 1285, 1287, 1338, 1287, 1287, 1287,
     1287, 1288, 1288, 1288, 1337, 1294, 1294, 1294, 1340, 1340,
     1285, 1288, 1287, 1288, 1288, 1288, 1288, 1348, 1348, 1289,
     1337, 1385, 1289, 1328, 1328, 1328, 1296, 1386, 1288, 1297,
     1298, 1298, 1298, 1395, 1396, 1289, 1292, 1292, 1292, 1397,
     1399, 1299, 1299, 1299, 1400, 1403, 1294, 1404, 1405, 1292,
     1292, 1292, 1294, 1301, 1301, 1301, 1302, 1302, 1302, 1303,
     1303, 1303, 1306, 1306, 1306, 1406, 1407, 1292, 1292, 1292,
     1292, 1298, 1298, 1408, 1292, 1409, 1410, 1292, 1411, 1413,

     1292, 1414, 1299, 1292, 1304, 1304, 1304, 1298, 1299, 1322,
     1322, 1322,  812,  811, 1304,  810, 1304, 1304, 1304, 1304,
     1303, 1303,  809, 1306,  808,  807, 1306,  804,  803,  802,
     1301, 1304,  801, 1302,  799,  798, 1303,  797,  796, 1306,
     1309, 1309, 1309,  795,  794,  793,  792, 1359, 1359, 1359,
     1322,  791,  790, 1309, 1309, 1309, 1324, 1324, 1324, 1339,
     1339, 1339,  789, 1326, 1326, 1326, 1322, 1341, 1341, 1341,
      788, 1309, 1309, 1309, 1309,  774,  772,  768, 1309,  767,
      766, 1309,  765,  764, 1309,  763,  762, 1309, 1323, 1323,
     1323, 1359, 1342, 1342, 1342,  761,  760, 1324, 1323,  759,

     1323, 1323, 1323, 1323, 1326, 1324,  758,  755, 1341, 1343,
     1343, 1343, 1326, 1324,  748, 1323, 1339,  746,  745,  744,
     1326, 1345, 1345, 1345, 1341,  743, 1349, 1349, 1349, 1323,
     1325, 1325, 1325, 1342, 1347, 1347, 1347, 1350, 1350, 1350,
     1325,  741, 1325, 1325, 1325, 1325,  737, 1343,  736, 1342,
     1343, 1351, 1351, 1351, 1354, 1354, 1354, 1325,  735,  734,
      733,  732, 1345, 1356, 1356, 1356, 1343,  730, 1345,  729,
      728, 1325, 1344, 1344, 1344, 1347,  727,  726, 1345,  725,
      724, 1347, 1344, 1349, 1344, 1344, 1344, 1344,  723,  721,
      720, 1347, 1351, 1351, 1350, 1354, 1357, 1357, 1357, 1344,

      719,  718,  717, 1354, 1356,  716,  715,  713, 1351,  712,
      711, 1354,  710, 1344, 1346, 1346, 1346,  709,  708,  706,
     1356,  701,  696,  694, 1346,  693, 1346, 1346, 1346, 1346,
      692,  691,  689,  685,  684,  683,  682, 1357,  681,  680,
      679, 1346,  678, 1357,  677,  676,  674,  672,  671,  670,
      669,  668,  667, 1357,  666, 1346, 1352, 1352, 1352,  665,
      664,  663,  662,  661,  660,  657, 1352,  649, 1352, 1352,
     1352, 1352,  647,  646,  645,  644,  643,  642,  641,  640,
      639,  638,  637, 1352,  636,  635,  634,  633,  632,  631,
      630,  629,  628,  626,  625,  624,  623, 1352,  622,  621,

      620,  619,  618,  617,  616,  614,  612,  611,  610,  609,
      607,  603,  602, 1352, 1353, 1353, 1353,  595,  594,  593,
      592,  591,  590,  589, 1353,  588, 1353, 1353, 1353, 1353,
      587,  586,  585,  582,  581,  580,  579,  578,  577,  576,
      575, 1353,  574,  573,  571,  570,  569,  568,  567,  566,
      565,  564,  563,  561,  560, 1353,  559,  557,  556,  555,
      554,  553,  552,  551,  550,  549,  546,  545,  544,  543,
      542, 1353, 1355, 1355, 1355,  541,  540,  539,  538,  537,
      535,  534, 1355,  533, 1355, 1355, 1355, 1355,  532,  531,
      530,  529,  528,  526,  525,  516,  515,  514,  512, 1355,

      511,  510,  509,  508,  507,  506,  505,  504,  503,  502,
      500,  498,  497, 1355,  495,  494,  493,  492,  491,  490,
      489,  488,  485,  484,  483,  482,  481,  480,  479, 1355,
     1358, 1358, 1358,  478,  477,  476,  475,  474,  472,  471,
     1358,  469, 1358, 1358, 1358, 1358,  468,  467,  466,  464,
      463,  462,  461,  460,  459,  458,  457, 1358,  456,  454,
      453,  452,  451,  450,  449,  448,  447,  446,  444,  443,
      442, 1358,  441,  440,  439,  438,  436,  435,  434,  433,
      432,  431,  430,  429,  428,  427,  426, 1358, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361,

     1361, 1362, 1362, 1362, 1362, 1362, 1362, 1362, 1362, 1362,
     1362, 1362, 1362, 1362, 1363, 1363, 1363, 1363, 1363, 1363,
     1363, 1363, 1363, 1363, 1363, 1363, 1363, 1364, 1364, 1364,
     1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364,
     1365, 1365, 1365, 1365, 1365, 1365, 1365, 1365, 1365, 1365,
     1365, 1365, 1365, 1366, 1366, 1366, 1366, 1366, 1366, 1366,
     1366, 1366, 1366, 1366, 1366, 1366, 1367, 1367, 1367, 1367,
     1367, 1367, 1367, 1367, 1367, 1367, 1367, 1367, 1367, 1368,
     1368, 1368, 1368, 1368, 1368, 1368, 1368, 1368, 1368, 1368,
     1368, 1368, 1369, 1369, 1369, 1369, 1369, 1369, 1369, 1369,

     1369, 1369, 1369, 1369, 1369, 1370, 1370, 1370, 1370, 1370,
     1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 1371, 1371,
     1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
     1371, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
     1372, 1372, 1372, 1372, 1373, 1373, 1373, 1373, 1373, 1373,
     1373, 1373, 1373, 1373, 1373, 1373, 1373, 1374, 1374, 1374,
     1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374,
     1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
     1375, 1375, 1375, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
     1376, 1376, 1376, 1376, 1376, 1376, 1377, 1377, 1377, 1377,

     1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1377, 1378,
      425,  424, 1378, 1378,  422, 1378, 1378, 1378, 1378, 1378,
     1379,  421,  420, 1379, 1379, 1379, 1379, 1379, 1379, 1379,
     1379, 1380, 1380,  419, 1380, 1380, 1380, 1380, 1380, 1380,
     1380, 1380, 1380, 1380, 1381,  418,  417,  416, 1381, 1382,
      415,  414, 1382, 1382, 1382, 1382, 1382, 1382, 1382, 1382,
      413, 1382, 1383,  412, 1383, 1383, 1383, 1384, 1384, 1387,
      411,  410, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1387,
     1388,  409,  408, 1388, 1388, 1388, 1388, 1388, 1388, 1388,
     1388, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1389,

     1389,  407, 1389, 1389, 1390, 1390, 1390, 1390, 1390, 1390,
     1390, 1390, 1390,  406, 1390, 1390, 1390, 1391, 1391, 1391,
     1391, 1391, 1391, 1391, 1391, 1391, 1391, 1391, 1392,  405,
      403,  402, 1392, 1393, 1393, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1398,  401,
      400,  398,  397, 1398, 1401,  396,  395,  394,  393, 1401,
     1402, 1402, 1402, 1402, 1402, 1402, 1402, 1402, 1402, 1402,
      392, 1402, 1402, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
     1412, 1412, 1412, 1412,  391, 1412,  390,  388,  387,  386,
      384,  383,  381,  380,  378,  377,  376,  375,  374,  373,

      372,  371,  370,  368,  366,  365,  364,  363,  362,  361,
      360,  359,  358,  357,  356,  355,  354,  353,  351,  350,
      349,  348,  347,  345,  342,  339,  338,  337,  336,  335,
      334,  333,  332,  331,  330,  329,  327,  326,  325,  324,
      322,  321,  320,  318,  317,  316,  315,  313,  312,  311,
      310,  309,  308,  304,  303,  302,  301,  300,  299,  298,
      296,  295,  294,  293,  291,  289,  288,  287,  286,  285,
      283,  280,  279,  278,  277,  276,  275,  274,  273,  272,
      271,  270,  269,  264,  262,  261,  259,  258,  257,  256,
      254,  253,  251,  250,  249,  248,  246,  242,  238,  236,

      234,  232,  231,  230,  229,  228,  226,  225,  223,  221,
      220,  219,  218,  217,  215,  214,  213,  212,  203,  196,
      192,  188,  184,  170,  169,  167,  161,  160,  159,  157,
      156,  155,  154,  153,  151,  149,  147,  145,  144,  143,
      142,  141,  135,  124,  120,  117,  114,  109,  108,  103,
       93,   82,   80,   78,   77,   76,   74,   73,   72,   70,
       68,   62,   58,   55,   52,   45,   42,   41,   34,   33,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,

     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "detex.l"

#line 97 "detex.l"
#undef IGNORE
#undef ECHO

#define	LaBEGIN		if (fLatex) BEGIN
#define	IGNORE		Ignore()
#define INCRLINENO	IncrLineNo()
#define ECHO		Echo()
#define NOUN		if (fSpace && !fWord && !fReplace) putchar(' '); else {if (fReplace) printf("noun");}
#define VERBNOUN		if (fReplace) printf(" verbs noun"); /* puts a verb and a noun to make grammar checking work */
#define	SPACE		if (!fWord) putchar(' ')
#define	NEWLINE		LineBreak()
#define	LATEX		fLatex=!fForcetex
#define KILLARGS(x)	cArgs=x; LaBEGIN LaMacro
#define STRIPARGS(x)	cArgs=x; LaBEGIN LaMacro2
#define	CITE(x)		if (fLatex && !fCite) KILLARGS(x)

#define NO_MALLOC_DECL

void LineBreak();
void Ignore();
void IncrLineNo();
void Echo();
void AddInclude(char *sbFile);
void ErrorExit(const char *sb1);
void UsageExit(void);
void VersionExit(void);
void IncludeFile(char *sbFile);
void InputFile(char *sbFile);
void SetEnvIgnore(const char *sbEnvList);
#ifndef KPATHSEA
void SetInputPaths(void);
#endif
void Warning(const char *sb1, const char *sb2);
int BeginEnv(const char *sbEnv);
int EndEnv(const char *sbEnv);
int InList(char *sbFile);
int SeparateList(char *sbList, char *rgsbList[] ,char chSep, int csbMax);
FILE *TexOpen(char *sbFile);
char *SafeMalloc(int cch, const char *sbMessage);
#ifndef KPATHSEA
char *getenv();
#ifndef NO_MALLOC_DECL
char	*malloc();
#endif
#ifdef OS2
void	yyless(int);
void	OS2UsageExit(void);
#endif
#endif /* KPATHSEA */

char	*rgsbEnvIgnore[MAXENVS];	/* list of environments ignored */
char	*rgsbIncList[MAXINCLIST];	/* list of includeonly files */
char	*rgsbInputPaths[MAXINPUTPATHS];	/* list of input paths in order */
char	sbCurrentIgnoredEnv[CCHMAXENV];	/* current environment being ignored */
char	*sbProgName;			/* name we were invoked with */
#ifndef NOFILE /* might be defined in <sys/param.h> */
#define NOFILE 256
#endif
FILE	*rgfp[NOFILE+1];		/* stack of input/include files */
int	cfp = 0;			/* count of files in stack */
int	cOpenBrace = 0;			/* count of `{' in <LaMacro> and <LaMacro2> */
int	cArgs = 0;			/* argument connt in <LaArgs> */
int	csbEnvIgnore;			/* count of environments ignored */
int	csbIncList = 0;			/* count of includeonly files */
int	csbInputPaths;			/* count of input paths */
int	fLatex = 0;			/* flag to indicated delatex */
int	fWord = 0;			/* flag for -w option */
int	fFollow = 1;			/* flag to follow input/include */
int	fCite = 0;			/* flag to echo \cite and \ref args */
int	fSpace = 0;			/* flag to replace \cs with space */
int	fForcetex = 0;			/* flag to inhibit latex mode */
int	fSrcLoc = 0;			/* flag to display source location of original file */
int fShowPictures = 0;	/* flag to show picture names */
int fReplace = 0;		/* flag to replace envirnments with "noun" */

int currBracesLevel = 0;
int footnoteLevel = -100;

#ifdef FLEX_SCANNER
/* flex has contexts for buffers that need to be switched when file changes
 * otherwise output contains imported files in reverse order.  Weird, but
 * true.
 */
YY_BUFFER_STATE rgsb[NOFILE + 1];		/* flex context stack */
char*			fFileNames[NOFILE + 1];	/* names of the buffers in context stack */
int				fFileLines[NOFILE + 1];	/* line number in each of the context files */
int				fIsColumn0 = 1;			/* Are we at the begining of a line? */
int				csb = 0;				/* depth of flex context stack */
#endif /* FLEX_SCANNER */

#line 1838 "lex.yy.c"

#line 1840 "lex.yy.c"

#define INITIAL 0
#define Define 1
#define Display 2
#define IncludeOnly 3
#define Input 4
#define Math 5
#define Normal 6
#define Control 7
#define LaBegin 8
#define LaDisplay 9
#define LaEnd 10
#define LaEnv 11
#define LaFormula 12
#define LaInclude 13
#define LaSubfile 14
#define LaMacro 15
#define LaOptArg 16
#define LaMacro2 17
#define LaOptArg2 18
#define LaVerbatim 19
#define LaBreak 20
#define LaPicture 21

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 208 "detex.l"

#line 2078 "lex.yy.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 1361 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 1360 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 209 "detex.l"
/* ignore comments */	{INCRLINENO;}
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 211 "detex.l"
{LATEX; IGNORE;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 213 "detex.l"
/* environment start */	{LaBEGIN LaBegin; IGNORE;}
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 215 "detex.l"
{ if (BeginEnv("verbatim"))
							BEGIN LaEnv;
						    else
							BEGIN LaVerbatim;
						    IGNORE;
						}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 222 "detex.l"
/* verbatim mode */	{BEGIN Normal; IGNORE;}
	YY_BREAK
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 223 "detex.l"
ECHO;
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 224 "detex.l"
ECHO;
	YY_BREAK
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 226 "detex.l"
{ KILLARGS(1);
						  if (BeginEnv("minipage"))
							BEGIN LaEnv;
						  else
							BEGIN LaMacro; /* Normal; */
						  IGNORE;
						}
	YY_BREAK
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 234 "detex.l"
{
						  if (BeginEnv("table"))
							BEGIN LaEnv;
						  else
							BEGIN Normal;
						  IGNORE;
						}
	YY_BREAK
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 242 "detex.l"
{
						  if (BeginEnv("figure"))
							BEGIN LaEnv;
						  else
							BEGIN Normal;
						  IGNORE;
						}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 250 "detex.l"
{ if (BeginEnv(yytext))
							BEGIN LaEnv;
						    else
							BEGIN Normal;
						    IGNORE;
						}
	YY_BREAK
/*<LaBegin>"\n"					NEWLINE;*/
case 12:
YY_RULE_SETUP
#line 257 "detex.l"
{INCRLINENO;}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 259 "detex.l"
/* absorb some environments */	{LaBEGIN LaEnd; IGNORE;}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 260 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 261 "detex.l"
{INCRLINENO;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 263 "detex.l"
/* end environment */	{   if (EndEnv(yytext))
							BEGIN Normal;
						    IGNORE;
						}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 267 "detex.l"
{BEGIN LaEnv; IGNORE;}
	YY_BREAK
/*<LaEnd>"\n"					NEWLINE;*/
case 18:
YY_RULE_SETUP
#line 269 "detex.l"
{INCRLINENO;}
	YY_BREAK
case 19:
/* rule 19 can match eol */
YY_RULE_SETUP
#line 271 "detex.l"
;
	YY_BREAK
case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 272 "detex.l"
;
	YY_BREAK
case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 273 "detex.l"
;
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 274 "detex.l"
;
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 275 "detex.l"
;
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 276 "detex.l"
;
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 277 "detex.l"
; /* hack to fix \begin{minipage}{300pt} */
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 279 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 280 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 281 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 282 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 283 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 284 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 285 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 286 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 287 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 288 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 289 "detex.l"
{ STRIPARGS(2); }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 290 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 291 "detex.l"
{ STRIPARGS(2); }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 292 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 293 "detex.l"
;
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 294 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 295 "detex.l"
{ LaBEGIN LaPicture; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 297 "detex.l"
;
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 298 "detex.l"
{ if(fShowPictures) { printf("<Picture %s>", yytext); } }
	YY_BREAK
case 45:
/* rule 45 can match eol */
YY_RULE_SETUP
#line 299 "detex.l"
{ BEGIN Normal; INCRLINENO; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 300 "detex.l"
BEGIN Normal;
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 302 "detex.l"
{ KILLARGS(3); }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 303 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 304 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 305 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 306 "detex.l"
{ KILLARGS(3); }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 307 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 308 "detex.l"
{ STRIPARGS(1); }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 309 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 310 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 311 "detex.l"
{ KILLARGS(3); }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 313 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 314 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 315 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 316 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 317 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 318 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 319 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 321 "detex.l"
/* ignore args  */	{KILLARGS(1); IGNORE;}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 322 "detex.l"
/* of these \cs */	{KILLARGS(1); IGNORE;}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 323 "detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 324 "detex.l"
{KILLARGS(1);} /* kill space before */
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 325 "detex.l"
{LATEX; KILLARGS(1); IGNORE;}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 326 "detex.l"
{LATEX; KILLARGS(1); IGNORE;}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 327 "detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 328 "detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 329 "detex.l"
{KILLARGS(1);}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 330 "detex.l"
{KILLARGS(1);}
	YY_BREAK
/*<Normal>"\\footnote"				{KILLARGS(1); SPACE;}*/
case 74:
YY_RULE_SETUP
#line 332 "detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 333 "detex.l"
{CITE(1); IGNORE;}
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 334 "detex.l"
{CITE(1); IGNORE;}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 335 "detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 336 "detex.l"
{CITE(1); IGNORE;}
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 337 "detex.l"
{KILLARGS(2); IGNORE;}
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 338 "detex.l"
{KILLARGS(2); IGNORE;}
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 339 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 340 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 342 "detex.l"
{KILLARGS(1);}
	YY_BREAK
case 84:
/* rule 84 can match eol */
YY_RULE_SETUP
#line 344 "detex.l"
{
							putchar('(');
							footnoteLevel = currBracesLevel;
							++currBracesLevel;
							}
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 349 "detex.l"
/* ignore \verb<ch>...<ch> */	{   if (fLatex) {
						 	char verbchar, c;
						 	verbchar = input();
						 	while ((c = input()) != verbchar)
							    /*if (c == '\n')
								NEWLINE;*/
								putchar(c);
						    }
						    IGNORE;
						}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 360 "detex.l"
{ LATEX; KILLARGS(2); }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 361 "detex.l"
{ LATEX; KILLARGS(2); }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 362 "detex.l"
{ LATEX; KILLARGS(3); }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 364 "detex.l"
/* ignore def begin */	{BEGIN Define; IGNORE;}
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 365 "detex.l"
BEGIN Normal;
	YY_BREAK
case 91:
/* rule 91 can match eol */
YY_RULE_SETUP
#line 366 "detex.l"
NEWLINE;
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 367 "detex.l"
;
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 369 "detex.l"
/* formula mode */	{LaBEGIN LaFormula; NOUN;}
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 370 "detex.l"
BEGIN Normal;
	YY_BREAK
case 95:
/* rule 95 can match eol */
YY_RULE_SETUP
#line 371 "detex.l"
NEWLINE;
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 372 "detex.l"
VERBNOUN;
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 373 "detex.l"
;
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 375 "detex.l"
/* display mode */	{LaBEGIN LaDisplay; NOUN;}
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 376 "detex.l"
BEGIN Normal;
	YY_BREAK
case 100:
/* rule 100 can match eol */
YY_RULE_SETUP
#line 377 "detex.l"
NEWLINE;
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 378 "detex.l"
VERBNOUN;
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 379 "detex.l"
;
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 381 "detex.l"
/* display mode */	{BEGIN Display; NOUN;}
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 382 "detex.l"
BEGIN Normal;
	YY_BREAK
case 105:
/* rule 105 can match eol */
YY_RULE_SETUP
#line 383 "detex.l"
NEWLINE;
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 384 "detex.l"
VERBNOUN;
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 385 "detex.l"
;
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 387 "detex.l"
/* math mode */		{BEGIN Math; NOUN;}
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 388 "detex.l"
BEGIN Normal;
	YY_BREAK
case 110:
/* rule 110 can match eol */
YY_RULE_SETUP
#line 389 "detex.l"
;
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 390 "detex.l"
;
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 391 "detex.l"
VERBNOUN;
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 392 "detex.l"
;
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 394 "detex.l"
/* process files */	{LaBEGIN LaInclude; IGNORE;}
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 395 "detex.l"
{   IncludeFile(yytext);
						    BEGIN Normal;
						}
	YY_BREAK
case 116:
/* rule 116 can match eol */
YY_RULE_SETUP
#line 398 "detex.l"
NEWLINE;
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 399 "detex.l"
;
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 401 "detex.l"
{BEGIN IncludeOnly; IGNORE;}
	YY_BREAK
case 119:
YY_RULE_SETUP
#line 402 "detex.l"
AddInclude(yytext);
	YY_BREAK
case 120:
YY_RULE_SETUP
#line 403 "detex.l"
{   if (csbIncList == 0)
							rgsbIncList[csbIncList++] = '\0';
						    BEGIN Normal;
						}
	YY_BREAK
case 121:
/* rule 121 can match eol */
YY_RULE_SETUP
#line 407 "detex.l"
NEWLINE;
	YY_BREAK
case 122:
YY_RULE_SETUP
#line 408 "detex.l"
;
	YY_BREAK
case 123:
YY_RULE_SETUP
#line 410 "detex.l"
/* process files */	{LaBEGIN LaSubfile; IGNORE;}
	YY_BREAK
case 124:
YY_RULE_SETUP
#line 411 "detex.l"
{   IncludeFile(yytext);
						    BEGIN Normal;
						}
	YY_BREAK
case 125:
/* rule 125 can match eol */
YY_RULE_SETUP
#line 414 "detex.l"
NEWLINE;
	YY_BREAK
case 126:
YY_RULE_SETUP
#line 415 "detex.l"
;
	YY_BREAK
case 127:
YY_RULE_SETUP
#line 417 "detex.l"
{BEGIN Input; IGNORE;}
	YY_BREAK
case 128:
YY_RULE_SETUP
#line 418 "detex.l"
{   InputFile(yytext);
						    BEGIN Normal;
						}
	YY_BREAK
case 129:
/* rule 129 can match eol */
YY_RULE_SETUP
#line 421 "detex.l"
NEWLINE;
	YY_BREAK
case 130:
YY_RULE_SETUP
#line 422 "detex.l"
;
	YY_BREAK
/* escaping commands */
case 131:
YY_RULE_SETUP
#line 425 "detex.l"
putchar('/');
	YY_BREAK
case 132:
/* rule 132 can match eol */
YY_RULE_SETUP
#line 427 "detex.l"
/* handle ligatures */	{(void)printf("%.2s", yytext+1);}
	YY_BREAK
case 133:
/* rule 133 can match eol */
YY_RULE_SETUP
#line 428 "detex.l"
{(void)printf("%.1s", yytext+1);}
	YY_BREAK
case 134:
YY_RULE_SETUP
#line 429 "detex.l"
{NEWLINE;}	/*BEGIN LaBreak;*/
	YY_BREAK
case 135:
YY_RULE_SETUP
#line 431 "detex.l"
/* ignore other \cs */	{BEGIN Control; IGNORE;}
	YY_BREAK
case 136:
YY_RULE_SETUP
#line 432 "detex.l"
SPACE;
	YY_BREAK
case 137:
/* rule 137 can match eol */
YY_RULE_SETUP
#line 433 "detex.l"
NEWLINE;
	YY_BREAK
case 138:
YY_RULE_SETUP
#line 434 "detex.l"
IGNORE;
	YY_BREAK
case 139:
YY_RULE_SETUP
#line 435 "detex.l"
{  if (yytext==NULL || strlen(yytext)==0
							|| atoi(yytext)>=0)
							NEWLINE;
						BEGIN Normal;
						}
	YY_BREAK
case 140:
YY_RULE_SETUP
#line 441 "detex.l"
IGNORE;
	YY_BREAK
case 141:
YY_RULE_SETUP
#line 442 "detex.l"
IGNORE;
	YY_BREAK
case 142:
/* rule 142 can match eol */
YY_RULE_SETUP
#line 443 "detex.l"
{BEGIN Normal; /*NEWLINE;*/}
	YY_BREAK
case 143:
YY_RULE_SETUP
#line 444 "detex.l"
{++currBracesLevel;BEGIN Normal; IGNORE;}
	YY_BREAK
case 144:
YY_RULE_SETUP
#line 445 "detex.l"
{BEGIN Normal; IGNORE;}
	YY_BREAK
case 145:
YY_RULE_SETUP
#line 446 "detex.l"
{yyless(0);BEGIN Normal;}
	YY_BREAK
case 146:
YY_RULE_SETUP
#line 448 "detex.l"
/* special characters */	IGNORE;
	YY_BREAK
case 147:
YY_RULE_SETUP
#line 449 "detex.l"
IGNORE;
	YY_BREAK
case 148:
YY_RULE_SETUP
#line 450 "detex.l"
SPACE;
	YY_BREAK
case 149:
YY_RULE_SETUP
#line 451 "detex.l"
putchar('-');
	YY_BREAK
case 150:
YY_RULE_SETUP
#line 452 "detex.l"
putchar('"');
	YY_BREAK
case 151:
YY_RULE_SETUP
#line 453 "detex.l"
putchar('\'');
	YY_BREAK
case 152:
YY_RULE_SETUP
#line 454 "detex.l"
putchar('"');
	YY_BREAK
case 153:
YY_RULE_SETUP
#line 455 "detex.l"
putchar('"');
	YY_BREAK
/* braces */
case 154:
YY_RULE_SETUP
#line 458 "detex.l"
{ ++currBracesLevel;
							}
	YY_BREAK
case 155:
YY_RULE_SETUP
#line 460 "detex.l"
{
							--currBracesLevel;
							if (currBracesLevel == footnoteLevel) {
								putchar(')');
								footnoteLevel = -100;
							}
							}
	YY_BREAK
case 156:
YY_RULE_SETUP
#line 467 "detex.l"
{   if (fWord)
							(void)printf("%s\n", yytext);
						    else
							ECHO;
						}
	YY_BREAK
case 157:
YY_RULE_SETUP
#line 472 "detex.l"
if (!fWord) ECHO;
	YY_BREAK
case 158:
YY_RULE_SETUP
#line 473 "detex.l"
{ INCRLINENO; if (!fWord) ECHO; }
	YY_BREAK
case 159:
/* rule 159 can match eol */
YY_RULE_SETUP
#line 474 "detex.l"
{ if (!fWord) NEWLINE; }
	YY_BREAK
case 160:
YY_RULE_SETUP
#line 475 "detex.l"
if (!fWord) putchar('\t');
	YY_BREAK
case 161:
YY_RULE_SETUP
#line 477 "detex.l"
{ BEGIN LaOptArg; }
	YY_BREAK
case 162:
YY_RULE_SETUP
#line 478 "detex.l"
{ cOpenBrace++; }
	YY_BREAK
case 163:
/* rule 163 can match eol */
YY_RULE_SETUP
#line 479 "detex.l"
{   cOpenBrace--; INCRLINENO;
						    if (cOpenBrace == 0)
						    {
							if (--cArgs==0)
							BEGIN Normal;
						    }
						}
	YY_BREAK
case 164:
YY_RULE_SETUP
#line 486 "detex.l"
;
	YY_BREAK
case 165:
YY_RULE_SETUP
#line 487 "detex.l"
BEGIN LaMacro;	
	YY_BREAK
case 166:
/* rule 166 can match eol */
YY_RULE_SETUP
#line 488 "detex.l"
;
	YY_BREAK
case 167:
YY_RULE_SETUP
#line 490 "detex.l"
{ BEGIN LaOptArg2; }
	YY_BREAK
case 168:
YY_RULE_SETUP
#line 491 "detex.l"
{ if (cOpenBrace == 0)
						    {
							if (--cArgs==0)
							{
							    BEGIN Normal;
							    cOpenBrace--;
							}
						    }
						  cOpenBrace++;
						}
	YY_BREAK
case 169:
YY_RULE_SETUP
#line 501 "detex.l"
{   cOpenBrace--; }
	YY_BREAK
case 170:
YY_RULE_SETUP
#line 502 "detex.l"
;
	YY_BREAK
case 171:
YY_RULE_SETUP
#line 503 "detex.l"
BEGIN LaMacro2;	
	YY_BREAK
case 172:
YY_RULE_SETUP
#line 504 "detex.l"
;
	YY_BREAK
case 173:
YY_RULE_SETUP
#line 505 "detex.l"
ECHO;
	YY_BREAK
#line 3118 "lex.yy.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(Define):
case YY_STATE_EOF(Display):
case YY_STATE_EOF(IncludeOnly):
case YY_STATE_EOF(Input):
case YY_STATE_EOF(Math):
case YY_STATE_EOF(Normal):
case YY_STATE_EOF(Control):
case YY_STATE_EOF(LaBegin):
case YY_STATE_EOF(LaDisplay):
case YY_STATE_EOF(LaEnd):
case YY_STATE_EOF(LaEnv):
case YY_STATE_EOF(LaFormula):
case YY_STATE_EOF(LaInclude):
case YY_STATE_EOF(LaSubfile):
case YY_STATE_EOF(LaMacro):
case YY_STATE_EOF(LaOptArg):
case YY_STATE_EOF(LaMacro2):
case YY_STATE_EOF(LaOptArg2):
case YY_STATE_EOF(LaVerbatim):
case YY_STATE_EOF(LaBreak):
case YY_STATE_EOF(LaPicture):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 1361 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 1361 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 1360);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 505 "detex.l"


/******
** main --
**	Set sbProgName to the base of arg 0.
**	Set the input paths.
**	Check for options
**		-c		echo LaTeX \cite, \ref, and \pageref values
**		-e <env-list>	list of LaTeX environments to ignore
**		-l		force latex mode
**		-n		do not follow \input and \include
**		-s		replace control sequences with space
**		-t		force tex mode
**		-w		word only output
**              -1              output some location information
**	Set the list of LaTeX environments to ignore.
**	Process each input file.
**	If no input files are specified on the command line, process stdin.
******/

int
main(int cArgs, char *rgsbArgs[])
{
	char	*pch, sbBadOpt[2];
	const char *sbEnvList = DEFAULTENV;
	int	fSawFile = 0, iArgs = 1;
	
	/* get base name and decide what we are doing, detex or delatex */
#ifdef OS2
	char drive[_MAX_DRIVE], dir[_MAX_DIR];
	char fname[_MAX_FNAME], ext[_MAX_EXT];
#ifdef __EMX__
	_wildcard(&cArgs, &rgsbArgs);
	_response(&cArgs, &rgsbArgs);
#endif
	_splitpath (rgsbArgs[0], drive, dir, fname, ext);
	sbProgName = strlwr(fname);
#elif defined(KPATHSEA)
	kpse_set_program_name (rgsbArgs[0], NULL);
	sbProgName = kpse_program_name;
#else
	if ((sbProgName = strrchr(rgsbArgs[0], '/')) != NULL)
	    sbProgName++;
	else
	    sbProgName = rgsbArgs[0];
#endif
	if (strcmp("delatex",sbProgName) == 0)
	    fLatex = 1;

#ifndef KPATHSEA
	/* set rgsbInputPaths for use with TexOpen() */
	SetInputPaths();
#endif

	/* process command line options */
	while (iArgs < cArgs && *(pch = rgsbArgs[iArgs]) == CHOPT) {
		while (*++pch)
		    switch (*pch) {
		    case CHCITEOPT:
			fCite = 1;
			break;
		    case CHENVOPT:
			if (++iArgs >= cArgs) {
				ErrorExit("-e option requires an argument");
			}
			sbEnvList = rgsbArgs[iArgs];
			break;
		    case CHLATEXOPT:
			fLatex = 1;
			break;
		    case CHNOFOLLOWOPT:
			fFollow = 0;
			break;
		    case CHSPACEOPT:
			fSpace = 1;
			break;
		    case CHTEXOPT:
			fForcetex = 1;
			break;
		    case CHWORDOPT:
			fWord = 1;
			break;
			case CHREPLACE:
			fReplace = 1;
			break;
			case CHVERSIONOPT:
			VersionExit();
			break;
			case CHSRCLOC:
			fSrcLoc = 1;
			break;
		    default:
			sbBadOpt[0] = *pch;
			sbBadOpt[1] = '\0';
			Warning("unknown option ignored -", sbBadOpt);
			UsageExit();
		    }
		iArgs++;
	}
	SetEnvIgnore(sbEnvList);

#ifdef WIN32
	_setmode(fileno(stdout), _O_BINARY);
#endif

	/* process input files */
	for (; iArgs < cArgs; iArgs++) {
	    fSawFile++;
	    if ((yyin = TexOpen(rgsbArgs[iArgs])) == NULL) {
		Warning("can't open file", rgsbArgs[iArgs]);
		continue;;
	    }
		fFileNames[csb] = rgsbArgs[iArgs];
		fFileLines[csb] = 1;
	    BEGIN Normal;
	    (void)yylex();
	}

	/* if there were no input files, assume stdin */
	if (!fSawFile) {
	    yyin = stdin;
#ifdef OS2
	    if (isatty(fileno(stdin)))
		OS2UsageExit();
#endif
	    BEGIN Normal;
	    (void)yylex();
	}
#ifndef FLEX_SCANNER
	if (YYSTATE != Normal)
	    ErrorExit("input contains an unterminated mode or environment");
#endif
	return(0);
}

#ifdef FLEX_SCANNER
#undef yywrap
#endif

/******
** yywrap -- handles EOF for lex.  Check to see if the stack of open files
**	has anything on it.  If it does, set yyin to the to value.  If not
**	return the termination signal for lex.
******/

int
yywrap(void)
{
	(void)fclose(yyin);
#ifdef FLEX_SCANNER
        /* Pop context state */
	if (csb > 0) {
		free(fFileNames[csb]);
		yy_delete_buffer( YY_CURRENT_BUFFER );
		yy_switch_to_buffer( rgsb[--csb] );
	}
#endif /* FLEX_SCANNER */
	if (cfp > 0) {
	    yyin = rgfp[--cfp];
	    return(0);
	}
	return(1);
}

#ifdef OS2

/******
** yyless -- return characters to the input stream.  Some systems don't have
**	a yyless routine
******/

void
yyless(int n)
{
	int 	i = strlen(yytext);

	while (i > n) unput(yytext[--i]);
	yytext[yyleng = n] = '\0';
}
#endif

/******
** PrintPrefix -- In case fSrcLoc is 1 and we are about to
**	print the first column of a line, we want to output the location of
**	that line in the original LaTeX document it came from.
******/

void
PrintPrefix()
{
	if (fSrcLoc && fIsColumn0) {
		printf("%s:%d: ", fFileNames[csb], fFileLines[csb]);
		fIsColumn0 = 0;
	}
}

/******
** LineBreak -- choses the proper way to break a line. If '-1' option is
**	enabled we also want to output some source location information.
******/

void
LineBreak()
{
	if (fWord) return;
	PrintPrefix();
	putchar('\n');
	fFileLines[csb]++; fIsColumn0=1;
}

/******
** Echo -- If we are at column 0 and have specified '-1'; output 
**	the source location information.
******/

void
Echo()
{
	PrintPrefix();
	fprintf(yyout, "%s", yytext);
}

/******
** IncrLineNo -- Increase the correct linenumber counter and
**	reset the the 'fIsColumn0' to true.
******/

void
IncrLineNo()
{
	char *c;
	for (c=yytext; *c != '\0'; c++) {
		if (*c == '\n') {
			fFileLines[csb]++; fIsColumn0=1;
		}
	}
}

/******
** Ignore -- Since we might need to track source location information we
**	cannot just ignore text. We must at least increase the linenumber counter.
******/

void 
Ignore()
{
	IncrLineNo();
	if (fSpace && !fWord) putchar(' ');
}

/******
** SetEnvIgnore -- sets rgsbEnvIgnore to the values indicated by the
**	sbEnvList.
******/

void
SetEnvIgnore(const char *sbEnvList)
{
	char *sb;
	sb = SafeMalloc(strlen(sbEnvList) + 1, "malloc for SetEnvIgnore failed");
	(void) strcpy(sb, sbEnvList);

	
	csbEnvIgnore = SeparateList(sb, rgsbEnvIgnore, CHENVSEP, MAXENVS);
	if (csbEnvIgnore == my_ERROR)
	    ErrorExit("The environment list contains too many environments");
}

/******
** BeginEnv -- checks to see if sbEnv is in the list rgsbEnvIgnore.  If it
**	is, sbCurrentIgnoredEnv is set to sbEnv.
******/

int
BeginEnv(const char *sbEnv)
{
	int	i;

	if (!fLatex) return(0);
	for (i = 0; i < csbEnvIgnore; ++i)
	    if (strcmp(sbEnv, rgsbEnvIgnore[i]) == 0) {
			(void)strcpy(sbCurrentIgnoredEnv, sbEnv);
			return(1);
	    }
	return(0);
}

/******
** EndEnv -- checks to see if sbEnv is the current environment being ignored.
******/

int
EndEnv(const char *sbEnv)
{
	if (!fLatex) return(0);
	if (strcmp(sbEnv, sbCurrentIgnoredEnv) == 0)
	    return(1);
	return(0);
}

/******
** InputFile -- push the current yyin and open sbFile.  If the open fails,
**	the sbFile is ignored.
******/


void
InputFile(char *sbFile)
{
	FILE	*TexOpen();

	if (!fFollow)
	    return;
	rgfp[cfp++] = yyin;
	if ((yyin = TexOpen(sbFile)) == NULL) {
	    Warning("can't open \\input file", sbFile);
	    yyin = rgfp[--cfp];
            return;
	} 
#ifdef FLEX_SCANNER
	rgsb[csb++]     = YY_CURRENT_BUFFER;
	fFileLines[csb] = 1;
	fFileNames[csb] = strdup(sbFile);
	yy_switch_to_buffer(yy_create_buffer( yyin, YY_BUF_SIZE ) );
#endif /* FLEX_SCANNER */
}

/******
** IncludeFile -- if sbFile is not in the rgsbIncList, push current yyin
**	and open sbFile.  If the open fails, the sbFile is ignored.
******/

void
IncludeFile(char *sbFile)
{
	FILE	*TexOpen();

	if (!fFollow)
	    return;
	if (!InList(sbFile))
	    return;
	rgfp[cfp++] = yyin;
	if ((yyin = TexOpen(sbFile)) == NULL) {
	    Warning("can't open \\include file", sbFile);
	    yyin = rgfp[--cfp];
            return;
	}
#ifdef FLEX_SCANNER
	rgsb[csb++]     = YY_CURRENT_BUFFER;
	fFileLines[csb] = 1;
	fFileNames[csb] = strdup(sbFile);
	yy_switch_to_buffer(yy_create_buffer( yyin, YY_BUF_SIZE ) );
#endif /* FLEX_SCANNER */
}

/******
** AddInclude -- adds sbFile to the rgsbIncList and increments csbIncList.
**	If the include list is too long, sbFile is ignored.
******/

void
AddInclude(char *sbFile)
{
	if (!fFollow)
	    return;
	if (csbIncList >= MAXINCLIST)
	    Warning("\\includeonly list is too long, ignoring", sbFile);
	rgsbIncList[csbIncList] = SafeMalloc(strlen(sbFile) + 1, "malloc for AddInclude failed");
	(void)strcpy(rgsbIncList[csbIncList++], sbFile);
}

/******
** InList -- checks to see if sbFile is in the rgsbIncList.  If there is
**	no list, all files are assumed to be "in the list".
******/

int
InList(char *sbFile)
{
	char	*pch, sbBase[PATH_MAX];
	int	i;

	if (csbIncList == 0)	/* no list */
	    return(1);
	(void)strcpy(sbBase, sbFile);
	if ((pch = strrchr(sbBase, '.')) != NULL)
	    *pch = '\0';
	i = 0;
	while ((i < csbIncList) && rgsbIncList[i])
	    if (strcmp(rgsbIncList[i++], sbBase) == 0)
	        return(1);
	return(0);
}

#ifndef KPATHSEA
/******
** SetInputPaths -- sets rgsbInputPaths to the values indicated by the
**	TEXINPUTS environment variable if set or else DEFAULTINPUTS.  If
**	the user's TEXINPUTS has a leading ':' prepend the DEFAULTINPUTS
**	to the path, if there is a trailing ':' append the DEFAULTINPUTS.
**	This is consistent with the most recent TeX.  However, this
**	routine does not honor the '//' construct (expand subdirs).
******/

void
SetInputPaths(void)
{
	const char *sb;
	char *sbPaths;
	int cchDefaults, cchPaths;

	cchDefaults = strlen(DEFAULTINPUTS);
#ifdef OS2
	if ((sb = getenv("TEXINPUT")) == NULL)
#endif
	    if ((sb = getenv("TEXINPUTS")) == NULL)
		sb = DEFAULTINPUTS;
	cchPaths = strlen(sb);
	if (sb[0] == CHPATHSEP)
	    cchPaths += cchDefaults;
	if (sb[strlen(sb) - 1] == CHPATHSEP)
	    cchPaths += cchDefaults;
	sbPaths = SafeMalloc(cchPaths + 1, "malloc for SetInputPaths failed");
	sbPaths[0] = '\0';
	if (sb[0] == CHPATHSEP)
	    (void)strcat(sbPaths, DEFAULTINPUTS);
	(void)strcat(sbPaths, sb);
	if (sb[strlen(sb) - 1] == CHPATHSEP)
	    (void)strcat(sbPaths, DEFAULTINPUTS);

	csbInputPaths = SeparateList(sbPaths, rgsbInputPaths, CHPATHSEP, MAXINPUTPATHS);
	if (csbInputPaths == my_ERROR)
#ifdef OS2
	    ErrorExit("TEXINPUT(S) environment variable has too many paths");
#else
	    ErrorExit("TEXINPUTS environment variable has too many paths");
#endif
}
#endif

/******
** SeparateList -- takes a chSep separated list sbList, replaces the
**	chSep's with NULLs and sets rgsbList[i] to the beginning of
**	the ith word in sbList.  The number of words is returned.  A
**	my_ERROR is returned if there are more than csbMax words.
******/

int
SeparateList(char *sbList, char *rgsbList[], char chSep, int csbMax)
{
	int	csbList = 0;

	while (sbList && *sbList && csbList < csbMax) {
	    rgsbList[csbList++] = sbList;
	    if ((sbList = strchr(sbList, chSep))) {
			*sbList++ = '\0';
		}
	}
	return(sbList && *sbList ? my_ERROR : csbList);
}

/******
** TexOpen -- tries to open sbFile in each of the rgsbInputPaths in turn.
**	For each input path the following order is used:
**		file.tex - must be as named, if not there go to the next path
**		file.ext - random extension, try it
**		file     - base name, add .tex and try it
**		file     - try it as is
**	Notice that if file exists in the first path and file.tex exists in
**	one of the other paths, file in the first path is what is opened.
**	If the sbFile begins with a '/', no paths are searched.
******/

FILE *
TexOpen(char *sbFile)
{
	char	*sbNew;
#ifndef KPATHSEA
	char	*pch;
	FILE	*fp;
	int	iPath;
	static char	sbFullPath[PATH_MAX];

	for (iPath = 0; iPath < csbInputPaths; iPath++) {
#ifdef OS2
	    if (*sbFile == '/' || *sbFile == '\\' || strchr(sbFile, ':')) {	/* absolute path */
#else
	    if (*sbFile == '/') {	/* absolute path */
#endif
			(void)snprintf(sbFullPath, PATH_MAX-1, "%s", sbFile);
			iPath = csbInputPaths;	/* only check once */
	    } else {
			(void)snprintf(sbFullPath, PATH_MAX-1, "%s/%s", rgsbInputPaths[iPath], sbFile);
		}
#ifdef OS2
	    pch = sbFullPath;
	    while (pch = strchr(pch, '\\')) {
			*pch = '/';
		}
#endif

	    /* If sbFile ends in .tex then it must be there */
	    if ((pch = strrchr(sbFullPath, '.')) != NULL
			&& (strcmp(pch, ".tex") == 0)) {
			if ((fp = fopen(sbFullPath, "r")) != NULL)
				return(fp);
			else
				continue;
	    }

	    /* if .<ext> then try to open it.  the '.' represents   */
	    /* the beginning of an extension if it is not the first */
	    /* character and it does not follow a '.' or a '/'      */
	    if (pch != NULL && pch > &(sbFullPath[0])
                    && *(pch - 1) != '.' && *(pch - 1) != '/'
		    && (fp = fopen(sbFullPath, "r")) != NULL) {
			return(fp);
		}

	    /* just base name, add .tex to the name */
	    sbNew = SafeMalloc(strlen(sbFullPath) + 5, "malloc for TexOpen failed");
	    (void)strcpy(sbNew, sbFullPath);
	    (void)strcat(sbNew, ".tex");
	    if ((fp = fopen(sbNew, "r")) != NULL) {
			free(sbNew);
			return(fp);
		}
		free(sbNew);

	    /* try sbFile regardless */
	    if ((fp = fopen(sbFullPath, "r")) != NULL)
			return(fp);
	}
	return NULL;
#else
	sbNew = kpse_find_file (sbFile, kpse_tex_format, false);

	if (sbNew == NULL)
	    return NULL;

	return fopen (sbNew, "r");
#endif
}

/******
** SafeMalloc -- wrapper around malloc() to check for failure.
******/

char *
SafeMalloc(int cch, const char *sbMessage)
{
	char *sb;

	if ((sb = (char *)malloc((unsigned)cch)) == NULL)
	    ErrorExit(sbMessage);
	return(sb);
}

/******
** Warning -- print a warning message preceded by the program name.
******/

void
Warning(const char *sb1, const char *sb2)
{
	(void)fprintf(stderr, "%s: warning: %s %s\n", sbProgName, sb1, sb2);
}

/******
** ErrorExit -- print an error message preceded by the program name.
**	Stdout is flushed and detex exits.
******/

void
ErrorExit(const char *sb1)
{
	(void)fflush(stdout);
	(void)fprintf(stderr, "%s: error: %s\n", sbProgName, sb1);
	exit(1);
}

/******
** UsageExit -- print usage message and exit.
******/

void
UsageExit(void)
{
	(void)printf("\n%s [ -clnrstw1 ] [ -e environment-list ] [ filename[.tex] ... ]\n",
		sbProgName);
	puts("  -c  echo LaTeX \\cite, \\ref, and \\pageref values\n  \
-e  <env-list> list of LaTeX environments to ignore\n  \
-l  force latex mode\n  \
-n  do not follow \\input, \\include and \\subfile\n  \
-r  replace math with \"noun\" and \"noun verbs noun\" to preserve grammar\n  \
-s  replace control sequences with space\n  \
-t  force tex mode\n  \
-w  word only output\n  \
-1  outputs the original file name and line number in the beginning of each line\n  \
-v  show program version and exit");
	exit(0);
}

/******
** VersionExit -- print version and exit.
******/

void
VersionExit(void)
{
	(void)printf("\nOpenDetex version %s\nhttps://github.com/pkubowicz/opendetex\n",
		VERSION);
	exit(0);
}

