/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.conflict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.plugins.conflict.AbstractConflictManager;
import org.apache.ivy.plugins.conflict.LatestConflictManager$IvyNodeArtifactInfo;
import org.apache.ivy.plugins.conflict.LatestConflictManager$NoConflictResolvedYetException;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.util.extendable.ExtendableItem;

public class LatestConflictManager
extends AbstractConflictManager {
    private LatestStrategy strategy;

    public LatestConflictManager() {
    }

    public LatestConflictManager(LatestStrategy latestStrategy) {
        this.strategy = latestStrategy;
    }

    public LatestConflictManager(String string, LatestStrategy latestStrategy) {
        this.setName(string);
        this.strategy = latestStrategy;
    }

    public Collection resolveConflicts(IvyNode ivyNode, Collection collection) {
        ExtendableItem extendableItem;
        if (collection.size() < 2) {
            return collection;
        }
        Object object = collection.iterator();
        while (object.hasNext()) {
            IvyNode ivyNode2 = (IvyNode)object.next();
            extendableItem = ivyNode2.getDependencyDescriptor(ivyNode);
            if (extendableItem == null || !extendableItem.isForce() || !ivyNode.getResolvedId().equals(extendableItem.getParentRevisionId())) continue;
            return Collections.singleton(ivyNode2);
        }
        object = collection.iterator();
        while (object.hasNext()) {
            extendableItem = ((IvyNode)object.next()).getResolvedId();
            if (!this.getSettings().getVersionMatcher().isDynamic((ModuleRevisionId)extendableItem)) continue;
            return null;
        }
        try {
            object = (LatestConflictManager$IvyNodeArtifactInfo)this.getStrategy().findLatest(LatestConflictManager.toArtifactInfo(collection), null);
            if (object != null) {
                return Collections.singleton(((LatestConflictManager$IvyNodeArtifactInfo)object).getNode());
            }
            return collection;
        }
        catch (LatestConflictManager$NoConflictResolvedYetException latestConflictManager$NoConflictResolvedYetException) {
            return null;
        }
    }

    protected static ArtifactInfo[] toArtifactInfo(Collection collection) {
        ArrayList<LatestConflictManager$IvyNodeArtifactInfo> arrayList = new ArrayList<LatestConflictManager$IvyNodeArtifactInfo>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IvyNode ivyNode = (IvyNode)iterator.next();
            arrayList.add(new LatestConflictManager$IvyNodeArtifactInfo(ivyNode));
        }
        return arrayList.toArray(new ArtifactInfo[arrayList.size()]);
    }

    public final LatestStrategy getStrategy() {
        if (this.strategy == null) {
            this.strategy = this.getSettings().getDefaultLatestStrategy();
        }
        return this.strategy;
    }

    public String toString() {
        if (this.strategy != null) {
            return String.valueOf(this.strategy);
        }
        return null;
    }
}

