/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2014  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD_SET_PRONUNCIATION_RULE_H
#define NJD_SET_PRONUNCIATION_RULE_H

#ifdef __cplusplus
#define NJD_SET_PRONUNCIATION_RULE_H_START extern "C" {
#define NJD_SET_PRONUNCIATION_RULE_H_END   }
#else
#define NJD_SET_PRONUNCIATION_RULE_H_START
#define NJD_SET_PRONUNCIATION_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD_SET_PRONUNCIATION_RULE_H_START;

static const char *njd_set_pronunciation_list[] = {
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "H", "H", "1",
   "F", "F", "1",
   "B", "B", "1",
   "@", "@", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "F", "F", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "~", "~", "1",
   "~", "~", "1",
   "~", "~", "1",
   "~F", "~F", "1",
   "~", "~", "1",
   "}", "}", "1",
   "|", "|", "1",
   "{", "{", "1",
   "z", "z", "1",
   "y", "y", "1",
   "x", "x", "1",
   "w", "w", "1",
   "v", "v", "1",
   "u", "u", "1",
   "tH", "tH", "1",
   "tF", "tF", "1",
   "tB", "tB", "1",
   "t@", "t@", "1",
   "t", "t", "1",
   "s", "s", "1",
   "s", "s", "1",
   "s", "s", "1",
   "sF", "sF", "1",
   "s", "s", "1",
   "r", "r", "1",
   "r", "r", "1",
   "r", "r", "1",
   "rF", "rF", "1",
   "r", "r", "1",
   "q", "q", "1",
   "q", "q", "1",
   "q", "q", "1",
   "qF", "qF", "1",
   "q", "q", "1",
   "p", "p", "1",
   "o", "o", "1",
   "n", "n", "1",
   "m", "m", "1",
   "l", "l", "1",
   "k", "k", "1",
   "j", "j", "1",
   "j", "j", "1",
   "j", "j", "1",
   "jF", "jF", "1",
   "j", "j", "1",
   "i", "i", "1",
   "hD", "hD", "1",
   "h", "h", "1",
   "gD", "gD", "1",
   "g", "g", "1",
   "f", "f", "1",
   "f", "f", "1",
   "f", "f", "1",
   "fF", "fF", "1",
   "fB", "fB", "1",
   "f", "f", "1",
   "e", "e", "1",
   "e", "e", "1",
   "e", "e", "1",
   "eB", "eB", "1",
   "e", "e", "1",
   "d", "d", "1",
   "cH", "cH", "1",
   "cF", "cF", "1",
   "cB", "cB", "1",
   "c@", "c@", "1",
   "c", "c", "1",
   "b", "b", "1",
   "a", "a", "1",
   "`", "`", "1",
   "`", "`", "1",
   "`", "`", "1",
   "`F", "`F", "1",
   "`", "`", "1",
   "_", "_", "1",
   "^", "^", "1",
   "]", "]", "1",
   "\", "\", "1",
   "[", "[", "1",
   "Z", "Z", "1",
   "YB", "YB", "1",
   "Y", "Y", "1",
   "XB", "XB", "1",
   "X", "X", "1",
   "W", "W", "1",
   "W", "W", "1",
   "W", "W", "1",
   "WF", "WF", "1",
   "W", "W", "1",
   "V", "V", "1",
   "V", "V", "1",
   "V", "V", "1",
   "VF", "VF", "1",
   "V", "V", "1",
   "U", "U", "1",
   "T", "T", "1",
   "S", "S", "1",
   "R", "R", "1",
   "Q", "Q", "1",
   "P", "P", "1",
   "O", "O", "1",
   "N", "N", "1",
   "M", "M", "1",
   "M", "M", "1",
   "M", "M", "1",
   "MF", "MF", "1",
   "M", "M", "1",
   "L", "L", "1",
   "L", "L", "1",
   "L", "L", "1",
   "LF", "LF", "1",
   "L", "L", "1",
   "K", "K", "1",
   "J", "J", "1",
   "I", "I", "1",
   "H", "H", "1",
   "G", "G", "1",
   "F", "F", "1",
   "EH", "EH", "1",
   "EF", "EF", "1",
   "EB", "EB", "1",
   "E", "E", "1",
   "D", "D", "1",
   "CF", "CF", "1",
   "C", "C", "1",
   "B", "B", "1",
   "A", "A", "1",
   "@", "@", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "肥", "F", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "݂", "~", "1",
   "݂", "~", "1",
   "݂", "~", "1",
   "݂", "~F", "1",
   "", "~", "1",
   "", "}", "1",
   "", "|", "1",
   "", "{", "1",
   "", "z", "1",
   "", "y", "1",
   "", "x", "1",
   "", "w", "1",
   "", "v", "1",
   "", "u", "1",
   "ӂ", "tH", "1",
   "ӂ", "tF", "1",
   "ӂ", "tB", "1",
   "ӂ", "t@", "1",
   "", "t", "1",
   "҂", "s", "1",
   "҂", "s", "1",
   "҂", "s", "1",
   "҂", "sF", "1",
   "", "s", "1",
   "т", "r", "1",
   "т", "r", "1",
   "т", "r", "1",
   "т", "rF", "1",
   "", "r", "1",
   "Ђ", "q", "1",
   "Ђ", "q", "1",
   "Ђ", "q", "1",
   "Ђ", "qF", "1",
   "", "q", "1",
   "", "p", "1",
   "", "o", "1",
   "", "n", "1",
   "", "m", "1",
   "", "l", "1",
   "", "k", "1",
   "ɂ", "j", "1",
   "ɂ", "j", "1",
   "ɂ", "j", "1",
   "ɂ", "jF", "1",
   "", "j", "1",
   "", "i", "1",
   "ǂ", "hD", "1",
   "", "h", "1",
   "Ƃ", "gD", "1",
   "", "g", "1",
   "ł", "f", "1",
   "ł", "f", "1",
   "ł", "f", "1",
   "ł", "fF", "1",
   "ł", "fB", "1",
   "", "f", "1",
   "Ă", "e", "1",
   "Ă", "e", "1",
   "Ă", "e", "1",
   "Ă", "eB", "1",
   "", "e", "1",
   "", "d", "1",
   "", "cH", "1",
   "", "cF", "1",
   "", "cB", "1",
   "", "c@", "1",
   "", "c", "1",
   "", "b", "1",
   "", "a", "1",
   "", "`", "1",
   "", "`", "1",
   "", "`", "1",
   "", "`F", "1",
   "", "`", "1",
   "", "_", "1",
   "", "^", "1",
   "", "]", "1",
   "", "\", "1",
   "", "[", "1",
   "", "Z", "1",
   "", "YB", "1",
   "", "Y", "1",
   "", "XB", "1",
   "", "X", "1",
   "", "W", "1",
   "", "W", "1",
   "", "W", "1",
   "", "WF", "1",
   "", "W", "1",
   "", "V", "1",
   "", "V", "1",
   "", "V", "1",
   "", "VF", "1",
   "", "V", "1",
   "", "U", "1",
   "", "T", "1",
   "", "S", "1",
   "", "R", "1",
   "", "Q", "1",
   "", "P", "1",
   "", "O", "1",
   "", "N", "1",
   "", "M", "1",
   "", "M", "1",
   "", "M", "1",
   "", "MF", "1",
   "", "M", "1",
   "", "L", "1",
   "", "L", "1",
   "", "L", "1",
   "", "LF", "1",
   "", "L", "1",
   "", "K", "1",
   "", "J", "1",
   "", "I", "1",
   "", "H", "1",
   "", "G", "1",
   "", "F", "1",
   "", "EH", "1",
   "", "EF", "1",
   "", "EB", "1",
   "", "E", "1",
   "", "D", "1",
   "", "CF", "1",
   "", "C", "1",
   "", "B", "1",
   "", "A", "1",
   "", "@", "1",
   "", "YB[", "2",
   "", "C", "2",
   "", "GbNX", "4",
   "", "_u[", "4",
   "", "uC", "2",
   "", "[", "2",
   "", "eB[", "2",
   "", "GX", "2",
   "", "A[", "3",
   "", "L[", "2",
   "", "s[", "2",
   "", "I[", "2",
   "", "Gk", "2",
   "", "G", "2",
   "", "G", "2",
   "", "P[", "2",
   "", "WF[", "2",
   "", "AC", "2",
   "", "GC`", "3",
   "", "W[", "2",
   "", "Gt", "2",
   "", "C[", "2",
   "", "fB[", "2",
   "", "V[", "2",
   "", "r[", "2",
   "", "GC", "2",
   "y", "YB[", "2",
   "x", "C", "2",
   "w", "GbNX", "4",
   "v", "_u[", "4",
   "u", "uC", "2",
   "t", "[", "2",
   "s", "eB[", "2",
   "r", "GX", "2",
   "q", "A[", "3",
   "p", "L[", "2",
   "o", "s[", "2",
   "n", "I[", "2",
   "m", "Gk", "2",
   "l", "G", "2",
   "k", "G", "2",
   "j", "P[", "2",
   "i", "WF[", "2",
   "h", "AC", "2",
   "g", "GC`", "3",
   "f", "W[", "2",
   "e", "Gt", "2",
   "d", "C[", "2",
   "c", "fB[", "2",
   "b", "V[", "2",
   "a", "r[", "2",
   "`", "GC", "2",
   "[", "[", "1",
   NULL, NULL, NULL
};

#define NJD_SET_PRONUNCIATION_KIGOU "L"
#define NJD_SET_PRONUNCIATION_KAZU ""

static const char *njd_set_pronunciation_symbol_list[] = {
   "@", "A",
   "A", "A",
   "B", "A",
   "C", "A",
   "D", "A",
   "E", "A",
   "F", "A",
   "G", "A",
   "H", "H",
   "I", "A",
   "J", "A",
   "K", "A",
   "L", "A",
   "M", "A",
   "N", "A",
   "O", "A",
   "P", "A",
   "Q", "A",
   "R", "A",
   "S", "A",
   "T", "A",
   "U", "A",
   "V", "A",
   "W", "A",
   "X", "A",
   "XX", "A",
   "Y", "A",
   "Z", "A",
   "\", "A",
   "\\", "A",
   "]", "A",
   "^", "A",
   "_", "A",
   "`", "A",
   "a", "A",
   "b", "A",
   "c", "A",
   "d", "A",
   "e", "A",
   "f", "A",
   "g", "A",
   "h", "A",
   "i", "A",
   "j", "A",
   "k", "A",
   "l", "A",
   "m", "A",
   "n", "A",
   "o", "A",
   "p", "A",
   "q", "A",
   "r", "A",
   "s", "A",
   "t", "A",
   "u", "A",
   "v", "A",
   "w", "A",
   "x", "A",
   "y", "A",
   "z", "A",
   "||", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "", "A",
   "|", "A",
   NULL, NULL
};

#define NJD_SET_PRONUNCIATION_FILLER "tB["

#define NJD_SET_PRONUNCIATION_U        "E"
#define NJD_SET_PRONUNCIATION_DOUSHI   ""
#define NJD_SET_PRONUNCIATION_JODOUSHI ""
#define NJD_SET_PRONUNCIATION_CHOUON   "["

#define NJD_SET_PRONUNCIATION_QUESTION  "H"
#define NJD_SET_PRONUNCIATION_DESU_STR  "ł"
#define NJD_SET_PRONUNCIATION_MASU_STR  "܂"
#define NJD_SET_PRONUNCIATION_DESU_PRON "fX"
#define NJD_SET_PRONUNCIATION_MASU_PRON "}X"

NJD_SET_PRONUNCIATION_RULE_H_END;

#endif                          /* !NJD_SET_PRONUNCIATION_RULE_H */
