/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2014  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD_SET_ACCENT_PHRASE_RULE_H
#define NJD_SET_ACCENT_PHRASE_RULE_H

#ifdef __cplusplus
#define NJD_SET_ACCENT_PHRASE_RULE_H_START extern "C" {
#define NJD_SET_ACCENT_PHRASE_RULE_H_END   }
#else
#define NJD_SET_ACCENT_PHRASE_RULE_H_START
#define NJD_SET_ACCENT_PHRASE_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD_SET_ACCENT_PHRASE_RULE_H_START;

/*
  Rule 01 \xa5\xc7\xa5\xd5\xa5\xa9\xa5\xeb\xa5\xc8\xa4\xcf\xa4\xaf\xa4\xc3\xa4\xc4\xa4\xb1\xa4\xeb
  Rule 02 \xa1\xd6\xcc\xbe\xbb\xec\xa1\xd7\xa4\xce\xcf\xa2\xc2\xb3\xa4\xcf\xa4\xaf\xa4\xc3\xa4\xc4\xa4\xb1\xa4\xeb
  Rule 03 \xa1\xd6\xb7\xc1\xcd\xc6\xbb\xec\xa1\xd7\xa4\xce\xb8\xe5\xa4\xcb\xa1\xd6\xcc\xbe\xbb\xec\xa1\xd7\xa4\xac\xa4\xad\xa4\xbf\xa4\xe9\xca\xcc\xa4\xce\xa5\xa2\xa5\xaf\xa5\xbb\xa5\xf3\xa5\xc8\xb6\xe7\xa4\xcb
  Rule 04 \xa1\xd6\xcc\xbe\xbb\xec,\xb7\xc1\xcd\xc6\xc6\xb0\xbb\xec\xb8\xec\xb4\xb4\xa1\xd7\xa4\xce\xb8\xe5\xa4\xcb\xa1\xd6\xcc\xbe\xbb\xec\xa1\xd7\xa4\xac\xa4\xad\xa4\xbf\xa4\xe9\xca\xcc\xa4\xce\xa5\xa2\xa5\xaf\xa5\xbb\xa5\xf3\xa5\xc8\xb6\xe7\xa4\xcb
  Rule 05 \xa1\xd6\xc6\xb0\xbb\xec\xa1\xd7\xa4\xce\xb8\xe5\xa4\xcb\xa1\xd6\xb7\xc1\xcd\xc6\xbb\xec\xa1\xd7or\xa1\xd6\xcc\xbe\xbb\xec\xa1\xd7\xa4\xac\xa4\xad\xa4\xbf\xa4\xe9\xca\xcc\xa4\xce\xa5\xa2\xa5\xaf\xa5\xbb\xa5\xf3\xa5\xc8\xb6\xe7\xa4\xcb
  Rule 06 \xa1\xd6\xc9\xfb\xbb\xec\xa1\xd7\xa1\xa4\xa1\xd6\xc0\xdc\xc2\xb3\xbb\xec\xa1\xd7\xa1\xa4\xa1\xd6\xcf\xa2\xc2\xce\xbb\xec\xa1\xd7\xa4\xcf\xc3\xb1\xc6\xc8\xa4\xce\xa5\xa2\xa5\xaf\xa5\xbb\xa5\xf3\xa5\xc8\xb6\xe7\xa4\xcb
  Rule 07 \xa1\xd6\xcc\xbe\xbb\xec,\xc9\xfb\xbb\xec\xb2\xc4\xc7\xbd\xa1\xd7\xa1\xca\xa4\xb9\xa4\xd9\xa4\xc6\xa1\xa4\xa4\xca\xa4\xc9\xa1\xcb\xa4\xcf\xc3\xb1\xc6\xc8\xa4\xce\xa5\xa2\xa5\xaf\xa5\xbb\xa5\xf3\xa5\xc8\xb6\xe7\xa4\xcb
  Rule 08 \xa1\xd6\xbd\xf5\xbb\xec\xa1\xd7or\xa1\xd6\xbd\xf5\xc6\xb0\xbb\xec\xa1\xd7\xa1\xca\xc9\xd5\xc2\xb0\xb8\xec\xa1\xcb\xa4\xcf\xc1\xb0\xa4\xcb\xa4\xaf\xa4\xc3\xa4\xc4\xa4\xb1\xa4\xeb
  Rule 09 \xa1\xd6\xbd\xf5\xbb\xec\xa1\xd7or\xa1\xd6\xbd\xf5\xc6\xb0\xbb\xec\xa1\xd7\xa1\xca\xc9\xd5\xc2\xb0\xb8\xec\xa1\xcb\xa4\xce\xb8\xe5\xa4\xce\xa1\xd6\xbd\xf5\xbb\xec\xa1\xd7\xa1\xa4\xa1\xd6\xbd\xf5\xc6\xb0\xbb\xec\xa1\xd7\xb0\xca\xb3\xb0\xa1\xca\xbc\xab\xce\xa9\xb8\xec\xa1\xcb\xa4\xcf\xca\xcc\xa4\xce\xa5\xa2\xa5\xaf\xa5\xbb\xa5\xf3\xa5\xc8\xb6\xe7\xa4\xcb
  Rule 10 \xa1\xd6*,\xc0\xdc\xc8\xf8\xa1\xd7\xa4\xce\xb8\xe5\xa4\xce\xa1\xd6\xcc\xbe\xbb\xec\xa1\xd7\xa4\xcf\xca\xcc\xa4\xce\xa5\xa2\xa5\xaf\xa5\xbb\xa5\xf3\xa5\xc8\xb6\xe7\xa4\xcb
  Rule 11 \xa1\xd6\xb7\xc1\xcd\xc6\xbb\xec,\xc8\xf3\xbc\xab\xce\xa9\xa1\xd7\xa4\xcf\xa1\xd6\xc6\xb0\xbb\xec,\xcf\xa2\xcd\xd1*\xa1\xd7or\xa1\xd6\xb7\xc1\xcd\xc6\xbb\xec,\xcf\xa2\xcd\xd1*\xa1\xd7or\xa1\xd6\xbd\xf5\xbb\xec,\xc0\xdc\xc2\xb3\xbd\xf5\xbb\xec,\xa4\xc6\xa1\xd7or\xa1\xd6\xbd\xf5\xbb\xec,\xc0\xdc\xc2\xb3\xbd\xf5\xbb\xec,\xa4\xc7\xa1\xd7\xa4\xcb\xc0\xdc\xc2\xb3\xa4\xb9\xa4\xeb\xbe\xec\xb9\xe7\xa4\xcb\xc1\xb0\xa4\xcb\xa4\xaf\xa4\xc3\xa4\xc4\xa4\xb1\xa4\xeb
  Rule 12 \xa1\xd6\xc6\xb0\xbb\xec,\xc8\xf3\xbc\xab\xce\xa9\xa1\xd7\xa4\xcf\xa1\xd6\xc6\xb0\xbb\xec,\xcf\xa2\xcd\xd1*\xa1\xd7or\xa1\xd6\xcc\xbe\xbb\xec,\xa5\xb5\xca\xd1\xc0\xdc\xc2\xb3\xa1\xd7\xa4\xcb\xc0\xdc\xc2\xb3\xa4\xb9\xa4\xeb\xbe\xec\xb9\xe7\xa4\xcb\xc1\xb0\xa4\xcb\xa4\xaf\xa4\xc3\xa4\xc4\xa4\xb1\xa4\xeb
  Rule 13 \xa1\xd6\xcc\xbe\xbb\xec\xa1\xd7\xa4\xce\xb8\xe5\xa4\xcb\xa1\xd6\xc6\xb0\xbb\xec\xa1\xd7or\xa1\xd6\xb7\xc1\xcd\xc6\xbb\xec\xa1\xd7or\xa1\xd6\xcc\xbe\xbb\xec,\xb7\xc1\xcd\xc6\xc6\xb0\xbb\xec\xb8\xec\xb4\xb4\xa1\xd7\xa4\xac\xa4\xad\xa4\xbf\xa4\xe9\xca\xcc\xa4\xce\xa5\xa2\xa5\xaf\xa5\xbb\xa5\xf3\xa5\xc8\xb6\xe7\xa4\xcb
  Rule 14 \xa1\xd6\xb5\xad\xb9\xe6\xa1\xd7\xa4\xcf\xc3\xb1\xc6\xc8\xa4\xce\xa5\xa2\xa5\xaf\xa5\xbb\xa5\xf3\xa5\xc8\xb6\xe7\xa4\xcb
  Rule 15 \xa1\xd6\xc0\xdc\xc6\xac\xbb\xec\xa1\xd7\xa4\xcf\xc3\xb1\xc6\xc8\xa4\xce\xa5\xa2\xa5\xaf\xa5\xbb\xa5\xf3\xa5\xc8\xb6\xe7\xa4\xcb
  Rule 16 \xa1\xd6*,*,*,\xc0\xab\xa1\xd7\xa4\xce\xb8\xe5\xa4\xce\xa1\xd6\xcc\xbe\xbb\xec\xa1\xd7\xa4\xcf\xca\xcc\xa4\xce\xa5\xa2\xa5\xaf\xa5\xbb\xa5\xf3\xa5\xc8\xb6\xe7\xa4\xcb
  Rule 17 \xa1\xd6\xcc\xbe\xbb\xec\xa1\xd7\xa4\xce\xb8\xe5\xa4\xce\xa1\xd6*,*,*,\xcc\xbe\xa1\xd7\xa4\xcf\xca\xcc\xa4\xce\xa5\xa2\xa5\xaf\xa5\xbb\xa5\xf3\xa5\xc8\xb6\xe7\xa4\xcb
  Rule 18 \xa1\xd6*,\xc0\xdc\xc8\xf8\xa1\xd7\xa4\xcf\xc1\xb0\xa4\xcb\xa4\xaf\xa4\xc3\xa4\xc4\xa4\xb1\xa4\xeb
*/

#define NJD_SET_ACCENT_PHRASE_MEISHI "\xcc\xbe\xbb\xec"
#define NJD_SET_ACCENT_PHRASE_KEIYOUSHI "\xb7\xc1\xcd\xc6\xbb\xec"
#define NJD_SET_ACCENT_PHRASE_DOUSHI "\xc6\xb0\xbb\xec"
#define NJD_SET_ACCENT_PHRASE_FUKUSHI "\xc9\xfb\xbb\xec"
#define NJD_SET_ACCENT_PHRASE_SETSUZOKUSHI "\xc0\xdc\xc2\xb3\xbb\xec"
#define NJD_SET_ACCENT_PHRASE_RENTAISHI "\xcf\xa2\xc2\xce\xbb\xec"
#define NJD_SET_ACCENT_PHRASE_JODOUSHI "\xbd\xf5\xc6\xb0\xbb\xec"
#define NJD_SET_ACCENT_PHRASE_JOSHI "\xbd\xf5\xbb\xec"
#define NJD_SET_ACCENT_PHRASE_KIGOU "\xb5\xad\xb9\xe6"
#define NJD_SET_ACCENT_PHRASE_KEIYOUDOUSHI_GOKAN "\xb7\xc1\xcd\xc6\xc6\xb0\xbb\xec\xb8\xec\xb4\xb4"
#define NJD_SET_ACCENT_PHRASE_FUKUSHI_KANOU "\xc9\xfb\xbb\xec\xb2\xc4\xc7\xbd"
#define NJD_SET_ACCENT_PHRASE_SETSUBI "\xc0\xdc\xc8\xf8"
#define NJD_SET_ACCENT_PHRASE_HIJIRITSU "\xc8\xf3\xbc\xab\xce\xa9"
#define NJD_SET_ACCENT_PHRASE_RENYOU "\xcf\xa2\xcd\xd1"
#define NJD_SET_ACCENT_PHRASE_SETSUZOKUJOSHI "\xc0\xdc\xc2\xb3\xbd\xf5\xbb\xec"
#define NJD_SET_ACCENT_PHRASE_SAHEN_SETSUZOKU "\xa5\xb5\xca\xd1\xc0\xdc\xc2\xb3"
#define NJD_SET_ACCENT_PHRASE_TE "\xa4\xc6"
#define NJD_SET_ACCENT_PHRASE_DE "\xa4\xc7"
#define NJD_SET_ACCENT_PHRASE_SETTOUSHI "\xc0\xdc\xc6\xac\xbb\xec"
#define NJD_SET_ACCENT_PHRASE_SEI "\xc0\xab"
#define NJD_SET_ACCENT_PHRASE_MEI "\xcc\xbe"

NJD_SET_ACCENT_PHRASE_RULE_H_END;

#endif                          /* !NJD_SET_ACCENT_PHRASE_RULE_H */
