# How to Contribute

We welcome community contributions to oneAPI DPC++ Library (oneDPL). You can:

- Submit your changes directly with a [pull request](https://github.com/oneapi-src/oneDPL/pulls).
- Log a bug or feedback with an [issue](https://github.com/oneapi-src/oneDPL/issues).

# Pull Requests

This project follows the
[GitHub flow](https://guides.github.com/introduction/flow/index.html). To submit
your change directly to the repository:

- Make sure your code is in line with our
  [coding conventions](#coding-conventions).
- Submit a
  [pull request](https://docs.github.com/en/free-pro-team@latest/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request) into the
  main branch. You may add a description of your contribution into [CREDITS.txt](https://github.com/oneapi-src/oneDPL/blob/main/CREDITS.txt).

# Coding Conventions

Running clang-format is required, except in the [test folder](https://github.com/oneapi-src/oneDPL/tree/main/test).

# License

oneDPL is licensed under the terms in [LICENSE](https://github.com/oneapi-src/oneDPL/blob/release_oneDPL/licensing/LICENSE.txt).
By contributing to the project, you agree to the license and copyright terms therein and
release your contribution under these terms.

# Sign Your Work

Please use the sign-off line at the end of the patch. Your signature certifies
that you wrote the patch or otherwise have the right to pass it on as an
open-source patch. The rules are simple: If you can certify
the content below (from [developercertificate.org](http://developercertificate.org/)):

```
Developer Certificate of Origin
Version 1.1

Copyright (C) 2004, 2006 The Linux Foundation and its contributors.
660 York Street, Suite 102,
San Francisco, CA 94110 USA

Everyone is permitted to copy and distribute verbatim copies of this
license document, but changing it is not allowed.

Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

(a) The contribution was created in whole or in part by me and I
    have the right to submit it under the open source license
    indicated in the file; or

(b) The contribution is based upon previous work that, to the best
    of my knowledge, is covered under an appropriate open source
    license and I have the right under that license to submit that
    work with modifications, whether created in whole or in part
    by me, under the same open source license (unless I am
    permitted to submit under a different license), as indicated
    in the file; or

(c) The contribution was provided directly to me by some other
    person who certified (a), (b) or (c) and I have not modified
    it.

(d) I understand and agree that this project and the contribution
    are public and that a record of the contribution (including all
    personal information I submit with it, including my sign-off) is
    maintained indefinitely and may be redistributed consistent with
    this project or the open source license(s) involved.
```

Then you can add a line to every git commit message:

    Signed-off-by: Name Surname <user@email.com>

Use your real name (sorry, no pseudonyms or anonymous contributions.)

If you set your `user.name` and `user.email` git configs, you can sign your
commit automatically with `git commit -s`.



