/*
 * $TSUKUBA_Release: Omni OpenMP Compiler 3 $
 * $TSUKUBA_Copyright:
 *  PLEASE DESCRIBE LICENSE AGREEMENT HERE
 *  $
 */
#ifndef _C_ACC_H
#define _C_ACC_H

enum ACC_pragma {
  ACC_PARALLEL,
  ACC_END_PARALLEL,
  ACC_DATA,
  ACC_END_DATA,
  ACC_LOOP, //no ACC_END_LOOP
  ACC_PARALLEL_LOOP,
  ACC_END_PARALLEL_LOOP,
  ACC_KERNELS_LOOP,
  ACC_END_KERNELS_LOOP,
  ACC_ATOMIC,
  ACC_END_ATOMIC,
  ACC_KERNELS,
  ACC_END_KERNELS,
  ACC_WAIT,
  ACC_CACHE,
  ACC_ROUTINE,
  ACC_ENTER_DATA,
  ACC_EXIT_DATA,
  ACC_HOST_DATA,
  ACC_END_HOST_DATA,
  ACC_DECLARE,
  ACC_UPDATE_D,
  ACC_INIT,
  ACC_SHUTDOWN,
  ACC_SET,

  ACC_DIR_END
};

enum ACC_pragma_clause {
  ACC_CLAUSE_IF = 500,
  ACC_CLAUSE_ASYNC,
  ACC_CLAUSE_WAIT,
  ACC_CLAUSE_DEVICE_TYPE,

  ACC_CLAUSE_WAIT_ARG,
  ACC_CLAUSE_CACHE_ARG,
  ACC_CLAUSE_ROUTINE_ARG,

  //data clause
  ACC_CLAUSE_COPY,
  ACC_CLAUSE_COPYIN,
  ACC_CLAUSE_COPYOUT,
  ACC_CLAUSE_CREATE,
  ACC_CLAUSE_PRESENT,
  ACC_CLAUSE_PRESENT_OR_COPY,
  ACC_CLAUSE_PRESENT_OR_COPYIN,
  ACC_CLAUSE_PRESENT_OR_COPYOUT,
  ACC_CLAUSE_PRESENT_OR_CREATE,
  ACC_CLAUSE_DEVICEPTR,

  //compute clause
  ACC_CLAUSE_NUM_GANGS,
  ACC_CLAUSE_NUM_WORKERS,
  ACC_CLAUSE_VECTOR_LENGTH,
  ACC_CLAUSE_DEFAULT,
  ACC_CLAUSE_NONE,

  //reductions
  ACC_CLAUSE_REDUCTION_PLUS,
  ACC_CLAUSE_REDUCTION_MUL,
  ACC_CLAUSE_REDUCTION_MAX,
  ACC_CLAUSE_REDUCTION_MIN,
  ACC_CLAUSE_REDUCTION_BITAND,
  ACC_CLAUSE_REDUCTION_BITOR,
  ACC_CLAUSE_REDUCTION_BITXOR,
  ACC_CLAUSE_REDUCTION_LOGAND,
  ACC_CLAUSE_REDUCTION_LOGOR,
  ACC_CLAUSE_REDUCTION_EQV,
  ACC_CLAUSE_REDUCTION_NEQV,

  //for parallel
  ACC_CLAUSE_PRIVATE,
  ACC_CLAUSE_FIRSTPRIVATE,

  //for loop
  ACC_CLAUSE_COLLAPSE,
  ACC_CLAUSE_GANG,
  ACC_CLAUSE_WORKER,
  ACC_CLAUSE_VECTOR,
  ACC_CLAUSE_STATIC,
  ACC_CLAUSE_SEQ,
  ACC_CLAUSE_AUTO,
  ACC_CLAUSE_TILE,
  ACC_CLAUSE_INDEPENDENT,

  //for routine
  ACC_CLAUSE_BIND,
  ACC_CLAUSE_NOHOST,

  //for atomic
  ACC_CLAUSE_READ,
  ACC_CLAUSE_WRITE,
  ACC_CLAUSE_UPDATE,
  ACC_CLAUSE_CAPTURE,

  //for exit
  ACC_CLAUSE_DELETE,
  ACC_CLAUSE_FINALIZE,

  //for host_data
  ACC_CLAUSE_USE_DEVICE,

  //for declare
  ACC_CLAUSE_DEVICE_RESIDENT,
  ACC_CLAUSE_LINK,

  //for update
  ACC_CLAUSE_HOST,
  ACC_CLAUSE_DEVICE,
  ACC_CLAUSE_IF_PRESENT,

  //for set
  ACC_CLAUSE_DEVICE_NUM,
  ACC_CLAUSE_DEFAULT_ASYNC,


  //others
  ACC_ASTERISK,
  ACC_COMMONBLOCK,

  ACC_CLAUSE_END
};

#endif
