#!/bin/bash

#-------------------------------------------------------
#  generator for xmp_lib_coarray_reduction.h
#-------------------------------------------------------

#--------------------
#  sub
#--------------------
echo72 () {
    str="$1                                                                        "
    str=`echo "$str" | cut -c -72`"&"
    echo "$str"
}

print_broadcast() {
    tk=$1
    typekind=$2
    echo "      subroutine xmpf_co_broadcast${DIM}d_${tk}(source, source_image)"
    case ${DIM} in
        0)  echo    "      ${typekind}, intent(inout) :: source" ;;
        1)  echo    "      ${typekind}, intent(inout) :: source(:)" ;;
        *)  echo -n "      ${typekind}, intent(inout) :: source(:"
            for i in `seq 2 ${DIM}`; do
                echo -n ',:'
            done
            echo ')' ;;
    esac
    echo "      integer, intent(in) :: source_image"
    echo "      end subroutine"
    echo
}

print_reduction() {
    tk=$1
    typekind=$2
    echo "      subroutine xmpf_co_${OP}${DIM}d_${tk}(source, result)"

    case ${DIM} in
        0)  echo    "      ${typekind}, intent(in)  :: source" ;;
        1)  echo    "      ${typekind}, intent(in)  :: source(:)" ;;
        *)  echo -n "      ${typekind}, intent(in)  :: source(:"
            for i in `seq 2 ${DIM}`; do
                echo -n ',:'
            done
            echo ')' ;;
    esac

    case ${DIM} in
        0)  echo    "      ${typekind}, intent(out) :: result" ;;
        1)  echo    "      ${typekind}, intent(out) :: result(:)" ;;
        *)  echo -n "      ${typekind}, intent(out) :: result(:"
            for i in `seq 2 ${DIM}`; do
                echo -n ',:'
            done
            echo ')' ;;
    esac

    echo "      end subroutine"
    echo
}


#--------------------
#  main
#--------------------
echo "!! This file is automatically generated by $0"
echo '!!'
echo '!! RESTRICTIONS in XMP/F'
echo '!!  - Quadruple precision real and complex are not supported.'
echo '!!  - The rank (number of dimensions) cannot exceed 7.'
echo '!!'
echo ''
echo '!-----------------------------------------------------------------------'
echo '      interface xmpf_co_broadcast_generic'
echo '!-----------------------------------------------------------------------'
echo ''

TARGET=$1
for DIM in `seq 0 7`
do
    if test "sxace-nec-superux" != "$TARGET"; then    ## integer(2) cannot be used on SX-ACE
	print_broadcast i2  "integer(2)"
    fi
    print_broadcast i4  "integer(4)"      
    print_broadcast i8  "integer(8)"
    print_broadcast r4  "real(4)"         
    print_broadcast r8  "real(8)"         
    print_broadcast z8  "complex(4)"      
    print_broadcast z16 "complex(8)"      
    if test "sxace-nec-superux" != "$TARGET"; then    ## logical(2) cannot be used on SX-ACE
	print_broadcast l2  "logical(2)"
    fi
    print_broadcast l4  "logical(4)"      
done

echo '      end interface'
echo ''

for OP in sum max min
do

echo '!-----------------------------------------------------------------------'
echo "      interface xmpf_co_${OP}_generic"
echo '!-----------------------------------------------------------------------'
echo ''
for DIM in `seq 0 7`
do
    if test "sxace-nec-superux" != "$TARGET"; then    ## integer(2) cannot be used on SX-ACE
	print_reduction i2  "integer(2)"
    fi
    print_reduction i4  "integer(4)"      
    print_reduction i8  "integer(8)"
    print_reduction r4  "real(4)"         
    print_reduction r8  "real(8)"         
    if test ${OP} == sum; then
        print_reduction z8  "complex(4)"      
        print_reduction z16 "complex(8)"      
    fi
done
echo '      end interface'
echo ''

done

exit
