/* 
 * $TSUKUBA_Release: Omni Compiler Version 0.9.0 $
 * $TSUKUBA_Copyright:
 *  Copyright (C) 2010-2014 University of Tsukuba, 
 *  	      2012-2014  University of Tsukuba and Riken AICS
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  * The specification of XcalableMP has been designed by the XcalableMP
 *    Specification Working Group (http://www.xcalablemp.org/).
 *  
 *  * The development of this software was partially supported by "Seamless and
 *    Highly-productive Parallel Programming Environment for
 *    High-performance computing" project funded by Ministry of Education,
 *    Culture, Sports, Science and Technology, Japan.
 *  $
 */
package exc.object;

import java.util.Vector;

/**
 * Super class of objects which has a property list. The property list is
 * implmented by a Vector.
 */
public class PropObject
{
    Vector<Object> props; // property list
    protected int id; // identifier

    public int Id()
    {
        return id;
    }

    public void setId(int id)
    {
        this.id = id;
    }

    public void setProp(Object key, Object value)
    {
        if(props == null)
            props = new Vector<Object>();
        int index = props.indexOf(key);
        if(index == -1) {
            props.addElement(key);
            props.addElement(value);
        } else {
            props.setElementAt(value, index + 1);
        }
    }

    public Object getProp(Object key)
    {
        if(props == null)
            return null;
        int index = props.indexOf(key);
        if(index == -1)
            return null;
        else
            return props.elementAt(index + 1);
    }

    public void remProp(Object key)
    {
        if(props == null)
            return;
        int index = props.indexOf(key);
        if(index == -1)
            return;
        else {
            props.removeElementAt(index);
            props.removeElementAt(index);
        }
    }

    public void remProperties()
    {
        props = null;
    }

    public Vector<Object> getProperties()
    {
        return props;
    }

    public void setProperties(Vector<Object> props)
    {
        this.props = props;
    }
}
