       module m
         interface operator(.myUnaryMathOp.)
            module procedure math_func
         end interface
         interface operator(.myUnaryLogOp.)
            module procedure logical_func
         end interface
       contains
         function math_func(in)
           integer, intent(in) :: in
           integer :: math_func
 
           math_func = in * 3 + 1
         end function math_func
         function logical_func(in)
           logical, intent(in) :: in
           logical :: logical_func
 
           logical_func = .not. in
         end function logical_func
       end module m
       module UnitTest
         integer :: test_case_number = 0
         integer :: current_test_case = 0
         integer :: test_case_failed_number = 0
       contains
         subroutine test_case(n)
           integer,optional :: n
           if (present(n) .and. n < 0) then
              WRITE (0,*) 'invalid test case number'
              STOP 1
           end if
           if (present(n)) then
              test_case_number = n
           else
              test_case_number = 0
           end if
           current_test_case = 0
           test_case_failed_number = 0
         end subroutine test_case
 
         subroutine assertEqualBoolean(a, b, message)
           Logical :: a, b
           Character(*), Optional :: message
 
           if (a .neqv. b) then
              if (PRESENT(message)) then
                 WRITE (0,*) 'Failed ', message
              else
                 WRITE (0,*) 'Failed test #', current_test_case
              end if
              WRITE (0,*) '  Expected     : ', a
              WRITE (0,*) '  Actually got : ', b
              test_case_failed_number = test_case_failed_number + 1
           end if
           current_test_case = current_test_case + 1
         end subroutine assertEqualBoolean
 
         subroutine assertEqualInteger(a, b, message)
           Integer :: a, b
           Character(*), Optional :: message
 
           if (a /= b) then
              if (PRESENT(message)) then
                 WRITE (0,*) 'Failed ', message
              else
                 WRITE (0,*) 'Failed test #', current_test_case
              end if
              WRITE (0,*) '  Expected     : ', a
              WRITE (0,*) '  Actually got : ', b
              test_case_failed_number = test_case_failed_number + 1
           end if
 
           current_test_case = current_test_case + 1
         end subroutine assertEqualInteger
 
         subroutine summary()
           if (test_case_failed_number > 0) then
              if (test_case_number > 0) then
                 WRITE (0,*) 'Failed ', test_case_failed_number, '/', test_case_number
              else
                 WRITE (0,*) 'Failed ', test_case_failed_number
              end if
              STOP 1
           else
              ! WRITE (*,*) 'All tests are passed'
           end if
         end subroutine summary
       end module UnitTest
       program main
         use m
         use UnitTest
         integer :: x, y, z
         logical :: u, v, t
         x =           4
         y =           2
         z =           1
         u = .true.
         v = .false.
         t = .true.
         call assertEqualInteger(           7 ,x + y + z,'x + y + z')
         call assertEqualInteger(           7 ,(x + y) + z, '(x + y) + z')
         call assertEqualInteger(           7 ,x + (y + z), 'x + (y + z)')
         call assertEqualInteger(           5 ,x + y - z,'x + y - z')
         call assertEqualInteger(           5 ,(x + y) - z, '(x + y) - z')
         call assertEqualInteger(           5 ,x + (y - z), 'x + (y - z)')
         call assertEqualInteger(           6 ,x + y * z,'x + y * z')
         call assertEqualInteger(           6 ,(x + y) * z, '(x + y) * z')
         call assertEqualInteger(           6 ,x + (y * z), 'x + (y * z)')
         call assertEqualInteger(           6 ,x + y / z,'x + y / z')
         call assertEqualInteger(           6 ,(x + y) / z, '(x + y) / z')
         call assertEqualInteger(           6 ,x + (y / z), 'x + (y / z)')
         call assertEqualInteger(           6 ,x + y ** z,'x + y ** z')
         call assertEqualInteger(           6 ,(x + y) ** z, '(x + y) ** z')
         call assertEqualInteger(           6 ,x + (y ** z), 'x + (y ** z)')
         call assertEqualInteger(           3 ,x - y + z,'x - y + z')
         call assertEqualInteger(           3 ,(x - y) + z, '(x - y) + z')
         call assertEqualInteger(           1 ,x - (y + z), 'x - (y + z)')
         call assertEqualInteger(           1 ,x - y - z,'x - y - z')
         call assertEqualInteger(           1 ,(x - y) - z, '(x - y) - z')
         call assertEqualInteger(           3 ,x - (y - z), 'x - (y - z)')
         call assertEqualInteger(           2 ,x - y * z,'x - y * z')
         call assertEqualInteger(           2 ,(x - y) * z, '(x - y) * z')
         call assertEqualInteger(           2 ,x - (y * z), 'x - (y * z)')
         call assertEqualInteger(           2 ,x - y / z,'x - y / z')
         call assertEqualInteger(           2 ,(x - y) / z, '(x - y) / z')
         call assertEqualInteger(           2 ,x - (y / z), 'x - (y / z)')
         call assertEqualInteger(           2 ,x - y ** z,'x - y ** z')
         call assertEqualInteger(           2 ,(x - y) ** z, '(x - y) ** z')
         call assertEqualInteger(           2 ,x - (y ** z), 'x - (y ** z)')
         call assertEqualInteger(           9 ,x * y + z,'x * y + z')
         call assertEqualInteger(           9 ,(x * y) + z, '(x * y) + z')
         call assertEqualInteger(          12 ,x * (y + z), 'x * (y + z)')
         call assertEqualInteger(           7 ,x * y - z,'x * y - z')
         call assertEqualInteger(           7 ,(x * y) - z, '(x * y) - z')
         call assertEqualInteger(           4 ,x * (y - z), 'x * (y - z)')
         call assertEqualInteger(           8 ,x * y * z,'x * y * z')
         call assertEqualInteger(           8 ,(x * y) * z, '(x * y) * z')
         call assertEqualInteger(           8 ,x * (y * z), 'x * (y * z)')
         call assertEqualInteger(           8 ,x * y / z,'x * y / z')
         call assertEqualInteger(           8 ,(x * y) / z, '(x * y) / z')
         call assertEqualInteger(           8 ,x * (y / z), 'x * (y / z)')
         call assertEqualInteger(           8 ,x * y ** z,'x * y ** z')
         call assertEqualInteger(           8 ,(x * y) ** z, '(x * y) ** z')
         call assertEqualInteger(           8 ,x * (y ** z), 'x * (y ** z)')
         call assertEqualInteger(           3 ,x / y + z,'x / y + z')
         call assertEqualInteger(           3 ,(x / y) + z, '(x / y) + z')
         call assertEqualInteger(           1 ,x / (y + z), 'x / (y + z)')
         call assertEqualInteger(           1 ,x / y - z,'x / y - z')
         call assertEqualInteger(           1 ,(x / y) - z, '(x / y) - z')
         call assertEqualInteger(           4 ,x / (y - z), 'x / (y - z)')
         call assertEqualInteger(           2 ,x / y * z,'x / y * z')
         call assertEqualInteger(           2 ,(x / y) * z, '(x / y) * z')
         call assertEqualInteger(           2 ,x / (y * z), 'x / (y * z)')
         call assertEqualInteger(           2 ,x / y / z,'x / y / z')
         call assertEqualInteger(           2 ,(x / y) / z, '(x / y) / z')
         call assertEqualInteger(           2 ,x / (y / z), 'x / (y / z)')
         call assertEqualInteger(           2 ,x / y ** z,'x / y ** z')
         call assertEqualInteger(           2 ,(x / y) ** z, '(x / y) ** z')
         call assertEqualInteger(           2 ,x / (y ** z), 'x / (y ** z)')
         call assertEqualInteger(          17 ,x ** y + z,'x ** y + z')
         call assertEqualInteger(          17 ,(x ** y) + z, '(x ** y) + z')
         call assertEqualInteger(          64 ,x ** (y + z), 'x ** (y + z)')
         call assertEqualInteger(          15 ,x ** y - z,'x ** y - z')
         call assertEqualInteger(          15 ,(x ** y) - z, '(x ** y) - z')
         call assertEqualInteger(           4 ,x ** (y - z), 'x ** (y - z)')
         call assertEqualInteger(          16 ,x ** y * z,'x ** y * z')
         call assertEqualInteger(          16 ,(x ** y) * z, '(x ** y) * z')
         call assertEqualInteger(          16 ,x ** (y * z), 'x ** (y * z)')
         call assertEqualInteger(          16 ,x ** y / z,'x ** y / z')
         call assertEqualInteger(          16 ,(x ** y) / z, '(x ** y) / z')
         call assertEqualInteger(          16 ,x ** (y / z), 'x ** (y / z)')
         call assertEqualInteger(          16 ,x ** y ** z,'x ** y ** z')
         call assertEqualInteger(          16 ,(x ** y) ** z, '(x ** y) ** z')
         call assertEqualInteger(          16 ,x ** (y ** z), 'x ** (y ** z)')
         call assertEqualInteger(          -1 ,- x + y + z, '- x + y + z')
         call assertEqualInteger(          -7 ,- (x + y + z), '- (x + y + z)')
         call assertEqualInteger(          -1 ,- x + (y + z), '- x + (y + z)')
         call assertEqualInteger(          -5 ,- (x + y) + z, '- (x + y) + z')
         call assertEqualInteger(          -3 ,- x + y - z, '- x + y - z')
         call assertEqualInteger(          -5 ,- (x + y - z), '- (x + y - z)')
         call assertEqualInteger(          -3 ,- x + (y - z), '- x + (y - z)')
         call assertEqualInteger(          -7 ,- (x + y) - z, '- (x + y) - z')
         call assertEqualInteger(          -2 ,- x + y * z, '- x + y * z')
         call assertEqualInteger(          -6 ,- (x + y * z), '- (x + y * z)')
         call assertEqualInteger(          -2 ,- x + (y * z), '- x + (y * z)')
         call assertEqualInteger(          -6 ,- (x + y) * z, '- (x + y) * z')
         call assertEqualInteger(          -2 ,- x + y / z, '- x + y / z')
         call assertEqualInteger(          -6 ,- (x + y / z), '- (x + y / z)')
         call assertEqualInteger(          -2 ,- x + (y / z), '- x + (y / z)')
         call assertEqualInteger(          -6 ,- (x + y) / z, '- (x + y) / z')
         call assertEqualInteger(          -2 ,- x + y ** z, '- x + y ** z')
         call assertEqualInteger(          -6 ,- (x + y ** z), '- (x + y ** z)')
         call assertEqualInteger(          -2 ,- x + (y ** z), '- x + (y ** z)')
         call assertEqualInteger(          -6 ,- (x + y) ** z, '- (x + y) ** z')
         call assertEqualInteger(          -5 ,- x - y + z, '- x - y + z')
         call assertEqualInteger(          -3 ,- (x - y + z), '- (x - y + z)')
         call assertEqualInteger(          -7 ,- x - (y + z), '- x - (y + z)')
         call assertEqualInteger(          -1 ,- (x - y) + z, '- (x - y) + z')
         call assertEqualInteger(          -7 ,- x - y - z, '- x - y - z')
         call assertEqualInteger(          -1 ,- (x - y - z), '- (x - y - z)')
         call assertEqualInteger(          -5 ,- x - (y - z), '- x - (y - z)')
         call assertEqualInteger(          -3 ,- (x - y) - z, '- (x - y) - z')
         call assertEqualInteger(          -6 ,- x - y * z, '- x - y * z')
         call assertEqualInteger(          -2 ,- (x - y * z), '- (x - y * z)')
         call assertEqualInteger(          -6 ,- x - (y * z), '- x - (y * z)')
         call assertEqualInteger(          -2 ,- (x - y) * z, '- (x - y) * z')
         call assertEqualInteger(          -6 ,- x - y / z, '- x - y / z')
         call assertEqualInteger(          -2 ,- (x - y / z), '- (x - y / z)')
         call assertEqualInteger(          -6 ,- x - (y / z), '- x - (y / z)')
         call assertEqualInteger(          -2 ,- (x - y) / z, '- (x - y) / z')
         call assertEqualInteger(          -6 ,- x - y ** z, '- x - y ** z')
         call assertEqualInteger(          -2 ,- (x - y ** z), '- (x - y ** z)')
         call assertEqualInteger(          -6 ,- x - (y ** z), '- x - (y ** z)')
         call assertEqualInteger(          -2 ,- (x - y) ** z, '- (x - y) ** z')
         call assertEqualInteger(          -7 ,- x * y + z, '- x * y + z')
         call assertEqualInteger(          -9 ,- (x * y + z), '- (x * y + z)')
         call assertEqualInteger(         -12 ,- x * (y + z), '- x * (y + z)')
         call assertEqualInteger(          -7 ,- (x * y) + z, '- (x * y) + z')
         call assertEqualInteger(          -9 ,- x * y - z, '- x * y - z')
         call assertEqualInteger(          -7 ,- (x * y - z), '- (x * y - z)')
         call assertEqualInteger(          -4 ,- x * (y - z), '- x * (y - z)')
         call assertEqualInteger(          -9 ,- (x * y) - z, '- (x * y) - z')
         call assertEqualInteger(          -8 ,- x * y * z, '- x * y * z')
         call assertEqualInteger(          -8 ,- (x * y * z), '- (x * y * z)')
         call assertEqualInteger(          -8 ,- x * (y * z), '- x * (y * z)')
         call assertEqualInteger(          -8 ,- (x * y) * z, '- (x * y) * z')
         call assertEqualInteger(          -8 ,- x * y / z, '- x * y / z')
         call assertEqualInteger(          -8 ,- (x * y / z), '- (x * y / z)')
         call assertEqualInteger(          -8 ,- x * (y / z), '- x * (y / z)')
         call assertEqualInteger(          -8 ,- (x * y) / z, '- (x * y) / z')
         call assertEqualInteger(          -8 ,- x * y ** z, '- x * y ** z')
         call assertEqualInteger(          -8 ,- (x * y ** z), '- (x * y ** z)')
         call assertEqualInteger(          -8 ,- x * (y ** z), '- x * (y ** z)')
         call assertEqualInteger(          -8 ,- (x * y) ** z, '- (x * y) ** z')
         call assertEqualInteger(          -1 ,- x / y + z, '- x / y + z')
         call assertEqualInteger(          -3 ,- (x / y + z), '- (x / y + z)')
         call assertEqualInteger(          -1 ,- x / (y + z), '- x / (y + z)')
         call assertEqualInteger(          -1 ,- (x / y) + z, '- (x / y) + z')
         call assertEqualInteger(          -3 ,- x / y - z, '- x / y - z')
         call assertEqualInteger(          -1 ,- (x / y - z), '- (x / y - z)')
         call assertEqualInteger(          -4 ,- x / (y - z), '- x / (y - z)')
         call assertEqualInteger(          -3 ,- (x / y) - z, '- (x / y) - z')
         call assertEqualInteger(          -2 ,- x / y * z, '- x / y * z')
         call assertEqualInteger(          -2 ,- (x / y * z), '- (x / y * z)')
         call assertEqualInteger(          -2 ,- x / (y * z), '- x / (y * z)')
         call assertEqualInteger(          -2 ,- (x / y) * z, '- (x / y) * z')
         call assertEqualInteger(          -2 ,- x / y / z, '- x / y / z')
         call assertEqualInteger(          -2 ,- (x / y / z), '- (x / y / z)')
         call assertEqualInteger(          -2 ,- x / (y / z), '- x / (y / z)')
         call assertEqualInteger(          -2 ,- (x / y) / z, '- (x / y) / z')
         call assertEqualInteger(          -2 ,- x / y ** z, '- x / y ** z')
         call assertEqualInteger(          -2 ,- (x / y ** z), '- (x / y ** z)')
         call assertEqualInteger(          -2 ,- x / (y ** z), '- x / (y ** z)')
         call assertEqualInteger(          -2 ,- (x / y) ** z, '- (x / y) ** z')
         call assertEqualInteger(         -15 ,- x ** y + z, '- x ** y + z')
         call assertEqualInteger(         -17 ,- (x ** y + z), '- (x ** y + z)')
         call assertEqualInteger(         -64 ,- x ** (y + z), '- x ** (y + z)')
         call assertEqualInteger(         -15 ,- (x ** y) + z, '- (x ** y) + z')
         call assertEqualInteger(         -17 ,- x ** y - z, '- x ** y - z')
         call assertEqualInteger(         -15 ,- (x ** y - z), '- (x ** y - z)')
         call assertEqualInteger(          -4 ,- x ** (y - z), '- x ** (y - z)')
         call assertEqualInteger(         -17 ,- (x ** y) - z, '- (x ** y) - z')
         call assertEqualInteger(         -16 ,- x ** y * z, '- x ** y * z')
         call assertEqualInteger(         -16 ,- (x ** y * z), '- (x ** y * z)')
         call assertEqualInteger(         -16 ,- x ** (y * z), '- x ** (y * z)')
         call assertEqualInteger(         -16 ,- (x ** y) * z, '- (x ** y) * z')
         call assertEqualInteger(         -16 ,- x ** y / z, '- x ** y / z')
         call assertEqualInteger(         -16 ,- (x ** y / z), '- (x ** y / z)')
         call assertEqualInteger(         -16 ,- x ** (y / z), '- x ** (y / z)')
         call assertEqualInteger(         -16 ,- (x ** y) / z, '- (x ** y) / z')
         call assertEqualInteger(         -16 ,- x ** y ** z, '- x ** y ** z')
         call assertEqualInteger(         -16 ,- (x ** y ** z), '- (x ** y ** z)')
         call assertEqualInteger(         -16 ,- x ** (y ** z), '- x ** (y ** z)')
         call assertEqualInteger(         -16 ,- (x ** y) ** z, '- (x ** y) ** z')
         ! call assertEqualInteger(          16 ,.myUnaryMathOp. x + y + z, '.myUnaryMathOp. x + y + z')
         ! call assertEqualInteger(          22 ,.myUnaryMathOp. (x + y + z), '.myUnaryMathOp. (x + y + z)')
         ! call assertEqualInteger(          16 ,.myUnaryMathOp. x + (y + z), '.myUnaryMathOp. x + (y + z)')
         ! call assertEqualInteger(          20 ,.myUnaryMathOp. (x + y) + z, '.myUnaryMathOp. (x + y) + z')
         ! call assertEqualInteger(          14 ,.myUnaryMathOp. x + y - z, '.myUnaryMathOp. x + y - z')
         ! call assertEqualInteger(          16 ,.myUnaryMathOp. (x + y - z), '.myUnaryMathOp. (x + y - z)')
         ! call assertEqualInteger(          14 ,.myUnaryMathOp. x + (y - z), '.myUnaryMathOp. x + (y - z)')
         ! call assertEqualInteger(          18 ,.myUnaryMathOp. (x + y) - z, '.myUnaryMathOp. (x + y) - z')
         ! call assertEqualInteger(          15 ,.myUnaryMathOp. x + y * z, '.myUnaryMathOp. x + y * z')
         ! call assertEqualInteger(          19 ,.myUnaryMathOp. (x + y * z), '.myUnaryMathOp. (x + y * z)')
         ! call assertEqualInteger(          15 ,.myUnaryMathOp. x + (y * z), '.myUnaryMathOp. x + (y * z)')
         ! call assertEqualInteger(          19 ,.myUnaryMathOp. (x + y) * z, '.myUnaryMathOp. (x + y) * z')
         ! call assertEqualInteger(          15 ,.myUnaryMathOp. x + y / z, '.myUnaryMathOp. x + y / z')
         ! call assertEqualInteger(          19 ,.myUnaryMathOp. (x + y / z), '.myUnaryMathOp. (x + y / z)')
         ! call assertEqualInteger(          15 ,.myUnaryMathOp. x + (y / z), '.myUnaryMathOp. x + (y / z)')
         ! call assertEqualInteger(          19 ,.myUnaryMathOp. (x + y) / z, '.myUnaryMathOp. (x + y) / z')
         ! call assertEqualInteger(          15 ,.myUnaryMathOp. x + y ** z, '.myUnaryMathOp. x + y ** z')
         ! call assertEqualInteger(          19 ,.myUnaryMathOp. (x + y ** z), '.myUnaryMathOp. (x + y ** z)')
         ! call assertEqualInteger(          15 ,.myUnaryMathOp. x + (y ** z), '.myUnaryMathOp. x + (y ** z)')
         ! call assertEqualInteger(          19 ,.myUnaryMathOp. (x + y) ** z, '.myUnaryMathOp. (x + y) ** z')
         ! call assertEqualInteger(          12 ,.myUnaryMathOp. x - y + z, '.myUnaryMathOp. x - y + z')
         ! call assertEqualInteger(          10 ,.myUnaryMathOp. (x - y + z), '.myUnaryMathOp. (x - y + z)')
         ! call assertEqualInteger(          10 ,.myUnaryMathOp. x - (y + z), '.myUnaryMathOp. x - (y + z)')
         ! call assertEqualInteger(           8 ,.myUnaryMathOp. (x - y) + z, '.myUnaryMathOp. (x - y) + z')
         ! call assertEqualInteger(          10 ,.myUnaryMathOp. x - y - z, '.myUnaryMathOp. x - y - z')
         ! call assertEqualInteger(           4 ,.myUnaryMathOp. (x - y - z), '.myUnaryMathOp. (x - y - z)')
         ! call assertEqualInteger(          12 ,.myUnaryMathOp. x - (y - z), '.myUnaryMathOp. x - (y - z)')
         ! call assertEqualInteger(           6 ,.myUnaryMathOp. (x - y) - z, '.myUnaryMathOp. (x - y) - z')
         ! call assertEqualInteger(          11 ,.myUnaryMathOp. x - y * z, '.myUnaryMathOp. x - y * z')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. (x - y * z), '.myUnaryMathOp. (x - y * z)')
         ! call assertEqualInteger(          11 ,.myUnaryMathOp. x - (y * z), '.myUnaryMathOp. x - (y * z)')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. (x - y) * z, '.myUnaryMathOp. (x - y) * z')
         ! call assertEqualInteger(          11 ,.myUnaryMathOp. x - y / z, '.myUnaryMathOp. x - y / z')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. (x - y / z), '.myUnaryMathOp. (x - y / z)')
         ! call assertEqualInteger(          11 ,.myUnaryMathOp. x - (y / z), '.myUnaryMathOp. x - (y / z)')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. (x - y) / z, '.myUnaryMathOp. (x - y) / z')
         ! call assertEqualInteger(          11 ,.myUnaryMathOp. x - y ** z, '.myUnaryMathOp. x - y ** z')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. (x - y ** z), '.myUnaryMathOp. (x - y ** z)')
         ! call assertEqualInteger(          11 ,.myUnaryMathOp. x - (y ** z), '.myUnaryMathOp. x - (y ** z)')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. (x - y) ** z, '.myUnaryMathOp. (x - y) ** z')
         ! call assertEqualInteger(          27 ,.myUnaryMathOp. x * y + z, '.myUnaryMathOp. x * y + z')
         ! call assertEqualInteger(          28 ,.myUnaryMathOp. (x * y + z), '.myUnaryMathOp. (x * y + z)')
         ! call assertEqualInteger(          39 ,.myUnaryMathOp. x * (y + z), '.myUnaryMathOp. x * (y + z)')
         ! call assertEqualInteger(          26 ,.myUnaryMathOp. (x * y) + z, '.myUnaryMathOp. (x * y) + z')
         ! call assertEqualInteger(          25 ,.myUnaryMathOp. x * y - z, '.myUnaryMathOp. x * y - z')
         ! call assertEqualInteger(          22 ,.myUnaryMathOp. (x * y - z), '.myUnaryMathOp. (x * y - z)')
         ! call assertEqualInteger(          13 ,.myUnaryMathOp. x * (y - z), '.myUnaryMathOp. x * (y - z)')
         ! call assertEqualInteger(          24 ,.myUnaryMathOp. (x * y) - z, '.myUnaryMathOp. (x * y) - z')
         ! call assertEqualInteger(          26 ,.myUnaryMathOp. x * y * z, '.myUnaryMathOp. x * y * z')
         ! call assertEqualInteger(          25 ,.myUnaryMathOp. (x * y * z), '.myUnaryMathOp. (x * y * z)')
         ! call assertEqualInteger(          26 ,.myUnaryMathOp. x * (y * z), '.myUnaryMathOp. x * (y * z)')
         ! call assertEqualInteger(          25 ,.myUnaryMathOp. (x * y) * z, '.myUnaryMathOp. (x * y) * z')
         ! call assertEqualInteger(          26 ,.myUnaryMathOp. x * y / z, '.myUnaryMathOp. x * y / z')
         ! call assertEqualInteger(          25 ,.myUnaryMathOp. (x * y / z), '.myUnaryMathOp. (x * y / z)')
         ! call assertEqualInteger(          26 ,.myUnaryMathOp. x * (y / z), '.myUnaryMathOp. x * (y / z)')
         ! call assertEqualInteger(          25 ,.myUnaryMathOp. (x * y) / z, '.myUnaryMathOp. (x * y) / z')
         ! call assertEqualInteger(          26 ,.myUnaryMathOp. x * y ** z, '.myUnaryMathOp. x * y ** z')
         ! call assertEqualInteger(          25 ,.myUnaryMathOp. (x * y ** z), '.myUnaryMathOp. (x * y ** z)')
         ! call assertEqualInteger(          26 ,.myUnaryMathOp. x * (y ** z), '.myUnaryMathOp. x * (y ** z)')
         ! call assertEqualInteger(          25 ,.myUnaryMathOp. (x * y) ** z, '.myUnaryMathOp. (x * y) ** z')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. x / y + z, '.myUnaryMathOp. x / y + z')
         ! call assertEqualInteger(          10 ,.myUnaryMathOp. (x / y + z), '.myUnaryMathOp. (x / y + z)')
         ! call assertEqualInteger(           4 ,.myUnaryMathOp. x / (y + z), '.myUnaryMathOp. x / (y + z)')
         ! call assertEqualInteger(           8 ,.myUnaryMathOp. (x / y) + z, '.myUnaryMathOp. (x / y) + z')
         ! call assertEqualInteger(           5 ,.myUnaryMathOp. x / y - z, '.myUnaryMathOp. x / y - z')
         ! call assertEqualInteger(           4 ,.myUnaryMathOp. (x / y - z), '.myUnaryMathOp. (x / y - z)')
         ! call assertEqualInteger(          13 ,.myUnaryMathOp. x / (y - z), '.myUnaryMathOp. x / (y - z)')
         ! call assertEqualInteger(           6 ,.myUnaryMathOp. (x / y) - z, '.myUnaryMathOp. (x / y) - z')
         ! call assertEqualInteger(           6 ,.myUnaryMathOp. x / y * z, '.myUnaryMathOp. x / y * z')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. (x / y * z), '.myUnaryMathOp. (x / y * z)')
         ! call assertEqualInteger(           6 ,.myUnaryMathOp. x / (y * z), '.myUnaryMathOp. x / (y * z)')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. (x / y) * z, '.myUnaryMathOp. (x / y) * z')
         ! call assertEqualInteger(           6 ,.myUnaryMathOp. x / y / z, '.myUnaryMathOp. x / y / z')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. (x / y / z), '.myUnaryMathOp. (x / y / z)')
         ! call assertEqualInteger(           6 ,.myUnaryMathOp. x / (y / z), '.myUnaryMathOp. x / (y / z)')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. (x / y) / z, '.myUnaryMathOp. (x / y) / z')
         ! call assertEqualInteger(           6 ,.myUnaryMathOp. x / y ** z, '.myUnaryMathOp. x / y ** z')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. (x / y ** z), '.myUnaryMathOp. (x / y ** z)')
         ! call assertEqualInteger(           6 ,.myUnaryMathOp. x / (y ** z), '.myUnaryMathOp. x / (y ** z)')
         ! call assertEqualInteger(           7 ,.myUnaryMathOp. (x / y) ** z, '.myUnaryMathOp. (x / y) ** z')
         ! call assertEqualInteger(         170 ,.myUnaryMathOp. x ** y + z, '.myUnaryMathOp. x ** y + z')
         ! call assertEqualInteger(          52 ,.myUnaryMathOp. (x ** y + z), '.myUnaryMathOp. (x ** y + z)')
         ! call assertEqualInteger(        2197 ,.myUnaryMathOp. x ** (y + z), '.myUnaryMathOp. x ** (y + z)')
         ! call assertEqualInteger(          50 ,.myUnaryMathOp. (x ** y) + z, '.myUnaryMathOp. (x ** y) + z')
         ! call assertEqualInteger(         168 ,.myUnaryMathOp. x ** y - z, '.myUnaryMathOp. x ** y - z')
         ! call assertEqualInteger(          46 ,.myUnaryMathOp. (x ** y - z), '.myUnaryMathOp. (x ** y - z)')
         ! call assertEqualInteger(          13 ,.myUnaryMathOp. x ** (y - z), '.myUnaryMathOp. x ** (y - z)')
         ! call assertEqualInteger(          48 ,.myUnaryMathOp. (x ** y) - z, '.myUnaryMathOp. (x ** y) - z')
         ! call assertEqualInteger(         169 ,.myUnaryMathOp. x ** y * z, '.myUnaryMathOp. x ** y * z')
         ! call assertEqualInteger(          49 ,.myUnaryMathOp. (x ** y * z), '.myUnaryMathOp. (x ** y * z)')
         ! call assertEqualInteger(         169 ,.myUnaryMathOp. x ** (y * z), '.myUnaryMathOp. x ** (y * z)')
         ! call assertEqualInteger(          49 ,.myUnaryMathOp. (x ** y) * z, '.myUnaryMathOp. (x ** y) * z')
         ! call assertEqualInteger(         169 ,.myUnaryMathOp. x ** y / z, '.myUnaryMathOp. x ** y / z')
         ! call assertEqualInteger(          49 ,.myUnaryMathOp. (x ** y / z), '.myUnaryMathOp. (x ** y / z)')
         ! call assertEqualInteger(         169 ,.myUnaryMathOp. x ** (y / z), '.myUnaryMathOp. x ** (y / z)')
         ! call assertEqualInteger(          49 ,.myUnaryMathOp. (x ** y) / z, '.myUnaryMathOp. (x ** y) / z')
         ! call assertEqualInteger(         169 ,.myUnaryMathOp. x ** y ** z, '.myUnaryMathOp. x ** y ** z')
         ! call assertEqualInteger(          49 ,.myUnaryMathOp. (x ** y ** z), '.myUnaryMathOp. (x ** y ** z)')
         ! call assertEqualInteger(         169 ,.myUnaryMathOp. x ** (y ** z), '.myUnaryMathOp. x ** (y ** z)')
         ! call assertEqualInteger(          49 ,.myUnaryMathOp. (x ** y) ** z, '.myUnaryMathOp. (x ** y) ** z')
         call assertEqualBoolean(.false.,u .and. v .and. t,'u .and. v .and. t')
         call assertEqualBoolean(.false.,(u .and. v) .and. t, '(u .and. v) .and. t')
         call assertEqualBoolean(.false.,u .and. (v .and. t), 'u .and. (v .and. t)')
         call assertEqualBoolean(.true. ,u .and. v .or. t,'u .and. v .or. t')
         call assertEqualBoolean(.true. ,(u .and. v) .or. t, '(u .and. v) .or. t')
         call assertEqualBoolean(.true. ,u .and. (v .or. t), 'u .and. (v .or. t)')
         call assertEqualBoolean(.false.,u .and. v .eqv. t,'u .and. v .eqv. t')
         call assertEqualBoolean(.false.,(u .and. v) .eqv. t, '(u .and. v) .eqv. t')
         call assertEqualBoolean(.false.,u .and. (v .eqv. t), 'u .and. (v .eqv. t)')
         call assertEqualBoolean(.true. ,u .and. v .neqv. t,'u .and. v .neqv. t')
         call assertEqualBoolean(.true. ,(u .and. v) .neqv. t, '(u .and. v) .neqv. t')
         call assertEqualBoolean(.true. ,u .and. (v .neqv. t), 'u .and. (v .neqv. t)')
         call assertEqualBoolean(.true. ,u .or. v .and. t,'u .or. v .and. t')
         call assertEqualBoolean(.true. ,(u .or. v) .and. t, '(u .or. v) .and. t')
         call assertEqualBoolean(.true. ,u .or. (v .and. t), 'u .or. (v .and. t)')
         call assertEqualBoolean(.true. ,u .or. v .or. t,'u .or. v .or. t')
         call assertEqualBoolean(.true. ,(u .or. v) .or. t, '(u .or. v) .or. t')
         call assertEqualBoolean(.true. ,u .or. (v .or. t), 'u .or. (v .or. t)')
         call assertEqualBoolean(.true. ,u .or. v .eqv. t,'u .or. v .eqv. t')
         call assertEqualBoolean(.true. ,(u .or. v) .eqv. t, '(u .or. v) .eqv. t')
         call assertEqualBoolean(.true. ,u .or. (v .eqv. t), 'u .or. (v .eqv. t)')
         call assertEqualBoolean(.false.,u .or. v .neqv. t,'u .or. v .neqv. t')
         call assertEqualBoolean(.false.,(u .or. v) .neqv. t, '(u .or. v) .neqv. t')
         call assertEqualBoolean(.true. ,u .or. (v .neqv. t), 'u .or. (v .neqv. t)')
         call assertEqualBoolean(.false.,u .eqv. v .and. t,'u .eqv. v .and. t')
         call assertEqualBoolean(.false.,(u .eqv. v) .and. t, '(u .eqv. v) .and. t')
         call assertEqualBoolean(.false.,u .eqv. (v .and. t), 'u .eqv. (v .and. t)')
         call assertEqualBoolean(.true. ,u .eqv. v .or. t,'u .eqv. v .or. t')
         call assertEqualBoolean(.true. ,(u .eqv. v) .or. t, '(u .eqv. v) .or. t')
         call assertEqualBoolean(.true. ,u .eqv. (v .or. t), 'u .eqv. (v .or. t)')
         call assertEqualBoolean(.false.,u .eqv. v .eqv. t,'u .eqv. v .eqv. t')
         call assertEqualBoolean(.false.,(u .eqv. v) .eqv. t, '(u .eqv. v) .eqv. t')
         call assertEqualBoolean(.false.,u .eqv. (v .eqv. t), 'u .eqv. (v .eqv. t)')
         call assertEqualBoolean(.true. ,u .eqv. v .neqv. t,'u .eqv. v .neqv. t')
         call assertEqualBoolean(.true. ,(u .eqv. v) .neqv. t, '(u .eqv. v) .neqv. t')
         call assertEqualBoolean(.true. ,u .eqv. (v .neqv. t), 'u .eqv. (v .neqv. t)')
         call assertEqualBoolean(.true. ,u .neqv. v .and. t,'u .neqv. v .and. t')
         call assertEqualBoolean(.true. ,(u .neqv. v) .and. t, '(u .neqv. v) .and. t')
         call assertEqualBoolean(.true. ,u .neqv. (v .and. t), 'u .neqv. (v .and. t)')
         call assertEqualBoolean(.false.,u .neqv. v .or. t,'u .neqv. v .or. t')
         call assertEqualBoolean(.true. ,(u .neqv. v) .or. t, '(u .neqv. v) .or. t')
         call assertEqualBoolean(.false.,u .neqv. (v .or. t), 'u .neqv. (v .or. t)')
         call assertEqualBoolean(.true. ,u .neqv. v .eqv. t,'u .neqv. v .eqv. t')
         call assertEqualBoolean(.true. ,(u .neqv. v) .eqv. t, '(u .neqv. v) .eqv. t')
         call assertEqualBoolean(.true. ,u .neqv. (v .eqv. t), 'u .neqv. (v .eqv. t)')
         call assertEqualBoolean(.false.,u .neqv. v .neqv. t,'u .neqv. v .neqv. t')
         call assertEqualBoolean(.false.,(u .neqv. v) .neqv. t, '(u .neqv. v) .neqv. t')
         call assertEqualBoolean(.false.,u .neqv. (v .neqv. t), 'u .neqv. (v .neqv. t)')
         call assertEqualBoolean(.false.,.not. u .and. v .and. t, '.not. u .and. v .and. t')
         call assertEqualBoolean(.true. ,.not. (u .and. v .and. t), '.not. (u .and. v .and. t)')
         call assertEqualBoolean(.false.,.not. u .and. (v .and. t), '.not. u .and. (v .and. t)')
         call assertEqualBoolean(.true. ,.not. (u .and. v) .and. t, '.not. (u .and. v) .and. t')
         call assertEqualBoolean(.true. ,.not. u .and. v .or. t, '.not. u .and. v .or. t')
         call assertEqualBoolean(.false.,.not. (u .and. v .or. t), '.not. (u .and. v .or. t)')
         call assertEqualBoolean(.false.,.not. u .and. (v .or. t), '.not. u .and. (v .or. t)')
         call assertEqualBoolean(.true. ,.not. (u .and. v) .or. t, '.not. (u .and. v) .or. t')
         call assertEqualBoolean(.false.,.not. u .and. v .eqv. t, '.not. u .and. v .eqv. t')
         call assertEqualBoolean(.true. ,.not. (u .and. v .eqv. t), '.not. (u .and. v .eqv. t)')
         call assertEqualBoolean(.false.,.not. u .and. (v .eqv. t), '.not. u .and. (v .eqv. t)')
         call assertEqualBoolean(.true. ,.not. (u .and. v) .eqv. t, '.not. (u .and. v) .eqv. t')
         call assertEqualBoolean(.true. ,.not. u .and. v .neqv. t, '.not. u .and. v .neqv. t')
         call assertEqualBoolean(.false.,.not. (u .and. v .neqv. t), '.not. (u .and. v .neqv. t)')
         call assertEqualBoolean(.false.,.not. u .and. (v .neqv. t), '.not. u .and. (v .neqv. t)')
         call assertEqualBoolean(.false.,.not. (u .and. v) .neqv. t, '.not. (u .and. v) .neqv. t')
         call assertEqualBoolean(.false.,.not. u .or. v .and. t, '.not. u .or. v .and. t')
         call assertEqualBoolean(.false.,.not. (u .or. v .and. t), '.not. (u .or. v .and. t)')
         call assertEqualBoolean(.false.,.not. u .or. (v .and. t), '.not. u .or. (v .and. t)')
         call assertEqualBoolean(.false.,.not. (u .or. v) .and. t, '.not. (u .or. v) .and. t')
         call assertEqualBoolean(.true. ,.not. u .or. v .or. t, '.not. u .or. v .or. t')
         call assertEqualBoolean(.false.,.not. (u .or. v .or. t), '.not. (u .or. v .or. t)')
         call assertEqualBoolean(.true. ,.not. u .or. (v .or. t), '.not. u .or. (v .or. t)')
         call assertEqualBoolean(.true. ,.not. (u .or. v) .or. t, '.not. (u .or. v) .or. t')
         call assertEqualBoolean(.false.,.not. u .or. v .eqv. t, '.not. u .or. v .eqv. t')
         call assertEqualBoolean(.false.,.not. (u .or. v .eqv. t), '.not. (u .or. v .eqv. t)')
         call assertEqualBoolean(.false.,.not. u .or. (v .eqv. t), '.not. u .or. (v .eqv. t)')
         call assertEqualBoolean(.false.,.not. (u .or. v) .eqv. t, '.not. (u .or. v) .eqv. t')
         call assertEqualBoolean(.true. ,.not. u .or. v .neqv. t, '.not. u .or. v .neqv. t')
         call assertEqualBoolean(.true. ,.not. (u .or. v .neqv. t), '.not. (u .or. v .neqv. t)')
         call assertEqualBoolean(.true. ,.not. u .or. (v .neqv. t), '.not. u .or. (v .neqv. t)')
         call assertEqualBoolean(.true. ,.not. (u .or. v) .neqv. t, '.not. (u .or. v) .neqv. t')
         call assertEqualBoolean(.true. ,.not. u .eqv. v .and. t, '.not. u .eqv. v .and. t')
         call assertEqualBoolean(.true. ,.not. (u .eqv. v .and. t), '.not. (u .eqv. v .and. t)')
         call assertEqualBoolean(.true. ,.not. u .eqv. (v .and. t), '.not. u .eqv. (v .and. t)')
         call assertEqualBoolean(.true. ,.not. (u .eqv. v) .and. t, '.not. (u .eqv. v) .and. t')
         call assertEqualBoolean(.false.,.not. u .eqv. v .or. t, '.not. u .eqv. v .or. t')
         call assertEqualBoolean(.false.,.not. (u .eqv. v .or. t), '.not. (u .eqv. v .or. t)')
         call assertEqualBoolean(.false.,.not. u .eqv. (v .or. t), '.not. u .eqv. (v .or. t)')
         call assertEqualBoolean(.true. ,.not. (u .eqv. v) .or. t, '.not. (u .eqv. v) .or. t')
         call assertEqualBoolean(.true. ,.not. u .eqv. v .eqv. t, '.not. u .eqv. v .eqv. t')
         call assertEqualBoolean(.true. ,.not. (u .eqv. v .eqv. t), '.not. (u .eqv. v .eqv. t)')
         call assertEqualBoolean(.true. ,.not. u .eqv. (v .eqv. t), '.not. u .eqv. (v .eqv. t)')
         call assertEqualBoolean(.true. ,.not. (u .eqv. v) .eqv. t, '.not. (u .eqv. v) .eqv. t')
         call assertEqualBoolean(.false.,.not. u .eqv. v .neqv. t, '.not. u .eqv. v .neqv. t')
         call assertEqualBoolean(.false.,.not. (u .eqv. v .neqv. t), '.not. (u .eqv. v .neqv. t)')
         call assertEqualBoolean(.false.,.not. u .eqv. (v .neqv. t), '.not. u .eqv. (v .neqv. t)')
         call assertEqualBoolean(.false.,.not. (u .eqv. v) .neqv. t, '.not. (u .eqv. v) .neqv. t')
         call assertEqualBoolean(.false.,.not. u .neqv. v .and. t, '.not. u .neqv. v .and. t')
         call assertEqualBoolean(.false.,.not. (u .neqv. v .and. t), '.not. (u .neqv. v .and. t)')
         call assertEqualBoolean(.false.,.not. u .neqv. (v .and. t), '.not. u .neqv. (v .and. t)')
         call assertEqualBoolean(.false.,.not. (u .neqv. v) .and. t, '.not. (u .neqv. v) .and. t')
         call assertEqualBoolean(.true. ,.not. u .neqv. v .or. t, '.not. u .neqv. v .or. t')
         call assertEqualBoolean(.true. ,.not. (u .neqv. v .or. t), '.not. (u .neqv. v .or. t)')
         call assertEqualBoolean(.true. ,.not. u .neqv. (v .or. t), '.not. u .neqv. (v .or. t)')
         call assertEqualBoolean(.true. ,.not. (u .neqv. v) .or. t, '.not. (u .neqv. v) .or. t')
         call assertEqualBoolean(.false.,.not. u .neqv. v .eqv. t, '.not. u .neqv. v .eqv. t')
         call assertEqualBoolean(.false.,.not. (u .neqv. v .eqv. t), '.not. (u .neqv. v .eqv. t)')
         call assertEqualBoolean(.false.,.not. u .neqv. (v .eqv. t), '.not. u .neqv. (v .eqv. t)')
         call assertEqualBoolean(.false.,.not. (u .neqv. v) .eqv. t, '.not. (u .neqv. v) .eqv. t')
         call assertEqualBoolean(.true. ,.not. u .neqv. v .neqv. t, '.not. u .neqv. v .neqv. t')
         call assertEqualBoolean(.true. ,.not. (u .neqv. v .neqv. t), '.not. (u .neqv. v .neqv. t)')
         call assertEqualBoolean(.true. ,.not. u .neqv. (v .neqv. t), '.not. u .neqv. (v .neqv. t)')
         call assertEqualBoolean(.true. ,.not. (u .neqv. v) .neqv. t, '.not. (u .neqv. v) .neqv. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .and. v .and. t, '.myUnaryLogOp. u .and. v .and. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .and. v .and. t), '.myUnaryLogOp. (u .and. v .and. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .and. (v .and. t), '.myUnaryLogOp. u .and. (v .and. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .and. v) .and. t, '.myUnaryLogOp. (u .and. v) .and. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .and. v .or. t, '.myUnaryLogOp. u .and. v .or. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .and. v .or. t), '.myUnaryLogOp. (u .and. v .or. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .and. (v .or. t), '.myUnaryLogOp. u .and. (v .or. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .and. v) .or. t, '.myUnaryLogOp. (u .and. v) .or. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .and. v .eqv. t, '.myUnaryLogOp. u .and. v .eqv. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .and. v .eqv. t), '.myUnaryLogOp. (u .and. v .eqv. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .and. (v .eqv. t), '.myUnaryLogOp. u .and. (v .eqv. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .and. v) .eqv. t, '.myUnaryLogOp. (u .and. v) .eqv. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .and. v .neqv. t, '.myUnaryLogOp. u .and. v .neqv. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .and. v .neqv. t), '.myUnaryLogOp. (u .and. v .neqv. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .and. (v .neqv. t), '.myUnaryLogOp. u .and. (v .neqv. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .and. v) .neqv. t, '.myUnaryLogOp. (u .and. v) .neqv. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .or. v .and. t, '.myUnaryLogOp. u .or. v .and. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .or. v .and. t), '.myUnaryLogOp. (u .or. v .and. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .or. (v .and. t), '.myUnaryLogOp. u .or. (v .and. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .or. v) .and. t, '.myUnaryLogOp. (u .or. v) .and. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .or. v .or. t, '.myUnaryLogOp. u .or. v .or. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .or. v .or. t), '.myUnaryLogOp. (u .or. v .or. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .or. (v .or. t), '.myUnaryLogOp. u .or. (v .or. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .or. v) .or. t, '.myUnaryLogOp. (u .or. v) .or. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .or. v .eqv. t, '.myUnaryLogOp. u .or. v .eqv. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .or. v .eqv. t), '.myUnaryLogOp. (u .or. v .eqv. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .or. (v .eqv. t), '.myUnaryLogOp. u .or. (v .eqv. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .or. v) .eqv. t, '.myUnaryLogOp. (u .or. v) .eqv. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .or. v .neqv. t, '.myUnaryLogOp. u .or. v .neqv. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .or. v .neqv. t), '.myUnaryLogOp. (u .or. v .neqv. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .or. (v .neqv. t), '.myUnaryLogOp. u .or. (v .neqv. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .or. v) .neqv. t, '.myUnaryLogOp. (u .or. v) .neqv. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .eqv. v .and. t, '.myUnaryLogOp. u .eqv. v .and. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .eqv. v .and. t), '.myUnaryLogOp. (u .eqv. v .and. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .eqv. (v .and. t), '.myUnaryLogOp. u .eqv. (v .and. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .eqv. v) .and. t, '.myUnaryLogOp. (u .eqv. v) .and. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .eqv. v .or. t, '.myUnaryLogOp. u .eqv. v .or. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .eqv. v .or. t), '.myUnaryLogOp. (u .eqv. v .or. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .eqv. (v .or. t), '.myUnaryLogOp. u .eqv. (v .or. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .eqv. v) .or. t, '.myUnaryLogOp. (u .eqv. v) .or. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .eqv. v .eqv. t, '.myUnaryLogOp. u .eqv. v .eqv. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .eqv. v .eqv. t), '.myUnaryLogOp. (u .eqv. v .eqv. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .eqv. (v .eqv. t), '.myUnaryLogOp. u .eqv. (v .eqv. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .eqv. v) .eqv. t, '.myUnaryLogOp. (u .eqv. v) .eqv. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .eqv. v .neqv. t, '.myUnaryLogOp. u .eqv. v .neqv. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .eqv. v .neqv. t), '.myUnaryLogOp. (u .eqv. v .neqv. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .eqv. (v .neqv. t), '.myUnaryLogOp. u .eqv. (v .neqv. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .eqv. v) .neqv. t, '.myUnaryLogOp. (u .eqv. v) .neqv. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .neqv. v .and. t, '.myUnaryLogOp. u .neqv. v .and. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .neqv. v .and. t), '.myUnaryLogOp. (u .neqv. v .and. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .neqv. (v .and. t), '.myUnaryLogOp. u .neqv. (v .and. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .neqv. v) .and. t, '.myUnaryLogOp. (u .neqv. v) .and. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .neqv. v .or. t, '.myUnaryLogOp. u .neqv. v .or. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .neqv. v .or. t), '.myUnaryLogOp. (u .neqv. v .or. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .neqv. (v .or. t), '.myUnaryLogOp. u .neqv. (v .or. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .neqv. v) .or. t, '.myUnaryLogOp. (u .neqv. v) .or. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .neqv. v .eqv. t, '.myUnaryLogOp. u .neqv. v .eqv. t')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .neqv. v .eqv. t), '.myUnaryLogOp. (u .neqv. v .eqv. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. u .neqv. (v .eqv. t), '.myUnaryLogOp. u .neqv. (v .eqv. t)')
         ! call assertEqualBoolean(.false.,.myUnaryLogOp. (u .neqv. v) .eqv. t, '.myUnaryLogOp. (u .neqv. v) .eqv. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .neqv. v .neqv. t, '.myUnaryLogOp. u .neqv. v .neqv. t')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .neqv. v .neqv. t), '.myUnaryLogOp. (u .neqv. v .neqv. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. u .neqv. (v .neqv. t), '.myUnaryLogOp. u .neqv. (v .neqv. t)')
         ! call assertEqualBoolean(.true. ,.myUnaryLogOp. (u .neqv. v) .neqv. t, '.myUnaryLogOp. (u .neqv. v) .neqv. t')
       end program main
