/*
 * The Relaxer artifact
 * Copyright (c) 2000-2003, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package xcodeml.f.binding.gen;

import xcodeml.binding.*;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * IXcodeML_FFactory is generated by Relaxer based on XcodeML_F.rng.
 *
 * @version XcodeML_F.rng 1.0 (Mon Jan 23 20:53:33 JST 2012)
 * @author  Relaxer 1.0 (http://www.relaxer.org)
 */
public interface IXcodeML_FFactory {
    /**
     * Sets a <b>errorHandler</b>.
     *
     * @param errorHandler
     */
    void setErrorHandler(org.xml.sax.ErrorHandler errorHandler);

    /**
     * Gets a <b>errorHandler</b>.
     *
     * @return org.xml.sax.ErrorHandler
     */
    org.xml.sax.ErrorHandler getErrorHandler();

    /**
     * Sets a <b>entityResolver</b>.
     *
     * @param entityResolver
     */
    void setEntityResolver(org.xml.sax.EntityResolver entityResolver);

    /**
     * Gets a <b>entityResolver</b>.
     *
     * @return org.xml.sax.EntityResolver
     */
    org.xml.sax.EntityResolver getEntityResolver();

    /**
     * Sets a <b>baseUri</b>.
     *
     * @param baseUri
     */
    void setBaseUri(String baseUri);

    /**
     * Gets a <b>baseUri</b>.
     *
     * @return String
     */
    String getBaseUri();

    /**
     * Creates a <code>Object</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the Object <code>source</code>.
     *
     * @param source
     * @return Object
     */
    Object create(Object source);

    /**
     * Creates a <code>Object</code> by the Document <code>dom</code>.
     *
     * @param doc
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(Document doc) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the Element <code>element</code>.
     *
     * @param element
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(Element element) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfXcodeProgram</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfXcodeProgram
     */
    XbfXcodeProgram createXbfXcodeProgram(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfTypeTable</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfTypeTable
     */
    XbfTypeTable createXbfTypeTable(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionType</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionType
     */
    XbfFfunctionType createXbfFfunctionType(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfParams</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfParams
     */
    XbfParams createXbfParams(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfName</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfName
     */
    XbfName createXbfName(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFbasicType</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbasicType
     */
    XbfFbasicType createXbfFbasicType(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfKind</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfKind
     */
    XbfKind createXbfKind(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFarrayRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayRef
     */
    XbfFarrayRef createXbfFarrayRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarRef
     */
    XbfVarRef createXbfVarRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcharacterRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterRef
     */
    XbfFcharacterRef createXbfFcharacterRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfIndexRange</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfIndexRange
     */
    XbfIndexRange createXbfIndexRange(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLowerBound</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLowerBound
     */
    XbfLowerBound createXbfLowerBound(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUpperBound</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUpperBound
     */
    XbfUpperBound createXbfUpperBound(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfStep</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStep
     */
    XbfStep createXbfStep(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmemberRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmemberRef
     */
    XbfFmemberRef createXbfFmemberRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcoArrayRef
     */
    XbfFcoArrayRef createXbfFcoArrayRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfArrayIndex</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArrayIndex
     */
    XbfArrayIndex createXbfArrayIndex(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVar</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVar
     */
    XbfVar createXbfVar(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayConstructor
     */
    XbfFarrayConstructor createXbfFarrayConstructor(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoLoop</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoLoop
     */
    XbfFdoLoop createXbfFdoLoop(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfValue</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValue
     */
    XbfValue createXbfValue(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRepeatCount</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRepeatCount
     */
    XbfRepeatCount createXbfRepeatCount(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFintConstant</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFintConstant
     */
    XbfFintConstant createXbfFintConstant(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFrealConstant</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrealConstant
     */
    XbfFrealConstant createXbfFrealConstant(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterConstant
     */
    XbfFcharacterConstant createXbfFcharacterConstant(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFlogicalConstant
     */
    XbfFlogicalConstant createXbfFlogicalConstant(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcomplexConstant
     */
    XbfFcomplexConstant createXbfFcomplexConstant(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructConstructor</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructConstructor
     */
    XbfFstructConstructor createXbfFstructConstructor(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFunctionCall</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFunctionCall
     */
    XbfFunctionCall createXbfFunctionCall(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfArguments</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArguments
     */
    XbfArguments createXbfArguments(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfNamedValue</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValue
     */
    XbfNamedValue createXbfNamedValue(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserUnaryExpr
     */
    XbfUserUnaryExpr createXbfUserUnaryExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserBinaryExpr
     */
    XbfUserBinaryExpr createXbfUserBinaryExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNotExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNotExpr
     */
    XbfLogNotExpr createXbfLogNotExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunction</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunction
     */
    XbfFfunction createXbfFfunction(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQExpr
     */
    XbfLogNEQExpr createXbfLogNEQExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogGTExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGTExpr
     */
    XbfLogGTExpr createXbfLogGTExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQVExpr
     */
    XbfLogNEQVExpr createXbfLogNEQVExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfPlusExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfPlusExpr
     */
    XbfPlusExpr createXbfPlusExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfMinusExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMinusExpr
     */
    XbfMinusExpr createXbfMinusExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfMulExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMulExpr
     */
    XbfMulExpr createXbfMulExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfDivExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDivExpr
     */
    XbfDivExpr createXbfDivExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpowerExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpowerExpr
     */
    XbfFpowerExpr createXbfFpowerExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFconcatExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFconcatExpr
     */
    XbfFconcatExpr createXbfFconcatExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogEQExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQExpr
     */
    XbfLogEQExpr createXbfLogEQExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogGEExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGEExpr
     */
    XbfLogGEExpr createXbfLogGEExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogLEExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLEExpr
     */
    XbfLogLEExpr createXbfLogLEExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogLTExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLTExpr
     */
    XbfLogLTExpr createXbfLogLTExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogAndExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogAndExpr
     */
    XbfLogAndExpr createXbfLogAndExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogOrExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogOrExpr
     */
    XbfLogOrExpr createXbfLogOrExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQVExpr
     */
    XbfLogEQVExpr createXbfLogEQVExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUnaryMinusExpr
     */
    XbfUnaryMinusExpr createXbfUnaryMinusExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLen</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLen
     */
    XbfLen createXbfLen(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfCoShape</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCoShape
     */
    XbfCoShape createXbfCoShape(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructType</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructType
     */
    XbfFstructType createXbfFstructType(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfSymbols</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfSymbols
     */
    XbfSymbols createXbfSymbols(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfId</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfId
     */
    XbfId createXbfId(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalSymbols
     */
    XbfGlobalSymbols createXbfGlobalSymbols(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalDeclarations
     */
    XbfGlobalDeclarations createXbfGlobalDeclarations(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDefinition
     */
    XbfFfunctionDefinition createXbfFfunctionDefinition(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfDeclarations</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDeclarations
     */
    XbfDeclarations createXbfDeclarations(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarDecl
     */
    XbfVarDecl createXbfVarDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfExternDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExternDecl
     */
    XbfExternDecl createXbfExternDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFuseDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseDecl
     */
    XbfFuseDecl createXbfFuseDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRename</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRename
     */
    XbfRename createXbfRename(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseOnlyDecl
     */
    XbfFuseOnlyDecl createXbfFuseOnlyDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRenamable</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRenamable
     */
    XbfRenamable createXbfRenamable(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinterfaceDecl
     */
    XbfFinterfaceDecl createXbfFinterfaceDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDecl
     */
    XbfFfunctionDecl createXbfFfunctionDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleProcedureDecl
     */
    XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnamelistDecl
     */
    XbfFnamelistDecl createXbfFnamelistDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarList
     */
    XbfVarList createXbfVarList(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFequivalenceDecl
     */
    XbfFequivalenceDecl createXbfFequivalenceDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcommonDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcommonDecl
     */
    XbfFcommonDecl createXbfFcommonDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructDecl
     */
    XbfFstructDecl createXbfFstructDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFentryDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFentryDecl
     */
    XbfFentryDecl createXbfFentryDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdataDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdataDecl
     */
    XbfFdataDecl createXbfFdataDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfValueList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValueList
     */
    XbfValueList createXbfValueList(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpragmaStatement
     */
    XbfFpragmaStatement createXbfFpragmaStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfBody</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfBody
     */
    XbfBody createXbfBody(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGotoStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGotoStatement
     */
    XbfGotoStatement createXbfGotoStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpauseStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpauseStatement
     */
    XbfFpauseStatement createXbfFpauseStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcycleStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcycleStatement
     */
    XbfFcycleStatement createXbfFcycleStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFreadStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreadStatement
     */
    XbfFreadStatement createXbfFreadStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfNamedValueList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValueList
     */
    XbfNamedValueList createXbfNamedValueList(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcloseStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcloseStatement
     */
    XbfFcloseStatement createXbfFcloseStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFopenStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFopenStatement
     */
    XbfFopenStatement createXbfFopenStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFassignStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFassignStatement
     */
    XbfFassignStatement createXbfFassignStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfExprStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExprStatement
     */
    XbfExprStatement createXbfExprStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpointerAssignStatement
     */
    XbfFpointerAssignStatement createXbfFpointerAssignStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFifStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFifStatement
     */
    XbfFifStatement createXbfFifStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfCondition</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCondition
     */
    XbfCondition createXbfCondition(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfThen</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfThen
     */
    XbfThen createXbfThen(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfElse</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfElse
     */
    XbfElse createXbfElse(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoStatement
     */
    XbfFdoStatement createXbfFdoStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoWhileStatement
     */
    XbfFdoWhileStatement createXbfFdoWhileStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfContinueStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfContinueStatement
     */
    XbfContinueStatement createXbfContinueStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFexitStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFexitStatement
     */
    XbfFexitStatement createXbfFexitStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFreturnStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreturnStatement
     */
    XbfFreturnStatement createXbfFreturnStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfStatementLabel</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStatementLabel
     */
    XbfStatementLabel createXbfStatementLabel(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFselectCaseStatement
     */
    XbfFselectCaseStatement createXbfFselectCaseStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcaseLabel</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcaseLabel
     */
    XbfFcaseLabel createXbfFcaseLabel(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFwhereStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwhereStatement
     */
    XbfFwhereStatement createXbfFwhereStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstopStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstopStatement
     */
    XbfFstopStatement createXbfFstopStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFwriteStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwriteStatement
     */
    XbfFwriteStatement createXbfFwriteStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFprintStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFprintStatement
     */
    XbfFprintStatement createXbfFprintStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFrewindStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrewindStatement
     */
    XbfFrewindStatement createXbfFrewindStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFendFileStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFendFileStatement
     */
    XbfFendFileStatement createXbfFendFileStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbackspaceStatement
     */
    XbfFbackspaceStatement createXbfFbackspaceStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFinquireStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinquireStatement
     */
    XbfFinquireStatement createXbfFinquireStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFformatDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFformatDecl
     */
    XbfFformatDecl createXbfFformatDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFallocateStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFallocateStatement
     */
    XbfFallocateStatement createXbfFallocateStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfAlloc</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfAlloc
     */
    XbfAlloc createXbfAlloc(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdeallocateStatement
     */
    XbfFdeallocateStatement createXbfFdeallocateStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnullifyStatement
     */
    XbfFnullifyStatement createXbfFnullifyStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcontainsStatement
     */
    XbfFcontainsStatement createXbfFcontainsStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfText</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfText
     */
    XbfText createXbfText(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleDefinition
     */
    XbfFmoduleDefinition createXbfFmoduleDefinition(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFblockDataDefinition
     */
    XbfFblockDataDefinition createXbfFblockDataDefinition(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfXcodeProgram</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfXcodeProgram
     */
    XbfXcodeProgram createXbfXcodeProgram(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfTypeTable</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfTypeTable
     */
    XbfTypeTable createXbfTypeTable(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionType</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionType
     */
    XbfFfunctionType createXbfFfunctionType(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfParams</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfParams
     */
    XbfParams createXbfParams(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfName</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfName
     */
    XbfName createXbfName(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFbasicType</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbasicType
     */
    XbfFbasicType createXbfFbasicType(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfKind</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfKind
     */
    XbfKind createXbfKind(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFarrayRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayRef
     */
    XbfFarrayRef createXbfFarrayRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarRef
     */
    XbfVarRef createXbfVarRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcharacterRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterRef
     */
    XbfFcharacterRef createXbfFcharacterRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfIndexRange</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfIndexRange
     */
    XbfIndexRange createXbfIndexRange(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLowerBound</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLowerBound
     */
    XbfLowerBound createXbfLowerBound(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUpperBound</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUpperBound
     */
    XbfUpperBound createXbfUpperBound(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfStep</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStep
     */
    XbfStep createXbfStep(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmemberRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmemberRef
     */
    XbfFmemberRef createXbfFmemberRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcoArrayRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcoArrayRef
     */
    XbfFcoArrayRef createXbfFcoArrayRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfArrayIndex</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArrayIndex
     */
    XbfArrayIndex createXbfArrayIndex(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVar</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVar
     */
    XbfVar createXbfVar(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFarrayConstructor</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayConstructor
     */
    XbfFarrayConstructor createXbfFarrayConstructor(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoLoop</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoLoop
     */
    XbfFdoLoop createXbfFdoLoop(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfValue</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValue
     */
    XbfValue createXbfValue(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRepeatCount</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRepeatCount
     */
    XbfRepeatCount createXbfRepeatCount(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFintConstant</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFintConstant
     */
    XbfFintConstant createXbfFintConstant(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFrealConstant</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrealConstant
     */
    XbfFrealConstant createXbfFrealConstant(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcharacterConstant</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterConstant
     */
    XbfFcharacterConstant createXbfFcharacterConstant(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFlogicalConstant</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFlogicalConstant
     */
    XbfFlogicalConstant createXbfFlogicalConstant(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcomplexConstant</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcomplexConstant
     */
    XbfFcomplexConstant createXbfFcomplexConstant(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructConstructor</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructConstructor
     */
    XbfFstructConstructor createXbfFstructConstructor(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFunctionCall</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFunctionCall
     */
    XbfFunctionCall createXbfFunctionCall(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfArguments</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArguments
     */
    XbfArguments createXbfArguments(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfNamedValue</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValue
     */
    XbfNamedValue createXbfNamedValue(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUserUnaryExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserUnaryExpr
     */
    XbfUserUnaryExpr createXbfUserUnaryExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUserBinaryExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserBinaryExpr
     */
    XbfUserBinaryExpr createXbfUserBinaryExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNotExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNotExpr
     */
    XbfLogNotExpr createXbfLogNotExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunction</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunction
     */
    XbfFfunction createXbfFfunction(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNEQExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQExpr
     */
    XbfLogNEQExpr createXbfLogNEQExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogGTExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGTExpr
     */
    XbfLogGTExpr createXbfLogGTExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNEQVExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQVExpr
     */
    XbfLogNEQVExpr createXbfLogNEQVExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfPlusExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfPlusExpr
     */
    XbfPlusExpr createXbfPlusExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfMinusExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMinusExpr
     */
    XbfMinusExpr createXbfMinusExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfMulExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMulExpr
     */
    XbfMulExpr createXbfMulExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfDivExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDivExpr
     */
    XbfDivExpr createXbfDivExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpowerExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpowerExpr
     */
    XbfFpowerExpr createXbfFpowerExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFconcatExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFconcatExpr
     */
    XbfFconcatExpr createXbfFconcatExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogEQExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQExpr
     */
    XbfLogEQExpr createXbfLogEQExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogGEExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGEExpr
     */
    XbfLogGEExpr createXbfLogGEExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogLEExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLEExpr
     */
    XbfLogLEExpr createXbfLogLEExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogLTExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLTExpr
     */
    XbfLogLTExpr createXbfLogLTExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogAndExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogAndExpr
     */
    XbfLogAndExpr createXbfLogAndExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogOrExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogOrExpr
     */
    XbfLogOrExpr createXbfLogOrExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogEQVExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQVExpr
     */
    XbfLogEQVExpr createXbfLogEQVExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUnaryMinusExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUnaryMinusExpr
     */
    XbfUnaryMinusExpr createXbfUnaryMinusExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLen</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLen
     */
    XbfLen createXbfLen(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfCoShape</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCoShape
     */
    XbfCoShape createXbfCoShape(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructType</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructType
     */
    XbfFstructType createXbfFstructType(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfSymbols</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfSymbols
     */
    XbfSymbols createXbfSymbols(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfId</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfId
     */
    XbfId createXbfId(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGlobalSymbols</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalSymbols
     */
    XbfGlobalSymbols createXbfGlobalSymbols(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGlobalDeclarations</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalDeclarations
     */
    XbfGlobalDeclarations createXbfGlobalDeclarations(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionDefinition</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDefinition
     */
    XbfFfunctionDefinition createXbfFfunctionDefinition(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfDeclarations</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDeclarations
     */
    XbfDeclarations createXbfDeclarations(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarDecl
     */
    XbfVarDecl createXbfVarDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfExternDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExternDecl
     */
    XbfExternDecl createXbfExternDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFuseDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseDecl
     */
    XbfFuseDecl createXbfFuseDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRename</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRename
     */
    XbfRename createXbfRename(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFuseOnlyDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseOnlyDecl
     */
    XbfFuseOnlyDecl createXbfFuseOnlyDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRenamable</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRenamable
     */
    XbfRenamable createXbfRenamable(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFinterfaceDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinterfaceDecl
     */
    XbfFinterfaceDecl createXbfFinterfaceDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDecl
     */
    XbfFfunctionDecl createXbfFfunctionDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleProcedureDecl
     */
    XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFnamelistDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnamelistDecl
     */
    XbfFnamelistDecl createXbfFnamelistDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarList
     */
    XbfVarList createXbfVarList(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFequivalenceDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFequivalenceDecl
     */
    XbfFequivalenceDecl createXbfFequivalenceDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcommonDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcommonDecl
     */
    XbfFcommonDecl createXbfFcommonDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructDecl
     */
    XbfFstructDecl createXbfFstructDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFentryDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFentryDecl
     */
    XbfFentryDecl createXbfFentryDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdataDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdataDecl
     */
    XbfFdataDecl createXbfFdataDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfValueList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValueList
     */
    XbfValueList createXbfValueList(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpragmaStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpragmaStatement
     */
    XbfFpragmaStatement createXbfFpragmaStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfBody</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfBody
     */
    XbfBody createXbfBody(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGotoStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGotoStatement
     */
    XbfGotoStatement createXbfGotoStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpauseStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpauseStatement
     */
    XbfFpauseStatement createXbfFpauseStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcycleStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcycleStatement
     */
    XbfFcycleStatement createXbfFcycleStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFreadStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreadStatement
     */
    XbfFreadStatement createXbfFreadStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfNamedValueList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValueList
     */
    XbfNamedValueList createXbfNamedValueList(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcloseStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcloseStatement
     */
    XbfFcloseStatement createXbfFcloseStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFopenStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFopenStatement
     */
    XbfFopenStatement createXbfFopenStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFassignStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFassignStatement
     */
    XbfFassignStatement createXbfFassignStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfExprStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExprStatement
     */
    XbfExprStatement createXbfExprStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpointerAssignStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpointerAssignStatement
     */
    XbfFpointerAssignStatement createXbfFpointerAssignStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFifStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFifStatement
     */
    XbfFifStatement createXbfFifStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfCondition</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCondition
     */
    XbfCondition createXbfCondition(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfThen</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfThen
     */
    XbfThen createXbfThen(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfElse</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfElse
     */
    XbfElse createXbfElse(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoStatement
     */
    XbfFdoStatement createXbfFdoStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoWhileStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoWhileStatement
     */
    XbfFdoWhileStatement createXbfFdoWhileStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfContinueStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfContinueStatement
     */
    XbfContinueStatement createXbfContinueStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFexitStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFexitStatement
     */
    XbfFexitStatement createXbfFexitStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFreturnStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreturnStatement
     */
    XbfFreturnStatement createXbfFreturnStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfStatementLabel</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStatementLabel
     */
    XbfStatementLabel createXbfStatementLabel(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFselectCaseStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFselectCaseStatement
     */
    XbfFselectCaseStatement createXbfFselectCaseStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcaseLabel</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcaseLabel
     */
    XbfFcaseLabel createXbfFcaseLabel(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFwhereStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwhereStatement
     */
    XbfFwhereStatement createXbfFwhereStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstopStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstopStatement
     */
    XbfFstopStatement createXbfFstopStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFwriteStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwriteStatement
     */
    XbfFwriteStatement createXbfFwriteStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFprintStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFprintStatement
     */
    XbfFprintStatement createXbfFprintStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFrewindStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrewindStatement
     */
    XbfFrewindStatement createXbfFrewindStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFendFileStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFendFileStatement
     */
    XbfFendFileStatement createXbfFendFileStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFbackspaceStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbackspaceStatement
     */
    XbfFbackspaceStatement createXbfFbackspaceStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFinquireStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinquireStatement
     */
    XbfFinquireStatement createXbfFinquireStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFformatDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFformatDecl
     */
    XbfFformatDecl createXbfFformatDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFallocateStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFallocateStatement
     */
    XbfFallocateStatement createXbfFallocateStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfAlloc</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfAlloc
     */
    XbfAlloc createXbfAlloc(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdeallocateStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdeallocateStatement
     */
    XbfFdeallocateStatement createXbfFdeallocateStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFnullifyStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnullifyStatement
     */
    XbfFnullifyStatement createXbfFnullifyStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcontainsStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcontainsStatement
     */
    XbfFcontainsStatement createXbfFcontainsStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfText</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfText
     */
    XbfText createXbfText(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmoduleDefinition</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleDefinition
     */
    XbfFmoduleDefinition createXbfFmoduleDefinition(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFblockDataDefinition</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFblockDataDefinition
     */
    XbfFblockDataDefinition createXbfFblockDataDefinition(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfXcodeProgram</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfXcodeProgram
     */
    XbfXcodeProgram createXbfXcodeProgram(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfTypeTable</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfTypeTable
     */
    XbfTypeTable createXbfTypeTable(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionType</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionType
     */
    XbfFfunctionType createXbfFfunctionType(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfParams</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfParams
     */
    XbfParams createXbfParams(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfName</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfName
     */
    XbfName createXbfName(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFbasicType</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbasicType
     */
    XbfFbasicType createXbfFbasicType(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfKind</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfKind
     */
    XbfKind createXbfKind(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFarrayRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayRef
     */
    XbfFarrayRef createXbfFarrayRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarRef
     */
    XbfVarRef createXbfVarRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcharacterRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterRef
     */
    XbfFcharacterRef createXbfFcharacterRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfIndexRange</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfIndexRange
     */
    XbfIndexRange createXbfIndexRange(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLowerBound</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLowerBound
     */
    XbfLowerBound createXbfLowerBound(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUpperBound</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUpperBound
     */
    XbfUpperBound createXbfUpperBound(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfStep</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStep
     */
    XbfStep createXbfStep(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmemberRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmemberRef
     */
    XbfFmemberRef createXbfFmemberRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcoArrayRef
     */
    XbfFcoArrayRef createXbfFcoArrayRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfArrayIndex</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArrayIndex
     */
    XbfArrayIndex createXbfArrayIndex(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVar</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVar
     */
    XbfVar createXbfVar(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayConstructor
     */
    XbfFarrayConstructor createXbfFarrayConstructor(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoLoop</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoLoop
     */
    XbfFdoLoop createXbfFdoLoop(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfValue</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValue
     */
    XbfValue createXbfValue(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRepeatCount</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRepeatCount
     */
    XbfRepeatCount createXbfRepeatCount(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFintConstant</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFintConstant
     */
    XbfFintConstant createXbfFintConstant(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFrealConstant</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrealConstant
     */
    XbfFrealConstant createXbfFrealConstant(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterConstant
     */
    XbfFcharacterConstant createXbfFcharacterConstant(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFlogicalConstant
     */
    XbfFlogicalConstant createXbfFlogicalConstant(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcomplexConstant
     */
    XbfFcomplexConstant createXbfFcomplexConstant(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructConstructor</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructConstructor
     */
    XbfFstructConstructor createXbfFstructConstructor(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFunctionCall</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFunctionCall
     */
    XbfFunctionCall createXbfFunctionCall(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfArguments</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArguments
     */
    XbfArguments createXbfArguments(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfNamedValue</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValue
     */
    XbfNamedValue createXbfNamedValue(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserUnaryExpr
     */
    XbfUserUnaryExpr createXbfUserUnaryExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserBinaryExpr
     */
    XbfUserBinaryExpr createXbfUserBinaryExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNotExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNotExpr
     */
    XbfLogNotExpr createXbfLogNotExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunction</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunction
     */
    XbfFfunction createXbfFfunction(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQExpr
     */
    XbfLogNEQExpr createXbfLogNEQExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogGTExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGTExpr
     */
    XbfLogGTExpr createXbfLogGTExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQVExpr
     */
    XbfLogNEQVExpr createXbfLogNEQVExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfPlusExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfPlusExpr
     */
    XbfPlusExpr createXbfPlusExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfMinusExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMinusExpr
     */
    XbfMinusExpr createXbfMinusExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfMulExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMulExpr
     */
    XbfMulExpr createXbfMulExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfDivExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDivExpr
     */
    XbfDivExpr createXbfDivExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpowerExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpowerExpr
     */
    XbfFpowerExpr createXbfFpowerExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFconcatExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFconcatExpr
     */
    XbfFconcatExpr createXbfFconcatExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogEQExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQExpr
     */
    XbfLogEQExpr createXbfLogEQExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogGEExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGEExpr
     */
    XbfLogGEExpr createXbfLogGEExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogLEExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLEExpr
     */
    XbfLogLEExpr createXbfLogLEExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogLTExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLTExpr
     */
    XbfLogLTExpr createXbfLogLTExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogAndExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogAndExpr
     */
    XbfLogAndExpr createXbfLogAndExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogOrExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogOrExpr
     */
    XbfLogOrExpr createXbfLogOrExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQVExpr
     */
    XbfLogEQVExpr createXbfLogEQVExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUnaryMinusExpr
     */
    XbfUnaryMinusExpr createXbfUnaryMinusExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLen</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLen
     */
    XbfLen createXbfLen(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfCoShape</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCoShape
     */
    XbfCoShape createXbfCoShape(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructType</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructType
     */
    XbfFstructType createXbfFstructType(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfSymbols</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfSymbols
     */
    XbfSymbols createXbfSymbols(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfId</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfId
     */
    XbfId createXbfId(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalSymbols
     */
    XbfGlobalSymbols createXbfGlobalSymbols(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalDeclarations
     */
    XbfGlobalDeclarations createXbfGlobalDeclarations(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDefinition
     */
    XbfFfunctionDefinition createXbfFfunctionDefinition(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfDeclarations</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDeclarations
     */
    XbfDeclarations createXbfDeclarations(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarDecl
     */
    XbfVarDecl createXbfVarDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfExternDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExternDecl
     */
    XbfExternDecl createXbfExternDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFuseDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseDecl
     */
    XbfFuseDecl createXbfFuseDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRename</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRename
     */
    XbfRename createXbfRename(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseOnlyDecl
     */
    XbfFuseOnlyDecl createXbfFuseOnlyDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRenamable</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRenamable
     */
    XbfRenamable createXbfRenamable(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinterfaceDecl
     */
    XbfFinterfaceDecl createXbfFinterfaceDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDecl
     */
    XbfFfunctionDecl createXbfFfunctionDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleProcedureDecl
     */
    XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnamelistDecl
     */
    XbfFnamelistDecl createXbfFnamelistDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarList
     */
    XbfVarList createXbfVarList(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFequivalenceDecl
     */
    XbfFequivalenceDecl createXbfFequivalenceDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcommonDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcommonDecl
     */
    XbfFcommonDecl createXbfFcommonDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructDecl
     */
    XbfFstructDecl createXbfFstructDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFentryDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFentryDecl
     */
    XbfFentryDecl createXbfFentryDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdataDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdataDecl
     */
    XbfFdataDecl createXbfFdataDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfValueList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValueList
     */
    XbfValueList createXbfValueList(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpragmaStatement
     */
    XbfFpragmaStatement createXbfFpragmaStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfBody</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfBody
     */
    XbfBody createXbfBody(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGotoStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGotoStatement
     */
    XbfGotoStatement createXbfGotoStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpauseStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpauseStatement
     */
    XbfFpauseStatement createXbfFpauseStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcycleStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcycleStatement
     */
    XbfFcycleStatement createXbfFcycleStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFreadStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreadStatement
     */
    XbfFreadStatement createXbfFreadStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfNamedValueList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValueList
     */
    XbfNamedValueList createXbfNamedValueList(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcloseStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcloseStatement
     */
    XbfFcloseStatement createXbfFcloseStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFopenStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFopenStatement
     */
    XbfFopenStatement createXbfFopenStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFassignStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFassignStatement
     */
    XbfFassignStatement createXbfFassignStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfExprStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExprStatement
     */
    XbfExprStatement createXbfExprStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpointerAssignStatement
     */
    XbfFpointerAssignStatement createXbfFpointerAssignStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFifStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFifStatement
     */
    XbfFifStatement createXbfFifStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfCondition</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCondition
     */
    XbfCondition createXbfCondition(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfThen</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfThen
     */
    XbfThen createXbfThen(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfElse</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfElse
     */
    XbfElse createXbfElse(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoStatement
     */
    XbfFdoStatement createXbfFdoStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoWhileStatement
     */
    XbfFdoWhileStatement createXbfFdoWhileStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfContinueStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfContinueStatement
     */
    XbfContinueStatement createXbfContinueStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFexitStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFexitStatement
     */
    XbfFexitStatement createXbfFexitStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFreturnStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreturnStatement
     */
    XbfFreturnStatement createXbfFreturnStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfStatementLabel</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStatementLabel
     */
    XbfStatementLabel createXbfStatementLabel(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFselectCaseStatement
     */
    XbfFselectCaseStatement createXbfFselectCaseStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcaseLabel</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcaseLabel
     */
    XbfFcaseLabel createXbfFcaseLabel(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFwhereStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwhereStatement
     */
    XbfFwhereStatement createXbfFwhereStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstopStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstopStatement
     */
    XbfFstopStatement createXbfFstopStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFwriteStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwriteStatement
     */
    XbfFwriteStatement createXbfFwriteStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFprintStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFprintStatement
     */
    XbfFprintStatement createXbfFprintStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFrewindStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrewindStatement
     */
    XbfFrewindStatement createXbfFrewindStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFendFileStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFendFileStatement
     */
    XbfFendFileStatement createXbfFendFileStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbackspaceStatement
     */
    XbfFbackspaceStatement createXbfFbackspaceStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFinquireStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinquireStatement
     */
    XbfFinquireStatement createXbfFinquireStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFformatDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFformatDecl
     */
    XbfFformatDecl createXbfFformatDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFallocateStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFallocateStatement
     */
    XbfFallocateStatement createXbfFallocateStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfAlloc</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfAlloc
     */
    XbfAlloc createXbfAlloc(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdeallocateStatement
     */
    XbfFdeallocateStatement createXbfFdeallocateStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnullifyStatement
     */
    XbfFnullifyStatement createXbfFnullifyStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcontainsStatement
     */
    XbfFcontainsStatement createXbfFcontainsStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfText</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfText
     */
    XbfText createXbfText(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleDefinition
     */
    XbfFmoduleDefinition createXbfFmoduleDefinition(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFblockDataDefinition
     */
    XbfFblockDataDefinition createXbfFblockDataDefinition(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfXcodeProgram</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfXcodeProgram
     */
    XbfXcodeProgram createXbfXcodeProgram(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfTypeTable</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfTypeTable
     */
    XbfTypeTable createXbfTypeTable(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionType</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionType
     */
    XbfFfunctionType createXbfFfunctionType(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfParams</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfParams
     */
    XbfParams createXbfParams(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfName</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfName
     */
    XbfName createXbfName(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFbasicType</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbasicType
     */
    XbfFbasicType createXbfFbasicType(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfKind</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfKind
     */
    XbfKind createXbfKind(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFarrayRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayRef
     */
    XbfFarrayRef createXbfFarrayRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarRef
     */
    XbfVarRef createXbfVarRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcharacterRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterRef
     */
    XbfFcharacterRef createXbfFcharacterRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfIndexRange</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfIndexRange
     */
    XbfIndexRange createXbfIndexRange(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLowerBound</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLowerBound
     */
    XbfLowerBound createXbfLowerBound(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUpperBound</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUpperBound
     */
    XbfUpperBound createXbfUpperBound(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfStep</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStep
     */
    XbfStep createXbfStep(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmemberRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmemberRef
     */
    XbfFmemberRef createXbfFmemberRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcoArrayRef
     */
    XbfFcoArrayRef createXbfFcoArrayRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfArrayIndex</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArrayIndex
     */
    XbfArrayIndex createXbfArrayIndex(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVar</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVar
     */
    XbfVar createXbfVar(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayConstructor
     */
    XbfFarrayConstructor createXbfFarrayConstructor(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoLoop</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoLoop
     */
    XbfFdoLoop createXbfFdoLoop(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfValue</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValue
     */
    XbfValue createXbfValue(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRepeatCount</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRepeatCount
     */
    XbfRepeatCount createXbfRepeatCount(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFintConstant</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFintConstant
     */
    XbfFintConstant createXbfFintConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFrealConstant</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrealConstant
     */
    XbfFrealConstant createXbfFrealConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterConstant
     */
    XbfFcharacterConstant createXbfFcharacterConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFlogicalConstant
     */
    XbfFlogicalConstant createXbfFlogicalConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcomplexConstant
     */
    XbfFcomplexConstant createXbfFcomplexConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructConstructor</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructConstructor
     */
    XbfFstructConstructor createXbfFstructConstructor(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFunctionCall</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFunctionCall
     */
    XbfFunctionCall createXbfFunctionCall(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfArguments</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArguments
     */
    XbfArguments createXbfArguments(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfNamedValue</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValue
     */
    XbfNamedValue createXbfNamedValue(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserUnaryExpr
     */
    XbfUserUnaryExpr createXbfUserUnaryExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserBinaryExpr
     */
    XbfUserBinaryExpr createXbfUserBinaryExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNotExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNotExpr
     */
    XbfLogNotExpr createXbfLogNotExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunction</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunction
     */
    XbfFfunction createXbfFfunction(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQExpr
     */
    XbfLogNEQExpr createXbfLogNEQExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogGTExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGTExpr
     */
    XbfLogGTExpr createXbfLogGTExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQVExpr
     */
    XbfLogNEQVExpr createXbfLogNEQVExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfPlusExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfPlusExpr
     */
    XbfPlusExpr createXbfPlusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfMinusExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMinusExpr
     */
    XbfMinusExpr createXbfMinusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfMulExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMulExpr
     */
    XbfMulExpr createXbfMulExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfDivExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDivExpr
     */
    XbfDivExpr createXbfDivExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpowerExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpowerExpr
     */
    XbfFpowerExpr createXbfFpowerExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFconcatExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFconcatExpr
     */
    XbfFconcatExpr createXbfFconcatExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogEQExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQExpr
     */
    XbfLogEQExpr createXbfLogEQExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogGEExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGEExpr
     */
    XbfLogGEExpr createXbfLogGEExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogLEExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLEExpr
     */
    XbfLogLEExpr createXbfLogLEExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogLTExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLTExpr
     */
    XbfLogLTExpr createXbfLogLTExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogAndExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogAndExpr
     */
    XbfLogAndExpr createXbfLogAndExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogOrExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogOrExpr
     */
    XbfLogOrExpr createXbfLogOrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQVExpr
     */
    XbfLogEQVExpr createXbfLogEQVExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUnaryMinusExpr
     */
    XbfUnaryMinusExpr createXbfUnaryMinusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLen</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLen
     */
    XbfLen createXbfLen(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfCoShape</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCoShape
     */
    XbfCoShape createXbfCoShape(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructType</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructType
     */
    XbfFstructType createXbfFstructType(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfSymbols</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfSymbols
     */
    XbfSymbols createXbfSymbols(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfId</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfId
     */
    XbfId createXbfId(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalSymbols
     */
    XbfGlobalSymbols createXbfGlobalSymbols(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalDeclarations
     */
    XbfGlobalDeclarations createXbfGlobalDeclarations(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDefinition
     */
    XbfFfunctionDefinition createXbfFfunctionDefinition(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfDeclarations</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDeclarations
     */
    XbfDeclarations createXbfDeclarations(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarDecl
     */
    XbfVarDecl createXbfVarDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfExternDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExternDecl
     */
    XbfExternDecl createXbfExternDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFuseDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseDecl
     */
    XbfFuseDecl createXbfFuseDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRename</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRename
     */
    XbfRename createXbfRename(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseOnlyDecl
     */
    XbfFuseOnlyDecl createXbfFuseOnlyDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRenamable</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRenamable
     */
    XbfRenamable createXbfRenamable(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinterfaceDecl
     */
    XbfFinterfaceDecl createXbfFinterfaceDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDecl
     */
    XbfFfunctionDecl createXbfFfunctionDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleProcedureDecl
     */
    XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnamelistDecl
     */
    XbfFnamelistDecl createXbfFnamelistDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarList
     */
    XbfVarList createXbfVarList(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFequivalenceDecl
     */
    XbfFequivalenceDecl createXbfFequivalenceDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcommonDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcommonDecl
     */
    XbfFcommonDecl createXbfFcommonDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructDecl
     */
    XbfFstructDecl createXbfFstructDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFentryDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFentryDecl
     */
    XbfFentryDecl createXbfFentryDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdataDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdataDecl
     */
    XbfFdataDecl createXbfFdataDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfValueList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValueList
     */
    XbfValueList createXbfValueList(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpragmaStatement
     */
    XbfFpragmaStatement createXbfFpragmaStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfBody</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfBody
     */
    XbfBody createXbfBody(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGotoStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGotoStatement
     */
    XbfGotoStatement createXbfGotoStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpauseStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpauseStatement
     */
    XbfFpauseStatement createXbfFpauseStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcycleStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcycleStatement
     */
    XbfFcycleStatement createXbfFcycleStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFreadStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreadStatement
     */
    XbfFreadStatement createXbfFreadStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfNamedValueList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValueList
     */
    XbfNamedValueList createXbfNamedValueList(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcloseStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcloseStatement
     */
    XbfFcloseStatement createXbfFcloseStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFopenStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFopenStatement
     */
    XbfFopenStatement createXbfFopenStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFassignStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFassignStatement
     */
    XbfFassignStatement createXbfFassignStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfExprStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExprStatement
     */
    XbfExprStatement createXbfExprStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpointerAssignStatement
     */
    XbfFpointerAssignStatement createXbfFpointerAssignStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFifStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFifStatement
     */
    XbfFifStatement createXbfFifStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfCondition</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCondition
     */
    XbfCondition createXbfCondition(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfThen</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfThen
     */
    XbfThen createXbfThen(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfElse</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfElse
     */
    XbfElse createXbfElse(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoStatement
     */
    XbfFdoStatement createXbfFdoStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoWhileStatement
     */
    XbfFdoWhileStatement createXbfFdoWhileStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfContinueStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfContinueStatement
     */
    XbfContinueStatement createXbfContinueStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFexitStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFexitStatement
     */
    XbfFexitStatement createXbfFexitStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFreturnStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreturnStatement
     */
    XbfFreturnStatement createXbfFreturnStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfStatementLabel</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStatementLabel
     */
    XbfStatementLabel createXbfStatementLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFselectCaseStatement
     */
    XbfFselectCaseStatement createXbfFselectCaseStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcaseLabel</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcaseLabel
     */
    XbfFcaseLabel createXbfFcaseLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFwhereStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwhereStatement
     */
    XbfFwhereStatement createXbfFwhereStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstopStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstopStatement
     */
    XbfFstopStatement createXbfFstopStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFwriteStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwriteStatement
     */
    XbfFwriteStatement createXbfFwriteStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFprintStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFprintStatement
     */
    XbfFprintStatement createXbfFprintStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFrewindStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrewindStatement
     */
    XbfFrewindStatement createXbfFrewindStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFendFileStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFendFileStatement
     */
    XbfFendFileStatement createXbfFendFileStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbackspaceStatement
     */
    XbfFbackspaceStatement createXbfFbackspaceStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFinquireStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinquireStatement
     */
    XbfFinquireStatement createXbfFinquireStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFformatDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFformatDecl
     */
    XbfFformatDecl createXbfFformatDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFallocateStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFallocateStatement
     */
    XbfFallocateStatement createXbfFallocateStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfAlloc</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfAlloc
     */
    XbfAlloc createXbfAlloc(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdeallocateStatement
     */
    XbfFdeallocateStatement createXbfFdeallocateStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnullifyStatement
     */
    XbfFnullifyStatement createXbfFnullifyStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcontainsStatement
     */
    XbfFcontainsStatement createXbfFcontainsStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfText</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfText
     */
    XbfText createXbfText(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleDefinition
     */
    XbfFmoduleDefinition createXbfFmoduleDefinition(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFblockDataDefinition
     */
    XbfFblockDataDefinition createXbfFblockDataDefinition(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfXcodeProgram</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfXcodeProgram
     */
    XbfXcodeProgram createXbfXcodeProgram(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfTypeTable</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfTypeTable
     */
    XbfTypeTable createXbfTypeTable(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionType</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionType
     */
    XbfFfunctionType createXbfFfunctionType(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfParams</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfParams
     */
    XbfParams createXbfParams(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfName</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfName
     */
    XbfName createXbfName(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFbasicType</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbasicType
     */
    XbfFbasicType createXbfFbasicType(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfKind</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfKind
     */
    XbfKind createXbfKind(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFarrayRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayRef
     */
    XbfFarrayRef createXbfFarrayRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarRef
     */
    XbfVarRef createXbfVarRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcharacterRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterRef
     */
    XbfFcharacterRef createXbfFcharacterRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfIndexRange</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfIndexRange
     */
    XbfIndexRange createXbfIndexRange(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLowerBound</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLowerBound
     */
    XbfLowerBound createXbfLowerBound(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUpperBound</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUpperBound
     */
    XbfUpperBound createXbfUpperBound(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfStep</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStep
     */
    XbfStep createXbfStep(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmemberRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmemberRef
     */
    XbfFmemberRef createXbfFmemberRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcoArrayRef
     */
    XbfFcoArrayRef createXbfFcoArrayRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfArrayIndex</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArrayIndex
     */
    XbfArrayIndex createXbfArrayIndex(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVar</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVar
     */
    XbfVar createXbfVar(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayConstructor
     */
    XbfFarrayConstructor createXbfFarrayConstructor(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoLoop</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoLoop
     */
    XbfFdoLoop createXbfFdoLoop(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfValue</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValue
     */
    XbfValue createXbfValue(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRepeatCount</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRepeatCount
     */
    XbfRepeatCount createXbfRepeatCount(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFintConstant</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFintConstant
     */
    XbfFintConstant createXbfFintConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFrealConstant</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrealConstant
     */
    XbfFrealConstant createXbfFrealConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterConstant
     */
    XbfFcharacterConstant createXbfFcharacterConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFlogicalConstant
     */
    XbfFlogicalConstant createXbfFlogicalConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcomplexConstant
     */
    XbfFcomplexConstant createXbfFcomplexConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructConstructor</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructConstructor
     */
    XbfFstructConstructor createXbfFstructConstructor(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFunctionCall</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFunctionCall
     */
    XbfFunctionCall createXbfFunctionCall(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfArguments</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArguments
     */
    XbfArguments createXbfArguments(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfNamedValue</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValue
     */
    XbfNamedValue createXbfNamedValue(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserUnaryExpr
     */
    XbfUserUnaryExpr createXbfUserUnaryExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserBinaryExpr
     */
    XbfUserBinaryExpr createXbfUserBinaryExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNotExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNotExpr
     */
    XbfLogNotExpr createXbfLogNotExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunction</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunction
     */
    XbfFfunction createXbfFfunction(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQExpr
     */
    XbfLogNEQExpr createXbfLogNEQExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogGTExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGTExpr
     */
    XbfLogGTExpr createXbfLogGTExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQVExpr
     */
    XbfLogNEQVExpr createXbfLogNEQVExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfPlusExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfPlusExpr
     */
    XbfPlusExpr createXbfPlusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfMinusExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMinusExpr
     */
    XbfMinusExpr createXbfMinusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfMulExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMulExpr
     */
    XbfMulExpr createXbfMulExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfDivExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDivExpr
     */
    XbfDivExpr createXbfDivExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpowerExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpowerExpr
     */
    XbfFpowerExpr createXbfFpowerExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFconcatExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFconcatExpr
     */
    XbfFconcatExpr createXbfFconcatExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogEQExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQExpr
     */
    XbfLogEQExpr createXbfLogEQExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogGEExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGEExpr
     */
    XbfLogGEExpr createXbfLogGEExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogLEExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLEExpr
     */
    XbfLogLEExpr createXbfLogLEExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogLTExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLTExpr
     */
    XbfLogLTExpr createXbfLogLTExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogAndExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogAndExpr
     */
    XbfLogAndExpr createXbfLogAndExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogOrExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogOrExpr
     */
    XbfLogOrExpr createXbfLogOrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQVExpr
     */
    XbfLogEQVExpr createXbfLogEQVExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUnaryMinusExpr
     */
    XbfUnaryMinusExpr createXbfUnaryMinusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLen</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLen
     */
    XbfLen createXbfLen(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfCoShape</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCoShape
     */
    XbfCoShape createXbfCoShape(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructType</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructType
     */
    XbfFstructType createXbfFstructType(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfSymbols</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfSymbols
     */
    XbfSymbols createXbfSymbols(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfId</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfId
     */
    XbfId createXbfId(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalSymbols
     */
    XbfGlobalSymbols createXbfGlobalSymbols(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalDeclarations
     */
    XbfGlobalDeclarations createXbfGlobalDeclarations(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDefinition
     */
    XbfFfunctionDefinition createXbfFfunctionDefinition(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfDeclarations</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDeclarations
     */
    XbfDeclarations createXbfDeclarations(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarDecl
     */
    XbfVarDecl createXbfVarDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfExternDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExternDecl
     */
    XbfExternDecl createXbfExternDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFuseDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseDecl
     */
    XbfFuseDecl createXbfFuseDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRename</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRename
     */
    XbfRename createXbfRename(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseOnlyDecl
     */
    XbfFuseOnlyDecl createXbfFuseOnlyDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRenamable</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRenamable
     */
    XbfRenamable createXbfRenamable(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinterfaceDecl
     */
    XbfFinterfaceDecl createXbfFinterfaceDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDecl
     */
    XbfFfunctionDecl createXbfFfunctionDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleProcedureDecl
     */
    XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnamelistDecl
     */
    XbfFnamelistDecl createXbfFnamelistDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarList
     */
    XbfVarList createXbfVarList(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFequivalenceDecl
     */
    XbfFequivalenceDecl createXbfFequivalenceDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcommonDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcommonDecl
     */
    XbfFcommonDecl createXbfFcommonDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructDecl
     */
    XbfFstructDecl createXbfFstructDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFentryDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFentryDecl
     */
    XbfFentryDecl createXbfFentryDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdataDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdataDecl
     */
    XbfFdataDecl createXbfFdataDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfValueList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValueList
     */
    XbfValueList createXbfValueList(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpragmaStatement
     */
    XbfFpragmaStatement createXbfFpragmaStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfBody</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfBody
     */
    XbfBody createXbfBody(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGotoStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGotoStatement
     */
    XbfGotoStatement createXbfGotoStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpauseStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpauseStatement
     */
    XbfFpauseStatement createXbfFpauseStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcycleStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcycleStatement
     */
    XbfFcycleStatement createXbfFcycleStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFreadStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreadStatement
     */
    XbfFreadStatement createXbfFreadStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfNamedValueList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValueList
     */
    XbfNamedValueList createXbfNamedValueList(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcloseStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcloseStatement
     */
    XbfFcloseStatement createXbfFcloseStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFopenStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFopenStatement
     */
    XbfFopenStatement createXbfFopenStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFassignStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFassignStatement
     */
    XbfFassignStatement createXbfFassignStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfExprStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExprStatement
     */
    XbfExprStatement createXbfExprStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpointerAssignStatement
     */
    XbfFpointerAssignStatement createXbfFpointerAssignStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFifStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFifStatement
     */
    XbfFifStatement createXbfFifStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfCondition</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCondition
     */
    XbfCondition createXbfCondition(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfThen</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfThen
     */
    XbfThen createXbfThen(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfElse</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfElse
     */
    XbfElse createXbfElse(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoStatement
     */
    XbfFdoStatement createXbfFdoStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoWhileStatement
     */
    XbfFdoWhileStatement createXbfFdoWhileStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfContinueStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfContinueStatement
     */
    XbfContinueStatement createXbfContinueStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFexitStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFexitStatement
     */
    XbfFexitStatement createXbfFexitStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFreturnStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreturnStatement
     */
    XbfFreturnStatement createXbfFreturnStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfStatementLabel</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStatementLabel
     */
    XbfStatementLabel createXbfStatementLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFselectCaseStatement
     */
    XbfFselectCaseStatement createXbfFselectCaseStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcaseLabel</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcaseLabel
     */
    XbfFcaseLabel createXbfFcaseLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFwhereStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwhereStatement
     */
    XbfFwhereStatement createXbfFwhereStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstopStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstopStatement
     */
    XbfFstopStatement createXbfFstopStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFwriteStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwriteStatement
     */
    XbfFwriteStatement createXbfFwriteStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFprintStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFprintStatement
     */
    XbfFprintStatement createXbfFprintStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFrewindStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrewindStatement
     */
    XbfFrewindStatement createXbfFrewindStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFendFileStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFendFileStatement
     */
    XbfFendFileStatement createXbfFendFileStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbackspaceStatement
     */
    XbfFbackspaceStatement createXbfFbackspaceStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFinquireStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinquireStatement
     */
    XbfFinquireStatement createXbfFinquireStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFformatDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFformatDecl
     */
    XbfFformatDecl createXbfFformatDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFallocateStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFallocateStatement
     */
    XbfFallocateStatement createXbfFallocateStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfAlloc</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfAlloc
     */
    XbfAlloc createXbfAlloc(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdeallocateStatement
     */
    XbfFdeallocateStatement createXbfFdeallocateStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnullifyStatement
     */
    XbfFnullifyStatement createXbfFnullifyStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcontainsStatement
     */
    XbfFcontainsStatement createXbfFcontainsStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfText</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfText
     */
    XbfText createXbfText(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleDefinition
     */
    XbfFmoduleDefinition createXbfFmoduleDefinition(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFblockDataDefinition
     */
    XbfFblockDataDefinition createXbfFblockDataDefinition(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfXcodeProgram</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfXcodeProgram
     */
    XbfXcodeProgram createXbfXcodeProgram(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfTypeTable</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfTypeTable
     */
    XbfTypeTable createXbfTypeTable(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionType</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionType
     */
    XbfFfunctionType createXbfFfunctionType(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfParams</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfParams
     */
    XbfParams createXbfParams(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfName</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfName
     */
    XbfName createXbfName(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFbasicType</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbasicType
     */
    XbfFbasicType createXbfFbasicType(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfKind</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfKind
     */
    XbfKind createXbfKind(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFarrayRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayRef
     */
    XbfFarrayRef createXbfFarrayRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarRef
     */
    XbfVarRef createXbfVarRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcharacterRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterRef
     */
    XbfFcharacterRef createXbfFcharacterRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfIndexRange</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfIndexRange
     */
    XbfIndexRange createXbfIndexRange(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLowerBound</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLowerBound
     */
    XbfLowerBound createXbfLowerBound(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUpperBound</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUpperBound
     */
    XbfUpperBound createXbfUpperBound(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfStep</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStep
     */
    XbfStep createXbfStep(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmemberRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmemberRef
     */
    XbfFmemberRef createXbfFmemberRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcoArrayRef
     */
    XbfFcoArrayRef createXbfFcoArrayRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfArrayIndex</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArrayIndex
     */
    XbfArrayIndex createXbfArrayIndex(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVar</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVar
     */
    XbfVar createXbfVar(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayConstructor
     */
    XbfFarrayConstructor createXbfFarrayConstructor(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoLoop</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoLoop
     */
    XbfFdoLoop createXbfFdoLoop(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfValue</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValue
     */
    XbfValue createXbfValue(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRepeatCount</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRepeatCount
     */
    XbfRepeatCount createXbfRepeatCount(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFintConstant</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFintConstant
     */
    XbfFintConstant createXbfFintConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFrealConstant</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrealConstant
     */
    XbfFrealConstant createXbfFrealConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterConstant
     */
    XbfFcharacterConstant createXbfFcharacterConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFlogicalConstant
     */
    XbfFlogicalConstant createXbfFlogicalConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcomplexConstant
     */
    XbfFcomplexConstant createXbfFcomplexConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructConstructor</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructConstructor
     */
    XbfFstructConstructor createXbfFstructConstructor(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFunctionCall</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFunctionCall
     */
    XbfFunctionCall createXbfFunctionCall(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfArguments</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArguments
     */
    XbfArguments createXbfArguments(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfNamedValue</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValue
     */
    XbfNamedValue createXbfNamedValue(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserUnaryExpr
     */
    XbfUserUnaryExpr createXbfUserUnaryExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserBinaryExpr
     */
    XbfUserBinaryExpr createXbfUserBinaryExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNotExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNotExpr
     */
    XbfLogNotExpr createXbfLogNotExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunction</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunction
     */
    XbfFfunction createXbfFfunction(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQExpr
     */
    XbfLogNEQExpr createXbfLogNEQExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogGTExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGTExpr
     */
    XbfLogGTExpr createXbfLogGTExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQVExpr
     */
    XbfLogNEQVExpr createXbfLogNEQVExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfPlusExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfPlusExpr
     */
    XbfPlusExpr createXbfPlusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfMinusExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMinusExpr
     */
    XbfMinusExpr createXbfMinusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfMulExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMulExpr
     */
    XbfMulExpr createXbfMulExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfDivExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDivExpr
     */
    XbfDivExpr createXbfDivExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpowerExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpowerExpr
     */
    XbfFpowerExpr createXbfFpowerExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFconcatExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFconcatExpr
     */
    XbfFconcatExpr createXbfFconcatExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogEQExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQExpr
     */
    XbfLogEQExpr createXbfLogEQExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogGEExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGEExpr
     */
    XbfLogGEExpr createXbfLogGEExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogLEExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLEExpr
     */
    XbfLogLEExpr createXbfLogLEExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogLTExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLTExpr
     */
    XbfLogLTExpr createXbfLogLTExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogAndExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogAndExpr
     */
    XbfLogAndExpr createXbfLogAndExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogOrExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogOrExpr
     */
    XbfLogOrExpr createXbfLogOrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQVExpr
     */
    XbfLogEQVExpr createXbfLogEQVExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUnaryMinusExpr
     */
    XbfUnaryMinusExpr createXbfUnaryMinusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfLen</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLen
     */
    XbfLen createXbfLen(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfCoShape</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCoShape
     */
    XbfCoShape createXbfCoShape(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructType</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructType
     */
    XbfFstructType createXbfFstructType(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfSymbols</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfSymbols
     */
    XbfSymbols createXbfSymbols(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfId</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfId
     */
    XbfId createXbfId(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalSymbols
     */
    XbfGlobalSymbols createXbfGlobalSymbols(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalDeclarations
     */
    XbfGlobalDeclarations createXbfGlobalDeclarations(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDefinition
     */
    XbfFfunctionDefinition createXbfFfunctionDefinition(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfDeclarations</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDeclarations
     */
    XbfDeclarations createXbfDeclarations(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarDecl
     */
    XbfVarDecl createXbfVarDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfExternDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExternDecl
     */
    XbfExternDecl createXbfExternDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFuseDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseDecl
     */
    XbfFuseDecl createXbfFuseDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRename</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRename
     */
    XbfRename createXbfRename(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseOnlyDecl
     */
    XbfFuseOnlyDecl createXbfFuseOnlyDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfRenamable</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRenamable
     */
    XbfRenamable createXbfRenamable(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinterfaceDecl
     */
    XbfFinterfaceDecl createXbfFinterfaceDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDecl
     */
    XbfFfunctionDecl createXbfFfunctionDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleProcedureDecl
     */
    XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnamelistDecl
     */
    XbfFnamelistDecl createXbfFnamelistDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfVarList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarList
     */
    XbfVarList createXbfVarList(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFequivalenceDecl
     */
    XbfFequivalenceDecl createXbfFequivalenceDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcommonDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcommonDecl
     */
    XbfFcommonDecl createXbfFcommonDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstructDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructDecl
     */
    XbfFstructDecl createXbfFstructDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFentryDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFentryDecl
     */
    XbfFentryDecl createXbfFentryDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdataDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdataDecl
     */
    XbfFdataDecl createXbfFdataDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfValueList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValueList
     */
    XbfValueList createXbfValueList(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpragmaStatement
     */
    XbfFpragmaStatement createXbfFpragmaStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfBody</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfBody
     */
    XbfBody createXbfBody(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfGotoStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGotoStatement
     */
    XbfGotoStatement createXbfGotoStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpauseStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpauseStatement
     */
    XbfFpauseStatement createXbfFpauseStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcycleStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcycleStatement
     */
    XbfFcycleStatement createXbfFcycleStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFreadStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreadStatement
     */
    XbfFreadStatement createXbfFreadStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfNamedValueList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValueList
     */
    XbfNamedValueList createXbfNamedValueList(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcloseStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcloseStatement
     */
    XbfFcloseStatement createXbfFcloseStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFopenStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFopenStatement
     */
    XbfFopenStatement createXbfFopenStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFassignStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFassignStatement
     */
    XbfFassignStatement createXbfFassignStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfExprStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExprStatement
     */
    XbfExprStatement createXbfExprStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpointerAssignStatement
     */
    XbfFpointerAssignStatement createXbfFpointerAssignStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFifStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFifStatement
     */
    XbfFifStatement createXbfFifStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfCondition</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCondition
     */
    XbfCondition createXbfCondition(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfThen</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfThen
     */
    XbfThen createXbfThen(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfElse</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfElse
     */
    XbfElse createXbfElse(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoStatement
     */
    XbfFdoStatement createXbfFdoStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoWhileStatement
     */
    XbfFdoWhileStatement createXbfFdoWhileStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfContinueStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfContinueStatement
     */
    XbfContinueStatement createXbfContinueStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFexitStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFexitStatement
     */
    XbfFexitStatement createXbfFexitStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFreturnStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreturnStatement
     */
    XbfFreturnStatement createXbfFreturnStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfStatementLabel</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStatementLabel
     */
    XbfStatementLabel createXbfStatementLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFselectCaseStatement
     */
    XbfFselectCaseStatement createXbfFselectCaseStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcaseLabel</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcaseLabel
     */
    XbfFcaseLabel createXbfFcaseLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFwhereStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwhereStatement
     */
    XbfFwhereStatement createXbfFwhereStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFstopStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstopStatement
     */
    XbfFstopStatement createXbfFstopStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFwriteStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwriteStatement
     */
    XbfFwriteStatement createXbfFwriteStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFprintStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFprintStatement
     */
    XbfFprintStatement createXbfFprintStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFrewindStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrewindStatement
     */
    XbfFrewindStatement createXbfFrewindStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFendFileStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFendFileStatement
     */
    XbfFendFileStatement createXbfFendFileStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbackspaceStatement
     */
    XbfFbackspaceStatement createXbfFbackspaceStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFinquireStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinquireStatement
     */
    XbfFinquireStatement createXbfFinquireStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFformatDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFformatDecl
     */
    XbfFformatDecl createXbfFformatDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFallocateStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFallocateStatement
     */
    XbfFallocateStatement createXbfFallocateStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfAlloc</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfAlloc
     */
    XbfAlloc createXbfAlloc(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdeallocateStatement
     */
    XbfFdeallocateStatement createXbfFdeallocateStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnullifyStatement
     */
    XbfFnullifyStatement createXbfFnullifyStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcontainsStatement
     */
    XbfFcontainsStatement createXbfFcontainsStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfText</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfText
     */
    XbfText createXbfText(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleDefinition
     */
    XbfFmoduleDefinition createXbfFmoduleDefinition(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFblockDataDefinition
     */
    XbfFblockDataDefinition createXbfFblockDataDefinition(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbfXcodeProgram</code>.
     *
     * @return XbfXcodeProgram
     */
    XbfXcodeProgram createXbfXcodeProgram();

    /**
     * Creates a <code>XbfTypeTable</code>.
     *
     * @return XbfTypeTable
     */
    XbfTypeTable createXbfTypeTable();

    /**
     * Creates a <code>XbfFfunctionType</code>.
     *
     * @return XbfFfunctionType
     */
    XbfFfunctionType createXbfFfunctionType();

    /**
     * Creates a <code>XbfParams</code>.
     *
     * @return XbfParams
     */
    XbfParams createXbfParams();

    /**
     * Creates a <code>XbfName</code>.
     *
     * @return XbfName
     */
    XbfName createXbfName();

    /**
     * Creates a <code>XbfFbasicType</code>.
     *
     * @return XbfFbasicType
     */
    XbfFbasicType createXbfFbasicType();

    /**
     * Creates a <code>XbfKind</code>.
     *
     * @return XbfKind
     */
    XbfKind createXbfKind();

    /**
     * Creates a <code>XbfFarrayRef</code>.
     *
     * @return XbfFarrayRef
     */
    XbfFarrayRef createXbfFarrayRef();

    /**
     * Creates a <code>XbfVarRef</code>.
     *
     * @return XbfVarRef
     */
    XbfVarRef createXbfVarRef();

    /**
     * Creates a <code>XbfFcharacterRef</code>.
     *
     * @return XbfFcharacterRef
     */
    XbfFcharacterRef createXbfFcharacterRef();

    /**
     * Creates a <code>XbfIndexRange</code>.
     *
     * @return XbfIndexRange
     */
    XbfIndexRange createXbfIndexRange();

    /**
     * Creates a <code>XbfLowerBound</code>.
     *
     * @return XbfLowerBound
     */
    XbfLowerBound createXbfLowerBound();

    /**
     * Creates a <code>XbfUpperBound</code>.
     *
     * @return XbfUpperBound
     */
    XbfUpperBound createXbfUpperBound();

    /**
     * Creates a <code>XbfStep</code>.
     *
     * @return XbfStep
     */
    XbfStep createXbfStep();

    /**
     * Creates a <code>XbfFmemberRef</code>.
     *
     * @return XbfFmemberRef
     */
    XbfFmemberRef createXbfFmemberRef();

    /**
     * Creates a <code>XbfFcoArrayRef</code>.
     *
     * @return XbfFcoArrayRef
     */
    XbfFcoArrayRef createXbfFcoArrayRef();

    /**
     * Creates a <code>XbfArrayIndex</code>.
     *
     * @return XbfArrayIndex
     */
    XbfArrayIndex createXbfArrayIndex();

    /**
     * Creates a <code>XbfVar</code>.
     *
     * @return XbfVar
     */
    XbfVar createXbfVar();

    /**
     * Creates a <code>XbfFarrayConstructor</code>.
     *
     * @return XbfFarrayConstructor
     */
    XbfFarrayConstructor createXbfFarrayConstructor();

    /**
     * Creates a <code>XbfFdoLoop</code>.
     *
     * @return XbfFdoLoop
     */
    XbfFdoLoop createXbfFdoLoop();

    /**
     * Creates a <code>XbfValue</code>.
     *
     * @return XbfValue
     */
    XbfValue createXbfValue();

    /**
     * Creates a <code>XbfRepeatCount</code>.
     *
     * @return XbfRepeatCount
     */
    XbfRepeatCount createXbfRepeatCount();

    /**
     * Creates a <code>XbfFintConstant</code>.
     *
     * @return XbfFintConstant
     */
    XbfFintConstant createXbfFintConstant();

    /**
     * Creates a <code>XbfFrealConstant</code>.
     *
     * @return XbfFrealConstant
     */
    XbfFrealConstant createXbfFrealConstant();

    /**
     * Creates a <code>XbfFcharacterConstant</code>.
     *
     * @return XbfFcharacterConstant
     */
    XbfFcharacterConstant createXbfFcharacterConstant();

    /**
     * Creates a <code>XbfFlogicalConstant</code>.
     *
     * @return XbfFlogicalConstant
     */
    XbfFlogicalConstant createXbfFlogicalConstant();

    /**
     * Creates a <code>XbfFcomplexConstant</code>.
     *
     * @return XbfFcomplexConstant
     */
    XbfFcomplexConstant createXbfFcomplexConstant();

    /**
     * Creates a <code>XbfFstructConstructor</code>.
     *
     * @return XbfFstructConstructor
     */
    XbfFstructConstructor createXbfFstructConstructor();

    /**
     * Creates a <code>XbfFunctionCall</code>.
     *
     * @return XbfFunctionCall
     */
    XbfFunctionCall createXbfFunctionCall();

    /**
     * Creates a <code>XbfArguments</code>.
     *
     * @return XbfArguments
     */
    XbfArguments createXbfArguments();

    /**
     * Creates a <code>XbfNamedValue</code>.
     *
     * @return XbfNamedValue
     */
    XbfNamedValue createXbfNamedValue();

    /**
     * Creates a <code>XbfUserUnaryExpr</code>.
     *
     * @return XbfUserUnaryExpr
     */
    XbfUserUnaryExpr createXbfUserUnaryExpr();

    /**
     * Creates a <code>XbfUserBinaryExpr</code>.
     *
     * @return XbfUserBinaryExpr
     */
    XbfUserBinaryExpr createXbfUserBinaryExpr();

    /**
     * Creates a <code>XbfLogNotExpr</code>.
     *
     * @return XbfLogNotExpr
     */
    XbfLogNotExpr createXbfLogNotExpr();

    /**
     * Creates a <code>XbfFfunction</code>.
     *
     * @return XbfFfunction
     */
    XbfFfunction createXbfFfunction();

    /**
     * Creates a <code>XbfLogNEQExpr</code>.
     *
     * @return XbfLogNEQExpr
     */
    XbfLogNEQExpr createXbfLogNEQExpr();

    /**
     * Creates a <code>XbfLogGTExpr</code>.
     *
     * @return XbfLogGTExpr
     */
    XbfLogGTExpr createXbfLogGTExpr();

    /**
     * Creates a <code>XbfLogNEQVExpr</code>.
     *
     * @return XbfLogNEQVExpr
     */
    XbfLogNEQVExpr createXbfLogNEQVExpr();

    /**
     * Creates a <code>XbfPlusExpr</code>.
     *
     * @return XbfPlusExpr
     */
    XbfPlusExpr createXbfPlusExpr();

    /**
     * Creates a <code>XbfMinusExpr</code>.
     *
     * @return XbfMinusExpr
     */
    XbfMinusExpr createXbfMinusExpr();

    /**
     * Creates a <code>XbfMulExpr</code>.
     *
     * @return XbfMulExpr
     */
    XbfMulExpr createXbfMulExpr();

    /**
     * Creates a <code>XbfDivExpr</code>.
     *
     * @return XbfDivExpr
     */
    XbfDivExpr createXbfDivExpr();

    /**
     * Creates a <code>XbfFpowerExpr</code>.
     *
     * @return XbfFpowerExpr
     */
    XbfFpowerExpr createXbfFpowerExpr();

    /**
     * Creates a <code>XbfFconcatExpr</code>.
     *
     * @return XbfFconcatExpr
     */
    XbfFconcatExpr createXbfFconcatExpr();

    /**
     * Creates a <code>XbfLogEQExpr</code>.
     *
     * @return XbfLogEQExpr
     */
    XbfLogEQExpr createXbfLogEQExpr();

    /**
     * Creates a <code>XbfLogGEExpr</code>.
     *
     * @return XbfLogGEExpr
     */
    XbfLogGEExpr createXbfLogGEExpr();

    /**
     * Creates a <code>XbfLogLEExpr</code>.
     *
     * @return XbfLogLEExpr
     */
    XbfLogLEExpr createXbfLogLEExpr();

    /**
     * Creates a <code>XbfLogLTExpr</code>.
     *
     * @return XbfLogLTExpr
     */
    XbfLogLTExpr createXbfLogLTExpr();

    /**
     * Creates a <code>XbfLogAndExpr</code>.
     *
     * @return XbfLogAndExpr
     */
    XbfLogAndExpr createXbfLogAndExpr();

    /**
     * Creates a <code>XbfLogOrExpr</code>.
     *
     * @return XbfLogOrExpr
     */
    XbfLogOrExpr createXbfLogOrExpr();

    /**
     * Creates a <code>XbfLogEQVExpr</code>.
     *
     * @return XbfLogEQVExpr
     */
    XbfLogEQVExpr createXbfLogEQVExpr();

    /**
     * Creates a <code>XbfUnaryMinusExpr</code>.
     *
     * @return XbfUnaryMinusExpr
     */
    XbfUnaryMinusExpr createXbfUnaryMinusExpr();

    /**
     * Creates a <code>XbfLen</code>.
     *
     * @return XbfLen
     */
    XbfLen createXbfLen();

    /**
     * Creates a <code>XbfCoShape</code>.
     *
     * @return XbfCoShape
     */
    XbfCoShape createXbfCoShape();

    /**
     * Creates a <code>XbfFstructType</code>.
     *
     * @return XbfFstructType
     */
    XbfFstructType createXbfFstructType();

    /**
     * Creates a <code>XbfSymbols</code>.
     *
     * @return XbfSymbols
     */
    XbfSymbols createXbfSymbols();

    /**
     * Creates a <code>XbfId</code>.
     *
     * @return XbfId
     */
    XbfId createXbfId();

    /**
     * Creates a <code>XbfGlobalSymbols</code>.
     *
     * @return XbfGlobalSymbols
     */
    XbfGlobalSymbols createXbfGlobalSymbols();

    /**
     * Creates a <code>XbfGlobalDeclarations</code>.
     *
     * @return XbfGlobalDeclarations
     */
    XbfGlobalDeclarations createXbfGlobalDeclarations();

    /**
     * Creates a <code>XbfFfunctionDefinition</code>.
     *
     * @return XbfFfunctionDefinition
     */
    XbfFfunctionDefinition createXbfFfunctionDefinition();

    /**
     * Creates a <code>XbfDeclarations</code>.
     *
     * @return XbfDeclarations
     */
    XbfDeclarations createXbfDeclarations();

    /**
     * Creates a <code>XbfVarDecl</code>.
     *
     * @return XbfVarDecl
     */
    XbfVarDecl createXbfVarDecl();

    /**
     * Creates a <code>XbfExternDecl</code>.
     *
     * @return XbfExternDecl
     */
    XbfExternDecl createXbfExternDecl();

    /**
     * Creates a <code>XbfFuseDecl</code>.
     *
     * @return XbfFuseDecl
     */
    XbfFuseDecl createXbfFuseDecl();

    /**
     * Creates a <code>XbfRename</code>.
     *
     * @return XbfRename
     */
    XbfRename createXbfRename();

    /**
     * Creates a <code>XbfFuseOnlyDecl</code>.
     *
     * @return XbfFuseOnlyDecl
     */
    XbfFuseOnlyDecl createXbfFuseOnlyDecl();

    /**
     * Creates a <code>XbfRenamable</code>.
     *
     * @return XbfRenamable
     */
    XbfRenamable createXbfRenamable();

    /**
     * Creates a <code>XbfFinterfaceDecl</code>.
     *
     * @return XbfFinterfaceDecl
     */
    XbfFinterfaceDecl createXbfFinterfaceDecl();

    /**
     * Creates a <code>XbfFfunctionDecl</code>.
     *
     * @return XbfFfunctionDecl
     */
    XbfFfunctionDecl createXbfFfunctionDecl();

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code>.
     *
     * @return XbfFmoduleProcedureDecl
     */
    XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl();

    /**
     * Creates a <code>XbfFnamelistDecl</code>.
     *
     * @return XbfFnamelistDecl
     */
    XbfFnamelistDecl createXbfFnamelistDecl();

    /**
     * Creates a <code>XbfVarList</code>.
     *
     * @return XbfVarList
     */
    XbfVarList createXbfVarList();

    /**
     * Creates a <code>XbfFequivalenceDecl</code>.
     *
     * @return XbfFequivalenceDecl
     */
    XbfFequivalenceDecl createXbfFequivalenceDecl();

    /**
     * Creates a <code>XbfFcommonDecl</code>.
     *
     * @return XbfFcommonDecl
     */
    XbfFcommonDecl createXbfFcommonDecl();

    /**
     * Creates a <code>XbfFstructDecl</code>.
     *
     * @return XbfFstructDecl
     */
    XbfFstructDecl createXbfFstructDecl();

    /**
     * Creates a <code>XbfFentryDecl</code>.
     *
     * @return XbfFentryDecl
     */
    XbfFentryDecl createXbfFentryDecl();

    /**
     * Creates a <code>XbfFdataDecl</code>.
     *
     * @return XbfFdataDecl
     */
    XbfFdataDecl createXbfFdataDecl();

    /**
     * Creates a <code>XbfValueList</code>.
     *
     * @return XbfValueList
     */
    XbfValueList createXbfValueList();

    /**
     * Creates a <code>XbfFpragmaStatement</code>.
     *
     * @return XbfFpragmaStatement
     */
    XbfFpragmaStatement createXbfFpragmaStatement();

    /**
     * Creates a <code>XbfBody</code>.
     *
     * @return XbfBody
     */
    XbfBody createXbfBody();

    /**
     * Creates a <code>XbfGotoStatement</code>.
     *
     * @return XbfGotoStatement
     */
    XbfGotoStatement createXbfGotoStatement();

    /**
     * Creates a <code>XbfFpauseStatement</code>.
     *
     * @return XbfFpauseStatement
     */
    XbfFpauseStatement createXbfFpauseStatement();

    /**
     * Creates a <code>XbfFcycleStatement</code>.
     *
     * @return XbfFcycleStatement
     */
    XbfFcycleStatement createXbfFcycleStatement();

    /**
     * Creates a <code>XbfFreadStatement</code>.
     *
     * @return XbfFreadStatement
     */
    XbfFreadStatement createXbfFreadStatement();

    /**
     * Creates a <code>XbfNamedValueList</code>.
     *
     * @return XbfNamedValueList
     */
    XbfNamedValueList createXbfNamedValueList();

    /**
     * Creates a <code>XbfFcloseStatement</code>.
     *
     * @return XbfFcloseStatement
     */
    XbfFcloseStatement createXbfFcloseStatement();

    /**
     * Creates a <code>XbfFopenStatement</code>.
     *
     * @return XbfFopenStatement
     */
    XbfFopenStatement createXbfFopenStatement();

    /**
     * Creates a <code>XbfFassignStatement</code>.
     *
     * @return XbfFassignStatement
     */
    XbfFassignStatement createXbfFassignStatement();

    /**
     * Creates a <code>XbfExprStatement</code>.
     *
     * @return XbfExprStatement
     */
    XbfExprStatement createXbfExprStatement();

    /**
     * Creates a <code>XbfFpointerAssignStatement</code>.
     *
     * @return XbfFpointerAssignStatement
     */
    XbfFpointerAssignStatement createXbfFpointerAssignStatement();

    /**
     * Creates a <code>XbfFifStatement</code>.
     *
     * @return XbfFifStatement
     */
    XbfFifStatement createXbfFifStatement();

    /**
     * Creates a <code>XbfCondition</code>.
     *
     * @return XbfCondition
     */
    XbfCondition createXbfCondition();

    /**
     * Creates a <code>XbfThen</code>.
     *
     * @return XbfThen
     */
    XbfThen createXbfThen();

    /**
     * Creates a <code>XbfElse</code>.
     *
     * @return XbfElse
     */
    XbfElse createXbfElse();

    /**
     * Creates a <code>XbfFdoStatement</code>.
     *
     * @return XbfFdoStatement
     */
    XbfFdoStatement createXbfFdoStatement();

    /**
     * Creates a <code>XbfFdoWhileStatement</code>.
     *
     * @return XbfFdoWhileStatement
     */
    XbfFdoWhileStatement createXbfFdoWhileStatement();

    /**
     * Creates a <code>XbfContinueStatement</code>.
     *
     * @return XbfContinueStatement
     */
    XbfContinueStatement createXbfContinueStatement();

    /**
     * Creates a <code>XbfFexitStatement</code>.
     *
     * @return XbfFexitStatement
     */
    XbfFexitStatement createXbfFexitStatement();

    /**
     * Creates a <code>XbfFreturnStatement</code>.
     *
     * @return XbfFreturnStatement
     */
    XbfFreturnStatement createXbfFreturnStatement();

    /**
     * Creates a <code>XbfStatementLabel</code>.
     *
     * @return XbfStatementLabel
     */
    XbfStatementLabel createXbfStatementLabel();

    /**
     * Creates a <code>XbfFselectCaseStatement</code>.
     *
     * @return XbfFselectCaseStatement
     */
    XbfFselectCaseStatement createXbfFselectCaseStatement();

    /**
     * Creates a <code>XbfFcaseLabel</code>.
     *
     * @return XbfFcaseLabel
     */
    XbfFcaseLabel createXbfFcaseLabel();

    /**
     * Creates a <code>XbfFwhereStatement</code>.
     *
     * @return XbfFwhereStatement
     */
    XbfFwhereStatement createXbfFwhereStatement();

    /**
     * Creates a <code>XbfFstopStatement</code>.
     *
     * @return XbfFstopStatement
     */
    XbfFstopStatement createXbfFstopStatement();

    /**
     * Creates a <code>XbfFwriteStatement</code>.
     *
     * @return XbfFwriteStatement
     */
    XbfFwriteStatement createXbfFwriteStatement();

    /**
     * Creates a <code>XbfFprintStatement</code>.
     *
     * @return XbfFprintStatement
     */
    XbfFprintStatement createXbfFprintStatement();

    /**
     * Creates a <code>XbfFrewindStatement</code>.
     *
     * @return XbfFrewindStatement
     */
    XbfFrewindStatement createXbfFrewindStatement();

    /**
     * Creates a <code>XbfFendFileStatement</code>.
     *
     * @return XbfFendFileStatement
     */
    XbfFendFileStatement createXbfFendFileStatement();

    /**
     * Creates a <code>XbfFbackspaceStatement</code>.
     *
     * @return XbfFbackspaceStatement
     */
    XbfFbackspaceStatement createXbfFbackspaceStatement();

    /**
     * Creates a <code>XbfFinquireStatement</code>.
     *
     * @return XbfFinquireStatement
     */
    XbfFinquireStatement createXbfFinquireStatement();

    /**
     * Creates a <code>XbfFformatDecl</code>.
     *
     * @return XbfFformatDecl
     */
    XbfFformatDecl createXbfFformatDecl();

    /**
     * Creates a <code>XbfFallocateStatement</code>.
     *
     * @return XbfFallocateStatement
     */
    XbfFallocateStatement createXbfFallocateStatement();

    /**
     * Creates a <code>XbfAlloc</code>.
     *
     * @return XbfAlloc
     */
    XbfAlloc createXbfAlloc();

    /**
     * Creates a <code>XbfFdeallocateStatement</code>.
     *
     * @return XbfFdeallocateStatement
     */
    XbfFdeallocateStatement createXbfFdeallocateStatement();

    /**
     * Creates a <code>XbfFnullifyStatement</code>.
     *
     * @return XbfFnullifyStatement
     */
    XbfFnullifyStatement createXbfFnullifyStatement();

    /**
     * Creates a <code>XbfFcontainsStatement</code>.
     *
     * @return XbfFcontainsStatement
     */
    XbfFcontainsStatement createXbfFcontainsStatement();

    /**
     * Creates a <code>XbfText</code>.
     *
     * @return XbfText
     */
    XbfText createXbfText();

    /**
     * Creates a <code>XbfFmoduleDefinition</code>.
     *
     * @return XbfFmoduleDefinition
     */
    XbfFmoduleDefinition createXbfFmoduleDefinition();

    /**
     * Creates a <code>XbfFblockDataDefinition</code>.
     *
     * @return XbfFblockDataDefinition
     */
    XbfFblockDataDefinition createXbfFblockDataDefinition();

    /**
     * Creates a <code>XbfXcodeProgram</code> by the XbfXcodeProgram <code>source</code>.
     *
     * @param source
     * @return XbfXcodeProgram
     */
    XbfXcodeProgram createXbfXcodeProgram(XbfXcodeProgram source);

    /**
     * Creates a <code>XbfTypeTable</code> by the XbfTypeTable <code>source</code>.
     *
     * @param source
     * @return XbfTypeTable
     */
    XbfTypeTable createXbfTypeTable(XbfTypeTable source);

    /**
     * Creates a <code>XbfFfunctionType</code> by the XbfFfunctionType <code>source</code>.
     *
     * @param source
     * @return XbfFfunctionType
     */
    XbfFfunctionType createXbfFfunctionType(XbfFfunctionType source);

    /**
     * Creates a <code>XbfParams</code> by the XbfParams <code>source</code>.
     *
     * @param source
     * @return XbfParams
     */
    XbfParams createXbfParams(XbfParams source);

    /**
     * Creates a <code>XbfName</code> by the XbfName <code>source</code>.
     *
     * @param source
     * @return XbfName
     */
    XbfName createXbfName(XbfName source);

    /**
     * Creates a <code>XbfFbasicType</code> by the XbfFbasicType <code>source</code>.
     *
     * @param source
     * @return XbfFbasicType
     */
    XbfFbasicType createXbfFbasicType(XbfFbasicType source);

    /**
     * Creates a <code>XbfKind</code> by the XbfKind <code>source</code>.
     *
     * @param source
     * @return XbfKind
     */
    XbfKind createXbfKind(XbfKind source);

    /**
     * Creates a <code>XbfFarrayRef</code> by the XbfFarrayRef <code>source</code>.
     *
     * @param source
     * @return XbfFarrayRef
     */
    XbfFarrayRef createXbfFarrayRef(XbfFarrayRef source);

    /**
     * Creates a <code>XbfVarRef</code> by the XbfVarRef <code>source</code>.
     *
     * @param source
     * @return XbfVarRef
     */
    XbfVarRef createXbfVarRef(XbfVarRef source);

    /**
     * Creates a <code>XbfFcharacterRef</code> by the XbfFcharacterRef <code>source</code>.
     *
     * @param source
     * @return XbfFcharacterRef
     */
    XbfFcharacterRef createXbfFcharacterRef(XbfFcharacterRef source);

    /**
     * Creates a <code>XbfIndexRange</code> by the XbfIndexRange <code>source</code>.
     *
     * @param source
     * @return XbfIndexRange
     */
    XbfIndexRange createXbfIndexRange(XbfIndexRange source);

    /**
     * Creates a <code>XbfLowerBound</code> by the XbfLowerBound <code>source</code>.
     *
     * @param source
     * @return XbfLowerBound
     */
    XbfLowerBound createXbfLowerBound(XbfLowerBound source);

    /**
     * Creates a <code>XbfUpperBound</code> by the XbfUpperBound <code>source</code>.
     *
     * @param source
     * @return XbfUpperBound
     */
    XbfUpperBound createXbfUpperBound(XbfUpperBound source);

    /**
     * Creates a <code>XbfStep</code> by the XbfStep <code>source</code>.
     *
     * @param source
     * @return XbfStep
     */
    XbfStep createXbfStep(XbfStep source);

    /**
     * Creates a <code>XbfFmemberRef</code> by the XbfFmemberRef <code>source</code>.
     *
     * @param source
     * @return XbfFmemberRef
     */
    XbfFmemberRef createXbfFmemberRef(XbfFmemberRef source);

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the XbfFcoArrayRef <code>source</code>.
     *
     * @param source
     * @return XbfFcoArrayRef
     */
    XbfFcoArrayRef createXbfFcoArrayRef(XbfFcoArrayRef source);

    /**
     * Creates a <code>XbfArrayIndex</code> by the XbfArrayIndex <code>source</code>.
     *
     * @param source
     * @return XbfArrayIndex
     */
    XbfArrayIndex createXbfArrayIndex(XbfArrayIndex source);

    /**
     * Creates a <code>XbfVar</code> by the XbfVar <code>source</code>.
     *
     * @param source
     * @return XbfVar
     */
    XbfVar createXbfVar(XbfVar source);

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the XbfFarrayConstructor <code>source</code>.
     *
     * @param source
     * @return XbfFarrayConstructor
     */
    XbfFarrayConstructor createXbfFarrayConstructor(XbfFarrayConstructor source);

    /**
     * Creates a <code>XbfFdoLoop</code> by the XbfFdoLoop <code>source</code>.
     *
     * @param source
     * @return XbfFdoLoop
     */
    XbfFdoLoop createXbfFdoLoop(XbfFdoLoop source);

    /**
     * Creates a <code>XbfValue</code> by the XbfValue <code>source</code>.
     *
     * @param source
     * @return XbfValue
     */
    XbfValue createXbfValue(XbfValue source);

    /**
     * Creates a <code>XbfRepeatCount</code> by the XbfRepeatCount <code>source</code>.
     *
     * @param source
     * @return XbfRepeatCount
     */
    XbfRepeatCount createXbfRepeatCount(XbfRepeatCount source);

    /**
     * Creates a <code>XbfFintConstant</code> by the XbfFintConstant <code>source</code>.
     *
     * @param source
     * @return XbfFintConstant
     */
    XbfFintConstant createXbfFintConstant(XbfFintConstant source);

    /**
     * Creates a <code>XbfFrealConstant</code> by the XbfFrealConstant <code>source</code>.
     *
     * @param source
     * @return XbfFrealConstant
     */
    XbfFrealConstant createXbfFrealConstant(XbfFrealConstant source);

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the XbfFcharacterConstant <code>source</code>.
     *
     * @param source
     * @return XbfFcharacterConstant
     */
    XbfFcharacterConstant createXbfFcharacterConstant(XbfFcharacterConstant source);

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the XbfFlogicalConstant <code>source</code>.
     *
     * @param source
     * @return XbfFlogicalConstant
     */
    XbfFlogicalConstant createXbfFlogicalConstant(XbfFlogicalConstant source);

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the XbfFcomplexConstant <code>source</code>.
     *
     * @param source
     * @return XbfFcomplexConstant
     */
    XbfFcomplexConstant createXbfFcomplexConstant(XbfFcomplexConstant source);

    /**
     * Creates a <code>XbfFstructConstructor</code> by the XbfFstructConstructor <code>source</code>.
     *
     * @param source
     * @return XbfFstructConstructor
     */
    XbfFstructConstructor createXbfFstructConstructor(XbfFstructConstructor source);

    /**
     * Creates a <code>XbfFunctionCall</code> by the XbfFunctionCall <code>source</code>.
     *
     * @param source
     * @return XbfFunctionCall
     */
    XbfFunctionCall createXbfFunctionCall(XbfFunctionCall source);

    /**
     * Creates a <code>XbfArguments</code> by the XbfArguments <code>source</code>.
     *
     * @param source
     * @return XbfArguments
     */
    XbfArguments createXbfArguments(XbfArguments source);

    /**
     * Creates a <code>XbfNamedValue</code> by the XbfNamedValue <code>source</code>.
     *
     * @param source
     * @return XbfNamedValue
     */
    XbfNamedValue createXbfNamedValue(XbfNamedValue source);

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the XbfUserUnaryExpr <code>source</code>.
     *
     * @param source
     * @return XbfUserUnaryExpr
     */
    XbfUserUnaryExpr createXbfUserUnaryExpr(XbfUserUnaryExpr source);

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the XbfUserBinaryExpr <code>source</code>.
     *
     * @param source
     * @return XbfUserBinaryExpr
     */
    XbfUserBinaryExpr createXbfUserBinaryExpr(XbfUserBinaryExpr source);

    /**
     * Creates a <code>XbfLogNotExpr</code> by the XbfLogNotExpr <code>source</code>.
     *
     * @param source
     * @return XbfLogNotExpr
     */
    XbfLogNotExpr createXbfLogNotExpr(XbfLogNotExpr source);

    /**
     * Creates a <code>XbfFfunction</code> by the XbfFfunction <code>source</code>.
     *
     * @param source
     * @return XbfFfunction
     */
    XbfFfunction createXbfFfunction(XbfFfunction source);

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the XbfLogNEQExpr <code>source</code>.
     *
     * @param source
     * @return XbfLogNEQExpr
     */
    XbfLogNEQExpr createXbfLogNEQExpr(XbfLogNEQExpr source);

    /**
     * Creates a <code>XbfLogGTExpr</code> by the XbfLogGTExpr <code>source</code>.
     *
     * @param source
     * @return XbfLogGTExpr
     */
    XbfLogGTExpr createXbfLogGTExpr(XbfLogGTExpr source);

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the XbfLogNEQVExpr <code>source</code>.
     *
     * @param source
     * @return XbfLogNEQVExpr
     */
    XbfLogNEQVExpr createXbfLogNEQVExpr(XbfLogNEQVExpr source);

    /**
     * Creates a <code>XbfPlusExpr</code> by the XbfPlusExpr <code>source</code>.
     *
     * @param source
     * @return XbfPlusExpr
     */
    XbfPlusExpr createXbfPlusExpr(XbfPlusExpr source);

    /**
     * Creates a <code>XbfMinusExpr</code> by the XbfMinusExpr <code>source</code>.
     *
     * @param source
     * @return XbfMinusExpr
     */
    XbfMinusExpr createXbfMinusExpr(XbfMinusExpr source);

    /**
     * Creates a <code>XbfMulExpr</code> by the XbfMulExpr <code>source</code>.
     *
     * @param source
     * @return XbfMulExpr
     */
    XbfMulExpr createXbfMulExpr(XbfMulExpr source);

    /**
     * Creates a <code>XbfDivExpr</code> by the XbfDivExpr <code>source</code>.
     *
     * @param source
     * @return XbfDivExpr
     */
    XbfDivExpr createXbfDivExpr(XbfDivExpr source);

    /**
     * Creates a <code>XbfFpowerExpr</code> by the XbfFpowerExpr <code>source</code>.
     *
     * @param source
     * @return XbfFpowerExpr
     */
    XbfFpowerExpr createXbfFpowerExpr(XbfFpowerExpr source);

    /**
     * Creates a <code>XbfFconcatExpr</code> by the XbfFconcatExpr <code>source</code>.
     *
     * @param source
     * @return XbfFconcatExpr
     */
    XbfFconcatExpr createXbfFconcatExpr(XbfFconcatExpr source);

    /**
     * Creates a <code>XbfLogEQExpr</code> by the XbfLogEQExpr <code>source</code>.
     *
     * @param source
     * @return XbfLogEQExpr
     */
    XbfLogEQExpr createXbfLogEQExpr(XbfLogEQExpr source);

    /**
     * Creates a <code>XbfLogGEExpr</code> by the XbfLogGEExpr <code>source</code>.
     *
     * @param source
     * @return XbfLogGEExpr
     */
    XbfLogGEExpr createXbfLogGEExpr(XbfLogGEExpr source);

    /**
     * Creates a <code>XbfLogLEExpr</code> by the XbfLogLEExpr <code>source</code>.
     *
     * @param source
     * @return XbfLogLEExpr
     */
    XbfLogLEExpr createXbfLogLEExpr(XbfLogLEExpr source);

    /**
     * Creates a <code>XbfLogLTExpr</code> by the XbfLogLTExpr <code>source</code>.
     *
     * @param source
     * @return XbfLogLTExpr
     */
    XbfLogLTExpr createXbfLogLTExpr(XbfLogLTExpr source);

    /**
     * Creates a <code>XbfLogAndExpr</code> by the XbfLogAndExpr <code>source</code>.
     *
     * @param source
     * @return XbfLogAndExpr
     */
    XbfLogAndExpr createXbfLogAndExpr(XbfLogAndExpr source);

    /**
     * Creates a <code>XbfLogOrExpr</code> by the XbfLogOrExpr <code>source</code>.
     *
     * @param source
     * @return XbfLogOrExpr
     */
    XbfLogOrExpr createXbfLogOrExpr(XbfLogOrExpr source);

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the XbfLogEQVExpr <code>source</code>.
     *
     * @param source
     * @return XbfLogEQVExpr
     */
    XbfLogEQVExpr createXbfLogEQVExpr(XbfLogEQVExpr source);

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the XbfUnaryMinusExpr <code>source</code>.
     *
     * @param source
     * @return XbfUnaryMinusExpr
     */
    XbfUnaryMinusExpr createXbfUnaryMinusExpr(XbfUnaryMinusExpr source);

    /**
     * Creates a <code>XbfLen</code> by the XbfLen <code>source</code>.
     *
     * @param source
     * @return XbfLen
     */
    XbfLen createXbfLen(XbfLen source);

    /**
     * Creates a <code>XbfCoShape</code> by the XbfCoShape <code>source</code>.
     *
     * @param source
     * @return XbfCoShape
     */
    XbfCoShape createXbfCoShape(XbfCoShape source);

    /**
     * Creates a <code>XbfFstructType</code> by the XbfFstructType <code>source</code>.
     *
     * @param source
     * @return XbfFstructType
     */
    XbfFstructType createXbfFstructType(XbfFstructType source);

    /**
     * Creates a <code>XbfSymbols</code> by the XbfSymbols <code>source</code>.
     *
     * @param source
     * @return XbfSymbols
     */
    XbfSymbols createXbfSymbols(XbfSymbols source);

    /**
     * Creates a <code>XbfId</code> by the XbfId <code>source</code>.
     *
     * @param source
     * @return XbfId
     */
    XbfId createXbfId(XbfId source);

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the XbfGlobalSymbols <code>source</code>.
     *
     * @param source
     * @return XbfGlobalSymbols
     */
    XbfGlobalSymbols createXbfGlobalSymbols(XbfGlobalSymbols source);

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the XbfGlobalDeclarations <code>source</code>.
     *
     * @param source
     * @return XbfGlobalDeclarations
     */
    XbfGlobalDeclarations createXbfGlobalDeclarations(XbfGlobalDeclarations source);

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the XbfFfunctionDefinition <code>source</code>.
     *
     * @param source
     * @return XbfFfunctionDefinition
     */
    XbfFfunctionDefinition createXbfFfunctionDefinition(XbfFfunctionDefinition source);

    /**
     * Creates a <code>XbfDeclarations</code> by the XbfDeclarations <code>source</code>.
     *
     * @param source
     * @return XbfDeclarations
     */
    XbfDeclarations createXbfDeclarations(XbfDeclarations source);

    /**
     * Creates a <code>XbfVarDecl</code> by the XbfVarDecl <code>source</code>.
     *
     * @param source
     * @return XbfVarDecl
     */
    XbfVarDecl createXbfVarDecl(XbfVarDecl source);

    /**
     * Creates a <code>XbfExternDecl</code> by the XbfExternDecl <code>source</code>.
     *
     * @param source
     * @return XbfExternDecl
     */
    XbfExternDecl createXbfExternDecl(XbfExternDecl source);

    /**
     * Creates a <code>XbfFuseDecl</code> by the XbfFuseDecl <code>source</code>.
     *
     * @param source
     * @return XbfFuseDecl
     */
    XbfFuseDecl createXbfFuseDecl(XbfFuseDecl source);

    /**
     * Creates a <code>XbfRename</code> by the XbfRename <code>source</code>.
     *
     * @param source
     * @return XbfRename
     */
    XbfRename createXbfRename(XbfRename source);

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the XbfFuseOnlyDecl <code>source</code>.
     *
     * @param source
     * @return XbfFuseOnlyDecl
     */
    XbfFuseOnlyDecl createXbfFuseOnlyDecl(XbfFuseOnlyDecl source);

    /**
     * Creates a <code>XbfRenamable</code> by the XbfRenamable <code>source</code>.
     *
     * @param source
     * @return XbfRenamable
     */
    XbfRenamable createXbfRenamable(XbfRenamable source);

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the XbfFinterfaceDecl <code>source</code>.
     *
     * @param source
     * @return XbfFinterfaceDecl
     */
    XbfFinterfaceDecl createXbfFinterfaceDecl(XbfFinterfaceDecl source);

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the XbfFfunctionDecl <code>source</code>.
     *
     * @param source
     * @return XbfFfunctionDecl
     */
    XbfFfunctionDecl createXbfFfunctionDecl(XbfFfunctionDecl source);

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the XbfFmoduleProcedureDecl <code>source</code>.
     *
     * @param source
     * @return XbfFmoduleProcedureDecl
     */
    XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(XbfFmoduleProcedureDecl source);

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the XbfFnamelistDecl <code>source</code>.
     *
     * @param source
     * @return XbfFnamelistDecl
     */
    XbfFnamelistDecl createXbfFnamelistDecl(XbfFnamelistDecl source);

    /**
     * Creates a <code>XbfVarList</code> by the XbfVarList <code>source</code>.
     *
     * @param source
     * @return XbfVarList
     */
    XbfVarList createXbfVarList(XbfVarList source);

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the XbfFequivalenceDecl <code>source</code>.
     *
     * @param source
     * @return XbfFequivalenceDecl
     */
    XbfFequivalenceDecl createXbfFequivalenceDecl(XbfFequivalenceDecl source);

    /**
     * Creates a <code>XbfFcommonDecl</code> by the XbfFcommonDecl <code>source</code>.
     *
     * @param source
     * @return XbfFcommonDecl
     */
    XbfFcommonDecl createXbfFcommonDecl(XbfFcommonDecl source);

    /**
     * Creates a <code>XbfFstructDecl</code> by the XbfFstructDecl <code>source</code>.
     *
     * @param source
     * @return XbfFstructDecl
     */
    XbfFstructDecl createXbfFstructDecl(XbfFstructDecl source);

    /**
     * Creates a <code>XbfFentryDecl</code> by the XbfFentryDecl <code>source</code>.
     *
     * @param source
     * @return XbfFentryDecl
     */
    XbfFentryDecl createXbfFentryDecl(XbfFentryDecl source);

    /**
     * Creates a <code>XbfFdataDecl</code> by the XbfFdataDecl <code>source</code>.
     *
     * @param source
     * @return XbfFdataDecl
     */
    XbfFdataDecl createXbfFdataDecl(XbfFdataDecl source);

    /**
     * Creates a <code>XbfValueList</code> by the XbfValueList <code>source</code>.
     *
     * @param source
     * @return XbfValueList
     */
    XbfValueList createXbfValueList(XbfValueList source);

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the XbfFpragmaStatement <code>source</code>.
     *
     * @param source
     * @return XbfFpragmaStatement
     */
    XbfFpragmaStatement createXbfFpragmaStatement(XbfFpragmaStatement source);

    /**
     * Creates a <code>XbfBody</code> by the XbfBody <code>source</code>.
     *
     * @param source
     * @return XbfBody
     */
    XbfBody createXbfBody(XbfBody source);

    /**
     * Creates a <code>XbfGotoStatement</code> by the XbfGotoStatement <code>source</code>.
     *
     * @param source
     * @return XbfGotoStatement
     */
    XbfGotoStatement createXbfGotoStatement(XbfGotoStatement source);

    /**
     * Creates a <code>XbfFpauseStatement</code> by the XbfFpauseStatement <code>source</code>.
     *
     * @param source
     * @return XbfFpauseStatement
     */
    XbfFpauseStatement createXbfFpauseStatement(XbfFpauseStatement source);

    /**
     * Creates a <code>XbfFcycleStatement</code> by the XbfFcycleStatement <code>source</code>.
     *
     * @param source
     * @return XbfFcycleStatement
     */
    XbfFcycleStatement createXbfFcycleStatement(XbfFcycleStatement source);

    /**
     * Creates a <code>XbfFreadStatement</code> by the XbfFreadStatement <code>source</code>.
     *
     * @param source
     * @return XbfFreadStatement
     */
    XbfFreadStatement createXbfFreadStatement(XbfFreadStatement source);

    /**
     * Creates a <code>XbfNamedValueList</code> by the XbfNamedValueList <code>source</code>.
     *
     * @param source
     * @return XbfNamedValueList
     */
    XbfNamedValueList createXbfNamedValueList(XbfNamedValueList source);

    /**
     * Creates a <code>XbfFcloseStatement</code> by the XbfFcloseStatement <code>source</code>.
     *
     * @param source
     * @return XbfFcloseStatement
     */
    XbfFcloseStatement createXbfFcloseStatement(XbfFcloseStatement source);

    /**
     * Creates a <code>XbfFopenStatement</code> by the XbfFopenStatement <code>source</code>.
     *
     * @param source
     * @return XbfFopenStatement
     */
    XbfFopenStatement createXbfFopenStatement(XbfFopenStatement source);

    /**
     * Creates a <code>XbfFassignStatement</code> by the XbfFassignStatement <code>source</code>.
     *
     * @param source
     * @return XbfFassignStatement
     */
    XbfFassignStatement createXbfFassignStatement(XbfFassignStatement source);

    /**
     * Creates a <code>XbfExprStatement</code> by the XbfExprStatement <code>source</code>.
     *
     * @param source
     * @return XbfExprStatement
     */
    XbfExprStatement createXbfExprStatement(XbfExprStatement source);

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the XbfFpointerAssignStatement <code>source</code>.
     *
     * @param source
     * @return XbfFpointerAssignStatement
     */
    XbfFpointerAssignStatement createXbfFpointerAssignStatement(XbfFpointerAssignStatement source);

    /**
     * Creates a <code>XbfFifStatement</code> by the XbfFifStatement <code>source</code>.
     *
     * @param source
     * @return XbfFifStatement
     */
    XbfFifStatement createXbfFifStatement(XbfFifStatement source);

    /**
     * Creates a <code>XbfCondition</code> by the XbfCondition <code>source</code>.
     *
     * @param source
     * @return XbfCondition
     */
    XbfCondition createXbfCondition(XbfCondition source);

    /**
     * Creates a <code>XbfThen</code> by the XbfThen <code>source</code>.
     *
     * @param source
     * @return XbfThen
     */
    XbfThen createXbfThen(XbfThen source);

    /**
     * Creates a <code>XbfElse</code> by the XbfElse <code>source</code>.
     *
     * @param source
     * @return XbfElse
     */
    XbfElse createXbfElse(XbfElse source);

    /**
     * Creates a <code>XbfFdoStatement</code> by the XbfFdoStatement <code>source</code>.
     *
     * @param source
     * @return XbfFdoStatement
     */
    XbfFdoStatement createXbfFdoStatement(XbfFdoStatement source);

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the XbfFdoWhileStatement <code>source</code>.
     *
     * @param source
     * @return XbfFdoWhileStatement
     */
    XbfFdoWhileStatement createXbfFdoWhileStatement(XbfFdoWhileStatement source);

    /**
     * Creates a <code>XbfContinueStatement</code> by the XbfContinueStatement <code>source</code>.
     *
     * @param source
     * @return XbfContinueStatement
     */
    XbfContinueStatement createXbfContinueStatement(XbfContinueStatement source);

    /**
     * Creates a <code>XbfFexitStatement</code> by the XbfFexitStatement <code>source</code>.
     *
     * @param source
     * @return XbfFexitStatement
     */
    XbfFexitStatement createXbfFexitStatement(XbfFexitStatement source);

    /**
     * Creates a <code>XbfFreturnStatement</code> by the XbfFreturnStatement <code>source</code>.
     *
     * @param source
     * @return XbfFreturnStatement
     */
    XbfFreturnStatement createXbfFreturnStatement(XbfFreturnStatement source);

    /**
     * Creates a <code>XbfStatementLabel</code> by the XbfStatementLabel <code>source</code>.
     *
     * @param source
     * @return XbfStatementLabel
     */
    XbfStatementLabel createXbfStatementLabel(XbfStatementLabel source);

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the XbfFselectCaseStatement <code>source</code>.
     *
     * @param source
     * @return XbfFselectCaseStatement
     */
    XbfFselectCaseStatement createXbfFselectCaseStatement(XbfFselectCaseStatement source);

    /**
     * Creates a <code>XbfFcaseLabel</code> by the XbfFcaseLabel <code>source</code>.
     *
     * @param source
     * @return XbfFcaseLabel
     */
    XbfFcaseLabel createXbfFcaseLabel(XbfFcaseLabel source);

    /**
     * Creates a <code>XbfFwhereStatement</code> by the XbfFwhereStatement <code>source</code>.
     *
     * @param source
     * @return XbfFwhereStatement
     */
    XbfFwhereStatement createXbfFwhereStatement(XbfFwhereStatement source);

    /**
     * Creates a <code>XbfFstopStatement</code> by the XbfFstopStatement <code>source</code>.
     *
     * @param source
     * @return XbfFstopStatement
     */
    XbfFstopStatement createXbfFstopStatement(XbfFstopStatement source);

    /**
     * Creates a <code>XbfFwriteStatement</code> by the XbfFwriteStatement <code>source</code>.
     *
     * @param source
     * @return XbfFwriteStatement
     */
    XbfFwriteStatement createXbfFwriteStatement(XbfFwriteStatement source);

    /**
     * Creates a <code>XbfFprintStatement</code> by the XbfFprintStatement <code>source</code>.
     *
     * @param source
     * @return XbfFprintStatement
     */
    XbfFprintStatement createXbfFprintStatement(XbfFprintStatement source);

    /**
     * Creates a <code>XbfFrewindStatement</code> by the XbfFrewindStatement <code>source</code>.
     *
     * @param source
     * @return XbfFrewindStatement
     */
    XbfFrewindStatement createXbfFrewindStatement(XbfFrewindStatement source);

    /**
     * Creates a <code>XbfFendFileStatement</code> by the XbfFendFileStatement <code>source</code>.
     *
     * @param source
     * @return XbfFendFileStatement
     */
    XbfFendFileStatement createXbfFendFileStatement(XbfFendFileStatement source);

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the XbfFbackspaceStatement <code>source</code>.
     *
     * @param source
     * @return XbfFbackspaceStatement
     */
    XbfFbackspaceStatement createXbfFbackspaceStatement(XbfFbackspaceStatement source);

    /**
     * Creates a <code>XbfFinquireStatement</code> by the XbfFinquireStatement <code>source</code>.
     *
     * @param source
     * @return XbfFinquireStatement
     */
    XbfFinquireStatement createXbfFinquireStatement(XbfFinquireStatement source);

    /**
     * Creates a <code>XbfFformatDecl</code> by the XbfFformatDecl <code>source</code>.
     *
     * @param source
     * @return XbfFformatDecl
     */
    XbfFformatDecl createXbfFformatDecl(XbfFformatDecl source);

    /**
     * Creates a <code>XbfFallocateStatement</code> by the XbfFallocateStatement <code>source</code>.
     *
     * @param source
     * @return XbfFallocateStatement
     */
    XbfFallocateStatement createXbfFallocateStatement(XbfFallocateStatement source);

    /**
     * Creates a <code>XbfAlloc</code> by the XbfAlloc <code>source</code>.
     *
     * @param source
     * @return XbfAlloc
     */
    XbfAlloc createXbfAlloc(XbfAlloc source);

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the XbfFdeallocateStatement <code>source</code>.
     *
     * @param source
     * @return XbfFdeallocateStatement
     */
    XbfFdeallocateStatement createXbfFdeallocateStatement(XbfFdeallocateStatement source);

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the XbfFnullifyStatement <code>source</code>.
     *
     * @param source
     * @return XbfFnullifyStatement
     */
    XbfFnullifyStatement createXbfFnullifyStatement(XbfFnullifyStatement source);

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the XbfFcontainsStatement <code>source</code>.
     *
     * @param source
     * @return XbfFcontainsStatement
     */
    XbfFcontainsStatement createXbfFcontainsStatement(XbfFcontainsStatement source);

    /**
     * Creates a <code>XbfText</code> by the XbfText <code>source</code>.
     *
     * @param source
     * @return XbfText
     */
    XbfText createXbfText(XbfText source);

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the XbfFmoduleDefinition <code>source</code>.
     *
     * @param source
     * @return XbfFmoduleDefinition
     */
    XbfFmoduleDefinition createXbfFmoduleDefinition(XbfFmoduleDefinition source);

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the XbfFblockDataDefinition <code>source</code>.
     *
     * @param source
     * @return XbfFblockDataDefinition
     */
    XbfFblockDataDefinition createXbfFblockDataDefinition(XbfFblockDataDefinition source);

    /**
     * Creates a <code>XbfXcodeProgram</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfXcodeProgram
     */
    XbfXcodeProgram createXbfXcodeProgram(Document doc);

    /**
     * Creates a <code>XbfTypeTable</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfTypeTable
     */
    XbfTypeTable createXbfTypeTable(Document doc);

    /**
     * Creates a <code>XbfFfunctionType</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFfunctionType
     */
    XbfFfunctionType createXbfFfunctionType(Document doc);

    /**
     * Creates a <code>XbfParams</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfParams
     */
    XbfParams createXbfParams(Document doc);

    /**
     * Creates a <code>XbfName</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfName
     */
    XbfName createXbfName(Document doc);

    /**
     * Creates a <code>XbfFbasicType</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFbasicType
     */
    XbfFbasicType createXbfFbasicType(Document doc);

    /**
     * Creates a <code>XbfKind</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfKind
     */
    XbfKind createXbfKind(Document doc);

    /**
     * Creates a <code>XbfFarrayRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFarrayRef
     */
    XbfFarrayRef createXbfFarrayRef(Document doc);

    /**
     * Creates a <code>XbfVarRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfVarRef
     */
    XbfVarRef createXbfVarRef(Document doc);

    /**
     * Creates a <code>XbfFcharacterRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFcharacterRef
     */
    XbfFcharacterRef createXbfFcharacterRef(Document doc);

    /**
     * Creates a <code>XbfIndexRange</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfIndexRange
     */
    XbfIndexRange createXbfIndexRange(Document doc);

    /**
     * Creates a <code>XbfLowerBound</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLowerBound
     */
    XbfLowerBound createXbfLowerBound(Document doc);

    /**
     * Creates a <code>XbfUpperBound</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfUpperBound
     */
    XbfUpperBound createXbfUpperBound(Document doc);

    /**
     * Creates a <code>XbfStep</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfStep
     */
    XbfStep createXbfStep(Document doc);

    /**
     * Creates a <code>XbfFmemberRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFmemberRef
     */
    XbfFmemberRef createXbfFmemberRef(Document doc);

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFcoArrayRef
     */
    XbfFcoArrayRef createXbfFcoArrayRef(Document doc);

    /**
     * Creates a <code>XbfArrayIndex</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfArrayIndex
     */
    XbfArrayIndex createXbfArrayIndex(Document doc);

    /**
     * Creates a <code>XbfVar</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfVar
     */
    XbfVar createXbfVar(Document doc);

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFarrayConstructor
     */
    XbfFarrayConstructor createXbfFarrayConstructor(Document doc);

    /**
     * Creates a <code>XbfFdoLoop</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFdoLoop
     */
    XbfFdoLoop createXbfFdoLoop(Document doc);

    /**
     * Creates a <code>XbfValue</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfValue
     */
    XbfValue createXbfValue(Document doc);

    /**
     * Creates a <code>XbfRepeatCount</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfRepeatCount
     */
    XbfRepeatCount createXbfRepeatCount(Document doc);

    /**
     * Creates a <code>XbfFintConstant</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFintConstant
     */
    XbfFintConstant createXbfFintConstant(Document doc);

    /**
     * Creates a <code>XbfFrealConstant</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFrealConstant
     */
    XbfFrealConstant createXbfFrealConstant(Document doc);

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFcharacterConstant
     */
    XbfFcharacterConstant createXbfFcharacterConstant(Document doc);

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFlogicalConstant
     */
    XbfFlogicalConstant createXbfFlogicalConstant(Document doc);

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFcomplexConstant
     */
    XbfFcomplexConstant createXbfFcomplexConstant(Document doc);

    /**
     * Creates a <code>XbfFstructConstructor</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFstructConstructor
     */
    XbfFstructConstructor createXbfFstructConstructor(Document doc);

    /**
     * Creates a <code>XbfFunctionCall</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFunctionCall
     */
    XbfFunctionCall createXbfFunctionCall(Document doc);

    /**
     * Creates a <code>XbfArguments</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfArguments
     */
    XbfArguments createXbfArguments(Document doc);

    /**
     * Creates a <code>XbfNamedValue</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfNamedValue
     */
    XbfNamedValue createXbfNamedValue(Document doc);

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfUserUnaryExpr
     */
    XbfUserUnaryExpr createXbfUserUnaryExpr(Document doc);

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfUserBinaryExpr
     */
    XbfUserBinaryExpr createXbfUserBinaryExpr(Document doc);

    /**
     * Creates a <code>XbfLogNotExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLogNotExpr
     */
    XbfLogNotExpr createXbfLogNotExpr(Document doc);

    /**
     * Creates a <code>XbfFfunction</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFfunction
     */
    XbfFfunction createXbfFfunction(Document doc);

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLogNEQExpr
     */
    XbfLogNEQExpr createXbfLogNEQExpr(Document doc);

    /**
     * Creates a <code>XbfLogGTExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLogGTExpr
     */
    XbfLogGTExpr createXbfLogGTExpr(Document doc);

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLogNEQVExpr
     */
    XbfLogNEQVExpr createXbfLogNEQVExpr(Document doc);

    /**
     * Creates a <code>XbfPlusExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfPlusExpr
     */
    XbfPlusExpr createXbfPlusExpr(Document doc);

    /**
     * Creates a <code>XbfMinusExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfMinusExpr
     */
    XbfMinusExpr createXbfMinusExpr(Document doc);

    /**
     * Creates a <code>XbfMulExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfMulExpr
     */
    XbfMulExpr createXbfMulExpr(Document doc);

    /**
     * Creates a <code>XbfDivExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfDivExpr
     */
    XbfDivExpr createXbfDivExpr(Document doc);

    /**
     * Creates a <code>XbfFpowerExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFpowerExpr
     */
    XbfFpowerExpr createXbfFpowerExpr(Document doc);

    /**
     * Creates a <code>XbfFconcatExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFconcatExpr
     */
    XbfFconcatExpr createXbfFconcatExpr(Document doc);

    /**
     * Creates a <code>XbfLogEQExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLogEQExpr
     */
    XbfLogEQExpr createXbfLogEQExpr(Document doc);

    /**
     * Creates a <code>XbfLogGEExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLogGEExpr
     */
    XbfLogGEExpr createXbfLogGEExpr(Document doc);

    /**
     * Creates a <code>XbfLogLEExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLogLEExpr
     */
    XbfLogLEExpr createXbfLogLEExpr(Document doc);

    /**
     * Creates a <code>XbfLogLTExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLogLTExpr
     */
    XbfLogLTExpr createXbfLogLTExpr(Document doc);

    /**
     * Creates a <code>XbfLogAndExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLogAndExpr
     */
    XbfLogAndExpr createXbfLogAndExpr(Document doc);

    /**
     * Creates a <code>XbfLogOrExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLogOrExpr
     */
    XbfLogOrExpr createXbfLogOrExpr(Document doc);

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLogEQVExpr
     */
    XbfLogEQVExpr createXbfLogEQVExpr(Document doc);

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfUnaryMinusExpr
     */
    XbfUnaryMinusExpr createXbfUnaryMinusExpr(Document doc);

    /**
     * Creates a <code>XbfLen</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfLen
     */
    XbfLen createXbfLen(Document doc);

    /**
     * Creates a <code>XbfCoShape</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfCoShape
     */
    XbfCoShape createXbfCoShape(Document doc);

    /**
     * Creates a <code>XbfFstructType</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFstructType
     */
    XbfFstructType createXbfFstructType(Document doc);

    /**
     * Creates a <code>XbfSymbols</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfSymbols
     */
    XbfSymbols createXbfSymbols(Document doc);

    /**
     * Creates a <code>XbfId</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfId
     */
    XbfId createXbfId(Document doc);

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfGlobalSymbols
     */
    XbfGlobalSymbols createXbfGlobalSymbols(Document doc);

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfGlobalDeclarations
     */
    XbfGlobalDeclarations createXbfGlobalDeclarations(Document doc);

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFfunctionDefinition
     */
    XbfFfunctionDefinition createXbfFfunctionDefinition(Document doc);

    /**
     * Creates a <code>XbfDeclarations</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfDeclarations
     */
    XbfDeclarations createXbfDeclarations(Document doc);

    /**
     * Creates a <code>XbfVarDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfVarDecl
     */
    XbfVarDecl createXbfVarDecl(Document doc);

    /**
     * Creates a <code>XbfExternDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfExternDecl
     */
    XbfExternDecl createXbfExternDecl(Document doc);

    /**
     * Creates a <code>XbfFuseDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFuseDecl
     */
    XbfFuseDecl createXbfFuseDecl(Document doc);

    /**
     * Creates a <code>XbfRename</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfRename
     */
    XbfRename createXbfRename(Document doc);

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFuseOnlyDecl
     */
    XbfFuseOnlyDecl createXbfFuseOnlyDecl(Document doc);

    /**
     * Creates a <code>XbfRenamable</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfRenamable
     */
    XbfRenamable createXbfRenamable(Document doc);

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFinterfaceDecl
     */
    XbfFinterfaceDecl createXbfFinterfaceDecl(Document doc);

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFfunctionDecl
     */
    XbfFfunctionDecl createXbfFfunctionDecl(Document doc);

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFmoduleProcedureDecl
     */
    XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(Document doc);

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFnamelistDecl
     */
    XbfFnamelistDecl createXbfFnamelistDecl(Document doc);

    /**
     * Creates a <code>XbfVarList</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfVarList
     */
    XbfVarList createXbfVarList(Document doc);

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFequivalenceDecl
     */
    XbfFequivalenceDecl createXbfFequivalenceDecl(Document doc);

    /**
     * Creates a <code>XbfFcommonDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFcommonDecl
     */
    XbfFcommonDecl createXbfFcommonDecl(Document doc);

    /**
     * Creates a <code>XbfFstructDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFstructDecl
     */
    XbfFstructDecl createXbfFstructDecl(Document doc);

    /**
     * Creates a <code>XbfFentryDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFentryDecl
     */
    XbfFentryDecl createXbfFentryDecl(Document doc);

    /**
     * Creates a <code>XbfFdataDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFdataDecl
     */
    XbfFdataDecl createXbfFdataDecl(Document doc);

    /**
     * Creates a <code>XbfValueList</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfValueList
     */
    XbfValueList createXbfValueList(Document doc);

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFpragmaStatement
     */
    XbfFpragmaStatement createXbfFpragmaStatement(Document doc);

    /**
     * Creates a <code>XbfBody</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfBody
     */
    XbfBody createXbfBody(Document doc);

    /**
     * Creates a <code>XbfGotoStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfGotoStatement
     */
    XbfGotoStatement createXbfGotoStatement(Document doc);

    /**
     * Creates a <code>XbfFpauseStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFpauseStatement
     */
    XbfFpauseStatement createXbfFpauseStatement(Document doc);

    /**
     * Creates a <code>XbfFcycleStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFcycleStatement
     */
    XbfFcycleStatement createXbfFcycleStatement(Document doc);

    /**
     * Creates a <code>XbfFreadStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFreadStatement
     */
    XbfFreadStatement createXbfFreadStatement(Document doc);

    /**
     * Creates a <code>XbfNamedValueList</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfNamedValueList
     */
    XbfNamedValueList createXbfNamedValueList(Document doc);

    /**
     * Creates a <code>XbfFcloseStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFcloseStatement
     */
    XbfFcloseStatement createXbfFcloseStatement(Document doc);

    /**
     * Creates a <code>XbfFopenStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFopenStatement
     */
    XbfFopenStatement createXbfFopenStatement(Document doc);

    /**
     * Creates a <code>XbfFassignStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFassignStatement
     */
    XbfFassignStatement createXbfFassignStatement(Document doc);

    /**
     * Creates a <code>XbfExprStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfExprStatement
     */
    XbfExprStatement createXbfExprStatement(Document doc);

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFpointerAssignStatement
     */
    XbfFpointerAssignStatement createXbfFpointerAssignStatement(Document doc);

    /**
     * Creates a <code>XbfFifStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFifStatement
     */
    XbfFifStatement createXbfFifStatement(Document doc);

    /**
     * Creates a <code>XbfCondition</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfCondition
     */
    XbfCondition createXbfCondition(Document doc);

    /**
     * Creates a <code>XbfThen</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfThen
     */
    XbfThen createXbfThen(Document doc);

    /**
     * Creates a <code>XbfElse</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfElse
     */
    XbfElse createXbfElse(Document doc);

    /**
     * Creates a <code>XbfFdoStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFdoStatement
     */
    XbfFdoStatement createXbfFdoStatement(Document doc);

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFdoWhileStatement
     */
    XbfFdoWhileStatement createXbfFdoWhileStatement(Document doc);

    /**
     * Creates a <code>XbfContinueStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfContinueStatement
     */
    XbfContinueStatement createXbfContinueStatement(Document doc);

    /**
     * Creates a <code>XbfFexitStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFexitStatement
     */
    XbfFexitStatement createXbfFexitStatement(Document doc);

    /**
     * Creates a <code>XbfFreturnStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFreturnStatement
     */
    XbfFreturnStatement createXbfFreturnStatement(Document doc);

    /**
     * Creates a <code>XbfStatementLabel</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfStatementLabel
     */
    XbfStatementLabel createXbfStatementLabel(Document doc);

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFselectCaseStatement
     */
    XbfFselectCaseStatement createXbfFselectCaseStatement(Document doc);

    /**
     * Creates a <code>XbfFcaseLabel</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFcaseLabel
     */
    XbfFcaseLabel createXbfFcaseLabel(Document doc);

    /**
     * Creates a <code>XbfFwhereStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFwhereStatement
     */
    XbfFwhereStatement createXbfFwhereStatement(Document doc);

    /**
     * Creates a <code>XbfFstopStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFstopStatement
     */
    XbfFstopStatement createXbfFstopStatement(Document doc);

    /**
     * Creates a <code>XbfFwriteStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFwriteStatement
     */
    XbfFwriteStatement createXbfFwriteStatement(Document doc);

    /**
     * Creates a <code>XbfFprintStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFprintStatement
     */
    XbfFprintStatement createXbfFprintStatement(Document doc);

    /**
     * Creates a <code>XbfFrewindStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFrewindStatement
     */
    XbfFrewindStatement createXbfFrewindStatement(Document doc);

    /**
     * Creates a <code>XbfFendFileStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFendFileStatement
     */
    XbfFendFileStatement createXbfFendFileStatement(Document doc);

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFbackspaceStatement
     */
    XbfFbackspaceStatement createXbfFbackspaceStatement(Document doc);

    /**
     * Creates a <code>XbfFinquireStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFinquireStatement
     */
    XbfFinquireStatement createXbfFinquireStatement(Document doc);

    /**
     * Creates a <code>XbfFformatDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFformatDecl
     */
    XbfFformatDecl createXbfFformatDecl(Document doc);

    /**
     * Creates a <code>XbfFallocateStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFallocateStatement
     */
    XbfFallocateStatement createXbfFallocateStatement(Document doc);

    /**
     * Creates a <code>XbfAlloc</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfAlloc
     */
    XbfAlloc createXbfAlloc(Document doc);

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFdeallocateStatement
     */
    XbfFdeallocateStatement createXbfFdeallocateStatement(Document doc);

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFnullifyStatement
     */
    XbfFnullifyStatement createXbfFnullifyStatement(Document doc);

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFcontainsStatement
     */
    XbfFcontainsStatement createXbfFcontainsStatement(Document doc);

    /**
     * Creates a <code>XbfText</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfText
     */
    XbfText createXbfText(Document doc);

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFmoduleDefinition
     */
    XbfFmoduleDefinition createXbfFmoduleDefinition(Document doc);

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbfFblockDataDefinition
     */
    XbfFblockDataDefinition createXbfFblockDataDefinition(Document doc);

    /**
     * Creates a <code>XbfXcodeProgram</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfXcodeProgram
     */
    XbfXcodeProgram createXbfXcodeProgram(Element element);

    /**
     * Creates a <code>XbfTypeTable</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfTypeTable
     */
    XbfTypeTable createXbfTypeTable(Element element);

    /**
     * Creates a <code>XbfFfunctionType</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFfunctionType
     */
    XbfFfunctionType createXbfFfunctionType(Element element);

    /**
     * Creates a <code>XbfParams</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfParams
     */
    XbfParams createXbfParams(Element element);

    /**
     * Creates a <code>XbfName</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfName
     */
    XbfName createXbfName(Element element);

    /**
     * Creates a <code>XbfFbasicType</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFbasicType
     */
    XbfFbasicType createXbfFbasicType(Element element);

    /**
     * Creates a <code>XbfKind</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfKind
     */
    XbfKind createXbfKind(Element element);

    /**
     * Creates a <code>XbfFarrayRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFarrayRef
     */
    XbfFarrayRef createXbfFarrayRef(Element element);

    /**
     * Creates a <code>XbfVarRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfVarRef
     */
    XbfVarRef createXbfVarRef(Element element);

    /**
     * Creates a <code>XbfFcharacterRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFcharacterRef
     */
    XbfFcharacterRef createXbfFcharacterRef(Element element);

    /**
     * Creates a <code>XbfIndexRange</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfIndexRange
     */
    XbfIndexRange createXbfIndexRange(Element element);

    /**
     * Creates a <code>XbfLowerBound</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLowerBound
     */
    XbfLowerBound createXbfLowerBound(Element element);

    /**
     * Creates a <code>XbfUpperBound</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfUpperBound
     */
    XbfUpperBound createXbfUpperBound(Element element);

    /**
     * Creates a <code>XbfStep</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfStep
     */
    XbfStep createXbfStep(Element element);

    /**
     * Creates a <code>XbfFmemberRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFmemberRef
     */
    XbfFmemberRef createXbfFmemberRef(Element element);

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFcoArrayRef
     */
    XbfFcoArrayRef createXbfFcoArrayRef(Element element);

    /**
     * Creates a <code>XbfArrayIndex</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfArrayIndex
     */
    XbfArrayIndex createXbfArrayIndex(Element element);

    /**
     * Creates a <code>XbfVar</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfVar
     */
    XbfVar createXbfVar(Element element);

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFarrayConstructor
     */
    XbfFarrayConstructor createXbfFarrayConstructor(Element element);

    /**
     * Creates a <code>XbfFdoLoop</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFdoLoop
     */
    XbfFdoLoop createXbfFdoLoop(Element element);

    /**
     * Creates a <code>XbfValue</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfValue
     */
    XbfValue createXbfValue(Element element);

    /**
     * Creates a <code>XbfRepeatCount</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfRepeatCount
     */
    XbfRepeatCount createXbfRepeatCount(Element element);

    /**
     * Creates a <code>XbfFintConstant</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFintConstant
     */
    XbfFintConstant createXbfFintConstant(Element element);

    /**
     * Creates a <code>XbfFrealConstant</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFrealConstant
     */
    XbfFrealConstant createXbfFrealConstant(Element element);

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFcharacterConstant
     */
    XbfFcharacterConstant createXbfFcharacterConstant(Element element);

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFlogicalConstant
     */
    XbfFlogicalConstant createXbfFlogicalConstant(Element element);

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFcomplexConstant
     */
    XbfFcomplexConstant createXbfFcomplexConstant(Element element);

    /**
     * Creates a <code>XbfFstructConstructor</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFstructConstructor
     */
    XbfFstructConstructor createXbfFstructConstructor(Element element);

    /**
     * Creates a <code>XbfFunctionCall</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFunctionCall
     */
    XbfFunctionCall createXbfFunctionCall(Element element);

    /**
     * Creates a <code>XbfArguments</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfArguments
     */
    XbfArguments createXbfArguments(Element element);

    /**
     * Creates a <code>XbfNamedValue</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfNamedValue
     */
    XbfNamedValue createXbfNamedValue(Element element);

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfUserUnaryExpr
     */
    XbfUserUnaryExpr createXbfUserUnaryExpr(Element element);

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfUserBinaryExpr
     */
    XbfUserBinaryExpr createXbfUserBinaryExpr(Element element);

    /**
     * Creates a <code>XbfLogNotExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLogNotExpr
     */
    XbfLogNotExpr createXbfLogNotExpr(Element element);

    /**
     * Creates a <code>XbfFfunction</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFfunction
     */
    XbfFfunction createXbfFfunction(Element element);

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLogNEQExpr
     */
    XbfLogNEQExpr createXbfLogNEQExpr(Element element);

    /**
     * Creates a <code>XbfLogGTExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLogGTExpr
     */
    XbfLogGTExpr createXbfLogGTExpr(Element element);

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLogNEQVExpr
     */
    XbfLogNEQVExpr createXbfLogNEQVExpr(Element element);

    /**
     * Creates a <code>XbfPlusExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfPlusExpr
     */
    XbfPlusExpr createXbfPlusExpr(Element element);

    /**
     * Creates a <code>XbfMinusExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfMinusExpr
     */
    XbfMinusExpr createXbfMinusExpr(Element element);

    /**
     * Creates a <code>XbfMulExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfMulExpr
     */
    XbfMulExpr createXbfMulExpr(Element element);

    /**
     * Creates a <code>XbfDivExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfDivExpr
     */
    XbfDivExpr createXbfDivExpr(Element element);

    /**
     * Creates a <code>XbfFpowerExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFpowerExpr
     */
    XbfFpowerExpr createXbfFpowerExpr(Element element);

    /**
     * Creates a <code>XbfFconcatExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFconcatExpr
     */
    XbfFconcatExpr createXbfFconcatExpr(Element element);

    /**
     * Creates a <code>XbfLogEQExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLogEQExpr
     */
    XbfLogEQExpr createXbfLogEQExpr(Element element);

    /**
     * Creates a <code>XbfLogGEExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLogGEExpr
     */
    XbfLogGEExpr createXbfLogGEExpr(Element element);

    /**
     * Creates a <code>XbfLogLEExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLogLEExpr
     */
    XbfLogLEExpr createXbfLogLEExpr(Element element);

    /**
     * Creates a <code>XbfLogLTExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLogLTExpr
     */
    XbfLogLTExpr createXbfLogLTExpr(Element element);

    /**
     * Creates a <code>XbfLogAndExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLogAndExpr
     */
    XbfLogAndExpr createXbfLogAndExpr(Element element);

    /**
     * Creates a <code>XbfLogOrExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLogOrExpr
     */
    XbfLogOrExpr createXbfLogOrExpr(Element element);

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLogEQVExpr
     */
    XbfLogEQVExpr createXbfLogEQVExpr(Element element);

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfUnaryMinusExpr
     */
    XbfUnaryMinusExpr createXbfUnaryMinusExpr(Element element);

    /**
     * Creates a <code>XbfLen</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfLen
     */
    XbfLen createXbfLen(Element element);

    /**
     * Creates a <code>XbfCoShape</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfCoShape
     */
    XbfCoShape createXbfCoShape(Element element);

    /**
     * Creates a <code>XbfFstructType</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFstructType
     */
    XbfFstructType createXbfFstructType(Element element);

    /**
     * Creates a <code>XbfSymbols</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfSymbols
     */
    XbfSymbols createXbfSymbols(Element element);

    /**
     * Creates a <code>XbfId</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfId
     */
    XbfId createXbfId(Element element);

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfGlobalSymbols
     */
    XbfGlobalSymbols createXbfGlobalSymbols(Element element);

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfGlobalDeclarations
     */
    XbfGlobalDeclarations createXbfGlobalDeclarations(Element element);

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFfunctionDefinition
     */
    XbfFfunctionDefinition createXbfFfunctionDefinition(Element element);

    /**
     * Creates a <code>XbfDeclarations</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfDeclarations
     */
    XbfDeclarations createXbfDeclarations(Element element);

    /**
     * Creates a <code>XbfVarDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfVarDecl
     */
    XbfVarDecl createXbfVarDecl(Element element);

    /**
     * Creates a <code>XbfExternDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfExternDecl
     */
    XbfExternDecl createXbfExternDecl(Element element);

    /**
     * Creates a <code>XbfFuseDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFuseDecl
     */
    XbfFuseDecl createXbfFuseDecl(Element element);

    /**
     * Creates a <code>XbfRename</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfRename
     */
    XbfRename createXbfRename(Element element);

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFuseOnlyDecl
     */
    XbfFuseOnlyDecl createXbfFuseOnlyDecl(Element element);

    /**
     * Creates a <code>XbfRenamable</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfRenamable
     */
    XbfRenamable createXbfRenamable(Element element);

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFinterfaceDecl
     */
    XbfFinterfaceDecl createXbfFinterfaceDecl(Element element);

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFfunctionDecl
     */
    XbfFfunctionDecl createXbfFfunctionDecl(Element element);

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFmoduleProcedureDecl
     */
    XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(Element element);

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFnamelistDecl
     */
    XbfFnamelistDecl createXbfFnamelistDecl(Element element);

    /**
     * Creates a <code>XbfVarList</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfVarList
     */
    XbfVarList createXbfVarList(Element element);

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFequivalenceDecl
     */
    XbfFequivalenceDecl createXbfFequivalenceDecl(Element element);

    /**
     * Creates a <code>XbfFcommonDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFcommonDecl
     */
    XbfFcommonDecl createXbfFcommonDecl(Element element);

    /**
     * Creates a <code>XbfFstructDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFstructDecl
     */
    XbfFstructDecl createXbfFstructDecl(Element element);

    /**
     * Creates a <code>XbfFentryDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFentryDecl
     */
    XbfFentryDecl createXbfFentryDecl(Element element);

    /**
     * Creates a <code>XbfFdataDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFdataDecl
     */
    XbfFdataDecl createXbfFdataDecl(Element element);

    /**
     * Creates a <code>XbfValueList</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfValueList
     */
    XbfValueList createXbfValueList(Element element);

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFpragmaStatement
     */
    XbfFpragmaStatement createXbfFpragmaStatement(Element element);

    /**
     * Creates a <code>XbfBody</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfBody
     */
    XbfBody createXbfBody(Element element);

    /**
     * Creates a <code>XbfGotoStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfGotoStatement
     */
    XbfGotoStatement createXbfGotoStatement(Element element);

    /**
     * Creates a <code>XbfFpauseStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFpauseStatement
     */
    XbfFpauseStatement createXbfFpauseStatement(Element element);

    /**
     * Creates a <code>XbfFcycleStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFcycleStatement
     */
    XbfFcycleStatement createXbfFcycleStatement(Element element);

    /**
     * Creates a <code>XbfFreadStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFreadStatement
     */
    XbfFreadStatement createXbfFreadStatement(Element element);

    /**
     * Creates a <code>XbfNamedValueList</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfNamedValueList
     */
    XbfNamedValueList createXbfNamedValueList(Element element);

    /**
     * Creates a <code>XbfFcloseStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFcloseStatement
     */
    XbfFcloseStatement createXbfFcloseStatement(Element element);

    /**
     * Creates a <code>XbfFopenStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFopenStatement
     */
    XbfFopenStatement createXbfFopenStatement(Element element);

    /**
     * Creates a <code>XbfFassignStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFassignStatement
     */
    XbfFassignStatement createXbfFassignStatement(Element element);

    /**
     * Creates a <code>XbfExprStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfExprStatement
     */
    XbfExprStatement createXbfExprStatement(Element element);

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFpointerAssignStatement
     */
    XbfFpointerAssignStatement createXbfFpointerAssignStatement(Element element);

    /**
     * Creates a <code>XbfFifStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFifStatement
     */
    XbfFifStatement createXbfFifStatement(Element element);

    /**
     * Creates a <code>XbfCondition</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfCondition
     */
    XbfCondition createXbfCondition(Element element);

    /**
     * Creates a <code>XbfThen</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfThen
     */
    XbfThen createXbfThen(Element element);

    /**
     * Creates a <code>XbfElse</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfElse
     */
    XbfElse createXbfElse(Element element);

    /**
     * Creates a <code>XbfFdoStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFdoStatement
     */
    XbfFdoStatement createXbfFdoStatement(Element element);

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFdoWhileStatement
     */
    XbfFdoWhileStatement createXbfFdoWhileStatement(Element element);

    /**
     * Creates a <code>XbfContinueStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfContinueStatement
     */
    XbfContinueStatement createXbfContinueStatement(Element element);

    /**
     * Creates a <code>XbfFexitStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFexitStatement
     */
    XbfFexitStatement createXbfFexitStatement(Element element);

    /**
     * Creates a <code>XbfFreturnStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFreturnStatement
     */
    XbfFreturnStatement createXbfFreturnStatement(Element element);

    /**
     * Creates a <code>XbfStatementLabel</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfStatementLabel
     */
    XbfStatementLabel createXbfStatementLabel(Element element);

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFselectCaseStatement
     */
    XbfFselectCaseStatement createXbfFselectCaseStatement(Element element);

    /**
     * Creates a <code>XbfFcaseLabel</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFcaseLabel
     */
    XbfFcaseLabel createXbfFcaseLabel(Element element);

    /**
     * Creates a <code>XbfFwhereStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFwhereStatement
     */
    XbfFwhereStatement createXbfFwhereStatement(Element element);

    /**
     * Creates a <code>XbfFstopStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFstopStatement
     */
    XbfFstopStatement createXbfFstopStatement(Element element);

    /**
     * Creates a <code>XbfFwriteStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFwriteStatement
     */
    XbfFwriteStatement createXbfFwriteStatement(Element element);

    /**
     * Creates a <code>XbfFprintStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFprintStatement
     */
    XbfFprintStatement createXbfFprintStatement(Element element);

    /**
     * Creates a <code>XbfFrewindStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFrewindStatement
     */
    XbfFrewindStatement createXbfFrewindStatement(Element element);

    /**
     * Creates a <code>XbfFendFileStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFendFileStatement
     */
    XbfFendFileStatement createXbfFendFileStatement(Element element);

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFbackspaceStatement
     */
    XbfFbackspaceStatement createXbfFbackspaceStatement(Element element);

    /**
     * Creates a <code>XbfFinquireStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFinquireStatement
     */
    XbfFinquireStatement createXbfFinquireStatement(Element element);

    /**
     * Creates a <code>XbfFformatDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFformatDecl
     */
    XbfFformatDecl createXbfFformatDecl(Element element);

    /**
     * Creates a <code>XbfFallocateStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFallocateStatement
     */
    XbfFallocateStatement createXbfFallocateStatement(Element element);

    /**
     * Creates a <code>XbfAlloc</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfAlloc
     */
    XbfAlloc createXbfAlloc(Element element);

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFdeallocateStatement
     */
    XbfFdeallocateStatement createXbfFdeallocateStatement(Element element);

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFnullifyStatement
     */
    XbfFnullifyStatement createXbfFnullifyStatement(Element element);

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFcontainsStatement
     */
    XbfFcontainsStatement createXbfFcontainsStatement(Element element);

    /**
     * Creates a <code>XbfText</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfText
     */
    XbfText createXbfText(Element element);

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFmoduleDefinition
     */
    XbfFmoduleDefinition createXbfFmoduleDefinition(Element element);

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbfFblockDataDefinition
     */
    XbfFblockDataDefinition createXbfFblockDataDefinition(Element element);

    /**
     * Creates a <code>XbfXcodeProgram</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfXcodeProgram
     */
    XbfXcodeProgram createXbfXcodeProgram(RStack stack);

    /**
     * Creates a <code>XbfTypeTable</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfTypeTable
     */
    XbfTypeTable createXbfTypeTable(RStack stack);

    /**
     * Creates a <code>XbfFfunctionType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFfunctionType
     */
    XbfFfunctionType createXbfFfunctionType(RStack stack);

    /**
     * Creates a <code>XbfParams</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfParams
     */
    XbfParams createXbfParams(RStack stack);

    /**
     * Creates a <code>XbfName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfName
     */
    XbfName createXbfName(RStack stack);

    /**
     * Creates a <code>XbfFbasicType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFbasicType
     */
    XbfFbasicType createXbfFbasicType(RStack stack);

    /**
     * Creates a <code>XbfKind</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfKind
     */
    XbfKind createXbfKind(RStack stack);

    /**
     * Creates a <code>XbfFarrayRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFarrayRef
     */
    XbfFarrayRef createXbfFarrayRef(RStack stack);

    /**
     * Creates a <code>XbfVarRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfVarRef
     */
    XbfVarRef createXbfVarRef(RStack stack);

    /**
     * Creates a <code>XbfFcharacterRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFcharacterRef
     */
    XbfFcharacterRef createXbfFcharacterRef(RStack stack);

    /**
     * Creates a <code>XbfIndexRange</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfIndexRange
     */
    XbfIndexRange createXbfIndexRange(RStack stack);

    /**
     * Creates a <code>XbfLowerBound</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLowerBound
     */
    XbfLowerBound createXbfLowerBound(RStack stack);

    /**
     * Creates a <code>XbfUpperBound</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfUpperBound
     */
    XbfUpperBound createXbfUpperBound(RStack stack);

    /**
     * Creates a <code>XbfStep</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfStep
     */
    XbfStep createXbfStep(RStack stack);

    /**
     * Creates a <code>XbfFmemberRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFmemberRef
     */
    XbfFmemberRef createXbfFmemberRef(RStack stack);

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFcoArrayRef
     */
    XbfFcoArrayRef createXbfFcoArrayRef(RStack stack);

    /**
     * Creates a <code>XbfArrayIndex</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfArrayIndex
     */
    XbfArrayIndex createXbfArrayIndex(RStack stack);

    /**
     * Creates a <code>XbfVar</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfVar
     */
    XbfVar createXbfVar(RStack stack);

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFarrayConstructor
     */
    XbfFarrayConstructor createXbfFarrayConstructor(RStack stack);

    /**
     * Creates a <code>XbfFdoLoop</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFdoLoop
     */
    XbfFdoLoop createXbfFdoLoop(RStack stack);

    /**
     * Creates a <code>XbfValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfValue
     */
    XbfValue createXbfValue(RStack stack);

    /**
     * Creates a <code>XbfRepeatCount</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfRepeatCount
     */
    XbfRepeatCount createXbfRepeatCount(RStack stack);

    /**
     * Creates a <code>XbfFintConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFintConstant
     */
    XbfFintConstant createXbfFintConstant(RStack stack);

    /**
     * Creates a <code>XbfFrealConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFrealConstant
     */
    XbfFrealConstant createXbfFrealConstant(RStack stack);

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFcharacterConstant
     */
    XbfFcharacterConstant createXbfFcharacterConstant(RStack stack);

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFlogicalConstant
     */
    XbfFlogicalConstant createXbfFlogicalConstant(RStack stack);

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFcomplexConstant
     */
    XbfFcomplexConstant createXbfFcomplexConstant(RStack stack);

    /**
     * Creates a <code>XbfFstructConstructor</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFstructConstructor
     */
    XbfFstructConstructor createXbfFstructConstructor(RStack stack);

    /**
     * Creates a <code>XbfFunctionCall</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFunctionCall
     */
    XbfFunctionCall createXbfFunctionCall(RStack stack);

    /**
     * Creates a <code>XbfArguments</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfArguments
     */
    XbfArguments createXbfArguments(RStack stack);

    /**
     * Creates a <code>XbfNamedValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfNamedValue
     */
    XbfNamedValue createXbfNamedValue(RStack stack);

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfUserUnaryExpr
     */
    XbfUserUnaryExpr createXbfUserUnaryExpr(RStack stack);

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfUserBinaryExpr
     */
    XbfUserBinaryExpr createXbfUserBinaryExpr(RStack stack);

    /**
     * Creates a <code>XbfLogNotExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLogNotExpr
     */
    XbfLogNotExpr createXbfLogNotExpr(RStack stack);

    /**
     * Creates a <code>XbfFfunction</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFfunction
     */
    XbfFfunction createXbfFfunction(RStack stack);

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLogNEQExpr
     */
    XbfLogNEQExpr createXbfLogNEQExpr(RStack stack);

    /**
     * Creates a <code>XbfLogGTExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLogGTExpr
     */
    XbfLogGTExpr createXbfLogGTExpr(RStack stack);

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLogNEQVExpr
     */
    XbfLogNEQVExpr createXbfLogNEQVExpr(RStack stack);

    /**
     * Creates a <code>XbfPlusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfPlusExpr
     */
    XbfPlusExpr createXbfPlusExpr(RStack stack);

    /**
     * Creates a <code>XbfMinusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfMinusExpr
     */
    XbfMinusExpr createXbfMinusExpr(RStack stack);

    /**
     * Creates a <code>XbfMulExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfMulExpr
     */
    XbfMulExpr createXbfMulExpr(RStack stack);

    /**
     * Creates a <code>XbfDivExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfDivExpr
     */
    XbfDivExpr createXbfDivExpr(RStack stack);

    /**
     * Creates a <code>XbfFpowerExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFpowerExpr
     */
    XbfFpowerExpr createXbfFpowerExpr(RStack stack);

    /**
     * Creates a <code>XbfFconcatExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFconcatExpr
     */
    XbfFconcatExpr createXbfFconcatExpr(RStack stack);

    /**
     * Creates a <code>XbfLogEQExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLogEQExpr
     */
    XbfLogEQExpr createXbfLogEQExpr(RStack stack);

    /**
     * Creates a <code>XbfLogGEExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLogGEExpr
     */
    XbfLogGEExpr createXbfLogGEExpr(RStack stack);

    /**
     * Creates a <code>XbfLogLEExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLogLEExpr
     */
    XbfLogLEExpr createXbfLogLEExpr(RStack stack);

    /**
     * Creates a <code>XbfLogLTExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLogLTExpr
     */
    XbfLogLTExpr createXbfLogLTExpr(RStack stack);

    /**
     * Creates a <code>XbfLogAndExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLogAndExpr
     */
    XbfLogAndExpr createXbfLogAndExpr(RStack stack);

    /**
     * Creates a <code>XbfLogOrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLogOrExpr
     */
    XbfLogOrExpr createXbfLogOrExpr(RStack stack);

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLogEQVExpr
     */
    XbfLogEQVExpr createXbfLogEQVExpr(RStack stack);

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfUnaryMinusExpr
     */
    XbfUnaryMinusExpr createXbfUnaryMinusExpr(RStack stack);

    /**
     * Creates a <code>XbfLen</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfLen
     */
    XbfLen createXbfLen(RStack stack);

    /**
     * Creates a <code>XbfCoShape</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfCoShape
     */
    XbfCoShape createXbfCoShape(RStack stack);

    /**
     * Creates a <code>XbfFstructType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFstructType
     */
    XbfFstructType createXbfFstructType(RStack stack);

    /**
     * Creates a <code>XbfSymbols</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfSymbols
     */
    XbfSymbols createXbfSymbols(RStack stack);

    /**
     * Creates a <code>XbfId</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfId
     */
    XbfId createXbfId(RStack stack);

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfGlobalSymbols
     */
    XbfGlobalSymbols createXbfGlobalSymbols(RStack stack);

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfGlobalDeclarations
     */
    XbfGlobalDeclarations createXbfGlobalDeclarations(RStack stack);

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFfunctionDefinition
     */
    XbfFfunctionDefinition createXbfFfunctionDefinition(RStack stack);

    /**
     * Creates a <code>XbfDeclarations</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfDeclarations
     */
    XbfDeclarations createXbfDeclarations(RStack stack);

    /**
     * Creates a <code>XbfVarDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfVarDecl
     */
    XbfVarDecl createXbfVarDecl(RStack stack);

    /**
     * Creates a <code>XbfExternDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfExternDecl
     */
    XbfExternDecl createXbfExternDecl(RStack stack);

    /**
     * Creates a <code>XbfFuseDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFuseDecl
     */
    XbfFuseDecl createXbfFuseDecl(RStack stack);

    /**
     * Creates a <code>XbfRename</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfRename
     */
    XbfRename createXbfRename(RStack stack);

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFuseOnlyDecl
     */
    XbfFuseOnlyDecl createXbfFuseOnlyDecl(RStack stack);

    /**
     * Creates a <code>XbfRenamable</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfRenamable
     */
    XbfRenamable createXbfRenamable(RStack stack);

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFinterfaceDecl
     */
    XbfFinterfaceDecl createXbfFinterfaceDecl(RStack stack);

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFfunctionDecl
     */
    XbfFfunctionDecl createXbfFfunctionDecl(RStack stack);

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFmoduleProcedureDecl
     */
    XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(RStack stack);

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFnamelistDecl
     */
    XbfFnamelistDecl createXbfFnamelistDecl(RStack stack);

    /**
     * Creates a <code>XbfVarList</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfVarList
     */
    XbfVarList createXbfVarList(RStack stack);

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFequivalenceDecl
     */
    XbfFequivalenceDecl createXbfFequivalenceDecl(RStack stack);

    /**
     * Creates a <code>XbfFcommonDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFcommonDecl
     */
    XbfFcommonDecl createXbfFcommonDecl(RStack stack);

    /**
     * Creates a <code>XbfFstructDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFstructDecl
     */
    XbfFstructDecl createXbfFstructDecl(RStack stack);

    /**
     * Creates a <code>XbfFentryDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFentryDecl
     */
    XbfFentryDecl createXbfFentryDecl(RStack stack);

    /**
     * Creates a <code>XbfFdataDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFdataDecl
     */
    XbfFdataDecl createXbfFdataDecl(RStack stack);

    /**
     * Creates a <code>XbfValueList</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfValueList
     */
    XbfValueList createXbfValueList(RStack stack);

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFpragmaStatement
     */
    XbfFpragmaStatement createXbfFpragmaStatement(RStack stack);

    /**
     * Creates a <code>XbfBody</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfBody
     */
    XbfBody createXbfBody(RStack stack);

    /**
     * Creates a <code>XbfGotoStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfGotoStatement
     */
    XbfGotoStatement createXbfGotoStatement(RStack stack);

    /**
     * Creates a <code>XbfFpauseStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFpauseStatement
     */
    XbfFpauseStatement createXbfFpauseStatement(RStack stack);

    /**
     * Creates a <code>XbfFcycleStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFcycleStatement
     */
    XbfFcycleStatement createXbfFcycleStatement(RStack stack);

    /**
     * Creates a <code>XbfFreadStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFreadStatement
     */
    XbfFreadStatement createXbfFreadStatement(RStack stack);

    /**
     * Creates a <code>XbfNamedValueList</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfNamedValueList
     */
    XbfNamedValueList createXbfNamedValueList(RStack stack);

    /**
     * Creates a <code>XbfFcloseStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFcloseStatement
     */
    XbfFcloseStatement createXbfFcloseStatement(RStack stack);

    /**
     * Creates a <code>XbfFopenStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFopenStatement
     */
    XbfFopenStatement createXbfFopenStatement(RStack stack);

    /**
     * Creates a <code>XbfFassignStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFassignStatement
     */
    XbfFassignStatement createXbfFassignStatement(RStack stack);

    /**
     * Creates a <code>XbfExprStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfExprStatement
     */
    XbfExprStatement createXbfExprStatement(RStack stack);

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFpointerAssignStatement
     */
    XbfFpointerAssignStatement createXbfFpointerAssignStatement(RStack stack);

    /**
     * Creates a <code>XbfFifStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFifStatement
     */
    XbfFifStatement createXbfFifStatement(RStack stack);

    /**
     * Creates a <code>XbfCondition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfCondition
     */
    XbfCondition createXbfCondition(RStack stack);

    /**
     * Creates a <code>XbfThen</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfThen
     */
    XbfThen createXbfThen(RStack stack);

    /**
     * Creates a <code>XbfElse</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfElse
     */
    XbfElse createXbfElse(RStack stack);

    /**
     * Creates a <code>XbfFdoStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFdoStatement
     */
    XbfFdoStatement createXbfFdoStatement(RStack stack);

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFdoWhileStatement
     */
    XbfFdoWhileStatement createXbfFdoWhileStatement(RStack stack);

    /**
     * Creates a <code>XbfContinueStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfContinueStatement
     */
    XbfContinueStatement createXbfContinueStatement(RStack stack);

    /**
     * Creates a <code>XbfFexitStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFexitStatement
     */
    XbfFexitStatement createXbfFexitStatement(RStack stack);

    /**
     * Creates a <code>XbfFreturnStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFreturnStatement
     */
    XbfFreturnStatement createXbfFreturnStatement(RStack stack);

    /**
     * Creates a <code>XbfStatementLabel</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfStatementLabel
     */
    XbfStatementLabel createXbfStatementLabel(RStack stack);

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFselectCaseStatement
     */
    XbfFselectCaseStatement createXbfFselectCaseStatement(RStack stack);

    /**
     * Creates a <code>XbfFcaseLabel</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFcaseLabel
     */
    XbfFcaseLabel createXbfFcaseLabel(RStack stack);

    /**
     * Creates a <code>XbfFwhereStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFwhereStatement
     */
    XbfFwhereStatement createXbfFwhereStatement(RStack stack);

    /**
     * Creates a <code>XbfFstopStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFstopStatement
     */
    XbfFstopStatement createXbfFstopStatement(RStack stack);

    /**
     * Creates a <code>XbfFwriteStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFwriteStatement
     */
    XbfFwriteStatement createXbfFwriteStatement(RStack stack);

    /**
     * Creates a <code>XbfFprintStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFprintStatement
     */
    XbfFprintStatement createXbfFprintStatement(RStack stack);

    /**
     * Creates a <code>XbfFrewindStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFrewindStatement
     */
    XbfFrewindStatement createXbfFrewindStatement(RStack stack);

    /**
     * Creates a <code>XbfFendFileStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFendFileStatement
     */
    XbfFendFileStatement createXbfFendFileStatement(RStack stack);

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFbackspaceStatement
     */
    XbfFbackspaceStatement createXbfFbackspaceStatement(RStack stack);

    /**
     * Creates a <code>XbfFinquireStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFinquireStatement
     */
    XbfFinquireStatement createXbfFinquireStatement(RStack stack);

    /**
     * Creates a <code>XbfFformatDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFformatDecl
     */
    XbfFformatDecl createXbfFformatDecl(RStack stack);

    /**
     * Creates a <code>XbfFallocateStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFallocateStatement
     */
    XbfFallocateStatement createXbfFallocateStatement(RStack stack);

    /**
     * Creates a <code>XbfAlloc</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfAlloc
     */
    XbfAlloc createXbfAlloc(RStack stack);

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFdeallocateStatement
     */
    XbfFdeallocateStatement createXbfFdeallocateStatement(RStack stack);

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFnullifyStatement
     */
    XbfFnullifyStatement createXbfFnullifyStatement(RStack stack);

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFcontainsStatement
     */
    XbfFcontainsStatement createXbfFcontainsStatement(RStack stack);

    /**
     * Creates a <code>XbfText</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfText
     */
    XbfText createXbfText(RStack stack);

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFmoduleDefinition
     */
    XbfFmoduleDefinition createXbfFmoduleDefinition(RStack stack);

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFblockDataDefinition
     */
    XbfFblockDataDefinition createXbfFblockDataDefinition(RStack stack);

    /**
     * Creates a <code>XbfDefModelArraySubscriptSequence1</code> by the Element <code>element</code>.
     *
     * @return XbfDefModelArraySubscriptSequence1
     */
    XbfDefModelArraySubscriptSequence1 createXbfDefModelArraySubscriptSequence1();

    /**
     * Creates a <code>XbfFequivalenceDeclSequence</code> by the Element <code>element</code>.
     *
     * @return XbfFequivalenceDeclSequence
     */
    XbfFequivalenceDeclSequence createXbfFequivalenceDeclSequence();

    /**
     * Creates a <code>XbfFdataDeclSequence</code> by the Element <code>element</code>.
     *
     * @return XbfFdataDeclSequence
     */
    XbfFdataDeclSequence createXbfFdataDeclSequence();

    /**
     * Creates a <code>XbfGotoStatementSequence</code> by the Element <code>element</code>.
     *
     * @return XbfGotoStatementSequence
     */
    XbfGotoStatementSequence createXbfGotoStatementSequence();

    /**
     * Creates a <code>XbfFdoStatementSequence</code> by the Element <code>element</code>.
     *
     * @return XbfFdoStatementSequence
     */
    XbfFdoStatementSequence createXbfFdoStatementSequence();

    /**
     * Creates a <code>XbfDefModelArraySubscriptSequence1</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfDefModelArraySubscriptSequence1
     */
    XbfDefModelArraySubscriptSequence1 createXbfDefModelArraySubscriptSequence1(RStack stack);

    /**
     * Creates a <code>XbfFequivalenceDeclSequence</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFequivalenceDeclSequence
     */
    XbfFequivalenceDeclSequence createXbfFequivalenceDeclSequence(RStack stack);

    /**
     * Creates a <code>XbfFdataDeclSequence</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFdataDeclSequence
     */
    XbfFdataDeclSequence createXbfFdataDeclSequence(RStack stack);

    /**
     * Creates a <code>XbfGotoStatementSequence</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfGotoStatementSequence
     */
    XbfGotoStatementSequence createXbfGotoStatementSequence(RStack stack);

    /**
     * Creates a <code>XbfFdoStatementSequence</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbfFdoStatementSequence
     */
    XbfFdoStatementSequence createXbfFdoStatementSequence(RStack stack);

    /**
     * Creates a <code>XbfDefModelArraySubscriptSequence1</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfDefModelArraySubscriptSequence1
     */
    XbfDefModelArraySubscriptSequence1 createXbfDefModelArraySubscriptSequence1(XbfDefModelArraySubscriptSequence1 source);

    /**
     * Creates a <code>XbfFequivalenceDeclSequence</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFequivalenceDeclSequence
     */
    XbfFequivalenceDeclSequence createXbfFequivalenceDeclSequence(XbfFequivalenceDeclSequence source);

    /**
     * Creates a <code>XbfFdataDeclSequence</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFdataDeclSequence
     */
    XbfFdataDeclSequence createXbfFdataDeclSequence(XbfFdataDeclSequence source);

    /**
     * Creates a <code>XbfGotoStatementSequence</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfGotoStatementSequence
     */
    XbfGotoStatementSequence createXbfGotoStatementSequence(XbfGotoStatementSequence source);

    /**
     * Creates a <code>XbfFdoStatementSequence</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFdoStatementSequence
     */
    XbfFdoStatementSequence createXbfFdoStatementSequence(XbfFdoStatementSequence source);
}
