/*
 * The Relaxer artifact
 * Copyright (c) 2000-2003, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package xcodeml.f.binding.gen;

import xcodeml.binding.*;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * AbstractXcodeML_FFactory is generated by Relaxer based on XcodeML_F.rng.
 *
 * @version XcodeML_F.rng 1.0 (Mon Jan 23 20:53:33 JST 2012)
 * @author  Relaxer 1.0 (http://www.relaxer.org)
 */
public abstract class AbstractXcodeML_FFactory implements IXcodeML_FFactory {
    protected org.xml.sax.ErrorHandler errorHandler;
    protected org.xml.sax.EntityResolver entityResolver;
    protected String baseUri;

    /**
     * Sets a <b>errorHandler</b>.
     *
     * @param errorHandler
     */
    public void setErrorHandler(org.xml.sax.ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    /**
     * Gets a <b>errorHandler</b>.
     *
     * @return org.xml.sax.ErrorHandler
     */
    public org.xml.sax.ErrorHandler getErrorHandler() {
        return (errorHandler);
    }

    /**
     * Sets a <b>entityResolver</b>.
     *
     * @param entityResolver
     */
    public void setEntityResolver(org.xml.sax.EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    /**
     * Gets a <b>entityResolver</b>.
     *
     * @return org.xml.sax.EntityResolver
     */
    public org.xml.sax.EntityResolver getEntityResolver() {
        return (entityResolver);
    }

    /**
     * Sets a <b>baseUri</b>.
     *
     * @param baseUri
     */
    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    /**
     * Gets a <b>baseUri</b>.
     *
     * @return String
     */
    public String getBaseUri() {
        return (baseUri);
    }

    /**
     * Creates a <code>Object</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(File file) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(String uri) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(URL url) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the copy <code>Object</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return Object
     */
    public Object create(Object source) {
        if (source instanceof XbfXcodeProgram) {
            XbfXcodeProgram node = createXbfXcodeProgram();
            node.setup((XbfXcodeProgram)source);
            return(node);
        } else if (source instanceof XbfTypeTable) {
            XbfTypeTable node = createXbfTypeTable();
            node.setup((XbfTypeTable)source);
            return(node);
        } else if (source instanceof XbfFfunctionType) {
            XbfFfunctionType node = createXbfFfunctionType();
            node.setup((XbfFfunctionType)source);
            return(node);
        } else if (source instanceof XbfParams) {
            XbfParams node = createXbfParams();
            node.setup((XbfParams)source);
            return(node);
        } else if (source instanceof XbfName) {
            XbfName node = createXbfName();
            node.setup((XbfName)source);
            return(node);
        } else if (source instanceof XbfFbasicType) {
            XbfFbasicType node = createXbfFbasicType();
            node.setup((XbfFbasicType)source);
            return(node);
        } else if (source instanceof XbfKind) {
            XbfKind node = createXbfKind();
            node.setup((XbfKind)source);
            return(node);
        } else if (source instanceof XbfFarrayRef) {
            XbfFarrayRef node = createXbfFarrayRef();
            node.setup((XbfFarrayRef)source);
            return(node);
        } else if (source instanceof XbfVarRef) {
            XbfVarRef node = createXbfVarRef();
            node.setup((XbfVarRef)source);
            return(node);
        } else if (source instanceof XbfFcharacterRef) {
            XbfFcharacterRef node = createXbfFcharacterRef();
            node.setup((XbfFcharacterRef)source);
            return(node);
        } else if (source instanceof XbfIndexRange) {
            XbfIndexRange node = createXbfIndexRange();
            node.setup((XbfIndexRange)source);
            return(node);
        } else if (source instanceof XbfLowerBound) {
            XbfLowerBound node = createXbfLowerBound();
            node.setup((XbfLowerBound)source);
            return(node);
        } else if (source instanceof XbfUpperBound) {
            XbfUpperBound node = createXbfUpperBound();
            node.setup((XbfUpperBound)source);
            return(node);
        } else if (source instanceof XbfStep) {
            XbfStep node = createXbfStep();
            node.setup((XbfStep)source);
            return(node);
        } else if (source instanceof XbfFmemberRef) {
            XbfFmemberRef node = createXbfFmemberRef();
            node.setup((XbfFmemberRef)source);
            return(node);
        } else if (source instanceof XbfFcoArrayRef) {
            XbfFcoArrayRef node = createXbfFcoArrayRef();
            node.setup((XbfFcoArrayRef)source);
            return(node);
        } else if (source instanceof XbfArrayIndex) {
            XbfArrayIndex node = createXbfArrayIndex();
            node.setup((XbfArrayIndex)source);
            return(node);
        } else if (source instanceof XbfVar) {
            XbfVar node = createXbfVar();
            node.setup((XbfVar)source);
            return(node);
        } else if (source instanceof XbfFarrayConstructor) {
            XbfFarrayConstructor node = createXbfFarrayConstructor();
            node.setup((XbfFarrayConstructor)source);
            return(node);
        } else if (source instanceof XbfFdoLoop) {
            XbfFdoLoop node = createXbfFdoLoop();
            node.setup((XbfFdoLoop)source);
            return(node);
        } else if (source instanceof XbfValue) {
            XbfValue node = createXbfValue();
            node.setup((XbfValue)source);
            return(node);
        } else if (source instanceof XbfRepeatCount) {
            XbfRepeatCount node = createXbfRepeatCount();
            node.setup((XbfRepeatCount)source);
            return(node);
        } else if (source instanceof XbfFintConstant) {
            XbfFintConstant node = createXbfFintConstant();
            node.setup((XbfFintConstant)source);
            return(node);
        } else if (source instanceof XbfFrealConstant) {
            XbfFrealConstant node = createXbfFrealConstant();
            node.setup((XbfFrealConstant)source);
            return(node);
        } else if (source instanceof XbfFcharacterConstant) {
            XbfFcharacterConstant node = createXbfFcharacterConstant();
            node.setup((XbfFcharacterConstant)source);
            return(node);
        } else if (source instanceof XbfFlogicalConstant) {
            XbfFlogicalConstant node = createXbfFlogicalConstant();
            node.setup((XbfFlogicalConstant)source);
            return(node);
        } else if (source instanceof XbfFcomplexConstant) {
            XbfFcomplexConstant node = createXbfFcomplexConstant();
            node.setup((XbfFcomplexConstant)source);
            return(node);
        } else if (source instanceof XbfFstructConstructor) {
            XbfFstructConstructor node = createXbfFstructConstructor();
            node.setup((XbfFstructConstructor)source);
            return(node);
        } else if (source instanceof XbfFunctionCall) {
            XbfFunctionCall node = createXbfFunctionCall();
            node.setup((XbfFunctionCall)source);
            return(node);
        } else if (source instanceof XbfArguments) {
            XbfArguments node = createXbfArguments();
            node.setup((XbfArguments)source);
            return(node);
        } else if (source instanceof XbfNamedValue) {
            XbfNamedValue node = createXbfNamedValue();
            node.setup((XbfNamedValue)source);
            return(node);
        } else if (source instanceof XbfUserUnaryExpr) {
            XbfUserUnaryExpr node = createXbfUserUnaryExpr();
            node.setup((XbfUserUnaryExpr)source);
            return(node);
        } else if (source instanceof XbfUserBinaryExpr) {
            XbfUserBinaryExpr node = createXbfUserBinaryExpr();
            node.setup((XbfUserBinaryExpr)source);
            return(node);
        } else if (source instanceof XbfLogNotExpr) {
            XbfLogNotExpr node = createXbfLogNotExpr();
            node.setup((XbfLogNotExpr)source);
            return(node);
        } else if (source instanceof XbfFfunction) {
            XbfFfunction node = createXbfFfunction();
            node.setup((XbfFfunction)source);
            return(node);
        } else if (source instanceof XbfLogNEQExpr) {
            XbfLogNEQExpr node = createXbfLogNEQExpr();
            node.setup((XbfLogNEQExpr)source);
            return(node);
        } else if (source instanceof XbfLogGTExpr) {
            XbfLogGTExpr node = createXbfLogGTExpr();
            node.setup((XbfLogGTExpr)source);
            return(node);
        } else if (source instanceof XbfLogNEQVExpr) {
            XbfLogNEQVExpr node = createXbfLogNEQVExpr();
            node.setup((XbfLogNEQVExpr)source);
            return(node);
        } else if (source instanceof XbfPlusExpr) {
            XbfPlusExpr node = createXbfPlusExpr();
            node.setup((XbfPlusExpr)source);
            return(node);
        } else if (source instanceof XbfMinusExpr) {
            XbfMinusExpr node = createXbfMinusExpr();
            node.setup((XbfMinusExpr)source);
            return(node);
        } else if (source instanceof XbfMulExpr) {
            XbfMulExpr node = createXbfMulExpr();
            node.setup((XbfMulExpr)source);
            return(node);
        } else if (source instanceof XbfDivExpr) {
            XbfDivExpr node = createXbfDivExpr();
            node.setup((XbfDivExpr)source);
            return(node);
        } else if (source instanceof XbfFpowerExpr) {
            XbfFpowerExpr node = createXbfFpowerExpr();
            node.setup((XbfFpowerExpr)source);
            return(node);
        } else if (source instanceof XbfFconcatExpr) {
            XbfFconcatExpr node = createXbfFconcatExpr();
            node.setup((XbfFconcatExpr)source);
            return(node);
        } else if (source instanceof XbfLogEQExpr) {
            XbfLogEQExpr node = createXbfLogEQExpr();
            node.setup((XbfLogEQExpr)source);
            return(node);
        } else if (source instanceof XbfLogGEExpr) {
            XbfLogGEExpr node = createXbfLogGEExpr();
            node.setup((XbfLogGEExpr)source);
            return(node);
        } else if (source instanceof XbfLogLEExpr) {
            XbfLogLEExpr node = createXbfLogLEExpr();
            node.setup((XbfLogLEExpr)source);
            return(node);
        } else if (source instanceof XbfLogLTExpr) {
            XbfLogLTExpr node = createXbfLogLTExpr();
            node.setup((XbfLogLTExpr)source);
            return(node);
        } else if (source instanceof XbfLogAndExpr) {
            XbfLogAndExpr node = createXbfLogAndExpr();
            node.setup((XbfLogAndExpr)source);
            return(node);
        } else if (source instanceof XbfLogOrExpr) {
            XbfLogOrExpr node = createXbfLogOrExpr();
            node.setup((XbfLogOrExpr)source);
            return(node);
        } else if (source instanceof XbfLogEQVExpr) {
            XbfLogEQVExpr node = createXbfLogEQVExpr();
            node.setup((XbfLogEQVExpr)source);
            return(node);
        } else if (source instanceof XbfUnaryMinusExpr) {
            XbfUnaryMinusExpr node = createXbfUnaryMinusExpr();
            node.setup((XbfUnaryMinusExpr)source);
            return(node);
        } else if (source instanceof XbfLen) {
            XbfLen node = createXbfLen();
            node.setup((XbfLen)source);
            return(node);
        } else if (source instanceof XbfCoShape) {
            XbfCoShape node = createXbfCoShape();
            node.setup((XbfCoShape)source);
            return(node);
        } else if (source instanceof XbfFstructType) {
            XbfFstructType node = createXbfFstructType();
            node.setup((XbfFstructType)source);
            return(node);
        } else if (source instanceof XbfSymbols) {
            XbfSymbols node = createXbfSymbols();
            node.setup((XbfSymbols)source);
            return(node);
        } else if (source instanceof XbfId) {
            XbfId node = createXbfId();
            node.setup((XbfId)source);
            return(node);
        } else if (source instanceof XbfGlobalSymbols) {
            XbfGlobalSymbols node = createXbfGlobalSymbols();
            node.setup((XbfGlobalSymbols)source);
            return(node);
        } else if (source instanceof XbfGlobalDeclarations) {
            XbfGlobalDeclarations node = createXbfGlobalDeclarations();
            node.setup((XbfGlobalDeclarations)source);
            return(node);
        } else if (source instanceof XbfFfunctionDefinition) {
            XbfFfunctionDefinition node = createXbfFfunctionDefinition();
            node.setup((XbfFfunctionDefinition)source);
            return(node);
        } else if (source instanceof XbfDeclarations) {
            XbfDeclarations node = createXbfDeclarations();
            node.setup((XbfDeclarations)source);
            return(node);
        } else if (source instanceof XbfVarDecl) {
            XbfVarDecl node = createXbfVarDecl();
            node.setup((XbfVarDecl)source);
            return(node);
        } else if (source instanceof XbfExternDecl) {
            XbfExternDecl node = createXbfExternDecl();
            node.setup((XbfExternDecl)source);
            return(node);
        } else if (source instanceof XbfFuseDecl) {
            XbfFuseDecl node = createXbfFuseDecl();
            node.setup((XbfFuseDecl)source);
            return(node);
        } else if (source instanceof XbfRename) {
            XbfRename node = createXbfRename();
            node.setup((XbfRename)source);
            return(node);
        } else if (source instanceof XbfFuseOnlyDecl) {
            XbfFuseOnlyDecl node = createXbfFuseOnlyDecl();
            node.setup((XbfFuseOnlyDecl)source);
            return(node);
        } else if (source instanceof XbfRenamable) {
            XbfRenamable node = createXbfRenamable();
            node.setup((XbfRenamable)source);
            return(node);
        } else if (source instanceof XbfFinterfaceDecl) {
            XbfFinterfaceDecl node = createXbfFinterfaceDecl();
            node.setup((XbfFinterfaceDecl)source);
            return(node);
        } else if (source instanceof XbfFfunctionDecl) {
            XbfFfunctionDecl node = createXbfFfunctionDecl();
            node.setup((XbfFfunctionDecl)source);
            return(node);
        } else if (source instanceof XbfFmoduleProcedureDecl) {
            XbfFmoduleProcedureDecl node = createXbfFmoduleProcedureDecl();
            node.setup((XbfFmoduleProcedureDecl)source);
            return(node);
        } else if (source instanceof XbfFnamelistDecl) {
            XbfFnamelistDecl node = createXbfFnamelistDecl();
            node.setup((XbfFnamelistDecl)source);
            return(node);
        } else if (source instanceof XbfVarList) {
            XbfVarList node = createXbfVarList();
            node.setup((XbfVarList)source);
            return(node);
        } else if (source instanceof XbfFequivalenceDecl) {
            XbfFequivalenceDecl node = createXbfFequivalenceDecl();
            node.setup((XbfFequivalenceDecl)source);
            return(node);
        } else if (source instanceof XbfFcommonDecl) {
            XbfFcommonDecl node = createXbfFcommonDecl();
            node.setup((XbfFcommonDecl)source);
            return(node);
        } else if (source instanceof XbfFstructDecl) {
            XbfFstructDecl node = createXbfFstructDecl();
            node.setup((XbfFstructDecl)source);
            return(node);
        } else if (source instanceof XbfFentryDecl) {
            XbfFentryDecl node = createXbfFentryDecl();
            node.setup((XbfFentryDecl)source);
            return(node);
        } else if (source instanceof XbfFdataDecl) {
            XbfFdataDecl node = createXbfFdataDecl();
            node.setup((XbfFdataDecl)source);
            return(node);
        } else if (source instanceof XbfValueList) {
            XbfValueList node = createXbfValueList();
            node.setup((XbfValueList)source);
            return(node);
        } else if (source instanceof XbfFpragmaStatement) {
            XbfFpragmaStatement node = createXbfFpragmaStatement();
            node.setup((XbfFpragmaStatement)source);
            return(node);
        } else if (source instanceof XbfBody) {
            XbfBody node = createXbfBody();
            node.setup((XbfBody)source);
            return(node);
        } else if (source instanceof XbfGotoStatement) {
            XbfGotoStatement node = createXbfGotoStatement();
            node.setup((XbfGotoStatement)source);
            return(node);
        } else if (source instanceof XbfFpauseStatement) {
            XbfFpauseStatement node = createXbfFpauseStatement();
            node.setup((XbfFpauseStatement)source);
            return(node);
        } else if (source instanceof XbfFcycleStatement) {
            XbfFcycleStatement node = createXbfFcycleStatement();
            node.setup((XbfFcycleStatement)source);
            return(node);
        } else if (source instanceof XbfFreadStatement) {
            XbfFreadStatement node = createXbfFreadStatement();
            node.setup((XbfFreadStatement)source);
            return(node);
        } else if (source instanceof XbfNamedValueList) {
            XbfNamedValueList node = createXbfNamedValueList();
            node.setup((XbfNamedValueList)source);
            return(node);
        } else if (source instanceof XbfFcloseStatement) {
            XbfFcloseStatement node = createXbfFcloseStatement();
            node.setup((XbfFcloseStatement)source);
            return(node);
        } else if (source instanceof XbfFopenStatement) {
            XbfFopenStatement node = createXbfFopenStatement();
            node.setup((XbfFopenStatement)source);
            return(node);
        } else if (source instanceof XbfFassignStatement) {
            XbfFassignStatement node = createXbfFassignStatement();
            node.setup((XbfFassignStatement)source);
            return(node);
        } else if (source instanceof XbfExprStatement) {
            XbfExprStatement node = createXbfExprStatement();
            node.setup((XbfExprStatement)source);
            return(node);
        } else if (source instanceof XbfFpointerAssignStatement) {
            XbfFpointerAssignStatement node = createXbfFpointerAssignStatement();
            node.setup((XbfFpointerAssignStatement)source);
            return(node);
        } else if (source instanceof XbfFifStatement) {
            XbfFifStatement node = createXbfFifStatement();
            node.setup((XbfFifStatement)source);
            return(node);
        } else if (source instanceof XbfCondition) {
            XbfCondition node = createXbfCondition();
            node.setup((XbfCondition)source);
            return(node);
        } else if (source instanceof XbfThen) {
            XbfThen node = createXbfThen();
            node.setup((XbfThen)source);
            return(node);
        } else if (source instanceof XbfElse) {
            XbfElse node = createXbfElse();
            node.setup((XbfElse)source);
            return(node);
        } else if (source instanceof XbfFdoStatement) {
            XbfFdoStatement node = createXbfFdoStatement();
            node.setup((XbfFdoStatement)source);
            return(node);
        } else if (source instanceof XbfFdoWhileStatement) {
            XbfFdoWhileStatement node = createXbfFdoWhileStatement();
            node.setup((XbfFdoWhileStatement)source);
            return(node);
        } else if (source instanceof XbfContinueStatement) {
            XbfContinueStatement node = createXbfContinueStatement();
            node.setup((XbfContinueStatement)source);
            return(node);
        } else if (source instanceof XbfFexitStatement) {
            XbfFexitStatement node = createXbfFexitStatement();
            node.setup((XbfFexitStatement)source);
            return(node);
        } else if (source instanceof XbfFreturnStatement) {
            XbfFreturnStatement node = createXbfFreturnStatement();
            node.setup((XbfFreturnStatement)source);
            return(node);
        } else if (source instanceof XbfStatementLabel) {
            XbfStatementLabel node = createXbfStatementLabel();
            node.setup((XbfStatementLabel)source);
            return(node);
        } else if (source instanceof XbfFselectCaseStatement) {
            XbfFselectCaseStatement node = createXbfFselectCaseStatement();
            node.setup((XbfFselectCaseStatement)source);
            return(node);
        } else if (source instanceof XbfFcaseLabel) {
            XbfFcaseLabel node = createXbfFcaseLabel();
            node.setup((XbfFcaseLabel)source);
            return(node);
        } else if (source instanceof XbfFwhereStatement) {
            XbfFwhereStatement node = createXbfFwhereStatement();
            node.setup((XbfFwhereStatement)source);
            return(node);
        } else if (source instanceof XbfFstopStatement) {
            XbfFstopStatement node = createXbfFstopStatement();
            node.setup((XbfFstopStatement)source);
            return(node);
        } else if (source instanceof XbfFwriteStatement) {
            XbfFwriteStatement node = createXbfFwriteStatement();
            node.setup((XbfFwriteStatement)source);
            return(node);
        } else if (source instanceof XbfFprintStatement) {
            XbfFprintStatement node = createXbfFprintStatement();
            node.setup((XbfFprintStatement)source);
            return(node);
        } else if (source instanceof XbfFrewindStatement) {
            XbfFrewindStatement node = createXbfFrewindStatement();
            node.setup((XbfFrewindStatement)source);
            return(node);
        } else if (source instanceof XbfFendFileStatement) {
            XbfFendFileStatement node = createXbfFendFileStatement();
            node.setup((XbfFendFileStatement)source);
            return(node);
        } else if (source instanceof XbfFbackspaceStatement) {
            XbfFbackspaceStatement node = createXbfFbackspaceStatement();
            node.setup((XbfFbackspaceStatement)source);
            return(node);
        } else if (source instanceof XbfFinquireStatement) {
            XbfFinquireStatement node = createXbfFinquireStatement();
            node.setup((XbfFinquireStatement)source);
            return(node);
        } else if (source instanceof XbfFformatDecl) {
            XbfFformatDecl node = createXbfFformatDecl();
            node.setup((XbfFformatDecl)source);
            return(node);
        } else if (source instanceof XbfFallocateStatement) {
            XbfFallocateStatement node = createXbfFallocateStatement();
            node.setup((XbfFallocateStatement)source);
            return(node);
        } else if (source instanceof XbfAlloc) {
            XbfAlloc node = createXbfAlloc();
            node.setup((XbfAlloc)source);
            return(node);
        } else if (source instanceof XbfFdeallocateStatement) {
            XbfFdeallocateStatement node = createXbfFdeallocateStatement();
            node.setup((XbfFdeallocateStatement)source);
            return(node);
        } else if (source instanceof XbfFnullifyStatement) {
            XbfFnullifyStatement node = createXbfFnullifyStatement();
            node.setup((XbfFnullifyStatement)source);
            return(node);
        } else if (source instanceof XbfFcontainsStatement) {
            XbfFcontainsStatement node = createXbfFcontainsStatement();
            node.setup((XbfFcontainsStatement)source);
            return(node);
        } else if (source instanceof XbfText) {
            XbfText node = createXbfText();
            node.setup((XbfText)source);
            return(node);
        } else if (source instanceof XbfFmoduleDefinition) {
            XbfFmoduleDefinition node = createXbfFmoduleDefinition();
            node.setup((XbfFmoduleDefinition)source);
            return(node);
        } else if (source instanceof XbfFblockDataDefinition) {
            XbfFblockDataDefinition node = createXbfFblockDataDefinition();
            node.setup((XbfFblockDataDefinition)source);
            return(node);
        } else {
            return (null);
        }
    }

    /**
     * Creates a <code>Object</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Document doc) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(doc.getDocumentElement());
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Element element) throws IOException, SAXException, ParserConfigurationException {
        if (XbfXcodeProgram.isMatch(element)) {
            XbfXcodeProgram node = createXbfXcodeProgram();
            node.setup(element);
            return(node);
        } else if (XbfTypeTable.isMatch(element)) {
            XbfTypeTable node = createXbfTypeTable();
            node.setup(element);
            return(node);
        } else if (XbfFfunctionType.isMatch(element)) {
            XbfFfunctionType node = createXbfFfunctionType();
            node.setup(element);
            return(node);
        } else if (XbfParams.isMatch(element)) {
            XbfParams node = createXbfParams();
            node.setup(element);
            return(node);
        } else if (XbfName.isMatch(element)) {
            XbfName node = createXbfName();
            node.setup(element);
            return(node);
        } else if (XbfFbasicType.isMatch(element)) {
            XbfFbasicType node = createXbfFbasicType();
            node.setup(element);
            return(node);
        } else if (XbfKind.isMatch(element)) {
            XbfKind node = createXbfKind();
            node.setup(element);
            return(node);
        } else if (XbfFarrayRef.isMatch(element)) {
            XbfFarrayRef node = createXbfFarrayRef();
            node.setup(element);
            return(node);
        } else if (XbfVarRef.isMatch(element)) {
            XbfVarRef node = createXbfVarRef();
            node.setup(element);
            return(node);
        } else if (XbfFcharacterRef.isMatch(element)) {
            XbfFcharacterRef node = createXbfFcharacterRef();
            node.setup(element);
            return(node);
        } else if (XbfIndexRange.isMatch(element)) {
            XbfIndexRange node = createXbfIndexRange();
            node.setup(element);
            return(node);
        } else if (XbfLowerBound.isMatch(element)) {
            XbfLowerBound node = createXbfLowerBound();
            node.setup(element);
            return(node);
        } else if (XbfUpperBound.isMatch(element)) {
            XbfUpperBound node = createXbfUpperBound();
            node.setup(element);
            return(node);
        } else if (XbfStep.isMatch(element)) {
            XbfStep node = createXbfStep();
            node.setup(element);
            return(node);
        } else if (XbfFmemberRef.isMatch(element)) {
            XbfFmemberRef node = createXbfFmemberRef();
            node.setup(element);
            return(node);
        } else if (XbfFcoArrayRef.isMatch(element)) {
            XbfFcoArrayRef node = createXbfFcoArrayRef();
            node.setup(element);
            return(node);
        } else if (XbfArrayIndex.isMatch(element)) {
            XbfArrayIndex node = createXbfArrayIndex();
            node.setup(element);
            return(node);
        } else if (XbfVar.isMatch(element)) {
            XbfVar node = createXbfVar();
            node.setup(element);
            return(node);
        } else if (XbfFarrayConstructor.isMatch(element)) {
            XbfFarrayConstructor node = createXbfFarrayConstructor();
            node.setup(element);
            return(node);
        } else if (XbfFdoLoop.isMatch(element)) {
            XbfFdoLoop node = createXbfFdoLoop();
            node.setup(element);
            return(node);
        } else if (XbfValue.isMatch(element)) {
            XbfValue node = createXbfValue();
            node.setup(element);
            return(node);
        } else if (XbfRepeatCount.isMatch(element)) {
            XbfRepeatCount node = createXbfRepeatCount();
            node.setup(element);
            return(node);
        } else if (XbfFintConstant.isMatch(element)) {
            XbfFintConstant node = createXbfFintConstant();
            node.setup(element);
            return(node);
        } else if (XbfFrealConstant.isMatch(element)) {
            XbfFrealConstant node = createXbfFrealConstant();
            node.setup(element);
            return(node);
        } else if (XbfFcharacterConstant.isMatch(element)) {
            XbfFcharacterConstant node = createXbfFcharacterConstant();
            node.setup(element);
            return(node);
        } else if (XbfFlogicalConstant.isMatch(element)) {
            XbfFlogicalConstant node = createXbfFlogicalConstant();
            node.setup(element);
            return(node);
        } else if (XbfFcomplexConstant.isMatch(element)) {
            XbfFcomplexConstant node = createXbfFcomplexConstant();
            node.setup(element);
            return(node);
        } else if (XbfFstructConstructor.isMatch(element)) {
            XbfFstructConstructor node = createXbfFstructConstructor();
            node.setup(element);
            return(node);
        } else if (XbfFunctionCall.isMatch(element)) {
            XbfFunctionCall node = createXbfFunctionCall();
            node.setup(element);
            return(node);
        } else if (XbfArguments.isMatch(element)) {
            XbfArguments node = createXbfArguments();
            node.setup(element);
            return(node);
        } else if (XbfNamedValue.isMatch(element)) {
            XbfNamedValue node = createXbfNamedValue();
            node.setup(element);
            return(node);
        } else if (XbfUserUnaryExpr.isMatch(element)) {
            XbfUserUnaryExpr node = createXbfUserUnaryExpr();
            node.setup(element);
            return(node);
        } else if (XbfUserBinaryExpr.isMatch(element)) {
            XbfUserBinaryExpr node = createXbfUserBinaryExpr();
            node.setup(element);
            return(node);
        } else if (XbfLogNotExpr.isMatch(element)) {
            XbfLogNotExpr node = createXbfLogNotExpr();
            node.setup(element);
            return(node);
        } else if (XbfFfunction.isMatch(element)) {
            XbfFfunction node = createXbfFfunction();
            node.setup(element);
            return(node);
        } else if (XbfLogNEQExpr.isMatch(element)) {
            XbfLogNEQExpr node = createXbfLogNEQExpr();
            node.setup(element);
            return(node);
        } else if (XbfLogGTExpr.isMatch(element)) {
            XbfLogGTExpr node = createXbfLogGTExpr();
            node.setup(element);
            return(node);
        } else if (XbfLogNEQVExpr.isMatch(element)) {
            XbfLogNEQVExpr node = createXbfLogNEQVExpr();
            node.setup(element);
            return(node);
        } else if (XbfPlusExpr.isMatch(element)) {
            XbfPlusExpr node = createXbfPlusExpr();
            node.setup(element);
            return(node);
        } else if (XbfMinusExpr.isMatch(element)) {
            XbfMinusExpr node = createXbfMinusExpr();
            node.setup(element);
            return(node);
        } else if (XbfMulExpr.isMatch(element)) {
            XbfMulExpr node = createXbfMulExpr();
            node.setup(element);
            return(node);
        } else if (XbfDivExpr.isMatch(element)) {
            XbfDivExpr node = createXbfDivExpr();
            node.setup(element);
            return(node);
        } else if (XbfFpowerExpr.isMatch(element)) {
            XbfFpowerExpr node = createXbfFpowerExpr();
            node.setup(element);
            return(node);
        } else if (XbfFconcatExpr.isMatch(element)) {
            XbfFconcatExpr node = createXbfFconcatExpr();
            node.setup(element);
            return(node);
        } else if (XbfLogEQExpr.isMatch(element)) {
            XbfLogEQExpr node = createXbfLogEQExpr();
            node.setup(element);
            return(node);
        } else if (XbfLogGEExpr.isMatch(element)) {
            XbfLogGEExpr node = createXbfLogGEExpr();
            node.setup(element);
            return(node);
        } else if (XbfLogLEExpr.isMatch(element)) {
            XbfLogLEExpr node = createXbfLogLEExpr();
            node.setup(element);
            return(node);
        } else if (XbfLogLTExpr.isMatch(element)) {
            XbfLogLTExpr node = createXbfLogLTExpr();
            node.setup(element);
            return(node);
        } else if (XbfLogAndExpr.isMatch(element)) {
            XbfLogAndExpr node = createXbfLogAndExpr();
            node.setup(element);
            return(node);
        } else if (XbfLogOrExpr.isMatch(element)) {
            XbfLogOrExpr node = createXbfLogOrExpr();
            node.setup(element);
            return(node);
        } else if (XbfLogEQVExpr.isMatch(element)) {
            XbfLogEQVExpr node = createXbfLogEQVExpr();
            node.setup(element);
            return(node);
        } else if (XbfUnaryMinusExpr.isMatch(element)) {
            XbfUnaryMinusExpr node = createXbfUnaryMinusExpr();
            node.setup(element);
            return(node);
        } else if (XbfLen.isMatch(element)) {
            XbfLen node = createXbfLen();
            node.setup(element);
            return(node);
        } else if (XbfCoShape.isMatch(element)) {
            XbfCoShape node = createXbfCoShape();
            node.setup(element);
            return(node);
        } else if (XbfFstructType.isMatch(element)) {
            XbfFstructType node = createXbfFstructType();
            node.setup(element);
            return(node);
        } else if (XbfSymbols.isMatch(element)) {
            XbfSymbols node = createXbfSymbols();
            node.setup(element);
            return(node);
        } else if (XbfId.isMatch(element)) {
            XbfId node = createXbfId();
            node.setup(element);
            return(node);
        } else if (XbfGlobalSymbols.isMatch(element)) {
            XbfGlobalSymbols node = createXbfGlobalSymbols();
            node.setup(element);
            return(node);
        } else if (XbfGlobalDeclarations.isMatch(element)) {
            XbfGlobalDeclarations node = createXbfGlobalDeclarations();
            node.setup(element);
            return(node);
        } else if (XbfFfunctionDefinition.isMatch(element)) {
            XbfFfunctionDefinition node = createXbfFfunctionDefinition();
            node.setup(element);
            return(node);
        } else if (XbfDeclarations.isMatch(element)) {
            XbfDeclarations node = createXbfDeclarations();
            node.setup(element);
            return(node);
        } else if (XbfVarDecl.isMatch(element)) {
            XbfVarDecl node = createXbfVarDecl();
            node.setup(element);
            return(node);
        } else if (XbfExternDecl.isMatch(element)) {
            XbfExternDecl node = createXbfExternDecl();
            node.setup(element);
            return(node);
        } else if (XbfFuseDecl.isMatch(element)) {
            XbfFuseDecl node = createXbfFuseDecl();
            node.setup(element);
            return(node);
        } else if (XbfRename.isMatch(element)) {
            XbfRename node = createXbfRename();
            node.setup(element);
            return(node);
        } else if (XbfFuseOnlyDecl.isMatch(element)) {
            XbfFuseOnlyDecl node = createXbfFuseOnlyDecl();
            node.setup(element);
            return(node);
        } else if (XbfRenamable.isMatch(element)) {
            XbfRenamable node = createXbfRenamable();
            node.setup(element);
            return(node);
        } else if (XbfFinterfaceDecl.isMatch(element)) {
            XbfFinterfaceDecl node = createXbfFinterfaceDecl();
            node.setup(element);
            return(node);
        } else if (XbfFfunctionDecl.isMatch(element)) {
            XbfFfunctionDecl node = createXbfFfunctionDecl();
            node.setup(element);
            return(node);
        } else if (XbfFmoduleProcedureDecl.isMatch(element)) {
            XbfFmoduleProcedureDecl node = createXbfFmoduleProcedureDecl();
            node.setup(element);
            return(node);
        } else if (XbfFnamelistDecl.isMatch(element)) {
            XbfFnamelistDecl node = createXbfFnamelistDecl();
            node.setup(element);
            return(node);
        } else if (XbfVarList.isMatch(element)) {
            XbfVarList node = createXbfVarList();
            node.setup(element);
            return(node);
        } else if (XbfFequivalenceDecl.isMatch(element)) {
            XbfFequivalenceDecl node = createXbfFequivalenceDecl();
            node.setup(element);
            return(node);
        } else if (XbfFcommonDecl.isMatch(element)) {
            XbfFcommonDecl node = createXbfFcommonDecl();
            node.setup(element);
            return(node);
        } else if (XbfFstructDecl.isMatch(element)) {
            XbfFstructDecl node = createXbfFstructDecl();
            node.setup(element);
            return(node);
        } else if (XbfFentryDecl.isMatch(element)) {
            XbfFentryDecl node = createXbfFentryDecl();
            node.setup(element);
            return(node);
        } else if (XbfFdataDecl.isMatch(element)) {
            XbfFdataDecl node = createXbfFdataDecl();
            node.setup(element);
            return(node);
        } else if (XbfValueList.isMatch(element)) {
            XbfValueList node = createXbfValueList();
            node.setup(element);
            return(node);
        } else if (XbfFpragmaStatement.isMatch(element)) {
            XbfFpragmaStatement node = createXbfFpragmaStatement();
            node.setup(element);
            return(node);
        } else if (XbfBody.isMatch(element)) {
            XbfBody node = createXbfBody();
            node.setup(element);
            return(node);
        } else if (XbfGotoStatement.isMatch(element)) {
            XbfGotoStatement node = createXbfGotoStatement();
            node.setup(element);
            return(node);
        } else if (XbfFpauseStatement.isMatch(element)) {
            XbfFpauseStatement node = createXbfFpauseStatement();
            node.setup(element);
            return(node);
        } else if (XbfFcycleStatement.isMatch(element)) {
            XbfFcycleStatement node = createXbfFcycleStatement();
            node.setup(element);
            return(node);
        } else if (XbfFreadStatement.isMatch(element)) {
            XbfFreadStatement node = createXbfFreadStatement();
            node.setup(element);
            return(node);
        } else if (XbfNamedValueList.isMatch(element)) {
            XbfNamedValueList node = createXbfNamedValueList();
            node.setup(element);
            return(node);
        } else if (XbfFcloseStatement.isMatch(element)) {
            XbfFcloseStatement node = createXbfFcloseStatement();
            node.setup(element);
            return(node);
        } else if (XbfFopenStatement.isMatch(element)) {
            XbfFopenStatement node = createXbfFopenStatement();
            node.setup(element);
            return(node);
        } else if (XbfFassignStatement.isMatch(element)) {
            XbfFassignStatement node = createXbfFassignStatement();
            node.setup(element);
            return(node);
        } else if (XbfExprStatement.isMatch(element)) {
            XbfExprStatement node = createXbfExprStatement();
            node.setup(element);
            return(node);
        } else if (XbfFpointerAssignStatement.isMatch(element)) {
            XbfFpointerAssignStatement node = createXbfFpointerAssignStatement();
            node.setup(element);
            return(node);
        } else if (XbfFifStatement.isMatch(element)) {
            XbfFifStatement node = createXbfFifStatement();
            node.setup(element);
            return(node);
        } else if (XbfCondition.isMatch(element)) {
            XbfCondition node = createXbfCondition();
            node.setup(element);
            return(node);
        } else if (XbfThen.isMatch(element)) {
            XbfThen node = createXbfThen();
            node.setup(element);
            return(node);
        } else if (XbfElse.isMatch(element)) {
            XbfElse node = createXbfElse();
            node.setup(element);
            return(node);
        } else if (XbfFdoStatement.isMatch(element)) {
            XbfFdoStatement node = createXbfFdoStatement();
            node.setup(element);
            return(node);
        } else if (XbfFdoWhileStatement.isMatch(element)) {
            XbfFdoWhileStatement node = createXbfFdoWhileStatement();
            node.setup(element);
            return(node);
        } else if (XbfContinueStatement.isMatch(element)) {
            XbfContinueStatement node = createXbfContinueStatement();
            node.setup(element);
            return(node);
        } else if (XbfFexitStatement.isMatch(element)) {
            XbfFexitStatement node = createXbfFexitStatement();
            node.setup(element);
            return(node);
        } else if (XbfFreturnStatement.isMatch(element)) {
            XbfFreturnStatement node = createXbfFreturnStatement();
            node.setup(element);
            return(node);
        } else if (XbfStatementLabel.isMatch(element)) {
            XbfStatementLabel node = createXbfStatementLabel();
            node.setup(element);
            return(node);
        } else if (XbfFselectCaseStatement.isMatch(element)) {
            XbfFselectCaseStatement node = createXbfFselectCaseStatement();
            node.setup(element);
            return(node);
        } else if (XbfFcaseLabel.isMatch(element)) {
            XbfFcaseLabel node = createXbfFcaseLabel();
            node.setup(element);
            return(node);
        } else if (XbfFwhereStatement.isMatch(element)) {
            XbfFwhereStatement node = createXbfFwhereStatement();
            node.setup(element);
            return(node);
        } else if (XbfFstopStatement.isMatch(element)) {
            XbfFstopStatement node = createXbfFstopStatement();
            node.setup(element);
            return(node);
        } else if (XbfFwriteStatement.isMatch(element)) {
            XbfFwriteStatement node = createXbfFwriteStatement();
            node.setup(element);
            return(node);
        } else if (XbfFprintStatement.isMatch(element)) {
            XbfFprintStatement node = createXbfFprintStatement();
            node.setup(element);
            return(node);
        } else if (XbfFrewindStatement.isMatch(element)) {
            XbfFrewindStatement node = createXbfFrewindStatement();
            node.setup(element);
            return(node);
        } else if (XbfFendFileStatement.isMatch(element)) {
            XbfFendFileStatement node = createXbfFendFileStatement();
            node.setup(element);
            return(node);
        } else if (XbfFbackspaceStatement.isMatch(element)) {
            XbfFbackspaceStatement node = createXbfFbackspaceStatement();
            node.setup(element);
            return(node);
        } else if (XbfFinquireStatement.isMatch(element)) {
            XbfFinquireStatement node = createXbfFinquireStatement();
            node.setup(element);
            return(node);
        } else if (XbfFformatDecl.isMatch(element)) {
            XbfFformatDecl node = createXbfFformatDecl();
            node.setup(element);
            return(node);
        } else if (XbfFallocateStatement.isMatch(element)) {
            XbfFallocateStatement node = createXbfFallocateStatement();
            node.setup(element);
            return(node);
        } else if (XbfAlloc.isMatch(element)) {
            XbfAlloc node = createXbfAlloc();
            node.setup(element);
            return(node);
        } else if (XbfFdeallocateStatement.isMatch(element)) {
            XbfFdeallocateStatement node = createXbfFdeallocateStatement();
            node.setup(element);
            return(node);
        } else if (XbfFnullifyStatement.isMatch(element)) {
            XbfFnullifyStatement node = createXbfFnullifyStatement();
            node.setup(element);
            return(node);
        } else if (XbfFcontainsStatement.isMatch(element)) {
            XbfFcontainsStatement node = createXbfFcontainsStatement();
            node.setup(element);
            return(node);
        } else if (XbfText.isMatch(element)) {
            XbfText node = createXbfText();
            node.setup(element);
            return(node);
        } else if (XbfFmoduleDefinition.isMatch(element)) {
            XbfFmoduleDefinition node = createXbfFmoduleDefinition();
            node.setup(element);
            return(node);
        } else if (XbfFblockDataDefinition.isMatch(element)) {
            XbfFblockDataDefinition node = createXbfFblockDataDefinition();
            node.setup(element);
            return(node);
        } else {
            return (null);
        }
    }

    /**
     * Creates a <code>XbfXcodeProgram</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfXcodeProgram
     */
    public XbfXcodeProgram createXbfXcodeProgram(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfXcodeProgram xbfXcodeProgram_ = createXbfXcodeProgram();
        xbfXcodeProgram_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfXcodeProgram_);
    }

    /**
     * Creates a <code>XbfTypeTable</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfTypeTable
     */
    public XbfTypeTable createXbfTypeTable(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfTypeTable xbfTypeTable_ = createXbfTypeTable();
        xbfTypeTable_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfTypeTable_);
    }

    /**
     * Creates a <code>XbfFfunctionType</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionType
     */
    public XbfFfunctionType createXbfFfunctionType(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionType xbfFfunctionType_ = createXbfFfunctionType();
        xbfFfunctionType_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionType_);
    }

    /**
     * Creates a <code>XbfParams</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfParams
     */
    public XbfParams createXbfParams(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfParams xbfParams_ = createXbfParams();
        xbfParams_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfParams_);
    }

    /**
     * Creates a <code>XbfName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfName
     */
    public XbfName createXbfName(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfName xbfName_ = createXbfName();
        xbfName_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfName_);
    }

    /**
     * Creates a <code>XbfFbasicType</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbasicType
     */
    public XbfFbasicType createXbfFbasicType(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFbasicType xbfFbasicType_ = createXbfFbasicType();
        xbfFbasicType_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFbasicType_);
    }

    /**
     * Creates a <code>XbfKind</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfKind
     */
    public XbfKind createXbfKind(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfKind xbfKind_ = createXbfKind();
        xbfKind_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfKind_);
    }

    /**
     * Creates a <code>XbfFarrayRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayRef
     */
    public XbfFarrayRef createXbfFarrayRef(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFarrayRef xbfFarrayRef_ = createXbfFarrayRef();
        xbfFarrayRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFarrayRef_);
    }

    /**
     * Creates a <code>XbfVarRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarRef
     */
    public XbfVarRef createXbfVarRef(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfVarRef xbfVarRef_ = createXbfVarRef();
        xbfVarRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarRef_);
    }

    /**
     * Creates a <code>XbfFcharacterRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterRef
     */
    public XbfFcharacterRef createXbfFcharacterRef(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFcharacterRef xbfFcharacterRef_ = createXbfFcharacterRef();
        xbfFcharacterRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcharacterRef_);
    }

    /**
     * Creates a <code>XbfIndexRange</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfIndexRange
     */
    public XbfIndexRange createXbfIndexRange(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfIndexRange xbfIndexRange_ = createXbfIndexRange();
        xbfIndexRange_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfIndexRange_);
    }

    /**
     * Creates a <code>XbfLowerBound</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLowerBound
     */
    public XbfLowerBound createXbfLowerBound(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLowerBound xbfLowerBound_ = createXbfLowerBound();
        xbfLowerBound_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLowerBound_);
    }

    /**
     * Creates a <code>XbfUpperBound</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUpperBound
     */
    public XbfUpperBound createXbfUpperBound(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfUpperBound xbfUpperBound_ = createXbfUpperBound();
        xbfUpperBound_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUpperBound_);
    }

    /**
     * Creates a <code>XbfStep</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStep
     */
    public XbfStep createXbfStep(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfStep xbfStep_ = createXbfStep();
        xbfStep_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfStep_);
    }

    /**
     * Creates a <code>XbfFmemberRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmemberRef
     */
    public XbfFmemberRef createXbfFmemberRef(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFmemberRef xbfFmemberRef_ = createXbfFmemberRef();
        xbfFmemberRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmemberRef_);
    }

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcoArrayRef
     */
    public XbfFcoArrayRef createXbfFcoArrayRef(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFcoArrayRef xbfFcoArrayRef_ = createXbfFcoArrayRef();
        xbfFcoArrayRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcoArrayRef_);
    }

    /**
     * Creates a <code>XbfArrayIndex</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArrayIndex
     */
    public XbfArrayIndex createXbfArrayIndex(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfArrayIndex xbfArrayIndex_ = createXbfArrayIndex();
        xbfArrayIndex_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfArrayIndex_);
    }

    /**
     * Creates a <code>XbfVar</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVar
     */
    public XbfVar createXbfVar(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfVar xbfVar_ = createXbfVar();
        xbfVar_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVar_);
    }

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayConstructor
     */
    public XbfFarrayConstructor createXbfFarrayConstructor(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFarrayConstructor xbfFarrayConstructor_ = createXbfFarrayConstructor();
        xbfFarrayConstructor_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFarrayConstructor_);
    }

    /**
     * Creates a <code>XbfFdoLoop</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoLoop
     */
    public XbfFdoLoop createXbfFdoLoop(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoLoop xbfFdoLoop_ = createXbfFdoLoop();
        xbfFdoLoop_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoLoop_);
    }

    /**
     * Creates a <code>XbfValue</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValue
     */
    public XbfValue createXbfValue(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfValue xbfValue_ = createXbfValue();
        xbfValue_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfValue_);
    }

    /**
     * Creates a <code>XbfRepeatCount</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRepeatCount
     */
    public XbfRepeatCount createXbfRepeatCount(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfRepeatCount xbfRepeatCount_ = createXbfRepeatCount();
        xbfRepeatCount_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRepeatCount_);
    }

    /**
     * Creates a <code>XbfFintConstant</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFintConstant
     */
    public XbfFintConstant createXbfFintConstant(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFintConstant xbfFintConstant_ = createXbfFintConstant();
        xbfFintConstant_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFintConstant_);
    }

    /**
     * Creates a <code>XbfFrealConstant</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrealConstant
     */
    public XbfFrealConstant createXbfFrealConstant(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFrealConstant xbfFrealConstant_ = createXbfFrealConstant();
        xbfFrealConstant_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFrealConstant_);
    }

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterConstant
     */
    public XbfFcharacterConstant createXbfFcharacterConstant(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFcharacterConstant xbfFcharacterConstant_ = createXbfFcharacterConstant();
        xbfFcharacterConstant_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcharacterConstant_);
    }

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFlogicalConstant
     */
    public XbfFlogicalConstant createXbfFlogicalConstant(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFlogicalConstant xbfFlogicalConstant_ = createXbfFlogicalConstant();
        xbfFlogicalConstant_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFlogicalConstant_);
    }

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcomplexConstant
     */
    public XbfFcomplexConstant createXbfFcomplexConstant(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFcomplexConstant xbfFcomplexConstant_ = createXbfFcomplexConstant();
        xbfFcomplexConstant_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcomplexConstant_);
    }

    /**
     * Creates a <code>XbfFstructConstructor</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructConstructor
     */
    public XbfFstructConstructor createXbfFstructConstructor(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructConstructor xbfFstructConstructor_ = createXbfFstructConstructor();
        xbfFstructConstructor_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructConstructor_);
    }

    /**
     * Creates a <code>XbfFunctionCall</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFunctionCall
     */
    public XbfFunctionCall createXbfFunctionCall(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFunctionCall xbfFunctionCall_ = createXbfFunctionCall();
        xbfFunctionCall_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFunctionCall_);
    }

    /**
     * Creates a <code>XbfArguments</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArguments
     */
    public XbfArguments createXbfArguments(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfArguments xbfArguments_ = createXbfArguments();
        xbfArguments_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfArguments_);
    }

    /**
     * Creates a <code>XbfNamedValue</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValue
     */
    public XbfNamedValue createXbfNamedValue(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfNamedValue xbfNamedValue_ = createXbfNamedValue();
        xbfNamedValue_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfNamedValue_);
    }

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserUnaryExpr
     */
    public XbfUserUnaryExpr createXbfUserUnaryExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfUserUnaryExpr xbfUserUnaryExpr_ = createXbfUserUnaryExpr();
        xbfUserUnaryExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUserUnaryExpr_);
    }

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserBinaryExpr
     */
    public XbfUserBinaryExpr createXbfUserBinaryExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfUserBinaryExpr xbfUserBinaryExpr_ = createXbfUserBinaryExpr();
        xbfUserBinaryExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUserBinaryExpr_);
    }

    /**
     * Creates a <code>XbfLogNotExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNotExpr
     */
    public XbfLogNotExpr createXbfLogNotExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNotExpr xbfLogNotExpr_ = createXbfLogNotExpr();
        xbfLogNotExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNotExpr_);
    }

    /**
     * Creates a <code>XbfFfunction</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunction
     */
    public XbfFfunction createXbfFfunction(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunction xbfFfunction_ = createXbfFfunction();
        xbfFfunction_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunction_);
    }

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQExpr
     */
    public XbfLogNEQExpr createXbfLogNEQExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNEQExpr xbfLogNEQExpr_ = createXbfLogNEQExpr();
        xbfLogNEQExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGTExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGTExpr
     */
    public XbfLogGTExpr createXbfLogGTExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLogGTExpr xbfLogGTExpr_ = createXbfLogGTExpr();
        xbfLogGTExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogGTExpr_);
    }

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQVExpr
     */
    public XbfLogNEQVExpr createXbfLogNEQVExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNEQVExpr xbfLogNEQVExpr_ = createXbfLogNEQVExpr();
        xbfLogNEQVExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNEQVExpr_);
    }

    /**
     * Creates a <code>XbfPlusExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfPlusExpr
     */
    public XbfPlusExpr createXbfPlusExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfPlusExpr xbfPlusExpr_ = createXbfPlusExpr();
        xbfPlusExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfPlusExpr_);
    }

    /**
     * Creates a <code>XbfMinusExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMinusExpr
     */
    public XbfMinusExpr createXbfMinusExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfMinusExpr xbfMinusExpr_ = createXbfMinusExpr();
        xbfMinusExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfMinusExpr_);
    }

    /**
     * Creates a <code>XbfMulExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMulExpr
     */
    public XbfMulExpr createXbfMulExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfMulExpr xbfMulExpr_ = createXbfMulExpr();
        xbfMulExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfMulExpr_);
    }

    /**
     * Creates a <code>XbfDivExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDivExpr
     */
    public XbfDivExpr createXbfDivExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfDivExpr xbfDivExpr_ = createXbfDivExpr();
        xbfDivExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfDivExpr_);
    }

    /**
     * Creates a <code>XbfFpowerExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpowerExpr
     */
    public XbfFpowerExpr createXbfFpowerExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFpowerExpr xbfFpowerExpr_ = createXbfFpowerExpr();
        xbfFpowerExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpowerExpr_);
    }

    /**
     * Creates a <code>XbfFconcatExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFconcatExpr
     */
    public XbfFconcatExpr createXbfFconcatExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFconcatExpr xbfFconcatExpr_ = createXbfFconcatExpr();
        xbfFconcatExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFconcatExpr_);
    }

    /**
     * Creates a <code>XbfLogEQExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQExpr
     */
    public XbfLogEQExpr createXbfLogEQExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLogEQExpr xbfLogEQExpr_ = createXbfLogEQExpr();
        xbfLogEQExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGEExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGEExpr
     */
    public XbfLogGEExpr createXbfLogGEExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLogGEExpr xbfLogGEExpr_ = createXbfLogGEExpr();
        xbfLogGEExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogGEExpr_);
    }

    /**
     * Creates a <code>XbfLogLEExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLEExpr
     */
    public XbfLogLEExpr createXbfLogLEExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLogLEExpr xbfLogLEExpr_ = createXbfLogLEExpr();
        xbfLogLEExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogLEExpr_);
    }

    /**
     * Creates a <code>XbfLogLTExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLTExpr
     */
    public XbfLogLTExpr createXbfLogLTExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLogLTExpr xbfLogLTExpr_ = createXbfLogLTExpr();
        xbfLogLTExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogLTExpr_);
    }

    /**
     * Creates a <code>XbfLogAndExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogAndExpr
     */
    public XbfLogAndExpr createXbfLogAndExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLogAndExpr xbfLogAndExpr_ = createXbfLogAndExpr();
        xbfLogAndExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogAndExpr_);
    }

    /**
     * Creates a <code>XbfLogOrExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogOrExpr
     */
    public XbfLogOrExpr createXbfLogOrExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLogOrExpr xbfLogOrExpr_ = createXbfLogOrExpr();
        xbfLogOrExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogOrExpr_);
    }

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQVExpr
     */
    public XbfLogEQVExpr createXbfLogEQVExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLogEQVExpr xbfLogEQVExpr_ = createXbfLogEQVExpr();
        xbfLogEQVExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogEQVExpr_);
    }

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUnaryMinusExpr
     */
    public XbfUnaryMinusExpr createXbfUnaryMinusExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfUnaryMinusExpr xbfUnaryMinusExpr_ = createXbfUnaryMinusExpr();
        xbfUnaryMinusExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbfLen</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLen
     */
    public XbfLen createXbfLen(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfLen xbfLen_ = createXbfLen();
        xbfLen_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLen_);
    }

    /**
     * Creates a <code>XbfCoShape</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCoShape
     */
    public XbfCoShape createXbfCoShape(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfCoShape xbfCoShape_ = createXbfCoShape();
        xbfCoShape_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfCoShape_);
    }

    /**
     * Creates a <code>XbfFstructType</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructType
     */
    public XbfFstructType createXbfFstructType(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructType xbfFstructType_ = createXbfFstructType();
        xbfFstructType_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructType_);
    }

    /**
     * Creates a <code>XbfSymbols</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfSymbols
     */
    public XbfSymbols createXbfSymbols(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfSymbols xbfSymbols_ = createXbfSymbols();
        xbfSymbols_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfSymbols_);
    }

    /**
     * Creates a <code>XbfId</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfId
     */
    public XbfId createXbfId(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfId xbfId_ = createXbfId();
        xbfId_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfId_);
    }

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalSymbols
     */
    public XbfGlobalSymbols createXbfGlobalSymbols(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfGlobalSymbols xbfGlobalSymbols_ = createXbfGlobalSymbols();
        xbfGlobalSymbols_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGlobalSymbols_);
    }

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalDeclarations
     */
    public XbfGlobalDeclarations createXbfGlobalDeclarations(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfGlobalDeclarations xbfGlobalDeclarations_ = createXbfGlobalDeclarations();
        xbfGlobalDeclarations_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDefinition
     */
    public XbfFfunctionDefinition createXbfFfunctionDefinition(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionDefinition xbfFfunctionDefinition_ = createXbfFfunctionDefinition();
        xbfFfunctionDefinition_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionDefinition_);
    }

    /**
     * Creates a <code>XbfDeclarations</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDeclarations
     */
    public XbfDeclarations createXbfDeclarations(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfDeclarations xbfDeclarations_ = createXbfDeclarations();
        xbfDeclarations_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfDeclarations_);
    }

    /**
     * Creates a <code>XbfVarDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarDecl
     */
    public XbfVarDecl createXbfVarDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfVarDecl xbfVarDecl_ = createXbfVarDecl();
        xbfVarDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarDecl_);
    }

    /**
     * Creates a <code>XbfExternDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExternDecl
     */
    public XbfExternDecl createXbfExternDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfExternDecl xbfExternDecl_ = createXbfExternDecl();
        xbfExternDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfExternDecl_);
    }

    /**
     * Creates a <code>XbfFuseDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseDecl
     */
    public XbfFuseDecl createXbfFuseDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFuseDecl xbfFuseDecl_ = createXbfFuseDecl();
        xbfFuseDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFuseDecl_);
    }

    /**
     * Creates a <code>XbfRename</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRename
     */
    public XbfRename createXbfRename(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfRename xbfRename_ = createXbfRename();
        xbfRename_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRename_);
    }

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseOnlyDecl
     */
    public XbfFuseOnlyDecl createXbfFuseOnlyDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFuseOnlyDecl xbfFuseOnlyDecl_ = createXbfFuseOnlyDecl();
        xbfFuseOnlyDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFuseOnlyDecl_);
    }

    /**
     * Creates a <code>XbfRenamable</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRenamable
     */
    public XbfRenamable createXbfRenamable(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfRenamable xbfRenamable_ = createXbfRenamable();
        xbfRenamable_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRenamable_);
    }

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinterfaceDecl
     */
    public XbfFinterfaceDecl createXbfFinterfaceDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFinterfaceDecl xbfFinterfaceDecl_ = createXbfFinterfaceDecl();
        xbfFinterfaceDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFinterfaceDecl_);
    }

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDecl
     */
    public XbfFfunctionDecl createXbfFfunctionDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionDecl xbfFfunctionDecl_ = createXbfFfunctionDecl();
        xbfFfunctionDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionDecl_);
    }

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleProcedureDecl
     */
    public XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFmoduleProcedureDecl xbfFmoduleProcedureDecl_ = createXbfFmoduleProcedureDecl();
        xbfFmoduleProcedureDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmoduleProcedureDecl_);
    }

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnamelistDecl
     */
    public XbfFnamelistDecl createXbfFnamelistDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFnamelistDecl xbfFnamelistDecl_ = createXbfFnamelistDecl();
        xbfFnamelistDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFnamelistDecl_);
    }

    /**
     * Creates a <code>XbfVarList</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarList
     */
    public XbfVarList createXbfVarList(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfVarList xbfVarList_ = createXbfVarList();
        xbfVarList_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarList_);
    }

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFequivalenceDecl
     */
    public XbfFequivalenceDecl createXbfFequivalenceDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFequivalenceDecl xbfFequivalenceDecl_ = createXbfFequivalenceDecl();
        xbfFequivalenceDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFequivalenceDecl_);
    }

    /**
     * Creates a <code>XbfFcommonDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcommonDecl
     */
    public XbfFcommonDecl createXbfFcommonDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFcommonDecl xbfFcommonDecl_ = createXbfFcommonDecl();
        xbfFcommonDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcommonDecl_);
    }

    /**
     * Creates a <code>XbfFstructDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructDecl
     */
    public XbfFstructDecl createXbfFstructDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructDecl xbfFstructDecl_ = createXbfFstructDecl();
        xbfFstructDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructDecl_);
    }

    /**
     * Creates a <code>XbfFentryDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFentryDecl
     */
    public XbfFentryDecl createXbfFentryDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFentryDecl xbfFentryDecl_ = createXbfFentryDecl();
        xbfFentryDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFentryDecl_);
    }

    /**
     * Creates a <code>XbfFdataDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdataDecl
     */
    public XbfFdataDecl createXbfFdataDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFdataDecl xbfFdataDecl_ = createXbfFdataDecl();
        xbfFdataDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdataDecl_);
    }

    /**
     * Creates a <code>XbfValueList</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValueList
     */
    public XbfValueList createXbfValueList(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfValueList xbfValueList_ = createXbfValueList();
        xbfValueList_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfValueList_);
    }

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpragmaStatement
     */
    public XbfFpragmaStatement createXbfFpragmaStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFpragmaStatement xbfFpragmaStatement_ = createXbfFpragmaStatement();
        xbfFpragmaStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpragmaStatement_);
    }

    /**
     * Creates a <code>XbfBody</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfBody
     */
    public XbfBody createXbfBody(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfBody xbfBody_ = createXbfBody();
        xbfBody_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfBody_);
    }

    /**
     * Creates a <code>XbfGotoStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGotoStatement
     */
    public XbfGotoStatement createXbfGotoStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfGotoStatement xbfGotoStatement_ = createXbfGotoStatement();
        xbfGotoStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGotoStatement_);
    }

    /**
     * Creates a <code>XbfFpauseStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpauseStatement
     */
    public XbfFpauseStatement createXbfFpauseStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFpauseStatement xbfFpauseStatement_ = createXbfFpauseStatement();
        xbfFpauseStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpauseStatement_);
    }

    /**
     * Creates a <code>XbfFcycleStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcycleStatement
     */
    public XbfFcycleStatement createXbfFcycleStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFcycleStatement xbfFcycleStatement_ = createXbfFcycleStatement();
        xbfFcycleStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcycleStatement_);
    }

    /**
     * Creates a <code>XbfFreadStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreadStatement
     */
    public XbfFreadStatement createXbfFreadStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFreadStatement xbfFreadStatement_ = createXbfFreadStatement();
        xbfFreadStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFreadStatement_);
    }

    /**
     * Creates a <code>XbfNamedValueList</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValueList
     */
    public XbfNamedValueList createXbfNamedValueList(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfNamedValueList xbfNamedValueList_ = createXbfNamedValueList();
        xbfNamedValueList_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfNamedValueList_);
    }

    /**
     * Creates a <code>XbfFcloseStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcloseStatement
     */
    public XbfFcloseStatement createXbfFcloseStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFcloseStatement xbfFcloseStatement_ = createXbfFcloseStatement();
        xbfFcloseStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcloseStatement_);
    }

    /**
     * Creates a <code>XbfFopenStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFopenStatement
     */
    public XbfFopenStatement createXbfFopenStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFopenStatement xbfFopenStatement_ = createXbfFopenStatement();
        xbfFopenStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFopenStatement_);
    }

    /**
     * Creates a <code>XbfFassignStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFassignStatement
     */
    public XbfFassignStatement createXbfFassignStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFassignStatement xbfFassignStatement_ = createXbfFassignStatement();
        xbfFassignStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFassignStatement_);
    }

    /**
     * Creates a <code>XbfExprStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExprStatement
     */
    public XbfExprStatement createXbfExprStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfExprStatement xbfExprStatement_ = createXbfExprStatement();
        xbfExprStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfExprStatement_);
    }

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpointerAssignStatement
     */
    public XbfFpointerAssignStatement createXbfFpointerAssignStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFpointerAssignStatement xbfFpointerAssignStatement_ = createXbfFpointerAssignStatement();
        xbfFpointerAssignStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpointerAssignStatement_);
    }

    /**
     * Creates a <code>XbfFifStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFifStatement
     */
    public XbfFifStatement createXbfFifStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFifStatement xbfFifStatement_ = createXbfFifStatement();
        xbfFifStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFifStatement_);
    }

    /**
     * Creates a <code>XbfCondition</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCondition
     */
    public XbfCondition createXbfCondition(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfCondition xbfCondition_ = createXbfCondition();
        xbfCondition_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfCondition_);
    }

    /**
     * Creates a <code>XbfThen</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfThen
     */
    public XbfThen createXbfThen(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfThen xbfThen_ = createXbfThen();
        xbfThen_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfThen_);
    }

    /**
     * Creates a <code>XbfElse</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfElse
     */
    public XbfElse createXbfElse(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfElse xbfElse_ = createXbfElse();
        xbfElse_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfElse_);
    }

    /**
     * Creates a <code>XbfFdoStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoStatement
     */
    public XbfFdoStatement createXbfFdoStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoStatement xbfFdoStatement_ = createXbfFdoStatement();
        xbfFdoStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoStatement_);
    }

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoWhileStatement
     */
    public XbfFdoWhileStatement createXbfFdoWhileStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoWhileStatement xbfFdoWhileStatement_ = createXbfFdoWhileStatement();
        xbfFdoWhileStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoWhileStatement_);
    }

    /**
     * Creates a <code>XbfContinueStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfContinueStatement
     */
    public XbfContinueStatement createXbfContinueStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfContinueStatement xbfContinueStatement_ = createXbfContinueStatement();
        xbfContinueStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfContinueStatement_);
    }

    /**
     * Creates a <code>XbfFexitStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFexitStatement
     */
    public XbfFexitStatement createXbfFexitStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFexitStatement xbfFexitStatement_ = createXbfFexitStatement();
        xbfFexitStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFexitStatement_);
    }

    /**
     * Creates a <code>XbfFreturnStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreturnStatement
     */
    public XbfFreturnStatement createXbfFreturnStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFreturnStatement xbfFreturnStatement_ = createXbfFreturnStatement();
        xbfFreturnStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFreturnStatement_);
    }

    /**
     * Creates a <code>XbfStatementLabel</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStatementLabel
     */
    public XbfStatementLabel createXbfStatementLabel(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfStatementLabel xbfStatementLabel_ = createXbfStatementLabel();
        xbfStatementLabel_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfStatementLabel_);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFselectCaseStatement
     */
    public XbfFselectCaseStatement createXbfFselectCaseStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFselectCaseStatement xbfFselectCaseStatement_ = createXbfFselectCaseStatement();
        xbfFselectCaseStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFselectCaseStatement_);
    }

    /**
     * Creates a <code>XbfFcaseLabel</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcaseLabel
     */
    public XbfFcaseLabel createXbfFcaseLabel(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFcaseLabel xbfFcaseLabel_ = createXbfFcaseLabel();
        xbfFcaseLabel_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcaseLabel_);
    }

    /**
     * Creates a <code>XbfFwhereStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwhereStatement
     */
    public XbfFwhereStatement createXbfFwhereStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFwhereStatement xbfFwhereStatement_ = createXbfFwhereStatement();
        xbfFwhereStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFwhereStatement_);
    }

    /**
     * Creates a <code>XbfFstopStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstopStatement
     */
    public XbfFstopStatement createXbfFstopStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFstopStatement xbfFstopStatement_ = createXbfFstopStatement();
        xbfFstopStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstopStatement_);
    }

    /**
     * Creates a <code>XbfFwriteStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwriteStatement
     */
    public XbfFwriteStatement createXbfFwriteStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFwriteStatement xbfFwriteStatement_ = createXbfFwriteStatement();
        xbfFwriteStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFwriteStatement_);
    }

    /**
     * Creates a <code>XbfFprintStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFprintStatement
     */
    public XbfFprintStatement createXbfFprintStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFprintStatement xbfFprintStatement_ = createXbfFprintStatement();
        xbfFprintStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFprintStatement_);
    }

    /**
     * Creates a <code>XbfFrewindStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrewindStatement
     */
    public XbfFrewindStatement createXbfFrewindStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFrewindStatement xbfFrewindStatement_ = createXbfFrewindStatement();
        xbfFrewindStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFrewindStatement_);
    }

    /**
     * Creates a <code>XbfFendFileStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFendFileStatement
     */
    public XbfFendFileStatement createXbfFendFileStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFendFileStatement xbfFendFileStatement_ = createXbfFendFileStatement();
        xbfFendFileStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFendFileStatement_);
    }

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbackspaceStatement
     */
    public XbfFbackspaceStatement createXbfFbackspaceStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFbackspaceStatement xbfFbackspaceStatement_ = createXbfFbackspaceStatement();
        xbfFbackspaceStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFbackspaceStatement_);
    }

    /**
     * Creates a <code>XbfFinquireStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinquireStatement
     */
    public XbfFinquireStatement createXbfFinquireStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFinquireStatement xbfFinquireStatement_ = createXbfFinquireStatement();
        xbfFinquireStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFinquireStatement_);
    }

    /**
     * Creates a <code>XbfFformatDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFformatDecl
     */
    public XbfFformatDecl createXbfFformatDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFformatDecl xbfFformatDecl_ = createXbfFformatDecl();
        xbfFformatDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFformatDecl_);
    }

    /**
     * Creates a <code>XbfFallocateStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFallocateStatement
     */
    public XbfFallocateStatement createXbfFallocateStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFallocateStatement xbfFallocateStatement_ = createXbfFallocateStatement();
        xbfFallocateStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFallocateStatement_);
    }

    /**
     * Creates a <code>XbfAlloc</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfAlloc
     */
    public XbfAlloc createXbfAlloc(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfAlloc xbfAlloc_ = createXbfAlloc();
        xbfAlloc_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfAlloc_);
    }

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdeallocateStatement
     */
    public XbfFdeallocateStatement createXbfFdeallocateStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFdeallocateStatement xbfFdeallocateStatement_ = createXbfFdeallocateStatement();
        xbfFdeallocateStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdeallocateStatement_);
    }

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnullifyStatement
     */
    public XbfFnullifyStatement createXbfFnullifyStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFnullifyStatement xbfFnullifyStatement_ = createXbfFnullifyStatement();
        xbfFnullifyStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFnullifyStatement_);
    }

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcontainsStatement
     */
    public XbfFcontainsStatement createXbfFcontainsStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFcontainsStatement xbfFcontainsStatement_ = createXbfFcontainsStatement();
        xbfFcontainsStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcontainsStatement_);
    }

    /**
     * Creates a <code>XbfText</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfText
     */
    public XbfText createXbfText(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfText xbfText_ = createXbfText();
        xbfText_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfText_);
    }

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleDefinition
     */
    public XbfFmoduleDefinition createXbfFmoduleDefinition(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFmoduleDefinition xbfFmoduleDefinition_ = createXbfFmoduleDefinition();
        xbfFmoduleDefinition_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmoduleDefinition_);
    }

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFblockDataDefinition
     */
    public XbfFblockDataDefinition createXbfFblockDataDefinition(File file) throws IOException, SAXException, ParserConfigurationException {
        XbfFblockDataDefinition xbfFblockDataDefinition_ = createXbfFblockDataDefinition();
        xbfFblockDataDefinition_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFblockDataDefinition_);
    }

    /**
     * Creates a <code>XbfXcodeProgram</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfXcodeProgram
     */
    public XbfXcodeProgram createXbfXcodeProgram(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfXcodeProgram xbfXcodeProgram_ = createXbfXcodeProgram();
        xbfXcodeProgram_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfXcodeProgram_);
    }

    /**
     * Creates a <code>XbfTypeTable</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfTypeTable
     */
    public XbfTypeTable createXbfTypeTable(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfTypeTable xbfTypeTable_ = createXbfTypeTable();
        xbfTypeTable_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfTypeTable_);
    }

    /**
     * Creates a <code>XbfFfunctionType</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionType
     */
    public XbfFfunctionType createXbfFfunctionType(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionType xbfFfunctionType_ = createXbfFfunctionType();
        xbfFfunctionType_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionType_);
    }

    /**
     * Creates a <code>XbfParams</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfParams
     */
    public XbfParams createXbfParams(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfParams xbfParams_ = createXbfParams();
        xbfParams_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfParams_);
    }

    /**
     * Creates a <code>XbfName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfName
     */
    public XbfName createXbfName(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfName xbfName_ = createXbfName();
        xbfName_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfName_);
    }

    /**
     * Creates a <code>XbfFbasicType</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbasicType
     */
    public XbfFbasicType createXbfFbasicType(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFbasicType xbfFbasicType_ = createXbfFbasicType();
        xbfFbasicType_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFbasicType_);
    }

    /**
     * Creates a <code>XbfKind</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfKind
     */
    public XbfKind createXbfKind(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfKind xbfKind_ = createXbfKind();
        xbfKind_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfKind_);
    }

    /**
     * Creates a <code>XbfFarrayRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayRef
     */
    public XbfFarrayRef createXbfFarrayRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFarrayRef xbfFarrayRef_ = createXbfFarrayRef();
        xbfFarrayRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFarrayRef_);
    }

    /**
     * Creates a <code>XbfVarRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarRef
     */
    public XbfVarRef createXbfVarRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfVarRef xbfVarRef_ = createXbfVarRef();
        xbfVarRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarRef_);
    }

    /**
     * Creates a <code>XbfFcharacterRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterRef
     */
    public XbfFcharacterRef createXbfFcharacterRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFcharacterRef xbfFcharacterRef_ = createXbfFcharacterRef();
        xbfFcharacterRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcharacterRef_);
    }

    /**
     * Creates a <code>XbfIndexRange</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfIndexRange
     */
    public XbfIndexRange createXbfIndexRange(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfIndexRange xbfIndexRange_ = createXbfIndexRange();
        xbfIndexRange_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfIndexRange_);
    }

    /**
     * Creates a <code>XbfLowerBound</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLowerBound
     */
    public XbfLowerBound createXbfLowerBound(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLowerBound xbfLowerBound_ = createXbfLowerBound();
        xbfLowerBound_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLowerBound_);
    }

    /**
     * Creates a <code>XbfUpperBound</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUpperBound
     */
    public XbfUpperBound createXbfUpperBound(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfUpperBound xbfUpperBound_ = createXbfUpperBound();
        xbfUpperBound_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUpperBound_);
    }

    /**
     * Creates a <code>XbfStep</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStep
     */
    public XbfStep createXbfStep(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfStep xbfStep_ = createXbfStep();
        xbfStep_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfStep_);
    }

    /**
     * Creates a <code>XbfFmemberRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmemberRef
     */
    public XbfFmemberRef createXbfFmemberRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFmemberRef xbfFmemberRef_ = createXbfFmemberRef();
        xbfFmemberRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmemberRef_);
    }

    /**
     * Creates a <code>XbfFcoArrayRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcoArrayRef
     */
    public XbfFcoArrayRef createXbfFcoArrayRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFcoArrayRef xbfFcoArrayRef_ = createXbfFcoArrayRef();
        xbfFcoArrayRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcoArrayRef_);
    }

    /**
     * Creates a <code>XbfArrayIndex</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArrayIndex
     */
    public XbfArrayIndex createXbfArrayIndex(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfArrayIndex xbfArrayIndex_ = createXbfArrayIndex();
        xbfArrayIndex_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfArrayIndex_);
    }

    /**
     * Creates a <code>XbfVar</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVar
     */
    public XbfVar createXbfVar(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfVar xbfVar_ = createXbfVar();
        xbfVar_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVar_);
    }

    /**
     * Creates a <code>XbfFarrayConstructor</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayConstructor
     */
    public XbfFarrayConstructor createXbfFarrayConstructor(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFarrayConstructor xbfFarrayConstructor_ = createXbfFarrayConstructor();
        xbfFarrayConstructor_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFarrayConstructor_);
    }

    /**
     * Creates a <code>XbfFdoLoop</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoLoop
     */
    public XbfFdoLoop createXbfFdoLoop(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoLoop xbfFdoLoop_ = createXbfFdoLoop();
        xbfFdoLoop_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoLoop_);
    }

    /**
     * Creates a <code>XbfValue</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValue
     */
    public XbfValue createXbfValue(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfValue xbfValue_ = createXbfValue();
        xbfValue_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfValue_);
    }

    /**
     * Creates a <code>XbfRepeatCount</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRepeatCount
     */
    public XbfRepeatCount createXbfRepeatCount(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfRepeatCount xbfRepeatCount_ = createXbfRepeatCount();
        xbfRepeatCount_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRepeatCount_);
    }

    /**
     * Creates a <code>XbfFintConstant</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFintConstant
     */
    public XbfFintConstant createXbfFintConstant(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFintConstant xbfFintConstant_ = createXbfFintConstant();
        xbfFintConstant_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFintConstant_);
    }

    /**
     * Creates a <code>XbfFrealConstant</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrealConstant
     */
    public XbfFrealConstant createXbfFrealConstant(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFrealConstant xbfFrealConstant_ = createXbfFrealConstant();
        xbfFrealConstant_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFrealConstant_);
    }

    /**
     * Creates a <code>XbfFcharacterConstant</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterConstant
     */
    public XbfFcharacterConstant createXbfFcharacterConstant(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFcharacterConstant xbfFcharacterConstant_ = createXbfFcharacterConstant();
        xbfFcharacterConstant_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcharacterConstant_);
    }

    /**
     * Creates a <code>XbfFlogicalConstant</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFlogicalConstant
     */
    public XbfFlogicalConstant createXbfFlogicalConstant(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFlogicalConstant xbfFlogicalConstant_ = createXbfFlogicalConstant();
        xbfFlogicalConstant_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFlogicalConstant_);
    }

    /**
     * Creates a <code>XbfFcomplexConstant</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcomplexConstant
     */
    public XbfFcomplexConstant createXbfFcomplexConstant(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFcomplexConstant xbfFcomplexConstant_ = createXbfFcomplexConstant();
        xbfFcomplexConstant_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcomplexConstant_);
    }

    /**
     * Creates a <code>XbfFstructConstructor</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructConstructor
     */
    public XbfFstructConstructor createXbfFstructConstructor(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructConstructor xbfFstructConstructor_ = createXbfFstructConstructor();
        xbfFstructConstructor_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructConstructor_);
    }

    /**
     * Creates a <code>XbfFunctionCall</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFunctionCall
     */
    public XbfFunctionCall createXbfFunctionCall(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFunctionCall xbfFunctionCall_ = createXbfFunctionCall();
        xbfFunctionCall_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFunctionCall_);
    }

    /**
     * Creates a <code>XbfArguments</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArguments
     */
    public XbfArguments createXbfArguments(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfArguments xbfArguments_ = createXbfArguments();
        xbfArguments_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfArguments_);
    }

    /**
     * Creates a <code>XbfNamedValue</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValue
     */
    public XbfNamedValue createXbfNamedValue(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfNamedValue xbfNamedValue_ = createXbfNamedValue();
        xbfNamedValue_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfNamedValue_);
    }

    /**
     * Creates a <code>XbfUserUnaryExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserUnaryExpr
     */
    public XbfUserUnaryExpr createXbfUserUnaryExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfUserUnaryExpr xbfUserUnaryExpr_ = createXbfUserUnaryExpr();
        xbfUserUnaryExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUserUnaryExpr_);
    }

    /**
     * Creates a <code>XbfUserBinaryExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserBinaryExpr
     */
    public XbfUserBinaryExpr createXbfUserBinaryExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfUserBinaryExpr xbfUserBinaryExpr_ = createXbfUserBinaryExpr();
        xbfUserBinaryExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUserBinaryExpr_);
    }

    /**
     * Creates a <code>XbfLogNotExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNotExpr
     */
    public XbfLogNotExpr createXbfLogNotExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNotExpr xbfLogNotExpr_ = createXbfLogNotExpr();
        xbfLogNotExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNotExpr_);
    }

    /**
     * Creates a <code>XbfFfunction</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunction
     */
    public XbfFfunction createXbfFfunction(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunction xbfFfunction_ = createXbfFfunction();
        xbfFfunction_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunction_);
    }

    /**
     * Creates a <code>XbfLogNEQExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQExpr
     */
    public XbfLogNEQExpr createXbfLogNEQExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNEQExpr xbfLogNEQExpr_ = createXbfLogNEQExpr();
        xbfLogNEQExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGTExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGTExpr
     */
    public XbfLogGTExpr createXbfLogGTExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLogGTExpr xbfLogGTExpr_ = createXbfLogGTExpr();
        xbfLogGTExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogGTExpr_);
    }

    /**
     * Creates a <code>XbfLogNEQVExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQVExpr
     */
    public XbfLogNEQVExpr createXbfLogNEQVExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNEQVExpr xbfLogNEQVExpr_ = createXbfLogNEQVExpr();
        xbfLogNEQVExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNEQVExpr_);
    }

    /**
     * Creates a <code>XbfPlusExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfPlusExpr
     */
    public XbfPlusExpr createXbfPlusExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfPlusExpr xbfPlusExpr_ = createXbfPlusExpr();
        xbfPlusExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfPlusExpr_);
    }

    /**
     * Creates a <code>XbfMinusExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMinusExpr
     */
    public XbfMinusExpr createXbfMinusExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfMinusExpr xbfMinusExpr_ = createXbfMinusExpr();
        xbfMinusExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfMinusExpr_);
    }

    /**
     * Creates a <code>XbfMulExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMulExpr
     */
    public XbfMulExpr createXbfMulExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfMulExpr xbfMulExpr_ = createXbfMulExpr();
        xbfMulExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfMulExpr_);
    }

    /**
     * Creates a <code>XbfDivExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDivExpr
     */
    public XbfDivExpr createXbfDivExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfDivExpr xbfDivExpr_ = createXbfDivExpr();
        xbfDivExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfDivExpr_);
    }

    /**
     * Creates a <code>XbfFpowerExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpowerExpr
     */
    public XbfFpowerExpr createXbfFpowerExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFpowerExpr xbfFpowerExpr_ = createXbfFpowerExpr();
        xbfFpowerExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpowerExpr_);
    }

    /**
     * Creates a <code>XbfFconcatExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFconcatExpr
     */
    public XbfFconcatExpr createXbfFconcatExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFconcatExpr xbfFconcatExpr_ = createXbfFconcatExpr();
        xbfFconcatExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFconcatExpr_);
    }

    /**
     * Creates a <code>XbfLogEQExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQExpr
     */
    public XbfLogEQExpr createXbfLogEQExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLogEQExpr xbfLogEQExpr_ = createXbfLogEQExpr();
        xbfLogEQExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGEExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGEExpr
     */
    public XbfLogGEExpr createXbfLogGEExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLogGEExpr xbfLogGEExpr_ = createXbfLogGEExpr();
        xbfLogGEExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogGEExpr_);
    }

    /**
     * Creates a <code>XbfLogLEExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLEExpr
     */
    public XbfLogLEExpr createXbfLogLEExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLogLEExpr xbfLogLEExpr_ = createXbfLogLEExpr();
        xbfLogLEExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogLEExpr_);
    }

    /**
     * Creates a <code>XbfLogLTExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLTExpr
     */
    public XbfLogLTExpr createXbfLogLTExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLogLTExpr xbfLogLTExpr_ = createXbfLogLTExpr();
        xbfLogLTExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogLTExpr_);
    }

    /**
     * Creates a <code>XbfLogAndExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogAndExpr
     */
    public XbfLogAndExpr createXbfLogAndExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLogAndExpr xbfLogAndExpr_ = createXbfLogAndExpr();
        xbfLogAndExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogAndExpr_);
    }

    /**
     * Creates a <code>XbfLogOrExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogOrExpr
     */
    public XbfLogOrExpr createXbfLogOrExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLogOrExpr xbfLogOrExpr_ = createXbfLogOrExpr();
        xbfLogOrExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogOrExpr_);
    }

    /**
     * Creates a <code>XbfLogEQVExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQVExpr
     */
    public XbfLogEQVExpr createXbfLogEQVExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLogEQVExpr xbfLogEQVExpr_ = createXbfLogEQVExpr();
        xbfLogEQVExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogEQVExpr_);
    }

    /**
     * Creates a <code>XbfUnaryMinusExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUnaryMinusExpr
     */
    public XbfUnaryMinusExpr createXbfUnaryMinusExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfUnaryMinusExpr xbfUnaryMinusExpr_ = createXbfUnaryMinusExpr();
        xbfUnaryMinusExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbfLen</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLen
     */
    public XbfLen createXbfLen(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfLen xbfLen_ = createXbfLen();
        xbfLen_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLen_);
    }

    /**
     * Creates a <code>XbfCoShape</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCoShape
     */
    public XbfCoShape createXbfCoShape(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfCoShape xbfCoShape_ = createXbfCoShape();
        xbfCoShape_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfCoShape_);
    }

    /**
     * Creates a <code>XbfFstructType</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructType
     */
    public XbfFstructType createXbfFstructType(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructType xbfFstructType_ = createXbfFstructType();
        xbfFstructType_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructType_);
    }

    /**
     * Creates a <code>XbfSymbols</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfSymbols
     */
    public XbfSymbols createXbfSymbols(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfSymbols xbfSymbols_ = createXbfSymbols();
        xbfSymbols_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfSymbols_);
    }

    /**
     * Creates a <code>XbfId</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfId
     */
    public XbfId createXbfId(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfId xbfId_ = createXbfId();
        xbfId_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfId_);
    }

    /**
     * Creates a <code>XbfGlobalSymbols</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalSymbols
     */
    public XbfGlobalSymbols createXbfGlobalSymbols(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfGlobalSymbols xbfGlobalSymbols_ = createXbfGlobalSymbols();
        xbfGlobalSymbols_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGlobalSymbols_);
    }

    /**
     * Creates a <code>XbfGlobalDeclarations</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalDeclarations
     */
    public XbfGlobalDeclarations createXbfGlobalDeclarations(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfGlobalDeclarations xbfGlobalDeclarations_ = createXbfGlobalDeclarations();
        xbfGlobalDeclarations_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbfFfunctionDefinition</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDefinition
     */
    public XbfFfunctionDefinition createXbfFfunctionDefinition(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionDefinition xbfFfunctionDefinition_ = createXbfFfunctionDefinition();
        xbfFfunctionDefinition_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionDefinition_);
    }

    /**
     * Creates a <code>XbfDeclarations</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDeclarations
     */
    public XbfDeclarations createXbfDeclarations(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfDeclarations xbfDeclarations_ = createXbfDeclarations();
        xbfDeclarations_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfDeclarations_);
    }

    /**
     * Creates a <code>XbfVarDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarDecl
     */
    public XbfVarDecl createXbfVarDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfVarDecl xbfVarDecl_ = createXbfVarDecl();
        xbfVarDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarDecl_);
    }

    /**
     * Creates a <code>XbfExternDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExternDecl
     */
    public XbfExternDecl createXbfExternDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfExternDecl xbfExternDecl_ = createXbfExternDecl();
        xbfExternDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfExternDecl_);
    }

    /**
     * Creates a <code>XbfFuseDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseDecl
     */
    public XbfFuseDecl createXbfFuseDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFuseDecl xbfFuseDecl_ = createXbfFuseDecl();
        xbfFuseDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFuseDecl_);
    }

    /**
     * Creates a <code>XbfRename</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRename
     */
    public XbfRename createXbfRename(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfRename xbfRename_ = createXbfRename();
        xbfRename_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRename_);
    }

    /**
     * Creates a <code>XbfFuseOnlyDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseOnlyDecl
     */
    public XbfFuseOnlyDecl createXbfFuseOnlyDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFuseOnlyDecl xbfFuseOnlyDecl_ = createXbfFuseOnlyDecl();
        xbfFuseOnlyDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFuseOnlyDecl_);
    }

    /**
     * Creates a <code>XbfRenamable</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRenamable
     */
    public XbfRenamable createXbfRenamable(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfRenamable xbfRenamable_ = createXbfRenamable();
        xbfRenamable_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRenamable_);
    }

    /**
     * Creates a <code>XbfFinterfaceDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinterfaceDecl
     */
    public XbfFinterfaceDecl createXbfFinterfaceDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFinterfaceDecl xbfFinterfaceDecl_ = createXbfFinterfaceDecl();
        xbfFinterfaceDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFinterfaceDecl_);
    }

    /**
     * Creates a <code>XbfFfunctionDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDecl
     */
    public XbfFfunctionDecl createXbfFfunctionDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionDecl xbfFfunctionDecl_ = createXbfFfunctionDecl();
        xbfFfunctionDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionDecl_);
    }

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleProcedureDecl
     */
    public XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFmoduleProcedureDecl xbfFmoduleProcedureDecl_ = createXbfFmoduleProcedureDecl();
        xbfFmoduleProcedureDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmoduleProcedureDecl_);
    }

    /**
     * Creates a <code>XbfFnamelistDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnamelistDecl
     */
    public XbfFnamelistDecl createXbfFnamelistDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFnamelistDecl xbfFnamelistDecl_ = createXbfFnamelistDecl();
        xbfFnamelistDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFnamelistDecl_);
    }

    /**
     * Creates a <code>XbfVarList</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarList
     */
    public XbfVarList createXbfVarList(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfVarList xbfVarList_ = createXbfVarList();
        xbfVarList_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarList_);
    }

    /**
     * Creates a <code>XbfFequivalenceDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFequivalenceDecl
     */
    public XbfFequivalenceDecl createXbfFequivalenceDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFequivalenceDecl xbfFequivalenceDecl_ = createXbfFequivalenceDecl();
        xbfFequivalenceDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFequivalenceDecl_);
    }

    /**
     * Creates a <code>XbfFcommonDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcommonDecl
     */
    public XbfFcommonDecl createXbfFcommonDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFcommonDecl xbfFcommonDecl_ = createXbfFcommonDecl();
        xbfFcommonDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcommonDecl_);
    }

    /**
     * Creates a <code>XbfFstructDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructDecl
     */
    public XbfFstructDecl createXbfFstructDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructDecl xbfFstructDecl_ = createXbfFstructDecl();
        xbfFstructDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructDecl_);
    }

    /**
     * Creates a <code>XbfFentryDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFentryDecl
     */
    public XbfFentryDecl createXbfFentryDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFentryDecl xbfFentryDecl_ = createXbfFentryDecl();
        xbfFentryDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFentryDecl_);
    }

    /**
     * Creates a <code>XbfFdataDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdataDecl
     */
    public XbfFdataDecl createXbfFdataDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFdataDecl xbfFdataDecl_ = createXbfFdataDecl();
        xbfFdataDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdataDecl_);
    }

    /**
     * Creates a <code>XbfValueList</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValueList
     */
    public XbfValueList createXbfValueList(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfValueList xbfValueList_ = createXbfValueList();
        xbfValueList_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfValueList_);
    }

    /**
     * Creates a <code>XbfFpragmaStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpragmaStatement
     */
    public XbfFpragmaStatement createXbfFpragmaStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFpragmaStatement xbfFpragmaStatement_ = createXbfFpragmaStatement();
        xbfFpragmaStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpragmaStatement_);
    }

    /**
     * Creates a <code>XbfBody</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfBody
     */
    public XbfBody createXbfBody(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfBody xbfBody_ = createXbfBody();
        xbfBody_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfBody_);
    }

    /**
     * Creates a <code>XbfGotoStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGotoStatement
     */
    public XbfGotoStatement createXbfGotoStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfGotoStatement xbfGotoStatement_ = createXbfGotoStatement();
        xbfGotoStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGotoStatement_);
    }

    /**
     * Creates a <code>XbfFpauseStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpauseStatement
     */
    public XbfFpauseStatement createXbfFpauseStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFpauseStatement xbfFpauseStatement_ = createXbfFpauseStatement();
        xbfFpauseStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpauseStatement_);
    }

    /**
     * Creates a <code>XbfFcycleStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcycleStatement
     */
    public XbfFcycleStatement createXbfFcycleStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFcycleStatement xbfFcycleStatement_ = createXbfFcycleStatement();
        xbfFcycleStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcycleStatement_);
    }

    /**
     * Creates a <code>XbfFreadStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreadStatement
     */
    public XbfFreadStatement createXbfFreadStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFreadStatement xbfFreadStatement_ = createXbfFreadStatement();
        xbfFreadStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFreadStatement_);
    }

    /**
     * Creates a <code>XbfNamedValueList</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValueList
     */
    public XbfNamedValueList createXbfNamedValueList(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfNamedValueList xbfNamedValueList_ = createXbfNamedValueList();
        xbfNamedValueList_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfNamedValueList_);
    }

    /**
     * Creates a <code>XbfFcloseStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcloseStatement
     */
    public XbfFcloseStatement createXbfFcloseStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFcloseStatement xbfFcloseStatement_ = createXbfFcloseStatement();
        xbfFcloseStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcloseStatement_);
    }

    /**
     * Creates a <code>XbfFopenStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFopenStatement
     */
    public XbfFopenStatement createXbfFopenStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFopenStatement xbfFopenStatement_ = createXbfFopenStatement();
        xbfFopenStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFopenStatement_);
    }

    /**
     * Creates a <code>XbfFassignStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFassignStatement
     */
    public XbfFassignStatement createXbfFassignStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFassignStatement xbfFassignStatement_ = createXbfFassignStatement();
        xbfFassignStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFassignStatement_);
    }

    /**
     * Creates a <code>XbfExprStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExprStatement
     */
    public XbfExprStatement createXbfExprStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfExprStatement xbfExprStatement_ = createXbfExprStatement();
        xbfExprStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfExprStatement_);
    }

    /**
     * Creates a <code>XbfFpointerAssignStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpointerAssignStatement
     */
    public XbfFpointerAssignStatement createXbfFpointerAssignStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFpointerAssignStatement xbfFpointerAssignStatement_ = createXbfFpointerAssignStatement();
        xbfFpointerAssignStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpointerAssignStatement_);
    }

    /**
     * Creates a <code>XbfFifStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFifStatement
     */
    public XbfFifStatement createXbfFifStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFifStatement xbfFifStatement_ = createXbfFifStatement();
        xbfFifStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFifStatement_);
    }

    /**
     * Creates a <code>XbfCondition</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCondition
     */
    public XbfCondition createXbfCondition(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfCondition xbfCondition_ = createXbfCondition();
        xbfCondition_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfCondition_);
    }

    /**
     * Creates a <code>XbfThen</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfThen
     */
    public XbfThen createXbfThen(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfThen xbfThen_ = createXbfThen();
        xbfThen_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfThen_);
    }

    /**
     * Creates a <code>XbfElse</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfElse
     */
    public XbfElse createXbfElse(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfElse xbfElse_ = createXbfElse();
        xbfElse_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfElse_);
    }

    /**
     * Creates a <code>XbfFdoStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoStatement
     */
    public XbfFdoStatement createXbfFdoStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoStatement xbfFdoStatement_ = createXbfFdoStatement();
        xbfFdoStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoStatement_);
    }

    /**
     * Creates a <code>XbfFdoWhileStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoWhileStatement
     */
    public XbfFdoWhileStatement createXbfFdoWhileStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoWhileStatement xbfFdoWhileStatement_ = createXbfFdoWhileStatement();
        xbfFdoWhileStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoWhileStatement_);
    }

    /**
     * Creates a <code>XbfContinueStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfContinueStatement
     */
    public XbfContinueStatement createXbfContinueStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfContinueStatement xbfContinueStatement_ = createXbfContinueStatement();
        xbfContinueStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfContinueStatement_);
    }

    /**
     * Creates a <code>XbfFexitStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFexitStatement
     */
    public XbfFexitStatement createXbfFexitStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFexitStatement xbfFexitStatement_ = createXbfFexitStatement();
        xbfFexitStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFexitStatement_);
    }

    /**
     * Creates a <code>XbfFreturnStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreturnStatement
     */
    public XbfFreturnStatement createXbfFreturnStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFreturnStatement xbfFreturnStatement_ = createXbfFreturnStatement();
        xbfFreturnStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFreturnStatement_);
    }

    /**
     * Creates a <code>XbfStatementLabel</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStatementLabel
     */
    public XbfStatementLabel createXbfStatementLabel(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfStatementLabel xbfStatementLabel_ = createXbfStatementLabel();
        xbfStatementLabel_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfStatementLabel_);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFselectCaseStatement
     */
    public XbfFselectCaseStatement createXbfFselectCaseStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFselectCaseStatement xbfFselectCaseStatement_ = createXbfFselectCaseStatement();
        xbfFselectCaseStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFselectCaseStatement_);
    }

    /**
     * Creates a <code>XbfFcaseLabel</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcaseLabel
     */
    public XbfFcaseLabel createXbfFcaseLabel(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFcaseLabel xbfFcaseLabel_ = createXbfFcaseLabel();
        xbfFcaseLabel_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcaseLabel_);
    }

    /**
     * Creates a <code>XbfFwhereStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwhereStatement
     */
    public XbfFwhereStatement createXbfFwhereStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFwhereStatement xbfFwhereStatement_ = createXbfFwhereStatement();
        xbfFwhereStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFwhereStatement_);
    }

    /**
     * Creates a <code>XbfFstopStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstopStatement
     */
    public XbfFstopStatement createXbfFstopStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFstopStatement xbfFstopStatement_ = createXbfFstopStatement();
        xbfFstopStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstopStatement_);
    }

    /**
     * Creates a <code>XbfFwriteStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwriteStatement
     */
    public XbfFwriteStatement createXbfFwriteStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFwriteStatement xbfFwriteStatement_ = createXbfFwriteStatement();
        xbfFwriteStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFwriteStatement_);
    }

    /**
     * Creates a <code>XbfFprintStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFprintStatement
     */
    public XbfFprintStatement createXbfFprintStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFprintStatement xbfFprintStatement_ = createXbfFprintStatement();
        xbfFprintStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFprintStatement_);
    }

    /**
     * Creates a <code>XbfFrewindStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrewindStatement
     */
    public XbfFrewindStatement createXbfFrewindStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFrewindStatement xbfFrewindStatement_ = createXbfFrewindStatement();
        xbfFrewindStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFrewindStatement_);
    }

    /**
     * Creates a <code>XbfFendFileStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFendFileStatement
     */
    public XbfFendFileStatement createXbfFendFileStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFendFileStatement xbfFendFileStatement_ = createXbfFendFileStatement();
        xbfFendFileStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFendFileStatement_);
    }

    /**
     * Creates a <code>XbfFbackspaceStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbackspaceStatement
     */
    public XbfFbackspaceStatement createXbfFbackspaceStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFbackspaceStatement xbfFbackspaceStatement_ = createXbfFbackspaceStatement();
        xbfFbackspaceStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFbackspaceStatement_);
    }

    /**
     * Creates a <code>XbfFinquireStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinquireStatement
     */
    public XbfFinquireStatement createXbfFinquireStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFinquireStatement xbfFinquireStatement_ = createXbfFinquireStatement();
        xbfFinquireStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFinquireStatement_);
    }

    /**
     * Creates a <code>XbfFformatDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFformatDecl
     */
    public XbfFformatDecl createXbfFformatDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFformatDecl xbfFformatDecl_ = createXbfFformatDecl();
        xbfFformatDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFformatDecl_);
    }

    /**
     * Creates a <code>XbfFallocateStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFallocateStatement
     */
    public XbfFallocateStatement createXbfFallocateStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFallocateStatement xbfFallocateStatement_ = createXbfFallocateStatement();
        xbfFallocateStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFallocateStatement_);
    }

    /**
     * Creates a <code>XbfAlloc</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfAlloc
     */
    public XbfAlloc createXbfAlloc(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfAlloc xbfAlloc_ = createXbfAlloc();
        xbfAlloc_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfAlloc_);
    }

    /**
     * Creates a <code>XbfFdeallocateStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdeallocateStatement
     */
    public XbfFdeallocateStatement createXbfFdeallocateStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFdeallocateStatement xbfFdeallocateStatement_ = createXbfFdeallocateStatement();
        xbfFdeallocateStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdeallocateStatement_);
    }

    /**
     * Creates a <code>XbfFnullifyStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnullifyStatement
     */
    public XbfFnullifyStatement createXbfFnullifyStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFnullifyStatement xbfFnullifyStatement_ = createXbfFnullifyStatement();
        xbfFnullifyStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFnullifyStatement_);
    }

    /**
     * Creates a <code>XbfFcontainsStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcontainsStatement
     */
    public XbfFcontainsStatement createXbfFcontainsStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFcontainsStatement xbfFcontainsStatement_ = createXbfFcontainsStatement();
        xbfFcontainsStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcontainsStatement_);
    }

    /**
     * Creates a <code>XbfText</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfText
     */
    public XbfText createXbfText(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfText xbfText_ = createXbfText();
        xbfText_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfText_);
    }

    /**
     * Creates a <code>XbfFmoduleDefinition</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleDefinition
     */
    public XbfFmoduleDefinition createXbfFmoduleDefinition(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFmoduleDefinition xbfFmoduleDefinition_ = createXbfFmoduleDefinition();
        xbfFmoduleDefinition_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmoduleDefinition_);
    }

    /**
     * Creates a <code>XbfFblockDataDefinition</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFblockDataDefinition
     */
    public XbfFblockDataDefinition createXbfFblockDataDefinition(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbfFblockDataDefinition xbfFblockDataDefinition_ = createXbfFblockDataDefinition();
        xbfFblockDataDefinition_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFblockDataDefinition_);
    }

    /**
     * Creates a <code>XbfXcodeProgram</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfXcodeProgram
     */
    public XbfXcodeProgram createXbfXcodeProgram(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfXcodeProgram xbfXcodeProgram_ = createXbfXcodeProgram();
        xbfXcodeProgram_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfXcodeProgram_);
    }

    /**
     * Creates a <code>XbfTypeTable</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfTypeTable
     */
    public XbfTypeTable createXbfTypeTable(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfTypeTable xbfTypeTable_ = createXbfTypeTable();
        xbfTypeTable_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfTypeTable_);
    }

    /**
     * Creates a <code>XbfFfunctionType</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionType
     */
    public XbfFfunctionType createXbfFfunctionType(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionType xbfFfunctionType_ = createXbfFfunctionType();
        xbfFfunctionType_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionType_);
    }

    /**
     * Creates a <code>XbfParams</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfParams
     */
    public XbfParams createXbfParams(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfParams xbfParams_ = createXbfParams();
        xbfParams_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfParams_);
    }

    /**
     * Creates a <code>XbfName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfName
     */
    public XbfName createXbfName(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfName xbfName_ = createXbfName();
        xbfName_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfName_);
    }

    /**
     * Creates a <code>XbfFbasicType</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbasicType
     */
    public XbfFbasicType createXbfFbasicType(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFbasicType xbfFbasicType_ = createXbfFbasicType();
        xbfFbasicType_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFbasicType_);
    }

    /**
     * Creates a <code>XbfKind</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfKind
     */
    public XbfKind createXbfKind(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfKind xbfKind_ = createXbfKind();
        xbfKind_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfKind_);
    }

    /**
     * Creates a <code>XbfFarrayRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayRef
     */
    public XbfFarrayRef createXbfFarrayRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFarrayRef xbfFarrayRef_ = createXbfFarrayRef();
        xbfFarrayRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFarrayRef_);
    }

    /**
     * Creates a <code>XbfVarRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarRef
     */
    public XbfVarRef createXbfVarRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfVarRef xbfVarRef_ = createXbfVarRef();
        xbfVarRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarRef_);
    }

    /**
     * Creates a <code>XbfFcharacterRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterRef
     */
    public XbfFcharacterRef createXbfFcharacterRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFcharacterRef xbfFcharacterRef_ = createXbfFcharacterRef();
        xbfFcharacterRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcharacterRef_);
    }

    /**
     * Creates a <code>XbfIndexRange</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfIndexRange
     */
    public XbfIndexRange createXbfIndexRange(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfIndexRange xbfIndexRange_ = createXbfIndexRange();
        xbfIndexRange_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfIndexRange_);
    }

    /**
     * Creates a <code>XbfLowerBound</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLowerBound
     */
    public XbfLowerBound createXbfLowerBound(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLowerBound xbfLowerBound_ = createXbfLowerBound();
        xbfLowerBound_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLowerBound_);
    }

    /**
     * Creates a <code>XbfUpperBound</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUpperBound
     */
    public XbfUpperBound createXbfUpperBound(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfUpperBound xbfUpperBound_ = createXbfUpperBound();
        xbfUpperBound_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUpperBound_);
    }

    /**
     * Creates a <code>XbfStep</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStep
     */
    public XbfStep createXbfStep(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfStep xbfStep_ = createXbfStep();
        xbfStep_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfStep_);
    }

    /**
     * Creates a <code>XbfFmemberRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmemberRef
     */
    public XbfFmemberRef createXbfFmemberRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFmemberRef xbfFmemberRef_ = createXbfFmemberRef();
        xbfFmemberRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmemberRef_);
    }

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcoArrayRef
     */
    public XbfFcoArrayRef createXbfFcoArrayRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFcoArrayRef xbfFcoArrayRef_ = createXbfFcoArrayRef();
        xbfFcoArrayRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcoArrayRef_);
    }

    /**
     * Creates a <code>XbfArrayIndex</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArrayIndex
     */
    public XbfArrayIndex createXbfArrayIndex(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfArrayIndex xbfArrayIndex_ = createXbfArrayIndex();
        xbfArrayIndex_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfArrayIndex_);
    }

    /**
     * Creates a <code>XbfVar</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVar
     */
    public XbfVar createXbfVar(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfVar xbfVar_ = createXbfVar();
        xbfVar_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVar_);
    }

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayConstructor
     */
    public XbfFarrayConstructor createXbfFarrayConstructor(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFarrayConstructor xbfFarrayConstructor_ = createXbfFarrayConstructor();
        xbfFarrayConstructor_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFarrayConstructor_);
    }

    /**
     * Creates a <code>XbfFdoLoop</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoLoop
     */
    public XbfFdoLoop createXbfFdoLoop(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoLoop xbfFdoLoop_ = createXbfFdoLoop();
        xbfFdoLoop_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoLoop_);
    }

    /**
     * Creates a <code>XbfValue</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValue
     */
    public XbfValue createXbfValue(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfValue xbfValue_ = createXbfValue();
        xbfValue_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfValue_);
    }

    /**
     * Creates a <code>XbfRepeatCount</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRepeatCount
     */
    public XbfRepeatCount createXbfRepeatCount(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfRepeatCount xbfRepeatCount_ = createXbfRepeatCount();
        xbfRepeatCount_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRepeatCount_);
    }

    /**
     * Creates a <code>XbfFintConstant</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFintConstant
     */
    public XbfFintConstant createXbfFintConstant(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFintConstant xbfFintConstant_ = createXbfFintConstant();
        xbfFintConstant_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFintConstant_);
    }

    /**
     * Creates a <code>XbfFrealConstant</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrealConstant
     */
    public XbfFrealConstant createXbfFrealConstant(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFrealConstant xbfFrealConstant_ = createXbfFrealConstant();
        xbfFrealConstant_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFrealConstant_);
    }

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterConstant
     */
    public XbfFcharacterConstant createXbfFcharacterConstant(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFcharacterConstant xbfFcharacterConstant_ = createXbfFcharacterConstant();
        xbfFcharacterConstant_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcharacterConstant_);
    }

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFlogicalConstant
     */
    public XbfFlogicalConstant createXbfFlogicalConstant(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFlogicalConstant xbfFlogicalConstant_ = createXbfFlogicalConstant();
        xbfFlogicalConstant_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFlogicalConstant_);
    }

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcomplexConstant
     */
    public XbfFcomplexConstant createXbfFcomplexConstant(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFcomplexConstant xbfFcomplexConstant_ = createXbfFcomplexConstant();
        xbfFcomplexConstant_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcomplexConstant_);
    }

    /**
     * Creates a <code>XbfFstructConstructor</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructConstructor
     */
    public XbfFstructConstructor createXbfFstructConstructor(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructConstructor xbfFstructConstructor_ = createXbfFstructConstructor();
        xbfFstructConstructor_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructConstructor_);
    }

    /**
     * Creates a <code>XbfFunctionCall</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFunctionCall
     */
    public XbfFunctionCall createXbfFunctionCall(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFunctionCall xbfFunctionCall_ = createXbfFunctionCall();
        xbfFunctionCall_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFunctionCall_);
    }

    /**
     * Creates a <code>XbfArguments</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArguments
     */
    public XbfArguments createXbfArguments(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfArguments xbfArguments_ = createXbfArguments();
        xbfArguments_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfArguments_);
    }

    /**
     * Creates a <code>XbfNamedValue</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValue
     */
    public XbfNamedValue createXbfNamedValue(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfNamedValue xbfNamedValue_ = createXbfNamedValue();
        xbfNamedValue_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfNamedValue_);
    }

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserUnaryExpr
     */
    public XbfUserUnaryExpr createXbfUserUnaryExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfUserUnaryExpr xbfUserUnaryExpr_ = createXbfUserUnaryExpr();
        xbfUserUnaryExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUserUnaryExpr_);
    }

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserBinaryExpr
     */
    public XbfUserBinaryExpr createXbfUserBinaryExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfUserBinaryExpr xbfUserBinaryExpr_ = createXbfUserBinaryExpr();
        xbfUserBinaryExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUserBinaryExpr_);
    }

    /**
     * Creates a <code>XbfLogNotExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNotExpr
     */
    public XbfLogNotExpr createXbfLogNotExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNotExpr xbfLogNotExpr_ = createXbfLogNotExpr();
        xbfLogNotExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNotExpr_);
    }

    /**
     * Creates a <code>XbfFfunction</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunction
     */
    public XbfFfunction createXbfFfunction(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunction xbfFfunction_ = createXbfFfunction();
        xbfFfunction_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunction_);
    }

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQExpr
     */
    public XbfLogNEQExpr createXbfLogNEQExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNEQExpr xbfLogNEQExpr_ = createXbfLogNEQExpr();
        xbfLogNEQExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGTExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGTExpr
     */
    public XbfLogGTExpr createXbfLogGTExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLogGTExpr xbfLogGTExpr_ = createXbfLogGTExpr();
        xbfLogGTExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogGTExpr_);
    }

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQVExpr
     */
    public XbfLogNEQVExpr createXbfLogNEQVExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNEQVExpr xbfLogNEQVExpr_ = createXbfLogNEQVExpr();
        xbfLogNEQVExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNEQVExpr_);
    }

    /**
     * Creates a <code>XbfPlusExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfPlusExpr
     */
    public XbfPlusExpr createXbfPlusExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfPlusExpr xbfPlusExpr_ = createXbfPlusExpr();
        xbfPlusExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfPlusExpr_);
    }

    /**
     * Creates a <code>XbfMinusExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMinusExpr
     */
    public XbfMinusExpr createXbfMinusExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfMinusExpr xbfMinusExpr_ = createXbfMinusExpr();
        xbfMinusExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfMinusExpr_);
    }

    /**
     * Creates a <code>XbfMulExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMulExpr
     */
    public XbfMulExpr createXbfMulExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfMulExpr xbfMulExpr_ = createXbfMulExpr();
        xbfMulExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfMulExpr_);
    }

    /**
     * Creates a <code>XbfDivExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDivExpr
     */
    public XbfDivExpr createXbfDivExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfDivExpr xbfDivExpr_ = createXbfDivExpr();
        xbfDivExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfDivExpr_);
    }

    /**
     * Creates a <code>XbfFpowerExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpowerExpr
     */
    public XbfFpowerExpr createXbfFpowerExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFpowerExpr xbfFpowerExpr_ = createXbfFpowerExpr();
        xbfFpowerExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpowerExpr_);
    }

    /**
     * Creates a <code>XbfFconcatExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFconcatExpr
     */
    public XbfFconcatExpr createXbfFconcatExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFconcatExpr xbfFconcatExpr_ = createXbfFconcatExpr();
        xbfFconcatExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFconcatExpr_);
    }

    /**
     * Creates a <code>XbfLogEQExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQExpr
     */
    public XbfLogEQExpr createXbfLogEQExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLogEQExpr xbfLogEQExpr_ = createXbfLogEQExpr();
        xbfLogEQExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGEExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGEExpr
     */
    public XbfLogGEExpr createXbfLogGEExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLogGEExpr xbfLogGEExpr_ = createXbfLogGEExpr();
        xbfLogGEExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogGEExpr_);
    }

    /**
     * Creates a <code>XbfLogLEExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLEExpr
     */
    public XbfLogLEExpr createXbfLogLEExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLogLEExpr xbfLogLEExpr_ = createXbfLogLEExpr();
        xbfLogLEExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogLEExpr_);
    }

    /**
     * Creates a <code>XbfLogLTExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLTExpr
     */
    public XbfLogLTExpr createXbfLogLTExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLogLTExpr xbfLogLTExpr_ = createXbfLogLTExpr();
        xbfLogLTExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogLTExpr_);
    }

    /**
     * Creates a <code>XbfLogAndExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogAndExpr
     */
    public XbfLogAndExpr createXbfLogAndExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLogAndExpr xbfLogAndExpr_ = createXbfLogAndExpr();
        xbfLogAndExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogAndExpr_);
    }

    /**
     * Creates a <code>XbfLogOrExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogOrExpr
     */
    public XbfLogOrExpr createXbfLogOrExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLogOrExpr xbfLogOrExpr_ = createXbfLogOrExpr();
        xbfLogOrExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogOrExpr_);
    }

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQVExpr
     */
    public XbfLogEQVExpr createXbfLogEQVExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLogEQVExpr xbfLogEQVExpr_ = createXbfLogEQVExpr();
        xbfLogEQVExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogEQVExpr_);
    }

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUnaryMinusExpr
     */
    public XbfUnaryMinusExpr createXbfUnaryMinusExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfUnaryMinusExpr xbfUnaryMinusExpr_ = createXbfUnaryMinusExpr();
        xbfUnaryMinusExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbfLen</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLen
     */
    public XbfLen createXbfLen(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfLen xbfLen_ = createXbfLen();
        xbfLen_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLen_);
    }

    /**
     * Creates a <code>XbfCoShape</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCoShape
     */
    public XbfCoShape createXbfCoShape(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfCoShape xbfCoShape_ = createXbfCoShape();
        xbfCoShape_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfCoShape_);
    }

    /**
     * Creates a <code>XbfFstructType</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructType
     */
    public XbfFstructType createXbfFstructType(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructType xbfFstructType_ = createXbfFstructType();
        xbfFstructType_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructType_);
    }

    /**
     * Creates a <code>XbfSymbols</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfSymbols
     */
    public XbfSymbols createXbfSymbols(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfSymbols xbfSymbols_ = createXbfSymbols();
        xbfSymbols_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfSymbols_);
    }

    /**
     * Creates a <code>XbfId</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfId
     */
    public XbfId createXbfId(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfId xbfId_ = createXbfId();
        xbfId_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfId_);
    }

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalSymbols
     */
    public XbfGlobalSymbols createXbfGlobalSymbols(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfGlobalSymbols xbfGlobalSymbols_ = createXbfGlobalSymbols();
        xbfGlobalSymbols_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGlobalSymbols_);
    }

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalDeclarations
     */
    public XbfGlobalDeclarations createXbfGlobalDeclarations(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfGlobalDeclarations xbfGlobalDeclarations_ = createXbfGlobalDeclarations();
        xbfGlobalDeclarations_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDefinition
     */
    public XbfFfunctionDefinition createXbfFfunctionDefinition(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionDefinition xbfFfunctionDefinition_ = createXbfFfunctionDefinition();
        xbfFfunctionDefinition_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionDefinition_);
    }

    /**
     * Creates a <code>XbfDeclarations</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDeclarations
     */
    public XbfDeclarations createXbfDeclarations(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfDeclarations xbfDeclarations_ = createXbfDeclarations();
        xbfDeclarations_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfDeclarations_);
    }

    /**
     * Creates a <code>XbfVarDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarDecl
     */
    public XbfVarDecl createXbfVarDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfVarDecl xbfVarDecl_ = createXbfVarDecl();
        xbfVarDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarDecl_);
    }

    /**
     * Creates a <code>XbfExternDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExternDecl
     */
    public XbfExternDecl createXbfExternDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfExternDecl xbfExternDecl_ = createXbfExternDecl();
        xbfExternDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfExternDecl_);
    }

    /**
     * Creates a <code>XbfFuseDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseDecl
     */
    public XbfFuseDecl createXbfFuseDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFuseDecl xbfFuseDecl_ = createXbfFuseDecl();
        xbfFuseDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFuseDecl_);
    }

    /**
     * Creates a <code>XbfRename</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRename
     */
    public XbfRename createXbfRename(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfRename xbfRename_ = createXbfRename();
        xbfRename_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRename_);
    }

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseOnlyDecl
     */
    public XbfFuseOnlyDecl createXbfFuseOnlyDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFuseOnlyDecl xbfFuseOnlyDecl_ = createXbfFuseOnlyDecl();
        xbfFuseOnlyDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFuseOnlyDecl_);
    }

    /**
     * Creates a <code>XbfRenamable</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRenamable
     */
    public XbfRenamable createXbfRenamable(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfRenamable xbfRenamable_ = createXbfRenamable();
        xbfRenamable_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRenamable_);
    }

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinterfaceDecl
     */
    public XbfFinterfaceDecl createXbfFinterfaceDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFinterfaceDecl xbfFinterfaceDecl_ = createXbfFinterfaceDecl();
        xbfFinterfaceDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFinterfaceDecl_);
    }

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDecl
     */
    public XbfFfunctionDecl createXbfFfunctionDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionDecl xbfFfunctionDecl_ = createXbfFfunctionDecl();
        xbfFfunctionDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionDecl_);
    }

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleProcedureDecl
     */
    public XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFmoduleProcedureDecl xbfFmoduleProcedureDecl_ = createXbfFmoduleProcedureDecl();
        xbfFmoduleProcedureDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmoduleProcedureDecl_);
    }

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnamelistDecl
     */
    public XbfFnamelistDecl createXbfFnamelistDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFnamelistDecl xbfFnamelistDecl_ = createXbfFnamelistDecl();
        xbfFnamelistDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFnamelistDecl_);
    }

    /**
     * Creates a <code>XbfVarList</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarList
     */
    public XbfVarList createXbfVarList(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfVarList xbfVarList_ = createXbfVarList();
        xbfVarList_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarList_);
    }

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFequivalenceDecl
     */
    public XbfFequivalenceDecl createXbfFequivalenceDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFequivalenceDecl xbfFequivalenceDecl_ = createXbfFequivalenceDecl();
        xbfFequivalenceDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFequivalenceDecl_);
    }

    /**
     * Creates a <code>XbfFcommonDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcommonDecl
     */
    public XbfFcommonDecl createXbfFcommonDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFcommonDecl xbfFcommonDecl_ = createXbfFcommonDecl();
        xbfFcommonDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcommonDecl_);
    }

    /**
     * Creates a <code>XbfFstructDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructDecl
     */
    public XbfFstructDecl createXbfFstructDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructDecl xbfFstructDecl_ = createXbfFstructDecl();
        xbfFstructDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructDecl_);
    }

    /**
     * Creates a <code>XbfFentryDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFentryDecl
     */
    public XbfFentryDecl createXbfFentryDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFentryDecl xbfFentryDecl_ = createXbfFentryDecl();
        xbfFentryDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFentryDecl_);
    }

    /**
     * Creates a <code>XbfFdataDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdataDecl
     */
    public XbfFdataDecl createXbfFdataDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFdataDecl xbfFdataDecl_ = createXbfFdataDecl();
        xbfFdataDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdataDecl_);
    }

    /**
     * Creates a <code>XbfValueList</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValueList
     */
    public XbfValueList createXbfValueList(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfValueList xbfValueList_ = createXbfValueList();
        xbfValueList_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfValueList_);
    }

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpragmaStatement
     */
    public XbfFpragmaStatement createXbfFpragmaStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFpragmaStatement xbfFpragmaStatement_ = createXbfFpragmaStatement();
        xbfFpragmaStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpragmaStatement_);
    }

    /**
     * Creates a <code>XbfBody</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfBody
     */
    public XbfBody createXbfBody(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfBody xbfBody_ = createXbfBody();
        xbfBody_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfBody_);
    }

    /**
     * Creates a <code>XbfGotoStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGotoStatement
     */
    public XbfGotoStatement createXbfGotoStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfGotoStatement xbfGotoStatement_ = createXbfGotoStatement();
        xbfGotoStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGotoStatement_);
    }

    /**
     * Creates a <code>XbfFpauseStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpauseStatement
     */
    public XbfFpauseStatement createXbfFpauseStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFpauseStatement xbfFpauseStatement_ = createXbfFpauseStatement();
        xbfFpauseStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpauseStatement_);
    }

    /**
     * Creates a <code>XbfFcycleStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcycleStatement
     */
    public XbfFcycleStatement createXbfFcycleStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFcycleStatement xbfFcycleStatement_ = createXbfFcycleStatement();
        xbfFcycleStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcycleStatement_);
    }

    /**
     * Creates a <code>XbfFreadStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreadStatement
     */
    public XbfFreadStatement createXbfFreadStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFreadStatement xbfFreadStatement_ = createXbfFreadStatement();
        xbfFreadStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFreadStatement_);
    }

    /**
     * Creates a <code>XbfNamedValueList</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValueList
     */
    public XbfNamedValueList createXbfNamedValueList(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfNamedValueList xbfNamedValueList_ = createXbfNamedValueList();
        xbfNamedValueList_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfNamedValueList_);
    }

    /**
     * Creates a <code>XbfFcloseStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcloseStatement
     */
    public XbfFcloseStatement createXbfFcloseStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFcloseStatement xbfFcloseStatement_ = createXbfFcloseStatement();
        xbfFcloseStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcloseStatement_);
    }

    /**
     * Creates a <code>XbfFopenStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFopenStatement
     */
    public XbfFopenStatement createXbfFopenStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFopenStatement xbfFopenStatement_ = createXbfFopenStatement();
        xbfFopenStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFopenStatement_);
    }

    /**
     * Creates a <code>XbfFassignStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFassignStatement
     */
    public XbfFassignStatement createXbfFassignStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFassignStatement xbfFassignStatement_ = createXbfFassignStatement();
        xbfFassignStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFassignStatement_);
    }

    /**
     * Creates a <code>XbfExprStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExprStatement
     */
    public XbfExprStatement createXbfExprStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfExprStatement xbfExprStatement_ = createXbfExprStatement();
        xbfExprStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfExprStatement_);
    }

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpointerAssignStatement
     */
    public XbfFpointerAssignStatement createXbfFpointerAssignStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFpointerAssignStatement xbfFpointerAssignStatement_ = createXbfFpointerAssignStatement();
        xbfFpointerAssignStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpointerAssignStatement_);
    }

    /**
     * Creates a <code>XbfFifStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFifStatement
     */
    public XbfFifStatement createXbfFifStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFifStatement xbfFifStatement_ = createXbfFifStatement();
        xbfFifStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFifStatement_);
    }

    /**
     * Creates a <code>XbfCondition</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCondition
     */
    public XbfCondition createXbfCondition(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfCondition xbfCondition_ = createXbfCondition();
        xbfCondition_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfCondition_);
    }

    /**
     * Creates a <code>XbfThen</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfThen
     */
    public XbfThen createXbfThen(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfThen xbfThen_ = createXbfThen();
        xbfThen_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfThen_);
    }

    /**
     * Creates a <code>XbfElse</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfElse
     */
    public XbfElse createXbfElse(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfElse xbfElse_ = createXbfElse();
        xbfElse_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfElse_);
    }

    /**
     * Creates a <code>XbfFdoStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoStatement
     */
    public XbfFdoStatement createXbfFdoStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoStatement xbfFdoStatement_ = createXbfFdoStatement();
        xbfFdoStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoStatement_);
    }

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoWhileStatement
     */
    public XbfFdoWhileStatement createXbfFdoWhileStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoWhileStatement xbfFdoWhileStatement_ = createXbfFdoWhileStatement();
        xbfFdoWhileStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoWhileStatement_);
    }

    /**
     * Creates a <code>XbfContinueStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfContinueStatement
     */
    public XbfContinueStatement createXbfContinueStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfContinueStatement xbfContinueStatement_ = createXbfContinueStatement();
        xbfContinueStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfContinueStatement_);
    }

    /**
     * Creates a <code>XbfFexitStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFexitStatement
     */
    public XbfFexitStatement createXbfFexitStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFexitStatement xbfFexitStatement_ = createXbfFexitStatement();
        xbfFexitStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFexitStatement_);
    }

    /**
     * Creates a <code>XbfFreturnStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreturnStatement
     */
    public XbfFreturnStatement createXbfFreturnStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFreturnStatement xbfFreturnStatement_ = createXbfFreturnStatement();
        xbfFreturnStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFreturnStatement_);
    }

    /**
     * Creates a <code>XbfStatementLabel</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStatementLabel
     */
    public XbfStatementLabel createXbfStatementLabel(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfStatementLabel xbfStatementLabel_ = createXbfStatementLabel();
        xbfStatementLabel_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfStatementLabel_);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFselectCaseStatement
     */
    public XbfFselectCaseStatement createXbfFselectCaseStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFselectCaseStatement xbfFselectCaseStatement_ = createXbfFselectCaseStatement();
        xbfFselectCaseStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFselectCaseStatement_);
    }

    /**
     * Creates a <code>XbfFcaseLabel</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcaseLabel
     */
    public XbfFcaseLabel createXbfFcaseLabel(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFcaseLabel xbfFcaseLabel_ = createXbfFcaseLabel();
        xbfFcaseLabel_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcaseLabel_);
    }

    /**
     * Creates a <code>XbfFwhereStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwhereStatement
     */
    public XbfFwhereStatement createXbfFwhereStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFwhereStatement xbfFwhereStatement_ = createXbfFwhereStatement();
        xbfFwhereStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFwhereStatement_);
    }

    /**
     * Creates a <code>XbfFstopStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstopStatement
     */
    public XbfFstopStatement createXbfFstopStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFstopStatement xbfFstopStatement_ = createXbfFstopStatement();
        xbfFstopStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstopStatement_);
    }

    /**
     * Creates a <code>XbfFwriteStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwriteStatement
     */
    public XbfFwriteStatement createXbfFwriteStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFwriteStatement xbfFwriteStatement_ = createXbfFwriteStatement();
        xbfFwriteStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFwriteStatement_);
    }

    /**
     * Creates a <code>XbfFprintStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFprintStatement
     */
    public XbfFprintStatement createXbfFprintStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFprintStatement xbfFprintStatement_ = createXbfFprintStatement();
        xbfFprintStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFprintStatement_);
    }

    /**
     * Creates a <code>XbfFrewindStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrewindStatement
     */
    public XbfFrewindStatement createXbfFrewindStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFrewindStatement xbfFrewindStatement_ = createXbfFrewindStatement();
        xbfFrewindStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFrewindStatement_);
    }

    /**
     * Creates a <code>XbfFendFileStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFendFileStatement
     */
    public XbfFendFileStatement createXbfFendFileStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFendFileStatement xbfFendFileStatement_ = createXbfFendFileStatement();
        xbfFendFileStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFendFileStatement_);
    }

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbackspaceStatement
     */
    public XbfFbackspaceStatement createXbfFbackspaceStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFbackspaceStatement xbfFbackspaceStatement_ = createXbfFbackspaceStatement();
        xbfFbackspaceStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFbackspaceStatement_);
    }

    /**
     * Creates a <code>XbfFinquireStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinquireStatement
     */
    public XbfFinquireStatement createXbfFinquireStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFinquireStatement xbfFinquireStatement_ = createXbfFinquireStatement();
        xbfFinquireStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFinquireStatement_);
    }

    /**
     * Creates a <code>XbfFformatDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFformatDecl
     */
    public XbfFformatDecl createXbfFformatDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFformatDecl xbfFformatDecl_ = createXbfFformatDecl();
        xbfFformatDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFformatDecl_);
    }

    /**
     * Creates a <code>XbfFallocateStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFallocateStatement
     */
    public XbfFallocateStatement createXbfFallocateStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFallocateStatement xbfFallocateStatement_ = createXbfFallocateStatement();
        xbfFallocateStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFallocateStatement_);
    }

    /**
     * Creates a <code>XbfAlloc</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfAlloc
     */
    public XbfAlloc createXbfAlloc(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfAlloc xbfAlloc_ = createXbfAlloc();
        xbfAlloc_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfAlloc_);
    }

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdeallocateStatement
     */
    public XbfFdeallocateStatement createXbfFdeallocateStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFdeallocateStatement xbfFdeallocateStatement_ = createXbfFdeallocateStatement();
        xbfFdeallocateStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdeallocateStatement_);
    }

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnullifyStatement
     */
    public XbfFnullifyStatement createXbfFnullifyStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFnullifyStatement xbfFnullifyStatement_ = createXbfFnullifyStatement();
        xbfFnullifyStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFnullifyStatement_);
    }

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcontainsStatement
     */
    public XbfFcontainsStatement createXbfFcontainsStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFcontainsStatement xbfFcontainsStatement_ = createXbfFcontainsStatement();
        xbfFcontainsStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcontainsStatement_);
    }

    /**
     * Creates a <code>XbfText</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfText
     */
    public XbfText createXbfText(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfText xbfText_ = createXbfText();
        xbfText_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfText_);
    }

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleDefinition
     */
    public XbfFmoduleDefinition createXbfFmoduleDefinition(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFmoduleDefinition xbfFmoduleDefinition_ = createXbfFmoduleDefinition();
        xbfFmoduleDefinition_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmoduleDefinition_);
    }

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFblockDataDefinition
     */
    public XbfFblockDataDefinition createXbfFblockDataDefinition(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbfFblockDataDefinition xbfFblockDataDefinition_ = createXbfFblockDataDefinition();
        xbfFblockDataDefinition_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFblockDataDefinition_);
    }

    /**
     * Creates a <code>XbfXcodeProgram</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfXcodeProgram
     */
    public XbfXcodeProgram createXbfXcodeProgram(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfXcodeProgram xbfXcodeProgram_ = createXbfXcodeProgram();
        xbfXcodeProgram_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfXcodeProgram_);
    }

    /**
     * Creates a <code>XbfTypeTable</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfTypeTable
     */
    public XbfTypeTable createXbfTypeTable(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfTypeTable xbfTypeTable_ = createXbfTypeTable();
        xbfTypeTable_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfTypeTable_);
    }

    /**
     * Creates a <code>XbfFfunctionType</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionType
     */
    public XbfFfunctionType createXbfFfunctionType(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionType xbfFfunctionType_ = createXbfFfunctionType();
        xbfFfunctionType_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionType_);
    }

    /**
     * Creates a <code>XbfParams</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfParams
     */
    public XbfParams createXbfParams(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfParams xbfParams_ = createXbfParams();
        xbfParams_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfParams_);
    }

    /**
     * Creates a <code>XbfName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfName
     */
    public XbfName createXbfName(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfName xbfName_ = createXbfName();
        xbfName_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfName_);
    }

    /**
     * Creates a <code>XbfFbasicType</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbasicType
     */
    public XbfFbasicType createXbfFbasicType(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFbasicType xbfFbasicType_ = createXbfFbasicType();
        xbfFbasicType_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFbasicType_);
    }

    /**
     * Creates a <code>XbfKind</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfKind
     */
    public XbfKind createXbfKind(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfKind xbfKind_ = createXbfKind();
        xbfKind_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfKind_);
    }

    /**
     * Creates a <code>XbfFarrayRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayRef
     */
    public XbfFarrayRef createXbfFarrayRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFarrayRef xbfFarrayRef_ = createXbfFarrayRef();
        xbfFarrayRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFarrayRef_);
    }

    /**
     * Creates a <code>XbfVarRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarRef
     */
    public XbfVarRef createXbfVarRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfVarRef xbfVarRef_ = createXbfVarRef();
        xbfVarRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarRef_);
    }

    /**
     * Creates a <code>XbfFcharacterRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterRef
     */
    public XbfFcharacterRef createXbfFcharacterRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFcharacterRef xbfFcharacterRef_ = createXbfFcharacterRef();
        xbfFcharacterRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcharacterRef_);
    }

    /**
     * Creates a <code>XbfIndexRange</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfIndexRange
     */
    public XbfIndexRange createXbfIndexRange(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfIndexRange xbfIndexRange_ = createXbfIndexRange();
        xbfIndexRange_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfIndexRange_);
    }

    /**
     * Creates a <code>XbfLowerBound</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLowerBound
     */
    public XbfLowerBound createXbfLowerBound(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLowerBound xbfLowerBound_ = createXbfLowerBound();
        xbfLowerBound_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLowerBound_);
    }

    /**
     * Creates a <code>XbfUpperBound</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUpperBound
     */
    public XbfUpperBound createXbfUpperBound(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfUpperBound xbfUpperBound_ = createXbfUpperBound();
        xbfUpperBound_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUpperBound_);
    }

    /**
     * Creates a <code>XbfStep</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStep
     */
    public XbfStep createXbfStep(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfStep xbfStep_ = createXbfStep();
        xbfStep_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfStep_);
    }

    /**
     * Creates a <code>XbfFmemberRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmemberRef
     */
    public XbfFmemberRef createXbfFmemberRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFmemberRef xbfFmemberRef_ = createXbfFmemberRef();
        xbfFmemberRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmemberRef_);
    }

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcoArrayRef
     */
    public XbfFcoArrayRef createXbfFcoArrayRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFcoArrayRef xbfFcoArrayRef_ = createXbfFcoArrayRef();
        xbfFcoArrayRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcoArrayRef_);
    }

    /**
     * Creates a <code>XbfArrayIndex</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArrayIndex
     */
    public XbfArrayIndex createXbfArrayIndex(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfArrayIndex xbfArrayIndex_ = createXbfArrayIndex();
        xbfArrayIndex_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfArrayIndex_);
    }

    /**
     * Creates a <code>XbfVar</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVar
     */
    public XbfVar createXbfVar(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfVar xbfVar_ = createXbfVar();
        xbfVar_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVar_);
    }

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayConstructor
     */
    public XbfFarrayConstructor createXbfFarrayConstructor(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFarrayConstructor xbfFarrayConstructor_ = createXbfFarrayConstructor();
        xbfFarrayConstructor_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFarrayConstructor_);
    }

    /**
     * Creates a <code>XbfFdoLoop</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoLoop
     */
    public XbfFdoLoop createXbfFdoLoop(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoLoop xbfFdoLoop_ = createXbfFdoLoop();
        xbfFdoLoop_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoLoop_);
    }

    /**
     * Creates a <code>XbfValue</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValue
     */
    public XbfValue createXbfValue(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfValue xbfValue_ = createXbfValue();
        xbfValue_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfValue_);
    }

    /**
     * Creates a <code>XbfRepeatCount</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRepeatCount
     */
    public XbfRepeatCount createXbfRepeatCount(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfRepeatCount xbfRepeatCount_ = createXbfRepeatCount();
        xbfRepeatCount_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRepeatCount_);
    }

    /**
     * Creates a <code>XbfFintConstant</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFintConstant
     */
    public XbfFintConstant createXbfFintConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFintConstant xbfFintConstant_ = createXbfFintConstant();
        xbfFintConstant_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFintConstant_);
    }

    /**
     * Creates a <code>XbfFrealConstant</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrealConstant
     */
    public XbfFrealConstant createXbfFrealConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFrealConstant xbfFrealConstant_ = createXbfFrealConstant();
        xbfFrealConstant_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFrealConstant_);
    }

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterConstant
     */
    public XbfFcharacterConstant createXbfFcharacterConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFcharacterConstant xbfFcharacterConstant_ = createXbfFcharacterConstant();
        xbfFcharacterConstant_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcharacterConstant_);
    }

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFlogicalConstant
     */
    public XbfFlogicalConstant createXbfFlogicalConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFlogicalConstant xbfFlogicalConstant_ = createXbfFlogicalConstant();
        xbfFlogicalConstant_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFlogicalConstant_);
    }

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcomplexConstant
     */
    public XbfFcomplexConstant createXbfFcomplexConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFcomplexConstant xbfFcomplexConstant_ = createXbfFcomplexConstant();
        xbfFcomplexConstant_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcomplexConstant_);
    }

    /**
     * Creates a <code>XbfFstructConstructor</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructConstructor
     */
    public XbfFstructConstructor createXbfFstructConstructor(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructConstructor xbfFstructConstructor_ = createXbfFstructConstructor();
        xbfFstructConstructor_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructConstructor_);
    }

    /**
     * Creates a <code>XbfFunctionCall</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFunctionCall
     */
    public XbfFunctionCall createXbfFunctionCall(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFunctionCall xbfFunctionCall_ = createXbfFunctionCall();
        xbfFunctionCall_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFunctionCall_);
    }

    /**
     * Creates a <code>XbfArguments</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArguments
     */
    public XbfArguments createXbfArguments(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfArguments xbfArguments_ = createXbfArguments();
        xbfArguments_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfArguments_);
    }

    /**
     * Creates a <code>XbfNamedValue</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValue
     */
    public XbfNamedValue createXbfNamedValue(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfNamedValue xbfNamedValue_ = createXbfNamedValue();
        xbfNamedValue_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfNamedValue_);
    }

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserUnaryExpr
     */
    public XbfUserUnaryExpr createXbfUserUnaryExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfUserUnaryExpr xbfUserUnaryExpr_ = createXbfUserUnaryExpr();
        xbfUserUnaryExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUserUnaryExpr_);
    }

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserBinaryExpr
     */
    public XbfUserBinaryExpr createXbfUserBinaryExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfUserBinaryExpr xbfUserBinaryExpr_ = createXbfUserBinaryExpr();
        xbfUserBinaryExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUserBinaryExpr_);
    }

    /**
     * Creates a <code>XbfLogNotExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNotExpr
     */
    public XbfLogNotExpr createXbfLogNotExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNotExpr xbfLogNotExpr_ = createXbfLogNotExpr();
        xbfLogNotExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNotExpr_);
    }

    /**
     * Creates a <code>XbfFfunction</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunction
     */
    public XbfFfunction createXbfFfunction(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunction xbfFfunction_ = createXbfFfunction();
        xbfFfunction_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunction_);
    }

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQExpr
     */
    public XbfLogNEQExpr createXbfLogNEQExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNEQExpr xbfLogNEQExpr_ = createXbfLogNEQExpr();
        xbfLogNEQExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGTExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGTExpr
     */
    public XbfLogGTExpr createXbfLogGTExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLogGTExpr xbfLogGTExpr_ = createXbfLogGTExpr();
        xbfLogGTExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogGTExpr_);
    }

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQVExpr
     */
    public XbfLogNEQVExpr createXbfLogNEQVExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNEQVExpr xbfLogNEQVExpr_ = createXbfLogNEQVExpr();
        xbfLogNEQVExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNEQVExpr_);
    }

    /**
     * Creates a <code>XbfPlusExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfPlusExpr
     */
    public XbfPlusExpr createXbfPlusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfPlusExpr xbfPlusExpr_ = createXbfPlusExpr();
        xbfPlusExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfPlusExpr_);
    }

    /**
     * Creates a <code>XbfMinusExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMinusExpr
     */
    public XbfMinusExpr createXbfMinusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfMinusExpr xbfMinusExpr_ = createXbfMinusExpr();
        xbfMinusExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfMinusExpr_);
    }

    /**
     * Creates a <code>XbfMulExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMulExpr
     */
    public XbfMulExpr createXbfMulExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfMulExpr xbfMulExpr_ = createXbfMulExpr();
        xbfMulExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfMulExpr_);
    }

    /**
     * Creates a <code>XbfDivExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDivExpr
     */
    public XbfDivExpr createXbfDivExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfDivExpr xbfDivExpr_ = createXbfDivExpr();
        xbfDivExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfDivExpr_);
    }

    /**
     * Creates a <code>XbfFpowerExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpowerExpr
     */
    public XbfFpowerExpr createXbfFpowerExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFpowerExpr xbfFpowerExpr_ = createXbfFpowerExpr();
        xbfFpowerExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpowerExpr_);
    }

    /**
     * Creates a <code>XbfFconcatExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFconcatExpr
     */
    public XbfFconcatExpr createXbfFconcatExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFconcatExpr xbfFconcatExpr_ = createXbfFconcatExpr();
        xbfFconcatExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFconcatExpr_);
    }

    /**
     * Creates a <code>XbfLogEQExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQExpr
     */
    public XbfLogEQExpr createXbfLogEQExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLogEQExpr xbfLogEQExpr_ = createXbfLogEQExpr();
        xbfLogEQExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGEExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGEExpr
     */
    public XbfLogGEExpr createXbfLogGEExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLogGEExpr xbfLogGEExpr_ = createXbfLogGEExpr();
        xbfLogGEExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogGEExpr_);
    }

    /**
     * Creates a <code>XbfLogLEExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLEExpr
     */
    public XbfLogLEExpr createXbfLogLEExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLogLEExpr xbfLogLEExpr_ = createXbfLogLEExpr();
        xbfLogLEExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogLEExpr_);
    }

    /**
     * Creates a <code>XbfLogLTExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLTExpr
     */
    public XbfLogLTExpr createXbfLogLTExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLogLTExpr xbfLogLTExpr_ = createXbfLogLTExpr();
        xbfLogLTExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogLTExpr_);
    }

    /**
     * Creates a <code>XbfLogAndExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogAndExpr
     */
    public XbfLogAndExpr createXbfLogAndExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLogAndExpr xbfLogAndExpr_ = createXbfLogAndExpr();
        xbfLogAndExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogAndExpr_);
    }

    /**
     * Creates a <code>XbfLogOrExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogOrExpr
     */
    public XbfLogOrExpr createXbfLogOrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLogOrExpr xbfLogOrExpr_ = createXbfLogOrExpr();
        xbfLogOrExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogOrExpr_);
    }

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQVExpr
     */
    public XbfLogEQVExpr createXbfLogEQVExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLogEQVExpr xbfLogEQVExpr_ = createXbfLogEQVExpr();
        xbfLogEQVExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogEQVExpr_);
    }

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUnaryMinusExpr
     */
    public XbfUnaryMinusExpr createXbfUnaryMinusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfUnaryMinusExpr xbfUnaryMinusExpr_ = createXbfUnaryMinusExpr();
        xbfUnaryMinusExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbfLen</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLen
     */
    public XbfLen createXbfLen(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfLen xbfLen_ = createXbfLen();
        xbfLen_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLen_);
    }

    /**
     * Creates a <code>XbfCoShape</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCoShape
     */
    public XbfCoShape createXbfCoShape(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfCoShape xbfCoShape_ = createXbfCoShape();
        xbfCoShape_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfCoShape_);
    }

    /**
     * Creates a <code>XbfFstructType</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructType
     */
    public XbfFstructType createXbfFstructType(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructType xbfFstructType_ = createXbfFstructType();
        xbfFstructType_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructType_);
    }

    /**
     * Creates a <code>XbfSymbols</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfSymbols
     */
    public XbfSymbols createXbfSymbols(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfSymbols xbfSymbols_ = createXbfSymbols();
        xbfSymbols_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfSymbols_);
    }

    /**
     * Creates a <code>XbfId</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfId
     */
    public XbfId createXbfId(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfId xbfId_ = createXbfId();
        xbfId_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfId_);
    }

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalSymbols
     */
    public XbfGlobalSymbols createXbfGlobalSymbols(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfGlobalSymbols xbfGlobalSymbols_ = createXbfGlobalSymbols();
        xbfGlobalSymbols_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGlobalSymbols_);
    }

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalDeclarations
     */
    public XbfGlobalDeclarations createXbfGlobalDeclarations(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfGlobalDeclarations xbfGlobalDeclarations_ = createXbfGlobalDeclarations();
        xbfGlobalDeclarations_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDefinition
     */
    public XbfFfunctionDefinition createXbfFfunctionDefinition(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionDefinition xbfFfunctionDefinition_ = createXbfFfunctionDefinition();
        xbfFfunctionDefinition_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionDefinition_);
    }

    /**
     * Creates a <code>XbfDeclarations</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDeclarations
     */
    public XbfDeclarations createXbfDeclarations(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfDeclarations xbfDeclarations_ = createXbfDeclarations();
        xbfDeclarations_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfDeclarations_);
    }

    /**
     * Creates a <code>XbfVarDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarDecl
     */
    public XbfVarDecl createXbfVarDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfVarDecl xbfVarDecl_ = createXbfVarDecl();
        xbfVarDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarDecl_);
    }

    /**
     * Creates a <code>XbfExternDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExternDecl
     */
    public XbfExternDecl createXbfExternDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfExternDecl xbfExternDecl_ = createXbfExternDecl();
        xbfExternDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfExternDecl_);
    }

    /**
     * Creates a <code>XbfFuseDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseDecl
     */
    public XbfFuseDecl createXbfFuseDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFuseDecl xbfFuseDecl_ = createXbfFuseDecl();
        xbfFuseDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFuseDecl_);
    }

    /**
     * Creates a <code>XbfRename</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRename
     */
    public XbfRename createXbfRename(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfRename xbfRename_ = createXbfRename();
        xbfRename_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRename_);
    }

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseOnlyDecl
     */
    public XbfFuseOnlyDecl createXbfFuseOnlyDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFuseOnlyDecl xbfFuseOnlyDecl_ = createXbfFuseOnlyDecl();
        xbfFuseOnlyDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFuseOnlyDecl_);
    }

    /**
     * Creates a <code>XbfRenamable</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRenamable
     */
    public XbfRenamable createXbfRenamable(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfRenamable xbfRenamable_ = createXbfRenamable();
        xbfRenamable_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRenamable_);
    }

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinterfaceDecl
     */
    public XbfFinterfaceDecl createXbfFinterfaceDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFinterfaceDecl xbfFinterfaceDecl_ = createXbfFinterfaceDecl();
        xbfFinterfaceDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFinterfaceDecl_);
    }

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDecl
     */
    public XbfFfunctionDecl createXbfFfunctionDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionDecl xbfFfunctionDecl_ = createXbfFfunctionDecl();
        xbfFfunctionDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionDecl_);
    }

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleProcedureDecl
     */
    public XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFmoduleProcedureDecl xbfFmoduleProcedureDecl_ = createXbfFmoduleProcedureDecl();
        xbfFmoduleProcedureDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmoduleProcedureDecl_);
    }

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnamelistDecl
     */
    public XbfFnamelistDecl createXbfFnamelistDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFnamelistDecl xbfFnamelistDecl_ = createXbfFnamelistDecl();
        xbfFnamelistDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFnamelistDecl_);
    }

    /**
     * Creates a <code>XbfVarList</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarList
     */
    public XbfVarList createXbfVarList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfVarList xbfVarList_ = createXbfVarList();
        xbfVarList_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarList_);
    }

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFequivalenceDecl
     */
    public XbfFequivalenceDecl createXbfFequivalenceDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFequivalenceDecl xbfFequivalenceDecl_ = createXbfFequivalenceDecl();
        xbfFequivalenceDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFequivalenceDecl_);
    }

    /**
     * Creates a <code>XbfFcommonDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcommonDecl
     */
    public XbfFcommonDecl createXbfFcommonDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFcommonDecl xbfFcommonDecl_ = createXbfFcommonDecl();
        xbfFcommonDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcommonDecl_);
    }

    /**
     * Creates a <code>XbfFstructDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructDecl
     */
    public XbfFstructDecl createXbfFstructDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructDecl xbfFstructDecl_ = createXbfFstructDecl();
        xbfFstructDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructDecl_);
    }

    /**
     * Creates a <code>XbfFentryDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFentryDecl
     */
    public XbfFentryDecl createXbfFentryDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFentryDecl xbfFentryDecl_ = createXbfFentryDecl();
        xbfFentryDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFentryDecl_);
    }

    /**
     * Creates a <code>XbfFdataDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdataDecl
     */
    public XbfFdataDecl createXbfFdataDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFdataDecl xbfFdataDecl_ = createXbfFdataDecl();
        xbfFdataDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdataDecl_);
    }

    /**
     * Creates a <code>XbfValueList</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValueList
     */
    public XbfValueList createXbfValueList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfValueList xbfValueList_ = createXbfValueList();
        xbfValueList_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfValueList_);
    }

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpragmaStatement
     */
    public XbfFpragmaStatement createXbfFpragmaStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFpragmaStatement xbfFpragmaStatement_ = createXbfFpragmaStatement();
        xbfFpragmaStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpragmaStatement_);
    }

    /**
     * Creates a <code>XbfBody</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfBody
     */
    public XbfBody createXbfBody(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfBody xbfBody_ = createXbfBody();
        xbfBody_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfBody_);
    }

    /**
     * Creates a <code>XbfGotoStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGotoStatement
     */
    public XbfGotoStatement createXbfGotoStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfGotoStatement xbfGotoStatement_ = createXbfGotoStatement();
        xbfGotoStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGotoStatement_);
    }

    /**
     * Creates a <code>XbfFpauseStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpauseStatement
     */
    public XbfFpauseStatement createXbfFpauseStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFpauseStatement xbfFpauseStatement_ = createXbfFpauseStatement();
        xbfFpauseStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpauseStatement_);
    }

    /**
     * Creates a <code>XbfFcycleStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcycleStatement
     */
    public XbfFcycleStatement createXbfFcycleStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFcycleStatement xbfFcycleStatement_ = createXbfFcycleStatement();
        xbfFcycleStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcycleStatement_);
    }

    /**
     * Creates a <code>XbfFreadStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreadStatement
     */
    public XbfFreadStatement createXbfFreadStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFreadStatement xbfFreadStatement_ = createXbfFreadStatement();
        xbfFreadStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFreadStatement_);
    }

    /**
     * Creates a <code>XbfNamedValueList</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValueList
     */
    public XbfNamedValueList createXbfNamedValueList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfNamedValueList xbfNamedValueList_ = createXbfNamedValueList();
        xbfNamedValueList_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfNamedValueList_);
    }

    /**
     * Creates a <code>XbfFcloseStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcloseStatement
     */
    public XbfFcloseStatement createXbfFcloseStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFcloseStatement xbfFcloseStatement_ = createXbfFcloseStatement();
        xbfFcloseStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcloseStatement_);
    }

    /**
     * Creates a <code>XbfFopenStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFopenStatement
     */
    public XbfFopenStatement createXbfFopenStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFopenStatement xbfFopenStatement_ = createXbfFopenStatement();
        xbfFopenStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFopenStatement_);
    }

    /**
     * Creates a <code>XbfFassignStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFassignStatement
     */
    public XbfFassignStatement createXbfFassignStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFassignStatement xbfFassignStatement_ = createXbfFassignStatement();
        xbfFassignStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFassignStatement_);
    }

    /**
     * Creates a <code>XbfExprStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExprStatement
     */
    public XbfExprStatement createXbfExprStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfExprStatement xbfExprStatement_ = createXbfExprStatement();
        xbfExprStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfExprStatement_);
    }

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpointerAssignStatement
     */
    public XbfFpointerAssignStatement createXbfFpointerAssignStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFpointerAssignStatement xbfFpointerAssignStatement_ = createXbfFpointerAssignStatement();
        xbfFpointerAssignStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpointerAssignStatement_);
    }

    /**
     * Creates a <code>XbfFifStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFifStatement
     */
    public XbfFifStatement createXbfFifStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFifStatement xbfFifStatement_ = createXbfFifStatement();
        xbfFifStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFifStatement_);
    }

    /**
     * Creates a <code>XbfCondition</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCondition
     */
    public XbfCondition createXbfCondition(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfCondition xbfCondition_ = createXbfCondition();
        xbfCondition_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfCondition_);
    }

    /**
     * Creates a <code>XbfThen</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfThen
     */
    public XbfThen createXbfThen(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfThen xbfThen_ = createXbfThen();
        xbfThen_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfThen_);
    }

    /**
     * Creates a <code>XbfElse</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfElse
     */
    public XbfElse createXbfElse(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfElse xbfElse_ = createXbfElse();
        xbfElse_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfElse_);
    }

    /**
     * Creates a <code>XbfFdoStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoStatement
     */
    public XbfFdoStatement createXbfFdoStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoStatement xbfFdoStatement_ = createXbfFdoStatement();
        xbfFdoStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoStatement_);
    }

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoWhileStatement
     */
    public XbfFdoWhileStatement createXbfFdoWhileStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoWhileStatement xbfFdoWhileStatement_ = createXbfFdoWhileStatement();
        xbfFdoWhileStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoWhileStatement_);
    }

    /**
     * Creates a <code>XbfContinueStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfContinueStatement
     */
    public XbfContinueStatement createXbfContinueStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfContinueStatement xbfContinueStatement_ = createXbfContinueStatement();
        xbfContinueStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfContinueStatement_);
    }

    /**
     * Creates a <code>XbfFexitStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFexitStatement
     */
    public XbfFexitStatement createXbfFexitStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFexitStatement xbfFexitStatement_ = createXbfFexitStatement();
        xbfFexitStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFexitStatement_);
    }

    /**
     * Creates a <code>XbfFreturnStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreturnStatement
     */
    public XbfFreturnStatement createXbfFreturnStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFreturnStatement xbfFreturnStatement_ = createXbfFreturnStatement();
        xbfFreturnStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFreturnStatement_);
    }

    /**
     * Creates a <code>XbfStatementLabel</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStatementLabel
     */
    public XbfStatementLabel createXbfStatementLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfStatementLabel xbfStatementLabel_ = createXbfStatementLabel();
        xbfStatementLabel_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfStatementLabel_);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFselectCaseStatement
     */
    public XbfFselectCaseStatement createXbfFselectCaseStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFselectCaseStatement xbfFselectCaseStatement_ = createXbfFselectCaseStatement();
        xbfFselectCaseStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFselectCaseStatement_);
    }

    /**
     * Creates a <code>XbfFcaseLabel</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcaseLabel
     */
    public XbfFcaseLabel createXbfFcaseLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFcaseLabel xbfFcaseLabel_ = createXbfFcaseLabel();
        xbfFcaseLabel_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcaseLabel_);
    }

    /**
     * Creates a <code>XbfFwhereStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwhereStatement
     */
    public XbfFwhereStatement createXbfFwhereStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFwhereStatement xbfFwhereStatement_ = createXbfFwhereStatement();
        xbfFwhereStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFwhereStatement_);
    }

    /**
     * Creates a <code>XbfFstopStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstopStatement
     */
    public XbfFstopStatement createXbfFstopStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFstopStatement xbfFstopStatement_ = createXbfFstopStatement();
        xbfFstopStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstopStatement_);
    }

    /**
     * Creates a <code>XbfFwriteStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwriteStatement
     */
    public XbfFwriteStatement createXbfFwriteStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFwriteStatement xbfFwriteStatement_ = createXbfFwriteStatement();
        xbfFwriteStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFwriteStatement_);
    }

    /**
     * Creates a <code>XbfFprintStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFprintStatement
     */
    public XbfFprintStatement createXbfFprintStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFprintStatement xbfFprintStatement_ = createXbfFprintStatement();
        xbfFprintStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFprintStatement_);
    }

    /**
     * Creates a <code>XbfFrewindStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrewindStatement
     */
    public XbfFrewindStatement createXbfFrewindStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFrewindStatement xbfFrewindStatement_ = createXbfFrewindStatement();
        xbfFrewindStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFrewindStatement_);
    }

    /**
     * Creates a <code>XbfFendFileStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFendFileStatement
     */
    public XbfFendFileStatement createXbfFendFileStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFendFileStatement xbfFendFileStatement_ = createXbfFendFileStatement();
        xbfFendFileStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFendFileStatement_);
    }

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbackspaceStatement
     */
    public XbfFbackspaceStatement createXbfFbackspaceStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFbackspaceStatement xbfFbackspaceStatement_ = createXbfFbackspaceStatement();
        xbfFbackspaceStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFbackspaceStatement_);
    }

    /**
     * Creates a <code>XbfFinquireStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinquireStatement
     */
    public XbfFinquireStatement createXbfFinquireStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFinquireStatement xbfFinquireStatement_ = createXbfFinquireStatement();
        xbfFinquireStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFinquireStatement_);
    }

    /**
     * Creates a <code>XbfFformatDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFformatDecl
     */
    public XbfFformatDecl createXbfFformatDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFformatDecl xbfFformatDecl_ = createXbfFformatDecl();
        xbfFformatDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFformatDecl_);
    }

    /**
     * Creates a <code>XbfFallocateStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFallocateStatement
     */
    public XbfFallocateStatement createXbfFallocateStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFallocateStatement xbfFallocateStatement_ = createXbfFallocateStatement();
        xbfFallocateStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFallocateStatement_);
    }

    /**
     * Creates a <code>XbfAlloc</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfAlloc
     */
    public XbfAlloc createXbfAlloc(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfAlloc xbfAlloc_ = createXbfAlloc();
        xbfAlloc_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfAlloc_);
    }

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdeallocateStatement
     */
    public XbfFdeallocateStatement createXbfFdeallocateStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFdeallocateStatement xbfFdeallocateStatement_ = createXbfFdeallocateStatement();
        xbfFdeallocateStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdeallocateStatement_);
    }

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnullifyStatement
     */
    public XbfFnullifyStatement createXbfFnullifyStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFnullifyStatement xbfFnullifyStatement_ = createXbfFnullifyStatement();
        xbfFnullifyStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFnullifyStatement_);
    }

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcontainsStatement
     */
    public XbfFcontainsStatement createXbfFcontainsStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFcontainsStatement xbfFcontainsStatement_ = createXbfFcontainsStatement();
        xbfFcontainsStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcontainsStatement_);
    }

    /**
     * Creates a <code>XbfText</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfText
     */
    public XbfText createXbfText(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfText xbfText_ = createXbfText();
        xbfText_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfText_);
    }

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleDefinition
     */
    public XbfFmoduleDefinition createXbfFmoduleDefinition(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFmoduleDefinition xbfFmoduleDefinition_ = createXbfFmoduleDefinition();
        xbfFmoduleDefinition_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmoduleDefinition_);
    }

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFblockDataDefinition
     */
    public XbfFblockDataDefinition createXbfFblockDataDefinition(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbfFblockDataDefinition xbfFblockDataDefinition_ = createXbfFblockDataDefinition();
        xbfFblockDataDefinition_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFblockDataDefinition_);
    }

    /**
     * Creates a <code>XbfXcodeProgram</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfXcodeProgram
     */
    public XbfXcodeProgram createXbfXcodeProgram(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfXcodeProgram xbfXcodeProgram_ = createXbfXcodeProgram();
        xbfXcodeProgram_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfXcodeProgram_);
    }

    /**
     * Creates a <code>XbfTypeTable</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfTypeTable
     */
    public XbfTypeTable createXbfTypeTable(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfTypeTable xbfTypeTable_ = createXbfTypeTable();
        xbfTypeTable_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfTypeTable_);
    }

    /**
     * Creates a <code>XbfFfunctionType</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionType
     */
    public XbfFfunctionType createXbfFfunctionType(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionType xbfFfunctionType_ = createXbfFfunctionType();
        xbfFfunctionType_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionType_);
    }

    /**
     * Creates a <code>XbfParams</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfParams
     */
    public XbfParams createXbfParams(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfParams xbfParams_ = createXbfParams();
        xbfParams_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfParams_);
    }

    /**
     * Creates a <code>XbfName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfName
     */
    public XbfName createXbfName(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfName xbfName_ = createXbfName();
        xbfName_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfName_);
    }

    /**
     * Creates a <code>XbfFbasicType</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbasicType
     */
    public XbfFbasicType createXbfFbasicType(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFbasicType xbfFbasicType_ = createXbfFbasicType();
        xbfFbasicType_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFbasicType_);
    }

    /**
     * Creates a <code>XbfKind</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfKind
     */
    public XbfKind createXbfKind(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfKind xbfKind_ = createXbfKind();
        xbfKind_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfKind_);
    }

    /**
     * Creates a <code>XbfFarrayRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayRef
     */
    public XbfFarrayRef createXbfFarrayRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFarrayRef xbfFarrayRef_ = createXbfFarrayRef();
        xbfFarrayRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFarrayRef_);
    }

    /**
     * Creates a <code>XbfVarRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarRef
     */
    public XbfVarRef createXbfVarRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfVarRef xbfVarRef_ = createXbfVarRef();
        xbfVarRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarRef_);
    }

    /**
     * Creates a <code>XbfFcharacterRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterRef
     */
    public XbfFcharacterRef createXbfFcharacterRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFcharacterRef xbfFcharacterRef_ = createXbfFcharacterRef();
        xbfFcharacterRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcharacterRef_);
    }

    /**
     * Creates a <code>XbfIndexRange</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfIndexRange
     */
    public XbfIndexRange createXbfIndexRange(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfIndexRange xbfIndexRange_ = createXbfIndexRange();
        xbfIndexRange_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfIndexRange_);
    }

    /**
     * Creates a <code>XbfLowerBound</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLowerBound
     */
    public XbfLowerBound createXbfLowerBound(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLowerBound xbfLowerBound_ = createXbfLowerBound();
        xbfLowerBound_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLowerBound_);
    }

    /**
     * Creates a <code>XbfUpperBound</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUpperBound
     */
    public XbfUpperBound createXbfUpperBound(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfUpperBound xbfUpperBound_ = createXbfUpperBound();
        xbfUpperBound_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUpperBound_);
    }

    /**
     * Creates a <code>XbfStep</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStep
     */
    public XbfStep createXbfStep(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfStep xbfStep_ = createXbfStep();
        xbfStep_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfStep_);
    }

    /**
     * Creates a <code>XbfFmemberRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmemberRef
     */
    public XbfFmemberRef createXbfFmemberRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFmemberRef xbfFmemberRef_ = createXbfFmemberRef();
        xbfFmemberRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmemberRef_);
    }

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcoArrayRef
     */
    public XbfFcoArrayRef createXbfFcoArrayRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFcoArrayRef xbfFcoArrayRef_ = createXbfFcoArrayRef();
        xbfFcoArrayRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcoArrayRef_);
    }

    /**
     * Creates a <code>XbfArrayIndex</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArrayIndex
     */
    public XbfArrayIndex createXbfArrayIndex(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfArrayIndex xbfArrayIndex_ = createXbfArrayIndex();
        xbfArrayIndex_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfArrayIndex_);
    }

    /**
     * Creates a <code>XbfVar</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVar
     */
    public XbfVar createXbfVar(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfVar xbfVar_ = createXbfVar();
        xbfVar_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVar_);
    }

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayConstructor
     */
    public XbfFarrayConstructor createXbfFarrayConstructor(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFarrayConstructor xbfFarrayConstructor_ = createXbfFarrayConstructor();
        xbfFarrayConstructor_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFarrayConstructor_);
    }

    /**
     * Creates a <code>XbfFdoLoop</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoLoop
     */
    public XbfFdoLoop createXbfFdoLoop(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoLoop xbfFdoLoop_ = createXbfFdoLoop();
        xbfFdoLoop_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoLoop_);
    }

    /**
     * Creates a <code>XbfValue</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValue
     */
    public XbfValue createXbfValue(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfValue xbfValue_ = createXbfValue();
        xbfValue_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfValue_);
    }

    /**
     * Creates a <code>XbfRepeatCount</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRepeatCount
     */
    public XbfRepeatCount createXbfRepeatCount(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfRepeatCount xbfRepeatCount_ = createXbfRepeatCount();
        xbfRepeatCount_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRepeatCount_);
    }

    /**
     * Creates a <code>XbfFintConstant</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFintConstant
     */
    public XbfFintConstant createXbfFintConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFintConstant xbfFintConstant_ = createXbfFintConstant();
        xbfFintConstant_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFintConstant_);
    }

    /**
     * Creates a <code>XbfFrealConstant</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrealConstant
     */
    public XbfFrealConstant createXbfFrealConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFrealConstant xbfFrealConstant_ = createXbfFrealConstant();
        xbfFrealConstant_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFrealConstant_);
    }

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterConstant
     */
    public XbfFcharacterConstant createXbfFcharacterConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFcharacterConstant xbfFcharacterConstant_ = createXbfFcharacterConstant();
        xbfFcharacterConstant_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcharacterConstant_);
    }

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFlogicalConstant
     */
    public XbfFlogicalConstant createXbfFlogicalConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFlogicalConstant xbfFlogicalConstant_ = createXbfFlogicalConstant();
        xbfFlogicalConstant_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFlogicalConstant_);
    }

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcomplexConstant
     */
    public XbfFcomplexConstant createXbfFcomplexConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFcomplexConstant xbfFcomplexConstant_ = createXbfFcomplexConstant();
        xbfFcomplexConstant_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcomplexConstant_);
    }

    /**
     * Creates a <code>XbfFstructConstructor</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructConstructor
     */
    public XbfFstructConstructor createXbfFstructConstructor(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructConstructor xbfFstructConstructor_ = createXbfFstructConstructor();
        xbfFstructConstructor_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructConstructor_);
    }

    /**
     * Creates a <code>XbfFunctionCall</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFunctionCall
     */
    public XbfFunctionCall createXbfFunctionCall(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFunctionCall xbfFunctionCall_ = createXbfFunctionCall();
        xbfFunctionCall_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFunctionCall_);
    }

    /**
     * Creates a <code>XbfArguments</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArguments
     */
    public XbfArguments createXbfArguments(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfArguments xbfArguments_ = createXbfArguments();
        xbfArguments_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfArguments_);
    }

    /**
     * Creates a <code>XbfNamedValue</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValue
     */
    public XbfNamedValue createXbfNamedValue(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfNamedValue xbfNamedValue_ = createXbfNamedValue();
        xbfNamedValue_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfNamedValue_);
    }

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserUnaryExpr
     */
    public XbfUserUnaryExpr createXbfUserUnaryExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfUserUnaryExpr xbfUserUnaryExpr_ = createXbfUserUnaryExpr();
        xbfUserUnaryExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUserUnaryExpr_);
    }

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserBinaryExpr
     */
    public XbfUserBinaryExpr createXbfUserBinaryExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfUserBinaryExpr xbfUserBinaryExpr_ = createXbfUserBinaryExpr();
        xbfUserBinaryExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUserBinaryExpr_);
    }

    /**
     * Creates a <code>XbfLogNotExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNotExpr
     */
    public XbfLogNotExpr createXbfLogNotExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNotExpr xbfLogNotExpr_ = createXbfLogNotExpr();
        xbfLogNotExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNotExpr_);
    }

    /**
     * Creates a <code>XbfFfunction</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunction
     */
    public XbfFfunction createXbfFfunction(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunction xbfFfunction_ = createXbfFfunction();
        xbfFfunction_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunction_);
    }

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQExpr
     */
    public XbfLogNEQExpr createXbfLogNEQExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNEQExpr xbfLogNEQExpr_ = createXbfLogNEQExpr();
        xbfLogNEQExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGTExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGTExpr
     */
    public XbfLogGTExpr createXbfLogGTExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLogGTExpr xbfLogGTExpr_ = createXbfLogGTExpr();
        xbfLogGTExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogGTExpr_);
    }

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQVExpr
     */
    public XbfLogNEQVExpr createXbfLogNEQVExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNEQVExpr xbfLogNEQVExpr_ = createXbfLogNEQVExpr();
        xbfLogNEQVExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNEQVExpr_);
    }

    /**
     * Creates a <code>XbfPlusExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfPlusExpr
     */
    public XbfPlusExpr createXbfPlusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfPlusExpr xbfPlusExpr_ = createXbfPlusExpr();
        xbfPlusExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfPlusExpr_);
    }

    /**
     * Creates a <code>XbfMinusExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMinusExpr
     */
    public XbfMinusExpr createXbfMinusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfMinusExpr xbfMinusExpr_ = createXbfMinusExpr();
        xbfMinusExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfMinusExpr_);
    }

    /**
     * Creates a <code>XbfMulExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMulExpr
     */
    public XbfMulExpr createXbfMulExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfMulExpr xbfMulExpr_ = createXbfMulExpr();
        xbfMulExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfMulExpr_);
    }

    /**
     * Creates a <code>XbfDivExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDivExpr
     */
    public XbfDivExpr createXbfDivExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfDivExpr xbfDivExpr_ = createXbfDivExpr();
        xbfDivExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfDivExpr_);
    }

    /**
     * Creates a <code>XbfFpowerExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpowerExpr
     */
    public XbfFpowerExpr createXbfFpowerExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFpowerExpr xbfFpowerExpr_ = createXbfFpowerExpr();
        xbfFpowerExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpowerExpr_);
    }

    /**
     * Creates a <code>XbfFconcatExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFconcatExpr
     */
    public XbfFconcatExpr createXbfFconcatExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFconcatExpr xbfFconcatExpr_ = createXbfFconcatExpr();
        xbfFconcatExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFconcatExpr_);
    }

    /**
     * Creates a <code>XbfLogEQExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQExpr
     */
    public XbfLogEQExpr createXbfLogEQExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLogEQExpr xbfLogEQExpr_ = createXbfLogEQExpr();
        xbfLogEQExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGEExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGEExpr
     */
    public XbfLogGEExpr createXbfLogGEExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLogGEExpr xbfLogGEExpr_ = createXbfLogGEExpr();
        xbfLogGEExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogGEExpr_);
    }

    /**
     * Creates a <code>XbfLogLEExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLEExpr
     */
    public XbfLogLEExpr createXbfLogLEExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLogLEExpr xbfLogLEExpr_ = createXbfLogLEExpr();
        xbfLogLEExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogLEExpr_);
    }

    /**
     * Creates a <code>XbfLogLTExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLTExpr
     */
    public XbfLogLTExpr createXbfLogLTExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLogLTExpr xbfLogLTExpr_ = createXbfLogLTExpr();
        xbfLogLTExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogLTExpr_);
    }

    /**
     * Creates a <code>XbfLogAndExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogAndExpr
     */
    public XbfLogAndExpr createXbfLogAndExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLogAndExpr xbfLogAndExpr_ = createXbfLogAndExpr();
        xbfLogAndExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogAndExpr_);
    }

    /**
     * Creates a <code>XbfLogOrExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogOrExpr
     */
    public XbfLogOrExpr createXbfLogOrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLogOrExpr xbfLogOrExpr_ = createXbfLogOrExpr();
        xbfLogOrExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogOrExpr_);
    }

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQVExpr
     */
    public XbfLogEQVExpr createXbfLogEQVExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLogEQVExpr xbfLogEQVExpr_ = createXbfLogEQVExpr();
        xbfLogEQVExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogEQVExpr_);
    }

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUnaryMinusExpr
     */
    public XbfUnaryMinusExpr createXbfUnaryMinusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfUnaryMinusExpr xbfUnaryMinusExpr_ = createXbfUnaryMinusExpr();
        xbfUnaryMinusExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbfLen</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLen
     */
    public XbfLen createXbfLen(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfLen xbfLen_ = createXbfLen();
        xbfLen_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLen_);
    }

    /**
     * Creates a <code>XbfCoShape</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCoShape
     */
    public XbfCoShape createXbfCoShape(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfCoShape xbfCoShape_ = createXbfCoShape();
        xbfCoShape_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfCoShape_);
    }

    /**
     * Creates a <code>XbfFstructType</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructType
     */
    public XbfFstructType createXbfFstructType(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructType xbfFstructType_ = createXbfFstructType();
        xbfFstructType_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructType_);
    }

    /**
     * Creates a <code>XbfSymbols</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfSymbols
     */
    public XbfSymbols createXbfSymbols(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfSymbols xbfSymbols_ = createXbfSymbols();
        xbfSymbols_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfSymbols_);
    }

    /**
     * Creates a <code>XbfId</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfId
     */
    public XbfId createXbfId(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfId xbfId_ = createXbfId();
        xbfId_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfId_);
    }

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalSymbols
     */
    public XbfGlobalSymbols createXbfGlobalSymbols(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfGlobalSymbols xbfGlobalSymbols_ = createXbfGlobalSymbols();
        xbfGlobalSymbols_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGlobalSymbols_);
    }

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalDeclarations
     */
    public XbfGlobalDeclarations createXbfGlobalDeclarations(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfGlobalDeclarations xbfGlobalDeclarations_ = createXbfGlobalDeclarations();
        xbfGlobalDeclarations_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDefinition
     */
    public XbfFfunctionDefinition createXbfFfunctionDefinition(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionDefinition xbfFfunctionDefinition_ = createXbfFfunctionDefinition();
        xbfFfunctionDefinition_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionDefinition_);
    }

    /**
     * Creates a <code>XbfDeclarations</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDeclarations
     */
    public XbfDeclarations createXbfDeclarations(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfDeclarations xbfDeclarations_ = createXbfDeclarations();
        xbfDeclarations_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfDeclarations_);
    }

    /**
     * Creates a <code>XbfVarDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarDecl
     */
    public XbfVarDecl createXbfVarDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfVarDecl xbfVarDecl_ = createXbfVarDecl();
        xbfVarDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarDecl_);
    }

    /**
     * Creates a <code>XbfExternDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExternDecl
     */
    public XbfExternDecl createXbfExternDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfExternDecl xbfExternDecl_ = createXbfExternDecl();
        xbfExternDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfExternDecl_);
    }

    /**
     * Creates a <code>XbfFuseDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseDecl
     */
    public XbfFuseDecl createXbfFuseDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFuseDecl xbfFuseDecl_ = createXbfFuseDecl();
        xbfFuseDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFuseDecl_);
    }

    /**
     * Creates a <code>XbfRename</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRename
     */
    public XbfRename createXbfRename(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfRename xbfRename_ = createXbfRename();
        xbfRename_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRename_);
    }

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseOnlyDecl
     */
    public XbfFuseOnlyDecl createXbfFuseOnlyDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFuseOnlyDecl xbfFuseOnlyDecl_ = createXbfFuseOnlyDecl();
        xbfFuseOnlyDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFuseOnlyDecl_);
    }

    /**
     * Creates a <code>XbfRenamable</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRenamable
     */
    public XbfRenamable createXbfRenamable(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfRenamable xbfRenamable_ = createXbfRenamable();
        xbfRenamable_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRenamable_);
    }

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinterfaceDecl
     */
    public XbfFinterfaceDecl createXbfFinterfaceDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFinterfaceDecl xbfFinterfaceDecl_ = createXbfFinterfaceDecl();
        xbfFinterfaceDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFinterfaceDecl_);
    }

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDecl
     */
    public XbfFfunctionDecl createXbfFfunctionDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionDecl xbfFfunctionDecl_ = createXbfFfunctionDecl();
        xbfFfunctionDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionDecl_);
    }

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleProcedureDecl
     */
    public XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFmoduleProcedureDecl xbfFmoduleProcedureDecl_ = createXbfFmoduleProcedureDecl();
        xbfFmoduleProcedureDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmoduleProcedureDecl_);
    }

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnamelistDecl
     */
    public XbfFnamelistDecl createXbfFnamelistDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFnamelistDecl xbfFnamelistDecl_ = createXbfFnamelistDecl();
        xbfFnamelistDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFnamelistDecl_);
    }

    /**
     * Creates a <code>XbfVarList</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarList
     */
    public XbfVarList createXbfVarList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfVarList xbfVarList_ = createXbfVarList();
        xbfVarList_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarList_);
    }

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFequivalenceDecl
     */
    public XbfFequivalenceDecl createXbfFequivalenceDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFequivalenceDecl xbfFequivalenceDecl_ = createXbfFequivalenceDecl();
        xbfFequivalenceDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFequivalenceDecl_);
    }

    /**
     * Creates a <code>XbfFcommonDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcommonDecl
     */
    public XbfFcommonDecl createXbfFcommonDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFcommonDecl xbfFcommonDecl_ = createXbfFcommonDecl();
        xbfFcommonDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcommonDecl_);
    }

    /**
     * Creates a <code>XbfFstructDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructDecl
     */
    public XbfFstructDecl createXbfFstructDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructDecl xbfFstructDecl_ = createXbfFstructDecl();
        xbfFstructDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructDecl_);
    }

    /**
     * Creates a <code>XbfFentryDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFentryDecl
     */
    public XbfFentryDecl createXbfFentryDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFentryDecl xbfFentryDecl_ = createXbfFentryDecl();
        xbfFentryDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFentryDecl_);
    }

    /**
     * Creates a <code>XbfFdataDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdataDecl
     */
    public XbfFdataDecl createXbfFdataDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFdataDecl xbfFdataDecl_ = createXbfFdataDecl();
        xbfFdataDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdataDecl_);
    }

    /**
     * Creates a <code>XbfValueList</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValueList
     */
    public XbfValueList createXbfValueList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfValueList xbfValueList_ = createXbfValueList();
        xbfValueList_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfValueList_);
    }

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpragmaStatement
     */
    public XbfFpragmaStatement createXbfFpragmaStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFpragmaStatement xbfFpragmaStatement_ = createXbfFpragmaStatement();
        xbfFpragmaStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpragmaStatement_);
    }

    /**
     * Creates a <code>XbfBody</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfBody
     */
    public XbfBody createXbfBody(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfBody xbfBody_ = createXbfBody();
        xbfBody_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfBody_);
    }

    /**
     * Creates a <code>XbfGotoStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGotoStatement
     */
    public XbfGotoStatement createXbfGotoStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfGotoStatement xbfGotoStatement_ = createXbfGotoStatement();
        xbfGotoStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGotoStatement_);
    }

    /**
     * Creates a <code>XbfFpauseStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpauseStatement
     */
    public XbfFpauseStatement createXbfFpauseStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFpauseStatement xbfFpauseStatement_ = createXbfFpauseStatement();
        xbfFpauseStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpauseStatement_);
    }

    /**
     * Creates a <code>XbfFcycleStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcycleStatement
     */
    public XbfFcycleStatement createXbfFcycleStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFcycleStatement xbfFcycleStatement_ = createXbfFcycleStatement();
        xbfFcycleStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcycleStatement_);
    }

    /**
     * Creates a <code>XbfFreadStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreadStatement
     */
    public XbfFreadStatement createXbfFreadStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFreadStatement xbfFreadStatement_ = createXbfFreadStatement();
        xbfFreadStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFreadStatement_);
    }

    /**
     * Creates a <code>XbfNamedValueList</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValueList
     */
    public XbfNamedValueList createXbfNamedValueList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfNamedValueList xbfNamedValueList_ = createXbfNamedValueList();
        xbfNamedValueList_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfNamedValueList_);
    }

    /**
     * Creates a <code>XbfFcloseStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcloseStatement
     */
    public XbfFcloseStatement createXbfFcloseStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFcloseStatement xbfFcloseStatement_ = createXbfFcloseStatement();
        xbfFcloseStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcloseStatement_);
    }

    /**
     * Creates a <code>XbfFopenStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFopenStatement
     */
    public XbfFopenStatement createXbfFopenStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFopenStatement xbfFopenStatement_ = createXbfFopenStatement();
        xbfFopenStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFopenStatement_);
    }

    /**
     * Creates a <code>XbfFassignStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFassignStatement
     */
    public XbfFassignStatement createXbfFassignStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFassignStatement xbfFassignStatement_ = createXbfFassignStatement();
        xbfFassignStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFassignStatement_);
    }

    /**
     * Creates a <code>XbfExprStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExprStatement
     */
    public XbfExprStatement createXbfExprStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfExprStatement xbfExprStatement_ = createXbfExprStatement();
        xbfExprStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfExprStatement_);
    }

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpointerAssignStatement
     */
    public XbfFpointerAssignStatement createXbfFpointerAssignStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFpointerAssignStatement xbfFpointerAssignStatement_ = createXbfFpointerAssignStatement();
        xbfFpointerAssignStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpointerAssignStatement_);
    }

    /**
     * Creates a <code>XbfFifStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFifStatement
     */
    public XbfFifStatement createXbfFifStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFifStatement xbfFifStatement_ = createXbfFifStatement();
        xbfFifStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFifStatement_);
    }

    /**
     * Creates a <code>XbfCondition</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCondition
     */
    public XbfCondition createXbfCondition(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfCondition xbfCondition_ = createXbfCondition();
        xbfCondition_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfCondition_);
    }

    /**
     * Creates a <code>XbfThen</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfThen
     */
    public XbfThen createXbfThen(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfThen xbfThen_ = createXbfThen();
        xbfThen_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfThen_);
    }

    /**
     * Creates a <code>XbfElse</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfElse
     */
    public XbfElse createXbfElse(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfElse xbfElse_ = createXbfElse();
        xbfElse_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfElse_);
    }

    /**
     * Creates a <code>XbfFdoStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoStatement
     */
    public XbfFdoStatement createXbfFdoStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoStatement xbfFdoStatement_ = createXbfFdoStatement();
        xbfFdoStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoStatement_);
    }

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoWhileStatement
     */
    public XbfFdoWhileStatement createXbfFdoWhileStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoWhileStatement xbfFdoWhileStatement_ = createXbfFdoWhileStatement();
        xbfFdoWhileStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoWhileStatement_);
    }

    /**
     * Creates a <code>XbfContinueStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfContinueStatement
     */
    public XbfContinueStatement createXbfContinueStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfContinueStatement xbfContinueStatement_ = createXbfContinueStatement();
        xbfContinueStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfContinueStatement_);
    }

    /**
     * Creates a <code>XbfFexitStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFexitStatement
     */
    public XbfFexitStatement createXbfFexitStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFexitStatement xbfFexitStatement_ = createXbfFexitStatement();
        xbfFexitStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFexitStatement_);
    }

    /**
     * Creates a <code>XbfFreturnStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreturnStatement
     */
    public XbfFreturnStatement createXbfFreturnStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFreturnStatement xbfFreturnStatement_ = createXbfFreturnStatement();
        xbfFreturnStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFreturnStatement_);
    }

    /**
     * Creates a <code>XbfStatementLabel</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStatementLabel
     */
    public XbfStatementLabel createXbfStatementLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfStatementLabel xbfStatementLabel_ = createXbfStatementLabel();
        xbfStatementLabel_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfStatementLabel_);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFselectCaseStatement
     */
    public XbfFselectCaseStatement createXbfFselectCaseStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFselectCaseStatement xbfFselectCaseStatement_ = createXbfFselectCaseStatement();
        xbfFselectCaseStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFselectCaseStatement_);
    }

    /**
     * Creates a <code>XbfFcaseLabel</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcaseLabel
     */
    public XbfFcaseLabel createXbfFcaseLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFcaseLabel xbfFcaseLabel_ = createXbfFcaseLabel();
        xbfFcaseLabel_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcaseLabel_);
    }

    /**
     * Creates a <code>XbfFwhereStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwhereStatement
     */
    public XbfFwhereStatement createXbfFwhereStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFwhereStatement xbfFwhereStatement_ = createXbfFwhereStatement();
        xbfFwhereStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFwhereStatement_);
    }

    /**
     * Creates a <code>XbfFstopStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstopStatement
     */
    public XbfFstopStatement createXbfFstopStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFstopStatement xbfFstopStatement_ = createXbfFstopStatement();
        xbfFstopStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstopStatement_);
    }

    /**
     * Creates a <code>XbfFwriteStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwriteStatement
     */
    public XbfFwriteStatement createXbfFwriteStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFwriteStatement xbfFwriteStatement_ = createXbfFwriteStatement();
        xbfFwriteStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFwriteStatement_);
    }

    /**
     * Creates a <code>XbfFprintStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFprintStatement
     */
    public XbfFprintStatement createXbfFprintStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFprintStatement xbfFprintStatement_ = createXbfFprintStatement();
        xbfFprintStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFprintStatement_);
    }

    /**
     * Creates a <code>XbfFrewindStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrewindStatement
     */
    public XbfFrewindStatement createXbfFrewindStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFrewindStatement xbfFrewindStatement_ = createXbfFrewindStatement();
        xbfFrewindStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFrewindStatement_);
    }

    /**
     * Creates a <code>XbfFendFileStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFendFileStatement
     */
    public XbfFendFileStatement createXbfFendFileStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFendFileStatement xbfFendFileStatement_ = createXbfFendFileStatement();
        xbfFendFileStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFendFileStatement_);
    }

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbackspaceStatement
     */
    public XbfFbackspaceStatement createXbfFbackspaceStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFbackspaceStatement xbfFbackspaceStatement_ = createXbfFbackspaceStatement();
        xbfFbackspaceStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFbackspaceStatement_);
    }

    /**
     * Creates a <code>XbfFinquireStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinquireStatement
     */
    public XbfFinquireStatement createXbfFinquireStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFinquireStatement xbfFinquireStatement_ = createXbfFinquireStatement();
        xbfFinquireStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFinquireStatement_);
    }

    /**
     * Creates a <code>XbfFformatDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFformatDecl
     */
    public XbfFformatDecl createXbfFformatDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFformatDecl xbfFformatDecl_ = createXbfFformatDecl();
        xbfFformatDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFformatDecl_);
    }

    /**
     * Creates a <code>XbfFallocateStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFallocateStatement
     */
    public XbfFallocateStatement createXbfFallocateStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFallocateStatement xbfFallocateStatement_ = createXbfFallocateStatement();
        xbfFallocateStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFallocateStatement_);
    }

    /**
     * Creates a <code>XbfAlloc</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfAlloc
     */
    public XbfAlloc createXbfAlloc(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfAlloc xbfAlloc_ = createXbfAlloc();
        xbfAlloc_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfAlloc_);
    }

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdeallocateStatement
     */
    public XbfFdeallocateStatement createXbfFdeallocateStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFdeallocateStatement xbfFdeallocateStatement_ = createXbfFdeallocateStatement();
        xbfFdeallocateStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdeallocateStatement_);
    }

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnullifyStatement
     */
    public XbfFnullifyStatement createXbfFnullifyStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFnullifyStatement xbfFnullifyStatement_ = createXbfFnullifyStatement();
        xbfFnullifyStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFnullifyStatement_);
    }

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcontainsStatement
     */
    public XbfFcontainsStatement createXbfFcontainsStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFcontainsStatement xbfFcontainsStatement_ = createXbfFcontainsStatement();
        xbfFcontainsStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcontainsStatement_);
    }

    /**
     * Creates a <code>XbfText</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfText
     */
    public XbfText createXbfText(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfText xbfText_ = createXbfText();
        xbfText_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfText_);
    }

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleDefinition
     */
    public XbfFmoduleDefinition createXbfFmoduleDefinition(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFmoduleDefinition xbfFmoduleDefinition_ = createXbfFmoduleDefinition();
        xbfFmoduleDefinition_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmoduleDefinition_);
    }

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFblockDataDefinition
     */
    public XbfFblockDataDefinition createXbfFblockDataDefinition(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbfFblockDataDefinition xbfFblockDataDefinition_ = createXbfFblockDataDefinition();
        xbfFblockDataDefinition_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFblockDataDefinition_);
    }

    /**
     * Creates a <code>XbfXcodeProgram</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfXcodeProgram
     */
    public XbfXcodeProgram createXbfXcodeProgram(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfXcodeProgram xbfXcodeProgram_ = createXbfXcodeProgram();
        xbfXcodeProgram_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfXcodeProgram_);
    }

    /**
     * Creates a <code>XbfTypeTable</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfTypeTable
     */
    public XbfTypeTable createXbfTypeTable(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfTypeTable xbfTypeTable_ = createXbfTypeTable();
        xbfTypeTable_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfTypeTable_);
    }

    /**
     * Creates a <code>XbfFfunctionType</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionType
     */
    public XbfFfunctionType createXbfFfunctionType(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionType xbfFfunctionType_ = createXbfFfunctionType();
        xbfFfunctionType_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionType_);
    }

    /**
     * Creates a <code>XbfParams</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfParams
     */
    public XbfParams createXbfParams(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfParams xbfParams_ = createXbfParams();
        xbfParams_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfParams_);
    }

    /**
     * Creates a <code>XbfName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfName
     */
    public XbfName createXbfName(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfName xbfName_ = createXbfName();
        xbfName_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfName_);
    }

    /**
     * Creates a <code>XbfFbasicType</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbasicType
     */
    public XbfFbasicType createXbfFbasicType(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFbasicType xbfFbasicType_ = createXbfFbasicType();
        xbfFbasicType_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFbasicType_);
    }

    /**
     * Creates a <code>XbfKind</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfKind
     */
    public XbfKind createXbfKind(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfKind xbfKind_ = createXbfKind();
        xbfKind_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfKind_);
    }

    /**
     * Creates a <code>XbfFarrayRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayRef
     */
    public XbfFarrayRef createXbfFarrayRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFarrayRef xbfFarrayRef_ = createXbfFarrayRef();
        xbfFarrayRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFarrayRef_);
    }

    /**
     * Creates a <code>XbfVarRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarRef
     */
    public XbfVarRef createXbfVarRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfVarRef xbfVarRef_ = createXbfVarRef();
        xbfVarRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarRef_);
    }

    /**
     * Creates a <code>XbfFcharacterRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterRef
     */
    public XbfFcharacterRef createXbfFcharacterRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFcharacterRef xbfFcharacterRef_ = createXbfFcharacterRef();
        xbfFcharacterRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcharacterRef_);
    }

    /**
     * Creates a <code>XbfIndexRange</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfIndexRange
     */
    public XbfIndexRange createXbfIndexRange(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfIndexRange xbfIndexRange_ = createXbfIndexRange();
        xbfIndexRange_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfIndexRange_);
    }

    /**
     * Creates a <code>XbfLowerBound</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLowerBound
     */
    public XbfLowerBound createXbfLowerBound(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLowerBound xbfLowerBound_ = createXbfLowerBound();
        xbfLowerBound_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLowerBound_);
    }

    /**
     * Creates a <code>XbfUpperBound</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUpperBound
     */
    public XbfUpperBound createXbfUpperBound(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfUpperBound xbfUpperBound_ = createXbfUpperBound();
        xbfUpperBound_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUpperBound_);
    }

    /**
     * Creates a <code>XbfStep</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStep
     */
    public XbfStep createXbfStep(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfStep xbfStep_ = createXbfStep();
        xbfStep_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfStep_);
    }

    /**
     * Creates a <code>XbfFmemberRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmemberRef
     */
    public XbfFmemberRef createXbfFmemberRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFmemberRef xbfFmemberRef_ = createXbfFmemberRef();
        xbfFmemberRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmemberRef_);
    }

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcoArrayRef
     */
    public XbfFcoArrayRef createXbfFcoArrayRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFcoArrayRef xbfFcoArrayRef_ = createXbfFcoArrayRef();
        xbfFcoArrayRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcoArrayRef_);
    }

    /**
     * Creates a <code>XbfArrayIndex</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArrayIndex
     */
    public XbfArrayIndex createXbfArrayIndex(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfArrayIndex xbfArrayIndex_ = createXbfArrayIndex();
        xbfArrayIndex_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfArrayIndex_);
    }

    /**
     * Creates a <code>XbfVar</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVar
     */
    public XbfVar createXbfVar(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfVar xbfVar_ = createXbfVar();
        xbfVar_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVar_);
    }

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFarrayConstructor
     */
    public XbfFarrayConstructor createXbfFarrayConstructor(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFarrayConstructor xbfFarrayConstructor_ = createXbfFarrayConstructor();
        xbfFarrayConstructor_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFarrayConstructor_);
    }

    /**
     * Creates a <code>XbfFdoLoop</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoLoop
     */
    public XbfFdoLoop createXbfFdoLoop(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoLoop xbfFdoLoop_ = createXbfFdoLoop();
        xbfFdoLoop_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoLoop_);
    }

    /**
     * Creates a <code>XbfValue</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValue
     */
    public XbfValue createXbfValue(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfValue xbfValue_ = createXbfValue();
        xbfValue_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfValue_);
    }

    /**
     * Creates a <code>XbfRepeatCount</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRepeatCount
     */
    public XbfRepeatCount createXbfRepeatCount(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfRepeatCount xbfRepeatCount_ = createXbfRepeatCount();
        xbfRepeatCount_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRepeatCount_);
    }

    /**
     * Creates a <code>XbfFintConstant</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFintConstant
     */
    public XbfFintConstant createXbfFintConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFintConstant xbfFintConstant_ = createXbfFintConstant();
        xbfFintConstant_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFintConstant_);
    }

    /**
     * Creates a <code>XbfFrealConstant</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrealConstant
     */
    public XbfFrealConstant createXbfFrealConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFrealConstant xbfFrealConstant_ = createXbfFrealConstant();
        xbfFrealConstant_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFrealConstant_);
    }

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcharacterConstant
     */
    public XbfFcharacterConstant createXbfFcharacterConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFcharacterConstant xbfFcharacterConstant_ = createXbfFcharacterConstant();
        xbfFcharacterConstant_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcharacterConstant_);
    }

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFlogicalConstant
     */
    public XbfFlogicalConstant createXbfFlogicalConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFlogicalConstant xbfFlogicalConstant_ = createXbfFlogicalConstant();
        xbfFlogicalConstant_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFlogicalConstant_);
    }

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcomplexConstant
     */
    public XbfFcomplexConstant createXbfFcomplexConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFcomplexConstant xbfFcomplexConstant_ = createXbfFcomplexConstant();
        xbfFcomplexConstant_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcomplexConstant_);
    }

    /**
     * Creates a <code>XbfFstructConstructor</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructConstructor
     */
    public XbfFstructConstructor createXbfFstructConstructor(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructConstructor xbfFstructConstructor_ = createXbfFstructConstructor();
        xbfFstructConstructor_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructConstructor_);
    }

    /**
     * Creates a <code>XbfFunctionCall</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFunctionCall
     */
    public XbfFunctionCall createXbfFunctionCall(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFunctionCall xbfFunctionCall_ = createXbfFunctionCall();
        xbfFunctionCall_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFunctionCall_);
    }

    /**
     * Creates a <code>XbfArguments</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfArguments
     */
    public XbfArguments createXbfArguments(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfArguments xbfArguments_ = createXbfArguments();
        xbfArguments_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfArguments_);
    }

    /**
     * Creates a <code>XbfNamedValue</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValue
     */
    public XbfNamedValue createXbfNamedValue(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfNamedValue xbfNamedValue_ = createXbfNamedValue();
        xbfNamedValue_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfNamedValue_);
    }

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserUnaryExpr
     */
    public XbfUserUnaryExpr createXbfUserUnaryExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfUserUnaryExpr xbfUserUnaryExpr_ = createXbfUserUnaryExpr();
        xbfUserUnaryExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUserUnaryExpr_);
    }

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUserBinaryExpr
     */
    public XbfUserBinaryExpr createXbfUserBinaryExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfUserBinaryExpr xbfUserBinaryExpr_ = createXbfUserBinaryExpr();
        xbfUserBinaryExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUserBinaryExpr_);
    }

    /**
     * Creates a <code>XbfLogNotExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNotExpr
     */
    public XbfLogNotExpr createXbfLogNotExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNotExpr xbfLogNotExpr_ = createXbfLogNotExpr();
        xbfLogNotExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNotExpr_);
    }

    /**
     * Creates a <code>XbfFfunction</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunction
     */
    public XbfFfunction createXbfFfunction(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunction xbfFfunction_ = createXbfFfunction();
        xbfFfunction_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunction_);
    }

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQExpr
     */
    public XbfLogNEQExpr createXbfLogNEQExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNEQExpr xbfLogNEQExpr_ = createXbfLogNEQExpr();
        xbfLogNEQExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGTExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGTExpr
     */
    public XbfLogGTExpr createXbfLogGTExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLogGTExpr xbfLogGTExpr_ = createXbfLogGTExpr();
        xbfLogGTExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogGTExpr_);
    }

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogNEQVExpr
     */
    public XbfLogNEQVExpr createXbfLogNEQVExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLogNEQVExpr xbfLogNEQVExpr_ = createXbfLogNEQVExpr();
        xbfLogNEQVExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogNEQVExpr_);
    }

    /**
     * Creates a <code>XbfPlusExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfPlusExpr
     */
    public XbfPlusExpr createXbfPlusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfPlusExpr xbfPlusExpr_ = createXbfPlusExpr();
        xbfPlusExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfPlusExpr_);
    }

    /**
     * Creates a <code>XbfMinusExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMinusExpr
     */
    public XbfMinusExpr createXbfMinusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfMinusExpr xbfMinusExpr_ = createXbfMinusExpr();
        xbfMinusExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfMinusExpr_);
    }

    /**
     * Creates a <code>XbfMulExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfMulExpr
     */
    public XbfMulExpr createXbfMulExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfMulExpr xbfMulExpr_ = createXbfMulExpr();
        xbfMulExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfMulExpr_);
    }

    /**
     * Creates a <code>XbfDivExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDivExpr
     */
    public XbfDivExpr createXbfDivExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfDivExpr xbfDivExpr_ = createXbfDivExpr();
        xbfDivExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfDivExpr_);
    }

    /**
     * Creates a <code>XbfFpowerExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpowerExpr
     */
    public XbfFpowerExpr createXbfFpowerExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFpowerExpr xbfFpowerExpr_ = createXbfFpowerExpr();
        xbfFpowerExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpowerExpr_);
    }

    /**
     * Creates a <code>XbfFconcatExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFconcatExpr
     */
    public XbfFconcatExpr createXbfFconcatExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFconcatExpr xbfFconcatExpr_ = createXbfFconcatExpr();
        xbfFconcatExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFconcatExpr_);
    }

    /**
     * Creates a <code>XbfLogEQExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQExpr
     */
    public XbfLogEQExpr createXbfLogEQExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLogEQExpr xbfLogEQExpr_ = createXbfLogEQExpr();
        xbfLogEQExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGEExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogGEExpr
     */
    public XbfLogGEExpr createXbfLogGEExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLogGEExpr xbfLogGEExpr_ = createXbfLogGEExpr();
        xbfLogGEExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogGEExpr_);
    }

    /**
     * Creates a <code>XbfLogLEExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLEExpr
     */
    public XbfLogLEExpr createXbfLogLEExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLogLEExpr xbfLogLEExpr_ = createXbfLogLEExpr();
        xbfLogLEExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogLEExpr_);
    }

    /**
     * Creates a <code>XbfLogLTExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogLTExpr
     */
    public XbfLogLTExpr createXbfLogLTExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLogLTExpr xbfLogLTExpr_ = createXbfLogLTExpr();
        xbfLogLTExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogLTExpr_);
    }

    /**
     * Creates a <code>XbfLogAndExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogAndExpr
     */
    public XbfLogAndExpr createXbfLogAndExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLogAndExpr xbfLogAndExpr_ = createXbfLogAndExpr();
        xbfLogAndExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogAndExpr_);
    }

    /**
     * Creates a <code>XbfLogOrExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogOrExpr
     */
    public XbfLogOrExpr createXbfLogOrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLogOrExpr xbfLogOrExpr_ = createXbfLogOrExpr();
        xbfLogOrExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogOrExpr_);
    }

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLogEQVExpr
     */
    public XbfLogEQVExpr createXbfLogEQVExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLogEQVExpr xbfLogEQVExpr_ = createXbfLogEQVExpr();
        xbfLogEQVExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLogEQVExpr_);
    }

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfUnaryMinusExpr
     */
    public XbfUnaryMinusExpr createXbfUnaryMinusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfUnaryMinusExpr xbfUnaryMinusExpr_ = createXbfUnaryMinusExpr();
        xbfUnaryMinusExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbfLen</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfLen
     */
    public XbfLen createXbfLen(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfLen xbfLen_ = createXbfLen();
        xbfLen_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfLen_);
    }

    /**
     * Creates a <code>XbfCoShape</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCoShape
     */
    public XbfCoShape createXbfCoShape(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfCoShape xbfCoShape_ = createXbfCoShape();
        xbfCoShape_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfCoShape_);
    }

    /**
     * Creates a <code>XbfFstructType</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructType
     */
    public XbfFstructType createXbfFstructType(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructType xbfFstructType_ = createXbfFstructType();
        xbfFstructType_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructType_);
    }

    /**
     * Creates a <code>XbfSymbols</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfSymbols
     */
    public XbfSymbols createXbfSymbols(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfSymbols xbfSymbols_ = createXbfSymbols();
        xbfSymbols_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfSymbols_);
    }

    /**
     * Creates a <code>XbfId</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfId
     */
    public XbfId createXbfId(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfId xbfId_ = createXbfId();
        xbfId_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfId_);
    }

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalSymbols
     */
    public XbfGlobalSymbols createXbfGlobalSymbols(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfGlobalSymbols xbfGlobalSymbols_ = createXbfGlobalSymbols();
        xbfGlobalSymbols_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGlobalSymbols_);
    }

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGlobalDeclarations
     */
    public XbfGlobalDeclarations createXbfGlobalDeclarations(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfGlobalDeclarations xbfGlobalDeclarations_ = createXbfGlobalDeclarations();
        xbfGlobalDeclarations_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDefinition
     */
    public XbfFfunctionDefinition createXbfFfunctionDefinition(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionDefinition xbfFfunctionDefinition_ = createXbfFfunctionDefinition();
        xbfFfunctionDefinition_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionDefinition_);
    }

    /**
     * Creates a <code>XbfDeclarations</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfDeclarations
     */
    public XbfDeclarations createXbfDeclarations(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfDeclarations xbfDeclarations_ = createXbfDeclarations();
        xbfDeclarations_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfDeclarations_);
    }

    /**
     * Creates a <code>XbfVarDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarDecl
     */
    public XbfVarDecl createXbfVarDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfVarDecl xbfVarDecl_ = createXbfVarDecl();
        xbfVarDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarDecl_);
    }

    /**
     * Creates a <code>XbfExternDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExternDecl
     */
    public XbfExternDecl createXbfExternDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfExternDecl xbfExternDecl_ = createXbfExternDecl();
        xbfExternDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfExternDecl_);
    }

    /**
     * Creates a <code>XbfFuseDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseDecl
     */
    public XbfFuseDecl createXbfFuseDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFuseDecl xbfFuseDecl_ = createXbfFuseDecl();
        xbfFuseDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFuseDecl_);
    }

    /**
     * Creates a <code>XbfRename</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRename
     */
    public XbfRename createXbfRename(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfRename xbfRename_ = createXbfRename();
        xbfRename_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRename_);
    }

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFuseOnlyDecl
     */
    public XbfFuseOnlyDecl createXbfFuseOnlyDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFuseOnlyDecl xbfFuseOnlyDecl_ = createXbfFuseOnlyDecl();
        xbfFuseOnlyDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFuseOnlyDecl_);
    }

    /**
     * Creates a <code>XbfRenamable</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfRenamable
     */
    public XbfRenamable createXbfRenamable(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfRenamable xbfRenamable_ = createXbfRenamable();
        xbfRenamable_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfRenamable_);
    }

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinterfaceDecl
     */
    public XbfFinterfaceDecl createXbfFinterfaceDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFinterfaceDecl xbfFinterfaceDecl_ = createXbfFinterfaceDecl();
        xbfFinterfaceDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFinterfaceDecl_);
    }

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFfunctionDecl
     */
    public XbfFfunctionDecl createXbfFfunctionDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFfunctionDecl xbfFfunctionDecl_ = createXbfFfunctionDecl();
        xbfFfunctionDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFfunctionDecl_);
    }

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleProcedureDecl
     */
    public XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFmoduleProcedureDecl xbfFmoduleProcedureDecl_ = createXbfFmoduleProcedureDecl();
        xbfFmoduleProcedureDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmoduleProcedureDecl_);
    }

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnamelistDecl
     */
    public XbfFnamelistDecl createXbfFnamelistDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFnamelistDecl xbfFnamelistDecl_ = createXbfFnamelistDecl();
        xbfFnamelistDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFnamelistDecl_);
    }

    /**
     * Creates a <code>XbfVarList</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfVarList
     */
    public XbfVarList createXbfVarList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfVarList xbfVarList_ = createXbfVarList();
        xbfVarList_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfVarList_);
    }

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFequivalenceDecl
     */
    public XbfFequivalenceDecl createXbfFequivalenceDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFequivalenceDecl xbfFequivalenceDecl_ = createXbfFequivalenceDecl();
        xbfFequivalenceDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFequivalenceDecl_);
    }

    /**
     * Creates a <code>XbfFcommonDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcommonDecl
     */
    public XbfFcommonDecl createXbfFcommonDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFcommonDecl xbfFcommonDecl_ = createXbfFcommonDecl();
        xbfFcommonDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcommonDecl_);
    }

    /**
     * Creates a <code>XbfFstructDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstructDecl
     */
    public XbfFstructDecl createXbfFstructDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFstructDecl xbfFstructDecl_ = createXbfFstructDecl();
        xbfFstructDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstructDecl_);
    }

    /**
     * Creates a <code>XbfFentryDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFentryDecl
     */
    public XbfFentryDecl createXbfFentryDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFentryDecl xbfFentryDecl_ = createXbfFentryDecl();
        xbfFentryDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFentryDecl_);
    }

    /**
     * Creates a <code>XbfFdataDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdataDecl
     */
    public XbfFdataDecl createXbfFdataDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFdataDecl xbfFdataDecl_ = createXbfFdataDecl();
        xbfFdataDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdataDecl_);
    }

    /**
     * Creates a <code>XbfValueList</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfValueList
     */
    public XbfValueList createXbfValueList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfValueList xbfValueList_ = createXbfValueList();
        xbfValueList_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfValueList_);
    }

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpragmaStatement
     */
    public XbfFpragmaStatement createXbfFpragmaStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFpragmaStatement xbfFpragmaStatement_ = createXbfFpragmaStatement();
        xbfFpragmaStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpragmaStatement_);
    }

    /**
     * Creates a <code>XbfBody</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfBody
     */
    public XbfBody createXbfBody(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfBody xbfBody_ = createXbfBody();
        xbfBody_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfBody_);
    }

    /**
     * Creates a <code>XbfGotoStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfGotoStatement
     */
    public XbfGotoStatement createXbfGotoStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfGotoStatement xbfGotoStatement_ = createXbfGotoStatement();
        xbfGotoStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfGotoStatement_);
    }

    /**
     * Creates a <code>XbfFpauseStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpauseStatement
     */
    public XbfFpauseStatement createXbfFpauseStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFpauseStatement xbfFpauseStatement_ = createXbfFpauseStatement();
        xbfFpauseStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpauseStatement_);
    }

    /**
     * Creates a <code>XbfFcycleStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcycleStatement
     */
    public XbfFcycleStatement createXbfFcycleStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFcycleStatement xbfFcycleStatement_ = createXbfFcycleStatement();
        xbfFcycleStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcycleStatement_);
    }

    /**
     * Creates a <code>XbfFreadStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreadStatement
     */
    public XbfFreadStatement createXbfFreadStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFreadStatement xbfFreadStatement_ = createXbfFreadStatement();
        xbfFreadStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFreadStatement_);
    }

    /**
     * Creates a <code>XbfNamedValueList</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfNamedValueList
     */
    public XbfNamedValueList createXbfNamedValueList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfNamedValueList xbfNamedValueList_ = createXbfNamedValueList();
        xbfNamedValueList_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfNamedValueList_);
    }

    /**
     * Creates a <code>XbfFcloseStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcloseStatement
     */
    public XbfFcloseStatement createXbfFcloseStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFcloseStatement xbfFcloseStatement_ = createXbfFcloseStatement();
        xbfFcloseStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcloseStatement_);
    }

    /**
     * Creates a <code>XbfFopenStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFopenStatement
     */
    public XbfFopenStatement createXbfFopenStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFopenStatement xbfFopenStatement_ = createXbfFopenStatement();
        xbfFopenStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFopenStatement_);
    }

    /**
     * Creates a <code>XbfFassignStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFassignStatement
     */
    public XbfFassignStatement createXbfFassignStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFassignStatement xbfFassignStatement_ = createXbfFassignStatement();
        xbfFassignStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFassignStatement_);
    }

    /**
     * Creates a <code>XbfExprStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfExprStatement
     */
    public XbfExprStatement createXbfExprStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfExprStatement xbfExprStatement_ = createXbfExprStatement();
        xbfExprStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfExprStatement_);
    }

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFpointerAssignStatement
     */
    public XbfFpointerAssignStatement createXbfFpointerAssignStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFpointerAssignStatement xbfFpointerAssignStatement_ = createXbfFpointerAssignStatement();
        xbfFpointerAssignStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFpointerAssignStatement_);
    }

    /**
     * Creates a <code>XbfFifStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFifStatement
     */
    public XbfFifStatement createXbfFifStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFifStatement xbfFifStatement_ = createXbfFifStatement();
        xbfFifStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFifStatement_);
    }

    /**
     * Creates a <code>XbfCondition</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfCondition
     */
    public XbfCondition createXbfCondition(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfCondition xbfCondition_ = createXbfCondition();
        xbfCondition_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfCondition_);
    }

    /**
     * Creates a <code>XbfThen</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfThen
     */
    public XbfThen createXbfThen(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfThen xbfThen_ = createXbfThen();
        xbfThen_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfThen_);
    }

    /**
     * Creates a <code>XbfElse</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfElse
     */
    public XbfElse createXbfElse(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfElse xbfElse_ = createXbfElse();
        xbfElse_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfElse_);
    }

    /**
     * Creates a <code>XbfFdoStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoStatement
     */
    public XbfFdoStatement createXbfFdoStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoStatement xbfFdoStatement_ = createXbfFdoStatement();
        xbfFdoStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoStatement_);
    }

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdoWhileStatement
     */
    public XbfFdoWhileStatement createXbfFdoWhileStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFdoWhileStatement xbfFdoWhileStatement_ = createXbfFdoWhileStatement();
        xbfFdoWhileStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdoWhileStatement_);
    }

    /**
     * Creates a <code>XbfContinueStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfContinueStatement
     */
    public XbfContinueStatement createXbfContinueStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfContinueStatement xbfContinueStatement_ = createXbfContinueStatement();
        xbfContinueStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfContinueStatement_);
    }

    /**
     * Creates a <code>XbfFexitStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFexitStatement
     */
    public XbfFexitStatement createXbfFexitStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFexitStatement xbfFexitStatement_ = createXbfFexitStatement();
        xbfFexitStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFexitStatement_);
    }

    /**
     * Creates a <code>XbfFreturnStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFreturnStatement
     */
    public XbfFreturnStatement createXbfFreturnStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFreturnStatement xbfFreturnStatement_ = createXbfFreturnStatement();
        xbfFreturnStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFreturnStatement_);
    }

    /**
     * Creates a <code>XbfStatementLabel</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfStatementLabel
     */
    public XbfStatementLabel createXbfStatementLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfStatementLabel xbfStatementLabel_ = createXbfStatementLabel();
        xbfStatementLabel_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfStatementLabel_);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFselectCaseStatement
     */
    public XbfFselectCaseStatement createXbfFselectCaseStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFselectCaseStatement xbfFselectCaseStatement_ = createXbfFselectCaseStatement();
        xbfFselectCaseStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFselectCaseStatement_);
    }

    /**
     * Creates a <code>XbfFcaseLabel</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcaseLabel
     */
    public XbfFcaseLabel createXbfFcaseLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFcaseLabel xbfFcaseLabel_ = createXbfFcaseLabel();
        xbfFcaseLabel_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcaseLabel_);
    }

    /**
     * Creates a <code>XbfFwhereStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwhereStatement
     */
    public XbfFwhereStatement createXbfFwhereStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFwhereStatement xbfFwhereStatement_ = createXbfFwhereStatement();
        xbfFwhereStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFwhereStatement_);
    }

    /**
     * Creates a <code>XbfFstopStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFstopStatement
     */
    public XbfFstopStatement createXbfFstopStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFstopStatement xbfFstopStatement_ = createXbfFstopStatement();
        xbfFstopStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFstopStatement_);
    }

    /**
     * Creates a <code>XbfFwriteStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFwriteStatement
     */
    public XbfFwriteStatement createXbfFwriteStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFwriteStatement xbfFwriteStatement_ = createXbfFwriteStatement();
        xbfFwriteStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFwriteStatement_);
    }

    /**
     * Creates a <code>XbfFprintStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFprintStatement
     */
    public XbfFprintStatement createXbfFprintStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFprintStatement xbfFprintStatement_ = createXbfFprintStatement();
        xbfFprintStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFprintStatement_);
    }

    /**
     * Creates a <code>XbfFrewindStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFrewindStatement
     */
    public XbfFrewindStatement createXbfFrewindStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFrewindStatement xbfFrewindStatement_ = createXbfFrewindStatement();
        xbfFrewindStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFrewindStatement_);
    }

    /**
     * Creates a <code>XbfFendFileStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFendFileStatement
     */
    public XbfFendFileStatement createXbfFendFileStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFendFileStatement xbfFendFileStatement_ = createXbfFendFileStatement();
        xbfFendFileStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFendFileStatement_);
    }

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFbackspaceStatement
     */
    public XbfFbackspaceStatement createXbfFbackspaceStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFbackspaceStatement xbfFbackspaceStatement_ = createXbfFbackspaceStatement();
        xbfFbackspaceStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFbackspaceStatement_);
    }

    /**
     * Creates a <code>XbfFinquireStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFinquireStatement
     */
    public XbfFinquireStatement createXbfFinquireStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFinquireStatement xbfFinquireStatement_ = createXbfFinquireStatement();
        xbfFinquireStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFinquireStatement_);
    }

    /**
     * Creates a <code>XbfFformatDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFformatDecl
     */
    public XbfFformatDecl createXbfFformatDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFformatDecl xbfFformatDecl_ = createXbfFformatDecl();
        xbfFformatDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFformatDecl_);
    }

    /**
     * Creates a <code>XbfFallocateStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFallocateStatement
     */
    public XbfFallocateStatement createXbfFallocateStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFallocateStatement xbfFallocateStatement_ = createXbfFallocateStatement();
        xbfFallocateStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFallocateStatement_);
    }

    /**
     * Creates a <code>XbfAlloc</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfAlloc
     */
    public XbfAlloc createXbfAlloc(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfAlloc xbfAlloc_ = createXbfAlloc();
        xbfAlloc_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfAlloc_);
    }

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFdeallocateStatement
     */
    public XbfFdeallocateStatement createXbfFdeallocateStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFdeallocateStatement xbfFdeallocateStatement_ = createXbfFdeallocateStatement();
        xbfFdeallocateStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFdeallocateStatement_);
    }

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFnullifyStatement
     */
    public XbfFnullifyStatement createXbfFnullifyStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFnullifyStatement xbfFnullifyStatement_ = createXbfFnullifyStatement();
        xbfFnullifyStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFnullifyStatement_);
    }

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFcontainsStatement
     */
    public XbfFcontainsStatement createXbfFcontainsStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFcontainsStatement xbfFcontainsStatement_ = createXbfFcontainsStatement();
        xbfFcontainsStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFcontainsStatement_);
    }

    /**
     * Creates a <code>XbfText</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfText
     */
    public XbfText createXbfText(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfText xbfText_ = createXbfText();
        xbfText_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfText_);
    }

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFmoduleDefinition
     */
    public XbfFmoduleDefinition createXbfFmoduleDefinition(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFmoduleDefinition xbfFmoduleDefinition_ = createXbfFmoduleDefinition();
        xbfFmoduleDefinition_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFmoduleDefinition_);
    }

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbfFblockDataDefinition
     */
    public XbfFblockDataDefinition createXbfFblockDataDefinition(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbfFblockDataDefinition xbfFblockDataDefinition_ = createXbfFblockDataDefinition();
        xbfFblockDataDefinition_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbfFblockDataDefinition_);
    }

    /**
     * Creates a <code>XbfXcodeProgram</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfXcodeProgram
     */
    public XbfXcodeProgram createXbfXcodeProgram(XbfXcodeProgram source) {
        XbfXcodeProgram xbfXcodeProgram_ = createXbfXcodeProgram();
        xbfXcodeProgram_.setup(source);
        return (xbfXcodeProgram_);
    }

    /**
     * Creates a <code>XbfTypeTable</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfTypeTable
     */
    public XbfTypeTable createXbfTypeTable(XbfTypeTable source) {
        XbfTypeTable xbfTypeTable_ = createXbfTypeTable();
        xbfTypeTable_.setup(source);
        return (xbfTypeTable_);
    }

    /**
     * Creates a <code>XbfFfunctionType</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFfunctionType
     */
    public XbfFfunctionType createXbfFfunctionType(XbfFfunctionType source) {
        XbfFfunctionType xbfFfunctionType_ = createXbfFfunctionType();
        xbfFfunctionType_.setup(source);
        return (xbfFfunctionType_);
    }

    /**
     * Creates a <code>XbfParams</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfParams
     */
    public XbfParams createXbfParams(XbfParams source) {
        XbfParams xbfParams_ = createXbfParams();
        xbfParams_.setup(source);
        return (xbfParams_);
    }

    /**
     * Creates a <code>XbfName</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfName
     */
    public XbfName createXbfName(XbfName source) {
        XbfName xbfName_ = createXbfName();
        xbfName_.setup(source);
        return (xbfName_);
    }

    /**
     * Creates a <code>XbfFbasicType</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFbasicType
     */
    public XbfFbasicType createXbfFbasicType(XbfFbasicType source) {
        XbfFbasicType xbfFbasicType_ = createXbfFbasicType();
        xbfFbasicType_.setup(source);
        return (xbfFbasicType_);
    }

    /**
     * Creates a <code>XbfKind</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfKind
     */
    public XbfKind createXbfKind(XbfKind source) {
        XbfKind xbfKind_ = createXbfKind();
        xbfKind_.setup(source);
        return (xbfKind_);
    }

    /**
     * Creates a <code>XbfFarrayRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFarrayRef
     */
    public XbfFarrayRef createXbfFarrayRef(XbfFarrayRef source) {
        XbfFarrayRef xbfFarrayRef_ = createXbfFarrayRef();
        xbfFarrayRef_.setup(source);
        return (xbfFarrayRef_);
    }

    /**
     * Creates a <code>XbfVarRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfVarRef
     */
    public XbfVarRef createXbfVarRef(XbfVarRef source) {
        XbfVarRef xbfVarRef_ = createXbfVarRef();
        xbfVarRef_.setup(source);
        return (xbfVarRef_);
    }

    /**
     * Creates a <code>XbfFcharacterRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFcharacterRef
     */
    public XbfFcharacterRef createXbfFcharacterRef(XbfFcharacterRef source) {
        XbfFcharacterRef xbfFcharacterRef_ = createXbfFcharacterRef();
        xbfFcharacterRef_.setup(source);
        return (xbfFcharacterRef_);
    }

    /**
     * Creates a <code>XbfIndexRange</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfIndexRange
     */
    public XbfIndexRange createXbfIndexRange(XbfIndexRange source) {
        XbfIndexRange xbfIndexRange_ = createXbfIndexRange();
        xbfIndexRange_.setup(source);
        return (xbfIndexRange_);
    }

    /**
     * Creates a <code>XbfLowerBound</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLowerBound
     */
    public XbfLowerBound createXbfLowerBound(XbfLowerBound source) {
        XbfLowerBound xbfLowerBound_ = createXbfLowerBound();
        xbfLowerBound_.setup(source);
        return (xbfLowerBound_);
    }

    /**
     * Creates a <code>XbfUpperBound</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfUpperBound
     */
    public XbfUpperBound createXbfUpperBound(XbfUpperBound source) {
        XbfUpperBound xbfUpperBound_ = createXbfUpperBound();
        xbfUpperBound_.setup(source);
        return (xbfUpperBound_);
    }

    /**
     * Creates a <code>XbfStep</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfStep
     */
    public XbfStep createXbfStep(XbfStep source) {
        XbfStep xbfStep_ = createXbfStep();
        xbfStep_.setup(source);
        return (xbfStep_);
    }

    /**
     * Creates a <code>XbfFmemberRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFmemberRef
     */
    public XbfFmemberRef createXbfFmemberRef(XbfFmemberRef source) {
        XbfFmemberRef xbfFmemberRef_ = createXbfFmemberRef();
        xbfFmemberRef_.setup(source);
        return (xbfFmemberRef_);
    }

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFcoArrayRef
     */
    public XbfFcoArrayRef createXbfFcoArrayRef(XbfFcoArrayRef source) {
        XbfFcoArrayRef xbfFcoArrayRef_ = createXbfFcoArrayRef();
        xbfFcoArrayRef_.setup(source);
        return (xbfFcoArrayRef_);
    }

    /**
     * Creates a <code>XbfArrayIndex</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfArrayIndex
     */
    public XbfArrayIndex createXbfArrayIndex(XbfArrayIndex source) {
        XbfArrayIndex xbfArrayIndex_ = createXbfArrayIndex();
        xbfArrayIndex_.setup(source);
        return (xbfArrayIndex_);
    }

    /**
     * Creates a <code>XbfVar</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfVar
     */
    public XbfVar createXbfVar(XbfVar source) {
        XbfVar xbfVar_ = createXbfVar();
        xbfVar_.setup(source);
        return (xbfVar_);
    }

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFarrayConstructor
     */
    public XbfFarrayConstructor createXbfFarrayConstructor(XbfFarrayConstructor source) {
        XbfFarrayConstructor xbfFarrayConstructor_ = createXbfFarrayConstructor();
        xbfFarrayConstructor_.setup(source);
        return (xbfFarrayConstructor_);
    }

    /**
     * Creates a <code>XbfFdoLoop</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFdoLoop
     */
    public XbfFdoLoop createXbfFdoLoop(XbfFdoLoop source) {
        XbfFdoLoop xbfFdoLoop_ = createXbfFdoLoop();
        xbfFdoLoop_.setup(source);
        return (xbfFdoLoop_);
    }

    /**
     * Creates a <code>XbfValue</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfValue
     */
    public XbfValue createXbfValue(XbfValue source) {
        XbfValue xbfValue_ = createXbfValue();
        xbfValue_.setup(source);
        return (xbfValue_);
    }

    /**
     * Creates a <code>XbfRepeatCount</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfRepeatCount
     */
    public XbfRepeatCount createXbfRepeatCount(XbfRepeatCount source) {
        XbfRepeatCount xbfRepeatCount_ = createXbfRepeatCount();
        xbfRepeatCount_.setup(source);
        return (xbfRepeatCount_);
    }

    /**
     * Creates a <code>XbfFintConstant</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFintConstant
     */
    public XbfFintConstant createXbfFintConstant(XbfFintConstant source) {
        XbfFintConstant xbfFintConstant_ = createXbfFintConstant();
        xbfFintConstant_.setup(source);
        return (xbfFintConstant_);
    }

    /**
     * Creates a <code>XbfFrealConstant</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFrealConstant
     */
    public XbfFrealConstant createXbfFrealConstant(XbfFrealConstant source) {
        XbfFrealConstant xbfFrealConstant_ = createXbfFrealConstant();
        xbfFrealConstant_.setup(source);
        return (xbfFrealConstant_);
    }

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFcharacterConstant
     */
    public XbfFcharacterConstant createXbfFcharacterConstant(XbfFcharacterConstant source) {
        XbfFcharacterConstant xbfFcharacterConstant_ = createXbfFcharacterConstant();
        xbfFcharacterConstant_.setup(source);
        return (xbfFcharacterConstant_);
    }

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFlogicalConstant
     */
    public XbfFlogicalConstant createXbfFlogicalConstant(XbfFlogicalConstant source) {
        XbfFlogicalConstant xbfFlogicalConstant_ = createXbfFlogicalConstant();
        xbfFlogicalConstant_.setup(source);
        return (xbfFlogicalConstant_);
    }

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFcomplexConstant
     */
    public XbfFcomplexConstant createXbfFcomplexConstant(XbfFcomplexConstant source) {
        XbfFcomplexConstant xbfFcomplexConstant_ = createXbfFcomplexConstant();
        xbfFcomplexConstant_.setup(source);
        return (xbfFcomplexConstant_);
    }

    /**
     * Creates a <code>XbfFstructConstructor</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFstructConstructor
     */
    public XbfFstructConstructor createXbfFstructConstructor(XbfFstructConstructor source) {
        XbfFstructConstructor xbfFstructConstructor_ = createXbfFstructConstructor();
        xbfFstructConstructor_.setup(source);
        return (xbfFstructConstructor_);
    }

    /**
     * Creates a <code>XbfFunctionCall</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFunctionCall
     */
    public XbfFunctionCall createXbfFunctionCall(XbfFunctionCall source) {
        XbfFunctionCall xbfFunctionCall_ = createXbfFunctionCall();
        xbfFunctionCall_.setup(source);
        return (xbfFunctionCall_);
    }

    /**
     * Creates a <code>XbfArguments</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfArguments
     */
    public XbfArguments createXbfArguments(XbfArguments source) {
        XbfArguments xbfArguments_ = createXbfArguments();
        xbfArguments_.setup(source);
        return (xbfArguments_);
    }

    /**
     * Creates a <code>XbfNamedValue</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfNamedValue
     */
    public XbfNamedValue createXbfNamedValue(XbfNamedValue source) {
        XbfNamedValue xbfNamedValue_ = createXbfNamedValue();
        xbfNamedValue_.setup(source);
        return (xbfNamedValue_);
    }

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfUserUnaryExpr
     */
    public XbfUserUnaryExpr createXbfUserUnaryExpr(XbfUserUnaryExpr source) {
        XbfUserUnaryExpr xbfUserUnaryExpr_ = createXbfUserUnaryExpr();
        xbfUserUnaryExpr_.setup(source);
        return (xbfUserUnaryExpr_);
    }

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfUserBinaryExpr
     */
    public XbfUserBinaryExpr createXbfUserBinaryExpr(XbfUserBinaryExpr source) {
        XbfUserBinaryExpr xbfUserBinaryExpr_ = createXbfUserBinaryExpr();
        xbfUserBinaryExpr_.setup(source);
        return (xbfUserBinaryExpr_);
    }

    /**
     * Creates a <code>XbfLogNotExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLogNotExpr
     */
    public XbfLogNotExpr createXbfLogNotExpr(XbfLogNotExpr source) {
        XbfLogNotExpr xbfLogNotExpr_ = createXbfLogNotExpr();
        xbfLogNotExpr_.setup(source);
        return (xbfLogNotExpr_);
    }

    /**
     * Creates a <code>XbfFfunction</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFfunction
     */
    public XbfFfunction createXbfFfunction(XbfFfunction source) {
        XbfFfunction xbfFfunction_ = createXbfFfunction();
        xbfFfunction_.setup(source);
        return (xbfFfunction_);
    }

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLogNEQExpr
     */
    public XbfLogNEQExpr createXbfLogNEQExpr(XbfLogNEQExpr source) {
        XbfLogNEQExpr xbfLogNEQExpr_ = createXbfLogNEQExpr();
        xbfLogNEQExpr_.setup(source);
        return (xbfLogNEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGTExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLogGTExpr
     */
    public XbfLogGTExpr createXbfLogGTExpr(XbfLogGTExpr source) {
        XbfLogGTExpr xbfLogGTExpr_ = createXbfLogGTExpr();
        xbfLogGTExpr_.setup(source);
        return (xbfLogGTExpr_);
    }

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLogNEQVExpr
     */
    public XbfLogNEQVExpr createXbfLogNEQVExpr(XbfLogNEQVExpr source) {
        XbfLogNEQVExpr xbfLogNEQVExpr_ = createXbfLogNEQVExpr();
        xbfLogNEQVExpr_.setup(source);
        return (xbfLogNEQVExpr_);
    }

    /**
     * Creates a <code>XbfPlusExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfPlusExpr
     */
    public XbfPlusExpr createXbfPlusExpr(XbfPlusExpr source) {
        XbfPlusExpr xbfPlusExpr_ = createXbfPlusExpr();
        xbfPlusExpr_.setup(source);
        return (xbfPlusExpr_);
    }

    /**
     * Creates a <code>XbfMinusExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfMinusExpr
     */
    public XbfMinusExpr createXbfMinusExpr(XbfMinusExpr source) {
        XbfMinusExpr xbfMinusExpr_ = createXbfMinusExpr();
        xbfMinusExpr_.setup(source);
        return (xbfMinusExpr_);
    }

    /**
     * Creates a <code>XbfMulExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfMulExpr
     */
    public XbfMulExpr createXbfMulExpr(XbfMulExpr source) {
        XbfMulExpr xbfMulExpr_ = createXbfMulExpr();
        xbfMulExpr_.setup(source);
        return (xbfMulExpr_);
    }

    /**
     * Creates a <code>XbfDivExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfDivExpr
     */
    public XbfDivExpr createXbfDivExpr(XbfDivExpr source) {
        XbfDivExpr xbfDivExpr_ = createXbfDivExpr();
        xbfDivExpr_.setup(source);
        return (xbfDivExpr_);
    }

    /**
     * Creates a <code>XbfFpowerExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFpowerExpr
     */
    public XbfFpowerExpr createXbfFpowerExpr(XbfFpowerExpr source) {
        XbfFpowerExpr xbfFpowerExpr_ = createXbfFpowerExpr();
        xbfFpowerExpr_.setup(source);
        return (xbfFpowerExpr_);
    }

    /**
     * Creates a <code>XbfFconcatExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFconcatExpr
     */
    public XbfFconcatExpr createXbfFconcatExpr(XbfFconcatExpr source) {
        XbfFconcatExpr xbfFconcatExpr_ = createXbfFconcatExpr();
        xbfFconcatExpr_.setup(source);
        return (xbfFconcatExpr_);
    }

    /**
     * Creates a <code>XbfLogEQExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLogEQExpr
     */
    public XbfLogEQExpr createXbfLogEQExpr(XbfLogEQExpr source) {
        XbfLogEQExpr xbfLogEQExpr_ = createXbfLogEQExpr();
        xbfLogEQExpr_.setup(source);
        return (xbfLogEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGEExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLogGEExpr
     */
    public XbfLogGEExpr createXbfLogGEExpr(XbfLogGEExpr source) {
        XbfLogGEExpr xbfLogGEExpr_ = createXbfLogGEExpr();
        xbfLogGEExpr_.setup(source);
        return (xbfLogGEExpr_);
    }

    /**
     * Creates a <code>XbfLogLEExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLogLEExpr
     */
    public XbfLogLEExpr createXbfLogLEExpr(XbfLogLEExpr source) {
        XbfLogLEExpr xbfLogLEExpr_ = createXbfLogLEExpr();
        xbfLogLEExpr_.setup(source);
        return (xbfLogLEExpr_);
    }

    /**
     * Creates a <code>XbfLogLTExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLogLTExpr
     */
    public XbfLogLTExpr createXbfLogLTExpr(XbfLogLTExpr source) {
        XbfLogLTExpr xbfLogLTExpr_ = createXbfLogLTExpr();
        xbfLogLTExpr_.setup(source);
        return (xbfLogLTExpr_);
    }

    /**
     * Creates a <code>XbfLogAndExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLogAndExpr
     */
    public XbfLogAndExpr createXbfLogAndExpr(XbfLogAndExpr source) {
        XbfLogAndExpr xbfLogAndExpr_ = createXbfLogAndExpr();
        xbfLogAndExpr_.setup(source);
        return (xbfLogAndExpr_);
    }

    /**
     * Creates a <code>XbfLogOrExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLogOrExpr
     */
    public XbfLogOrExpr createXbfLogOrExpr(XbfLogOrExpr source) {
        XbfLogOrExpr xbfLogOrExpr_ = createXbfLogOrExpr();
        xbfLogOrExpr_.setup(source);
        return (xbfLogOrExpr_);
    }

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLogEQVExpr
     */
    public XbfLogEQVExpr createXbfLogEQVExpr(XbfLogEQVExpr source) {
        XbfLogEQVExpr xbfLogEQVExpr_ = createXbfLogEQVExpr();
        xbfLogEQVExpr_.setup(source);
        return (xbfLogEQVExpr_);
    }

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfUnaryMinusExpr
     */
    public XbfUnaryMinusExpr createXbfUnaryMinusExpr(XbfUnaryMinusExpr source) {
        XbfUnaryMinusExpr xbfUnaryMinusExpr_ = createXbfUnaryMinusExpr();
        xbfUnaryMinusExpr_.setup(source);
        return (xbfUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbfLen</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfLen
     */
    public XbfLen createXbfLen(XbfLen source) {
        XbfLen xbfLen_ = createXbfLen();
        xbfLen_.setup(source);
        return (xbfLen_);
    }

    /**
     * Creates a <code>XbfCoShape</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfCoShape
     */
    public XbfCoShape createXbfCoShape(XbfCoShape source) {
        XbfCoShape xbfCoShape_ = createXbfCoShape();
        xbfCoShape_.setup(source);
        return (xbfCoShape_);
    }

    /**
     * Creates a <code>XbfFstructType</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFstructType
     */
    public XbfFstructType createXbfFstructType(XbfFstructType source) {
        XbfFstructType xbfFstructType_ = createXbfFstructType();
        xbfFstructType_.setup(source);
        return (xbfFstructType_);
    }

    /**
     * Creates a <code>XbfSymbols</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfSymbols
     */
    public XbfSymbols createXbfSymbols(XbfSymbols source) {
        XbfSymbols xbfSymbols_ = createXbfSymbols();
        xbfSymbols_.setup(source);
        return (xbfSymbols_);
    }

    /**
     * Creates a <code>XbfId</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfId
     */
    public XbfId createXbfId(XbfId source) {
        XbfId xbfId_ = createXbfId();
        xbfId_.setup(source);
        return (xbfId_);
    }

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfGlobalSymbols
     */
    public XbfGlobalSymbols createXbfGlobalSymbols(XbfGlobalSymbols source) {
        XbfGlobalSymbols xbfGlobalSymbols_ = createXbfGlobalSymbols();
        xbfGlobalSymbols_.setup(source);
        return (xbfGlobalSymbols_);
    }

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfGlobalDeclarations
     */
    public XbfGlobalDeclarations createXbfGlobalDeclarations(XbfGlobalDeclarations source) {
        XbfGlobalDeclarations xbfGlobalDeclarations_ = createXbfGlobalDeclarations();
        xbfGlobalDeclarations_.setup(source);
        return (xbfGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFfunctionDefinition
     */
    public XbfFfunctionDefinition createXbfFfunctionDefinition(XbfFfunctionDefinition source) {
        XbfFfunctionDefinition xbfFfunctionDefinition_ = createXbfFfunctionDefinition();
        xbfFfunctionDefinition_.setup(source);
        return (xbfFfunctionDefinition_);
    }

    /**
     * Creates a <code>XbfDeclarations</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfDeclarations
     */
    public XbfDeclarations createXbfDeclarations(XbfDeclarations source) {
        XbfDeclarations xbfDeclarations_ = createXbfDeclarations();
        xbfDeclarations_.setup(source);
        return (xbfDeclarations_);
    }

    /**
     * Creates a <code>XbfVarDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfVarDecl
     */
    public XbfVarDecl createXbfVarDecl(XbfVarDecl source) {
        XbfVarDecl xbfVarDecl_ = createXbfVarDecl();
        xbfVarDecl_.setup(source);
        return (xbfVarDecl_);
    }

    /**
     * Creates a <code>XbfExternDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfExternDecl
     */
    public XbfExternDecl createXbfExternDecl(XbfExternDecl source) {
        XbfExternDecl xbfExternDecl_ = createXbfExternDecl();
        xbfExternDecl_.setup(source);
        return (xbfExternDecl_);
    }

    /**
     * Creates a <code>XbfFuseDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFuseDecl
     */
    public XbfFuseDecl createXbfFuseDecl(XbfFuseDecl source) {
        XbfFuseDecl xbfFuseDecl_ = createXbfFuseDecl();
        xbfFuseDecl_.setup(source);
        return (xbfFuseDecl_);
    }

    /**
     * Creates a <code>XbfRename</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfRename
     */
    public XbfRename createXbfRename(XbfRename source) {
        XbfRename xbfRename_ = createXbfRename();
        xbfRename_.setup(source);
        return (xbfRename_);
    }

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFuseOnlyDecl
     */
    public XbfFuseOnlyDecl createXbfFuseOnlyDecl(XbfFuseOnlyDecl source) {
        XbfFuseOnlyDecl xbfFuseOnlyDecl_ = createXbfFuseOnlyDecl();
        xbfFuseOnlyDecl_.setup(source);
        return (xbfFuseOnlyDecl_);
    }

    /**
     * Creates a <code>XbfRenamable</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfRenamable
     */
    public XbfRenamable createXbfRenamable(XbfRenamable source) {
        XbfRenamable xbfRenamable_ = createXbfRenamable();
        xbfRenamable_.setup(source);
        return (xbfRenamable_);
    }

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFinterfaceDecl
     */
    public XbfFinterfaceDecl createXbfFinterfaceDecl(XbfFinterfaceDecl source) {
        XbfFinterfaceDecl xbfFinterfaceDecl_ = createXbfFinterfaceDecl();
        xbfFinterfaceDecl_.setup(source);
        return (xbfFinterfaceDecl_);
    }

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFfunctionDecl
     */
    public XbfFfunctionDecl createXbfFfunctionDecl(XbfFfunctionDecl source) {
        XbfFfunctionDecl xbfFfunctionDecl_ = createXbfFfunctionDecl();
        xbfFfunctionDecl_.setup(source);
        return (xbfFfunctionDecl_);
    }

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFmoduleProcedureDecl
     */
    public XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(XbfFmoduleProcedureDecl source) {
        XbfFmoduleProcedureDecl xbfFmoduleProcedureDecl_ = createXbfFmoduleProcedureDecl();
        xbfFmoduleProcedureDecl_.setup(source);
        return (xbfFmoduleProcedureDecl_);
    }

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFnamelistDecl
     */
    public XbfFnamelistDecl createXbfFnamelistDecl(XbfFnamelistDecl source) {
        XbfFnamelistDecl xbfFnamelistDecl_ = createXbfFnamelistDecl();
        xbfFnamelistDecl_.setup(source);
        return (xbfFnamelistDecl_);
    }

    /**
     * Creates a <code>XbfVarList</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfVarList
     */
    public XbfVarList createXbfVarList(XbfVarList source) {
        XbfVarList xbfVarList_ = createXbfVarList();
        xbfVarList_.setup(source);
        return (xbfVarList_);
    }

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFequivalenceDecl
     */
    public XbfFequivalenceDecl createXbfFequivalenceDecl(XbfFequivalenceDecl source) {
        XbfFequivalenceDecl xbfFequivalenceDecl_ = createXbfFequivalenceDecl();
        xbfFequivalenceDecl_.setup(source);
        return (xbfFequivalenceDecl_);
    }

    /**
     * Creates a <code>XbfFcommonDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFcommonDecl
     */
    public XbfFcommonDecl createXbfFcommonDecl(XbfFcommonDecl source) {
        XbfFcommonDecl xbfFcommonDecl_ = createXbfFcommonDecl();
        xbfFcommonDecl_.setup(source);
        return (xbfFcommonDecl_);
    }

    /**
     * Creates a <code>XbfFstructDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFstructDecl
     */
    public XbfFstructDecl createXbfFstructDecl(XbfFstructDecl source) {
        XbfFstructDecl xbfFstructDecl_ = createXbfFstructDecl();
        xbfFstructDecl_.setup(source);
        return (xbfFstructDecl_);
    }

    /**
     * Creates a <code>XbfFentryDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFentryDecl
     */
    public XbfFentryDecl createXbfFentryDecl(XbfFentryDecl source) {
        XbfFentryDecl xbfFentryDecl_ = createXbfFentryDecl();
        xbfFentryDecl_.setup(source);
        return (xbfFentryDecl_);
    }

    /**
     * Creates a <code>XbfFdataDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFdataDecl
     */
    public XbfFdataDecl createXbfFdataDecl(XbfFdataDecl source) {
        XbfFdataDecl xbfFdataDecl_ = createXbfFdataDecl();
        xbfFdataDecl_.setup(source);
        return (xbfFdataDecl_);
    }

    /**
     * Creates a <code>XbfValueList</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfValueList
     */
    public XbfValueList createXbfValueList(XbfValueList source) {
        XbfValueList xbfValueList_ = createXbfValueList();
        xbfValueList_.setup(source);
        return (xbfValueList_);
    }

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFpragmaStatement
     */
    public XbfFpragmaStatement createXbfFpragmaStatement(XbfFpragmaStatement source) {
        XbfFpragmaStatement xbfFpragmaStatement_ = createXbfFpragmaStatement();
        xbfFpragmaStatement_.setup(source);
        return (xbfFpragmaStatement_);
    }

    /**
     * Creates a <code>XbfBody</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfBody
     */
    public XbfBody createXbfBody(XbfBody source) {
        XbfBody xbfBody_ = createXbfBody();
        xbfBody_.setup(source);
        return (xbfBody_);
    }

    /**
     * Creates a <code>XbfGotoStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfGotoStatement
     */
    public XbfGotoStatement createXbfGotoStatement(XbfGotoStatement source) {
        XbfGotoStatement xbfGotoStatement_ = createXbfGotoStatement();
        xbfGotoStatement_.setup(source);
        return (xbfGotoStatement_);
    }

    /**
     * Creates a <code>XbfFpauseStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFpauseStatement
     */
    public XbfFpauseStatement createXbfFpauseStatement(XbfFpauseStatement source) {
        XbfFpauseStatement xbfFpauseStatement_ = createXbfFpauseStatement();
        xbfFpauseStatement_.setup(source);
        return (xbfFpauseStatement_);
    }

    /**
     * Creates a <code>XbfFcycleStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFcycleStatement
     */
    public XbfFcycleStatement createXbfFcycleStatement(XbfFcycleStatement source) {
        XbfFcycleStatement xbfFcycleStatement_ = createXbfFcycleStatement();
        xbfFcycleStatement_.setup(source);
        return (xbfFcycleStatement_);
    }

    /**
     * Creates a <code>XbfFreadStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFreadStatement
     */
    public XbfFreadStatement createXbfFreadStatement(XbfFreadStatement source) {
        XbfFreadStatement xbfFreadStatement_ = createXbfFreadStatement();
        xbfFreadStatement_.setup(source);
        return (xbfFreadStatement_);
    }

    /**
     * Creates a <code>XbfNamedValueList</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfNamedValueList
     */
    public XbfNamedValueList createXbfNamedValueList(XbfNamedValueList source) {
        XbfNamedValueList xbfNamedValueList_ = createXbfNamedValueList();
        xbfNamedValueList_.setup(source);
        return (xbfNamedValueList_);
    }

    /**
     * Creates a <code>XbfFcloseStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFcloseStatement
     */
    public XbfFcloseStatement createXbfFcloseStatement(XbfFcloseStatement source) {
        XbfFcloseStatement xbfFcloseStatement_ = createXbfFcloseStatement();
        xbfFcloseStatement_.setup(source);
        return (xbfFcloseStatement_);
    }

    /**
     * Creates a <code>XbfFopenStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFopenStatement
     */
    public XbfFopenStatement createXbfFopenStatement(XbfFopenStatement source) {
        XbfFopenStatement xbfFopenStatement_ = createXbfFopenStatement();
        xbfFopenStatement_.setup(source);
        return (xbfFopenStatement_);
    }

    /**
     * Creates a <code>XbfFassignStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFassignStatement
     */
    public XbfFassignStatement createXbfFassignStatement(XbfFassignStatement source) {
        XbfFassignStatement xbfFassignStatement_ = createXbfFassignStatement();
        xbfFassignStatement_.setup(source);
        return (xbfFassignStatement_);
    }

    /**
     * Creates a <code>XbfExprStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfExprStatement
     */
    public XbfExprStatement createXbfExprStatement(XbfExprStatement source) {
        XbfExprStatement xbfExprStatement_ = createXbfExprStatement();
        xbfExprStatement_.setup(source);
        return (xbfExprStatement_);
    }

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFpointerAssignStatement
     */
    public XbfFpointerAssignStatement createXbfFpointerAssignStatement(XbfFpointerAssignStatement source) {
        XbfFpointerAssignStatement xbfFpointerAssignStatement_ = createXbfFpointerAssignStatement();
        xbfFpointerAssignStatement_.setup(source);
        return (xbfFpointerAssignStatement_);
    }

    /**
     * Creates a <code>XbfFifStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFifStatement
     */
    public XbfFifStatement createXbfFifStatement(XbfFifStatement source) {
        XbfFifStatement xbfFifStatement_ = createXbfFifStatement();
        xbfFifStatement_.setup(source);
        return (xbfFifStatement_);
    }

    /**
     * Creates a <code>XbfCondition</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfCondition
     */
    public XbfCondition createXbfCondition(XbfCondition source) {
        XbfCondition xbfCondition_ = createXbfCondition();
        xbfCondition_.setup(source);
        return (xbfCondition_);
    }

    /**
     * Creates a <code>XbfThen</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfThen
     */
    public XbfThen createXbfThen(XbfThen source) {
        XbfThen xbfThen_ = createXbfThen();
        xbfThen_.setup(source);
        return (xbfThen_);
    }

    /**
     * Creates a <code>XbfElse</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfElse
     */
    public XbfElse createXbfElse(XbfElse source) {
        XbfElse xbfElse_ = createXbfElse();
        xbfElse_.setup(source);
        return (xbfElse_);
    }

    /**
     * Creates a <code>XbfFdoStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFdoStatement
     */
    public XbfFdoStatement createXbfFdoStatement(XbfFdoStatement source) {
        XbfFdoStatement xbfFdoStatement_ = createXbfFdoStatement();
        xbfFdoStatement_.setup(source);
        return (xbfFdoStatement_);
    }

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFdoWhileStatement
     */
    public XbfFdoWhileStatement createXbfFdoWhileStatement(XbfFdoWhileStatement source) {
        XbfFdoWhileStatement xbfFdoWhileStatement_ = createXbfFdoWhileStatement();
        xbfFdoWhileStatement_.setup(source);
        return (xbfFdoWhileStatement_);
    }

    /**
     * Creates a <code>XbfContinueStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfContinueStatement
     */
    public XbfContinueStatement createXbfContinueStatement(XbfContinueStatement source) {
        XbfContinueStatement xbfContinueStatement_ = createXbfContinueStatement();
        xbfContinueStatement_.setup(source);
        return (xbfContinueStatement_);
    }

    /**
     * Creates a <code>XbfFexitStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFexitStatement
     */
    public XbfFexitStatement createXbfFexitStatement(XbfFexitStatement source) {
        XbfFexitStatement xbfFexitStatement_ = createXbfFexitStatement();
        xbfFexitStatement_.setup(source);
        return (xbfFexitStatement_);
    }

    /**
     * Creates a <code>XbfFreturnStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFreturnStatement
     */
    public XbfFreturnStatement createXbfFreturnStatement(XbfFreturnStatement source) {
        XbfFreturnStatement xbfFreturnStatement_ = createXbfFreturnStatement();
        xbfFreturnStatement_.setup(source);
        return (xbfFreturnStatement_);
    }

    /**
     * Creates a <code>XbfStatementLabel</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfStatementLabel
     */
    public XbfStatementLabel createXbfStatementLabel(XbfStatementLabel source) {
        XbfStatementLabel xbfStatementLabel_ = createXbfStatementLabel();
        xbfStatementLabel_.setup(source);
        return (xbfStatementLabel_);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFselectCaseStatement
     */
    public XbfFselectCaseStatement createXbfFselectCaseStatement(XbfFselectCaseStatement source) {
        XbfFselectCaseStatement xbfFselectCaseStatement_ = createXbfFselectCaseStatement();
        xbfFselectCaseStatement_.setup(source);
        return (xbfFselectCaseStatement_);
    }

    /**
     * Creates a <code>XbfFcaseLabel</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFcaseLabel
     */
    public XbfFcaseLabel createXbfFcaseLabel(XbfFcaseLabel source) {
        XbfFcaseLabel xbfFcaseLabel_ = createXbfFcaseLabel();
        xbfFcaseLabel_.setup(source);
        return (xbfFcaseLabel_);
    }

    /**
     * Creates a <code>XbfFwhereStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFwhereStatement
     */
    public XbfFwhereStatement createXbfFwhereStatement(XbfFwhereStatement source) {
        XbfFwhereStatement xbfFwhereStatement_ = createXbfFwhereStatement();
        xbfFwhereStatement_.setup(source);
        return (xbfFwhereStatement_);
    }

    /**
     * Creates a <code>XbfFstopStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFstopStatement
     */
    public XbfFstopStatement createXbfFstopStatement(XbfFstopStatement source) {
        XbfFstopStatement xbfFstopStatement_ = createXbfFstopStatement();
        xbfFstopStatement_.setup(source);
        return (xbfFstopStatement_);
    }

    /**
     * Creates a <code>XbfFwriteStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFwriteStatement
     */
    public XbfFwriteStatement createXbfFwriteStatement(XbfFwriteStatement source) {
        XbfFwriteStatement xbfFwriteStatement_ = createXbfFwriteStatement();
        xbfFwriteStatement_.setup(source);
        return (xbfFwriteStatement_);
    }

    /**
     * Creates a <code>XbfFprintStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFprintStatement
     */
    public XbfFprintStatement createXbfFprintStatement(XbfFprintStatement source) {
        XbfFprintStatement xbfFprintStatement_ = createXbfFprintStatement();
        xbfFprintStatement_.setup(source);
        return (xbfFprintStatement_);
    }

    /**
     * Creates a <code>XbfFrewindStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFrewindStatement
     */
    public XbfFrewindStatement createXbfFrewindStatement(XbfFrewindStatement source) {
        XbfFrewindStatement xbfFrewindStatement_ = createXbfFrewindStatement();
        xbfFrewindStatement_.setup(source);
        return (xbfFrewindStatement_);
    }

    /**
     * Creates a <code>XbfFendFileStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFendFileStatement
     */
    public XbfFendFileStatement createXbfFendFileStatement(XbfFendFileStatement source) {
        XbfFendFileStatement xbfFendFileStatement_ = createXbfFendFileStatement();
        xbfFendFileStatement_.setup(source);
        return (xbfFendFileStatement_);
    }

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFbackspaceStatement
     */
    public XbfFbackspaceStatement createXbfFbackspaceStatement(XbfFbackspaceStatement source) {
        XbfFbackspaceStatement xbfFbackspaceStatement_ = createXbfFbackspaceStatement();
        xbfFbackspaceStatement_.setup(source);
        return (xbfFbackspaceStatement_);
    }

    /**
     * Creates a <code>XbfFinquireStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFinquireStatement
     */
    public XbfFinquireStatement createXbfFinquireStatement(XbfFinquireStatement source) {
        XbfFinquireStatement xbfFinquireStatement_ = createXbfFinquireStatement();
        xbfFinquireStatement_.setup(source);
        return (xbfFinquireStatement_);
    }

    /**
     * Creates a <code>XbfFformatDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFformatDecl
     */
    public XbfFformatDecl createXbfFformatDecl(XbfFformatDecl source) {
        XbfFformatDecl xbfFformatDecl_ = createXbfFformatDecl();
        xbfFformatDecl_.setup(source);
        return (xbfFformatDecl_);
    }

    /**
     * Creates a <code>XbfFallocateStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFallocateStatement
     */
    public XbfFallocateStatement createXbfFallocateStatement(XbfFallocateStatement source) {
        XbfFallocateStatement xbfFallocateStatement_ = createXbfFallocateStatement();
        xbfFallocateStatement_.setup(source);
        return (xbfFallocateStatement_);
    }

    /**
     * Creates a <code>XbfAlloc</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfAlloc
     */
    public XbfAlloc createXbfAlloc(XbfAlloc source) {
        XbfAlloc xbfAlloc_ = createXbfAlloc();
        xbfAlloc_.setup(source);
        return (xbfAlloc_);
    }

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFdeallocateStatement
     */
    public XbfFdeallocateStatement createXbfFdeallocateStatement(XbfFdeallocateStatement source) {
        XbfFdeallocateStatement xbfFdeallocateStatement_ = createXbfFdeallocateStatement();
        xbfFdeallocateStatement_.setup(source);
        return (xbfFdeallocateStatement_);
    }

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFnullifyStatement
     */
    public XbfFnullifyStatement createXbfFnullifyStatement(XbfFnullifyStatement source) {
        XbfFnullifyStatement xbfFnullifyStatement_ = createXbfFnullifyStatement();
        xbfFnullifyStatement_.setup(source);
        return (xbfFnullifyStatement_);
    }

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFcontainsStatement
     */
    public XbfFcontainsStatement createXbfFcontainsStatement(XbfFcontainsStatement source) {
        XbfFcontainsStatement xbfFcontainsStatement_ = createXbfFcontainsStatement();
        xbfFcontainsStatement_.setup(source);
        return (xbfFcontainsStatement_);
    }

    /**
     * Creates a <code>XbfText</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfText
     */
    public XbfText createXbfText(XbfText source) {
        XbfText xbfText_ = createXbfText();
        xbfText_.setup(source);
        return (xbfText_);
    }

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFmoduleDefinition
     */
    public XbfFmoduleDefinition createXbfFmoduleDefinition(XbfFmoduleDefinition source) {
        XbfFmoduleDefinition xbfFmoduleDefinition_ = createXbfFmoduleDefinition();
        xbfFmoduleDefinition_.setup(source);
        return (xbfFmoduleDefinition_);
    }

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFblockDataDefinition
     */
    public XbfFblockDataDefinition createXbfFblockDataDefinition(XbfFblockDataDefinition source) {
        XbfFblockDataDefinition xbfFblockDataDefinition_ = createXbfFblockDataDefinition();
        xbfFblockDataDefinition_.setup(source);
        return (xbfFblockDataDefinition_);
    }

    /**
     * Creates a <code>XbfXcodeProgram</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfXcodeProgram
     */
    public XbfXcodeProgram createXbfXcodeProgram(Document doc) {
        XbfXcodeProgram xbfXcodeProgram_ = createXbfXcodeProgram();
        xbfXcodeProgram_.setup(doc);
        return (xbfXcodeProgram_);
    }

    /**
     * Creates a <code>XbfTypeTable</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfTypeTable
     */
    public XbfTypeTable createXbfTypeTable(Document doc) {
        XbfTypeTable xbfTypeTable_ = createXbfTypeTable();
        xbfTypeTable_.setup(doc);
        return (xbfTypeTable_);
    }

    /**
     * Creates a <code>XbfFfunctionType</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFfunctionType
     */
    public XbfFfunctionType createXbfFfunctionType(Document doc) {
        XbfFfunctionType xbfFfunctionType_ = createXbfFfunctionType();
        xbfFfunctionType_.setup(doc);
        return (xbfFfunctionType_);
    }

    /**
     * Creates a <code>XbfParams</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfParams
     */
    public XbfParams createXbfParams(Document doc) {
        XbfParams xbfParams_ = createXbfParams();
        xbfParams_.setup(doc);
        return (xbfParams_);
    }

    /**
     * Creates a <code>XbfName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfName
     */
    public XbfName createXbfName(Document doc) {
        XbfName xbfName_ = createXbfName();
        xbfName_.setup(doc);
        return (xbfName_);
    }

    /**
     * Creates a <code>XbfFbasicType</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFbasicType
     */
    public XbfFbasicType createXbfFbasicType(Document doc) {
        XbfFbasicType xbfFbasicType_ = createXbfFbasicType();
        xbfFbasicType_.setup(doc);
        return (xbfFbasicType_);
    }

    /**
     * Creates a <code>XbfKind</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfKind
     */
    public XbfKind createXbfKind(Document doc) {
        XbfKind xbfKind_ = createXbfKind();
        xbfKind_.setup(doc);
        return (xbfKind_);
    }

    /**
     * Creates a <code>XbfFarrayRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFarrayRef
     */
    public XbfFarrayRef createXbfFarrayRef(Document doc) {
        XbfFarrayRef xbfFarrayRef_ = createXbfFarrayRef();
        xbfFarrayRef_.setup(doc);
        return (xbfFarrayRef_);
    }

    /**
     * Creates a <code>XbfVarRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfVarRef
     */
    public XbfVarRef createXbfVarRef(Document doc) {
        XbfVarRef xbfVarRef_ = createXbfVarRef();
        xbfVarRef_.setup(doc);
        return (xbfVarRef_);
    }

    /**
     * Creates a <code>XbfFcharacterRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFcharacterRef
     */
    public XbfFcharacterRef createXbfFcharacterRef(Document doc) {
        XbfFcharacterRef xbfFcharacterRef_ = createXbfFcharacterRef();
        xbfFcharacterRef_.setup(doc);
        return (xbfFcharacterRef_);
    }

    /**
     * Creates a <code>XbfIndexRange</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfIndexRange
     */
    public XbfIndexRange createXbfIndexRange(Document doc) {
        XbfIndexRange xbfIndexRange_ = createXbfIndexRange();
        xbfIndexRange_.setup(doc);
        return (xbfIndexRange_);
    }

    /**
     * Creates a <code>XbfLowerBound</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLowerBound
     */
    public XbfLowerBound createXbfLowerBound(Document doc) {
        XbfLowerBound xbfLowerBound_ = createXbfLowerBound();
        xbfLowerBound_.setup(doc);
        return (xbfLowerBound_);
    }

    /**
     * Creates a <code>XbfUpperBound</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfUpperBound
     */
    public XbfUpperBound createXbfUpperBound(Document doc) {
        XbfUpperBound xbfUpperBound_ = createXbfUpperBound();
        xbfUpperBound_.setup(doc);
        return (xbfUpperBound_);
    }

    /**
     * Creates a <code>XbfStep</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfStep
     */
    public XbfStep createXbfStep(Document doc) {
        XbfStep xbfStep_ = createXbfStep();
        xbfStep_.setup(doc);
        return (xbfStep_);
    }

    /**
     * Creates a <code>XbfFmemberRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFmemberRef
     */
    public XbfFmemberRef createXbfFmemberRef(Document doc) {
        XbfFmemberRef xbfFmemberRef_ = createXbfFmemberRef();
        xbfFmemberRef_.setup(doc);
        return (xbfFmemberRef_);
    }

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFcoArrayRef
     */
    public XbfFcoArrayRef createXbfFcoArrayRef(Document doc) {
        XbfFcoArrayRef xbfFcoArrayRef_ = createXbfFcoArrayRef();
        xbfFcoArrayRef_.setup(doc);
        return (xbfFcoArrayRef_);
    }

    /**
     * Creates a <code>XbfArrayIndex</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfArrayIndex
     */
    public XbfArrayIndex createXbfArrayIndex(Document doc) {
        XbfArrayIndex xbfArrayIndex_ = createXbfArrayIndex();
        xbfArrayIndex_.setup(doc);
        return (xbfArrayIndex_);
    }

    /**
     * Creates a <code>XbfVar</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfVar
     */
    public XbfVar createXbfVar(Document doc) {
        XbfVar xbfVar_ = createXbfVar();
        xbfVar_.setup(doc);
        return (xbfVar_);
    }

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFarrayConstructor
     */
    public XbfFarrayConstructor createXbfFarrayConstructor(Document doc) {
        XbfFarrayConstructor xbfFarrayConstructor_ = createXbfFarrayConstructor();
        xbfFarrayConstructor_.setup(doc);
        return (xbfFarrayConstructor_);
    }

    /**
     * Creates a <code>XbfFdoLoop</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFdoLoop
     */
    public XbfFdoLoop createXbfFdoLoop(Document doc) {
        XbfFdoLoop xbfFdoLoop_ = createXbfFdoLoop();
        xbfFdoLoop_.setup(doc);
        return (xbfFdoLoop_);
    }

    /**
     * Creates a <code>XbfValue</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfValue
     */
    public XbfValue createXbfValue(Document doc) {
        XbfValue xbfValue_ = createXbfValue();
        xbfValue_.setup(doc);
        return (xbfValue_);
    }

    /**
     * Creates a <code>XbfRepeatCount</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfRepeatCount
     */
    public XbfRepeatCount createXbfRepeatCount(Document doc) {
        XbfRepeatCount xbfRepeatCount_ = createXbfRepeatCount();
        xbfRepeatCount_.setup(doc);
        return (xbfRepeatCount_);
    }

    /**
     * Creates a <code>XbfFintConstant</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFintConstant
     */
    public XbfFintConstant createXbfFintConstant(Document doc) {
        XbfFintConstant xbfFintConstant_ = createXbfFintConstant();
        xbfFintConstant_.setup(doc);
        return (xbfFintConstant_);
    }

    /**
     * Creates a <code>XbfFrealConstant</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFrealConstant
     */
    public XbfFrealConstant createXbfFrealConstant(Document doc) {
        XbfFrealConstant xbfFrealConstant_ = createXbfFrealConstant();
        xbfFrealConstant_.setup(doc);
        return (xbfFrealConstant_);
    }

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFcharacterConstant
     */
    public XbfFcharacterConstant createXbfFcharacterConstant(Document doc) {
        XbfFcharacterConstant xbfFcharacterConstant_ = createXbfFcharacterConstant();
        xbfFcharacterConstant_.setup(doc);
        return (xbfFcharacterConstant_);
    }

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFlogicalConstant
     */
    public XbfFlogicalConstant createXbfFlogicalConstant(Document doc) {
        XbfFlogicalConstant xbfFlogicalConstant_ = createXbfFlogicalConstant();
        xbfFlogicalConstant_.setup(doc);
        return (xbfFlogicalConstant_);
    }

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFcomplexConstant
     */
    public XbfFcomplexConstant createXbfFcomplexConstant(Document doc) {
        XbfFcomplexConstant xbfFcomplexConstant_ = createXbfFcomplexConstant();
        xbfFcomplexConstant_.setup(doc);
        return (xbfFcomplexConstant_);
    }

    /**
     * Creates a <code>XbfFstructConstructor</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFstructConstructor
     */
    public XbfFstructConstructor createXbfFstructConstructor(Document doc) {
        XbfFstructConstructor xbfFstructConstructor_ = createXbfFstructConstructor();
        xbfFstructConstructor_.setup(doc);
        return (xbfFstructConstructor_);
    }

    /**
     * Creates a <code>XbfFunctionCall</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFunctionCall
     */
    public XbfFunctionCall createXbfFunctionCall(Document doc) {
        XbfFunctionCall xbfFunctionCall_ = createXbfFunctionCall();
        xbfFunctionCall_.setup(doc);
        return (xbfFunctionCall_);
    }

    /**
     * Creates a <code>XbfArguments</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfArguments
     */
    public XbfArguments createXbfArguments(Document doc) {
        XbfArguments xbfArguments_ = createXbfArguments();
        xbfArguments_.setup(doc);
        return (xbfArguments_);
    }

    /**
     * Creates a <code>XbfNamedValue</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfNamedValue
     */
    public XbfNamedValue createXbfNamedValue(Document doc) {
        XbfNamedValue xbfNamedValue_ = createXbfNamedValue();
        xbfNamedValue_.setup(doc);
        return (xbfNamedValue_);
    }

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfUserUnaryExpr
     */
    public XbfUserUnaryExpr createXbfUserUnaryExpr(Document doc) {
        XbfUserUnaryExpr xbfUserUnaryExpr_ = createXbfUserUnaryExpr();
        xbfUserUnaryExpr_.setup(doc);
        return (xbfUserUnaryExpr_);
    }

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfUserBinaryExpr
     */
    public XbfUserBinaryExpr createXbfUserBinaryExpr(Document doc) {
        XbfUserBinaryExpr xbfUserBinaryExpr_ = createXbfUserBinaryExpr();
        xbfUserBinaryExpr_.setup(doc);
        return (xbfUserBinaryExpr_);
    }

    /**
     * Creates a <code>XbfLogNotExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLogNotExpr
     */
    public XbfLogNotExpr createXbfLogNotExpr(Document doc) {
        XbfLogNotExpr xbfLogNotExpr_ = createXbfLogNotExpr();
        xbfLogNotExpr_.setup(doc);
        return (xbfLogNotExpr_);
    }

    /**
     * Creates a <code>XbfFfunction</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFfunction
     */
    public XbfFfunction createXbfFfunction(Document doc) {
        XbfFfunction xbfFfunction_ = createXbfFfunction();
        xbfFfunction_.setup(doc);
        return (xbfFfunction_);
    }

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLogNEQExpr
     */
    public XbfLogNEQExpr createXbfLogNEQExpr(Document doc) {
        XbfLogNEQExpr xbfLogNEQExpr_ = createXbfLogNEQExpr();
        xbfLogNEQExpr_.setup(doc);
        return (xbfLogNEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGTExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLogGTExpr
     */
    public XbfLogGTExpr createXbfLogGTExpr(Document doc) {
        XbfLogGTExpr xbfLogGTExpr_ = createXbfLogGTExpr();
        xbfLogGTExpr_.setup(doc);
        return (xbfLogGTExpr_);
    }

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLogNEQVExpr
     */
    public XbfLogNEQVExpr createXbfLogNEQVExpr(Document doc) {
        XbfLogNEQVExpr xbfLogNEQVExpr_ = createXbfLogNEQVExpr();
        xbfLogNEQVExpr_.setup(doc);
        return (xbfLogNEQVExpr_);
    }

    /**
     * Creates a <code>XbfPlusExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfPlusExpr
     */
    public XbfPlusExpr createXbfPlusExpr(Document doc) {
        XbfPlusExpr xbfPlusExpr_ = createXbfPlusExpr();
        xbfPlusExpr_.setup(doc);
        return (xbfPlusExpr_);
    }

    /**
     * Creates a <code>XbfMinusExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfMinusExpr
     */
    public XbfMinusExpr createXbfMinusExpr(Document doc) {
        XbfMinusExpr xbfMinusExpr_ = createXbfMinusExpr();
        xbfMinusExpr_.setup(doc);
        return (xbfMinusExpr_);
    }

    /**
     * Creates a <code>XbfMulExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfMulExpr
     */
    public XbfMulExpr createXbfMulExpr(Document doc) {
        XbfMulExpr xbfMulExpr_ = createXbfMulExpr();
        xbfMulExpr_.setup(doc);
        return (xbfMulExpr_);
    }

    /**
     * Creates a <code>XbfDivExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfDivExpr
     */
    public XbfDivExpr createXbfDivExpr(Document doc) {
        XbfDivExpr xbfDivExpr_ = createXbfDivExpr();
        xbfDivExpr_.setup(doc);
        return (xbfDivExpr_);
    }

    /**
     * Creates a <code>XbfFpowerExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFpowerExpr
     */
    public XbfFpowerExpr createXbfFpowerExpr(Document doc) {
        XbfFpowerExpr xbfFpowerExpr_ = createXbfFpowerExpr();
        xbfFpowerExpr_.setup(doc);
        return (xbfFpowerExpr_);
    }

    /**
     * Creates a <code>XbfFconcatExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFconcatExpr
     */
    public XbfFconcatExpr createXbfFconcatExpr(Document doc) {
        XbfFconcatExpr xbfFconcatExpr_ = createXbfFconcatExpr();
        xbfFconcatExpr_.setup(doc);
        return (xbfFconcatExpr_);
    }

    /**
     * Creates a <code>XbfLogEQExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLogEQExpr
     */
    public XbfLogEQExpr createXbfLogEQExpr(Document doc) {
        XbfLogEQExpr xbfLogEQExpr_ = createXbfLogEQExpr();
        xbfLogEQExpr_.setup(doc);
        return (xbfLogEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGEExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLogGEExpr
     */
    public XbfLogGEExpr createXbfLogGEExpr(Document doc) {
        XbfLogGEExpr xbfLogGEExpr_ = createXbfLogGEExpr();
        xbfLogGEExpr_.setup(doc);
        return (xbfLogGEExpr_);
    }

    /**
     * Creates a <code>XbfLogLEExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLogLEExpr
     */
    public XbfLogLEExpr createXbfLogLEExpr(Document doc) {
        XbfLogLEExpr xbfLogLEExpr_ = createXbfLogLEExpr();
        xbfLogLEExpr_.setup(doc);
        return (xbfLogLEExpr_);
    }

    /**
     * Creates a <code>XbfLogLTExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLogLTExpr
     */
    public XbfLogLTExpr createXbfLogLTExpr(Document doc) {
        XbfLogLTExpr xbfLogLTExpr_ = createXbfLogLTExpr();
        xbfLogLTExpr_.setup(doc);
        return (xbfLogLTExpr_);
    }

    /**
     * Creates a <code>XbfLogAndExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLogAndExpr
     */
    public XbfLogAndExpr createXbfLogAndExpr(Document doc) {
        XbfLogAndExpr xbfLogAndExpr_ = createXbfLogAndExpr();
        xbfLogAndExpr_.setup(doc);
        return (xbfLogAndExpr_);
    }

    /**
     * Creates a <code>XbfLogOrExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLogOrExpr
     */
    public XbfLogOrExpr createXbfLogOrExpr(Document doc) {
        XbfLogOrExpr xbfLogOrExpr_ = createXbfLogOrExpr();
        xbfLogOrExpr_.setup(doc);
        return (xbfLogOrExpr_);
    }

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLogEQVExpr
     */
    public XbfLogEQVExpr createXbfLogEQVExpr(Document doc) {
        XbfLogEQVExpr xbfLogEQVExpr_ = createXbfLogEQVExpr();
        xbfLogEQVExpr_.setup(doc);
        return (xbfLogEQVExpr_);
    }

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfUnaryMinusExpr
     */
    public XbfUnaryMinusExpr createXbfUnaryMinusExpr(Document doc) {
        XbfUnaryMinusExpr xbfUnaryMinusExpr_ = createXbfUnaryMinusExpr();
        xbfUnaryMinusExpr_.setup(doc);
        return (xbfUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbfLen</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfLen
     */
    public XbfLen createXbfLen(Document doc) {
        XbfLen xbfLen_ = createXbfLen();
        xbfLen_.setup(doc);
        return (xbfLen_);
    }

    /**
     * Creates a <code>XbfCoShape</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfCoShape
     */
    public XbfCoShape createXbfCoShape(Document doc) {
        XbfCoShape xbfCoShape_ = createXbfCoShape();
        xbfCoShape_.setup(doc);
        return (xbfCoShape_);
    }

    /**
     * Creates a <code>XbfFstructType</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFstructType
     */
    public XbfFstructType createXbfFstructType(Document doc) {
        XbfFstructType xbfFstructType_ = createXbfFstructType();
        xbfFstructType_.setup(doc);
        return (xbfFstructType_);
    }

    /**
     * Creates a <code>XbfSymbols</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfSymbols
     */
    public XbfSymbols createXbfSymbols(Document doc) {
        XbfSymbols xbfSymbols_ = createXbfSymbols();
        xbfSymbols_.setup(doc);
        return (xbfSymbols_);
    }

    /**
     * Creates a <code>XbfId</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfId
     */
    public XbfId createXbfId(Document doc) {
        XbfId xbfId_ = createXbfId();
        xbfId_.setup(doc);
        return (xbfId_);
    }

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfGlobalSymbols
     */
    public XbfGlobalSymbols createXbfGlobalSymbols(Document doc) {
        XbfGlobalSymbols xbfGlobalSymbols_ = createXbfGlobalSymbols();
        xbfGlobalSymbols_.setup(doc);
        return (xbfGlobalSymbols_);
    }

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfGlobalDeclarations
     */
    public XbfGlobalDeclarations createXbfGlobalDeclarations(Document doc) {
        XbfGlobalDeclarations xbfGlobalDeclarations_ = createXbfGlobalDeclarations();
        xbfGlobalDeclarations_.setup(doc);
        return (xbfGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFfunctionDefinition
     */
    public XbfFfunctionDefinition createXbfFfunctionDefinition(Document doc) {
        XbfFfunctionDefinition xbfFfunctionDefinition_ = createXbfFfunctionDefinition();
        xbfFfunctionDefinition_.setup(doc);
        return (xbfFfunctionDefinition_);
    }

    /**
     * Creates a <code>XbfDeclarations</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfDeclarations
     */
    public XbfDeclarations createXbfDeclarations(Document doc) {
        XbfDeclarations xbfDeclarations_ = createXbfDeclarations();
        xbfDeclarations_.setup(doc);
        return (xbfDeclarations_);
    }

    /**
     * Creates a <code>XbfVarDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfVarDecl
     */
    public XbfVarDecl createXbfVarDecl(Document doc) {
        XbfVarDecl xbfVarDecl_ = createXbfVarDecl();
        xbfVarDecl_.setup(doc);
        return (xbfVarDecl_);
    }

    /**
     * Creates a <code>XbfExternDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfExternDecl
     */
    public XbfExternDecl createXbfExternDecl(Document doc) {
        XbfExternDecl xbfExternDecl_ = createXbfExternDecl();
        xbfExternDecl_.setup(doc);
        return (xbfExternDecl_);
    }

    /**
     * Creates a <code>XbfFuseDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFuseDecl
     */
    public XbfFuseDecl createXbfFuseDecl(Document doc) {
        XbfFuseDecl xbfFuseDecl_ = createXbfFuseDecl();
        xbfFuseDecl_.setup(doc);
        return (xbfFuseDecl_);
    }

    /**
     * Creates a <code>XbfRename</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfRename
     */
    public XbfRename createXbfRename(Document doc) {
        XbfRename xbfRename_ = createXbfRename();
        xbfRename_.setup(doc);
        return (xbfRename_);
    }

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFuseOnlyDecl
     */
    public XbfFuseOnlyDecl createXbfFuseOnlyDecl(Document doc) {
        XbfFuseOnlyDecl xbfFuseOnlyDecl_ = createXbfFuseOnlyDecl();
        xbfFuseOnlyDecl_.setup(doc);
        return (xbfFuseOnlyDecl_);
    }

    /**
     * Creates a <code>XbfRenamable</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfRenamable
     */
    public XbfRenamable createXbfRenamable(Document doc) {
        XbfRenamable xbfRenamable_ = createXbfRenamable();
        xbfRenamable_.setup(doc);
        return (xbfRenamable_);
    }

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFinterfaceDecl
     */
    public XbfFinterfaceDecl createXbfFinterfaceDecl(Document doc) {
        XbfFinterfaceDecl xbfFinterfaceDecl_ = createXbfFinterfaceDecl();
        xbfFinterfaceDecl_.setup(doc);
        return (xbfFinterfaceDecl_);
    }

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFfunctionDecl
     */
    public XbfFfunctionDecl createXbfFfunctionDecl(Document doc) {
        XbfFfunctionDecl xbfFfunctionDecl_ = createXbfFfunctionDecl();
        xbfFfunctionDecl_.setup(doc);
        return (xbfFfunctionDecl_);
    }

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFmoduleProcedureDecl
     */
    public XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(Document doc) {
        XbfFmoduleProcedureDecl xbfFmoduleProcedureDecl_ = createXbfFmoduleProcedureDecl();
        xbfFmoduleProcedureDecl_.setup(doc);
        return (xbfFmoduleProcedureDecl_);
    }

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFnamelistDecl
     */
    public XbfFnamelistDecl createXbfFnamelistDecl(Document doc) {
        XbfFnamelistDecl xbfFnamelistDecl_ = createXbfFnamelistDecl();
        xbfFnamelistDecl_.setup(doc);
        return (xbfFnamelistDecl_);
    }

    /**
     * Creates a <code>XbfVarList</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfVarList
     */
    public XbfVarList createXbfVarList(Document doc) {
        XbfVarList xbfVarList_ = createXbfVarList();
        xbfVarList_.setup(doc);
        return (xbfVarList_);
    }

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFequivalenceDecl
     */
    public XbfFequivalenceDecl createXbfFequivalenceDecl(Document doc) {
        XbfFequivalenceDecl xbfFequivalenceDecl_ = createXbfFequivalenceDecl();
        xbfFequivalenceDecl_.setup(doc);
        return (xbfFequivalenceDecl_);
    }

    /**
     * Creates a <code>XbfFcommonDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFcommonDecl
     */
    public XbfFcommonDecl createXbfFcommonDecl(Document doc) {
        XbfFcommonDecl xbfFcommonDecl_ = createXbfFcommonDecl();
        xbfFcommonDecl_.setup(doc);
        return (xbfFcommonDecl_);
    }

    /**
     * Creates a <code>XbfFstructDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFstructDecl
     */
    public XbfFstructDecl createXbfFstructDecl(Document doc) {
        XbfFstructDecl xbfFstructDecl_ = createXbfFstructDecl();
        xbfFstructDecl_.setup(doc);
        return (xbfFstructDecl_);
    }

    /**
     * Creates a <code>XbfFentryDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFentryDecl
     */
    public XbfFentryDecl createXbfFentryDecl(Document doc) {
        XbfFentryDecl xbfFentryDecl_ = createXbfFentryDecl();
        xbfFentryDecl_.setup(doc);
        return (xbfFentryDecl_);
    }

    /**
     * Creates a <code>XbfFdataDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFdataDecl
     */
    public XbfFdataDecl createXbfFdataDecl(Document doc) {
        XbfFdataDecl xbfFdataDecl_ = createXbfFdataDecl();
        xbfFdataDecl_.setup(doc);
        return (xbfFdataDecl_);
    }

    /**
     * Creates a <code>XbfValueList</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfValueList
     */
    public XbfValueList createXbfValueList(Document doc) {
        XbfValueList xbfValueList_ = createXbfValueList();
        xbfValueList_.setup(doc);
        return (xbfValueList_);
    }

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFpragmaStatement
     */
    public XbfFpragmaStatement createXbfFpragmaStatement(Document doc) {
        XbfFpragmaStatement xbfFpragmaStatement_ = createXbfFpragmaStatement();
        xbfFpragmaStatement_.setup(doc);
        return (xbfFpragmaStatement_);
    }

    /**
     * Creates a <code>XbfBody</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfBody
     */
    public XbfBody createXbfBody(Document doc) {
        XbfBody xbfBody_ = createXbfBody();
        xbfBody_.setup(doc);
        return (xbfBody_);
    }

    /**
     * Creates a <code>XbfGotoStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfGotoStatement
     */
    public XbfGotoStatement createXbfGotoStatement(Document doc) {
        XbfGotoStatement xbfGotoStatement_ = createXbfGotoStatement();
        xbfGotoStatement_.setup(doc);
        return (xbfGotoStatement_);
    }

    /**
     * Creates a <code>XbfFpauseStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFpauseStatement
     */
    public XbfFpauseStatement createXbfFpauseStatement(Document doc) {
        XbfFpauseStatement xbfFpauseStatement_ = createXbfFpauseStatement();
        xbfFpauseStatement_.setup(doc);
        return (xbfFpauseStatement_);
    }

    /**
     * Creates a <code>XbfFcycleStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFcycleStatement
     */
    public XbfFcycleStatement createXbfFcycleStatement(Document doc) {
        XbfFcycleStatement xbfFcycleStatement_ = createXbfFcycleStatement();
        xbfFcycleStatement_.setup(doc);
        return (xbfFcycleStatement_);
    }

    /**
     * Creates a <code>XbfFreadStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFreadStatement
     */
    public XbfFreadStatement createXbfFreadStatement(Document doc) {
        XbfFreadStatement xbfFreadStatement_ = createXbfFreadStatement();
        xbfFreadStatement_.setup(doc);
        return (xbfFreadStatement_);
    }

    /**
     * Creates a <code>XbfNamedValueList</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfNamedValueList
     */
    public XbfNamedValueList createXbfNamedValueList(Document doc) {
        XbfNamedValueList xbfNamedValueList_ = createXbfNamedValueList();
        xbfNamedValueList_.setup(doc);
        return (xbfNamedValueList_);
    }

    /**
     * Creates a <code>XbfFcloseStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFcloseStatement
     */
    public XbfFcloseStatement createXbfFcloseStatement(Document doc) {
        XbfFcloseStatement xbfFcloseStatement_ = createXbfFcloseStatement();
        xbfFcloseStatement_.setup(doc);
        return (xbfFcloseStatement_);
    }

    /**
     * Creates a <code>XbfFopenStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFopenStatement
     */
    public XbfFopenStatement createXbfFopenStatement(Document doc) {
        XbfFopenStatement xbfFopenStatement_ = createXbfFopenStatement();
        xbfFopenStatement_.setup(doc);
        return (xbfFopenStatement_);
    }

    /**
     * Creates a <code>XbfFassignStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFassignStatement
     */
    public XbfFassignStatement createXbfFassignStatement(Document doc) {
        XbfFassignStatement xbfFassignStatement_ = createXbfFassignStatement();
        xbfFassignStatement_.setup(doc);
        return (xbfFassignStatement_);
    }

    /**
     * Creates a <code>XbfExprStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfExprStatement
     */
    public XbfExprStatement createXbfExprStatement(Document doc) {
        XbfExprStatement xbfExprStatement_ = createXbfExprStatement();
        xbfExprStatement_.setup(doc);
        return (xbfExprStatement_);
    }

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFpointerAssignStatement
     */
    public XbfFpointerAssignStatement createXbfFpointerAssignStatement(Document doc) {
        XbfFpointerAssignStatement xbfFpointerAssignStatement_ = createXbfFpointerAssignStatement();
        xbfFpointerAssignStatement_.setup(doc);
        return (xbfFpointerAssignStatement_);
    }

    /**
     * Creates a <code>XbfFifStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFifStatement
     */
    public XbfFifStatement createXbfFifStatement(Document doc) {
        XbfFifStatement xbfFifStatement_ = createXbfFifStatement();
        xbfFifStatement_.setup(doc);
        return (xbfFifStatement_);
    }

    /**
     * Creates a <code>XbfCondition</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfCondition
     */
    public XbfCondition createXbfCondition(Document doc) {
        XbfCondition xbfCondition_ = createXbfCondition();
        xbfCondition_.setup(doc);
        return (xbfCondition_);
    }

    /**
     * Creates a <code>XbfThen</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfThen
     */
    public XbfThen createXbfThen(Document doc) {
        XbfThen xbfThen_ = createXbfThen();
        xbfThen_.setup(doc);
        return (xbfThen_);
    }

    /**
     * Creates a <code>XbfElse</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfElse
     */
    public XbfElse createXbfElse(Document doc) {
        XbfElse xbfElse_ = createXbfElse();
        xbfElse_.setup(doc);
        return (xbfElse_);
    }

    /**
     * Creates a <code>XbfFdoStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFdoStatement
     */
    public XbfFdoStatement createXbfFdoStatement(Document doc) {
        XbfFdoStatement xbfFdoStatement_ = createXbfFdoStatement();
        xbfFdoStatement_.setup(doc);
        return (xbfFdoStatement_);
    }

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFdoWhileStatement
     */
    public XbfFdoWhileStatement createXbfFdoWhileStatement(Document doc) {
        XbfFdoWhileStatement xbfFdoWhileStatement_ = createXbfFdoWhileStatement();
        xbfFdoWhileStatement_.setup(doc);
        return (xbfFdoWhileStatement_);
    }

    /**
     * Creates a <code>XbfContinueStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfContinueStatement
     */
    public XbfContinueStatement createXbfContinueStatement(Document doc) {
        XbfContinueStatement xbfContinueStatement_ = createXbfContinueStatement();
        xbfContinueStatement_.setup(doc);
        return (xbfContinueStatement_);
    }

    /**
     * Creates a <code>XbfFexitStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFexitStatement
     */
    public XbfFexitStatement createXbfFexitStatement(Document doc) {
        XbfFexitStatement xbfFexitStatement_ = createXbfFexitStatement();
        xbfFexitStatement_.setup(doc);
        return (xbfFexitStatement_);
    }

    /**
     * Creates a <code>XbfFreturnStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFreturnStatement
     */
    public XbfFreturnStatement createXbfFreturnStatement(Document doc) {
        XbfFreturnStatement xbfFreturnStatement_ = createXbfFreturnStatement();
        xbfFreturnStatement_.setup(doc);
        return (xbfFreturnStatement_);
    }

    /**
     * Creates a <code>XbfStatementLabel</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfStatementLabel
     */
    public XbfStatementLabel createXbfStatementLabel(Document doc) {
        XbfStatementLabel xbfStatementLabel_ = createXbfStatementLabel();
        xbfStatementLabel_.setup(doc);
        return (xbfStatementLabel_);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFselectCaseStatement
     */
    public XbfFselectCaseStatement createXbfFselectCaseStatement(Document doc) {
        XbfFselectCaseStatement xbfFselectCaseStatement_ = createXbfFselectCaseStatement();
        xbfFselectCaseStatement_.setup(doc);
        return (xbfFselectCaseStatement_);
    }

    /**
     * Creates a <code>XbfFcaseLabel</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFcaseLabel
     */
    public XbfFcaseLabel createXbfFcaseLabel(Document doc) {
        XbfFcaseLabel xbfFcaseLabel_ = createXbfFcaseLabel();
        xbfFcaseLabel_.setup(doc);
        return (xbfFcaseLabel_);
    }

    /**
     * Creates a <code>XbfFwhereStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFwhereStatement
     */
    public XbfFwhereStatement createXbfFwhereStatement(Document doc) {
        XbfFwhereStatement xbfFwhereStatement_ = createXbfFwhereStatement();
        xbfFwhereStatement_.setup(doc);
        return (xbfFwhereStatement_);
    }

    /**
     * Creates a <code>XbfFstopStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFstopStatement
     */
    public XbfFstopStatement createXbfFstopStatement(Document doc) {
        XbfFstopStatement xbfFstopStatement_ = createXbfFstopStatement();
        xbfFstopStatement_.setup(doc);
        return (xbfFstopStatement_);
    }

    /**
     * Creates a <code>XbfFwriteStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFwriteStatement
     */
    public XbfFwriteStatement createXbfFwriteStatement(Document doc) {
        XbfFwriteStatement xbfFwriteStatement_ = createXbfFwriteStatement();
        xbfFwriteStatement_.setup(doc);
        return (xbfFwriteStatement_);
    }

    /**
     * Creates a <code>XbfFprintStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFprintStatement
     */
    public XbfFprintStatement createXbfFprintStatement(Document doc) {
        XbfFprintStatement xbfFprintStatement_ = createXbfFprintStatement();
        xbfFprintStatement_.setup(doc);
        return (xbfFprintStatement_);
    }

    /**
     * Creates a <code>XbfFrewindStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFrewindStatement
     */
    public XbfFrewindStatement createXbfFrewindStatement(Document doc) {
        XbfFrewindStatement xbfFrewindStatement_ = createXbfFrewindStatement();
        xbfFrewindStatement_.setup(doc);
        return (xbfFrewindStatement_);
    }

    /**
     * Creates a <code>XbfFendFileStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFendFileStatement
     */
    public XbfFendFileStatement createXbfFendFileStatement(Document doc) {
        XbfFendFileStatement xbfFendFileStatement_ = createXbfFendFileStatement();
        xbfFendFileStatement_.setup(doc);
        return (xbfFendFileStatement_);
    }

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFbackspaceStatement
     */
    public XbfFbackspaceStatement createXbfFbackspaceStatement(Document doc) {
        XbfFbackspaceStatement xbfFbackspaceStatement_ = createXbfFbackspaceStatement();
        xbfFbackspaceStatement_.setup(doc);
        return (xbfFbackspaceStatement_);
    }

    /**
     * Creates a <code>XbfFinquireStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFinquireStatement
     */
    public XbfFinquireStatement createXbfFinquireStatement(Document doc) {
        XbfFinquireStatement xbfFinquireStatement_ = createXbfFinquireStatement();
        xbfFinquireStatement_.setup(doc);
        return (xbfFinquireStatement_);
    }

    /**
     * Creates a <code>XbfFformatDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFformatDecl
     */
    public XbfFformatDecl createXbfFformatDecl(Document doc) {
        XbfFformatDecl xbfFformatDecl_ = createXbfFformatDecl();
        xbfFformatDecl_.setup(doc);
        return (xbfFformatDecl_);
    }

    /**
     * Creates a <code>XbfFallocateStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFallocateStatement
     */
    public XbfFallocateStatement createXbfFallocateStatement(Document doc) {
        XbfFallocateStatement xbfFallocateStatement_ = createXbfFallocateStatement();
        xbfFallocateStatement_.setup(doc);
        return (xbfFallocateStatement_);
    }

    /**
     * Creates a <code>XbfAlloc</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfAlloc
     */
    public XbfAlloc createXbfAlloc(Document doc) {
        XbfAlloc xbfAlloc_ = createXbfAlloc();
        xbfAlloc_.setup(doc);
        return (xbfAlloc_);
    }

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFdeallocateStatement
     */
    public XbfFdeallocateStatement createXbfFdeallocateStatement(Document doc) {
        XbfFdeallocateStatement xbfFdeallocateStatement_ = createXbfFdeallocateStatement();
        xbfFdeallocateStatement_.setup(doc);
        return (xbfFdeallocateStatement_);
    }

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFnullifyStatement
     */
    public XbfFnullifyStatement createXbfFnullifyStatement(Document doc) {
        XbfFnullifyStatement xbfFnullifyStatement_ = createXbfFnullifyStatement();
        xbfFnullifyStatement_.setup(doc);
        return (xbfFnullifyStatement_);
    }

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFcontainsStatement
     */
    public XbfFcontainsStatement createXbfFcontainsStatement(Document doc) {
        XbfFcontainsStatement xbfFcontainsStatement_ = createXbfFcontainsStatement();
        xbfFcontainsStatement_.setup(doc);
        return (xbfFcontainsStatement_);
    }

    /**
     * Creates a <code>XbfText</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfText
     */
    public XbfText createXbfText(Document doc) {
        XbfText xbfText_ = createXbfText();
        xbfText_.setup(doc);
        return (xbfText_);
    }

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFmoduleDefinition
     */
    public XbfFmoduleDefinition createXbfFmoduleDefinition(Document doc) {
        XbfFmoduleDefinition xbfFmoduleDefinition_ = createXbfFmoduleDefinition();
        xbfFmoduleDefinition_.setup(doc);
        return (xbfFmoduleDefinition_);
    }

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbfFblockDataDefinition
     */
    public XbfFblockDataDefinition createXbfFblockDataDefinition(Document doc) {
        XbfFblockDataDefinition xbfFblockDataDefinition_ = createXbfFblockDataDefinition();
        xbfFblockDataDefinition_.setup(doc);
        return (xbfFblockDataDefinition_);
    }

    /**
     * Creates a <code>XbfXcodeProgram</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfXcodeProgram
     */
    public XbfXcodeProgram createXbfXcodeProgram(Element element) {
        XbfXcodeProgram xbfXcodeProgram_ = createXbfXcodeProgram();
        xbfXcodeProgram_.setup(element);
        return (xbfXcodeProgram_);
    }

    /**
     * Creates a <code>XbfTypeTable</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfTypeTable
     */
    public XbfTypeTable createXbfTypeTable(Element element) {
        XbfTypeTable xbfTypeTable_ = createXbfTypeTable();
        xbfTypeTable_.setup(element);
        return (xbfTypeTable_);
    }

    /**
     * Creates a <code>XbfFfunctionType</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFfunctionType
     */
    public XbfFfunctionType createXbfFfunctionType(Element element) {
        XbfFfunctionType xbfFfunctionType_ = createXbfFfunctionType();
        xbfFfunctionType_.setup(element);
        return (xbfFfunctionType_);
    }

    /**
     * Creates a <code>XbfParams</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfParams
     */
    public XbfParams createXbfParams(Element element) {
        XbfParams xbfParams_ = createXbfParams();
        xbfParams_.setup(element);
        return (xbfParams_);
    }

    /**
     * Creates a <code>XbfName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfName
     */
    public XbfName createXbfName(Element element) {
        XbfName xbfName_ = createXbfName();
        xbfName_.setup(element);
        return (xbfName_);
    }

    /**
     * Creates a <code>XbfFbasicType</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFbasicType
     */
    public XbfFbasicType createXbfFbasicType(Element element) {
        XbfFbasicType xbfFbasicType_ = createXbfFbasicType();
        xbfFbasicType_.setup(element);
        return (xbfFbasicType_);
    }

    /**
     * Creates a <code>XbfKind</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfKind
     */
    public XbfKind createXbfKind(Element element) {
        XbfKind xbfKind_ = createXbfKind();
        xbfKind_.setup(element);
        return (xbfKind_);
    }

    /**
     * Creates a <code>XbfFarrayRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFarrayRef
     */
    public XbfFarrayRef createXbfFarrayRef(Element element) {
        XbfFarrayRef xbfFarrayRef_ = createXbfFarrayRef();
        xbfFarrayRef_.setup(element);
        return (xbfFarrayRef_);
    }

    /**
     * Creates a <code>XbfVarRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfVarRef
     */
    public XbfVarRef createXbfVarRef(Element element) {
        XbfVarRef xbfVarRef_ = createXbfVarRef();
        xbfVarRef_.setup(element);
        return (xbfVarRef_);
    }

    /**
     * Creates a <code>XbfFcharacterRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFcharacterRef
     */
    public XbfFcharacterRef createXbfFcharacterRef(Element element) {
        XbfFcharacterRef xbfFcharacterRef_ = createXbfFcharacterRef();
        xbfFcharacterRef_.setup(element);
        return (xbfFcharacterRef_);
    }

    /**
     * Creates a <code>XbfIndexRange</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfIndexRange
     */
    public XbfIndexRange createXbfIndexRange(Element element) {
        XbfIndexRange xbfIndexRange_ = createXbfIndexRange();
        xbfIndexRange_.setup(element);
        return (xbfIndexRange_);
    }

    /**
     * Creates a <code>XbfLowerBound</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLowerBound
     */
    public XbfLowerBound createXbfLowerBound(Element element) {
        XbfLowerBound xbfLowerBound_ = createXbfLowerBound();
        xbfLowerBound_.setup(element);
        return (xbfLowerBound_);
    }

    /**
     * Creates a <code>XbfUpperBound</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfUpperBound
     */
    public XbfUpperBound createXbfUpperBound(Element element) {
        XbfUpperBound xbfUpperBound_ = createXbfUpperBound();
        xbfUpperBound_.setup(element);
        return (xbfUpperBound_);
    }

    /**
     * Creates a <code>XbfStep</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfStep
     */
    public XbfStep createXbfStep(Element element) {
        XbfStep xbfStep_ = createXbfStep();
        xbfStep_.setup(element);
        return (xbfStep_);
    }

    /**
     * Creates a <code>XbfFmemberRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFmemberRef
     */
    public XbfFmemberRef createXbfFmemberRef(Element element) {
        XbfFmemberRef xbfFmemberRef_ = createXbfFmemberRef();
        xbfFmemberRef_.setup(element);
        return (xbfFmemberRef_);
    }

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFcoArrayRef
     */
    public XbfFcoArrayRef createXbfFcoArrayRef(Element element) {
        XbfFcoArrayRef xbfFcoArrayRef_ = createXbfFcoArrayRef();
        xbfFcoArrayRef_.setup(element);
        return (xbfFcoArrayRef_);
    }

    /**
     * Creates a <code>XbfArrayIndex</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfArrayIndex
     */
    public XbfArrayIndex createXbfArrayIndex(Element element) {
        XbfArrayIndex xbfArrayIndex_ = createXbfArrayIndex();
        xbfArrayIndex_.setup(element);
        return (xbfArrayIndex_);
    }

    /**
     * Creates a <code>XbfVar</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfVar
     */
    public XbfVar createXbfVar(Element element) {
        XbfVar xbfVar_ = createXbfVar();
        xbfVar_.setup(element);
        return (xbfVar_);
    }

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFarrayConstructor
     */
    public XbfFarrayConstructor createXbfFarrayConstructor(Element element) {
        XbfFarrayConstructor xbfFarrayConstructor_ = createXbfFarrayConstructor();
        xbfFarrayConstructor_.setup(element);
        return (xbfFarrayConstructor_);
    }

    /**
     * Creates a <code>XbfFdoLoop</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFdoLoop
     */
    public XbfFdoLoop createXbfFdoLoop(Element element) {
        XbfFdoLoop xbfFdoLoop_ = createXbfFdoLoop();
        xbfFdoLoop_.setup(element);
        return (xbfFdoLoop_);
    }

    /**
     * Creates a <code>XbfValue</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfValue
     */
    public XbfValue createXbfValue(Element element) {
        XbfValue xbfValue_ = createXbfValue();
        xbfValue_.setup(element);
        return (xbfValue_);
    }

    /**
     * Creates a <code>XbfRepeatCount</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfRepeatCount
     */
    public XbfRepeatCount createXbfRepeatCount(Element element) {
        XbfRepeatCount xbfRepeatCount_ = createXbfRepeatCount();
        xbfRepeatCount_.setup(element);
        return (xbfRepeatCount_);
    }

    /**
     * Creates a <code>XbfFintConstant</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFintConstant
     */
    public XbfFintConstant createXbfFintConstant(Element element) {
        XbfFintConstant xbfFintConstant_ = createXbfFintConstant();
        xbfFintConstant_.setup(element);
        return (xbfFintConstant_);
    }

    /**
     * Creates a <code>XbfFrealConstant</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFrealConstant
     */
    public XbfFrealConstant createXbfFrealConstant(Element element) {
        XbfFrealConstant xbfFrealConstant_ = createXbfFrealConstant();
        xbfFrealConstant_.setup(element);
        return (xbfFrealConstant_);
    }

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFcharacterConstant
     */
    public XbfFcharacterConstant createXbfFcharacterConstant(Element element) {
        XbfFcharacterConstant xbfFcharacterConstant_ = createXbfFcharacterConstant();
        xbfFcharacterConstant_.setup(element);
        return (xbfFcharacterConstant_);
    }

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFlogicalConstant
     */
    public XbfFlogicalConstant createXbfFlogicalConstant(Element element) {
        XbfFlogicalConstant xbfFlogicalConstant_ = createXbfFlogicalConstant();
        xbfFlogicalConstant_.setup(element);
        return (xbfFlogicalConstant_);
    }

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFcomplexConstant
     */
    public XbfFcomplexConstant createXbfFcomplexConstant(Element element) {
        XbfFcomplexConstant xbfFcomplexConstant_ = createXbfFcomplexConstant();
        xbfFcomplexConstant_.setup(element);
        return (xbfFcomplexConstant_);
    }

    /**
     * Creates a <code>XbfFstructConstructor</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFstructConstructor
     */
    public XbfFstructConstructor createXbfFstructConstructor(Element element) {
        XbfFstructConstructor xbfFstructConstructor_ = createXbfFstructConstructor();
        xbfFstructConstructor_.setup(element);
        return (xbfFstructConstructor_);
    }

    /**
     * Creates a <code>XbfFunctionCall</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFunctionCall
     */
    public XbfFunctionCall createXbfFunctionCall(Element element) {
        XbfFunctionCall xbfFunctionCall_ = createXbfFunctionCall();
        xbfFunctionCall_.setup(element);
        return (xbfFunctionCall_);
    }

    /**
     * Creates a <code>XbfArguments</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfArguments
     */
    public XbfArguments createXbfArguments(Element element) {
        XbfArguments xbfArguments_ = createXbfArguments();
        xbfArguments_.setup(element);
        return (xbfArguments_);
    }

    /**
     * Creates a <code>XbfNamedValue</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfNamedValue
     */
    public XbfNamedValue createXbfNamedValue(Element element) {
        XbfNamedValue xbfNamedValue_ = createXbfNamedValue();
        xbfNamedValue_.setup(element);
        return (xbfNamedValue_);
    }

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfUserUnaryExpr
     */
    public XbfUserUnaryExpr createXbfUserUnaryExpr(Element element) {
        XbfUserUnaryExpr xbfUserUnaryExpr_ = createXbfUserUnaryExpr();
        xbfUserUnaryExpr_.setup(element);
        return (xbfUserUnaryExpr_);
    }

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfUserBinaryExpr
     */
    public XbfUserBinaryExpr createXbfUserBinaryExpr(Element element) {
        XbfUserBinaryExpr xbfUserBinaryExpr_ = createXbfUserBinaryExpr();
        xbfUserBinaryExpr_.setup(element);
        return (xbfUserBinaryExpr_);
    }

    /**
     * Creates a <code>XbfLogNotExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLogNotExpr
     */
    public XbfLogNotExpr createXbfLogNotExpr(Element element) {
        XbfLogNotExpr xbfLogNotExpr_ = createXbfLogNotExpr();
        xbfLogNotExpr_.setup(element);
        return (xbfLogNotExpr_);
    }

    /**
     * Creates a <code>XbfFfunction</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFfunction
     */
    public XbfFfunction createXbfFfunction(Element element) {
        XbfFfunction xbfFfunction_ = createXbfFfunction();
        xbfFfunction_.setup(element);
        return (xbfFfunction_);
    }

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLogNEQExpr
     */
    public XbfLogNEQExpr createXbfLogNEQExpr(Element element) {
        XbfLogNEQExpr xbfLogNEQExpr_ = createXbfLogNEQExpr();
        xbfLogNEQExpr_.setup(element);
        return (xbfLogNEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGTExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLogGTExpr
     */
    public XbfLogGTExpr createXbfLogGTExpr(Element element) {
        XbfLogGTExpr xbfLogGTExpr_ = createXbfLogGTExpr();
        xbfLogGTExpr_.setup(element);
        return (xbfLogGTExpr_);
    }

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLogNEQVExpr
     */
    public XbfLogNEQVExpr createXbfLogNEQVExpr(Element element) {
        XbfLogNEQVExpr xbfLogNEQVExpr_ = createXbfLogNEQVExpr();
        xbfLogNEQVExpr_.setup(element);
        return (xbfLogNEQVExpr_);
    }

    /**
     * Creates a <code>XbfPlusExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfPlusExpr
     */
    public XbfPlusExpr createXbfPlusExpr(Element element) {
        XbfPlusExpr xbfPlusExpr_ = createXbfPlusExpr();
        xbfPlusExpr_.setup(element);
        return (xbfPlusExpr_);
    }

    /**
     * Creates a <code>XbfMinusExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfMinusExpr
     */
    public XbfMinusExpr createXbfMinusExpr(Element element) {
        XbfMinusExpr xbfMinusExpr_ = createXbfMinusExpr();
        xbfMinusExpr_.setup(element);
        return (xbfMinusExpr_);
    }

    /**
     * Creates a <code>XbfMulExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfMulExpr
     */
    public XbfMulExpr createXbfMulExpr(Element element) {
        XbfMulExpr xbfMulExpr_ = createXbfMulExpr();
        xbfMulExpr_.setup(element);
        return (xbfMulExpr_);
    }

    /**
     * Creates a <code>XbfDivExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfDivExpr
     */
    public XbfDivExpr createXbfDivExpr(Element element) {
        XbfDivExpr xbfDivExpr_ = createXbfDivExpr();
        xbfDivExpr_.setup(element);
        return (xbfDivExpr_);
    }

    /**
     * Creates a <code>XbfFpowerExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFpowerExpr
     */
    public XbfFpowerExpr createXbfFpowerExpr(Element element) {
        XbfFpowerExpr xbfFpowerExpr_ = createXbfFpowerExpr();
        xbfFpowerExpr_.setup(element);
        return (xbfFpowerExpr_);
    }

    /**
     * Creates a <code>XbfFconcatExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFconcatExpr
     */
    public XbfFconcatExpr createXbfFconcatExpr(Element element) {
        XbfFconcatExpr xbfFconcatExpr_ = createXbfFconcatExpr();
        xbfFconcatExpr_.setup(element);
        return (xbfFconcatExpr_);
    }

    /**
     * Creates a <code>XbfLogEQExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLogEQExpr
     */
    public XbfLogEQExpr createXbfLogEQExpr(Element element) {
        XbfLogEQExpr xbfLogEQExpr_ = createXbfLogEQExpr();
        xbfLogEQExpr_.setup(element);
        return (xbfLogEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGEExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLogGEExpr
     */
    public XbfLogGEExpr createXbfLogGEExpr(Element element) {
        XbfLogGEExpr xbfLogGEExpr_ = createXbfLogGEExpr();
        xbfLogGEExpr_.setup(element);
        return (xbfLogGEExpr_);
    }

    /**
     * Creates a <code>XbfLogLEExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLogLEExpr
     */
    public XbfLogLEExpr createXbfLogLEExpr(Element element) {
        XbfLogLEExpr xbfLogLEExpr_ = createXbfLogLEExpr();
        xbfLogLEExpr_.setup(element);
        return (xbfLogLEExpr_);
    }

    /**
     * Creates a <code>XbfLogLTExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLogLTExpr
     */
    public XbfLogLTExpr createXbfLogLTExpr(Element element) {
        XbfLogLTExpr xbfLogLTExpr_ = createXbfLogLTExpr();
        xbfLogLTExpr_.setup(element);
        return (xbfLogLTExpr_);
    }

    /**
     * Creates a <code>XbfLogAndExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLogAndExpr
     */
    public XbfLogAndExpr createXbfLogAndExpr(Element element) {
        XbfLogAndExpr xbfLogAndExpr_ = createXbfLogAndExpr();
        xbfLogAndExpr_.setup(element);
        return (xbfLogAndExpr_);
    }

    /**
     * Creates a <code>XbfLogOrExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLogOrExpr
     */
    public XbfLogOrExpr createXbfLogOrExpr(Element element) {
        XbfLogOrExpr xbfLogOrExpr_ = createXbfLogOrExpr();
        xbfLogOrExpr_.setup(element);
        return (xbfLogOrExpr_);
    }

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLogEQVExpr
     */
    public XbfLogEQVExpr createXbfLogEQVExpr(Element element) {
        XbfLogEQVExpr xbfLogEQVExpr_ = createXbfLogEQVExpr();
        xbfLogEQVExpr_.setup(element);
        return (xbfLogEQVExpr_);
    }

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfUnaryMinusExpr
     */
    public XbfUnaryMinusExpr createXbfUnaryMinusExpr(Element element) {
        XbfUnaryMinusExpr xbfUnaryMinusExpr_ = createXbfUnaryMinusExpr();
        xbfUnaryMinusExpr_.setup(element);
        return (xbfUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbfLen</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfLen
     */
    public XbfLen createXbfLen(Element element) {
        XbfLen xbfLen_ = createXbfLen();
        xbfLen_.setup(element);
        return (xbfLen_);
    }

    /**
     * Creates a <code>XbfCoShape</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfCoShape
     */
    public XbfCoShape createXbfCoShape(Element element) {
        XbfCoShape xbfCoShape_ = createXbfCoShape();
        xbfCoShape_.setup(element);
        return (xbfCoShape_);
    }

    /**
     * Creates a <code>XbfFstructType</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFstructType
     */
    public XbfFstructType createXbfFstructType(Element element) {
        XbfFstructType xbfFstructType_ = createXbfFstructType();
        xbfFstructType_.setup(element);
        return (xbfFstructType_);
    }

    /**
     * Creates a <code>XbfSymbols</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfSymbols
     */
    public XbfSymbols createXbfSymbols(Element element) {
        XbfSymbols xbfSymbols_ = createXbfSymbols();
        xbfSymbols_.setup(element);
        return (xbfSymbols_);
    }

    /**
     * Creates a <code>XbfId</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfId
     */
    public XbfId createXbfId(Element element) {
        XbfId xbfId_ = createXbfId();
        xbfId_.setup(element);
        return (xbfId_);
    }

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfGlobalSymbols
     */
    public XbfGlobalSymbols createXbfGlobalSymbols(Element element) {
        XbfGlobalSymbols xbfGlobalSymbols_ = createXbfGlobalSymbols();
        xbfGlobalSymbols_.setup(element);
        return (xbfGlobalSymbols_);
    }

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfGlobalDeclarations
     */
    public XbfGlobalDeclarations createXbfGlobalDeclarations(Element element) {
        XbfGlobalDeclarations xbfGlobalDeclarations_ = createXbfGlobalDeclarations();
        xbfGlobalDeclarations_.setup(element);
        return (xbfGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFfunctionDefinition
     */
    public XbfFfunctionDefinition createXbfFfunctionDefinition(Element element) {
        XbfFfunctionDefinition xbfFfunctionDefinition_ = createXbfFfunctionDefinition();
        xbfFfunctionDefinition_.setup(element);
        return (xbfFfunctionDefinition_);
    }

    /**
     * Creates a <code>XbfDeclarations</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfDeclarations
     */
    public XbfDeclarations createXbfDeclarations(Element element) {
        XbfDeclarations xbfDeclarations_ = createXbfDeclarations();
        xbfDeclarations_.setup(element);
        return (xbfDeclarations_);
    }

    /**
     * Creates a <code>XbfVarDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfVarDecl
     */
    public XbfVarDecl createXbfVarDecl(Element element) {
        XbfVarDecl xbfVarDecl_ = createXbfVarDecl();
        xbfVarDecl_.setup(element);
        return (xbfVarDecl_);
    }

    /**
     * Creates a <code>XbfExternDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfExternDecl
     */
    public XbfExternDecl createXbfExternDecl(Element element) {
        XbfExternDecl xbfExternDecl_ = createXbfExternDecl();
        xbfExternDecl_.setup(element);
        return (xbfExternDecl_);
    }

    /**
     * Creates a <code>XbfFuseDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFuseDecl
     */
    public XbfFuseDecl createXbfFuseDecl(Element element) {
        XbfFuseDecl xbfFuseDecl_ = createXbfFuseDecl();
        xbfFuseDecl_.setup(element);
        return (xbfFuseDecl_);
    }

    /**
     * Creates a <code>XbfRename</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfRename
     */
    public XbfRename createXbfRename(Element element) {
        XbfRename xbfRename_ = createXbfRename();
        xbfRename_.setup(element);
        return (xbfRename_);
    }

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFuseOnlyDecl
     */
    public XbfFuseOnlyDecl createXbfFuseOnlyDecl(Element element) {
        XbfFuseOnlyDecl xbfFuseOnlyDecl_ = createXbfFuseOnlyDecl();
        xbfFuseOnlyDecl_.setup(element);
        return (xbfFuseOnlyDecl_);
    }

    /**
     * Creates a <code>XbfRenamable</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfRenamable
     */
    public XbfRenamable createXbfRenamable(Element element) {
        XbfRenamable xbfRenamable_ = createXbfRenamable();
        xbfRenamable_.setup(element);
        return (xbfRenamable_);
    }

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFinterfaceDecl
     */
    public XbfFinterfaceDecl createXbfFinterfaceDecl(Element element) {
        XbfFinterfaceDecl xbfFinterfaceDecl_ = createXbfFinterfaceDecl();
        xbfFinterfaceDecl_.setup(element);
        return (xbfFinterfaceDecl_);
    }

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFfunctionDecl
     */
    public XbfFfunctionDecl createXbfFfunctionDecl(Element element) {
        XbfFfunctionDecl xbfFfunctionDecl_ = createXbfFfunctionDecl();
        xbfFfunctionDecl_.setup(element);
        return (xbfFfunctionDecl_);
    }

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFmoduleProcedureDecl
     */
    public XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(Element element) {
        XbfFmoduleProcedureDecl xbfFmoduleProcedureDecl_ = createXbfFmoduleProcedureDecl();
        xbfFmoduleProcedureDecl_.setup(element);
        return (xbfFmoduleProcedureDecl_);
    }

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFnamelistDecl
     */
    public XbfFnamelistDecl createXbfFnamelistDecl(Element element) {
        XbfFnamelistDecl xbfFnamelistDecl_ = createXbfFnamelistDecl();
        xbfFnamelistDecl_.setup(element);
        return (xbfFnamelistDecl_);
    }

    /**
     * Creates a <code>XbfVarList</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfVarList
     */
    public XbfVarList createXbfVarList(Element element) {
        XbfVarList xbfVarList_ = createXbfVarList();
        xbfVarList_.setup(element);
        return (xbfVarList_);
    }

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFequivalenceDecl
     */
    public XbfFequivalenceDecl createXbfFequivalenceDecl(Element element) {
        XbfFequivalenceDecl xbfFequivalenceDecl_ = createXbfFequivalenceDecl();
        xbfFequivalenceDecl_.setup(element);
        return (xbfFequivalenceDecl_);
    }

    /**
     * Creates a <code>XbfFcommonDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFcommonDecl
     */
    public XbfFcommonDecl createXbfFcommonDecl(Element element) {
        XbfFcommonDecl xbfFcommonDecl_ = createXbfFcommonDecl();
        xbfFcommonDecl_.setup(element);
        return (xbfFcommonDecl_);
    }

    /**
     * Creates a <code>XbfFstructDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFstructDecl
     */
    public XbfFstructDecl createXbfFstructDecl(Element element) {
        XbfFstructDecl xbfFstructDecl_ = createXbfFstructDecl();
        xbfFstructDecl_.setup(element);
        return (xbfFstructDecl_);
    }

    /**
     * Creates a <code>XbfFentryDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFentryDecl
     */
    public XbfFentryDecl createXbfFentryDecl(Element element) {
        XbfFentryDecl xbfFentryDecl_ = createXbfFentryDecl();
        xbfFentryDecl_.setup(element);
        return (xbfFentryDecl_);
    }

    /**
     * Creates a <code>XbfFdataDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFdataDecl
     */
    public XbfFdataDecl createXbfFdataDecl(Element element) {
        XbfFdataDecl xbfFdataDecl_ = createXbfFdataDecl();
        xbfFdataDecl_.setup(element);
        return (xbfFdataDecl_);
    }

    /**
     * Creates a <code>XbfValueList</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfValueList
     */
    public XbfValueList createXbfValueList(Element element) {
        XbfValueList xbfValueList_ = createXbfValueList();
        xbfValueList_.setup(element);
        return (xbfValueList_);
    }

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFpragmaStatement
     */
    public XbfFpragmaStatement createXbfFpragmaStatement(Element element) {
        XbfFpragmaStatement xbfFpragmaStatement_ = createXbfFpragmaStatement();
        xbfFpragmaStatement_.setup(element);
        return (xbfFpragmaStatement_);
    }

    /**
     * Creates a <code>XbfBody</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfBody
     */
    public XbfBody createXbfBody(Element element) {
        XbfBody xbfBody_ = createXbfBody();
        xbfBody_.setup(element);
        return (xbfBody_);
    }

    /**
     * Creates a <code>XbfGotoStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfGotoStatement
     */
    public XbfGotoStatement createXbfGotoStatement(Element element) {
        XbfGotoStatement xbfGotoStatement_ = createXbfGotoStatement();
        xbfGotoStatement_.setup(element);
        return (xbfGotoStatement_);
    }

    /**
     * Creates a <code>XbfFpauseStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFpauseStatement
     */
    public XbfFpauseStatement createXbfFpauseStatement(Element element) {
        XbfFpauseStatement xbfFpauseStatement_ = createXbfFpauseStatement();
        xbfFpauseStatement_.setup(element);
        return (xbfFpauseStatement_);
    }

    /**
     * Creates a <code>XbfFcycleStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFcycleStatement
     */
    public XbfFcycleStatement createXbfFcycleStatement(Element element) {
        XbfFcycleStatement xbfFcycleStatement_ = createXbfFcycleStatement();
        xbfFcycleStatement_.setup(element);
        return (xbfFcycleStatement_);
    }

    /**
     * Creates a <code>XbfFreadStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFreadStatement
     */
    public XbfFreadStatement createXbfFreadStatement(Element element) {
        XbfFreadStatement xbfFreadStatement_ = createXbfFreadStatement();
        xbfFreadStatement_.setup(element);
        return (xbfFreadStatement_);
    }

    /**
     * Creates a <code>XbfNamedValueList</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfNamedValueList
     */
    public XbfNamedValueList createXbfNamedValueList(Element element) {
        XbfNamedValueList xbfNamedValueList_ = createXbfNamedValueList();
        xbfNamedValueList_.setup(element);
        return (xbfNamedValueList_);
    }

    /**
     * Creates a <code>XbfFcloseStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFcloseStatement
     */
    public XbfFcloseStatement createXbfFcloseStatement(Element element) {
        XbfFcloseStatement xbfFcloseStatement_ = createXbfFcloseStatement();
        xbfFcloseStatement_.setup(element);
        return (xbfFcloseStatement_);
    }

    /**
     * Creates a <code>XbfFopenStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFopenStatement
     */
    public XbfFopenStatement createXbfFopenStatement(Element element) {
        XbfFopenStatement xbfFopenStatement_ = createXbfFopenStatement();
        xbfFopenStatement_.setup(element);
        return (xbfFopenStatement_);
    }

    /**
     * Creates a <code>XbfFassignStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFassignStatement
     */
    public XbfFassignStatement createXbfFassignStatement(Element element) {
        XbfFassignStatement xbfFassignStatement_ = createXbfFassignStatement();
        xbfFassignStatement_.setup(element);
        return (xbfFassignStatement_);
    }

    /**
     * Creates a <code>XbfExprStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfExprStatement
     */
    public XbfExprStatement createXbfExprStatement(Element element) {
        XbfExprStatement xbfExprStatement_ = createXbfExprStatement();
        xbfExprStatement_.setup(element);
        return (xbfExprStatement_);
    }

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFpointerAssignStatement
     */
    public XbfFpointerAssignStatement createXbfFpointerAssignStatement(Element element) {
        XbfFpointerAssignStatement xbfFpointerAssignStatement_ = createXbfFpointerAssignStatement();
        xbfFpointerAssignStatement_.setup(element);
        return (xbfFpointerAssignStatement_);
    }

    /**
     * Creates a <code>XbfFifStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFifStatement
     */
    public XbfFifStatement createXbfFifStatement(Element element) {
        XbfFifStatement xbfFifStatement_ = createXbfFifStatement();
        xbfFifStatement_.setup(element);
        return (xbfFifStatement_);
    }

    /**
     * Creates a <code>XbfCondition</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfCondition
     */
    public XbfCondition createXbfCondition(Element element) {
        XbfCondition xbfCondition_ = createXbfCondition();
        xbfCondition_.setup(element);
        return (xbfCondition_);
    }

    /**
     * Creates a <code>XbfThen</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfThen
     */
    public XbfThen createXbfThen(Element element) {
        XbfThen xbfThen_ = createXbfThen();
        xbfThen_.setup(element);
        return (xbfThen_);
    }

    /**
     * Creates a <code>XbfElse</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfElse
     */
    public XbfElse createXbfElse(Element element) {
        XbfElse xbfElse_ = createXbfElse();
        xbfElse_.setup(element);
        return (xbfElse_);
    }

    /**
     * Creates a <code>XbfFdoStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFdoStatement
     */
    public XbfFdoStatement createXbfFdoStatement(Element element) {
        XbfFdoStatement xbfFdoStatement_ = createXbfFdoStatement();
        xbfFdoStatement_.setup(element);
        return (xbfFdoStatement_);
    }

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFdoWhileStatement
     */
    public XbfFdoWhileStatement createXbfFdoWhileStatement(Element element) {
        XbfFdoWhileStatement xbfFdoWhileStatement_ = createXbfFdoWhileStatement();
        xbfFdoWhileStatement_.setup(element);
        return (xbfFdoWhileStatement_);
    }

    /**
     * Creates a <code>XbfContinueStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfContinueStatement
     */
    public XbfContinueStatement createXbfContinueStatement(Element element) {
        XbfContinueStatement xbfContinueStatement_ = createXbfContinueStatement();
        xbfContinueStatement_.setup(element);
        return (xbfContinueStatement_);
    }

    /**
     * Creates a <code>XbfFexitStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFexitStatement
     */
    public XbfFexitStatement createXbfFexitStatement(Element element) {
        XbfFexitStatement xbfFexitStatement_ = createXbfFexitStatement();
        xbfFexitStatement_.setup(element);
        return (xbfFexitStatement_);
    }

    /**
     * Creates a <code>XbfFreturnStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFreturnStatement
     */
    public XbfFreturnStatement createXbfFreturnStatement(Element element) {
        XbfFreturnStatement xbfFreturnStatement_ = createXbfFreturnStatement();
        xbfFreturnStatement_.setup(element);
        return (xbfFreturnStatement_);
    }

    /**
     * Creates a <code>XbfStatementLabel</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfStatementLabel
     */
    public XbfStatementLabel createXbfStatementLabel(Element element) {
        XbfStatementLabel xbfStatementLabel_ = createXbfStatementLabel();
        xbfStatementLabel_.setup(element);
        return (xbfStatementLabel_);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFselectCaseStatement
     */
    public XbfFselectCaseStatement createXbfFselectCaseStatement(Element element) {
        XbfFselectCaseStatement xbfFselectCaseStatement_ = createXbfFselectCaseStatement();
        xbfFselectCaseStatement_.setup(element);
        return (xbfFselectCaseStatement_);
    }

    /**
     * Creates a <code>XbfFcaseLabel</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFcaseLabel
     */
    public XbfFcaseLabel createXbfFcaseLabel(Element element) {
        XbfFcaseLabel xbfFcaseLabel_ = createXbfFcaseLabel();
        xbfFcaseLabel_.setup(element);
        return (xbfFcaseLabel_);
    }

    /**
     * Creates a <code>XbfFwhereStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFwhereStatement
     */
    public XbfFwhereStatement createXbfFwhereStatement(Element element) {
        XbfFwhereStatement xbfFwhereStatement_ = createXbfFwhereStatement();
        xbfFwhereStatement_.setup(element);
        return (xbfFwhereStatement_);
    }

    /**
     * Creates a <code>XbfFstopStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFstopStatement
     */
    public XbfFstopStatement createXbfFstopStatement(Element element) {
        XbfFstopStatement xbfFstopStatement_ = createXbfFstopStatement();
        xbfFstopStatement_.setup(element);
        return (xbfFstopStatement_);
    }

    /**
     * Creates a <code>XbfFwriteStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFwriteStatement
     */
    public XbfFwriteStatement createXbfFwriteStatement(Element element) {
        XbfFwriteStatement xbfFwriteStatement_ = createXbfFwriteStatement();
        xbfFwriteStatement_.setup(element);
        return (xbfFwriteStatement_);
    }

    /**
     * Creates a <code>XbfFprintStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFprintStatement
     */
    public XbfFprintStatement createXbfFprintStatement(Element element) {
        XbfFprintStatement xbfFprintStatement_ = createXbfFprintStatement();
        xbfFprintStatement_.setup(element);
        return (xbfFprintStatement_);
    }

    /**
     * Creates a <code>XbfFrewindStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFrewindStatement
     */
    public XbfFrewindStatement createXbfFrewindStatement(Element element) {
        XbfFrewindStatement xbfFrewindStatement_ = createXbfFrewindStatement();
        xbfFrewindStatement_.setup(element);
        return (xbfFrewindStatement_);
    }

    /**
     * Creates a <code>XbfFendFileStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFendFileStatement
     */
    public XbfFendFileStatement createXbfFendFileStatement(Element element) {
        XbfFendFileStatement xbfFendFileStatement_ = createXbfFendFileStatement();
        xbfFendFileStatement_.setup(element);
        return (xbfFendFileStatement_);
    }

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFbackspaceStatement
     */
    public XbfFbackspaceStatement createXbfFbackspaceStatement(Element element) {
        XbfFbackspaceStatement xbfFbackspaceStatement_ = createXbfFbackspaceStatement();
        xbfFbackspaceStatement_.setup(element);
        return (xbfFbackspaceStatement_);
    }

    /**
     * Creates a <code>XbfFinquireStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFinquireStatement
     */
    public XbfFinquireStatement createXbfFinquireStatement(Element element) {
        XbfFinquireStatement xbfFinquireStatement_ = createXbfFinquireStatement();
        xbfFinquireStatement_.setup(element);
        return (xbfFinquireStatement_);
    }

    /**
     * Creates a <code>XbfFformatDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFformatDecl
     */
    public XbfFformatDecl createXbfFformatDecl(Element element) {
        XbfFformatDecl xbfFformatDecl_ = createXbfFformatDecl();
        xbfFformatDecl_.setup(element);
        return (xbfFformatDecl_);
    }

    /**
     * Creates a <code>XbfFallocateStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFallocateStatement
     */
    public XbfFallocateStatement createXbfFallocateStatement(Element element) {
        XbfFallocateStatement xbfFallocateStatement_ = createXbfFallocateStatement();
        xbfFallocateStatement_.setup(element);
        return (xbfFallocateStatement_);
    }

    /**
     * Creates a <code>XbfAlloc</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfAlloc
     */
    public XbfAlloc createXbfAlloc(Element element) {
        XbfAlloc xbfAlloc_ = createXbfAlloc();
        xbfAlloc_.setup(element);
        return (xbfAlloc_);
    }

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFdeallocateStatement
     */
    public XbfFdeallocateStatement createXbfFdeallocateStatement(Element element) {
        XbfFdeallocateStatement xbfFdeallocateStatement_ = createXbfFdeallocateStatement();
        xbfFdeallocateStatement_.setup(element);
        return (xbfFdeallocateStatement_);
    }

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFnullifyStatement
     */
    public XbfFnullifyStatement createXbfFnullifyStatement(Element element) {
        XbfFnullifyStatement xbfFnullifyStatement_ = createXbfFnullifyStatement();
        xbfFnullifyStatement_.setup(element);
        return (xbfFnullifyStatement_);
    }

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFcontainsStatement
     */
    public XbfFcontainsStatement createXbfFcontainsStatement(Element element) {
        XbfFcontainsStatement xbfFcontainsStatement_ = createXbfFcontainsStatement();
        xbfFcontainsStatement_.setup(element);
        return (xbfFcontainsStatement_);
    }

    /**
     * Creates a <code>XbfText</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfText
     */
    public XbfText createXbfText(Element element) {
        XbfText xbfText_ = createXbfText();
        xbfText_.setup(element);
        return (xbfText_);
    }

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFmoduleDefinition
     */
    public XbfFmoduleDefinition createXbfFmoduleDefinition(Element element) {
        XbfFmoduleDefinition xbfFmoduleDefinition_ = createXbfFmoduleDefinition();
        xbfFmoduleDefinition_.setup(element);
        return (xbfFmoduleDefinition_);
    }

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbfFblockDataDefinition
     */
    public XbfFblockDataDefinition createXbfFblockDataDefinition(Element element) {
        XbfFblockDataDefinition xbfFblockDataDefinition_ = createXbfFblockDataDefinition();
        xbfFblockDataDefinition_.setup(element);
        return (xbfFblockDataDefinition_);
    }

    /**
     * Creates a <code>XbfXcodeProgram</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfXcodeProgram
     */
    public XbfXcodeProgram createXbfXcodeProgram(RStack stack) {
        XbfXcodeProgram xbfXcodeProgram_ = createXbfXcodeProgram();
        xbfXcodeProgram_.setup(stack);
        return (xbfXcodeProgram_);
    }

    /**
     * Creates a <code>XbfTypeTable</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfTypeTable
     */
    public XbfTypeTable createXbfTypeTable(RStack stack) {
        XbfTypeTable xbfTypeTable_ = createXbfTypeTable();
        xbfTypeTable_.setup(stack);
        return (xbfTypeTable_);
    }

    /**
     * Creates a <code>XbfFfunctionType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFfunctionType
     */
    public XbfFfunctionType createXbfFfunctionType(RStack stack) {
        XbfFfunctionType xbfFfunctionType_ = createXbfFfunctionType();
        xbfFfunctionType_.setup(stack);
        return (xbfFfunctionType_);
    }

    /**
     * Creates a <code>XbfParams</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfParams
     */
    public XbfParams createXbfParams(RStack stack) {
        XbfParams xbfParams_ = createXbfParams();
        xbfParams_.setup(stack);
        return (xbfParams_);
    }

    /**
     * Creates a <code>XbfName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfName
     */
    public XbfName createXbfName(RStack stack) {
        XbfName xbfName_ = createXbfName();
        xbfName_.setup(stack);
        return (xbfName_);
    }

    /**
     * Creates a <code>XbfFbasicType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFbasicType
     */
    public XbfFbasicType createXbfFbasicType(RStack stack) {
        XbfFbasicType xbfFbasicType_ = createXbfFbasicType();
        xbfFbasicType_.setup(stack);
        return (xbfFbasicType_);
    }

    /**
     * Creates a <code>XbfKind</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfKind
     */
    public XbfKind createXbfKind(RStack stack) {
        XbfKind xbfKind_ = createXbfKind();
        xbfKind_.setup(stack);
        return (xbfKind_);
    }

    /**
     * Creates a <code>XbfFarrayRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFarrayRef
     */
    public XbfFarrayRef createXbfFarrayRef(RStack stack) {
        XbfFarrayRef xbfFarrayRef_ = createXbfFarrayRef();
        xbfFarrayRef_.setup(stack);
        return (xbfFarrayRef_);
    }

    /**
     * Creates a <code>XbfVarRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfVarRef
     */
    public XbfVarRef createXbfVarRef(RStack stack) {
        XbfVarRef xbfVarRef_ = createXbfVarRef();
        xbfVarRef_.setup(stack);
        return (xbfVarRef_);
    }

    /**
     * Creates a <code>XbfFcharacterRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFcharacterRef
     */
    public XbfFcharacterRef createXbfFcharacterRef(RStack stack) {
        XbfFcharacterRef xbfFcharacterRef_ = createXbfFcharacterRef();
        xbfFcharacterRef_.setup(stack);
        return (xbfFcharacterRef_);
    }

    /**
     * Creates a <code>XbfIndexRange</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfIndexRange
     */
    public XbfIndexRange createXbfIndexRange(RStack stack) {
        XbfIndexRange xbfIndexRange_ = createXbfIndexRange();
        xbfIndexRange_.setup(stack);
        return (xbfIndexRange_);
    }

    /**
     * Creates a <code>XbfLowerBound</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLowerBound
     */
    public XbfLowerBound createXbfLowerBound(RStack stack) {
        XbfLowerBound xbfLowerBound_ = createXbfLowerBound();
        xbfLowerBound_.setup(stack);
        return (xbfLowerBound_);
    }

    /**
     * Creates a <code>XbfUpperBound</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfUpperBound
     */
    public XbfUpperBound createXbfUpperBound(RStack stack) {
        XbfUpperBound xbfUpperBound_ = createXbfUpperBound();
        xbfUpperBound_.setup(stack);
        return (xbfUpperBound_);
    }

    /**
     * Creates a <code>XbfStep</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfStep
     */
    public XbfStep createXbfStep(RStack stack) {
        XbfStep xbfStep_ = createXbfStep();
        xbfStep_.setup(stack);
        return (xbfStep_);
    }

    /**
     * Creates a <code>XbfFmemberRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFmemberRef
     */
    public XbfFmemberRef createXbfFmemberRef(RStack stack) {
        XbfFmemberRef xbfFmemberRef_ = createXbfFmemberRef();
        xbfFmemberRef_.setup(stack);
        return (xbfFmemberRef_);
    }

    /**
     * Creates a <code>XbfFcoArrayRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFcoArrayRef
     */
    public XbfFcoArrayRef createXbfFcoArrayRef(RStack stack) {
        XbfFcoArrayRef xbfFcoArrayRef_ = createXbfFcoArrayRef();
        xbfFcoArrayRef_.setup(stack);
        return (xbfFcoArrayRef_);
    }

    /**
     * Creates a <code>XbfArrayIndex</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfArrayIndex
     */
    public XbfArrayIndex createXbfArrayIndex(RStack stack) {
        XbfArrayIndex xbfArrayIndex_ = createXbfArrayIndex();
        xbfArrayIndex_.setup(stack);
        return (xbfArrayIndex_);
    }

    /**
     * Creates a <code>XbfVar</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfVar
     */
    public XbfVar createXbfVar(RStack stack) {
        XbfVar xbfVar_ = createXbfVar();
        xbfVar_.setup(stack);
        return (xbfVar_);
    }

    /**
     * Creates a <code>XbfFarrayConstructor</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFarrayConstructor
     */
    public XbfFarrayConstructor createXbfFarrayConstructor(RStack stack) {
        XbfFarrayConstructor xbfFarrayConstructor_ = createXbfFarrayConstructor();
        xbfFarrayConstructor_.setup(stack);
        return (xbfFarrayConstructor_);
    }

    /**
     * Creates a <code>XbfFdoLoop</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFdoLoop
     */
    public XbfFdoLoop createXbfFdoLoop(RStack stack) {
        XbfFdoLoop xbfFdoLoop_ = createXbfFdoLoop();
        xbfFdoLoop_.setup(stack);
        return (xbfFdoLoop_);
    }

    /**
     * Creates a <code>XbfValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfValue
     */
    public XbfValue createXbfValue(RStack stack) {
        XbfValue xbfValue_ = createXbfValue();
        xbfValue_.setup(stack);
        return (xbfValue_);
    }

    /**
     * Creates a <code>XbfRepeatCount</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfRepeatCount
     */
    public XbfRepeatCount createXbfRepeatCount(RStack stack) {
        XbfRepeatCount xbfRepeatCount_ = createXbfRepeatCount();
        xbfRepeatCount_.setup(stack);
        return (xbfRepeatCount_);
    }

    /**
     * Creates a <code>XbfFintConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFintConstant
     */
    public XbfFintConstant createXbfFintConstant(RStack stack) {
        XbfFintConstant xbfFintConstant_ = createXbfFintConstant();
        xbfFintConstant_.setup(stack);
        return (xbfFintConstant_);
    }

    /**
     * Creates a <code>XbfFrealConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFrealConstant
     */
    public XbfFrealConstant createXbfFrealConstant(RStack stack) {
        XbfFrealConstant xbfFrealConstant_ = createXbfFrealConstant();
        xbfFrealConstant_.setup(stack);
        return (xbfFrealConstant_);
    }

    /**
     * Creates a <code>XbfFcharacterConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFcharacterConstant
     */
    public XbfFcharacterConstant createXbfFcharacterConstant(RStack stack) {
        XbfFcharacterConstant xbfFcharacterConstant_ = createXbfFcharacterConstant();
        xbfFcharacterConstant_.setup(stack);
        return (xbfFcharacterConstant_);
    }

    /**
     * Creates a <code>XbfFlogicalConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFlogicalConstant
     */
    public XbfFlogicalConstant createXbfFlogicalConstant(RStack stack) {
        XbfFlogicalConstant xbfFlogicalConstant_ = createXbfFlogicalConstant();
        xbfFlogicalConstant_.setup(stack);
        return (xbfFlogicalConstant_);
    }

    /**
     * Creates a <code>XbfFcomplexConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFcomplexConstant
     */
    public XbfFcomplexConstant createXbfFcomplexConstant(RStack stack) {
        XbfFcomplexConstant xbfFcomplexConstant_ = createXbfFcomplexConstant();
        xbfFcomplexConstant_.setup(stack);
        return (xbfFcomplexConstant_);
    }

    /**
     * Creates a <code>XbfFstructConstructor</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFstructConstructor
     */
    public XbfFstructConstructor createXbfFstructConstructor(RStack stack) {
        XbfFstructConstructor xbfFstructConstructor_ = createXbfFstructConstructor();
        xbfFstructConstructor_.setup(stack);
        return (xbfFstructConstructor_);
    }

    /**
     * Creates a <code>XbfFunctionCall</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFunctionCall
     */
    public XbfFunctionCall createXbfFunctionCall(RStack stack) {
        XbfFunctionCall xbfFunctionCall_ = createXbfFunctionCall();
        xbfFunctionCall_.setup(stack);
        return (xbfFunctionCall_);
    }

    /**
     * Creates a <code>XbfArguments</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfArguments
     */
    public XbfArguments createXbfArguments(RStack stack) {
        XbfArguments xbfArguments_ = createXbfArguments();
        xbfArguments_.setup(stack);
        return (xbfArguments_);
    }

    /**
     * Creates a <code>XbfNamedValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfNamedValue
     */
    public XbfNamedValue createXbfNamedValue(RStack stack) {
        XbfNamedValue xbfNamedValue_ = createXbfNamedValue();
        xbfNamedValue_.setup(stack);
        return (xbfNamedValue_);
    }

    /**
     * Creates a <code>XbfUserUnaryExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfUserUnaryExpr
     */
    public XbfUserUnaryExpr createXbfUserUnaryExpr(RStack stack) {
        XbfUserUnaryExpr xbfUserUnaryExpr_ = createXbfUserUnaryExpr();
        xbfUserUnaryExpr_.setup(stack);
        return (xbfUserUnaryExpr_);
    }

    /**
     * Creates a <code>XbfUserBinaryExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfUserBinaryExpr
     */
    public XbfUserBinaryExpr createXbfUserBinaryExpr(RStack stack) {
        XbfUserBinaryExpr xbfUserBinaryExpr_ = createXbfUserBinaryExpr();
        xbfUserBinaryExpr_.setup(stack);
        return (xbfUserBinaryExpr_);
    }

    /**
     * Creates a <code>XbfLogNotExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLogNotExpr
     */
    public XbfLogNotExpr createXbfLogNotExpr(RStack stack) {
        XbfLogNotExpr xbfLogNotExpr_ = createXbfLogNotExpr();
        xbfLogNotExpr_.setup(stack);
        return (xbfLogNotExpr_);
    }

    /**
     * Creates a <code>XbfFfunction</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFfunction
     */
    public XbfFfunction createXbfFfunction(RStack stack) {
        XbfFfunction xbfFfunction_ = createXbfFfunction();
        xbfFfunction_.setup(stack);
        return (xbfFfunction_);
    }

    /**
     * Creates a <code>XbfLogNEQExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLogNEQExpr
     */
    public XbfLogNEQExpr createXbfLogNEQExpr(RStack stack) {
        XbfLogNEQExpr xbfLogNEQExpr_ = createXbfLogNEQExpr();
        xbfLogNEQExpr_.setup(stack);
        return (xbfLogNEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGTExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLogGTExpr
     */
    public XbfLogGTExpr createXbfLogGTExpr(RStack stack) {
        XbfLogGTExpr xbfLogGTExpr_ = createXbfLogGTExpr();
        xbfLogGTExpr_.setup(stack);
        return (xbfLogGTExpr_);
    }

    /**
     * Creates a <code>XbfLogNEQVExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLogNEQVExpr
     */
    public XbfLogNEQVExpr createXbfLogNEQVExpr(RStack stack) {
        XbfLogNEQVExpr xbfLogNEQVExpr_ = createXbfLogNEQVExpr();
        xbfLogNEQVExpr_.setup(stack);
        return (xbfLogNEQVExpr_);
    }

    /**
     * Creates a <code>XbfPlusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfPlusExpr
     */
    public XbfPlusExpr createXbfPlusExpr(RStack stack) {
        XbfPlusExpr xbfPlusExpr_ = createXbfPlusExpr();
        xbfPlusExpr_.setup(stack);
        return (xbfPlusExpr_);
    }

    /**
     * Creates a <code>XbfMinusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfMinusExpr
     */
    public XbfMinusExpr createXbfMinusExpr(RStack stack) {
        XbfMinusExpr xbfMinusExpr_ = createXbfMinusExpr();
        xbfMinusExpr_.setup(stack);
        return (xbfMinusExpr_);
    }

    /**
     * Creates a <code>XbfMulExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfMulExpr
     */
    public XbfMulExpr createXbfMulExpr(RStack stack) {
        XbfMulExpr xbfMulExpr_ = createXbfMulExpr();
        xbfMulExpr_.setup(stack);
        return (xbfMulExpr_);
    }

    /**
     * Creates a <code>XbfDivExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfDivExpr
     */
    public XbfDivExpr createXbfDivExpr(RStack stack) {
        XbfDivExpr xbfDivExpr_ = createXbfDivExpr();
        xbfDivExpr_.setup(stack);
        return (xbfDivExpr_);
    }

    /**
     * Creates a <code>XbfFpowerExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFpowerExpr
     */
    public XbfFpowerExpr createXbfFpowerExpr(RStack stack) {
        XbfFpowerExpr xbfFpowerExpr_ = createXbfFpowerExpr();
        xbfFpowerExpr_.setup(stack);
        return (xbfFpowerExpr_);
    }

    /**
     * Creates a <code>XbfFconcatExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFconcatExpr
     */
    public XbfFconcatExpr createXbfFconcatExpr(RStack stack) {
        XbfFconcatExpr xbfFconcatExpr_ = createXbfFconcatExpr();
        xbfFconcatExpr_.setup(stack);
        return (xbfFconcatExpr_);
    }

    /**
     * Creates a <code>XbfLogEQExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLogEQExpr
     */
    public XbfLogEQExpr createXbfLogEQExpr(RStack stack) {
        XbfLogEQExpr xbfLogEQExpr_ = createXbfLogEQExpr();
        xbfLogEQExpr_.setup(stack);
        return (xbfLogEQExpr_);
    }

    /**
     * Creates a <code>XbfLogGEExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLogGEExpr
     */
    public XbfLogGEExpr createXbfLogGEExpr(RStack stack) {
        XbfLogGEExpr xbfLogGEExpr_ = createXbfLogGEExpr();
        xbfLogGEExpr_.setup(stack);
        return (xbfLogGEExpr_);
    }

    /**
     * Creates a <code>XbfLogLEExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLogLEExpr
     */
    public XbfLogLEExpr createXbfLogLEExpr(RStack stack) {
        XbfLogLEExpr xbfLogLEExpr_ = createXbfLogLEExpr();
        xbfLogLEExpr_.setup(stack);
        return (xbfLogLEExpr_);
    }

    /**
     * Creates a <code>XbfLogLTExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLogLTExpr
     */
    public XbfLogLTExpr createXbfLogLTExpr(RStack stack) {
        XbfLogLTExpr xbfLogLTExpr_ = createXbfLogLTExpr();
        xbfLogLTExpr_.setup(stack);
        return (xbfLogLTExpr_);
    }

    /**
     * Creates a <code>XbfLogAndExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLogAndExpr
     */
    public XbfLogAndExpr createXbfLogAndExpr(RStack stack) {
        XbfLogAndExpr xbfLogAndExpr_ = createXbfLogAndExpr();
        xbfLogAndExpr_.setup(stack);
        return (xbfLogAndExpr_);
    }

    /**
     * Creates a <code>XbfLogOrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLogOrExpr
     */
    public XbfLogOrExpr createXbfLogOrExpr(RStack stack) {
        XbfLogOrExpr xbfLogOrExpr_ = createXbfLogOrExpr();
        xbfLogOrExpr_.setup(stack);
        return (xbfLogOrExpr_);
    }

    /**
     * Creates a <code>XbfLogEQVExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLogEQVExpr
     */
    public XbfLogEQVExpr createXbfLogEQVExpr(RStack stack) {
        XbfLogEQVExpr xbfLogEQVExpr_ = createXbfLogEQVExpr();
        xbfLogEQVExpr_.setup(stack);
        return (xbfLogEQVExpr_);
    }

    /**
     * Creates a <code>XbfUnaryMinusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfUnaryMinusExpr
     */
    public XbfUnaryMinusExpr createXbfUnaryMinusExpr(RStack stack) {
        XbfUnaryMinusExpr xbfUnaryMinusExpr_ = createXbfUnaryMinusExpr();
        xbfUnaryMinusExpr_.setup(stack);
        return (xbfUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbfLen</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfLen
     */
    public XbfLen createXbfLen(RStack stack) {
        XbfLen xbfLen_ = createXbfLen();
        xbfLen_.setup(stack);
        return (xbfLen_);
    }

    /**
     * Creates a <code>XbfCoShape</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfCoShape
     */
    public XbfCoShape createXbfCoShape(RStack stack) {
        XbfCoShape xbfCoShape_ = createXbfCoShape();
        xbfCoShape_.setup(stack);
        return (xbfCoShape_);
    }

    /**
     * Creates a <code>XbfFstructType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFstructType
     */
    public XbfFstructType createXbfFstructType(RStack stack) {
        XbfFstructType xbfFstructType_ = createXbfFstructType();
        xbfFstructType_.setup(stack);
        return (xbfFstructType_);
    }

    /**
     * Creates a <code>XbfSymbols</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfSymbols
     */
    public XbfSymbols createXbfSymbols(RStack stack) {
        XbfSymbols xbfSymbols_ = createXbfSymbols();
        xbfSymbols_.setup(stack);
        return (xbfSymbols_);
    }

    /**
     * Creates a <code>XbfId</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfId
     */
    public XbfId createXbfId(RStack stack) {
        XbfId xbfId_ = createXbfId();
        xbfId_.setup(stack);
        return (xbfId_);
    }

    /**
     * Creates a <code>XbfGlobalSymbols</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfGlobalSymbols
     */
    public XbfGlobalSymbols createXbfGlobalSymbols(RStack stack) {
        XbfGlobalSymbols xbfGlobalSymbols_ = createXbfGlobalSymbols();
        xbfGlobalSymbols_.setup(stack);
        return (xbfGlobalSymbols_);
    }

    /**
     * Creates a <code>XbfGlobalDeclarations</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfGlobalDeclarations
     */
    public XbfGlobalDeclarations createXbfGlobalDeclarations(RStack stack) {
        XbfGlobalDeclarations xbfGlobalDeclarations_ = createXbfGlobalDeclarations();
        xbfGlobalDeclarations_.setup(stack);
        return (xbfGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbfFfunctionDefinition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFfunctionDefinition
     */
    public XbfFfunctionDefinition createXbfFfunctionDefinition(RStack stack) {
        XbfFfunctionDefinition xbfFfunctionDefinition_ = createXbfFfunctionDefinition();
        xbfFfunctionDefinition_.setup(stack);
        return (xbfFfunctionDefinition_);
    }

    /**
     * Creates a <code>XbfDeclarations</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfDeclarations
     */
    public XbfDeclarations createXbfDeclarations(RStack stack) {
        XbfDeclarations xbfDeclarations_ = createXbfDeclarations();
        xbfDeclarations_.setup(stack);
        return (xbfDeclarations_);
    }

    /**
     * Creates a <code>XbfVarDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfVarDecl
     */
    public XbfVarDecl createXbfVarDecl(RStack stack) {
        XbfVarDecl xbfVarDecl_ = createXbfVarDecl();
        xbfVarDecl_.setup(stack);
        return (xbfVarDecl_);
    }

    /**
     * Creates a <code>XbfExternDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfExternDecl
     */
    public XbfExternDecl createXbfExternDecl(RStack stack) {
        XbfExternDecl xbfExternDecl_ = createXbfExternDecl();
        xbfExternDecl_.setup(stack);
        return (xbfExternDecl_);
    }

    /**
     * Creates a <code>XbfFuseDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFuseDecl
     */
    public XbfFuseDecl createXbfFuseDecl(RStack stack) {
        XbfFuseDecl xbfFuseDecl_ = createXbfFuseDecl();
        xbfFuseDecl_.setup(stack);
        return (xbfFuseDecl_);
    }

    /**
     * Creates a <code>XbfRename</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfRename
     */
    public XbfRename createXbfRename(RStack stack) {
        XbfRename xbfRename_ = createXbfRename();
        xbfRename_.setup(stack);
        return (xbfRename_);
    }

    /**
     * Creates a <code>XbfFuseOnlyDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFuseOnlyDecl
     */
    public XbfFuseOnlyDecl createXbfFuseOnlyDecl(RStack stack) {
        XbfFuseOnlyDecl xbfFuseOnlyDecl_ = createXbfFuseOnlyDecl();
        xbfFuseOnlyDecl_.setup(stack);
        return (xbfFuseOnlyDecl_);
    }

    /**
     * Creates a <code>XbfRenamable</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfRenamable
     */
    public XbfRenamable createXbfRenamable(RStack stack) {
        XbfRenamable xbfRenamable_ = createXbfRenamable();
        xbfRenamable_.setup(stack);
        return (xbfRenamable_);
    }

    /**
     * Creates a <code>XbfFinterfaceDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFinterfaceDecl
     */
    public XbfFinterfaceDecl createXbfFinterfaceDecl(RStack stack) {
        XbfFinterfaceDecl xbfFinterfaceDecl_ = createXbfFinterfaceDecl();
        xbfFinterfaceDecl_.setup(stack);
        return (xbfFinterfaceDecl_);
    }

    /**
     * Creates a <code>XbfFfunctionDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFfunctionDecl
     */
    public XbfFfunctionDecl createXbfFfunctionDecl(RStack stack) {
        XbfFfunctionDecl xbfFfunctionDecl_ = createXbfFfunctionDecl();
        xbfFfunctionDecl_.setup(stack);
        return (xbfFfunctionDecl_);
    }

    /**
     * Creates a <code>XbfFmoduleProcedureDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFmoduleProcedureDecl
     */
    public XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl(RStack stack) {
        XbfFmoduleProcedureDecl xbfFmoduleProcedureDecl_ = createXbfFmoduleProcedureDecl();
        xbfFmoduleProcedureDecl_.setup(stack);
        return (xbfFmoduleProcedureDecl_);
    }

    /**
     * Creates a <code>XbfFnamelistDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFnamelistDecl
     */
    public XbfFnamelistDecl createXbfFnamelistDecl(RStack stack) {
        XbfFnamelistDecl xbfFnamelistDecl_ = createXbfFnamelistDecl();
        xbfFnamelistDecl_.setup(stack);
        return (xbfFnamelistDecl_);
    }

    /**
     * Creates a <code>XbfVarList</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfVarList
     */
    public XbfVarList createXbfVarList(RStack stack) {
        XbfVarList xbfVarList_ = createXbfVarList();
        xbfVarList_.setup(stack);
        return (xbfVarList_);
    }

    /**
     * Creates a <code>XbfFequivalenceDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFequivalenceDecl
     */
    public XbfFequivalenceDecl createXbfFequivalenceDecl(RStack stack) {
        XbfFequivalenceDecl xbfFequivalenceDecl_ = createXbfFequivalenceDecl();
        xbfFequivalenceDecl_.setup(stack);
        return (xbfFequivalenceDecl_);
    }

    /**
     * Creates a <code>XbfFcommonDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFcommonDecl
     */
    public XbfFcommonDecl createXbfFcommonDecl(RStack stack) {
        XbfFcommonDecl xbfFcommonDecl_ = createXbfFcommonDecl();
        xbfFcommonDecl_.setup(stack);
        return (xbfFcommonDecl_);
    }

    /**
     * Creates a <code>XbfFstructDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFstructDecl
     */
    public XbfFstructDecl createXbfFstructDecl(RStack stack) {
        XbfFstructDecl xbfFstructDecl_ = createXbfFstructDecl();
        xbfFstructDecl_.setup(stack);
        return (xbfFstructDecl_);
    }

    /**
     * Creates a <code>XbfFentryDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFentryDecl
     */
    public XbfFentryDecl createXbfFentryDecl(RStack stack) {
        XbfFentryDecl xbfFentryDecl_ = createXbfFentryDecl();
        xbfFentryDecl_.setup(stack);
        return (xbfFentryDecl_);
    }

    /**
     * Creates a <code>XbfFdataDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFdataDecl
     */
    public XbfFdataDecl createXbfFdataDecl(RStack stack) {
        XbfFdataDecl xbfFdataDecl_ = createXbfFdataDecl();
        xbfFdataDecl_.setup(stack);
        return (xbfFdataDecl_);
    }

    /**
     * Creates a <code>XbfValueList</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfValueList
     */
    public XbfValueList createXbfValueList(RStack stack) {
        XbfValueList xbfValueList_ = createXbfValueList();
        xbfValueList_.setup(stack);
        return (xbfValueList_);
    }

    /**
     * Creates a <code>XbfFpragmaStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFpragmaStatement
     */
    public XbfFpragmaStatement createXbfFpragmaStatement(RStack stack) {
        XbfFpragmaStatement xbfFpragmaStatement_ = createXbfFpragmaStatement();
        xbfFpragmaStatement_.setup(stack);
        return (xbfFpragmaStatement_);
    }

    /**
     * Creates a <code>XbfBody</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfBody
     */
    public XbfBody createXbfBody(RStack stack) {
        XbfBody xbfBody_ = createXbfBody();
        xbfBody_.setup(stack);
        return (xbfBody_);
    }

    /**
     * Creates a <code>XbfGotoStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfGotoStatement
     */
    public XbfGotoStatement createXbfGotoStatement(RStack stack) {
        XbfGotoStatement xbfGotoStatement_ = createXbfGotoStatement();
        xbfGotoStatement_.setup(stack);
        return (xbfGotoStatement_);
    }

    /**
     * Creates a <code>XbfFpauseStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFpauseStatement
     */
    public XbfFpauseStatement createXbfFpauseStatement(RStack stack) {
        XbfFpauseStatement xbfFpauseStatement_ = createXbfFpauseStatement();
        xbfFpauseStatement_.setup(stack);
        return (xbfFpauseStatement_);
    }

    /**
     * Creates a <code>XbfFcycleStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFcycleStatement
     */
    public XbfFcycleStatement createXbfFcycleStatement(RStack stack) {
        XbfFcycleStatement xbfFcycleStatement_ = createXbfFcycleStatement();
        xbfFcycleStatement_.setup(stack);
        return (xbfFcycleStatement_);
    }

    /**
     * Creates a <code>XbfFreadStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFreadStatement
     */
    public XbfFreadStatement createXbfFreadStatement(RStack stack) {
        XbfFreadStatement xbfFreadStatement_ = createXbfFreadStatement();
        xbfFreadStatement_.setup(stack);
        return (xbfFreadStatement_);
    }

    /**
     * Creates a <code>XbfNamedValueList</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfNamedValueList
     */
    public XbfNamedValueList createXbfNamedValueList(RStack stack) {
        XbfNamedValueList xbfNamedValueList_ = createXbfNamedValueList();
        xbfNamedValueList_.setup(stack);
        return (xbfNamedValueList_);
    }

    /**
     * Creates a <code>XbfFcloseStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFcloseStatement
     */
    public XbfFcloseStatement createXbfFcloseStatement(RStack stack) {
        XbfFcloseStatement xbfFcloseStatement_ = createXbfFcloseStatement();
        xbfFcloseStatement_.setup(stack);
        return (xbfFcloseStatement_);
    }

    /**
     * Creates a <code>XbfFopenStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFopenStatement
     */
    public XbfFopenStatement createXbfFopenStatement(RStack stack) {
        XbfFopenStatement xbfFopenStatement_ = createXbfFopenStatement();
        xbfFopenStatement_.setup(stack);
        return (xbfFopenStatement_);
    }

    /**
     * Creates a <code>XbfFassignStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFassignStatement
     */
    public XbfFassignStatement createXbfFassignStatement(RStack stack) {
        XbfFassignStatement xbfFassignStatement_ = createXbfFassignStatement();
        xbfFassignStatement_.setup(stack);
        return (xbfFassignStatement_);
    }

    /**
     * Creates a <code>XbfExprStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfExprStatement
     */
    public XbfExprStatement createXbfExprStatement(RStack stack) {
        XbfExprStatement xbfExprStatement_ = createXbfExprStatement();
        xbfExprStatement_.setup(stack);
        return (xbfExprStatement_);
    }

    /**
     * Creates a <code>XbfFpointerAssignStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFpointerAssignStatement
     */
    public XbfFpointerAssignStatement createXbfFpointerAssignStatement(RStack stack) {
        XbfFpointerAssignStatement xbfFpointerAssignStatement_ = createXbfFpointerAssignStatement();
        xbfFpointerAssignStatement_.setup(stack);
        return (xbfFpointerAssignStatement_);
    }

    /**
     * Creates a <code>XbfFifStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFifStatement
     */
    public XbfFifStatement createXbfFifStatement(RStack stack) {
        XbfFifStatement xbfFifStatement_ = createXbfFifStatement();
        xbfFifStatement_.setup(stack);
        return (xbfFifStatement_);
    }

    /**
     * Creates a <code>XbfCondition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfCondition
     */
    public XbfCondition createXbfCondition(RStack stack) {
        XbfCondition xbfCondition_ = createXbfCondition();
        xbfCondition_.setup(stack);
        return (xbfCondition_);
    }

    /**
     * Creates a <code>XbfThen</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfThen
     */
    public XbfThen createXbfThen(RStack stack) {
        XbfThen xbfThen_ = createXbfThen();
        xbfThen_.setup(stack);
        return (xbfThen_);
    }

    /**
     * Creates a <code>XbfElse</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfElse
     */
    public XbfElse createXbfElse(RStack stack) {
        XbfElse xbfElse_ = createXbfElse();
        xbfElse_.setup(stack);
        return (xbfElse_);
    }

    /**
     * Creates a <code>XbfFdoStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFdoStatement
     */
    public XbfFdoStatement createXbfFdoStatement(RStack stack) {
        XbfFdoStatement xbfFdoStatement_ = createXbfFdoStatement();
        xbfFdoStatement_.setup(stack);
        return (xbfFdoStatement_);
    }

    /**
     * Creates a <code>XbfFdoWhileStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFdoWhileStatement
     */
    public XbfFdoWhileStatement createXbfFdoWhileStatement(RStack stack) {
        XbfFdoWhileStatement xbfFdoWhileStatement_ = createXbfFdoWhileStatement();
        xbfFdoWhileStatement_.setup(stack);
        return (xbfFdoWhileStatement_);
    }

    /**
     * Creates a <code>XbfContinueStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfContinueStatement
     */
    public XbfContinueStatement createXbfContinueStatement(RStack stack) {
        XbfContinueStatement xbfContinueStatement_ = createXbfContinueStatement();
        xbfContinueStatement_.setup(stack);
        return (xbfContinueStatement_);
    }

    /**
     * Creates a <code>XbfFexitStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFexitStatement
     */
    public XbfFexitStatement createXbfFexitStatement(RStack stack) {
        XbfFexitStatement xbfFexitStatement_ = createXbfFexitStatement();
        xbfFexitStatement_.setup(stack);
        return (xbfFexitStatement_);
    }

    /**
     * Creates a <code>XbfFreturnStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFreturnStatement
     */
    public XbfFreturnStatement createXbfFreturnStatement(RStack stack) {
        XbfFreturnStatement xbfFreturnStatement_ = createXbfFreturnStatement();
        xbfFreturnStatement_.setup(stack);
        return (xbfFreturnStatement_);
    }

    /**
     * Creates a <code>XbfStatementLabel</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfStatementLabel
     */
    public XbfStatementLabel createXbfStatementLabel(RStack stack) {
        XbfStatementLabel xbfStatementLabel_ = createXbfStatementLabel();
        xbfStatementLabel_.setup(stack);
        return (xbfStatementLabel_);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFselectCaseStatement
     */
    public XbfFselectCaseStatement createXbfFselectCaseStatement(RStack stack) {
        XbfFselectCaseStatement xbfFselectCaseStatement_ = createXbfFselectCaseStatement();
        xbfFselectCaseStatement_.setup(stack);
        return (xbfFselectCaseStatement_);
    }

    /**
     * Creates a <code>XbfFcaseLabel</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFcaseLabel
     */
    public XbfFcaseLabel createXbfFcaseLabel(RStack stack) {
        XbfFcaseLabel xbfFcaseLabel_ = createXbfFcaseLabel();
        xbfFcaseLabel_.setup(stack);
        return (xbfFcaseLabel_);
    }

    /**
     * Creates a <code>XbfFwhereStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFwhereStatement
     */
    public XbfFwhereStatement createXbfFwhereStatement(RStack stack) {
        XbfFwhereStatement xbfFwhereStatement_ = createXbfFwhereStatement();
        xbfFwhereStatement_.setup(stack);
        return (xbfFwhereStatement_);
    }

    /**
     * Creates a <code>XbfFstopStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFstopStatement
     */
    public XbfFstopStatement createXbfFstopStatement(RStack stack) {
        XbfFstopStatement xbfFstopStatement_ = createXbfFstopStatement();
        xbfFstopStatement_.setup(stack);
        return (xbfFstopStatement_);
    }

    /**
     * Creates a <code>XbfFwriteStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFwriteStatement
     */
    public XbfFwriteStatement createXbfFwriteStatement(RStack stack) {
        XbfFwriteStatement xbfFwriteStatement_ = createXbfFwriteStatement();
        xbfFwriteStatement_.setup(stack);
        return (xbfFwriteStatement_);
    }

    /**
     * Creates a <code>XbfFprintStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFprintStatement
     */
    public XbfFprintStatement createXbfFprintStatement(RStack stack) {
        XbfFprintStatement xbfFprintStatement_ = createXbfFprintStatement();
        xbfFprintStatement_.setup(stack);
        return (xbfFprintStatement_);
    }

    /**
     * Creates a <code>XbfFrewindStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFrewindStatement
     */
    public XbfFrewindStatement createXbfFrewindStatement(RStack stack) {
        XbfFrewindStatement xbfFrewindStatement_ = createXbfFrewindStatement();
        xbfFrewindStatement_.setup(stack);
        return (xbfFrewindStatement_);
    }

    /**
     * Creates a <code>XbfFendFileStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFendFileStatement
     */
    public XbfFendFileStatement createXbfFendFileStatement(RStack stack) {
        XbfFendFileStatement xbfFendFileStatement_ = createXbfFendFileStatement();
        xbfFendFileStatement_.setup(stack);
        return (xbfFendFileStatement_);
    }

    /**
     * Creates a <code>XbfFbackspaceStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFbackspaceStatement
     */
    public XbfFbackspaceStatement createXbfFbackspaceStatement(RStack stack) {
        XbfFbackspaceStatement xbfFbackspaceStatement_ = createXbfFbackspaceStatement();
        xbfFbackspaceStatement_.setup(stack);
        return (xbfFbackspaceStatement_);
    }

    /**
     * Creates a <code>XbfFinquireStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFinquireStatement
     */
    public XbfFinquireStatement createXbfFinquireStatement(RStack stack) {
        XbfFinquireStatement xbfFinquireStatement_ = createXbfFinquireStatement();
        xbfFinquireStatement_.setup(stack);
        return (xbfFinquireStatement_);
    }

    /**
     * Creates a <code>XbfFformatDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFformatDecl
     */
    public XbfFformatDecl createXbfFformatDecl(RStack stack) {
        XbfFformatDecl xbfFformatDecl_ = createXbfFformatDecl();
        xbfFformatDecl_.setup(stack);
        return (xbfFformatDecl_);
    }

    /**
     * Creates a <code>XbfFallocateStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFallocateStatement
     */
    public XbfFallocateStatement createXbfFallocateStatement(RStack stack) {
        XbfFallocateStatement xbfFallocateStatement_ = createXbfFallocateStatement();
        xbfFallocateStatement_.setup(stack);
        return (xbfFallocateStatement_);
    }

    /**
     * Creates a <code>XbfAlloc</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfAlloc
     */
    public XbfAlloc createXbfAlloc(RStack stack) {
        XbfAlloc xbfAlloc_ = createXbfAlloc();
        xbfAlloc_.setup(stack);
        return (xbfAlloc_);
    }

    /**
     * Creates a <code>XbfFdeallocateStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFdeallocateStatement
     */
    public XbfFdeallocateStatement createXbfFdeallocateStatement(RStack stack) {
        XbfFdeallocateStatement xbfFdeallocateStatement_ = createXbfFdeallocateStatement();
        xbfFdeallocateStatement_.setup(stack);
        return (xbfFdeallocateStatement_);
    }

    /**
     * Creates a <code>XbfFnullifyStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFnullifyStatement
     */
    public XbfFnullifyStatement createXbfFnullifyStatement(RStack stack) {
        XbfFnullifyStatement xbfFnullifyStatement_ = createXbfFnullifyStatement();
        xbfFnullifyStatement_.setup(stack);
        return (xbfFnullifyStatement_);
    }

    /**
     * Creates a <code>XbfFcontainsStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFcontainsStatement
     */
    public XbfFcontainsStatement createXbfFcontainsStatement(RStack stack) {
        XbfFcontainsStatement xbfFcontainsStatement_ = createXbfFcontainsStatement();
        xbfFcontainsStatement_.setup(stack);
        return (xbfFcontainsStatement_);
    }

    /**
     * Creates a <code>XbfText</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfText
     */
    public XbfText createXbfText(RStack stack) {
        XbfText xbfText_ = createXbfText();
        xbfText_.setup(stack);
        return (xbfText_);
    }

    /**
     * Creates a <code>XbfFmoduleDefinition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFmoduleDefinition
     */
    public XbfFmoduleDefinition createXbfFmoduleDefinition(RStack stack) {
        XbfFmoduleDefinition xbfFmoduleDefinition_ = createXbfFmoduleDefinition();
        xbfFmoduleDefinition_.setup(stack);
        return (xbfFmoduleDefinition_);
    }

    /**
     * Creates a <code>XbfFblockDataDefinition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFblockDataDefinition
     */
    public XbfFblockDataDefinition createXbfFblockDataDefinition(RStack stack) {
        XbfFblockDataDefinition xbfFblockDataDefinition_ = createXbfFblockDataDefinition();
        xbfFblockDataDefinition_.setup(stack);
        return (xbfFblockDataDefinition_);
    }

    /**
     * Creates a <code>XbfDefModelArraySubscriptSequence1</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfDefModelArraySubscriptSequence1
     */
    public XbfDefModelArraySubscriptSequence1 createXbfDefModelArraySubscriptSequence1(RStack stack) {
        XbfDefModelArraySubscriptSequence1 xbfDefModelArraySubscriptSequence1_ = createXbfDefModelArraySubscriptSequence1();
        xbfDefModelArraySubscriptSequence1_.setup(stack);
        return (xbfDefModelArraySubscriptSequence1_);
    }

    /**
     * Creates a <code>XbfFequivalenceDeclSequence</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFequivalenceDeclSequence
     */
    public XbfFequivalenceDeclSequence createXbfFequivalenceDeclSequence(RStack stack) {
        XbfFequivalenceDeclSequence xbfFequivalenceDeclSequence_ = createXbfFequivalenceDeclSequence();
        xbfFequivalenceDeclSequence_.setup(stack);
        return (xbfFequivalenceDeclSequence_);
    }

    /**
     * Creates a <code>XbfFdataDeclSequence</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFdataDeclSequence
     */
    public XbfFdataDeclSequence createXbfFdataDeclSequence(RStack stack) {
        XbfFdataDeclSequence xbfFdataDeclSequence_ = createXbfFdataDeclSequence();
        xbfFdataDeclSequence_.setup(stack);
        return (xbfFdataDeclSequence_);
    }

    /**
     * Creates a <code>XbfGotoStatementSequence</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfGotoStatementSequence
     */
    public XbfGotoStatementSequence createXbfGotoStatementSequence(RStack stack) {
        XbfGotoStatementSequence xbfGotoStatementSequence_ = createXbfGotoStatementSequence();
        xbfGotoStatementSequence_.setup(stack);
        return (xbfGotoStatementSequence_);
    }

    /**
     * Creates a <code>XbfFdoStatementSequence</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbfFdoStatementSequence
     */
    public XbfFdoStatementSequence createXbfFdoStatementSequence(RStack stack) {
        XbfFdoStatementSequence xbfFdoStatementSequence_ = createXbfFdoStatementSequence();
        xbfFdoStatementSequence_.setup(stack);
        return (xbfFdoStatementSequence_);
    }

    /**
     * Creates a <code>XbfDefModelArraySubscriptSequence1</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfDefModelArraySubscriptSequence1
     */
    public XbfDefModelArraySubscriptSequence1 createXbfDefModelArraySubscriptSequence1(XbfDefModelArraySubscriptSequence1 source) {
        XbfDefModelArraySubscriptSequence1 xbfDefModelArraySubscriptSequence1_ = createXbfDefModelArraySubscriptSequence1();
        xbfDefModelArraySubscriptSequence1_.setup(source);
        return (xbfDefModelArraySubscriptSequence1_);
    }

    /**
     * Creates a <code>XbfFequivalenceDeclSequence</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFequivalenceDeclSequence
     */
    public XbfFequivalenceDeclSequence createXbfFequivalenceDeclSequence(XbfFequivalenceDeclSequence source) {
        XbfFequivalenceDeclSequence xbfFequivalenceDeclSequence_ = createXbfFequivalenceDeclSequence();
        xbfFequivalenceDeclSequence_.setup(source);
        return (xbfFequivalenceDeclSequence_);
    }

    /**
     * Creates a <code>XbfFdataDeclSequence</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFdataDeclSequence
     */
    public XbfFdataDeclSequence createXbfFdataDeclSequence(XbfFdataDeclSequence source) {
        XbfFdataDeclSequence xbfFdataDeclSequence_ = createXbfFdataDeclSequence();
        xbfFdataDeclSequence_.setup(source);
        return (xbfFdataDeclSequence_);
    }

    /**
     * Creates a <code>XbfGotoStatementSequence</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfGotoStatementSequence
     */
    public XbfGotoStatementSequence createXbfGotoStatementSequence(XbfGotoStatementSequence source) {
        XbfGotoStatementSequence xbfGotoStatementSequence_ = createXbfGotoStatementSequence();
        xbfGotoStatementSequence_.setup(source);
        return (xbfGotoStatementSequence_);
    }

    /**
     * Creates a <code>XbfFdoStatementSequence</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbfFdoStatementSequence
     */
    public XbfFdoStatementSequence createXbfFdoStatementSequence(XbfFdoStatementSequence source) {
        XbfFdoStatementSequence xbfFdoStatementSequence_ = createXbfFdoStatementSequence();
        xbfFdoStatementSequence_.setup(source);
        return (xbfFdoStatementSequence_);
    }
}
