/* 
 * $TSUKUBA_Release: Omni Compiler Version 0.9.0 $
 * $TSUKUBA_Copyright:
 *  Copyright (C) 2010-2014 University of Tsukuba, 
 *  	      2012-2014  University of Tsukuba and Riken AICS
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  * The specification of XcalableMP has been designed by the XcalableMP
 *    Specification Working Group (http://www.xcalablemp.org/).
 *  
 *  * The development of this software was partially supported by "Seamless and
 *    Highly-productive Parallel Programming Environment for
 *    High-performance computing" project funded by Ministry of Education,
 *    Culture, Sports, Science and Technology, Japan.
 *  $
 */
package xcodeml.c.binding;

import xcodeml.c.binding.gen.XbcArraySize;

/**
 * Concrete classes implement this interface are follows :
 * XbcArrayType, XbcCoArrayType
 */
public interface IXbcArrayType
{
    /**
     * Gets array_size attribute.
     *
     * @return contents of array_size attribute.
     */
    public String getArraySize1();
    public void setArraySize1(String size1);

    /**
     * Gets arraySize tag element.
     *
     * @return arraySize tag object.
     */
    public XbcArraySize getArraySize2();
    public void setArraySize2(XbcArraySize size2);

    /**
     * Gets element_type attribute.
     *
     * @return content of element_type attribute.
     */
    public String getElementType();
    public void setElementType(String elemType);
}
