![Build/release](https://github.com/TorstenDittmann/OmniaWrite/workflows/Build/release/badge.svg)
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-12-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->
[![omniawrite](https://snapcraft.io//omniawrite/badge.svg)](https://snapcraft.io/omniawrite)

<!-- PROJECT LOGO -->
<br />
<p align="center">
  <a href="https://omniawrite.com">
    <img src="public/android-chrome-512x512.png" alt="Logo" width="80" height="80">
  </a>

  <h3 align="center">OmniaWrite</h3>

  <p align="center">
    A text editor engineered for creative writing.
    <br />
    <a href="https://omniawrite.com"><strong>Visit homepage »</strong></a>
    <br />
    <br />
    <a href="https://app.omniawrite.com">View WebApp</a>
    ·
    <a href="https://github.com/TorstenDittmann/OmniaWrite/issues">Report Bug</a>
    ·
    <a href="https://github.com/TorstenDittmann/OmniaWrite/issues">Request Feature</a>
  </p>
</p>

<!-- TABLE OF CONTENTS -->
## Table of Contents

* [About the Project](#about-omniawrite)
  * [Built With](#built-with)
* [Contributing](#contributing)
* [License](#license)
* [Contact](#contact)

<!-- ABOUT OMNIAWRITE -->

## About OmniaWrite

OmniaWrite is a next-generation plain text editor engineered for creative writing. It is perfect for writing novels, lyrics, poems, essays, drafts and screenplays.

Writing a good story is one of the most challenging things in life. But for many it is a dream worth pursuing.

OmniaWrite doesn't help you create a novel out of nothing, but is a faithful companion at every step of your projects. Organisation, environment for concentrated work, export to all common file formats and much more.

#### Full Featured Text Editor
Everything you need. Nothing you don’t.

#### Chapters and Scenes
Write in chapters and scenes to give your text more structure and add manageability. You can move and rearrange scenes at will without having to break your structure.

#### Anywhere
OmniaWrite will support Windows, Linux, macOS, Android, iOS and can also run in any modern browser.

### Built With

* [svelte](https://svelte.dev)
* [Appwrite](https://appwrite.io)
* [Electron](https://www.electronjs.org)
* [Capacitor](https://capacitorjs.com)

## Contributing
Current development branch: [dev](https://github.com/TorstenDittmann/OmniaWrite/tree/dev)

## Releasing

When you want to create a new release, follow these steps:

1. Update the version in `package.json` file (e.g. `1.2.3`)
2. Commit that change (`git commit -am v1.2.3`)
3. Tag commit (`git tag v1.2.3`). Make sure the tag name's format is `v*.*.*`.
4. Push changes to GitHub (`git push && git push --tags`)

After building successfully, the action will publish your release artifacts.

## License

This work is licensed under a Apache License 2.0.

<!-- CONTACT -->
## Contact

OmniaWrite - [@OmniaWrite](https://twitter.com/OmniaWrite) - info@omniawrite.com

Project Link: [https://OmniaWrite.com](https://OmniaWrite.com)
Project GitHub Link: [https://github.com/TorstenDittmann/OmniaWrite](https://github.com/TorstenDittmann/OmniaWrite)

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://github.com/AnthonyBoucher"><img src="https://avatars0.githubusercontent.com/u/6674732?v=4" width="100px;" alt=""/><br /><sub><b>AnthonyBoucher</b></sub></a><br /><a href="#maintenance-AnthonyBoucher" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://twitter.com/dennistobar"><img src="https://avatars1.githubusercontent.com/u/1218182?v=4" width="100px;" alt=""/><br /><sub><b>Dennis Tobar</b></sub></a><br /><a href="#translation-dennistobar" title="Translation">🌍</a></td>
    <td align="center"><a href="https://github.com/marlonemmerich"><img src="https://avatars1.githubusercontent.com/u/52637919?v=4" width="100px;" alt=""/><br /><sub><b>Marlon Emmerich</b></sub></a><br /><a href="#translation-marlonemmerich" title="Translation">🌍</a></td>
    <td align="center"><a href="https://github.com/Gulianrdgd"><img src="https://avatars3.githubusercontent.com/u/45941668?v=4" width="100px;" alt=""/><br /><sub><b>Gulianrdgd</b></sub></a><br /><a href="#translation-Gulianrdgd" title="Translation">🌍</a></td>
    <td align="center"><a href="http://evgeniae.tk"><img src="https://avatars3.githubusercontent.com/u/22026957?v=4" width="100px;" alt=""/><br /><sub><b>Evgenia Polozova</b></sub></a><br /><a href="#translation-eugpoloz" title="Translation">🌍</a></td>
    <td align="center"><a href="https://github.com/ertugrulk"><img src="https://avatars1.githubusercontent.com/u/1182186?v=4" width="100px;" alt=""/><br /><sub><b>Ertugrul K</b></sub></a><br /><a href="#translation-ertugrulk" title="Translation">🌍</a></td>
    <td align="center"><a href="https://ontheneworbit.blogspot.com/"><img src="https://avatars1.githubusercontent.com/u/25644062?v=4" width="100px;" alt=""/><br /><sub><b>y yam</b></sub></a><br /><a href="#translation-sidemt" title="Translation">🌍</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/fredericbonnet"><img src="https://avatars2.githubusercontent.com/u/11368533?v=4" width="100px;" alt=""/><br /><sub><b>Frédéric Bonnet</b></sub></a><br /><a href="https://github.com/TorstenDittmann/OmniaWrite/commits?author=fredericbonnet" title="Tests">⚠️</a></td>
    <td align="center"><a href="https://github.com/minna-xD"><img src="https://avatars2.githubusercontent.com/u/44906587?v=4" width="100px;" alt=""/><br /><sub><b>Minna N.</b></sub></a><br /><a href="#translation-minna-xD" title="Translation">🌍</a></td>
    <td align="center"><a href="https://github.com/gustavohleal"><img src="https://avatars1.githubusercontent.com/u/22385451?v=4" width="100px;" alt=""/><br /><sub><b>Gustavo Henrique Leal</b></sub></a><br /><a href="https://github.com/TorstenDittmann/OmniaWrite/commits?author=gustavohleal" title="Tests">⚠️</a></td>
    <td align="center"><a href="https://github.com/magdapoppins"><img src="https://avatars2.githubusercontent.com/u/26743924?v=4" width="100px;" alt=""/><br /><sub><b>Magda Stenius</b></sub></a><br /><a href="#translation-magdapoppins" title="Translation">🌍</a></td>
    <td align="center"><a href="https://github.com/syentix"><img src="https://avatars3.githubusercontent.com/u/43079612?v=4" width="100px;" alt=""/><br /><sub><b>Ole S.</b></sub></a><br /><a href="https://github.com/TorstenDittmann/OmniaWrite/commits?author=syentix" title="Code">💻</a></td>
  </tr>
</table>

<!-- markdownlint-enable -->
<!-- prettier-ignore-end -->
<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
