//								-*- C++ -*-
// Copyright (C) 2009 EPITA Research and Development Laboratory (LRDE)
//
// This file is part of Olena.
//
// Olena is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, version 2 of the License.
//
// Olena is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Olena.  If not, see <http://www.gnu.org/licenses/>.
//
// As a special exception, you may use this file as part of a free
// software project without restriction.  Specifically, if other files
// instantiate templates or use macros or inline functions from this
// file, or you compile this file and link it with other files to produce
// an executable, this file does not by itself cause the resulting
// executable to be covered by the GNU General Public License.  This
// exception does not however invalidate any other reasons why the
// executable file might be covered by the GNU General Public License.

/// \file box2d_piter.i
/// \brief A wrapper of mln::box_fwd_piter_< mln::point2d >.

%module box2d_piter

%include box_piter.ixx

%{
#include "mln/core/alias/point2d.hh"
%}

%import point2d.i

// FIXME: Move reusable parts elsewhere (in box_piter.i and/or another
// file).

// Ignore internal methods.
%ignore mln::box_fwd_piter_< mln::point<mln::grid::square, mln::def::coord> >::is_valid_();
%ignore mln::box_fwd_piter_< mln::point<mln::grid::square, mln::def::coord> >::invalidate_();
%ignore mln::box_fwd_piter_< mln::point<mln::grid::square, mln::def::coord> >::start_();
%ignore mln::box_fwd_piter_< mln::point<mln::grid::square, mln::def::coord> >::next_();

// Ignore the backward iterator (for the moment).
%ignore mln::box_bkd_piter_< mln::point<mln::grid::square, mln::def::coord> >;


/*--------------------.
| Generic interface.  |
`--------------------*/

/* These methods are mostly for debugging purpose: we should use the
   language's interface (e.g. Python's `next()') to manipulate an
   iterator.  */
/* FIXME: Except for `site()', these methods could be generated by
   Swig by wrapping base classes mln::Iterator and mln::Site_Iterator
   of mln::box_fwd_piter_ (and renaming Site_Iterator's `next()' as
   `advance()' to avoid a name clash with the new `next()' method
   added to Python's code.  */
%extend mln::box_fwd_piter_< mln::point<mln::grid::square, mln::def::coord> >
{
  // Return the site pointed by an iterator.
  const mln::point<mln::grid::square, mln::def::coord>
  site()
  {
    return *$self;
  }

  // Initiate the iterator.
  void
  start()
  {
    $self->start();
  }

  // Move the iterator forward.
  void
  advance()
  {
    $self->next();
  }

  // Is the iterator valid?
  bool
  is_valid()
  {
    return $self->is_valid();
  }

  // Invalidate the iterator.
  void
  invalidate()
  {
    $self->invalidate();
  }
}


/*-------------------.
| Python interface.  |
`-------------------*/

#if SWIGPYTHON

// Handling iterators  la Python.

%extend mln::box_fwd_piter_< mln::point<mln::grid::square, mln::def::coord> >
{
  mln::box_fwd_piter_< mln::point<mln::grid::square, mln::def::coord> >&
  __iter__()
  {
    return *$self;
  }
}

// Raise a Python `StopIteration' exception on `next()' if the
// iterator is invalid.
%exception mln::box_fwd_piter_< mln::point<mln::grid::square, mln::def::coord> >::next
{
  /* FIXME: Is it safe to use `arg1'?  It seems to be pretty
     low-level, and may not be part of Swig's standard interface.  */
  if (!arg1->is_valid())
    {
      PyErr_SetString(PyExc_StopIteration, "Invalid iterator");
      return NULL;
    }
  $action
}

%extend mln::box_fwd_piter_< mln::point<mln::grid::square, mln::def::coord> >
{
  const mln::point<mln::grid::square, mln::def::coord>
  next()
  {
    // Keep a copy of the current site before incrementation.
    const mln::point<mln::grid::square, mln::def::coord> current = *$self;
    // Delegate incrementation to `Super_Iterator's `next()' method.
    $self->next();
    return current;
  }
}

#endif // !SWIGPYTHON


%template(box2d_piter)
mln::box_fwd_piter_< mln::point<mln::grid::square, mln::def::coord> >;
