// Copyright (C) 2007, 2008, 2009, 2010 EPITA Research and Development
// Laboratory (LRDE)
//
// This file is part of Olena.
//
// Olena is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, version 2 of the License.
//
// Olena is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Olena.  If not, see <http://www.gnu.org/licenses/>.
//
// As a special exception, you may use this file as part of a free
// software project without restriction.  Specifically, if other files
// instantiate templates or use macros or inline functions from this
// file, or you compile this file and link it with other files to produce
// an executable, this file does not by itself cause the resulting
// executable to be covered by the GNU General Public License.  This
// exception does not however invalidate any other reasons why the
// executable file might be covered by the GNU General Public License.

#include <mln/core/image/image2d.hh>
#include <mln/core/var.hh>
#include <mln/io/pbm/load.hh>
#include <mln/core/alias/neighb2d.hh>
#include <mln/data/compare.hh>
#include <mln/labeling/foreground.hh>

#include "tests/data.hh"


int main()
{
  using namespace mln;

  typedef image2d<bool> I;
  neighb2d nbh = c4();

  I pic = io::pbm::load(MLN_IMG_DIR "/picasso.pbm");
  image2d<unsigned> out, ref;

  unsigned n;
  out = labeling::foreground(pic, nbh, n); // Calls the fastest 'video'
					   // version.
  mln_assertion(n == 33);

  {
    // Note that  labeling::foreground  actually is  labeling::value
    // which calls  canvas::labeling_video  and its generic dispatch
    // leads to  canvas::impl::generic::labeling.

    labeling::impl::value_functor<I,unsigned> f(pic, true);

    unsigned n_;
    ref = canvas::labeling::impl::generic::labeling(pic, nbh, n_,
						    pic.domain(),
						    f);
    mln_invariant(n_ == n);
    mln_invariant(ref == out);
  }

}
