/*! 
\htmlonly
<!--HEVEA command line is: /usr/bin/hevea -fix -O -o tutorial.html -I /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc/. -I /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc/outputs -I /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc/outputs/split -I /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc/img -I /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc/examples/split -I /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc/./tutorial.tex -->
<!--CUT DEF chapter 1 --><P>
\endhtmlonly</P><P>\page tutorial Tutorial
- \subpage tuto1
- \subpage tuto2
- \subpage tuto3
- \subpage tuto4
- \subpage tuto5
- \subpage tuto6
- \subpage tuto7
- \subpage tuto8</P><P>

\htmlonly

</P><P><A NAME="tuto1"></A>
\endhtmlonly

*/


/*!
\page tuto1 Welcome

\htmlonly
 </P><P>Welcome to Milena&rsquo;s tutorial.</P><P><BR>
<BR>
<BR>

<A NAME="tuto1howotlearn"></A>
\endhtmlonly

\section tuto1howotlearn How to learn Milena

\htmlonly
 </P><P>Milena is only a subpart of Olena but tends to be a large system too.
Therefore it is not possible to present all the functionalities in a
tutorial.</P><P>Milena targets several audiences: <I>assemblers</I>,
<I>designers</I>, <I>providers</I> and
<I>architects</I>. <I>Assemblers</I> want to apply and assemble
algorithms to solve image processing, pattern recognition or computer
vision problems, <I>designers</I> build new algorithms,
<I>providers</I> are interested in developing their own data
structures and extend an existing library and <I>architects</I> are
basically developpers extending the core library.</P><P>Whatever the kind of user you are, the key to learning how to use
Milena is to become familiar with its palette of objects and the way
of combining them.</P><P>As an <I>assemblers</I>, you may start with this simple tutorial and the Quick
tour . They describe and illustrate the key features of the library.
<I>Assemblers</I> getting familiar with Milena and <I>designers</I>, should
take a look at the Quick Reference Guide .
It is a more detailed explanations of the library&rsquo;s features.</P><P><I>Assemblers</I> and <I>designers</I> may be also interested by all the
examples provided with the documentation and the tutorial. The source code is
available in <I>milena/doc/examples</I>  and is usually pointed
out and commented by the documentation.</P><P>Taking a look at the test suite is also a good idea. The tests usually focus on
a single functionality and handle several use cases which may overlap your needs.
The test suite is located in <I>milena/tests</I> .</P><P>Still not enough information? More information about all the routines is
available in the User HTML documentation .
It mainly targets <I>designers</I> and <I>providers</I>.
The latter may also be interested by the Developer HTML documentation
(not available yet).</P><P><BR>
<BR>
<BR>

<A NAME="tuto1obtainingthelib"></A>
\endhtmlonly

\section tuto1obtainingthelib Obtaining the library

\htmlonly
 </P><P>There are two ways of getting Milena on the web:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
Download a tarball/package from the website,
</LI><LI CLASS="li-itemize">Checkout the SVN repository.
</LI></UL><P>Downloading a package or a tarball is the best choice for a new user. Except
for nightly builds which are packages generated every night from the SVN repository,
packages and tarballs contain only a released version of Milena. It guaranties a
certain quality: no building issues, no bugs (ok, maybe some...), &#X2026;</P><P>This tutorial is based on the latest released version of Milena. Therefore,
if you decide to use the SVN version, you may notice different behaviors or results
compared to what it is described in this document.</P><P>Using the SVN version implies some drawbacks: the code might crash, not
compile or produce incorrect results.
Besides, The SVN version is always up to date and you may find new functionalities,
bug fixes and new syntax improvements.
This version targets users familiar with build systems and compilation issues.
We strongly advise you to not use it for production use.</P><P><BR>
<BR>
<BR>

<A NAME="tuto1downloading"></A>
\endhtmlonly

\section tuto1downloading Downloading the library

\htmlonly
 </P><P><A NAME="tuto1downloadingsvn"></A>
\endhtmlonly

\subsection tuto1downloadingsvn Downloading from SVN

\htmlonly
 </P><P>First, be sure that SVN is already installed on your system.
Open a terminal and type:</P><PRE CLASS="verbatim">$ svn --version --quiet
1.4.6
</PRE><P>You should see your version of SVN installed. If you read &rsquo;Command not found&rsquo;
then you need to install SVN.</P><P>Usually, systems providing packages reference SVN&rsquo;s package as &rsquo;subversion&rsquo;.</P><P>To install SVN on Debian or Ubuntu, run:</P><PRE CLASS="verbatim">$ sudo apt-get install subversion
</PRE><P>For other distributions, please refer to the user documentation of your system.</P><P>Once you have SVN installed, go to the directory where you would like to
download Olena and create a new directory.</P><PRE CLASS="verbatim">$ cd $HOME
$ mkdir olena
$ cd olena
</PRE><P>Then &rsquo;checkout&rsquo; (download) the repository with the following command.</P><PRE CLASS="verbatim">$ svn co https://svn.lrde.epita.fr/svn/oln/trunk
</PRE><P>Enter the &rsquo;trunk&rsquo; directory.</P><PRE CLASS="verbatim">$ cd trunk
</PRE><P>You are now ready to configure the directory and install Milena as described
in section 
\endhtmlonly\ref tuto2\htmlonly .
We invite you to take a look at the description of the directory structure
(section 
\endhtmlonly\ref tuto1dirstruct\htmlonly ).
If you encounter any issues in the installation process or if you have any
question, do not forget to join the mailing lists (section 
\endhtmlonly\ref tuto1mailinglists\htmlonly )
and/or use the other documentations resources (section reftuto1documentation).</P><P><A NAME="tuto1downloadingpackages"></A>
\endhtmlonly

\subsection tuto1downloadingpackages Downloading packaged releases

\htmlonly
 </P><P>Milena&rsquo;s packages can be downloaded from:</P><P><A HREF="http://www.lrde.epita.fr/Olena/Download">http://www.lrde.epita.fr/Olena/Download</A></P><P>On this page you will find the latest and past releases.
Currently, we provide only &rsquo;.tar.gz&rsquo; and &rsquo;tar.bz2&rsquo; archives.</P><P>Once downloaded, you just need to uncompress the archive.</P><P>For the &rsquo;.tar.gz&rsquo; archive:
</P><PRE CLASS="verbatim">$ tar zxvf olena.tar.gz
</PRE><P>For the &rsquo;.tar.bz2&rsquo; archive:
</P><PRE CLASS="verbatim">$ tar jxvf olena.tar.bz2
</PRE><P>Then, enter the new created directory:
</P><PRE CLASS="verbatim">$ cd olena
</PRE><P>You are now ready to configure the directory and install Milena as described
in section 
\endhtmlonly\ref tuto2\htmlonly .
We invite you to take a look at the description of the directory structure
(section 
\endhtmlonly\ref tuto1dirstruct\htmlonly ).
If you encounter any issues in the installation process or if you have any
question, do not forget to join the mailing lists (section

\endhtmlonly\ref tuto1mailinglists\htmlonly ) and/or use the other documentations resources
(section 
\endhtmlonly\ref tuto1documentation\htmlonly )).</P><P><BR>
<BR>
<BR>

<A NAME="tuto1mailinglists"></A>
\endhtmlonly

\section tuto1mailinglists Join the mailing lists

\htmlonly
 </P><P>Regardless your use of Olena, we strongly advise you to join our mailing lists.
This is the best way to keep up to date about new releases, bug
notifications/fixes and future updates.
This is also a good opportunity to tell us what you would like to find in
Milena and what could be improved.</P><P>Currently four mailing-lists are available:</P><TABLE CELLSPACING=6 CELLPADDING=0><TR><TD ALIGN=left NOWRAP><B>Olena</B>		</TD><TD ALIGN=left NOWRAP>Discussion about the project Olena</TD></TR>
<TR><TD ALIGN=left NOWRAP><B>Olena-bugs</B>	</TD><TD ALIGN=left NOWRAP>Bugs from Olena projects</TD></TR>
<TR><TD ALIGN=left NOWRAP><B>Olena-core</B>	</TD><TD ALIGN=left NOWRAP>Internal list for the Olena project</TD></TR>
<TR><TD ALIGN=left NOWRAP><B>Olena-patches</B>	</TD><TD ALIGN=left NOWRAP>patches for the Olena project</TD></TR>
</TABLE><P>You can subscribe to these mailing lists at the following address:</P><DIV CLASS="center">
<PRE CLASS="verbatim">https://www.lrde.epita.fr/mailman/listinfo/
</PRE></DIV><P>Just click on the name of the mailing list you want to subscribe to and fill
out the form.</P><P><BR>
<BR>
<BR>

<A NAME="tuto1dirstruct"></A>
\endhtmlonly

\section tuto1dirstruct Directory structure

\htmlonly
 </P><P>Milena&rsquo;s directory is composed of several subdirectories. In order to help
you finding what you need, you will find a description of all these
subdirectories.</P><P><BR>

List of <I>milena</I>&rsquo;s subdirectories:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
<I><B>apps</B></I>
 &#X2014; A full example of a 3D mesh visualisation tool. It
uses milena.</LI><LI CLASS="li-itemize">
<I><B>doc</B></I>
 &#X2014; THE directory you must know. Contains all the
documentation material.</LI><LI CLASS="li-itemize">
<I><B>img</B></I>
 &#X2014; A set of common test images. They are used in the
test suite. Feel free to use it in your programs.</LI><LI CLASS="li-itemize">
<I><B>mesh</B></I>
 &#X2014; A set of 3D meshes. They can be used with the full
example located in <I>milena/apps</I>.</LI><LI CLASS="li-itemize">
<I><B>mln</B></I>
 &#X2014; The core of the library. Contains all the library headers.</LI><LI CLASS="li-itemize">
<I><B>tests</B></I>
 &#X2014; The test suite. Is it subdivided in sub directories.
The directory hierarchy respects <I>milena/mln</I>&rsquo;s.</LI><LI CLASS="li-itemize">
<I><B>tools</B></I>
 &#X2014; Small tools written with milena. They can be used as examples.</LI></UL><P><BR>

List of <I>mln</I>&rsquo;s subdirectories:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">

<I><B>accu</B></I>
 &#X2014; Set of Accumulators.
</LI><LI CLASS="li-itemize">
<I><B>algebra</B></I>
 &#X2014; Algebraic structures like vectors or matrices.
</LI><LI CLASS="li-itemize">
<I><B>arith</B></I>
 &#X2014; Arithmetical operators.
</LI><LI CLASS="li-itemize">
<I><B>binarization</B></I>
 &#X2014; Routines to binarize an image.
</LI><LI CLASS="li-itemize">
<I><B>border</B></I>
 &#X2014; Image border related routines.
</LI><LI CLASS="li-itemize">
<I><B>canvas</B></I>
 &#X2014; Generic canvas. They define generic ways of browsing
an image, compute data, &#X2026;.
</LI><LI CLASS="li-itemize">
<I><B>convert</B></I>
 &#X2014; Automatic conversion mechanism.
</LI><LI CLASS="li-itemize">
<I><B>core</B></I>
 &#X2014; Core of the library. Here you can find the image types,
the site set types and basic concepts.
</LI><LI CLASS="li-itemize">
<I><B>data</B></I>
 &#X2014; Routines that modify image data.
</LI><LI CLASS="li-itemize">
<I><B>debug</B></I>
 &#X2014; Debug related routines.
</LI><LI CLASS="li-itemize">
<I><B>display</B></I>
 &#X2014; Display images on the screen.
</LI><LI CLASS="li-itemize">
<I><B>draw</B></I>
 &#X2014; Draw geometric objects in an image.
</LI><LI CLASS="li-itemize">
<I><B>essential</B></I>
 &#X2014; Set of essential headers for 1,2,3-D manipulations.
</LI><LI CLASS="li-itemize">
<I><B>estim</B></I>
 &#X2014; Compute data on image values.
</LI><LI CLASS="li-itemize">
<I><B>extension</B></I>
 &#X2014; Image extension manipulation.
</LI><LI CLASS="li-itemize">
<I><B>fun</B></I>
 &#X2014; Set of functions applying on sites, values, &#X2026;</LI><LI CLASS="li-itemize">
<I><B>geom</B></I>
 &#X2014; Functions related to image geometry.
</LI><LI CLASS="li-itemize">
<I><B>graph</B></I>
 &#X2014; Graph related routines.
</LI><LI CLASS="li-itemize">
<I><B>histo</B></I>
 &#X2014; Histogram related functions.
</LI><LI CLASS="li-itemize">
<I><B>io</B></I>
 &#X2014; I/O related routines.
</LI><LI CLASS="li-itemize">
<I><B>labeling</B></I>
 &#X2014; Labeling related routines.
</LI><LI CLASS="li-itemize">
<I><B>linear</B></I>
 &#X2014; Linear operators.
</LI><LI CLASS="li-itemize">
<I><B>literal</B></I>
 &#X2014; Generic image values such as zero, black, white &#X2026;</LI><LI CLASS="li-itemize">
<I><B>logical</B></I>
 &#X2014; Logical operators.
</LI><LI CLASS="li-itemize">
<I><B>make</B></I>
 &#X2014; Small routines to construct images, windows, &#X2026;</LI><LI CLASS="li-itemize">
<I><B>math</B></I>
 &#X2014; Mathematical functions.
</LI><LI CLASS="li-itemize">
<I><B>metal</B></I>
 &#X2014; Metallic macros/structures. Static library helping
developing doing static tests.
</LI><LI CLASS="li-itemize">
<I><B>morpho</B></I>
 &#X2014; Mathematical morphology.
</LI><LI CLASS="li-itemize">
<I><B>norm</B></I>
 &#X2014; Norm computation.
</LI><LI CLASS="li-itemize">
<I><B>opt</B></I>
 &#X2014; Optional routines. Routines which may work on a
specific image type only.
</LI><LI CLASS="li-itemize">
<I><B>pw</B></I>
 &#X2014; Point-wise image related routines.
</LI><LI CLASS="li-itemize">
<I><B>registration</B></I>
 &#X2013; Registration related routine.
</LI><LI CLASS="li-itemize">
<I><B>set</B></I>
 &#X2014; Set related routines.
</LI><LI CLASS="li-itemize">
<I><B>subsampling</B></I>
 &#X2014; Sub-sampling related algorithms.
</LI><LI CLASS="li-itemize">
<I><B>tag</B></I>
 &#X2014; Tag traits.
</LI><LI CLASS="li-itemize">
<I><B>test</B></I>
 &#X2014; Definition of predicates.
</LI><LI CLASS="li-itemize">
<I><B>topo</B></I>
 &#X2014; Complex related structures.
</LI><LI CLASS="li-itemize">
<I><B>trace</B></I>
 &#X2014; Debug trace mechanism.
</LI><LI CLASS="li-itemize">
<I><B>trait</B></I>
 &#X2014; Internal traits mechanism.
</LI><LI CLASS="li-itemize">
<I><B>transform</B></I>
 &#X2014; Algorithms based on the data::transform.
</LI><LI CLASS="li-itemize">
<I><B>util</B></I>
 &#X2014; Various utilitarian classes.
</LI><LI CLASS="li-itemize">
<I><B>value</B></I>
 &#X2014; Set of value types which can be used in an image.
</LI><LI CLASS="li-itemize">
<I><B>win</B></I>
 &#X2014; Set of various window kinds.
</LI></UL><P>The source code and the material of the documentation is available in <I>
milena/doc</I>.
List of <I>doc</I>&rsquo;s subdirectories:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">

<I><B>examples</B></I>
 &#X2014; All the source code of the documentation examples.
</LI><LI CLASS="li-itemize">
<I><B>benchmark</B></I>
 &#X2014; Some benchmarks.
</LI><LI CLASS="li-itemize">
<I><B>tools</B></I>
 &#X2014; Small tools used for generating documentation /
building examples.</LI><LI CLASS="li-itemize">
<I><B>tutorial</B></I>
 &#X2014; Tutorial sources.
</LI><LI CLASS="li-itemize">
<I><B>white_paper</B></I>
 &#X2014; White paper sources.
</LI><LI CLASS="li-itemize">
<I><B>ref_guide</B></I>
 &#X2014; Reference guide sources.
</LI><LI CLASS="li-itemize">
<I><B>figures</B></I>
 &#X2014; Reference figures for documentation generation.
</LI><LI CLASS="li-itemize">
<I><B>outputs</B></I>
 &#X2014; Reference outputs for documentation examples.</LI></UL><P><BR>
<BR>
<BR>

<A NAME="tuto1documentation"></A>
\endhtmlonly

\section tuto1documentation Documentation

\htmlonly
 </P><P>This tutorial is not the only documentation of Milena. Other documents are available:</P><UL CLASS="itemize"><LI CLASS="li-itemize">

<I><B>White paper</B></I>
 &#X2014; A small document of few pages presenting the key
features of the library. It intents to give a big picture of the library.</LI><LI CLASS="li-itemize">
<I><B>Quick tour</B></I>
 &#X2014; It aims at giving an overview of Milena&rsquo;s possibilities.
It does not only give the concepts but illustrate them with small sample
codes.</LI><LI CLASS="li-itemize">
<I><B>Quick reference guide</B></I>
 &#X2014; Presents in details all the main
functionalities of Milena.
Hints and full examples are also provided. The sample codes are commented
and each concept in the library is detailed. This is the reference document for any
<I>assembler</I> and <I>algorithm designer</I>.</LI><LI CLASS="li-itemize">
<I><B>HTML user doc</B></I>
 &#X2014; The full documentation of the library. The full
API is described in details. Each part of the library is classified by
categories and the source code is directly accessible from the documentation.
This is the reference document for any <I>algorithm designer</I> and/or
<I>provider of data structures</I>.</LI><LI CLASS="li-itemize">
<I><B>Header files</B></I>
 &#X2014; Every object or algorithm is declared in a &rsquo;.hh&rsquo; file.
The documentation is provided as comments in these file.
</LI></UL><P><BR>
<BR>
<BR>

<A NAME="tuto1community"></A>
\endhtmlonly

\section tuto1community Community and Support

\htmlonly
 </P><P>Even though Milena is currently developed by the LRDE in EPITA, we are open
for new contributors.</P><UL CLASS="itemize"><LI CLASS="li-itemize">
If you are a user, please send us feedback about the library.
Did you find what you wanted? Do you miss something?</LI><LI CLASS="li-itemize">Please report bugs and defects in the API. Mailing lists are the best
way for reporting that (section 
\endhtmlonly\ref tuto1mailinglists\htmlonly ).</LI><LI CLASS="li-itemize">Developers, if you write cool open source programs or algorithms with Milena,
send them to us. We may ship your code with Olena and/or add it to
our download page.</LI><LI CLASS="li-itemize">Educators, if you use Olena for your courses and you are ready to
share your materials, you can send it to us through our mailing-lists.</LI><LI CLASS="li-itemize">We are also interested in partnership or commercial use of Milena.
If you are interested, contact us directly (
\endhtmlonly\ref tuto1contacts\htmlonly ).</LI></UL><P><BR>
<BR>
<BR>

<A NAME="tuto1projectstatus"></A>
\endhtmlonly

\section tuto1projectstatus Project status

\htmlonly
 </P><P>If you want to stay tuned to Milena&rsquo;s development, the best way is probably
the mailing-lists (section 
\endhtmlonly\ref tuto1mailinglists\htmlonly ).</P><P>There are other ways to get to know what is the status of the project.</P><UL CLASS="itemize"><LI CLASS="li-itemize">
Olena&rsquo;s trac<BR>
 <A HREF="https://trac.lrde.org/olena">https://trac.lrde.org/olena</A><BR>
 Here is the road-map, the current open tickets/bugs/improvements which
are taken in consideration. A source browser is also available.</LI><LI CLASS="li-itemize">Olena&rsquo;s Buildfarm<BR>
 <A HREF="https://buildfarm.lrde.org/buildfarm/oln/">https://buildfarm.lrde.org/buildfarm/oln/</A><BR>
 The official build-farm. Every night and after each commit, tests
are compiled and run. The build-farm can show you whether it is safe
to update your svn copy of Milena or not&#X2026;</LI><LI CLASS="li-itemize">Test failures<BR>
 <A HREF="http://www.lrde.epita.fr/dload/olena/test-failures-daily.html">http://www.lrde.epita.fr/dload/olena/test-failures-daily.html</A><BR>
 Through this page, you can see exactly which tests do not compile or pass.
This page is updated every night.</LI></UL><P><BR>
<BR>
<BR>

<A NAME="tuto1briefhistory"></A>
\endhtmlonly

\section tuto1briefhistory A brief history of Milena

\htmlonly
 </P><P>The Olena project aims at building a scientific computation platform oriented
towards image processing, image recognition, and artificial vision.
This environment is composed of a high performance generic library (Milena),
a set of tools for shell scripts, together with, in the more distant future,
an interpreter (a la Octave, MatLab etc.) and a visual programming environment.</P><P>The Olena project started in 2000 from a small prototype on 2-D images.
From November 2001 to April 2004, this prototype evolved from version 0.1 to 0.10.
More image types were supported and the level of genericity expected from the
library was partially obtained. During these three years, the prototype was used
to experiment with genericity and to try to meet our objectives.
In February 2007, Olena 0.11 was released to conform modern C++ compilers.
At that time, the code was not enough readable though and the compilation time
was too long.</P><P>Since June 2007 up to now, The library of the Olena platform is called Milena
and the library has been rewritten. The programming paradigm has been
simplified: the code is more readable and the compilation time is acceptable.
The level of genericity still meets our objectives though.</P><P>Milena is now getting ready for being considered as stable and distributable.
The core of the library is getting frozen and we aim at enriching the library,
its documentation and the related tools.</P><P><BR>
<BR>
<BR>

<A NAME="tuto1contacts"></A>
\endhtmlonly

\section tuto1contacts Contacts

\htmlonly
 </P><P>If you want to reach us directly, you can contact one of the following people:</P><UL CLASS="itemize"><LI CLASS="li-itemize">
Thierry Geraud - Project Manager - thierry.geraud@lrde.epita.fr
</LI><LI CLASS="li-itemize">Jonathan Fabrizio - jonathan.fabrizio@lrde.epita.fr
</LI><LI CLASS="li-itemize">Yann Jacquelet - yann.jacquelet@lrde.epita.fr
</LI><LI CLASS="li-itemize">Guillaume Lazzara - guillaume.lazzara@lrde.epita.fr
</LI><LI CLASS="li-itemize">Roland Levillain - roland.levillain@lrde.epita.fr
</LI></UL><P><BR>
<BR>
<BR>
<BR>
<BR>
<BR>

</P><DIV CLASS="center">
<DIV CLASS="center">Go to 
\endhtmlonly\ref tuto2\htmlonly &nbsp; &#X2014;&rarr;</DIV>
</DIV><P><A NAME="tuto2"></A>
\endhtmlonly

*/


/*!
\page tuto2 Installation

\htmlonly
 </P><P>This section describes the installation process of Milena.
Do not forget that Milena is a library, not a program. Therefore, no program
will be installed.</P><P>Milena&rsquo;s examples and tests are compiled on the following platforms:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
Apple Tiger Darwin 8, PowerPC, GCC 4.0.1
</LI><LI CLASS="li-itemize">Apple Leopard Darwin 10.5, X86-64, GCC 4.0.1, 4.2
</LI><LI CLASS="li-itemize">Linux, i486, GCC 3.3, 4.1, 4.2, 4.3
</LI><LI CLASS="li-itemize">Linux, x86-64, GCC 4.1
</LI></UL><P>We guaranty that Milena compiles on these platforms, e.g. Linux and Unix
platforms. It may compiles on other platforms though but we have not tested.
If you did, and you succeeded, please let us know in order to update this
section.</P><P>Milena is known NOT to work with GCC-2.95.</P><P>Milena is actively developed under Unix systems. As a result, the build system
is based on the Autotools.
Autotools make sure that every dependencies are resolved before compiling
or installing a program.</P><P>Milena is different from usual libraries in a way that nothing needs to be
compiled to use it. The library itself is composed of headers which must be
included when you need them.
Then, your application will be compiled with the parts of the library used in
that program. That&rsquo;s all.</P><P>So, why do we have a build system? It is useful for installing the library on
your system, generating the doc and compiling the test suite and the examples.</P><P><BR>
<BR>
<BR>

<A NAME="tuto2bootstrap"></A>
\endhtmlonly

\section tuto2bootstrap Bootstrap (SVN Sources)

\htmlonly
 </P><P>If you got the sources from a package/tarball, you can skip this section. Go
to section 
\endhtmlonly\ref tuto2configure\htmlonly .</P><P>If you downloaded the sources from the SVN repository, you must launch a
script before configuring the build directory.</P><P>Run the following:
</P><PRE CLASS="verbatim">$ cd /my/path/to/olena
$ ./bootstrap
</PRE><P>Running &rsquo;bootstrap&rsquo; can take a while. Some files are generated during this
process.
When it&rsquo;s done, you are ready to configure the build directory.</P><P><BR>
<BR>
<BR>

<A NAME="tuto2configure"></A>
\endhtmlonly

\section tuto2configure Configure

\htmlonly
 </P><P>First, make sure you are at the root directory of the milena source:</P><PRE CLASS="verbatim">$ cd /my/path/to/olena
</PRE><P>First, create and enter a build directory:
</P><PRE CLASS="verbatim">$ mkdir build
$ cd build
</PRE><P>We are now about to configure the build directory. This process will create
the necessary files to compile documentation, examples and tools and prepare the
installation.</P><P>Note that once the configuration ends the build directory cannot be
moved elsewhere without following the following steps again.</P><P><B>Important Note</B>: the installation path prefix must be chosen at this step.
By default, Milena will be installed in /usr/local but you may like to install
it elsewhere. To do so, pass the option <I>--prefix=/installation/path/prefix</I>
to the configure script (see below). Replace &rsquo;/installation/path/prefix&rsquo; with the
wanted installation path prefix.</P><P>now, you can run:
</P><PRE CLASS="verbatim">$ ../configure
</PRE><P>OR
</P><PRE CLASS="verbatim">$ ../configure --prefix=/installation/path/prefix
</PRE><P>The configure script will perform various tests. If there is no dependency
issues, the last lines shown before the prompt are:</P><PRE CLASS="verbatim">config.status: creating config.h
config.status: executing depfiles commands
$
</PRE><P>And if you type the following command, a &rsquo;0&rsquo; is printed out.
</P><PRE CLASS="verbatim">$ echo $?
0
$
</PRE><P>The build directory is now configured, the library can be installed.</P><P><BR>
<BR>
<BR>

<A NAME="tuto2install"></A>
\endhtmlonly

\section tuto2install Install

\htmlonly
 </P><P>First, be sure to be in the build directory. If you followed the previous
steps, the build directory should be in the Milena sources root directory.</P><PRE CLASS="verbatim">$ cd /my/path/to/olena/build
</PRE><P>If you did not change the default install path prefix, set to
<I>/usr/local</I>, you will need to have administrator privileges to
perform the installation. Then, you may type:
</P><PRE CLASS="verbatim">$ sudo make install
</PRE><P>You will be prompted for the administrator password.</P><P>Otherwise, if you set the install path prefix to a directory own by your
user, simply type:
</P><PRE CLASS="verbatim">$ make install
</PRE><P>When the installation is finished, you are done. Milena is installed on your
system. But maybe you would like to build the examples? This is described
in section 
\endhtmlonly\ref tuto2optionalcomp\htmlonly .</P><P>A description of the installation content is also available in section

\endhtmlonly\ref tuto2installcontent\htmlonly .</P><P><BR>
<BR>
<BR>

<A NAME="tuto2optionalcomp"></A>
\endhtmlonly

\section tuto2optionalcomp Optional compilation

\htmlonly
 </P><P>The library itself does not need to be compiled, therefore installing
Milena does not require compilation.</P><P>Though, some examples and tools are provided with the library and must be
compiled if you want to use them.</P><P><A NAME="tuto2examples"></A>
\endhtmlonly

\subsection tuto2examples Examples

\htmlonly
 </P><P>Examples are part of the documentation. The sources are located in
<I>milena/doc/examples</I>.</P><P>To compile the examples simply run:
</P><PRE CLASS="verbatim">$ cd /my/path/to/olena/build/milena/doc/examples
$ make
</PRE><P>These examples can produce outputs and images. May be you would like
to run all the examples and take a look at the outputs? To do so, run:
</P><PRE CLASS="verbatim">$ cd /my/path/to/olena/build/milena/doc/examples
$ make examples
</PRE><P>Text and image outputs will be respectively stored in
<I>build/milena/doc/outputs</I> and <I>build/milena/doc/figures</I>.</P><P><A NAME="tuto2tools"></A>
\endhtmlonly

\subsection tuto2tools Tools

\htmlonly
 </P><P>Few tools are provided with Milena. They can be considered as full program
examples.</P><P>Currently two tools are available:<BR>

</P><TABLE CELLSPACING=6 CELLPADDING=0><TR><TD ALIGN=left NOWRAP>area_flooding.cc</TD><TD ALIGN=left NOWRAP>&nbsp;</TD></TR>
<TR><TD CLASS="hbar" COLSPAN=2></TD></TR>
<TR><TD ALIGN=left NOWRAP>seed2tiling.cc</TD><TD ALIGN=left NOWRAP>&nbsp;</TD></TR>
</TABLE><P><BR>
<BR>
</P><P>To build these tools, run:
</P><PRE CLASS="verbatim">$ cd /my/path/to/olena/build/milena/tools
$ make
</PRE><P><A NAME="tuto2tests"></A>
\endhtmlonly

\subsection tuto2tests Tests

\htmlonly
 </P><P>The test suite used for Milena&rsquo;s development is shipped with the library.
It is usually useless for simple users and tends to be used by developers
extending the library.</P><P>In order to build and run it, just do the following:
</P><PRE CLASS="verbatim">$ cd /my/path/to/olena/build/milena/tests
$ make check
</PRE><P>Running the test suite is memory and CPU consuming and will take a while.</P><P><BR>
<BR>
<BR>

<A NAME="tuto2installcontent"></A>
\endhtmlonly

\section tuto2installcontent Installation content

\htmlonly
 </P><P>Once installed, Milena&rsquo;s files are located in the installed path prefix
you passed to the configure script or in the default path /usr/local.</P><P>In the installation path prefix, Milena&rsquo;s files are located in:</P><UL CLASS="itemize"><LI CLASS="li-itemize">
include/mln/ &#X2014; The library. All the headers are located here.
</LI><LI CLASS="li-itemize">share/olena/images &#X2014; Mesh sample files which may be used with
example programs.
</LI><LI CLASS="li-itemize">share/olena/doc &#X2014; HTML and PDF documentation.
</LI></UL><P><BR>
<BR>
<BR>
<BR>
<BR>
<BR>

</P><DIV CLASS="center">
<DIV CLASS="center">&#X2190;&#X2014;&nbsp;Go to 
\endhtmlonly\ref tuto1\htmlonly  &nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp; Go to 
\endhtmlonly\ref tuto3\htmlonly &nbsp; &#X2014;&rarr;</DIV>
</DIV><P><A NAME="tuto3"></A>
\endhtmlonly

*/


/*!
\page tuto3 Getting started with Milena

\htmlonly
 </P><P><BR>
<BR>
<BR>

<A NAME="tuto3getfamiliargen"></A>
\endhtmlonly

\section tuto3getfamiliargen Getting familiar with genericity

\htmlonly
 </P><P>One of Milena&rsquo;s main features is its genericity. In order to understand how to
take benefit of it, let&rsquo;s see what genericity really means for us and how it is
illustrated in the library.</P><P>A 
<B>Generic algorithm</B>
 is written once, without duplicates, and works on
different kinds of input.</P><P>Let&rsquo;s have a look to a small example. In any image processing library, we may be
interested in a small routine to fill an image with data. A common
implementation would look like this one:</P><P>
\endhtmlonly

\include tuto3/fill_non_generic.cc.raw

\htmlonly
 </P><P>See milena/doc/examples/tuto3/fill_non_generic.cc.</P><P>In this example, there are a lot of 
<B>implicit</B>
 assumptions about the input:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
The input image has to be 2D;
</LI><LI CLASS="li-itemize">Its definition domain has to be a rectangle starting at (0,0);
</LI><LI CLASS="li-itemize">Data cannot be of a different type than <I>unsigned char</I>;
</LI><LI CLASS="li-itemize">Image data need to be stored as a 2D array in RAM.
</LI></UL><P>
So, what would happen if we would like to use it for 3D images, use rgb8 as
value or even work on a region of interest?</P><P>This implementation would require to be re-implemented and the user would have to
deal with the various versions of the fill routine. For the developer, it is error
prone, redundant and hard to maintain. For the user, it is confusing and forces
to always think about what he is manipulating.
According to our definition, this algorithm is clearly 
<B>not</B>
 generic.</P><P>This is not acceptable and that&rsquo;s why Milena is developed considering
genericity and user/developer friendliness.</P><P>With Milena, the previous example would be written as follow:</P><P>
\endhtmlonly

\include fill-1.cc.raw

\htmlonly
 </P><P>In this version, the routine can take any kind of image types as arguments. So
it is for the values: the expected type depends on the value used in the
given image.
The <I>for_all</I> loop is also significantly generic to support any kind of
images since the iterator guarantees it will pass through every sites.</P><P>This code is more generic and remains really close to the common description of
the generic algorithm.</P><P>As a result, with this algorithm we can fill an image,...

\endhtmlonly

\include fill-3.cc.raw

\htmlonly
 

\endhtmlonly

\image html fill-2.png

\htmlonly
 </P><P>... Or fill only a region of interest (a set of points).

\endhtmlonly

\include fill-2.cc.raw

\htmlonly
 

\endhtmlonly

\image html fill-1.png

\htmlonly
 </P><P><BR>
<BR>
<BR>

<A NAME="tuto3firstgenalgo"></A>
\endhtmlonly

\section tuto3firstgenalgo First generic algorithm

\htmlonly
 
In this section, we will introduce several routines/tools which are useful while
writing generic algorithms. It is more important to focus on these
routines/tools than what this program actually does.</P><P>Here is the full example:</P><P>
\endhtmlonly

\include tuto3_first_routine-1.cc.raw

\htmlonly
 
Let&rsquo;s see the different parts of the algorithm.</P><P>
\endhtmlonly

\include tuto3_first_routine-2.cc.raw

\htmlonly
 
The prototype is restrictive enough, readable and still generic.
We use concepts to statically check that the generic type passed as
parameter is what the routine expects. The &ldquo;exact&rdquo; image type is <I>I</I>. For
instance an image of type <I>image2d</I> inherits from <I>Image&lt;image2d&gt;</I>. So
an <I>image2d</I> is an <I>Image&lt;I&gt;</I>.
Note that the return type of this function is defined by a macro.
<I>mln_concrete</I> is a macro hiding tricky mechanisms (traits) used in Milena.
The important point to remember is that a generic function should not return
<I>I</I> directly but <I>mln_concrete(I)</I> instead.</P><P>
\endhtmlonly

\include tuto3_first_routine-3.cc.raw

\htmlonly
 
Like any Milena&rsquo;s routine, note that we use <I>trace</I>. This debugging tool
will be detailed in section 
\endhtmlonly\ref tuto3debughints\htmlonly .</P><P>
\endhtmlonly

\include tuto3_first_routine-4.cc.raw

\htmlonly
 
Since the function take some arguments as concept objects, these object cannot
be used as such. Indeed, concepts are empty shells only used for dispatching and
concept checking, that&rsquo;s the reason why they are parameterized with their exact
type. The exact type let us know what is the real type of the object. To get an
object with the exact type, simply call <I>exact()</I>.
Of course, it is always a good idea to add few preconditions to help during
debug.</P><P>
\endhtmlonly

\include tuto3_first_routine-5.cc.raw

\htmlonly
 
In this portion of code, the image is labeled and the number of sites per label
is computed. This code does not depend on the image type at all. Again, a macro
<I>mln_ch_value</I> (&ldquo;mln change value&rdquo;) helps us. <I>labeling::blobs</I> is
a routine returning an image of the same kind as the input image but with a
different value. <I>mln_ch_value</I> enables the possibility of doing that,
whatever the image type <I>I</I> and whatever its value type, it returns the
same image type with a different value type.</P><P>
\endhtmlonly

\include tuto3_first_routine-6.cc.raw

\htmlonly
 
The output image is declared here. Like any variable, it must be initialized at
some point. To do so, <I>initialize()</I> is provided. It is a generic routine
which can initialize the geometry of any image kind with another image of the
same kind.
After this call, <I>output</I> has a valid domain and is valid. It can be used in
an algorithm, here <I>data::fill</I>, to have its values modified.
Note that the value passed to <I>data::fill</I> is also generic. The library
includes few generic common values from which any value type can convert to.
<I>literal::one</I> is one of them. It is a generic one value which can convert
to every value type in the library.</P><P>
\endhtmlonly

\include tuto3_first_routine-7.cc.raw

\htmlonly
 
In this part, every region from the labeled image, of which cardinality is lower
than 10 sites, is set to <I>literal::zero</I> in <I>output</I>.
Once again, a generic value is used in order to avoid constraints on the image
value type.</P><P>
\endhtmlonly

\include tuto3_first_routine-8.cc.raw

\htmlonly
 
Don&rsquo;t forget to close the trace before exiting the function. Then return the
result.</P><P><BR>
<BR>
<BR>

<A NAME="tuto3compilhints"></A>
\endhtmlonly

\section tuto3compilhints Compilation

\htmlonly
 </P><P><A NAME="tuto3howtocompile"></A>
\endhtmlonly

\subsection tuto3howtocompile Include path

\htmlonly
 </P><P>If Milena has been installed in a custom directory, e.g. not /usr/include or
/usr/local/include, the path to the library headers must be passed to the
compiler.</P><P>With g++ and MinGW, the option is 
<B>-I&lt;path&gt;</B>
.
</P><PRE CLASS="verbatim">$ g++ -Ipath/to/mln my_program.cc
</PRE><P>For other compilers, please look at the documentation and search for &ldquo;include
path&rdquo;.</P><P><A NAME="tuto3liblink"></A>
\endhtmlonly

\subsection tuto3liblink Library linking

\htmlonly
 
As it is usually expected when using a library, no library linking is needed for
the library itself.
Milena is a &ldquo;header only&rdquo; library and is compiled &ldquo;on demand&rdquo; with your
program.</P><P>If you use specific input/output you may need to link your program with the
right graphic library. For more information, please refer to section

\endhtmlonly\ref inputoutput\htmlonly  in the Quick Reference Guide.</P><P><A NAME="tuto3compildndebug"></A>
\endhtmlonly

\subsection tuto3compildndebug Disable Debug

\htmlonly
 
By default, Olena enables a lot of internal pre and post conditions. Usually,
this is a useful feature and it should be enabled. It can heavily slow down a
program though and these tests can be disabled by compiling using -DNDEBUG:</P><PRE CLASS="verbatim">$ g++ -DNDEBUG -Ipath/to/mln my_program.cc
</PRE><P><A NAME="tuto3compoptimflags"></A>
\endhtmlonly

\subsection tuto3compoptimflags Compiler optimization flags

\htmlonly
 </P><P>In this section you will find remarks about the compiler optimization flags and
their impact on the compilation and execution time.</P><P><A NAME="tuto3compoptimgcc"></A>
\endhtmlonly

\subsubsection tuto3compoptimgcc GCC

\htmlonly
 </P><UL CLASS="itemize"><LI CLASS="li-itemize">

<B>-O0</B>
, combined with -DNDEBUG, it leads to the fastest compilation
time. The execution is somewhat slow though since dispatch functions and one
line members are not inlined by the compiler.
</LI><LI CLASS="li-itemize">
<B>-O1</B>
, best compromise between compilation time and execution time.
</LI><LI CLASS="li-itemize">
<B>-O2</B>
, 
<B>-O3</B>
, combined with -DNDEBUG, it leads to the best execution
time. However these optimizations dramatically slow down the compilation and
requires much more memory at compile time.
</LI></UL><P><A NAME="tuto3compoptimother"></A>
\endhtmlonly

\subsubsection tuto3compoptimother Other compilers

\htmlonly
 </P><P>Currently, we have not tested different optimization flags with other
compilers. If you did, please report us your results.</P><P><BR>
<BR>
<BR>

<A NAME="tuto3debughints"></A>
\endhtmlonly

\section tuto3debughints Debug hints

\htmlonly
 </P><P><A NAME="tuto3gdbhints"></A>
\endhtmlonly

\subsection tuto3gdbhints Using assertions and GDB

\htmlonly
 
As said above, Milena already includes a lot of post and pre conditions.
Thus, if you made a mistake in your code there is a high probability that it
will be detected at run time. If an assertion fails, we advice you to compile
with the following options:</P><PRE CLASS="verbatim">$ g++ -ggdb -Ipath/to/mln my_program.cc
</PRE><P>Note that you 
<B>MUST NOT</B>
 compile with <I>&#X2212;DNDEBUG</I> since assertions will be
disabled.
Once compiled, restart the program with GDB.</P><PRE CLASS="verbatim">$ gdb ./my_program
</PRE><P>In the GDB console, run it again.
</P><PRE CLASS="verbatim">(gdb) run &lt;any parameter you may want to pass to the program&gt;
</PRE><P>When an assertion fails, in the GDB console simply type:
</P><PRE CLASS="verbatim">(gdb) bt
</PRE><P>The full backtrace will be printed out and you will be able to find from where
the error come from. The filenames, the line numbers and the parameters values
are printed out in the backtrace as you can see in the following example:</P><PRE CLASS="verbatim">#0  0xffffe410 in __kernel_vsyscall ()
#1  0xb7d00640 in raise () from /lib/i686/cmov/libc.so.6
#2  0xb7d02018 in abort () from /lib/i686/cmov/libc.so.6
#3  0xb7cf95be in __assert_fail () from /lib/i686/cmov/libc.so.6
#4  0x0804e094 in mln::image2d&lt;bool&gt;::has (this=0xbff32f34, p=@0xbff32f3c)
    at /lrde/stockholm/lazzara/svn/olena/git/oln/milena/mln/core/image/image2d.hh:442
#5  0x0804e6d7 in mln::image2d&lt;bool&gt;::operator() (this=0xbff32f34, p=@0xbff32f3c)
    at /lrde/stockholm/lazzara/svn/olena/git/oln/milena/mln/core/image/image2d.hh:460
#6  0x080490b0 in main () at test.cc:18
</PRE><P><A NAME="tuto3traces"></A>
\endhtmlonly

\subsection tuto3traces Traces

\htmlonly
 
Sometimes, compiling for GDB without optimization flags and with debug
assertions enabled could lead to execution time dramatically high.
If the function parameter values are not necessary for debugging,
a good alternative is the trace system provided in Milena.
Each time a routine is called, a trace log is written.</P><P>This trace allows to follow the stack trace at runtime. It also provides the
time passed in each function call if the call last at least 10ms.</P><P>In order to enable traces in a program, set the related global variable to
true:
</P><PRE CLASS="verbatim">...
trace::quiet = true;
...
</PRE><P>Since it&rsquo;s a global variable, at anytime in the source code, the trace can be
enabled/disabled.</P><P>Traces are enabled:

\endhtmlonly

\include tuto3_trace-1.cc.raw

\htmlonly
 
<I>labeleling::blobs</I> is run and the debug is then disabled.

\endhtmlonly

\include tuto3_trace-2.cc.raw

\htmlonly
 </P><P>The previous code will produce the following trace:</P><PRE CLASS="verbatim">labeling::blobs {
  core::initialize {}
  data::fill {
    data::fill_with_value {
      data::impl::fill_with_value_one_block {
        data::memset_ {
          data::impl::memset_ {}
        } data::memset_
      } data::impl::fill_with_value_one_block
    } data::fill_with_value
  } data::fill
} labeling::blobs - 0.08s
</PRE><P>As you can see, <I>labeling::blobs</I> is located just after having set
<I>trace::quiet</I> to <I>true</I> so its trace is part of the output.
<I>geom::bbox</I>&rsquo;s trace is not part of the output though since traces have
been disabled just before it is called.</P><P><A NAME="tuto3debugroutines"></A>
\endhtmlonly

\subsection tuto3debugroutines Debug routines

\htmlonly
 
Milena also provides a lot of debug tools. Here is a small list of the tools:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
mln::debug::println, print an image in the console.

\endhtmlonly

\include tuto3_println-1.cc.raw

\htmlonly
 

\endhtmlonly

\include tuto3_println-1.txt

\htmlonly
 </LI><LI CLASS="li-itemize">mln::debug::println_with_border, print an image in the console withs
its border.

\endhtmlonly

\include tuto3_println-2.cc.raw

\htmlonly
 

\endhtmlonly

\include tuto3_println-2.txt

\htmlonly
 </LI><LI CLASS="li-itemize">mln::labeling::colorize, colorize a label image with random colors.

\endhtmlonly

\include tuto3_colorize-1.cc.raw

\htmlonly
 <DIV CLASS="center">
<TABLE CELLSPACING=6 CELLPADDING=0><TR><TD ALIGN=center NOWRAP> 
\endhtmlonly

\image html tuto3_colorize-1.png

\htmlonly
 </TD><TD ALIGN=center NOWRAP>&nbsp;<FONT SIZE=6>&rarr;&nbsp;</FONT></TD><TD ALIGN=center NOWRAP> 
\endhtmlonly

\image html tuto3_colorize-2.png

\htmlonly
</TD></TR>
</TABLE>
</DIV></LI><LI CLASS="li-itemize">mln::labeling::superpose, Superpose two images.</LI><LI CLASS="li-itemize">mln::labeling::filename, easily format debug file names.</LI></UL><P><BR>
<BR>
<BR>
<BR>
<BR>
<BR>

</P><DIV CLASS="center">
<DIV CLASS="center">&#X2190;&#X2014;&nbsp;Go to 
\endhtmlonly\ref tuto2\htmlonly  &nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp; Go to 
\endhtmlonly\ref tuto4\htmlonly &nbsp; &#X2014;&rarr;</DIV>
</DIV><P><A NAME="tuto4"></A>
\endhtmlonly

*/


/*!
\page tuto4 Data representation

\htmlonly
 </P><P>This chapter aims at explaining how images are stored and which objects compose
an image in Milena. We will start to talk about the localization of a pixel and
then the image itself which stores the values.</P><P><BR>
<BR>
<BR>

<A NAME="tuto4sites"></A>
\endhtmlonly

\section tuto4sites Sites

\htmlonly
 </P><P>A pixel is an element having both information, localization and
value. In Milena, we make a difference between a pixel, a pixel value and a pixel
location. Thus, in order to refer to a pixel location, we have the site concept.
A site can be any kind of localization element.
For instance, in an image defined on a 2D regular grid, it is a 2D point with
<I>row</I> and <I>col</I> coordinates.</P><P>
\endhtmlonly

\include tuto4_point2d-1.cc.raw

\htmlonly
 </P><P>Output:

\endhtmlonly

\include tuto4_point2d.txt

\htmlonly
 </P><P>The image site type is defined by its underlying site set.</P><P><BR>
<BR>
<BR>

<A NAME="tuto4sitesets"></A>
\endhtmlonly

\section tuto4sitesets Site sets

\htmlonly
 </P><P>Site sets are mainly used to define image domains. They hold all the available
sites in an image, consequently they do not store any values.</P><P>Site sets can used as standalone containers.</P><P>A list of available site sets is available in section 
\endhtmlonly\ref siteset\htmlonly .</P><P><A NAME="tuto4createsiteset"></A>
\endhtmlonly

\subsection tuto4createsiteset Creating a site set

\htmlonly
 </P><P>In this section, we will detail how to create common site sets.</P><P>The most used site set is <I>mln::box</I>. The main reason is that
common images have this kind of domain. Since it is a plain set only
two sites are needed to define a box: the top left corner, <I>pmin</I>,
and the bottom right corner, <I>pmax</I>.</P><P>By default, <I>pmin</I> is set to <I>(0,0)</I> so a box can be
constructed from given <I>pmax</I> coordinates:</P><P>
\endhtmlonly

\include tuto4_site_set_create-1.cc.raw

\htmlonly
 </P><P>This box is defined from <I>(0,0)</I> to <I>(4,4)</I> :</P><P>
\endhtmlonly

\include tuto4_site_set_create-1.txt

\htmlonly
 </P><P>A box can also starts from a site different from <I>(0,0)</I>.</P><P>
\endhtmlonly

\include tuto4_site_set_create-4.cc.raw

\htmlonly
 </P><P>This box is defined from <I>(0,0)</I> to <I>(4,4)</I> :</P><P>
\endhtmlonly

\include tuto4_site_set_create-3.txt

\htmlonly
 </P><P>Another common site set is <I>p_array</I>. It contains only sites which have been added to it.</P><P>
\endhtmlonly

\include tuto4_site_set_create-2.cc.raw

\htmlonly
 </P><P>This site only contains :</P><P>
\endhtmlonly

\include tuto4_site_set_create-2.txt

\htmlonly
 </P><P><A NAME="tuto4accesstosites"></A>
\endhtmlonly

\subsection tuto4accesstosites Getting access to sites

\htmlonly
 </P><P><BR>
<BR>
<BR>

<A NAME="tuto4images"></A>
\endhtmlonly

\section tuto4images Images

\htmlonly
 </P><P>In milena, an image is seen as a composition of both a site set and a function
mapping a site to a value.</P><P><A NAME="tuto4createimate"></A>
\endhtmlonly

\subsection tuto4createimate Creating an image

\htmlonly
 </P><P>In this section, we will detail how to create common images.</P><P><A NAME="tuto4readimage"></A>
\endhtmlonly

\subsection tuto4readimage Reading an image from a file

\htmlonly
 </P><P><A NAME="tuto4accessdata"></A>
\endhtmlonly

\subsection tuto4accessdata Accessing data

\htmlonly
 </P><P><BR>
<BR>
<BR>
<BR>
<BR>
<BR>

</P><DIV CLASS="center">
<DIV CLASS="center">&#X2190;&#X2014;&nbsp;Go to 
\endhtmlonly\ref tuto3\htmlonly  &nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp; Go to 
\endhtmlonly\ref tuto5\htmlonly &nbsp; &#X2014;&rarr;</DIV>
</DIV><P><A NAME="tuto5"></A>
\endhtmlonly

*/


/*!
\page tuto5 Load and save images

\htmlonly
 </P><P>After this step you should know how to:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
load an image,
</LI><LI CLASS="li-itemize">save an image.
</LI></UL><P><BR>
<BR>
<BR>
<BR>
<BR>
<BR>

Currently, Olena supports the following input image formats:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
PBM
</LI><LI CLASS="li-itemize">PFM
</LI><LI CLASS="li-itemize">PGM
</LI><LI CLASS="li-itemize">PNM
</LI><LI CLASS="li-itemize">PPM
</LI></UL><P>This support is provided through two headers for each type, <I>save.hh</I> and
<I>load.hh</I>.
They are located in <I>mln/io/&lt;image-format&gt;/</I>.</P><P>Once the right header is included, the image can be loaded:</P><P>
\endhtmlonly

\include ima-load-1.cc.raw

\htmlonly
 </P><P>If you wan to save an image, simply call the save routine in the proper namespace:

\endhtmlonly

\include ima-save-1.cc.raw

\htmlonly
 </P><P>According to the image value type, the proper file format must be chosen.
The supported file formats and their associated image value types are listed
in section 
\endhtmlonly\ref imaio\htmlonly .</P><P><BR>
<BR>
<BR>
<BR>
<BR>
<BR>

</P><DIV CLASS="center">&#X2190;&#X2014;&nbsp;Go to 
\endhtmlonly\ref tuto4\htmlonly  &nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp; Go to 
\endhtmlonly\ref tuto6\htmlonly &nbsp; &#X2014;&rarr;</DIV><P><A NAME="tuto6"></A>
\endhtmlonly

*/


/*!
\page tuto6 Create your first image

\htmlonly
 </P><P>After this step you should know how to:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
create an image,
</LI><LI CLASS="li-itemize">display an image in console mode.
</LI></UL><P>
\endhtmlonly\see tuto2_first_image.cc\htmlonly </P><P><BR>
<BR>
<BR>
<BR>
<BR>
<BR>

First, declare an array of bool which will represent the image grid. Each each
cell in this grid is a site and each cell contains a value, <I>true</I> or
<I>false</I>.

\endhtmlonly

\include tuto2_first_image-1.cc.raw

\htmlonly
 </P><P>From that grid, simply call make::image to get an image initialized with that
data.

\endhtmlonly

\include tuto2_first_image-2.cc.raw

\htmlonly
 
This way of initializing an image is the most common one. However, there are
several other ways described in section 
\endhtmlonly\ref imacreate\htmlonly .</P><P>To be sure that the data is correctly initialized, it is possible to display the
image in the standard output using debug::println.

\endhtmlonly

\include tuto2_first_image-3.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include tuto2_first_image.txt

\htmlonly
 </P><P>Finally, you may want to save the image. Since we use bool as image value, the
PBM format is the best choice. Therefore, we use io::pbm::save.

\endhtmlonly

\include tuto2_first_image-4.cc.raw

\htmlonly
 </P><P>The output image looks like the following:<BR>


\endhtmlonly

\image html tuto2_first_image-1.png

\htmlonly
 </P><P>In this first step we used a boolean image. Many other value types are available
though. A more detailed description can be found in section

\endhtmlonly\ref imapossvalues\htmlonly .</P><P><BR>
<BR>
<BR>
<BR>
<BR>
<BR>

</P><DIV CLASS="center">
<DIV CLASS="center">&#X2190;&#X2014;&nbsp;Go to 
\endhtmlonly\ref tuto5\htmlonly  &nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp; Go to 
\endhtmlonly\ref tuto7\htmlonly &nbsp; &#X2014;&rarr;</DIV>
</DIV><P><A NAME="tuto7"></A>
\endhtmlonly

*/


/*!
\page tuto7 Read and write images

\htmlonly
 </P><P>After this step you should know how to:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
modify/initialize image values,
</LI><LI CLASS="li-itemize">copy and paste data to an image.
</LI></UL><P>
\endhtmlonly\see tuto3_rw_image.cc\htmlonly </P><P><BR>
<BR>
<BR>
<BR>
<BR>
<BR>

First create an empty color image with a <I>box2d</I> of 40x40 as domain.

\endhtmlonly

\include tuto3_rw_image-1.cc.raw

\htmlonly
 </P><P>If you want to initialize the image with the color red, simply call data::fill as follows:

\endhtmlonly

\include tuto3_rw_image-2.cc.raw

\htmlonly
 </P><P>Updating a site value is also possible using <I>operator()</I> or the
<I>opt::at()</I> routine. Here we create a blue square of 10x10 pixels from site
(20, 20) to (30, 30).

\endhtmlonly

\include tuto3_rw_image-3.cc.raw

\htmlonly
 

\endhtmlonly

\include tuto3_rw_image-4.cc.raw

\htmlonly
 </P><P>The corresponding image:<BR>


\endhtmlonly

\image html tuto3_rw_image-1.png

\htmlonly
 </P><P>An image can also be initialized/modified thanks to another image.
Let&rsquo;s load a new image.

\endhtmlonly

\include tuto3_rw_image-5.cc.raw

\htmlonly
 
<I>lena</I> looks like:<BR>


\endhtmlonly

\image html small-enlarged.png

\htmlonly
 </P><P>If we want to initialize <I>ima</I> with <I>lena</I>, we can use <I>data::fill</I>:

\endhtmlonly

\include tuto3_rw_image-6.cc.raw

\htmlonly
 
Output:<BR>


\endhtmlonly

\image html tuto3_rw_image-2.png

\htmlonly
<BR>
Note that to fill an image with some data, the image domain <B>must</B>
be smaller
or equal to the data.</P><P>Likewise, it is possible to paste data from an image to another:

\endhtmlonly

\include tuto3_rw_image-7.cc.raw

\htmlonly
 
Output:<BR>


\endhtmlonly

\image html tuto3_rw_image-3.png

\htmlonly
 </P><P>More details can be found in sections 
\endhtmlonly\ref imaaccessmodval\htmlonly , 
\endhtmlonly\ref fillop\htmlonly  and 
\endhtmlonly\ref pasteop\htmlonly  in
the reference guide.</P><P><BR>
<BR>
<BR>
<BR>
<BR>
<BR>

</P><DIV CLASS="center">
<DIV CLASS="center">&#X2190;&#X2014;&nbsp;Go to 
\endhtmlonly\ref tuto6\htmlonly  &nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp; Go to 
\endhtmlonly\ref tuto8\htmlonly &nbsp; &#X2014;&rarr;</DIV>
</DIV><P><A NAME="tuto8"></A>
\endhtmlonly

*/


/*!
\page tuto8 Regions of interest

\htmlonly
 </P><P>After this step you should know how to:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
take benefit of Olena&rsquo;s genericity,
</LI><LI CLASS="li-itemize">work only on a region of interest in an image.
</LI></UL><P>
\endhtmlonly\see tuto4_genericity_and_algorithms.cc\htmlonly 
<BR>
<BR>
<BR>
<BR>
<BR>
<BR>
</P><P>In the previous step, we used the routine <I>data::fill</I> in order to change
the values of an image. It was convenient since we did not need to write any
loop by hand. The problem was that we could not specify which region to fill
with data. This point leads us to talk about the genericity in Olena.
All along this example we will use the routine <I>data::fill</I> to illustrate
the possibilities in Olena but note that every image types passed to the
routine in this example could be passed to any algorithm in the library
expecting an image.</P><P>One main feature of Olena is to be able to easily work on regions of interest in
images. According to the way a region of interest is defined, a specific image
type is associated. Therefore, each algorithm knows exactly what it is working
on and can behave differently in order to be the most efficient as possible.</P><P>All along this step, we will use the following image <I>lena</I> declared as
follow:</P><P>
\endhtmlonly

\include tuto4_genericity_and_algorithms-1.cc.raw

\htmlonly
 

\endhtmlonly

\image html small-enlarged.png

\htmlonly
 </P><P><I>data::fill</I> has the following prototype:

\endhtmlonly

\include fill-proto.cc.raw

\htmlonly
 
So keep in mind that the first argument we will try to construct in each
example is an image. Note that this image <B>must</B>
be writable, e.g. non-const.</P><P><BR>
<BR>
<BR>

<A NAME="tuto4imadomainsiteset"></A>
\endhtmlonly

\section tuto4imadomainsiteset Image domain restricted by a site set

\htmlonly
 </P><P>Here, we would like to fill a small square with green in <I>lena</I>. We want
this square to be of size 20x20 and to be located at (20,20).
First, we just need to declare this square which is actually a site set, a
<I>box2d</I>.

\endhtmlonly

\include tuto4_genericity_and_algorithms-2.cc.raw

\htmlonly
 </P><P>Then, we just need to tell <I>data::fill</I> that we would like to fill the
image <I>lena</I> but only in this restricted part of the image domain.

\endhtmlonly

\include tuto4_genericity_and_algorithms-3.cc.raw

\htmlonly
 
Operator &rsquo;|&rsquo; can be read &rsquo;restricted to&rsquo;. So below, we wrote &rsquo;image <I>lena</I>
restricted to the region of interest <I>roi</I>&rsquo;. Actually this is not directly
<I>lena</I> which is restricted but its domain.</P><P>Note the use of <I>rw()</I> which is mandatory due to C++ limitations. In C++,
the image created by <I>lena | roi</I> is <I>const</I>, e.g. read-only, though
<I>data::fill</I> expect a <I>non-const</I> image, e.g. read-write. <I>rw()</I>
is a workaround to make it read-write.</P><DIV CLASS="center">
<TABLE CELLSPACING=6 CELLPADDING=0><TR><TD ALIGN=center NOWRAP> 
\endhtmlonly

\image html small-enlarged.png

\htmlonly
 </TD><TD ALIGN=center NOWRAP>&nbsp;<FONT SIZE=6>&rarr;&nbsp;</FONT></TD><TD ALIGN=center NOWRAP>
\endhtmlonly

\image html tuto4_genericity_and_algorithms-1.png

\htmlonly
</TD></TR>
<TR><TD ALIGN=center NOWRAP COLSPAN=3>Fill with blue a region of interest defined by a
<I>box2d</I>.</TD></TR>
</TABLE>
</DIV><P><BR>
<BR>
<BR>

<A NAME="tuto4imadomainfun"></A>
\endhtmlonly

\section tuto4imadomainfun Image domain restricted by a function

\htmlonly
 </P><P>Sometimes it may not be easy to construct a site set to restrict an image. For
instance, if we would like to fill with green one point out of two in the whole
image, we <B>do not want</B> to write anyloop or construct any site set by hand:

\endhtmlonly

\include tuto4_genericity_and_algorithms-4.cc.raw

\htmlonly
 

\endhtmlonly

\include tuto4_genericity_and_algorithms-5.cc.raw

\htmlonly
 </P><P>A shorter way to get exactly the same result, is to define that behavior by a
function. In Milena, a function <I>fun::p2b::chess</I> is available and does
exactly what we want. Like if it was a site set, simply restrict the image with
the function.</P><P>
\endhtmlonly

\include tuto4_genericity_and_algorithms-6.cc.raw

\htmlonly
 
</P><DIV CLASS="center">
<TABLE CELLSPACING=6 CELLPADDING=0><TR><TD ALIGN=center NOWRAP> 
\endhtmlonly

\image html small-enlarged.png

\htmlonly
 </TD><TD ALIGN=center NOWRAP>&nbsp;<FONT SIZE=6>&rarr;&nbsp;</FONT></TD><TD ALIGN=center NOWRAP>
\endhtmlonly

\image html tuto4_genericity_and_algorithms-2.png

\htmlonly
</TD></TR>
<TR><TD ALIGN=center NOWRAP COLSPAN=3>Fill with green a region of interest defined by a
<I>Function</I>.</TD></TR>
</TABLE>
</DIV><P>Note that the functions provided by default in Olena are actually functors.
Thus, they must be constructed like any object which why it is written
<I>lena | fun::p2v::chess()</I> and not <I>lena | fun::p2v::chess</I>.</P><P><BR>
<BR>
<BR>

<A NAME="tuto4imadomainmask"></A>
\endhtmlonly

\section tuto4imadomainmask Image domain restricted by a mask

\htmlonly
 </P><P>Sometimes instead of having a site site or a function defining the regions of
interest we want to work on, we may have a binary image, e.g. a mask. When a
site has its value set to true, it means it will be considered as part of the
masked image domain. Otherwise, it will not.</P><P>We construct a mask, <I>mask</I>. It is initialized with the same geometry properties as
<I>lena</I>
(domain, extension...).

\endhtmlonly

\include tuto4_genericity_and_algorithms-7.cc.raw

\htmlonly
 </P><P>Then, we cannot restrict directly <I>lena</I> with <I>mask</I>. These two images
have the same domain, so <I>lena | mask.domain()</I> would not do anything.
<I>mask</I> is a classical image, there is not specific type for mask images.
Therefore, we need to express that we want that binary image to be considered as
a mask.

\endhtmlonly

\include tuto4_genericity_and_algorithms-8.cc.raw

\htmlonly
 
<I>pw::value(mask)</I> makes explicit the fact that <I>mask</I> is actually a
mask. It means, that for each site of <I>mask</I>, if its value is set to
<I>true</I>, then the value associated to this site in <I>lena</I> must be set
to green.
In this example, we use two images for two different use case: <I>lena</I> store
the result and the modifications make by the algorithm and <I>mask</I> allows the
algorithm to know whether it must treat a site or not.</P><DIV CLASS="center">
<TABLE CELLSPACING=6 CELLPADDING=0><TR><TD ALIGN=center NOWRAP> 
\endhtmlonly

\image html small-enlarged.png

\htmlonly
 </TD><TD ALIGN=center NOWRAP> 
\endhtmlonly

\image html tuto4_genericity_and_algorithms-3.png

\htmlonly
 </TD><TD ALIGN=center NOWRAP> &nbsp;<FONT SIZE=6>&rarr;&nbsp;</FONT></TD><TD ALIGN=center NOWRAP> 
\endhtmlonly

\image html tuto4_genericity_and_algorithms-4.png

\htmlonly
</TD></TR>
<TR><TD ALIGN=center NOWRAP COLSPAN=4>Fill with green a region of interest defined by a mask
image.</TD></TR>
</TABLE>
</DIV><P><BR>
<BR>
<BR>

<A NAME="tuto4imadomainpredicate"></A>
\endhtmlonly

\section tuto4imadomainpredicate Image domain restricted by a predicate

\htmlonly
 </P><P>Restricting by a predicate is exactly like restricting with a function. We want
to talk about that separately in order to present the small routines available.
They enable the user to write quick and efficient predicate/function.</P><P>The two routines are :
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
pw::value(Image), as seen in a previous section, it is a way to express
&rsquo;for each site value in Image&rsquo;.
</LI><LI CLASS="li-itemize">pw::cst(Value), it is a way to specify a value to which a site value can
be compared.
</LI></UL><P>Let&rsquo;s see a common use case.
First, we binarize lena according to specific criterions, only site values with
specific colors are set to true in <I>lena_bw</I>. Others are set to false. This
image will be used in order to label the components.
Let&rsquo;s consider a labeled image <I>label</I>. Each component of <I>lena</I> is labeled with a unique index.
Now, we consider that that our region of interest is a component with id 16.
Then we want to express &rsquo;for each site <I>fill</I> its value in <I>lena</I> if its
value in <I>label</I> is equal to 16&rsquo;.

\endhtmlonly

\include tuto4_genericity_and_algorithms-9.cc.raw

\htmlonly
 </P><P>
\endhtmlonly

\include tuto4_genericity_and_algorithms-10.cc.raw

\htmlonly
 </P><DIV CLASS="center">
<TABLE CELLSPACING=6 CELLPADDING=0><TR><TD ALIGN=center NOWRAP> 
\endhtmlonly

\image html small-enlarged.png

\htmlonly
 </TD><TD ALIGN=center NOWRAP> 
\endhtmlonly

\image html tuto4_genericity_and_algorithms-5.png

\htmlonly
 </TD><TD ALIGN=center NOWRAP> &nbsp;<FONT SIZE=6>&rarr;&nbsp;</FONT></TD><TD ALIGN=center NOWRAP> 
\endhtmlonly

\image html tuto4_genericity_and_algorithms-6.png

\htmlonly
</TD></TR>
<TR><TD ALIGN=center NOWRAP COLSPAN=4>Fill with green a region of interest defined by its
label.</TD></TR>
</TABLE>
</DIV><P><BR>
<BR>
<BR>
<BR>
<BR>
<BR>

</P><DIV CLASS="center">
<DIV CLASS="center">&#X2190;&#X2014;&nbsp;Go to 
\endhtmlonly\ref tuto7\htmlonly  &nbsp;&nbsp;&nbsp;</DIV>
</DIV><!--CUT END -->
<!--HTMLFOOT-->
<!--ENDHTML-->
<!--FOOTER-->
<HR SIZE=2><BLOCKQUOTE CLASS="quote"><EM>This document was translated from L<sup>A</sup>T<sub>E</sub>X by
<A HREF="http://hevea.inria.fr/index.html">H<FONT SIZE=2><sup>E</sup></FONT>V<FONT SIZE=2><sup>E</sup></FONT>A</A>.</EM></BLOCKQUOTE></BODY>
</HTML>
\endhtmlonly */
