/*! 
\htmlonly
<!--HEVEA command line is: /usr/bin/hevea -fix -O -o ref-guide.html -I /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc/. -I /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc/outputs -I /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc/outputs/split -I /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc/img -I /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc/examples/split -I /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc /work/buildfarm/oln/oln_linux_gcc4_2/build/milena/doc/./ref-guide.tex -->
<!--CUT DEF chapter 1 --><P>
\endhtmlonly</P><P>\page quickref Quick Reference Guide
- \subpage installation
- \subpage foreword
- \subpage site
- \subpage siteset
- \subpage image
- \subpage winneigh
- \subpage sitesandco
- \subpage iterators
- \subpage imamemmgmt
- \subpage basicops
- \subpage inputoutput
- \subpage graphandima
- \subpage globalvars
- \subpage macros
- \subpage compilerrors
\htmlonly
</P><P><A NAME="installation"></A>
\endhtmlonly

*/


/*!
\page installation Installation

\htmlonly
 </P><P><BR>
<BR>
<BR>

<A NAME="requirements"></A>
\endhtmlonly

\section requirements Requirements

\htmlonly
 </P><P><A NAME="compexample"></A>
\endhtmlonly

\subsection compexample To compile the user examples

\htmlonly
 </P><UL CLASS="itemize"><LI CLASS="li-itemize">
a POSIX shell, like Bash
</LI><LI CLASS="li-itemize">a decent C++ compiler, like GNU C++
</LI><LI CLASS="li-itemize">a &#X2018;make&rsquo; utility, like GNU or BSD &#X2018;make&rsquo;
</LI></UL><P><A NAME="compdoc"></A>
\endhtmlonly

\subsection compdoc To compile the documentation (Optional)

\htmlonly
 </P><UL CLASS="itemize"><LI CLASS="li-itemize">
a LaTeX distribution
</LI><LI CLASS="li-itemize">the &#X2018;listings&rsquo; TeX package
</LI><LI CLASS="li-itemize">the utility &#X2018;convert&rsquo; from ImageMagick
</LI><LI CLASS="li-itemize">GNU Autogen
</LI><LI CLASS="li-itemize">&#X2018;hevea&rsquo;, a TeX to HTML conversion tool
</LI><LI CLASS="li-itemize">the &#X2018;texinfo&rsquo; utilities from GNU
</LI></UL><P><A NAME="devolena"></A>
\endhtmlonly

\subsection devolena To develop in Olena

\htmlonly
 
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
GNU Autotools (Autoconf 2.54, Automake 1.10)
</LI></UL><P><BR>
<BR>
<BR>

<A NAME="getolena"></A>
\endhtmlonly

\section getolena Getting Olena

\htmlonly
 </P><P>The latest version of Olena is available at the following addresses:</P><UL CLASS="itemize"><LI CLASS="li-itemize">
<A HREF="http://www.lrde.epita.fr/dload/olena/olena.tar.gz">http://www.lrde.epita.fr/dload/olena/olena.tar.gz</A>
</LI><LI CLASS="li-itemize"><A HREF="http://www.lrde.epita.fr/dload/olena/olena.tar.bz2">http://www.lrde.epita.fr/dload/olena/olena.tar.bz2</A>
</LI></UL><P><BR>
<BR>
<BR>

<A NAME="buildingolena"></A>
\endhtmlonly

\section buildingolena Building Olena

\htmlonly
 </P><P>First uncompress the archive. According to the downloaded archive, the options
are different.
</P><PRE CLASS="verbatim">$ tar zxvf olena.tar.gz
</PRE><P>Or
</P><PRE CLASS="verbatim">$ tar jxvf olena.tar.bz2
</PRE><P>Then follow these steps:
</P><PRE CLASS="verbatim">$ mkdir olena-build
$ cd olena-build
$ ../olena-1.0/configure &amp;&amp; make
$ sudo make install
</PRE><P><A NAME="foreword"></A>
\endhtmlonly

*/


/*!
\page foreword Foreword

\htmlonly
 </P><P><BR>
<BR>
<BR>

<A NAME="generality"></A>
\endhtmlonly

\section generality Generality

\htmlonly
 
The following tutorial explains the basic concepts behind Olena and how to use
the most common objects and routines.
This tutorial includes many code examples and figures. In order to make this
tutorial easier to understand, we will mainly talk about 2D images. This is
not so restrictive since 1D, 3D, <I>n</I>D images behave the same way.</P><P>Since examples are based on 2D images pixels are actually "points" however we
will call them "sites" which is the most generic name.<BR>
</P><P>Here is also a list of common variable name conventions:
</P><BLOCKQUOTE CLASS="figure"><DIV CLASS="center"><HR WIDTH="80%" SIZE=2></DIV>
<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD ALIGN=left NOWRAP> <B>Object</B></TD><TD ALIGN=left NOWRAP><B>Variable name</B></TD></TR>
<TR><TD ALIGN=left NOWRAP> Site</TD><TD ALIGN=left NOWRAP>p</TD></TR>
<TR><TD ALIGN=left NOWRAP> Value</TD><TD ALIGN=left NOWRAP>v</TD></TR>
<TR><TD ALIGN=left NOWRAP> Neighboor</TD><TD ALIGN=left NOWRAP>n</TD></TR>
<TR><TD ALIGN=left NOWRAP> A site close to another site p</TD><TD ALIGN=left NOWRAP>q</TD></TR>
</TABLE>
<DIV CLASS="center"><HR WIDTH="80%" SIZE=2></DIV></BLOCKQUOTE><P>Olena is organized in a namespace hierarchy. Everything is declared by Olena
within the &rsquo;mln::&rsquo; namespace, and possibly a sub-namespace such as
&rsquo;<I>mln::arith::</I>&rsquo; (arithmetic operations on images), &rsquo;<I>mln::morpho::</I>&rsquo; (morphological
operations), etc. Usually, the namespace hierarchy is mapped to the mln
directory tree. For the sake of simplicity, we will neglect the &rsquo;<I>mln::</I>&rsquo;
prefix in all the code examples.</P><P>Methods provided by objects in the library are in constant time. If you need
a specific method but you cannot find it, you may find an algorithm which can
compute the information you need.</P><P><BR>
<BR>
<BR>

<A NAME="dirtree"></A>
\endhtmlonly

\section dirtree Directory hierarchy

\htmlonly
 
Olena&rsquo;s tarball is structured as follow:</P><UL CLASS="itemize"><LI CLASS="li-itemize">
milena
<UL CLASS="itemize"><LI CLASS="li-itemize">
doc
	<UL CLASS="itemize"><LI CLASS="li-itemize">
	 benchmark: set of benchmark.
	 </LI><LI CLASS="li-itemize">examples: more examples.
	 </LI><LI CLASS="li-itemize">oldies: partialy not updated documentation. Not recommended for new users.
	 </LI><LI CLASS="li-itemize">technical: technical doc.
	 </LI><LI CLASS="li-itemize">tutorial: code sample and tutorial.
	</LI></UL>
</LI><LI CLASS="li-itemize">img: a set of sample images.
</LI><LI CLASS="li-itemize">mesh: a full example which uses Olena.
</LI><LI CLASS="li-itemize">mln: the library. Contains only headers.
</LI><LI CLASS="li-itemize">tests: test suite.
</LI></UL>
</LI><LI CLASS="li-itemize">swilena: Python bindings for Olena.
</LI></UL><P><BR>
<BR>
<BR>

<A NAME="compilehint"></A>
\endhtmlonly

\section compilehint Writing and compiling a program with Olena

\htmlonly
 </P><P>Before writing your first program, please be aware of these hints:</P><UL CLASS="itemize"><LI CLASS="li-itemize">
By default, Olena enables a lot of internal pre and post conditions.
Usually, this is a useful feature and it <B>should</B>
be enabled. However, it can heavily
slow down a program though so these tests can be disabled by compiling
using <I>-DNDEBUG</I>.
<PRE CLASS="verbatim">$ g++ -DNDEBUG -Ipath/to/mln my_program.cc
  </PRE></LI><LI CLASS="li-itemize">If you decide to use optimization flags to compile for debugging,
prefer using <I>-O1</I>. It is much faster to compile and it gives good
performance results.</LI></UL><P><A NAME="site"></A>
\endhtmlonly

*/


/*!
\page site Site

\htmlonly
 </P><P>Usually, when talking about images, we think about common images composed of a
set of pixels.
Since Olena is generic, we want to support many kind of images, even images
which are not composed of a set of points, such as images having images as sites.</P><P>In order to express this genericity, we have the &ldquo;site&rdquo; concept.
This concept allows us to divide a pixel into two information:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
The pixel location, e.g. its coordinates (the site itself).
</LI><LI CLASS="li-itemize">The value.
</LI></UL><P>Let&rsquo;s say we have a 2D grid like this:</P><P>On such a regular grid, in 2D, we usually use a 2D point as a site which
means we have the following equivalence:</P><DIV CLASS="center">
Intersection &equiv; point2d (2D site) &equiv; center of a pixel
</DIV><P>The site does not store any value but refers to an area where we will be able
to read its value.</P><P>Sites may have a different types, depending on the image type:</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD ALIGN=left NOWRAP>Name</TD><TD ALIGN=left NOWRAP>Description</TD></TR>
<TR><TD ALIGN=left NOWRAP><I>point2d</I></TD><TD ALIGN=left NOWRAP>2D point on a regular grid</TD></TR>
<TR><TD ALIGN=left NOWRAP><I>point</I></TD><TD ALIGN=left NOWRAP>Generic point (<I>n</I>D) on a regular grid</TD></TR>
<TR><TD ALIGN=left NOWRAP><I>algebra::vec</I></TD><TD ALIGN=left NOWRAP>Algebraic vector</TD></TR>
<TR><TD ALIGN=left NOWRAP><I>util::vertex</I></TD><TD ALIGN=left NOWRAP>Graph vertex</TD></TR>
<TR><TD ALIGN=left NOWRAP><I>util::edge</I></TD><TD ALIGN=left NOWRAP>Graph edge</TD></TR>
</TABLE><P><A NAME="siteset"></A>
\endhtmlonly

*/


/*!
\page siteset Site set

\htmlonly
 </P><P>Site sets are used:
</P><OL CLASS="enumerate" type=1><LI CLASS="li-enumerate">
To define an image definition domain.
</LI><LI CLASS="li-enumerate">As Site container.
</LI></OL><P>They do not actually store any image value. They only store site information.</P><P>Here is a list of all the site set concepts which can be found in
core/site_set:</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Site set</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
p_array</TD><TD VALIGN=top ALIGN=left>site array.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>p_box	</TD><TD VALIGN=top ALIGN=left>compact domain defined on a regular grid (in 2D, a rectangle).</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>p_if	</TD><TD VALIGN=top ALIGN=left>site set verifying a predicate.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>p_queue</TD><TD VALIGN=top ALIGN=left>site queue.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>p_run	</TD><TD VALIGN=top ALIGN=left>site range.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>p_runs	</TD><TD VALIGN=top ALIGN=left>site range set.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>p_set	</TD><TD VALIGN=top ALIGN=left>mathematical site set.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>p_vaccess</TD><TD VALIGN=top ALIGN=left>site set ordered by value.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>p_edges</TD><TD VALIGN=top ALIGN=left>set of graph edges associated to sites.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>p_vertices</TD><TD VALIGN=top ALIGN=left>set of graph vertices associated to sites.</TD></TR>
</TABLE><P>All site sets are iterable. More detailed explanations are available in section 
\endhtmlonly\ref iterators\htmlonly .</P><P><BR>
<BR>
<BR>

<A NAME="sitesetinterface"></A>
\endhtmlonly

\section sitesetinterface Basic interface

\htmlonly
 
Common basic interface:<BR>

</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Return Type</TD><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left NOWRAP>Arguments</TD><TD VALIGN=top ALIGN=left NOWRAP>Const</TD><TD VALIGN=top ALIGN=left>Comments</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
bool</TD><TD VALIGN=top ALIGN=left NOWRAP>is_valid</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left NOWRAP>X</TD><TD VALIGN=top ALIGN=left>Returns true if it has been initialized. The
default constructor does not initialize it.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
bool</TD><TD VALIGN=top ALIGN=left NOWRAP>has</TD><TD VALIGN=top ALIGN=left NOWRAP>const P&amp; p</TD><TD VALIGN=top ALIGN=left NOWRAP>X</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
</TABLE><P><BR>
</P><P><BR>
<BR>
<BR>

<A NAME="sitesetopinterface"></A>
\endhtmlonly

\section sitesetopinterface Optional interface

\htmlonly
 
Site sets may have other methods depending on their type:<BR>

</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Return Type</TD><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left NOWRAP>Arguments</TD><TD VALIGN=top ALIGN=left NOWRAP>Const</TD><TD VALIGN=top ALIGN=left>Comments</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
size_t</TD><TD VALIGN=top ALIGN=left NOWRAP>nsites</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left>Return the number of sites.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>const Box&amp;</TD><TD VALIGN=top ALIGN=left NOWRAP>bbox</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left NOWRAP>X</TD><TD VALIGN=top ALIGN=left>Bounding box. Available only on grid site sets.</TD></TR>
</TABLE><P><BR>

The previous methods are available depending on the site set. A box
will have the bbox() method since it can be retrived in constant time: a box
is it&rsquo;s own bounding box.</P><P>
\endhtmlonly

\include box2d-bbox-1.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include box2d-bbox.txt

\htmlonly
 </P><P>A <I>p_array</I> does not have the bbox
method since its sites do not have to be adjacent. Maintaining such information, in
order to keep getting the bbox in constant time, would be time and memory
consuming. Instead of providing a method directly in <I>p_array</I>, an algorithm is
available if this information is needed.
<I>p_array</I> and <I>box</I> both have a nsites method since the internal structure allows a
constant time retrieval.</P><P>
\endhtmlonly

\include parray-bbox-1.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include parray-bbox.txt

\htmlonly
 </P><P><A NAME="image"></A>
\endhtmlonly

*/


/*!
\page image Image

\htmlonly
 </P><P><BR>
<BR>
<BR>

<A NAME="definition"></A>
\endhtmlonly

\section definition Definition

\htmlonly
 
An image is composed both of:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
A function

<TABLE CLASS="display dcenter"><TR VALIGN="middle"><TD CLASS="dcell">
<I>ima</I>&nbsp;:&nbsp;</TD><TD CLASS="dcell">&#X23A7;<BR>
&#X23A8;<BR>
&#X23A9;</TD><TD CLASS="dcell"><TABLE CELLSPACING=6 CELLPADDING=0><TR><TD ALIGN=left NOWRAP>&nbsp;&nbsp;&nbsp;&nbsp;<I>Site</I></TD><TD ALIGN=left NOWRAP>&rarr;</TD><TD ALIGN=left NOWRAP><I>Value</I>&nbsp;</TD></TR>
<TR><TD ALIGN=left NOWRAP>&nbsp;&nbsp;&nbsp;&nbsp;<I>p</I></TD><TD ALIGN=left NOWRAP>&map;</TD><TD ALIGN=left NOWRAP><I>ima</I>(<I>p</I>)</TD></TR>
</TABLE></TD><TD CLASS="dcell">
</TD></TR>
</TABLE>

</LI><LI CLASS="li-itemize">A site set, also called the "domain".
</LI></UL><P><BR>
<BR>
<BR>

<A NAME="imatypes"></A>
\endhtmlonly

\section imatypes Possible image types

\htmlonly
 </P><P>Here is a short list of the main/usual image types you may want to use with
Olena:<BR>
<BR>
<BR>
</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD ALIGN=left NOWRAP>Name</TD><TD ALIGN=left NOWRAP>Description</TD></TR>
<TR><TD ALIGN=left NOWRAP><I>image1d</I></TD><TD ALIGN=left NOWRAP>1D image</TD></TR>
<TR><TD ALIGN=left NOWRAP><I>image2d</I></TD><TD ALIGN=left NOWRAP>2D image</TD></TR>
<TR><TD ALIGN=left NOWRAP><I>image3d</I></TD><TD ALIGN=left NOWRAP>3D image</TD></TR>
<TR><TD ALIGN=left NOWRAP><I>flat_image</I></TD><TD ALIGN=left NOWRAP>Constant value image</TD></TR>
<TR><TD ALIGN=left NOWRAP><I>image_if</I></TD><TD ALIGN=left NOWRAP>Image defined by a function</TD></TR>
</TABLE><P><BR>
<BR>
<BR>

<A NAME="imapossvalues"></A>
\endhtmlonly

\section imapossvalues Possible value types

\htmlonly
 </P><P>Every image type <B>must</B>
take its type of value as parameter.
The value type can be one of the builtins one:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
<I>bool</I>
</LI><LI CLASS="li-itemize"><I>char</I>
</LI><LI CLASS="li-itemize"><I>unsigned</I>
</LI><LI CLASS="li-itemize"><I>int</I>
</LI><LI CLASS="li-itemize"><I>short</I>
</LI><LI CLASS="li-itemize"><I>long</I>
</LI><LI CLASS="li-itemize"><I>float</I>
</LI><LI CLASS="li-itemize"><I>double</I>
</LI></UL><P>Other data types are also available:</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD ALIGN=left NOWRAP>Value type</TD><TD ALIGN=left NOWRAP>underlying data type</TD></TR>
<TR><TD ALIGN=left NOWRAP><I>float01_8</I></TD><TD ALIGN=left NOWRAP><I>unsigned long</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>float01_16</I></TD><TD ALIGN=left NOWRAP><I>unsigned long</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>float01_f</I></TD><TD ALIGN=left NOWRAP><I>float</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>gl8</I></TD><TD ALIGN=left NOWRAP><I>unsigned char</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>gl16</I></TD><TD ALIGN=left NOWRAP><I>unsigned short</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>glf</I></TD><TD ALIGN=left NOWRAP><I>float</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>hsi_d</I></TD><TD ALIGN=left NOWRAP><I>double</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>hsi_f</I></TD><TD ALIGN=left NOWRAP><I>float</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>int_s8</I></TD><TD ALIGN=left NOWRAP><I>char</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>int_s16</I></TD><TD ALIGN=left NOWRAP><I>short</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>int_s32</I></TD><TD ALIGN=left NOWRAP><I>int</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>int_u8</I></TD><TD ALIGN=left NOWRAP><I>unsigned char</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>int_u16</I></TD><TD ALIGN=left NOWRAP><I>unsigned short</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>int_u32</I></TD><TD ALIGN=left NOWRAP><I>unsigned int</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>rgb16</I></TD><TD ALIGN=left NOWRAP><I>mln::algebra::vec&lt;unsigned short&gt;</I></TD></TR>
<TR><TD ALIGN=left NOWRAP><I>rgb8</I></TD><TD ALIGN=left NOWRAP><I>mln::algebra::vec&lt;unsigned char&gt;</I></TD></TR>
</TABLE><P><BR>
</P><P>All these types are available in mln/value and accessible in the
<I>mln::value</I> namespace.
Most of the time, the name of the header which <B>must</B>
be included to use one of these data
types is actually &ldquo;type_name.hh". For instance, for <I>rgb8</I> the header will be
<I>rgb8.hh</I>.</P><P><BR>
<BR>
<BR>

<A NAME="imadomain"></A>
\endhtmlonly

\section imadomain Domain

\htmlonly
 
The site set contains the sites which compose the image. Sites are based on a
grid so the image depends on that grid as well.
It means that a 2D images can only be defined by sites based on a 2D grid.
Likewise, an <I>image2d</I> will always have its bouding box defined by a <I>box2d</I>.</P><P>Being defined on a grid means that the image can be defined anywhere.
For instance, defining a 2D image with a <I>box2d</I> starting from point (-20, -20)
to (-3, 5) is completely valid.</P><P>The following example shows that the definition domain and the site set are
exactly equivalent.</P><P>
\endhtmlonly

\include ima2d-1-1.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include ima2d-1.txt

\htmlonly
 </P><P>To know if a site belongs to an image domain or not, a method &ldquo;<I>has()</I>&rdquo; is
available.

\endhtmlonly

\include point-1-1.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include point-1.txt

\htmlonly
 </P><P>Since the notion of site is independent from the image it applies on, we can
form expressions where a site passed to several images:

\endhtmlonly

\include ima2d-4-1.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include ima2d-4.txt

\htmlonly
 </P><P><BR>
<BR>
<BR>

<A NAME="imaborder"></A>
\endhtmlonly

\section imaborder Border and extension

\htmlonly
 
Olena provides extension mechanisms for the
image domain. In the library, both the concept of border and of extension can be encountered.
These concepts are useful in many algorithms and can avoid costly tests while
working with sites located on image edges.</P><P><A NAME="imabordersection"></A>
\endhtmlonly

\subsection imabordersection Image border

\htmlonly
 </P><P>A border is a finite extension provided to a basic image type, such as
<I>image2d</I>. By default, every image is created with a border. The default width is
defined through the global variable <I>border::thickness</I> defined in
<I>mln/border/thickness.hh</I>. Since this is a variable, it can be changed
as shown in the following example.</P><P>
\endhtmlonly

\include borderthickness-1.cc.raw

\htmlonly
 </P><P>Output:</P><P>
\endhtmlonly

\include borderthickness.txt

\htmlonly
 </P><P>It is important to note that to display the border in the ouput, we use a
special debug function, <I>debug::println_with_border</I>. Indeed, the border and the
extension are considered as part of an image only in the algorithms. They are
ignored while saving or printing an image.</P><P>Some operations can be performed on the border. The functions are located in
<I>mln/border</I>.<BR>

<BR>
<BR>
</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Routine</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>adjust</TD><TD VALIGN=top ALIGN=left>Increase the border thickness if it is inferior to a minimum.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>duplicate</TD><TD VALIGN=top ALIGN=left>Assign the border with the duplicate of the edges of this image.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>equalize</TD><TD VALIGN=top ALIGN=left>Equalize the border of two images so that their size is equal and is
at least a minimum size.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>fill</TD><TD VALIGN=top ALIGN=left>Fill the border with a given value.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>find</TD><TD VALIGN=top ALIGN=left>Find the border thickness of an image.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>get</TD><TD VALIGN=top ALIGN=left>Get the border thickness of an image.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>mirror</TD><TD VALIGN=top ALIGN=left>Fills border using nearer pixels with a mirroring effect.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>resize</TD><TD VALIGN=top ALIGN=left>Set image border to a specific size.</TD></TR>
</TABLE><P><BR>
</P><P><A NAME="imextgeneral"></A>
\endhtmlonly

\subsection imextgeneral Generality on image extension

\htmlonly
 </P><P>On morphed images, described in section 
\endhtmlonly\ref imamorphed\htmlonly , the border concept
does not exist and is generalized to the extension concept.
A simple example of a morphed image is a sub-image. A sub image does not have
border nor extension by default.
Thanks to <I>mln/core/routine/extend.hh</I>, an extension can be defined through a
function. This means that the extension can be infinite.
Another point is that an image can be used as extension. For instance, in the
case of a sub-image, you may be interested in extending the sub-image with the
image itself.</P><P>The extension supports the following operations. These functions are located in
<I>mln/extension</I>.<BR>

<BR>
<BR>
</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Routine</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>adjust</TD><TD VALIGN=top ALIGN=left>Adjust the extension given a structural element.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>adjust_duplicate</TD><TD VALIGN=top ALIGN=left>Adjust the size of the extension given a structural element and duplicate the image inner boundary.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>adjust_fill</TD><TD VALIGN=top ALIGN=left>Adjust the size of the extension given a structural element and fill it with a value.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>duplicate</TD><TD VALIGN=top ALIGN=left>Duplicate the values of the image inner boundary in the extension.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>fill</TD><TD VALIGN=top ALIGN=left>Fill the extension with a given value.</TD></TR>
</TABLE><P><BR>
</P><P>In order to extend an image, a routine <I>extend</I> is available in
<I>mln/core/routine/extend.hh</I>. The routine <I>extended_to</I> may
also help during debug. It allows to extend the image domain to a larger
one. The values associated to the new sites comes from the extension.</P><P><A NAME="extexample"></A>
\endhtmlonly

\subsection extexample Different extensions

\htmlonly
 </P><P>Let&rsquo;s say we have want to extract a sub domain from an image. In the following
example, <I>ima_roi</I> holds several small rectangles from the original image.

\endhtmlonly

\include extend-2.cc.raw

\htmlonly
 </P><DIV CLASS="center">
<TABLE CELLSPACING=6 CELLPADDING=0><TR><TD ALIGN=center NOWRAP> 
\endhtmlonly

\image html small-enlarged.png

\htmlonly
 </TD><TD ALIGN=center NOWRAP>&nbsp;<FONT SIZE=6>&rarr;&nbsp;</FONT></TD><TD ALIGN=center NOWRAP>
\endhtmlonly

\image html extend-1.png

\htmlonly
</TD></TR>
<TR><TD ALIGN=center NOWRAP> <I>lena</I></TD><TD ALIGN=center NOWRAP>&nbsp;</TD><TD ALIGN=center NOWRAP><I>ima_roi</I> (black color means the sites are not included in the domain)</TD></TR>
</TABLE>
</DIV><P>Then, we may extend this sub image with one of the three following extension type.</P><P><A NAME="extval"></A>
\endhtmlonly

\subsubsection extval Extension with a value

\htmlonly
 </P><P>Let&rsquo;s extend with the value <I>literal::blue</I>.

\endhtmlonly

\include extend-3.cc.raw

\htmlonly
 

\endhtmlonly

\image html extend-2.png

\htmlonly
 </P><P>Note the use of the <I>extended_to()</I> routine. We used a larger bbox to
extend the image domain. That is the reason why the image is surrounded by the
extension value, blue.</P><P><A NAME="extfun"></A>
\endhtmlonly

\subsubsection extfun Extension with a function

\htmlonly
 </P><P>Let&rsquo;s use the following function:

\endhtmlonly

\include extend-1.cc.raw

\htmlonly
 

\endhtmlonly

\include extend-4.cc.raw

\htmlonly
 

\endhtmlonly

\image html extend-3.png

\htmlonly
 </P><P><A NAME="extima"></A>
\endhtmlonly

\subsubsection extima Extension with an image

\htmlonly
 </P><P>Let&rsquo;s extend with the original image, <I>lena</I>.

\endhtmlonly

\include extend-5.cc.raw

\htmlonly
 </P><DIV CLASS="center">
<TABLE CELLSPACING=6 CELLPADDING=0><TR><TD ALIGN=center NOWRAP> 
\endhtmlonly

\image html extend-4.png

\htmlonly
 </TD><TD ALIGN=center NOWRAP>
\endhtmlonly

\image html extend-5.png

\htmlonly
</TD></TR>
<TR><TD ALIGN=center NOWRAP> <I>ext_with_ima</I>, the extended image.</TD><TD ALIGN=center NOWRAP>The actual data in the domain (light) with its extension (dark)</TD></TR>
</TABLE>
</DIV><!--TOC subsection IMPORTANT NOTE-->
<H3 CLASS="subsection"><!--SEC ANCHOR -->IMPORTANT NOTE</H3><!--SEC END --><P>
Many times, you may want to check if a site is part of the image before applying
a treatment. All images provide a method &ldquo;<I>has(Site)</I>&rdquo; which can return this
information.
<B>Be careful though, calling <I>has()</I> on the image returns &ldquo;true&rdquo; if
the given site is part of the domain OR the the extension/border</B>. All
algorithms in Olena call that method which means that all the algorithms take
in consideration the extension/border if it exists. The default border
thickness is set to 3 as shown by the following example.</P><P>
\endhtmlonly

\include ima-has-1.cc.raw

\htmlonly
 </P><P>Output:</P><P>
\endhtmlonly

\include ima-has.txt

\htmlonly
 </P><P>Most of the time, this is the good behavior. For instance, if a rotation
is applied to an image, sites which were not previously in the domain
will be part of it. Thanks to the extension/border, these sites will be
associated to the value of the extension/border.</P><P>In the following example, the extension is set to a constant color <I>yellow</I>.
It means that whatever the new sites computed through the rotation, it will be
part of the image and a value will be available. Site which were previously in
the extension/border, will be associated to <I>yellow</I> in the output image.</P><P>
\endhtmlonly

\include ima2d-rot-1.cc.raw

\htmlonly
 </P><P>Output:</P><P><BR>
<BR>
</P><TABLE CELLSPACING=6 CELLPADDING=0><TR><TD ALIGN=center NOWRAP>
\endhtmlonly

\image html ima2d-rot-1.png

\htmlonly
 </TD><TD ALIGN=center NOWRAP>
\endhtmlonly

\image html ima2d-rot-2.png

\htmlonly
</TD></TR>
<TR><TD ALIGN=center NOWRAP COLSPAN=2><I>ima1</I> and its border before rotation (left) and <I>ima2</I>
and its border after rotation (right).</TD></TR>
</TABLE><P><BR>
<BR>
</P><P>Sometimes taking the domain in consideration may not be the expected behavior.
If you do not want to use the extension/border for a specific routine, simply
restrict the image to its domain.</P><P>
\endhtmlonly

\include extension-ignore-1.cc.raw

\htmlonly
 </P><P>Note that:
</P><DIV CLASS="center">
<I>ima.domain().has()</I> &equiv; <I>(ima | ima.domain()).has()</I>
</DIV><P><BR>
<BR>
<BR>

<A NAME="imainterface"></A>
\endhtmlonly

\section imainterface Interface

\htmlonly
 </P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Return Type</TD><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left NOWRAP>Arguments</TD><TD VALIGN=top ALIGN=left NOWRAP>Const</TD><TD VALIGN=top ALIGN=left>Comments</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
I::pvset</TD><TD VALIGN=top ALIGN=left NOWRAP>domain</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left NOWRAP>X</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>const Value&amp;</TD><TD VALIGN=top ALIGN=left NOWRAP>operator()</TD><TD VALIGN=top ALIGN=left NOWRAP>const point&amp; p</TD><TD VALIGN=top ALIGN=left NOWRAP>X</TD><TD VALIGN=top ALIGN=left>Used for reading.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>Value&amp;</TD><TD VALIGN=top ALIGN=left NOWRAP>operator()</TD><TD VALIGN=top ALIGN=left NOWRAP>const point&amp; p</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left>Used for writing.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>bool</TD><TD VALIGN=top ALIGN=left NOWRAP>has</TD><TD VALIGN=top ALIGN=left NOWRAP>const Point&amp; p</TD><TD VALIGN=top ALIGN=left NOWRAP>X</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>bool</TD><TD VALIGN=top ALIGN=left NOWRAP>has_data</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left NOWRAP>X</TD><TD VALIGN=top ALIGN=left>Returns true if the domain is defined.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>site_id</TD><TD VALIGN=top ALIGN=left NOWRAP>id</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left NOWRAP>X</TD><TD VALIGN=top ALIGN=left>Return the Id of the underlying shared data.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>I::vset</TD><TD VALIGN=top ALIGN=left NOWRAP>destination</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left NOWRAP>X</TD><TD VALIGN=top ALIGN=left>Value set of all the possible site values in this
Image.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>site_set</TD><TD VALIGN=top ALIGN=left NOWRAP>bbox</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left>Returns the bounding box of the domain.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>site_set</TD><TD VALIGN=top ALIGN=left NOWRAP>bbox_large</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left>Returns the bouding box of the domain and the
extended domain.</TD></TR>
</TABLE><P><BR>
<BR>
<BR>

<A NAME="imaio"></A>
\endhtmlonly

\section imaio Load and save images

\htmlonly
 </P><P>Currently, Olena supports the following input image formats:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
PBM
</LI><LI CLASS="li-itemize">PFM
</LI><LI CLASS="li-itemize">PGM
</LI><LI CLASS="li-itemize">PNM
</LI><LI CLASS="li-itemize">PPM
</LI></UL><P>This support is provided through two headers for each type, <I>save.hh</I> and
<I>load.hh</I>.
They are located in <I>mln/io/&lt;image-format&gt;/</I>.</P><P>Once the right header is included, the image can be loaded:</P><P>
\endhtmlonly

\include ima-load-1.cc.raw

\htmlonly
 </P><P>Note that each format is associated to specific image value types:</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD ALIGN=left NOWRAP>&nbsp;</TD></TR>
<TR><TD ALIGN=left NOWRAP>hline
Format</TD><TD ALIGN=left NOWRAP>Value type</TD></TR>
<TR><TD ALIGN=left NOWRAP>PBM</TD><TD ALIGN=left NOWRAP>bool</TD></TR>
<TR><TD ALIGN=left NOWRAP>PFM</TD><TD ALIGN=left NOWRAP>float, double, float01_*</TD></TR>
<TR><TD ALIGN=left NOWRAP>PGM</TD><TD ALIGN=left NOWRAP>unsigned, long, int, int_u*, gl*</TD></TR>
<TR><TD ALIGN=left NOWRAP>PNM</TD><TD ALIGN=left NOWRAP>See PGM, PBM and PPM</TD></TR>
<TR><TD ALIGN=left NOWRAP>PPM</TD><TD ALIGN=left NOWRAP>rgb*</TD></TR>
</TABLE><P>
\endhtmlonly

\include ima-save-1.cc.raw

\htmlonly
 
</P><P><BR>
<BR>
<BR>

<A NAME="imacreate"></A>
\endhtmlonly

\section imacreate Create an image

\htmlonly
 </P><P>Loading an image is not mandatory, an image can be created from scratch. There
are two possibilites to do so:</P><P>
\endhtmlonly

\include ima2d-2-1.cc.raw

\htmlonly
 </P><P><I>img1a</I> has no data and its definition domain is still unset. We do
not know yet the number of sites it contains. However, it is really useful to
have such an "empty image" because it is a placeholder for the result of some
processing, or another image. Trying to access the site value from an empty
image leads to an error at run-time.
<I>img1b</I> is defined on a domain but does not have data yet.<BR>

An image can also be created and initialized at the same time:

\endhtmlonly

\include labeling-compute-1.cc.raw

\htmlonly
 
It constructs the following image:<BR>
</P><DIV CLASS="center">

\endhtmlonly

\image html labeling-compute-1.png

\htmlonly
 
</DIV><P>Sometimes, you may want to initialize an image from another one:

\endhtmlonly

\include ima2d-7-1.cc.raw

\htmlonly
 
<I>img2b</I> is declared without specifying a domain. Its border size is set to
the default one, e.g 0. By using <I>initialize()</I>, <I>img2b</I> is initialized
with the same domain and border/extension as <I>img2a</I>. The data is not
copied though. Other routines like <I>data::fill()</I> can be called in order to
do so (See also 
\endhtmlonly\ref fillop\htmlonly ).</P><P><BR>
<BR>
<BR>

<A NAME="imaaccessmodval"></A>
\endhtmlonly

\section imaaccessmodval Access and modify values

\htmlonly
 </P><P>There are several ways to access/modify an image &ldquo;<I>ima</I>&rdquo;:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
<I>opt::at(ima, x, y, &#X2026;)</I>
</LI><LI CLASS="li-itemize"><I>ima(Site)</I>
</LI></UL><P>Most of the time, images can be modified and these two methods can be used both
to read a value and modify it. Both methods are equivalent.

\endhtmlonly

\include ima2d-3-1.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include ima2d-3.txt

\htmlonly
 </P><P>Usually, you will want to use the functional way, &ldquo;<I>ima(Site)</I>&rdquo;, more
particularly while iterating over all the sites through an iterator. This use
case will be detailed further in section 
\endhtmlonly\ref iterators\htmlonly .</P><P><BR>
<BR>
<BR>

<A NAME="imasize"></A>
\endhtmlonly

\section imasize Image size

\htmlonly
 
Most typical image types owns special methods to retrieve the image size.</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD ALIGN=left NOWRAP>Image type</TD><TD ALIGN=left NOWRAP>Methods</TD></TR>
<TR><TD ALIGN=left NOWRAP>image1d</TD><TD ALIGN=left NOWRAP>length()</TD></TR>
<TR><TD ALIGN=left NOWRAP>image2d</TD><TD ALIGN=left NOWRAP>ncols(), nrows()</TD></TR>
<TR><TD ALIGN=left NOWRAP>image3d</TD><TD ALIGN=left NOWRAP>ncols(), nrows(), nslis()</TD></TR>
</TABLE><P>If you need a more generic way to get the size, you can use the routines
provided in <I>mln/geom</I> in the following files:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
<I>ncols.hh</I>
</LI><LI CLASS="li-itemize"><I>nrows.hh</I>
</LI><LI CLASS="li-itemize"><I>nslis.hh</I>
</LI></UL><P>
\endhtmlonly

\include ima-size-1.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include ima-size.txt

\htmlonly
 </P><P><A NAME="winneigh"></A>
\endhtmlonly

*/


/*!
\page winneigh Structural elements: Window and neighborhood

\htmlonly
 </P><P>In Olena, there are both the window and neighborhood concept. A window can be
defined on any site around a central site which may also be included.
A neighborhood is more restrictive and <B>must</B>
not include the central site.
Therefore these two concepts are really similar and are detailed together in
this section.</P><P>By default, structural elements are centered. The central site is located at the
origin of the grid: &ldquo;<I>literal::origin</I>&rdquo;. With <I>image2d</I>, the central site is
(0,0). Centered structural elements <B>must</B>
have an odd size.</P><P><BR>
<BR>
<BR>

<A NAME="sedef"></A>
\endhtmlonly

\section sedef Define an element

\htmlonly
 </P><P><A NAME="winwin"></A>
\endhtmlonly

\subsection winwin Window

\htmlonly
 </P><!--TOC subsubsection Generic Predefined windows-->
<H4 CLASS="subsubsection"><!--SEC ANCHOR -->Generic Predefined windows</H4><!--SEC END --><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD ALIGN=left NOWRAP>Name</TD><TD ALIGN=left NOWRAP>Description</TD><TD ALIGN=left NOWRAP>Representation</TD></TR>
<TR><TD ALIGN=left NOWRAP>win_c4p</TD><TD ALIGN=left NOWRAP>4-connectivity</TD><TD ALIGN=left NOWRAP>&nbsp;</TD></TR>
<TR><TD ALIGN=left NOWRAP>win_c8p</TD><TD ALIGN=left NOWRAP>8-connectivity</TD><TD ALIGN=left NOWRAP>&nbsp;</TD></TR>
</TABLE><P>
<BR>
<BR>
</P><!--TOC subsubsection 1D Predefined windows-->
<H4 CLASS="subsubsection"><!--SEC ANCHOR -->1D Predefined windows</H4><!--SEC END --><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD ALIGN=left NOWRAP>Name</TD><TD ALIGN=left NOWRAP>Description</TD><TD ALIGN=left NOWRAP>Representation</TD></TR>
<TR><TD ALIGN=left NOWRAP>segment1d</TD><TD ALIGN=left NOWRAP>1D segment</TD><TD ALIGN=left NOWRAP>-</TD></TR>
</TABLE><P>
<BR>
<BR>
</P><!--TOC subsubsection 2D Predefined windows-->
<H4 CLASS="subsubsection"><!--SEC ANCHOR -->2D Predefined windows</H4><!--SEC END --><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD ALIGN=left NOWRAP>Name</TD><TD ALIGN=left NOWRAP>Description</TD><TD ALIGN=left NOWRAP>Representation</TD></TR>
<TR><TD ALIGN=left NOWRAP>backdiag2d</TD><TD ALIGN=left NOWRAP>Back diagonal</TD><TD ALIGN=left NOWRAP>-</TD></TR>
<TR><TD ALIGN=left NOWRAP>diag2d</TD><TD ALIGN=left NOWRAP>2D diagonal</TD><TD ALIGN=left NOWRAP>-</TD></TR>
<TR><TD ALIGN=left NOWRAP>disk2d</TD><TD ALIGN=left NOWRAP>2D disk</TD><TD ALIGN=left NOWRAP>-</TD></TR>
<TR><TD ALIGN=left NOWRAP>hline2d</TD><TD ALIGN=left NOWRAP>2D horizontal line</TD><TD ALIGN=left NOWRAP>-</TD></TR>
<TR><TD ALIGN=left NOWRAP>octagon2d</TD><TD ALIGN=left NOWRAP>2D octogon</TD><TD ALIGN=left NOWRAP>-</TD></TR>
<TR><TD ALIGN=left NOWRAP>rectangle2d</TD><TD ALIGN=left NOWRAP>2D rectangle</TD><TD ALIGN=left NOWRAP>-</TD></TR>
<TR><TD ALIGN=left NOWRAP>vline2d</TD><TD ALIGN=left NOWRAP>2D vertical line</TD><TD ALIGN=left NOWRAP>-</TD></TR>
</TABLE><P>
<BR>
<BR>
</P><!--TOC subsubsection 3D Predefined windows-->
<H4 CLASS="subsubsection"><!--SEC ANCHOR -->3D Predefined windows</H4><!--SEC END --><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD ALIGN=left NOWRAP>Name</TD><TD ALIGN=left NOWRAP>Description</TD><TD ALIGN=left NOWRAP>Representation</TD></TR>
<TR><TD ALIGN=left NOWRAP>cube3d</TD><TD ALIGN=left NOWRAP>3D Cube</TD><TD ALIGN=left NOWRAP>-</TD></TR>
<TR><TD ALIGN=left NOWRAP>cuboid3d</TD><TD ALIGN=left NOWRAP>Cuboid</TD><TD ALIGN=left NOWRAP>-</TD></TR>
</TABLE><P>These predefined windows can be passed directly to a function. The headers are
located in <I>mln/core/alias/window*.hh</I>.</P><P><A NAME="neighborhood"></A>
\endhtmlonly

\subsection neighborhood Neighborhood

\htmlonly
 </P><P>Predefined neighborhood:<BR>

</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD ALIGN=left NOWRAP>Name</TD><TD ALIGN=left NOWRAP>Description</TD><TD ALIGN=left NOWRAP>Representation</TD></TR>
<TR><TD ALIGN=left NOWRAP>c4</TD><TD ALIGN=left NOWRAP>4-connectivity</TD><TD ALIGN=left NOWRAP>&nbsp;</TD></TR>
<TR><TD ALIGN=left NOWRAP>c8</TD><TD ALIGN=left NOWRAP>8-connectivity</TD><TD ALIGN=left NOWRAP>&nbsp;</TD></TR>
</TABLE><P>These predefined neighborhood can be passed directly to a function. The headers are
located in <I>mln/core/alias/neigh*.hh</I>.</P><P>Use case example:

\endhtmlonly

\include labeling-compute-2.cc.raw

\htmlonly
 </P><P><A NAME="customse"></A>
\endhtmlonly

\subsection customse Custom structural elements

\htmlonly
 </P><!--TOC subsubsection Windows-->
<H4 CLASS="subsubsection"><!--SEC ANCHOR -->Windows</H4><!--SEC END --><P>There are several ways to define a new window.
The first and the most common way is to declare a window variable and insert
dpoints:

\endhtmlonly

\include win-create-1-1.cc.raw

\htmlonly
 
This code creates the following window where &ldquo;X&rdquo; is the central point from
which the window is computed:

\endhtmlonly

\include win-create-1-display.txt

\htmlonly
 </P><P>Another way to define the same window is to provide a bool array:

\endhtmlonly

\include win-create-2-1.cc.raw

\htmlonly
 </P><P><B>Note that despite the different ways of defining these windows,
&ldquo;varwin&rdquo; == &ldquo;<I>win2</I>&rdquo;</B>.
The boolean array <B>must</B>
always have an odd size.
While creating a windows thanks to a bool array/matrix, the window&rsquo;s center is the
central site of the array/matrix.</P><P><A NAME="convneighwin"></A>
\endhtmlonly

\subsection convneighwin Conversion between Neighborhoods and Windows

\htmlonly
 </P><P>Windows are not convertible to a Neighborhood.
Neighborhood are convertible to a window though.</P><P>A neighborhood has a method &ldquo;<I>win()</I>&rdquo; which returns the definition window.
Be ware that this window is not centered, thus does not include the central
point.</P><P><A NAME="sitesandco"></A>
\endhtmlonly

*/


/*!
\page sitesandco Sites, psites and dpoints

\htmlonly
 </P><P><BR>
<BR>
<BR>

<A NAME="sitessite"></A>
\endhtmlonly

\section sitessite Need for site

\htmlonly
 </P><P>As we have seen before, an image is usually defined on a grid. It has associated
data and a site set which defines the domain of the image on that grid.
Usually, we need to access a value by its coordinates. With default images it
can be done easily, at no cost.</P><P>Example with an <I>image2d</I>:

\endhtmlonly

\include ima2d-display-1.txt

\htmlonly
 </P><P>The site <I>x</I> is the point (0, 1). The image values are stored in a
multi-dimensional array. The point coordinates can be used directly. The site
(0, 1) <B>is</B> the point (0, 1) and the data is stored at row 0 and column
1.</P><P>Here we have:</P><P><I>I::site</I> == <I>I::psite</I> == <I>point2d</I></P><P>where, roughly, <I>point2d</I> = { row, column }.</P><P><BR>
<BR>
<BR>

<A NAME="sitespsite"></A>
\endhtmlonly

\section sitespsite Need for psite

\htmlonly
 </P><P>Sometimes, accessing a value in constant-time complexity, O(1), is not
possible with a site object.</P><P>Let&rsquo;s have a small example. Define a function returning a value for a given
point:

\endhtmlonly

\include fun-p2v-1-1.cc.raw

\htmlonly
 </P><P>So, for each point having (0, x) as coordinate, this function will return 8,
otherwise it will be 9.</P><P>Then, define a <I>p_array</I> with few <I>point2d</I>:

\endhtmlonly

\include parray-append-1.cc.raw

\htmlonly
 </P><P>Now, create a point-wise image from this function and this <I>p_array</I>:

\endhtmlonly

\include mln_var-1.cc.raw

\htmlonly
 </P><P><I>ima</I> is actually that image:

\endhtmlonly

\include ima2d-display-2.txt

\htmlonly
 </P><P>However, in memory, since it is based on a <I>p_array</I>, sites are stored in a
vector.</P><P>The site x is the point (3, 7) which corresponds to the cell 1 in the
<I>p_array</I>.

\endhtmlonly

\include parray-display-1.txt

\htmlonly
 </P><P>Obviously, we cannot check in constant time whether the site <I>x</I>,
<I>point2d</I> here,
is part of that image or not: knowing the point coordinates is not enough.
That&rsquo;s why we need a different mechanism in order to access this information:
the psites.</P><P>Here we have:</P><P><I>I::site</I> == <I>point2d</I> but <I>I::psite</I> ==
<I>pseudo_site&lt;point2d&gt;</I></P><P>where, roughly, <I>pseudo_site&lt;point2d&gt;</I> = { i_in_p_array, p_array_ptr
}.</P><P>Psites contains all the needed information to access the values in
constant-time.</P><P><BR>
<BR>
<BR>

<A NAME="sitespsitensite"></A>
\endhtmlonly

\section sitespsitensite From psite to site

\htmlonly
 </P><P>In the last example there was an image of type <I>I</I> such as <I>I::site</I>
!= <I>I::psite</I>.
In that case, an object of type <I>I::psite</I> is actually convertible towards an
object of type <I>I::site</I>. Furthermore, a <I>psite</I> shall behave as if it was a
<I>site</I>.</P><P>Design note: it seems impossible to offer through the interface of
some <I>psite</I> what is expected from its corresponding <I>site</I>. For instance, when a
site has a given feature, say a method "<I>m</I>", then this
method has to appear in the <I>psite</I> interface. However, thanks to
inheritance, we fetch an interface and an implementation that delegates
to the site.</P><P>For instance, in the last example, <I>I::psite</I> has a method <I>row()</I> because
<I>I::site</I>, <I>point2d</I>, provides such a method.</P><P>How it works: a <I>psite</I> inherits from <I>internal::site_impl&lt;site&gt;</I> which is
specialized for every site type; for instance,
	 <I>internal::site_impl&lt;point2d&gt;</I>
owns the method &ldquo;<I>coord row() const</I>&rdquo; which is defined as
&ldquo;<I>return exact(this)-&gt;to_site().row()</I>&rdquo;.</P><P><BR>
<BR>
<BR>

<A NAME="sitesdpoint"></A>
\endhtmlonly

\section sitesdpoint Dpoint

\htmlonly
 
Dpoints are relative sites. They are usually used in window and neighborhood
definitions. Since the central site is not constant, windows and neighborhoods
<B>must</B>
be recomputed and dpoints help in doing that.</P><P>
\endhtmlonly

\include dpoint-1-1.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include dpoint-1.txt

\htmlonly
 </P><P><A NAME="iterators"></A>
\endhtmlonly

*/


/*!
\page iterators Iterators

\htmlonly
 </P><P>Each container object in Olena like site sets or images have iterators.
The iteration mechanism for images is directly derived from the mechanism
for site sets.</P><P>There are usually three kinds:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
<B>fwd_iter</B>, depends on the container,
</LI><LI CLASS="li-itemize"><B>bkd_iter</B>, iterates like forward but to the opposite way,
</LI><LI CLASS="li-itemize"><B>iter</B>, usually the same as fwd_iter. It is guaranteed to
iterate all over the elements.
</LI></UL><P>
Every iterable object have these three kinds of iterator. There are all
bidirectional containers.
Whatever the iterator used, the basic iterator has the only property of
browsing every site once.</P><P>The iterator type name depends on the data pointed by it:<BR>

</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Data type</TD><TD VALIGN=top ALIGN=left NOWRAP>Iterator Names</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>Site</TD><TD VALIGN=top ALIGN=left NOWRAP>fwd_piter, bkd_piter, piter</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>Value</TD><TD VALIGN=top ALIGN=left NOWRAP>fwd_viter, bkd_viter, viter</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>Neighboors</TD><TD VALIGN=top ALIGN=left NOWRAP>fwd_niter, bkd_niter, niter</TD></TR>
</TABLE><P><BR>

As you may have noticed, according to the data type, the word &ldquo;iter&rdquo; is prefixed
by the usual name variable used for that data type. Sites variables are usually
called &ldquo;p&rdquo; so the proper iterator is &ldquo;typepiter&rdquo;. (See the foreword)<BR>
</P><P>An iterator has the following interface:<BR>

</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Return Type</TD><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left NOWRAP>Arguments</TD><TD VALIGN=top ALIGN=left NOWRAP>Const</TD><TD VALIGN=top ALIGN=left>Comments</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
void</TD><TD VALIGN=top ALIGN=left NOWRAP>start</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>void</TD><TD VALIGN=top ALIGN=left NOWRAP>next</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>bool</TD><TD VALIGN=top ALIGN=left NOWRAP>is_valid</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left NOWRAP>-</TD><TD VALIGN=top ALIGN=left>Return false if created with the default
constructor and not associated to a proper container.</TD></TR>
</TABLE><P><BR>
</P><P>Example of different forward iterations:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
box2d: from top to bottom then from left to right.
</LI><LI CLASS="li-itemize">p_array&lt;point2d&gt;: from left to right.
</LI></UL><P>A <I>for_all()</I> macro is available to iterate over all the sites:<BR>


\endhtmlonly

\include forall-piter-1.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include forall-piter.txt

\htmlonly
 </P><P>Note that when you declare an iterator, prefer using the &ldquo;<I>mln_*iter</I>&rdquo; macros.
They resolve the iterator type automatically from the given container type
passed as parameter. These macros can be used with any container like images or
site sets.</P><P>Here follow an example with the implemantions of the most basic routines which
use the <I>for_all()</I> loop: <I>data::fill()</I> and <I>data::paste()</I>.</P><P>
\endhtmlonly

\include fill-1.cc.raw

\htmlonly
 </P><P>
\endhtmlonly

\include paste-1.cc.raw

\htmlonly
 </P><P>Important note: macros for iterators exist in two versions:
&ldquo;<I>mln_*iter</I>&rdquo; and &ldquo;<I>mln_*iter_</I>&rdquo;. The difference is that the
first version <B>must</B>
be used in templated function whereas the second one <B>must</B>
be
used in non templated functions.</P><P>If you want a list of all the macros available in Olena, please refert to
section 
\endhtmlonly\ref macros\htmlonly .</P><P><A NAME="imamemmgmt"></A>
\endhtmlonly

*/


/*!
\page imamemmgmt Memory management

\htmlonly
 </P><P>In the Olena library, all image types behave like image2d:
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
An "empty" image is actually a mathematical variable.<P>&rarr; just think in a mathemetical way when dealing with images;</P></LI><LI CLASS="li-itemize">No dynamic memory allocation/deallocation is required.
the user never has to use "new / delete" (the C++ equivalent for the C
"malloc / free") so she does not have to manipulate pointers or to directly
access memory.<P>&rarr; Olena prevents the user from making mistakes;</P></LI><LI CLASS="li-itemize">Image data/values can be shared between several variables and the memory
used for image data is handled by the library.<P>&rarr; Memory management is automatic.
</P></LI></UL><!--TOC subsection Exemple with image2d-->
<H3 CLASS="subsection"><!--SEC ANCHOR -->Exemple with image2d</H3><!--SEC END --><P>Images do not actually store the data in the class. Images store a pointer
to an allocated space which can be shared with other objects. Once an image is
assigned to another one, the two images share the same data so they have the
same ID and point to the same memory space.
Therefore, assigning an image to another one is NOT a costly operation. The new
variable behaves like some mathematical variable. Put differently it is just a
name to designate an image:

\endhtmlonly

\include ima2d-5-1.cc.raw

\htmlonly
 </P><P>If a deep copy of the image is needed, a <I>duplicate()</I> routine is available:

\endhtmlonly

\include ima2d-6-clone-1.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include ima2d-6-clone.txt

\htmlonly
 </P><P><A NAME="basicops"></A>
\endhtmlonly

*/


/*!
\page basicops Basic routines

\htmlonly
 
</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Routine name</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>duplicate()</TD><TD VALIGN=top ALIGN=left>creates a deep copy of an object. Any shared data is
duplicated.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
data::fill()</TD><TD VALIGN=top ALIGN=left>fill an object with a value.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
data::paste()</TD><TD VALIGN=top ALIGN=left>paste object data to another object.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
labeling::blobs()</TD><TD VALIGN=top ALIGN=left>find and label the different components of an image.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
logical::not_()
logical::not_inplace()</TD><TD VALIGN=top ALIGN=left>Point-wise "logical not"</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
*::compute()</TD><TD VALIGN=top ALIGN=left>compute an accumulator on specific elements.</TD></TR>
</TABLE><P><BR>

<BR>
<BR>
<BR>

<A NAME="fillop"></A>
\endhtmlonly

\section fillop Fill

\htmlonly
 
First, create an image:

\endhtmlonly

\include fill-call-1-1.cc.raw

\htmlonly
 </P><P>Memory has been allocated so data can be stored but site values
have not been initialized yet. So we fill <I>imga</I> with the value &rsquo;a&rsquo;:</P><P>
\endhtmlonly

\include fill-call-1-2.cc.raw

\htmlonly
 </P><P>The <I>fill()</I> algorithm is located in the sub-namespace "<I>mln::data</I>" since this
algorithm deals with the site values.</P><P>The full name of this routine is <I>mln::data::fill()</I>.
To access to a particular algorithm, the proper file shall be included.
The file names of algorithms strictly map their C++ name; so
<I>mln::data::fill</I> is defined in the file <I>mln/data/fill.hh</I>.</P><!--TOC subsection Note-->
<H3 CLASS="subsection"><!--SEC ANCHOR -->Note</H3><!--SEC END --><P>
Most algorithms in Olena are constructed following the classical scheme: "output
algo(input)", where the input image is only read. However some few algorithms
take an input image in order to modify it. To enforce this particular feature,
the user shall explicitly state that the image is provided so that its data is
modified "read/write". The algorithm call shall be <I>data::fill(ima.rw(),
val)</I>. When forgetting the <I>rw()</I> call, it does not compile.</P><P>
\endhtmlonly

\include fill-call-1-3.cc.raw

\htmlonly
 </P><P><BR>
<BR>
<BR>

<A NAME="pasteop"></A>
\endhtmlonly

\section pasteop Paste

\htmlonly
 
We then define below a second image to play with. As you can see this image has
data for the sites (5, 5) to (14, 14) (so it has 100 sites).</P><P>
\endhtmlonly

\include paste-call-1-1.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include paste-call-1.txt

\htmlonly
 </P><!--TOC subsection Note-->
<H3 CLASS="subsection"><!--SEC ANCHOR -->Note</H3><!--SEC END --><P>
With this simple example we can see that images defined on different domains (or
set of sites) can interoperate. The set of sites of an image is defined and
can be accessed and printed. The following code:</P><P>
\endhtmlonly

\include domain-display-1.cc.raw

\htmlonly
 </P><P>Gives:

\endhtmlonly

\include domain-display-1.cc.raw

\htmlonly
 </P><P>The notion of site sets plays an important role in Olena. Many tests are
performed at run-time to ensure that the program is correct.</P><P>For instance, the algorithm <I>data::paste()</I> tests that the set of sites of <I>imgb</I>
(whose values are to be pasted) is a subset of the destination image.</P><P><BR>
<BR>
<BR>

<A NAME="blobs"></A>
\endhtmlonly

\section blobs Blobs

\htmlonly
 </P><P><I>labeling::blobs()</I> is used to label an image. It returns a new image with the
component id as value for each site. The background has 0 as id therefore the
component ids start from 1.</P><P>Consider the following image:

\endhtmlonly

\include labeling-compute-1.cc.raw

\htmlonly
 </P><P>Output:<BR>
</P><DIV CLASS="center">

\endhtmlonly

\image html labeling-compute-1.png

\htmlonly
 
</DIV><P>Then label this image thanks to <I>labeling::blobs()</I>:

\endhtmlonly

\include labeling-compute-2.cc.raw

\htmlonly
 </P><P>Output:<BR>

</P><DIV CLASS="center">

\endhtmlonly

\image html labeling-compute-2.png

\htmlonly
 
</DIV><P>Note that this routine returns the number of components in its third parameter.
This parameter <B>must</B>
be of the same type as the returned image value.</P><P><BR>
<BR>
<BR>

<A NAME="logicalnot"></A>
\endhtmlonly

\section logicalnot Logical not

\htmlonly
 
</P><DIV CLASS="center">
<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD ALIGN=left NOWRAP> <B>Header</B></TD><TD ALIGN=left NOWRAP>mln/logical/not.hh</TD></TR>
<TR><TD ALIGN=left NOWRAP>
<B>Full namespace</B></TD><TD ALIGN=left NOWRAP>mln::logical</TD></TR>
<TR><TD ALIGN=left NOWRAP>
<B>Routine(s)</B></TD><TD ALIGN=left NOWRAP>not_(),
			not_inplace()</TD></TR>
</TABLE>
</DIV><P><BR>
<BR>
</P><P>This small routine only works on binary images. It performs a point-wise
"logical not" and therefore "negates" the image. There are two versions of that
algorithm: a version which returns a new image and another which works in place.
Example:</P><P>Make a binary image:

\endhtmlonly

\include logical-not-1.cc.raw

\htmlonly
 
</P><DIV CLASS="center">

\endhtmlonly

\image html logical-not-1.png

\htmlonly
 
</DIV><P>Return the result in a new image:

\endhtmlonly

\include logical-not-2.cc.raw

\htmlonly
 
</P><DIV CLASS="center">
<TABLE CELLSPACING=6 CELLPADDING=0><TR><TD ALIGN=center NOWRAP>
\endhtmlonly

\image html logical-not-1.png

\htmlonly
 </TD><TD ALIGN=center NOWRAP>
\endhtmlonly

\image html logical-not-2.png

\htmlonly
</TD></TR>
<TR><TD ALIGN=center NOWRAP COLSPAN=2><I>ima</I> (left) and <I>ima<SUB>n</SUB>eg</I> (right) after having
called logical::not_().</TD></TR>
</TABLE>
</DIV><P>Or, work in place:

\endhtmlonly

\include logical-not-3.cc.raw

\htmlonly
 
Then, <I>ima</I> looks like:
</P><DIV CLASS="center">

\endhtmlonly

\image html logical-not-3.png

\htmlonly
 
</DIV><P><BR>
<BR>
<BR>

<A NAME="compute"></A>
\endhtmlonly

\section compute Compute

\htmlonly
 </P><P>There are several flavour of the compute routine, depending on what the kind of
elements it computes.</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>labeling::compute()</TD><TD VALIGN=top ALIGN=left>compute an accumulator for each component in a labeled
image.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
data::compute()</TD><TD VALIGN=top ALIGN=left>compute an accumulator on the values of an image.</TD></TR>
</TABLE><P><A NAME="accu"></A>
\endhtmlonly

\subsection accu Accumulators

\htmlonly
 
An accumulator is a special object accumulating data while iterating all over
the image values or sites. Hereby follows a list of accumulators available in
Olena.</P><!--TOC subsubsection Accumulators on sites-->
<H4 CLASS="subsubsection"><!--SEC ANCHOR -->Accumulators on sites</H4><!--SEC END --><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>bbox</TD><TD VALIGN=top ALIGN=left>Bounding boxes</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>count_adjacent_vertices</TD><TD VALIGN=top ALIGN=left>Count adjacent vertices</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>count</TD><TD VALIGN=top ALIGN=left>Count the number of sites</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>height</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>volume</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
</TABLE><!--TOC subsubsection Accumulators on values-->
<H4 CLASS="subsubsection"><!--SEC ANCHOR -->Accumulators on values</H4><!--SEC END --><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>histo</TD><TD VALIGN=top ALIGN=left>Histogram</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>max</TD><TD VALIGN=top ALIGN=left>Max value</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>max_h</TD><TD VALIGN=top ALIGN=left>Max value (Hexa)</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>mean</TD><TD VALIGN=top ALIGN=left>Mean value</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>median_alt</TD><TD VALIGN=top ALIGN=left>Median</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>median_h</TD><TD VALIGN=top ALIGN=left>Median (Hexa)</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>min</TD><TD VALIGN=top ALIGN=left>Min value</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>min_h</TD><TD VALIGN=top ALIGN=left>Min value (Hexa)</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>min_max</TD><TD VALIGN=top ALIGN=left>Min and Max value</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>rank_bool</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>rank</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>rank_high_quant</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>sum</TD><TD VALIGN=top ALIGN=left>Sum the values</TD></TR>
</TABLE><!--TOC subsubsection Special accumulators-->
<H4 CLASS="subsubsection"><!--SEC ANCHOR -->Special accumulators</H4><!--SEC END --><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>pair</TD><TD VALIGN=top ALIGN=left>Pair of accumulators</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>tuple</TD><TD VALIGN=top ALIGN=left><I>n</I>-uplets of accumulators</TD></TR>
</TABLE><P>Each accumulator can be used in <I>*::compute()</I>.
It exists two versions of each accumulator.
</P><UL CLASS="itemize"><LI CLASS="li-itemize">
<I>mln::accu::*</I>, this version require the site or value type as parameter.
For instance, for the bbox accumulator, the type would be
<I>accu::bbox&lt;mln_psite(I)&gt;</I>, where <I>I</I> is the type of the image on which it will be
computed.
</LI><LI CLASS="li-itemize"><I>mln::accu::meta::*</I>, this is usually the easiest version to use. The type
of site or value do not need to be specified and will be deduced at compile
time. For the bbox accumulator, the accumulator type would be
<I>accu::meta::bbox</I>.
</LI></UL><P>Note that when an accumulator is passed to <I>*::compute()</I>, it <B>must</B>
be instanciated.You cannot write:

\endhtmlonly

\include accu-wrong-instantiation.cc.raw

\htmlonly
 
Instead, you <B>must</B>
write:

\endhtmlonly

\include accu-right-instantiation-1.cc.raw

\htmlonly
 </P><P><A NAME="exlblcompute"></A>
\endhtmlonly

\subsection exlblcompute Example with labeling::compute()

\htmlonly
 </P><P>In this example we will try to retrieve the bounding box of each component in an
image.</P><P>Consider the following image:

\endhtmlonly

\include labeling-compute-1.cc.raw

\htmlonly
 </P><P>Then label this image thanks to <I>labeling::blobs()</I>:

\endhtmlonly

\include labeling-compute-2.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\image html labeling-compute-2.png

\htmlonly
 </P><P>Then, use <I>labeling::compute()</I> with the bbox accumulator:

\endhtmlonly

\include labeling-compute-3.cc.raw

\htmlonly
 </P><P><I>labeling::compute()</I> holds an accumulator for each component, which means it
returns an array of accumulator results.
In this case, it returns an array of <I>box2d</I>.</P><P><B>Important note:</B> since <I>labeling::blobs()</I> labels the component from 1 and
set the background to 0, we will want to iterate from 1 to nlabels included.

\endhtmlonly

\include labeling-compute-4.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include labeling-compute.txt

\htmlonly
 </P><!--TOC subsection Routines based on accumulators and *::compute()-->
<H3 CLASS="subsection"><!--SEC ANCHOR --><A NAME="htoc1">0.0.1</A>&nbsp;&nbsp;Routines based on accumulators and *::compute()</H3><!--SEC END --><P>
In order to make the code cleaner, small routines are available for the
most used accumulators.</P><P>Currently there are the following routines:<BR>

</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>nsites</TD><TD VALIGN=top ALIGN=left>Return the number of sites of an image or a site set.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>mean</TD><TD VALIGN=top ALIGN=left>Return the mean of the values of an image.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>min_max</TD><TD VALIGN=top ALIGN=left>Return the min and max values of the values of an image.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>sum</TD><TD VALIGN=top ALIGN=left>Return the sum of the values of an image.</TD></TR>
</TABLE><P>These routines can be found in <I>mln/geom</I> and in <I>mln/estim</I>.
For example, with <I>geom::nsites()</I> simply write:

\endhtmlonly

\include estim-sites-1.cc.raw

\htmlonly
 </P><P><BR>
<BR>
<BR>

<A NAME="partima"></A>
\endhtmlonly

\section partima Working with parts of an image

\htmlonly
 </P><P>Sometimes it may be interesting to work only on some parts of the image or to
extract only a sub set of that image. Olena enables that through the
operator &rsquo;|&rsquo;.</P><P>Three kinds of that operator exist:<BR>

</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Prototype</TD><TD VALIGN=top ALIGN=left NOWRAP>Comments</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
Image | Sub Domain</TD><TD VALIGN=top ALIGN=left NOWRAP>Create a new image.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>Image | Function_p2b</TD><TD VALIGN=top ALIGN=left NOWRAP>Do not create a new image but create a morpher.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>Function_p2v | Sub Domain</TD><TD VALIGN=top ALIGN=left NOWRAP>Do not create a new image but create a morpher.</TD></TR>
</TABLE><P><BR>

A Sub Domain can be a site set, an image or any value returned by this
operator.
For a given site, <I>Function_p2v</I> returns a value and <I>Function_p2b</I> returns a
boolean. These functions are actually a sort of predicate. A common
<I>Function_p2v</I> is <I>pw::value(Image)</I>. It returns the
point to value function used in the given image. C functions can also be used as
predicate by passing the function pointer.</P><P>You can easily get a <I>Function_p2b</I> by comparing the value returned
by a <I>Function_p2v</I> to another Value.
The following sample codes illustrate this feature.</P><P>In order to use C functions as predicate, they <B>must</B>
have one of the following
prototype if you work on 2D images:

\endhtmlonly

\include predicate-1-1.cc.raw

\htmlonly
 
Of course, you just need to change the point type if you use another image
type. For instance, you would use <I>point3d</I> with 3D images.
The returned value type <I>V</I> for <I>Function_p2v</I> depends on the image value type.
With <I>image2d&lt;int&gt;</I>, <I>V</I> would be <I>int</I>.</P><P>In this section, all along the examples, the image <I>ima</I> will refer to the
following declaration:

\endhtmlonly

\include fill-part-image-1.cc.raw

\htmlonly
 
Output:
</P><DIV CLASS="center">

\endhtmlonly

\image html fill-subdomain-1.png

\htmlonly
 
</DIV><P><A NAME="restrictsiteset"></A>
\endhtmlonly

\subsection restrictsiteset Restrict an image with a site set

\htmlonly
 
A simple example is to fill only a part of an image with a specific value:

\endhtmlonly

\include fill-part-image-2.cc.raw

\htmlonly
 </P><P>Output:

\endhtmlonly

\include fill-part-image.txt

\htmlonly
 </P><P><A NAME="restrictpred"></A>
\endhtmlonly

\subsection restrictpred Restrict an image with a predicate

\htmlonly
 
In the following example, we aim at extracting a component from an image and
create a new image with it.</P><P>First, find and label the components.

\endhtmlonly

\include fill-subdomain-2.cc.raw

\htmlonly
 
Output:
</P><DIV CLASS="center">

\endhtmlonly

\image html fill-subdomain-2.png

\htmlonly
 
</DIV><P>Then, restrict the image to the sites being part of component 2.

\endhtmlonly

\include fill-subdomain-3.cc.raw

\htmlonly
 </P><P><I>lbl_2</I> is a new image. <I>lbl_2</I> looks like:
</P><DIV CLASS="center">

\endhtmlonly

\image html fill-subdomain-3.png

\htmlonly
 
</DIV><P>Finally, create a new color image, fill it with black and fill the sites part of
component 2 with red.

\endhtmlonly

\include fill-subdomain-4.cc.raw

\htmlonly
 
Output:
</P><DIV CLASS="center">

\endhtmlonly

\image html fill-subdomain-4.png

\htmlonly
 
</DIV><P>The previous example can be written more quickly:

\endhtmlonly

\include fill-subdomain-shorter-2.cc.raw

\htmlonly
 </P><P><A NAME="restrictcfun"></A>
\endhtmlonly

\subsection restrictcfun Restrict an image with a C function

\htmlonly
 
In this example, the image is restricted to its odd lines. A new image is
created in which odd lines are in red and others in black.</P><P>Here is the simple C function used as predicate:

\endhtmlonly

\include fill-imageif-cfun-1.cc.raw

\htmlonly
 </P><P>Restrict the image with it:

\endhtmlonly

\include fill-imageif-cfun-3.cc.raw

\htmlonly
 </P><P>Output:
</P><DIV CLASS="center">

\endhtmlonly

\image html fill-imageif-cfun-1.png

\htmlonly
 
</DIV><P>
<BR>
</P><!--TOC subsection Important note-->
<H3 CLASS="subsection"><!--SEC ANCHOR -->Important note</H3><!--SEC END --><P>
When writing:</P><P>
\endhtmlonly

\include ima2d-restricted-1.cc.raw

\htmlonly
 </P><P><I>sub_D</I> <B>must</B>
be included in <I>ima.domain()</I>.</P><P>Let&rsquo;s have an image, <I>imab</I>, like this:

\endhtmlonly

\include ima2d-display-output-1.txt

\htmlonly
 </P><P>Extract a sub image from <I>imab</I> with sites having their value set to 1.

\endhtmlonly

\include mln_var-2.cc.raw

\htmlonly
 
Then, <I>imab1</I> looks like:

\endhtmlonly

\include ima2d-display-output-2.txt

\htmlonly
 </P><P>Now, if we want to extract a sub image it may fail, depending on the site set
used:

\endhtmlonly

\include ima2d-restricted-2.cc.raw

\htmlonly
 </P><P>If you do not want this constraint, you may want to use an alternative
operator:

\endhtmlonly

\include ima2d-restricted-3.cc.raw

\htmlonly
 </P><P><A NAME="inputoutput"></A>
\endhtmlonly

*/


/*!
\page inputoutput Input / Output

\htmlonly
 </P><P>Olena offers a builtin support for PNM (PBM, PGM &amp; PPM), PFM and dump file formats.</P><P>You can extend the range of supported files by installing third-parties libraries such as:</P><UL CLASS="itemize"><LI CLASS="li-itemize">
ImageMagick: support for usual images (PNG, TIFF, JPEG, ...)
</LI><LI CLASS="li-itemize">GDCM: support for DICOM medical images
</LI></UL><P><BR>
<BR>
<BR>

<A NAME="ioim"></A>
\endhtmlonly

\section ioim ImageMagick

\htmlonly
 
<A HREF="http://www.imagemagick.org">http://www.imagemagick.org</A><BR>

You have to install ImageMagick with Magick++ support. You will be able to
load every file recognized as an image by ImageMagick.<BR>

Olena only support binary and 8 bits images through ImageMagick.<BR>

During the compilation, you will have to specify the ImageMagick flags and
libraries.<BR>

To do so, just add the following line to your compilation:</P><PRE CLASS="verbatim">  `Magick++-config --cppflags --cxxflags --ldflags --libs`
  </PRE><P>Magick++-config will automatically fill the dependencies depending of your
installation.</P><P><BR>
<BR>
<BR>

<A NAME="iodcm"></A>
\endhtmlonly

\section iodcm GDCM

\htmlonly
 
<A HREF="http://apps.sourceforge.net/mediawiki/gdcm">http://apps.sourceforge.net/mediawiki/gdcm</A><BR>

GDCM is a library for manipulating DICOM files. DICOM files are used in
medical imaging.</P><P><A NAME="graphandima"></A>
\endhtmlonly

*/


/*!
\page graphandima Graphs and images

\htmlonly
 </P><P><BR>
<BR>
<BR>

<A NAME="graphdesc"></A>
\endhtmlonly

\section graphdesc Description

\htmlonly
 
Olena enables the possibility of using graphs with images.
Graphs can help you to handle directly parts of an image and represent their
relationship.
Specific data can be associated to each vertex and/or edges.</P><P><BR>
<BR>
<BR>

<A NAME="graphexample"></A>
\endhtmlonly

\section graphexample Example

\htmlonly
 </P><P>First, create a graph which looks like the following:</P><P>
\endhtmlonly

\include graph-output-1.txt

\htmlonly
 </P><P>First we need to add vertices:</P><P>
\endhtmlonly

\include graph-data-2.cc.raw

\htmlonly
 </P><P>Finally, populate the graph with edges:

\endhtmlonly

\include graph-data-3.cc.raw

\htmlonly
 </P><P>Now there is a graph topology and we want to associate elements of this graph
to a site in the image.
The idea is to use specific site sets such as <I>p_vertices</I> and
<I>p_edges</I>.
Let&rsquo;s associate the vertices with sites. To do so we need a function which maps
a vertex id to a site, e.g. a <I>point2d</I> here.

\endhtmlonly

\include graph-data-4.cc.raw

\htmlonly
 </P><P>Then declare a <I>p_vertices</I>:

\endhtmlonly

\include graph-data-5.cc.raw

\htmlonly
 </P><P>Thanks to the <I>p_vertices</I> there is now a mapping between vertices and sites.
We may want to map data to it. The idea is to provide a function which returns
the associated data according to the site given as parameter. Combining this
function and the <I>p_vertices</I>, we get an image which can be used with
algorithms and <I>for_all</I> loops.</P><P>
\endhtmlonly

\include graph-data-1.cc.raw

\htmlonly
 

\endhtmlonly

\include graph-data-6.cc.raw

\htmlonly
 </P><P>Output:

\endhtmlonly

\include graph-data.txt

\htmlonly
 </P><P>Note that like any image in Olena, graph images share their data. Therefore,
while constructing a graph image from a graph and a function, the graph is not
copied and this is NOT a costly operation.</P><P>Of course, creating a graph image is not necessary and you can work directly
with the graph and container/function mapping sites and data.</P><P>
\endhtmlonly

\include graph-iter-1.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include graph-iter-1.txt

\htmlonly
 </P><P>Graphs have iterators like any other site sets and also provide
specific iterators in order to iterate over graphs in a more intuitive way.</P><P>Iteration over the adjacent edges of all the vertices:

\endhtmlonly

\include graph-iter-2.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include graph-iter-2.txt

\htmlonly
 </P><P>Iteration over the adjacent edges of all the edges:

\endhtmlonly

\include graph-iter-3.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include graph-iter-3.txt

\htmlonly
 </P><P>Iteration over the adjacent vertices of all the vertices:

\endhtmlonly

\include graph-iter-4.cc.raw

\htmlonly
 
Output:

\endhtmlonly

\include graph-iter-4.txt

\htmlonly
 </P><P><A NAME="globalvars"></A>
\endhtmlonly

*/


/*!
\page globalvars Useful global variables

\htmlonly
 </P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left>Description</TD><TD VALIGN=top ALIGN=left NOWRAP>Possible values</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>literal::zero</TD><TD VALIGN=top ALIGN=left>Generic zero value. Can be used with various types such as
algebra::vec, dpoint&#X2026;</TD><TD VALIGN=top ALIGN=left NOWRAP>n.a.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>&nbsp;</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD><TD VALIGN=top ALIGN=left NOWRAP>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>literal::one</TD><TD VALIGN=top ALIGN=left>Generic one value. Can be used with various types such as
algebra::vec, dpoint&#X2026;</TD><TD VALIGN=top ALIGN=left NOWRAP>n.a.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>&nbsp;</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD><TD VALIGN=top ALIGN=left NOWRAP>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>literal::origin</TD><TD VALIGN=top ALIGN=left>Generic value for the origin point on a grid.</TD><TD VALIGN=top ALIGN=left NOWRAP>n.a.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>&nbsp;</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD><TD VALIGN=top ALIGN=left NOWRAP>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>border::thickness</TD><TD VALIGN=top ALIGN=left>Set the default border thickness of images</TD><TD VALIGN=top ALIGN=left NOWRAP>[0&#X2212;<I>UINT</I>_<I>MAX</I>]</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>&nbsp;</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD><TD VALIGN=top ALIGN=left NOWRAP>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>trace::quiet</TD><TD VALIGN=top ALIGN=left>Enable trace printing</TD><TD VALIGN=top ALIGN=left NOWRAP>true/false</TD></TR>
</TABLE><P><A NAME="macros"></A>
\endhtmlonly

*/


/*!
\page macros Useful macros

\htmlonly
 
</P><P><BR>
<BR>
<BR>

<A NAME="vardeclmacros"></A>
\endhtmlonly

\section vardeclmacros Variable declaration macros

\htmlonly
 
</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left>Arguments</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>mln_VAR(N, V)	</TD><TD VALIGN=top ALIGN=left>N : name of the variable.</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>		</TD><TD VALIGN=top ALIGN=left>V : value to assign to N.</TD><TD VALIGN=top ALIGN=left>Declare a variable N of type N_t and
assign the value V.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_const_VAR(N, V)</TD><TD VALIGN=top ALIGN=left>N : name of the variable.</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>		</TD><TD VALIGN=top ALIGN=left>V : value to assign to N.</TD><TD VALIGN=top ALIGN=left>Declare a const variable N of type N_t
and assign the value V.</TD></TR>
</TABLE><P><BR>
<BR>
<BR>

<A NAME="macrositerators"></A>
\endhtmlonly

\section macrositerators Iterator type macros

\htmlonly
 </P><P><A NAME="macrosdefit"></A>
\endhtmlonly

\subsection macrosdefit Default iterator types

\htmlonly
 
</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left>Arguments</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>mln_eiter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable container type	</TD><TD VALIGN=top ALIGN=left>Type of the element
iterator of T</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_niter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable container/Image type</TD><TD VALIGN=top ALIGN=left>Type of the neighborhood
iterator of T</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_piter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable container/image type</TD><TD VALIGN=top ALIGN=left>Type of the site
iterator</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_qiter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable container/image type</TD><TD VALIGN=top ALIGN=left>Type of the window
neighbors iterator of T</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_viter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable value container type</TD><TD VALIGN=top ALIGN=left>Type of the value
iterator of T</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_pixter(I)	</TD><TD VALIGN=top ALIGN=left>I : image			</TD><TD VALIGN=top ALIGN=left>Type of the pixel
iterator of I</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_qixter(I, W)</TD><TD VALIGN=top ALIGN=left>I : image type,		</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>		</TD><TD VALIGN=top ALIGN=left>W : window Type		</TD><TD VALIGN=top ALIGN=left>Type of the pixel iterator of a
window on an image of type I.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_nixter(I, N)</TD><TD VALIGN=top ALIGN=left>I : image type,		</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>		</TD><TD VALIGN=top ALIGN=left>N : neighborhood type	</TD><TD VALIGN=top ALIGN=left>Type of the pixel iterator of a
neighborhood on an image of type I.</TD></TR>
</TABLE><P><A NAME="macrosfwdit"></A>
\endhtmlonly

\subsection macrosfwdit Forward iterator types

\htmlonly
 
</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left>Arguments</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>mln_fwd_eiter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable container type	</TD><TD VALIGN=top ALIGN=left>Type of the
element forward iterator of T</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_fwd_niter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable container/Image type</TD><TD VALIGN=top ALIGN=left>Type of the
neighborhood forward iterator of T</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_fwd_piter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable container/image type</TD><TD VALIGN=top ALIGN=left>Type of the site
forward iterator</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_fwd_qiter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable container/image type</TD><TD VALIGN=top ALIGN=left>Type of the window
neighbors forward iterator of T</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_fwd_viter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable value container type</TD><TD VALIGN=top ALIGN=left>Type of the value
forward iterator of T</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_fwd_pixter(I)	</TD><TD VALIGN=top ALIGN=left>I : image			</TD><TD VALIGN=top ALIGN=left>Type of the pixel
forward iterator of I</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_fwd_qixter(I, W)	</TD><TD VALIGN=top ALIGN=left>I : image type,		</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>			</TD><TD VALIGN=top ALIGN=left>W : window Type		</TD><TD VALIGN=top ALIGN=left>Type of the pixel
forward iterator of a window on an image of type I.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_fwd_nixter(I, N)	</TD><TD VALIGN=top ALIGN=left>I : image type,		</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>			</TD><TD VALIGN=top ALIGN=left>N : neighborhood type		</TD><TD VALIGN=top ALIGN=left>Type of the pixel
forward iterator of a neighborhood on an image of type I.</TD></TR>
</TABLE><P><A NAME="macrosbkdit"></A>
\endhtmlonly

\subsection macrosbkdit Backward iterators

\htmlonly
 
</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left>Arguments</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>mln_bkd_eiter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable container type	</TD><TD VALIGN=top ALIGN=left>Type of the
element backward iterator of T</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_bkd_niter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable container/Image type</TD><TD VALIGN=top ALIGN=left>Type of the
neighborhood backward iterator of T</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_bkd_piter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable container/image type</TD><TD VALIGN=top ALIGN=left>Type of the site
backward iterator</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_bkd_qiter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable container/image type</TD><TD VALIGN=top ALIGN=left>Type of the window
neighbors backward iterator of T</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_bkd_viter(T)	</TD><TD VALIGN=top ALIGN=left>T : iterable value container type</TD><TD VALIGN=top ALIGN=left>Type of the value
backward iterator of T</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_bkd_pixter(I)	</TD><TD VALIGN=top ALIGN=left>I : image			</TD><TD VALIGN=top ALIGN=left>Type of the pixel
backward iterator of I</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_bkd_qixter(I, W)	</TD><TD VALIGN=top ALIGN=left>I : image type,		</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>			</TD><TD VALIGN=top ALIGN=left>W : window Type		</TD><TD VALIGN=top ALIGN=left>Type of the pixel
backward iterator of a window on an image of type I.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>
mln_bkd_nixter(I, N)	</TD><TD VALIGN=top ALIGN=left>I : image type,		</TD><TD VALIGN=top ALIGN=left>&nbsp;</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>			</TD><TD VALIGN=top ALIGN=left>N : neighborhood type		</TD><TD VALIGN=top ALIGN=left>Type of the pixel
backward iterator of a neighborhood on an image of type I.</TD></TR>
</TABLE><P><A NAME="macrosgraphit"></A>
\endhtmlonly

\subsection macrosgraphit Graph iterators

\htmlonly
 
</P><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=1><TR><TD VALIGN=top ALIGN=left NOWRAP>Name</TD><TD VALIGN=top ALIGN=left>Arguments</TD><TD VALIGN=top ALIGN=left>Description</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>mln_vertex_iter(G)		</TD><TD VALIGN=top ALIGN=left>G : graph type</TD><TD VALIGN=top ALIGN=left>Iterator on vertices.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>mln_edge_iter(G)		</TD><TD VALIGN=top ALIGN=left>G : graph type</TD><TD VALIGN=top ALIGN=left>Iterator on edges.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>mln_vertex_nbh_edge_iter(G)	</TD><TD VALIGN=top ALIGN=left>G : graph type</TD><TD VALIGN=top ALIGN=left>Iterator on the edges adjacent to a vertex.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>mln_vertex_nbh_vertex_iter(G)</TD><TD VALIGN=top ALIGN=left>G : graph type</TD><TD VALIGN=top ALIGN=left>Iterator on the vertices adjacent to a vertex.</TD></TR>
<TR><TD VALIGN=top ALIGN=left NOWRAP>mln_edge_nbh_edge_iter(G)	</TD><TD VALIGN=top ALIGN=left>G : graph type</TD><TD VALIGN=top ALIGN=left>Iterator on the edges adjacent to an edge.</TD></TR>
</TABLE><P><A NAME="compilerrors"></A>
\endhtmlonly

*/


/*!
\page compilerrors Common Compilation Errors

\htmlonly
 </P><P>In this section, the most common compilation errors are gathered and explained.</P><UL CLASS="itemize"><LI CLASS="li-itemize">
<B>error: &rsquo;check&rsquo; is not a member of &rsquo;mln::metal::not_equal&lt;bool, bool&gt;<BR>
 error: &rsquo;check&rsquo; is not a member of &rsquo;mln::metal::converts_to&lt;mln::value::rgb&lt;8u&gt;, unsigned int&gt;&rsquo;</B><BR>

The routine does not support a given image with such a value type
or an automatic conversion from the image value type to the
expected value type is not available.</LI><LI CLASS="li-itemize"><B>error: using &rsquo;typename&rsquo; outside of template</B><BR>

Macros like <I>mln_site</I> or <I>mln_domain</I> can only be
used in templated functions. In order to use them in a
non-templated function, a &#X2018;_&rsquo; must be appended to the macro
name. For instance : <I>mln_site_</I> and <I>mln_domain_</I>.</LI></UL><!--CUT END -->
<!--HTMLFOOT-->
<!--ENDHTML-->
<!--FOOTER-->
<HR SIZE=2><BLOCKQUOTE CLASS="quote"><EM>This document was translated from L<sup>A</sup>T<sub>E</sub>X by
<A HREF="http://hevea.inria.fr/index.html">H<FONT SIZE=2><sup>E</sup></FONT>V<FONT SIZE=2><sup>E</sup></FONT>A</A>.</EM></BLOCKQUOTE></BODY>
</HTML>
\endhtmlonly */
