// Copyright (C) 2009 EPITA Research and Development Laboratory (LRDE)
//
// This file is part of Olena.
//
// Olena is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, version 2 of the License.
//
// Olena is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Olena.  If not, see <http://www.gnu.org/licenses/>.
//
// As a special exception, you may use this file as part of a free
// software project without restriction.  Specifically, if other files
// instantiate templates or use macros or inline functions from this
// file, or you compile this file and link it with other files to produce
// an executable, this file does not by itself cause the resulting
// executable to be covered by the GNU General Public License.  This
// exception does not however invalidate any other reasons why the
// executable file might be covered by the GNU General Public License.

#ifndef APPS_MESH_SEGM_SKEL_SAVE_BIN_ALT_HH
# define APPS_MESH_SEGM_SKEL_SAVE_BIN_ALT_HH

/*--------------------------------------------------------------------.
| FIXME: Copied and adjusted (in a hurry) from mln/io/off/save.hh,    |
| because fixing image_if + complex_image was much too long.  Sorry.  |
`--------------------------------------------------------------------*/

# include <cstdlib>

# include <iostream>
# include <fstream>
# include <sstream>

# include <string>

# include <mln/core/alias/complex_image.hh>
# include <mln/core/image/complex_neighborhoods.hh>
# include <mln/core/image/complex_neighborhood_piter.hh>

namespace mln
{

  namespace io
  {

    namespace off
    {

      /** FIXME: Similar to
	  mln::io::off::save(const bin_2complex_image3df&, const std::string&),
          but does not save faces whose value is `false'.  */
      template <typename I>
      void save_bin_alt(const I& ima,
			const std::string& filename)
      {
	const std::string me = "mln::io::off::save";

	std::ofstream ostr(filename.c_str());
	if (!ostr)
	  {
	    std::cerr << me << ": `" << filename << "' invalid file."
		      << std::endl;
	    /* FIXME: Too violent.  We should allow the use of
	       exceptions, at least to have Milena's code behave
	       correctly in interpreted environments (std::exit() or
	       std::abort() causes the termination of a Python
	       interpreter, for instance!).  */
	    std::exit(1);
	  }

	/*---------.
	| Header.  |
	`---------*/

	static const unsigned D = I::dim;
	typedef mln_geom(I) G;

	/* ``The .off files in the Princeton Shape Benchmark conform
	   to the following standard.'' */

	/* ``OFF files are all ASCII files beginning with the
	   keyword OFF. ''  */
	ostr << "OFF" << std::endl;

	// A comment.
	ostr << "# Generated by Milena 1.0  http://olena.lrde.epita.fr\n"
	     << "# EPITA Research and Development Laboratory (LRDE)"
	     << std::endl;

	// Count the number of 2-faces set to `true'.
	unsigned n2faces = 0;
	p_n_faces_fwd_piter<D, G> f(ima.domain(), 2);
	for_all(f)
	  if (ima(f))
	    ++n2faces;

	/* ``The next line states the number of vertices, the number
	   of faces, and the number of edges. The number of edges can
	   be safely ignored.'' */
	/* FIXME: This is too long.  We shall be able to write

	   ima.domain().template nfaces_of_static_dim<0>()

	   or even

	   ima.template nfaces_of_static_dim<0>().
	*/
	ostr << ima.domain().cplx().template nfaces_of_static_dim<0>() << ' '
	     << n2faces << ' '
	     << ima.domain().cplx().template nfaces_of_static_dim<1>()
	     << std::endl;

	/*-------.
	| Data.  |
	`-------*/

	// ------------------------------------------ //
	// Vertices & geometry (vertices locations).  //
	// ------------------------------------------ //

	/* ``The vertices are listed with x, y, z coordinates, written
	   one per line.'' */

	// Traverse the 0-faces (vertices).
	p_n_faces_fwd_piter<D, G> v(ima.domain(), 0);
	for_all(v)
	{
	  mln_invariant(v.to_site().size() == 1);
	  ostr << v.to_site().front()[0] << ' '
	       << v.to_site().front()[1] << ' '
	       << v.to_site().front()[2] << std::endl;
	}

	// --------------- //
	// Faces & edges.  //
	// --------------- //

	/* ``After the list of vertices, the faces are listed, with one
	   face per line. For each face, the number of vertices is
	   specified, followed by indices into the list of
	   vertices.''  */

	// Traverse the 2-faces (polygons).
	typedef complex_m_face_neighborhood<D, G> nbh_t;
	// A neighborhood where neighbors are the set of 0-faces
	// transitively adjacent to the reference point.
	nbh_t nbh;
	mln_fwd_niter(nbh_t) u(nbh, f);
	/* FIXME: We should be able to pas this value (m) either at
	   the construction of the neighborhood or at the construction
	   of the iterator.  */
	u.iter().set_m(0);

	// For each (2-)face, iterate on (transitively) ajacent
	// vertices (0-faces).
	for_all(f)
	  if (ima(f))
	    {
	      unsigned nvertices = 0;
	      std::ostringstream vertices;
	      for_all(u)
	      {
		// FIXME: Likewise, this is a bit too long...
		vertices << ' ' << u.unproxy_().face().face_id();
		++nvertices;
	      }
	      ostr << nvertices << vertices.str();
	      ostr << std::endl;
	    }

	ostr.close();
      }

    } // end of namespace mln::io::off

  } // end of namespace mln::io

} // end of namespace mln


#endif // ! APPS_MESH_SEGM_SKEL_SAVE_BIN_ALT_HH
