#! /bin/sh

# Copyright (C) 2009 EPITA Research and Development Laboratory (LRDE).
#
# This file is part of Olena.
#
# Olena is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation, version 2 of the License.
#
# Olena is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Olena.  If not, see <http://www.gnu.org/licenses/>.


# Generate a list of distributed files w.r.t. a list of file which must
# be excluded.
# --------------------
# List all the headers in order to make them part of distribution.

# Use the C locale to have a deterministic sort.
export LC_ALL=C

if [ $# -ne 3 ] && [ $# -ne 5 ]; then
  echo "$0 <scanned_dir> <output> <nodist-headers> [<module name> <inc_path>]"
  exit 1
fi

me=`basename $0`
scanned_dir=$1
output=$2
nodist_headers=$3
test -f "$nodist_headers" \
  || { echo "$me: Cannot find \`$nodist_headers' in `pwd`."; exit 1; }

echo "Generating $output..." >&2
rm -f "$output"

if [ $# -eq 5 ]; then
    cat <<EOF > "$output"
## Generated by \`$me', do not edit by hand.
$4dir = \$(includedir)/$5
nobase_$4_HEADERS = \\
EOF
else
    cat <<EOF > "$output"
## Generated by \`$me', do not edit by hand.

nobase_include_HEADERS = \\
EOF
fi


find $scanned_dir -type f -a \( -name '*.hh' -o -name '*.hxx' \) \
  | sort						\
  | comm -23 - "$nodist_headers"			\
  | sed -e 's/$/ \\/g' >> $output


last_line=`tail -n 1 $output | sed -e 's/\\\//g'` # remove '\' in last line
sed '$d' < $output > $output.tmp # remove last line
mv $output.tmp $output
echo $last_line >> $output # put the cleaned last line back.


# Add non distributed files to installed headers list.
#
# Non distributed headers will be installed if the installation
# process is launched from the repository copy.
if [ $# -eq 5 ]; then
    cat <<EOF >> "$output"

#<<lrde
nobase_$4_HEADERS += \\
EOF
else
    cat <<EOF >> "$output"

#<<lrde
nobase_include_HEADERS += \\
EOF
fi

cat $nodist_headers | sed -e 's/$/ \\/g' >> $output

last_line=`tail -n 1 $output | sed -e 's/\\\//g'` # remove '\' in last line
sed '$d' < $output > $output.tmp # remove last line
mv $output.tmp $output
echo $last_line >> $output # put the cleaned last line back.

echo "#>>" >> $output