from asdl import pybase

option_t = int  # type alias for integer

class option_i(object):
  errexit = 1
  nounset = 2
  pipefail = 3
  inherit_errexit = 4
  nullglob = 5
  verbose_errexit = 6
  noexec = 7
  xtrace = 8
  verbose = 9
  noglob = 10
  noclobber = 11
  posix = 12
  vi = 13
  emacs = 14
  interactive = 15
  hashall = 16
  failglob = 17
  extglob = 18
  nocasematch = 19
  eval_unsafe_arith = 20
  _allow_command_sub = 21
  _allow_process_sub = 22
  dynamic_scope = 23
  redefine_module = 24
  _running_trap = 25
  _running_hay = 26
  _no_debug_trap = 27
  strict_argv = 28
  strict_arith = 29
  strict_array = 30
  strict_control_flow = 31
  strict_errexit = 32
  strict_nameref = 33
  strict_word_eval = 34
  strict_tilde = 35
  strict_glob = 36
  parse_at = 37
  parse_proc = 38
  parse_func = 39
  parse_brace = 40
  parse_bracket = 41
  parse_equals = 42
  parse_paren = 43
  parse_ysh_string = 44
  parse_triple_quote = 45
  simple_word_eval = 46
  dashglob = 47
  command_sub_errexit = 48
  process_sub_fail = 49
  xtrace_rich = 50
  xtrace_details = 51
  sigpipe_status_ok = 52
  redefine_proc_func = 53
  parse_at_all = 54
  parse_backslash = 55
  parse_backticks = 56
  parse_dollar = 57
  parse_ignored = 58
  parse_sh_arith = 59
  parse_dparen = 60
  parse_dbracket = 61
  parse_bare_word = 62
  simple_echo = 63
  simple_eval_builtin = 64
  simple_test_builtin = 65
  expand_aliases = 66
  lastpipe = 67
  progcomp = 68
  histappend = 69
  hostcomplete = 70
  cmdhist = 71
  assoc_expand_once = 72
  autocd = 73
  cdable_vars = 74
  cdspell = 75
  checkhash = 76
  checkjobs = 77
  checkwinsize = 78
  complete_fullquote = 79
  direxpand = 80
  dirspell = 81
  dotglob = 82
  execfail = 83
  extdebug = 84
  extquote = 85
  force_fignore = 86
  globasciiranges = 87
  globstar = 88
  gnu_errfmt = 89
  histreedit = 90
  histverify = 91
  huponexit = 92
  interactive_comments = 93
  lithist = 94
  localvar_inherit = 95
  localvar_unset = 96
  login_shell = 97
  mailwarn = 98
  no_empty_cmd_completion = 99
  nocaseglob = 100
  progcomp_alias = 101
  promptvars = 102
  restricted_shell = 103
  shift_verbose = 104
  sourcepath = 105
  xpg_echo = 106
  ARRAY_SIZE = 107

_option_str = {
  1: 'option.errexit',
  2: 'option.nounset',
  3: 'option.pipefail',
  4: 'option.inherit_errexit',
  5: 'option.nullglob',
  6: 'option.verbose_errexit',
  7: 'option.noexec',
  8: 'option.xtrace',
  9: 'option.verbose',
  10: 'option.noglob',
  11: 'option.noclobber',
  12: 'option.posix',
  13: 'option.vi',
  14: 'option.emacs',
  15: 'option.interactive',
  16: 'option.hashall',
  17: 'option.failglob',
  18: 'option.extglob',
  19: 'option.nocasematch',
  20: 'option.eval_unsafe_arith',
  21: 'option._allow_command_sub',
  22: 'option._allow_process_sub',
  23: 'option.dynamic_scope',
  24: 'option.redefine_module',
  25: 'option._running_trap',
  26: 'option._running_hay',
  27: 'option._no_debug_trap',
  28: 'option.strict_argv',
  29: 'option.strict_arith',
  30: 'option.strict_array',
  31: 'option.strict_control_flow',
  32: 'option.strict_errexit',
  33: 'option.strict_nameref',
  34: 'option.strict_word_eval',
  35: 'option.strict_tilde',
  36: 'option.strict_glob',
  37: 'option.parse_at',
  38: 'option.parse_proc',
  39: 'option.parse_func',
  40: 'option.parse_brace',
  41: 'option.parse_bracket',
  42: 'option.parse_equals',
  43: 'option.parse_paren',
  44: 'option.parse_ysh_string',
  45: 'option.parse_triple_quote',
  46: 'option.simple_word_eval',
  47: 'option.dashglob',
  48: 'option.command_sub_errexit',
  49: 'option.process_sub_fail',
  50: 'option.xtrace_rich',
  51: 'option.xtrace_details',
  52: 'option.sigpipe_status_ok',
  53: 'option.redefine_proc_func',
  54: 'option.parse_at_all',
  55: 'option.parse_backslash',
  56: 'option.parse_backticks',
  57: 'option.parse_dollar',
  58: 'option.parse_ignored',
  59: 'option.parse_sh_arith',
  60: 'option.parse_dparen',
  61: 'option.parse_dbracket',
  62: 'option.parse_bare_word',
  63: 'option.simple_echo',
  64: 'option.simple_eval_builtin',
  65: 'option.simple_test_builtin',
  66: 'option.expand_aliases',
  67: 'option.lastpipe',
  68: 'option.progcomp',
  69: 'option.histappend',
  70: 'option.hostcomplete',
  71: 'option.cmdhist',
  72: 'option.assoc_expand_once',
  73: 'option.autocd',
  74: 'option.cdable_vars',
  75: 'option.cdspell',
  76: 'option.checkhash',
  77: 'option.checkjobs',
  78: 'option.checkwinsize',
  79: 'option.complete_fullquote',
  80: 'option.direxpand',
  81: 'option.dirspell',
  82: 'option.dotglob',
  83: 'option.execfail',
  84: 'option.extdebug',
  85: 'option.extquote',
  86: 'option.force_fignore',
  87: 'option.globasciiranges',
  88: 'option.globstar',
  89: 'option.gnu_errfmt',
  90: 'option.histreedit',
  91: 'option.histverify',
  92: 'option.huponexit',
  93: 'option.interactive_comments',
  94: 'option.lithist',
  95: 'option.localvar_inherit',
  96: 'option.localvar_unset',
  97: 'option.login_shell',
  98: 'option.mailwarn',
  99: 'option.no_empty_cmd_completion',
  100: 'option.nocaseglob',
  101: 'option.progcomp_alias',
  102: 'option.promptvars',
  103: 'option.restricted_shell',
  104: 'option.shift_verbose',
  105: 'option.sourcepath',
  106: 'option.xpg_echo',
}

def option_str(val):
  # type: (option_t) -> str
  return _option_str[val]

builtin_t = int  # type alias for integer

class builtin_i(object):
  colon = 1
  dot = 2
  exec_ = 3
  eval = 4
  set = 5
  shift = 6
  times = 7
  trap = 8
  unset = 9
  builtin = 10
  readonly = 11
  local = 12
  declare = 13
  typeset = 14
  export_ = 15
  true_ = 16
  false_ = 17
  try_ = 18
  read = 19
  echo = 20
  printf = 21
  mapfile = 22
  readarray = 23
  cd = 24
  pushd = 25
  popd = 26
  dirs = 27
  pwd = 28
  source = 29
  umask = 30
  ulimit = 31
  wait = 32
  jobs = 33
  fg = 34
  bg = 35
  shopt = 36
  complete = 37
  compgen = 38
  compopt = 39
  compadjust = 40
  compexport = 41
  getopts = 42
  command = 43
  type = 44
  hash = 45
  help = 46
  history = 47
  alias = 48
  unalias = 49
  bind = 50
  append = 51
  write = 52
  json = 53
  json8 = 54
  pp = 55
  hay = 56
  haynode = 57
  module = 58
  use = 59
  error = 60
  fork = 61
  forkwait = 62
  fopen = 63
  shvar = 64
  ctx = 65
  runproc = 66
  boolstatus = 67
  test = 68
  bracket = 69
  push_registers = 70
  is_main = 71
  cat = 72
  ARRAY_SIZE = 73

_builtin_str = {
  1: 'builtin.colon',
  2: 'builtin.dot',
  3: 'builtin.exec_',
  4: 'builtin.eval',
  5: 'builtin.set',
  6: 'builtin.shift',
  7: 'builtin.times',
  8: 'builtin.trap',
  9: 'builtin.unset',
  10: 'builtin.builtin',
  11: 'builtin.readonly',
  12: 'builtin.local',
  13: 'builtin.declare',
  14: 'builtin.typeset',
  15: 'builtin.export_',
  16: 'builtin.true_',
  17: 'builtin.false_',
  18: 'builtin.try_',
  19: 'builtin.read',
  20: 'builtin.echo',
  21: 'builtin.printf',
  22: 'builtin.mapfile',
  23: 'builtin.readarray',
  24: 'builtin.cd',
  25: 'builtin.pushd',
  26: 'builtin.popd',
  27: 'builtin.dirs',
  28: 'builtin.pwd',
  29: 'builtin.source',
  30: 'builtin.umask',
  31: 'builtin.ulimit',
  32: 'builtin.wait',
  33: 'builtin.jobs',
  34: 'builtin.fg',
  35: 'builtin.bg',
  36: 'builtin.shopt',
  37: 'builtin.complete',
  38: 'builtin.compgen',
  39: 'builtin.compopt',
  40: 'builtin.compadjust',
  41: 'builtin.compexport',
  42: 'builtin.getopts',
  43: 'builtin.command',
  44: 'builtin.type',
  45: 'builtin.hash',
  46: 'builtin.help',
  47: 'builtin.history',
  48: 'builtin.alias',
  49: 'builtin.unalias',
  50: 'builtin.bind',
  51: 'builtin.append',
  52: 'builtin.write',
  53: 'builtin.json',
  54: 'builtin.json8',
  55: 'builtin.pp',
  56: 'builtin.hay',
  57: 'builtin.haynode',
  58: 'builtin.module',
  59: 'builtin.use',
  60: 'builtin.error',
  61: 'builtin.fork',
  62: 'builtin.forkwait',
  63: 'builtin.fopen',
  64: 'builtin.shvar',
  65: 'builtin.ctx',
  66: 'builtin.runproc',
  67: 'builtin.boolstatus',
  68: 'builtin.test',
  69: 'builtin.bracket',
  70: 'builtin.push_registers',
  71: 'builtin.is_main',
  72: 'builtin.cat',
}

def builtin_str(val):
  # type: (builtin_t) -> str
  return _builtin_str[val]

