from asdl import pybase

option_t = int  # type alias for integer

class option_i(object):
  errexit = 1
  nounset = 2
  pipefail = 3
  inherit_errexit = 4
  nullglob = 5
  verbose_errexit = 6
  noexec = 7
  xtrace = 8
  verbose = 9
  noglob = 10
  noclobber = 11
  posix = 12
  vi = 13
  emacs = 14
  interactive = 15
  hashall = 16
  failglob = 17
  extglob = 18
  nocasematch = 19
  eval_unsafe_arith = 20
  _allow_command_sub = 21
  _allow_process_sub = 22
  dynamic_scope = 23
  redefine_module = 24
  _running_trap = 25
  _running_hay = 26
  _no_debug_trap = 27
  strict_argv = 28
  strict_arith = 29
  strict_array = 30
  strict_control_flow = 31
  strict_errexit = 32
  strict_nameref = 33
  strict_word_eval = 34
  strict_tilde = 35
  strict_glob = 36
  parse_at = 37
  parse_proc = 38
  parse_func = 39
  parse_brace = 40
  parse_bracket = 41
  parse_equals = 42
  parse_paren = 43
  parse_ysh_string = 44
  parse_triple_quote = 45
  simple_word_eval = 46
  dashglob = 47
  expand_aliases = 48
  command_sub_errexit = 49
  process_sub_fail = 50
  xtrace_rich = 51
  xtrace_details = 52
  sigpipe_status_ok = 53
  redefine_proc_func = 54
  parse_at_all = 55
  parse_backslash = 56
  parse_backticks = 57
  parse_dollar = 58
  parse_ignored = 59
  parse_sh_arith = 60
  parse_dparen = 61
  parse_bare_word = 62
  simple_echo = 63
  simple_eval_builtin = 64
  simple_test_builtin = 65
  lastpipe = 66
  progcomp = 67
  histappend = 68
  hostcomplete = 69
  cmdhist = 70
  assoc_expand_once = 71
  autocd = 72
  cdable_vars = 73
  cdspell = 74
  checkhash = 75
  checkjobs = 76
  checkwinsize = 77
  complete_fullquote = 78
  direxpand = 79
  dirspell = 80
  dotglob = 81
  execfail = 82
  extdebug = 83
  extquote = 84
  force_fignore = 85
  globasciiranges = 86
  globstar = 87
  gnu_errfmt = 88
  histreedit = 89
  histverify = 90
  huponexit = 91
  interactive_comments = 92
  lithist = 93
  localvar_inherit = 94
  localvar_unset = 95
  login_shell = 96
  mailwarn = 97
  no_empty_cmd_completion = 98
  nocaseglob = 99
  progcomp_alias = 100
  promptvars = 101
  restricted_shell = 102
  shift_verbose = 103
  sourcepath = 104
  xpg_echo = 105
  ARRAY_SIZE = 106

_option_str = {
  1: 'option.errexit',
  2: 'option.nounset',
  3: 'option.pipefail',
  4: 'option.inherit_errexit',
  5: 'option.nullglob',
  6: 'option.verbose_errexit',
  7: 'option.noexec',
  8: 'option.xtrace',
  9: 'option.verbose',
  10: 'option.noglob',
  11: 'option.noclobber',
  12: 'option.posix',
  13: 'option.vi',
  14: 'option.emacs',
  15: 'option.interactive',
  16: 'option.hashall',
  17: 'option.failglob',
  18: 'option.extglob',
  19: 'option.nocasematch',
  20: 'option.eval_unsafe_arith',
  21: 'option._allow_command_sub',
  22: 'option._allow_process_sub',
  23: 'option.dynamic_scope',
  24: 'option.redefine_module',
  25: 'option._running_trap',
  26: 'option._running_hay',
  27: 'option._no_debug_trap',
  28: 'option.strict_argv',
  29: 'option.strict_arith',
  30: 'option.strict_array',
  31: 'option.strict_control_flow',
  32: 'option.strict_errexit',
  33: 'option.strict_nameref',
  34: 'option.strict_word_eval',
  35: 'option.strict_tilde',
  36: 'option.strict_glob',
  37: 'option.parse_at',
  38: 'option.parse_proc',
  39: 'option.parse_func',
  40: 'option.parse_brace',
  41: 'option.parse_bracket',
  42: 'option.parse_equals',
  43: 'option.parse_paren',
  44: 'option.parse_ysh_string',
  45: 'option.parse_triple_quote',
  46: 'option.simple_word_eval',
  47: 'option.dashglob',
  48: 'option.expand_aliases',
  49: 'option.command_sub_errexit',
  50: 'option.process_sub_fail',
  51: 'option.xtrace_rich',
  52: 'option.xtrace_details',
  53: 'option.sigpipe_status_ok',
  54: 'option.redefine_proc_func',
  55: 'option.parse_at_all',
  56: 'option.parse_backslash',
  57: 'option.parse_backticks',
  58: 'option.parse_dollar',
  59: 'option.parse_ignored',
  60: 'option.parse_sh_arith',
  61: 'option.parse_dparen',
  62: 'option.parse_bare_word',
  63: 'option.simple_echo',
  64: 'option.simple_eval_builtin',
  65: 'option.simple_test_builtin',
  66: 'option.lastpipe',
  67: 'option.progcomp',
  68: 'option.histappend',
  69: 'option.hostcomplete',
  70: 'option.cmdhist',
  71: 'option.assoc_expand_once',
  72: 'option.autocd',
  73: 'option.cdable_vars',
  74: 'option.cdspell',
  75: 'option.checkhash',
  76: 'option.checkjobs',
  77: 'option.checkwinsize',
  78: 'option.complete_fullquote',
  79: 'option.direxpand',
  80: 'option.dirspell',
  81: 'option.dotglob',
  82: 'option.execfail',
  83: 'option.extdebug',
  84: 'option.extquote',
  85: 'option.force_fignore',
  86: 'option.globasciiranges',
  87: 'option.globstar',
  88: 'option.gnu_errfmt',
  89: 'option.histreedit',
  90: 'option.histverify',
  91: 'option.huponexit',
  92: 'option.interactive_comments',
  93: 'option.lithist',
  94: 'option.localvar_inherit',
  95: 'option.localvar_unset',
  96: 'option.login_shell',
  97: 'option.mailwarn',
  98: 'option.no_empty_cmd_completion',
  99: 'option.nocaseglob',
  100: 'option.progcomp_alias',
  101: 'option.promptvars',
  102: 'option.restricted_shell',
  103: 'option.shift_verbose',
  104: 'option.sourcepath',
  105: 'option.xpg_echo',
}

def option_str(val):
  # type: (option_t) -> str
  return _option_str[val]

builtin_t = int  # type alias for integer

class builtin_i(object):
  colon = 1
  dot = 2
  exec_ = 3
  eval = 4
  set = 5
  shift = 6
  times = 7
  trap = 8
  unset = 9
  builtin = 10
  readonly = 11
  local = 12
  declare = 13
  typeset = 14
  export_ = 15
  true_ = 16
  false_ = 17
  try_ = 18
  read = 19
  echo = 20
  printf = 21
  mapfile = 22
  readarray = 23
  cd = 24
  pushd = 25
  popd = 26
  dirs = 27
  pwd = 28
  source = 29
  umask = 30
  wait = 31
  jobs = 32
  fg = 33
  bg = 34
  shopt = 35
  complete = 36
  compgen = 37
  compopt = 38
  compadjust = 39
  compexport = 40
  getopts = 41
  command = 42
  type = 43
  hash = 44
  help = 45
  history = 46
  alias = 47
  unalias = 48
  bind = 49
  append = 50
  write = 51
  json = 52
  json8 = 53
  pp = 54
  hay = 55
  haynode = 56
  module = 57
  use = 58
  error = 59
  fork = 60
  forkwait = 61
  fopen = 62
  shvar = 63
  ctx = 64
  runproc = 65
  boolstatus = 66
  test = 67
  bracket = 68
  push_registers = 69
  is_main = 70
  cat = 71
  ARRAY_SIZE = 72

_builtin_str = {
  1: 'builtin.colon',
  2: 'builtin.dot',
  3: 'builtin.exec_',
  4: 'builtin.eval',
  5: 'builtin.set',
  6: 'builtin.shift',
  7: 'builtin.times',
  8: 'builtin.trap',
  9: 'builtin.unset',
  10: 'builtin.builtin',
  11: 'builtin.readonly',
  12: 'builtin.local',
  13: 'builtin.declare',
  14: 'builtin.typeset',
  15: 'builtin.export_',
  16: 'builtin.true_',
  17: 'builtin.false_',
  18: 'builtin.try_',
  19: 'builtin.read',
  20: 'builtin.echo',
  21: 'builtin.printf',
  22: 'builtin.mapfile',
  23: 'builtin.readarray',
  24: 'builtin.cd',
  25: 'builtin.pushd',
  26: 'builtin.popd',
  27: 'builtin.dirs',
  28: 'builtin.pwd',
  29: 'builtin.source',
  30: 'builtin.umask',
  31: 'builtin.wait',
  32: 'builtin.jobs',
  33: 'builtin.fg',
  34: 'builtin.bg',
  35: 'builtin.shopt',
  36: 'builtin.complete',
  37: 'builtin.compgen',
  38: 'builtin.compopt',
  39: 'builtin.compadjust',
  40: 'builtin.compexport',
  41: 'builtin.getopts',
  42: 'builtin.command',
  43: 'builtin.type',
  44: 'builtin.hash',
  45: 'builtin.help',
  46: 'builtin.history',
  47: 'builtin.alias',
  48: 'builtin.unalias',
  49: 'builtin.bind',
  50: 'builtin.append',
  51: 'builtin.write',
  52: 'builtin.json',
  53: 'builtin.json8',
  54: 'builtin.pp',
  55: 'builtin.hay',
  56: 'builtin.haynode',
  57: 'builtin.module',
  58: 'builtin.use',
  59: 'builtin.error',
  60: 'builtin.fork',
  61: 'builtin.forkwait',
  62: 'builtin.fopen',
  63: 'builtin.shvar',
  64: 'builtin.ctx',
  65: 'builtin.runproc',
  66: 'builtin.boolstatus',
  67: 'builtin.test',
  68: 'builtin.bracket',
  69: 'builtin.push_registers',
  70: 'builtin.is_main',
  71: 'builtin.cat',
}

def builtin_str(val):
  # type: (builtin_t) -> str
  return _builtin_str[val]

