!! Copyright (C) 2010 X. Andrade
!!
!! This program is free software; you can redistribute it and/or modify
!! it under the terms of the GNU General Public License as published by
!! the Free Software Foundation; either version 2, or (at your option)
!! any later version.
!!
!! This program is distributed in the hope that it will be useful,
!! but WITHOUT ANY WARRANTY; without even the implied warranty of
!! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!! GNU General Public License for more details.
!!
!! You should have received a copy of the GNU General Public License
!! along with this program; if not, write to the Free Software
!! Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
!! 02110-1301, USA.
!!
!! $Id: opencl_inc.F90 11591 2013-12-17 09:10:32Z joseba $


subroutine X(opencl_write_buffer_1)(this, size, data, offset)
  type(opencl_mem_t),               intent(inout) :: this
  integer,                          intent(in)    :: size
  R_TYPE,                           intent(in)    :: data(:)
  integer,                optional, intent(in)    :: offset

  integer(8) :: fsize, offset_
  integer :: ierr

  PUSH_SUB(X(opencl_write_buffer_1))
  call profiling_in(prof_write, "CL_WRITE_BUFFER")

  ! it does not make sense to write a buffer that the kernels cannot read
  ASSERT(this%flags /= CL_MEM_WRITE_ONLY)

  fsize = int(size,8)*R_SIZEOF
  offset_ = 0
  if(present(offset)) offset_ = int(offset, 8)*R_SIZEOF

  ASSERT(fsize >= 0)

#ifdef HAVE_OPENCL
  call clEnqueueWriteBuffer(opencl%command_queue, this%mem, cl_bool(.true.), offset_, fsize, data(1), ierr)
#endif

  if(ierr /= CL_SUCCESS) call opencl_print_error(ierr, "EnqueueWriteBuffer")

  call profiling_count_transfers(size, data(1))
  call opencl_finish()
  call profiling_out(prof_write)
  POP_SUB(X(opencl_write_buffer_1))

end subroutine X(opencl_write_buffer_1)

! -----------------------------------------------------------------------------

subroutine X(opencl_write_buffer_2)(this, size, data, offset)
  type(opencl_mem_t),               intent(inout) :: this
  integer,                          intent(in)    :: size
  R_TYPE,                           intent(in)    :: data(:, :)
  integer,                optional, intent(in)    :: offset

  integer(8) :: fsize, offset_
  integer :: ierr

  PUSH_SUB(X(opencl_write_buffer_2))
  call profiling_in(prof_write, "CL_WRITE_BUFFER")

  ! it does not make sense to write a buffer that the kernels cannot read
  ASSERT(this%flags /= CL_MEM_WRITE_ONLY)

  fsize = int(size, 8)*R_SIZEOF
  offset_ = 0
  if(present(offset)) offset_ = int(offset, 8)*R_SIZEOF

#ifdef HAVE_OPENCL
  call clEnqueueWriteBuffer(opencl%command_queue, this%mem, cl_bool(.true.), offset_, fsize, data(1, 1), ierr)
#endif

  if(ierr /= CL_SUCCESS) call opencl_print_error(ierr, "EnqueueWriteBuffer")

  call profiling_count_transfers(size, data(1, 1))
  call opencl_finish()
  call profiling_out(prof_write)
  POP_SUB(X(opencl_write_buffer_2))

end subroutine X(opencl_write_buffer_2)

! -----------------------------------------------------------------------------

subroutine X(opencl_write_buffer_3)(this, size, data, offset)
  type(opencl_mem_t),               intent(inout) :: this
  integer,                          intent(in)    :: size
  R_TYPE,                           intent(in)    :: data(:, :, :)
  integer,                optional, intent(in)    :: offset

  integer(8) :: fsize, offset_
  integer :: ierr

  PUSH_SUB(X(opencl_write_buffer_3))
  call profiling_in(prof_write, "CL_WRITE_BUFFER")

  ! it does not make sense to write a buffer that the kernels cannot read
  ASSERT(this%flags /= CL_MEM_WRITE_ONLY)

  fsize = int(size, 8)*R_SIZEOF
  offset_ = 0
  if(present(offset)) offset_ = int(offset, 8)*R_SIZEOF

#ifdef HAVE_OPENCL
  call clEnqueueWriteBuffer(opencl%command_queue, this%mem, cl_bool(.true.), offset_, fsize, data(1, 1, 1), ierr)
#endif

  if(ierr /= CL_SUCCESS) call opencl_print_error(ierr, "EnqueueWriteBuffer")
  
  call profiling_count_transfers(size, data(1, 1, 1))
  call opencl_finish()
  call profiling_out(prof_write)
  POP_SUB(X(opencl_write_buffer_3))

end subroutine X(opencl_write_buffer_3)

! -----------------------------------------------------------------------------

subroutine X(opencl_read_buffer_1)(this, size, data, offset)
  type(opencl_mem_t),               intent(in)    :: this
  integer,                          intent(in)    :: size
  R_TYPE,                           intent(out)   :: data(:)
  integer,                optional, intent(in)    :: offset

  integer(8) :: fsize, offset_
  integer :: ierr

  PUSH_SUB(X(opencl_read_buffer_1))
  call profiling_in(prof_read, "CL_READ_BUFFER")

  ! it does not make sense to read a buffer that the kernels cannot write
  ASSERT(this%flags /= CL_MEM_READ_ONLY)

  fsize = size*R_SIZEOF
  offset_ = 0
  if(present(offset)) offset_ = offset*R_SIZEOF

#ifdef HAVE_OPENCL
  call clEnqueueReadBuffer(opencl%command_queue, this%mem, cl_bool(.true.), offset_, fsize, data(1), ierr)
#endif
  if(ierr /= CL_SUCCESS) call opencl_print_error(ierr, "EnqueueReadBuffer")

  call profiling_count_transfers(size, data(1))
  call opencl_finish()
  call profiling_out(prof_read)
  POP_SUB(X(opencl_read_buffer_1))

end subroutine X(opencl_read_buffer_1)

! ---------------------------------------------------------------------------

subroutine X(opencl_read_buffer_2)(this, size, data, offset)
  type(opencl_mem_t),               intent(in)    :: this
  integer,                          intent(in)    :: size
  R_TYPE,                           intent(out)   :: data(:, :)
  integer,                optional, intent(in)    :: offset

  integer(8) :: fsize, offset_
  integer :: ierr
  
  PUSH_SUB(X(opencl_read_buffer_2))
  call profiling_in(prof_read, "CL_READ_BUFFER")

  ! it does not make sense to read a buffer that the kernels cannot write
  ASSERT(this%flags /= CL_MEM_READ_ONLY)

  fsize = size*R_SIZEOF
  offset_ = 0
  if(present(offset)) offset_ = offset*R_SIZEOF

#ifdef HAVE_OPENCL
  call clEnqueueReadBuffer(opencl%command_queue, this%mem, cl_bool(.true.), offset_, fsize, data(1, 1), ierr)
#endif
  if(ierr /= CL_SUCCESS) call opencl_print_error(ierr, "EnqueueReadBuffer")

  call profiling_count_transfers(size, data(1, 1))
  call opencl_finish()
  
  call profiling_out(prof_read)
  POP_SUB(X(opencl_read_buffer_2))
  
end subroutine X(opencl_read_buffer_2)

! ---------------------------------------------------------------------------

subroutine X(opencl_read_buffer_3)(this, size, data, offset)
  type(opencl_mem_t),               intent(in)    :: this
  integer,                          intent(in)    :: size
  R_TYPE,                           intent(out)   :: data(:, :, :)
  integer,                optional, intent(in)    :: offset

  integer(8) :: fsize, offset_
  integer :: ierr
  
  PUSH_SUB(X(opencl_read_buffer_3))
  call profiling_in(prof_read, "CL_READ_BUFFER")

  ! it does not make sense to read a buffer that the kernels cannot write
  ASSERT(this%flags /= CL_MEM_READ_ONLY)

  fsize = size*R_SIZEOF
  offset_ = 0
  if(present(offset)) offset_ = offset*R_SIZEOF

#ifdef HAVE_OPENCL
  call clEnqueueReadBuffer(opencl%command_queue, this%mem, cl_bool(.true.), offset_, fsize, data(1, 1, 1), ierr)
#endif
  if(ierr /= CL_SUCCESS) call opencl_print_error(ierr, "EnqueueReadBuffer")

  call profiling_count_transfers(size, data(1, 1, 1))
  call opencl_finish()
  call profiling_out(prof_read)
  POP_SUB(X(opencl_read_buffer_3))
  
end subroutine X(opencl_read_buffer_3)

! ---------------------------------------------------------------------------

subroutine X(opencl_set_kernel_arg_data)(kernel, narg, data)
  type(cl_kernel),    intent(inout) :: kernel
  integer,            intent(in)    :: narg
  R_TYPE,             intent(in)    :: data
  
  integer :: ierr

  ! no push_sub, called too frequently

#ifdef HAVE_OPENCL
  call clSetKernelArg(kernel, narg, data, ierr)
#endif
  if(ierr /= CL_SUCCESS) call opencl_print_error(ierr, "set_kernel_arg_data")

end subroutine X(opencl_set_kernel_arg_data)


!! Local Variables:
!! mode: f90
!! coding: utf-8
!! End:
