function cmap = velasColormap(cmapname,varargin)

%{
        inputs:
               cmapname, the name of colormap, 'viridis' (default).
               flipflag, determine whether to flip the colormap, flipflag = false.
        outputs:
               cmap: the corresponding colormap.

        cmapname: cmapname must be char! Can be: 'viridis' (default) 'inferno'	'plasma'	'magma'	'rocket'	'mako'	'flare'	'crest'	'vlag'	'icefire'	'Spectral'	'coolwarm'	'cool'	'summer'	'copper'
                                                 'hot'	'ocean'	'gray'	'bone'	'pink'	'spring'	'autumn'	'winter'	'thermal'	'haline'	'solar'	'ice'	'deep'	'dense'	'algae'	'matter'	'turbid'
	                                               'speed'	'amp'	'tempo'	'rain'	'phase'	'balance'	'delta'	'curl'	'diff'	'tarn'	'cubehelix'	'turbo'	'Blues'	'BuGn'	'BuPu'	'GnBu'	'Greens'	'Greys'
                                                 'Oranges'	'OrRd'	'PuBu'	'PuBuGn'	'PuRd'	'Purples'	'RdPu'	'Reds'	'YlGn'	'YlGnBu'	'YlOrBr'	'YlOrRd'	'afmhot'	'gistheat'	'BrBG'	'bwr'
                                                 'coolwarmC'	'PiYG'	'PRGn' 'PuOr'	'RdBu'	'RdGy'	'RdYlBu'	'RdYlGn'	'seismic'.

        (Note: If you enter an option other than the one above, it will return to the default "jet".)
        The colormap data export from GUN Octave.

        if you use this data your work, please cite GNU Octave in publications use:

        John W. Eaton, David Bateman, Søren Hauberg, Rik Wehbring (2022).
        GNU Octave version 7.1.0 manual: a high-level interactive language for numerical computations.
        URL https://www.gnu.org/software/octave/doc/v7.1.0/

        A BibTeX entry for LaTeX users is:

        @manual{,
         title     = {{GNU Octave} version 7.1.0 manual: a high-level interactive language for numerical computations},
         author    = {John W. Eaton and David Bateman and S{\o}ren Hauberg and Rik Wehbring},
         year      = {2022},
         url       = {https://www.gnu.org/software/octave/doc/v7.1.0/},
       }

       Default Colormap: % 'viridis' (default)

       [1] The color maps viridis, magma, inferno, and plasma were created by Stéfan van der Walt ([@stefanv](https://github.com/stefanv))
       and Nathaniel Smith ([@njsmith](https://github.com/njsmith)).

       [2] Please cite the following paper if you use "cubehelix" in any publications:
       Green, D. A., 2011,  A colour scheme for the display of astronomical intensity images , Bulletin of the Astronomical Society of India, 39, 289.

       [3] A collection of colormaps from https://matplotlib.org/cmocean/
       cmocean: 'thermal'  'haline'  'solar'  'ice'  'deep'  'dense'  'algae'  'matter'  'turbid'  'speed'  'amp'  'tempo'  'rain'  'phase'  'balance'  'delta'  'curl'  'diff'  'tarn'
       Please cite the following paper if you use "cmocean" colormap sets in any publications:
        Thyng, K. M., Greene, C. A., Hetland, R. D., Zimmerle, H. M., & DiMarco, S. F. (2016). True colors of oceanography. Oceanography, 29(3), 10.

       [4] A collection of colormaps from https://seaborn.pydata.org/
       seaborn: ["rocket", "mako", "flare", "crest", "vlag", "icefire", "Spectral", "coolwarm"]
       Please cite the following paper if you use 'seaborn' colormap sets in any publications:
       Waskom, M. L., (2021). seaborn: statistical data visualization. Journal of Open Source Software, 6(60), 3021, https://doi.org/10.21105/joss.03021

       [5] A collection of colormaps from https://www.fabiocrameri.ch/colourmaps/
       Scientific colourmaps:
       Please cite the following paper if you use 'Scientific colourmaps' sets in any publications:
       Crameri, F. (2018). Scientific colour-maps. Zenodo. http://doi.org/10.5281/zenodo.1243862
       Crameri, F. (2018), Geodynamic diagnostics, scientific visualisation and StagLab 3.0, Geosci. Model Dev., 11, 2541-2562, doi:10.5194/gmd-11-2541-2018.

%}

narginchk(0,2);

switch(nargin)
    case 0
        cmapname = 'viridis';
        flipflag = false;
    case 1
        if ~ischar(cmapname)
            cmapname = 'viridis';
        end
        flipflag = false;
    case 2
        if ~ischar(cmapname)
            cmapname = 'viridis';
        end
        tflag = varargin{1};
        if ~islogical(tflag)
            flipflag = false;
        else
            flipflag = tflag;
        end
    otherwise
        cmapname = 'viridis';
        flipflag = false;
end

if exist('velasColormap.mat','file')
    tcmap = load('velasColormap.mat',cmapname);
    cmap  = tcmap.(cmapname);
else
    % 'viridis' (default)
    cmap = [0.267000000000000	0.00487430000000000	0.329420000000000
        0.268395882352941	0.0100555435294118	0.335337058823529
        0.269791764705882	0.0152367870588235	0.341254117647059
        0.271187647058824	0.0204180305882353	0.347171176470588
        0.272583529411765	0.0255992741176471	0.353088235294118
        0.273699411764706	0.0317443529411765	0.358751176470588
        0.274801294117647	0.0379376235294118	0.364401411764706
        0.275903176470588	0.0441308941176471	0.370051647058824
        0.277005058823529	0.0503241647058824	0.375701882352941
        0.277836470588235	0.0561193294117647	0.381081647058824
        0.278639411764706	0.0618725882352941	0.386432941176471
        0.279442352941177	0.0676258470588235	0.391784235294118
        0.280245294117647	0.0733791058823530	0.397135529411765
        0.280789882352941	0.0788075176470588	0.402209411764706
        0.281291411764706	0.0841817882352941	0.407237058823529
        0.281792941176471	0.0895560588235294	0.412264705882353
        0.282294470588235	0.0949303294117647	0.417292352941176
        0.282552000000000	0.100141200000000	0.422036000000000
        0.282752117647059	0.105313623529412	0.426712823529412
        0.282952235294118	0.110486047058824	0.431389647058824
        0.283152352941176	0.115658470588235	0.436066470588235
        0.283126588235294	0.120741294117647	0.440459058823529
        0.283030235294118	0.125796117647059	0.444762823529412
        0.282933882352941	0.130850941176471	0.449066588235294
        0.282837529411765	0.135905764705882	0.453370352941177
        0.282531176470588	0.140902352941176	0.457393529411765
        0.282140823529412	0.145875647058824	0.461304470588235
        0.281750470588235	0.150848941176471	0.465215411764706
        0.281360117647059	0.155822235294118	0.469126352941177
        0.280783647058824	0.160752705882353	0.472772117647059
        0.280114117647059	0.165661764705882	0.476285294117647
        0.279444588235294	0.170570823529412	0.479798470588235
        0.278775058823529	0.175479882352941	0.483311647058824
        0.277941882352941	0.180350705882353	0.486577058823529
        0.277008000000000	0.185198000000000	0.489690000000000
        0.276074117647059	0.190045294117647	0.492802941176471
        0.275140235294118	0.194892588235294	0.495915882352941
        0.274068000000000	0.199703176470588	0.498802941176471
        0.272892000000000	0.204486235294118	0.501520588235294
        0.271716000000000	0.209269294117647	0.504238235294118
        0.270540000000000	0.214052352941176	0.506955882352941
        0.269254000000000	0.218797882352941	0.509476823529412
        0.267868000000000	0.223509294117647	0.511818941176471
        0.266482000000000	0.228220705882353	0.514161058823530
        0.265096000000000	0.232932117647059	0.516503176470588
        0.263624117647059	0.237607058823529	0.518677058823529
        0.262057764705882	0.242241882352941	0.520665882352941
        0.260491411764706	0.246876705882353	0.522654705882353
        0.258925058823529	0.251511529411765	0.524643529411765
        0.257296235294118	0.256109294117647	0.526493647058824
        0.255584117647059	0.260657647058824	0.528158823529412
        0.253872000000000	0.265206000000000	0.529824000000000
        0.252159882352941	0.269754352941176	0.531489176470588
        0.250406352941176	0.274268823529412	0.533045176470588
        0.248585529411765	0.278728235294118	0.534423764705882
        0.246764705882353	0.283187647058824	0.535802352941177
        0.244943882352941	0.287647058823529	0.537180941176471
        0.243099176470588	0.292075176470588	0.538474705882353
        0.241206705882353	0.296440705882353	0.539598823529412
        0.239314235294118	0.300806235294118	0.540722941176471
        0.237421764705882	0.305171764705882	0.541847058823529
        0.235518705882353	0.309511176470588	0.542910470588235
        0.233589176470588	0.313785294117647	0.543822117647059
        0.231659647058824	0.318059411764706	0.544733764705882
        0.229730117647059	0.322333529411765	0.545645411764706
        0.227798823529412	0.326585882352941	0.546513529411765
        0.225861882352941	0.330768588235294	0.547242352941177
        0.223924941176471	0.334951294117647	0.547971176470588
        0.221988000000000	0.339134000000000	0.548700000000000
        0.220055294117647	0.343300235294118	0.549400588235294
        0.218140588235294	0.347396470588235	0.549981176470588
        0.216225882352941	0.351492705882353	0.550561764705882
        0.214311176470588	0.355588941176471	0.551142352941177
        0.212402117647059	0.359674235294118	0.551705294117647
        0.210526941176471	0.363693882352941	0.552162352941177
        0.208651764705882	0.367713529411765	0.552619411764706
        0.206776588235294	0.371733176470588	0.553076470588235
        0.204906823529412	0.375745764705882	0.553524352941177
        0.203088470588235	0.379691294117647	0.553885058823530
        0.201270117647059	0.383636823529412	0.554245764705882
        0.199451764705882	0.387582352941177	0.554606470588235
        0.197636588235294	0.391524941176471	0.554963411764706
        0.195884941176471	0.395408705882353	0.555245058823530
        0.194133294117647	0.399292470588235	0.555526705882353
        0.192381647058824	0.403176235294118	0.555808352941177
        0.190630000000000	0.407060000000000	0.556090000000000
        0.188947529411765	0.410889411764706	0.556302470588235
        0.187265058823529	0.414718823529412	0.556514941176471
        0.185582588235294	0.418548235294118	0.556727411764706
        0.183900117647059	0.422377647058824	0.556939882352941
        0.182278823529412	0.426167058823529	0.557098235294118
        0.180660588235294	0.429954470588235	0.557253882352941
        0.179042352941176	0.433741882352941	0.557409529411765
        0.177424117647059	0.437529294117647	0.557565176470588
        0.175859529411765	0.441280941176471	0.557667176470588
        0.174300588235294	0.445028823529412	0.557763529411765
        0.172741647058824	0.448776705882353	0.557859882352941
        0.171182705882353	0.452524588235294	0.557956235294118
        0.169661882352941	0.456251294117647	0.558006000000000
        0.168147411764706	0.459974470588235	0.558048000000000
        0.166632941176471	0.463697647058824	0.558090000000000
        0.165118470588235	0.467420823529412	0.558132000000000
        0.163634000000000	0.471128000000000	0.558124000000000
        0.162156588235294	0.474831411764706	0.558104235294118
        0.160679176470588	0.478534823529412	0.558084470588235
        0.159201764705882	0.482238235294118	0.558064705882353
        0.157739411764706	0.485930352941177	0.557988470588235
        0.156281764705882	0.489618941176471	0.557894588235294
        0.154824117647059	0.493307529411765	0.557800705882353
        0.153366470588235	0.496996117647059	0.557706823529412
        0.151922941176471	0.500681176470588	0.557554705882353
        0.150485058823529	0.504364823529412	0.557379294117647
        0.149047176470588	0.508048470588235	0.557203882352941
        0.147609294117647	0.511732117647059	0.557028470588235
        0.146186235294118	0.515412470588235	0.556787176470588
        0.144770588235294	0.519091176470588	0.556512941176471
        0.143354941176471	0.522769882352941	0.556238705882353
        0.141939294117647	0.526448588235294	0.555964470588235
        0.140548117647059	0.530128823529412	0.555619882352941
        0.139172000000000	0.533810000000000	0.555232000000000
        0.137795882352941	0.537491176470588	0.554844117647059
        0.136419764705882	0.541172352941176	0.554456235294118
        0.135088823529412	0.544853529411765	0.553992117647059
        0.133791764705882	0.548534705882353	0.553470823529412
        0.132494705882353	0.552215882352941	0.552949529411765
        0.131197647058824	0.555897058823529	0.552428235294118
        0.129974352941176	0.559579529411765	0.551826705882353
        0.128818117647059	0.563263176470588	0.551152235294118
        0.127661882352941	0.566946823529412	0.550477764705882
        0.126505647058824	0.570630470588235	0.549803294117647
        0.125460000000000	0.574315294117647	0.549046470588235
        0.124536000000000	0.578001411764706	0.548199058823529
        0.123612000000000	0.581687529411765	0.547351647058824
        0.122688000000000	0.585373647058824	0.546504235294118
        0.121917529411765	0.589057647058824	0.545576352941177
        0.121351764705882	0.592738823529412	0.544541176470588
        0.120786000000000	0.596420000000000	0.543506000000000
        0.120220235294118	0.600101176470588	0.542470823529412
        0.119847411764706	0.603781411764706	0.541356588235294
        0.119788117647059	0.607460117647059	0.540113882352941
        0.119728823529412	0.611138823529412	0.538871176470588
        0.119669529411765	0.614817529411765	0.537628470588235
        0.119829294117647	0.618492117647059	0.536310000000000
        0.120427176470588	0.622158470588235	0.534840000000000
        0.121025058823529	0.625824823529412	0.533370000000000
        0.121622941176471	0.629491176470588	0.531900000000000
        0.122446705882353	0.633152588235294	0.530360823529412
        0.123835176470588	0.636801647058824	0.528648705882353
        0.125223647058824	0.640450705882353	0.526936588235294
        0.126612117647059	0.644099764705882	0.525224470588235
        0.128208823529412	0.647743529411765	0.523452352941177
        0.130471882352941	0.651370352941177	0.521488235294118
        0.132734941176471	0.654997176470588	0.519524117647059
        0.134998000000000	0.658624000000000	0.517560000000000
        0.137432823529412	0.662245176470588	0.515544117647059
        0.140597647058824	0.665842352941177	0.513308235294118
        0.143762470588235	0.669439529411765	0.511072352941177
        0.146927294117647	0.673036705882353	0.508836470588235
        0.150216352941177	0.676628235294118	0.506561058823529
        0.154250823529412	0.680185882352941	0.504048470588235
        0.158285294117647	0.683743529411765	0.501535882352941
        0.162319764705882	0.687301176470588	0.499023294117647
        0.166430470588235	0.690854352941177	0.496483176470588
        0.171265411764706	0.694365058823530	0.493681529411765
        0.176100352941176	0.697875764705882	0.490879882352941
        0.180935294117647	0.701386470588235	0.488078235294118
        0.185804588235294	0.704894352941176	0.485262470588235
        0.191360941176471	0.708345764705882	0.482164352941177
        0.196917294117647	0.711797176470588	0.479066235294118
        0.202473647058823	0.715248588235294	0.475968117647059
        0.208030000000000	0.718700000000000	0.472870000000000
        0.214231176470588	0.722087176470588	0.469470470588235
        0.220432352941176	0.725474352941177	0.466070941176471
        0.226633529411765	0.728861529411765	0.462671411764706
        0.232834705882353	0.732248705882353	0.459271882352941
        0.239577058823529	0.735560588235294	0.455578235294118
        0.246346470588235	0.738868705882353	0.451869882352941
        0.253115882352941	0.742176823529412	0.448161529411765
        0.259885294117647	0.745484941176471	0.444453176470588
        0.267117411764706	0.748717058823530	0.440463176470588
        0.274398235294118	0.751941176470588	0.436443529411765
        0.281679058823529	0.755165294117647	0.432423882352941
        0.288959882352941	0.758389411764706	0.428404235294118
        0.296634588235294	0.761528823529412	0.424115647058824
        0.304374941176471	0.764654117647059	0.419782235294118
        0.312115294117647	0.767779411764706	0.415448823529412
        0.319855647058824	0.770904705882353	0.411115411764706
        0.327936000000000	0.773942000000000	0.406530000000000
        0.336096352941176	0.776958588235294	0.401885294117647
        0.344256705882353	0.779975176470588	0.397240588235294
        0.352417058823529	0.782991764705882	0.392595882352941
        0.360867294117647	0.785919882352941	0.387712117647059
        0.369408117647059	0.788820352941177	0.382753647058824
        0.377948941176471	0.791720823529412	0.377795176470588
        0.386489764705882	0.794621294117647	0.372836705882353
        0.395282941176471	0.797430000000000	0.367657647058824
        0.404177058823529	0.800202000000000	0.362390352941177
        0.413071176470588	0.802974000000000	0.357123058823529
        0.421965294117647	0.805746000000000	0.351855764705882
        0.431076823529412	0.808427411764706	0.346384235294118
        0.440297058823530	0.811063529411765	0.340810588235294
        0.449517294117647	0.813699647058824	0.335236941176471
        0.458737529411765	0.816335764705882	0.329663294117647
        0.468138235294118	0.818880117647059	0.323909176470588
        0.477650000000000	0.821368000000000	0.318044000000000
        0.487161764705882	0.823855882352941	0.312178823529412
        0.496673529411765	0.826343764705882	0.306313647058824
        0.506339176470588	0.828744117647059	0.300287529411765
        0.516120235294118	0.831078823529412	0.294140705882353
        0.525901294117647	0.833413529411765	0.287993882352941
        0.535682352941177	0.835748235294118	0.281847058823529
        0.545583764705883	0.837998823529412	0.275565647058823
        0.555594588235294	0.840172941176471	0.269161882352941
        0.565605411764706	0.842347058823529	0.262758117647059
        0.575616235294118	0.844521176470588	0.256354352941177
        0.585720000000000	0.846620000000000	0.249849411764706
        0.595926000000000	0.848636000000000	0.243233176470588
        0.606132000000000	0.850652000000000	0.236616941176471
        0.616338000000000	0.852668000000000	0.230000705882353
        0.626608588235294	0.854614117647059	0.223325176470588
        0.636965294117647	0.856467058823530	0.216570588235294
        0.647322000000000	0.858320000000000	0.209816000000000
        0.657678705882353	0.860172941176471	0.203061411764706
        0.668072117647059	0.861968470588235	0.196302117647059
        0.678525176470588	0.863670705882353	0.189535176470588
        0.688978235294118	0.865372941176471	0.182768235294118
        0.699431294117647	0.867075176470588	0.176001294117647
        0.709899176470588	0.868729647058824	0.169311764705882
        0.720396705882353	0.870288588235294	0.162777058823529
        0.730894235294118	0.871847529411765	0.156242352941176
        0.741391764705882	0.873406470588235	0.149707647058824
        0.751881529411765	0.874931529411765	0.143363529411765
        0.762351882352941	0.876371882352941	0.137495882352941
        0.772822235294118	0.877812235294118	0.131628235294118
        0.783292588235294	0.879252588235294	0.125760588235294
        0.793742352941177	0.880669411764706	0.120233529411765
        0.804126235294118	0.882010941176471	0.115796352941176
        0.814510117647059	0.883352470588235	0.111359176470588
        0.824894000000000	0.884694000000000	0.106922000000000
        0.835249176470588	0.886023294117647	0.102954517647059
        0.845482352941177	0.887300588235294	0.100983235294118
        0.855715529411765	0.888577882352941	0.0990119529411765
        0.865948705882353	0.889855176470588	0.0970406705882353
        0.876152235294118	0.891127176470588	0.0955316705882353
        0.886177882352941	0.892367411764706	0.0967963647058824
        0.896203529411765	0.893607647058824	0.0980610588235294
        0.906229176470588	0.894847882352941	0.0993257529411765
        0.916230352941176	0.896088588235294	0.100879647058824
        0.925999058823530	0.897333764705882	0.105180941176471
        0.935767764705882	0.898578941176471	0.109482235294118
        0.945536470588235	0.899824117647059	0.113783529411765
        0.955291882352941	0.901070588235294	0.118186588235294
        0.964781411764706	0.902342941176471	0.124624941176471
        0.974270941176471	0.903615294117647	0.131063294117647
        0.983760470588235	0.904887647058823	0.137501647058823
        0.993250000000000	0.906160000000000	0.143940000000000];
end

if flipflag
    cmap = flipud(cmap);
end


