# Tablicious Online Documentation

This is the documentation site for Tablicious.

Tablicious is a package for GNU Octave that provides relational data structures for Octave. It includes implementations of `table` arrays, `datetime`, `string`, `categorical`, and some other related stuff. You can think of it as "pandas for Octave".

The repo for this project is at <https://github.com/apjanke/octave-tablicious>, where you can get the source code, report issues, and find more information.

## User Documentation

See the online [User Guide](release/v0.4.0/user-guide/html/index.html) for info and API Reference. There's also a [single-page version of the User Guide](release/v0.4.0/user-guide/tablicious.html), and a downloadable [PDF version](release/v0.4.0/user-guide/tablicious.pdf).

Those are for the latest release (currently 0.4.0). You can also see the docs for older specific releases, and the current in-progress development version (for the `main` branch of the Git repo).

### Releases

* Development branch (unreleased)
  * [User Guide, multiple pages](devel/user-guide/html/index.html)
  * [User Guide, single page](devel/user-guide/tablicious.html)
  * [User Guide, PDF](devel/user-guide/tablicious.pdf)
* v0.4.2 (2024-02-07)
  * [User Guide, multiple pages](release/v0.4.2/user-guide/html/index.html)
  * [User Guide, single page](release/v0.4.2/user-guide/tablicious.html)
  * [User Guide, PDF](release/v0.4.2/user-guide/tablicious.pdf)
* v0.4.1 (2024-02-07)
  * [User Guide, multiple pages](release/v0.4.1/user-guide/html/index.html)
  * [User Guide, single page](release/v0.4.1/user-guide/tablicious.html)
  * [User Guide, PDF](release/v0.4.1/user-guide/tablicious.pdf)
* v0.4.0 (2024-02-07)
  * [User Guide, multiple pages](release/v0.4.0/user-guide/html/index.html)
  * [User Guide, single page](release/v0.4.0/user-guide/tablicious.html)
  * [User Guide, PDF](release/v0.4.0/user-guide/tablicious.pdf)
* v0.3.7 (2023-01-05)
  * [User Guide, multiple pages](release/v0.3.7/user-guide/html/index.html)
  * [User Guide, single page](release/v0.3.7/user-guide/tablicious.html)
  * [User Guide, PDF](release/v0.3.7/user-guide/tablicious.pdf)
* v0.3.6 (2021-07-05)
  * [User Guide, multiple pages](release/v0.3.6/user-guide/html/index.html)
  * [User Guide, single page](release/v0.3.6/user-guide/tablicious.html)
  * [User Guide, PDF](release/v0.3.6/user-guide/tablicious.pdf)

There are older releases, too. Let me know if you actually want to see the doco for those online.

## Developer Documentation

* [Developer Notes](Developer-Notes.html) – documentation for developers of Tablicious itself
  * [Join Behavior](Join-Behavior.html) – Notes on "proxy keys" and other join-related stuff
  * [Design and Justification](Design-and-Justification.html)
  * [Release Checklist](Release-Checklist.html)
  * [TODO](TODO.html)
* [FAQ](FAQ.html) – Frequently Asked Questions
