# The Octave queueing toolbox

Copyright (C) 2008, 2009, 2010, 2011, 2012, 2013, 2018, 2020, 2024

Moreno Marzolla <moreno.marzolla@unibo.it>

## Description

The _queueing toolbox_ ("queueing", in short) is a collection of GNU
Octave scripts for numerical evaluation of queueing network
models. Open, closed and mixed networks are supported, with single or
multiple classes of customers. The queueing toolbox also provides
functions for steady-state and transient analysis of Markov chains, as
well as for single station queueing systems.

This package requires GNU Octave version 4.0.0 or later. GNU Octave is
free software and is available at https://www.gnu.org/software/octave/

The Octave queueing toolbox is distributed under the terms of the GNU
General Public License, version 3 or later. See the file `COPYING` for
details.

## Download and install

The Web pages of the queueing toolbox are

https://gnu-octave.github.io/packages/queueing/

https://www.moreno.marzolla.name/software/queueing/

where the latest version can be downloaded. See the installation
instructions there.

## Documentation

The queueing toolbox comes with extensive documentation; here is the
user manual in
[pdf](https://www.moreno.marzolla.name/software/queueing/queueing.pdf)
and
[html](https://www.moreno.marzolla.name/software/queueing/queueing.html)
format. Usage help for all functions is available through the `help`
built-in command at the GNU Octave prompt. See the manual for details.

## Citation

To cite the Octave queueing package use:

> Moreno Marzolla. 2022. Queueing Networks and Markov Chains Analysis
> with the Octave queueing package. SIGMETRICS Perform. Eval. Rev. 49,
> 4 (March 2022), 47–52. https://doi.org/10.1145/3543146.3543158

A BibTeX entry for LaTeX users is:

```
@article{queueing,
  author = {Marzolla, Moreno},
  title = {Queueing Networks and Markov Chains Analysis with the Octave queueing package},
  year = {2022},
  issue_date = {March 2022},
  publisher = {Association for Computing Machinery},
  address = {New York, NY, USA},
  volume = {49},
  number = {4},
  issn = {0163-5999},
  doi = {10.1145/3543146.3543158},
  journal = {SIGMETRICS Perform. Eval. Rev.},
  month = {jun},
  pages = {47--52}
}
```
