# Contribution Guidelines

## Introduction

Thank you for considering contributing to this Octave package. We hope that it
will grow to become an important part of the Octave toolset and community. Any
contribution is extremely welcome and appreciated.

These guidelines are designed to help all contributors understand how to work
and interact within this project.

## Basics

- Issues and merge requests via GitLab are very welcome
- Issues and changes should be small and focused on a particular topic
- Contributions include testing on various operating systems and environments,
  testing with a variety of Python libraries, writing documentation or
  examples, submitting issues, writing code, and proposing new features
- Contributors are expected to abide by the
  [code of conduct](CODE_OF_CONDUCT.md)

## Community

All project interaction takes place primarily on the GitLab project
[gnu-octave/octave-pythonic](https://gitlab.com/gnu-octave/octave-pythonic).

There is also a
[Python interface wiki page](https://wiki.octave.org/Python_interface) on the
[GNU Octave wiki](https://wiki.octave.org) that also contains examples and
ideas about this package.

Since this package is intended to be used by the Octave community, questions
and discussions may be sent to the
[Octave Discourse discussion forum](https://octave.discourse.group).

If you are not familiar or comfortable with such a forum, you can also
contact one of the maintainers directly at
[cbm@m.fsf.org](mailto:cbm@m.fsf.org).
