function status = jobState(ID)
    stateList = {...
      'PENDING' 'pending';...
      'RUNNING' 'running';...
      'COMPLETED' 'finished';...
      'CANCELLED' 'error';...
      'CANCELLED+' 'error';...
      'FAILED' 'error';...
      };
    [s, w] = system(sprintf('sacct -j %d --format=state',ID)); w = textscan(w,'%s'); w = w{1};
    if numel(w) == 2
      status = 'finished';
    else
      status = stateList{strcmp(stateList(:,1),deblank(w{3})),2};
    end
end
