## DO NOT EDIT!  Generated automatically from test/abs_rev.itl
## by the Interval Testing Framework for IEEE 1788.
## https://github.com/nehmeier/ITF1788/tree/29b1d1b6c3a640d4057fe86548d5e7d7c7265904
##
## Copyright 2015 Oliver Heimlich
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, see <http://www.gnu.org/licenses/>.
##
%!#Test library imports
%!function s = to_string (x)
%!    if (isnumeric (x))
%!        s = num2str (x);
%!    elseif (isa (x, 'infsup'))
%!        s = intervaltotext (x);
%!    elseif (isa (x, 'intval'))
%!        s = disp_ (x);
%!    else
%!        # x probably is a char.
%!        s = x;
%!    endif
%!endfunction
%!
%!function assert_warn (expected, actual)
%!    if (not (all (eq (expected, actual))))
%!        warning (["expected: ", to_string(expected), " actual value: ", to_string(actual)]);
%!    endif
%!endfunction

%!#Arithmetic library imports
%!function n = decval (dec)
%!    n = find (strcmp (dec, {"ill", "trv", "def", "dac", "com"}));
%!endfunction

%!#Preamble

## minimal.absRevBin_test

%!test
%! assert (all (eq (absrev (infsup, infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (absrev (infsup (0.0, 1.0), infsup), infsup)));
%!test
%! assert (all (eq (absrev (infsup (0.0, 1.0), infsup (7.0, 9.0)), infsup)));
%!test
%! assert (all (eq (absrev (infsup, infsup (0.0, 1.0)), infsup)));
%!test
%! assert (all (eq (absrev (infsup (-2.0, -1.0), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (absrev (infsup (1.0, 1.0), infsup (-inf, inf)), infsup (-1.0, 1.0))));
%!test
%! assert (all (eq (absrev (infsup (0.0, 0.0), infsup (-inf, inf)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (absrev (infsup (-1.0, -1.0), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (absrev (infsup (1.797693134862315708e+308, 1.797693134862315708e+308), infsup (-inf, inf)), infsup (-1.797693134862315708e+308, 1.797693134862315708e+308))));
%!test
%! assert (all (eq (absrev (infsup (2.225073858507201383e-308, 2.225073858507201383e-308), infsup (-inf, inf)), infsup (-2.225073858507201383e-308, 2.225073858507201383e-308))));
%!test
%! assert (all (eq (absrev (infsup (-2.225073858507201383e-308, -2.225073858507201383e-308), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (absrev (infsup (-1.797693134862315708e+308, -1.797693134862315708e+308), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (absrev (infsup (1.0, 2.0), infsup (-inf, inf)), infsup (-2.0, 2.0))));
%!test
%! assert (all (eq (absrev (infsup (1.0, 2.0), infsup (0.0, 2.0)), infsup (1.0, 2.0))));
%!test
%! assert (all (eq (absrev (infsup (0.0, 1.0), infsup (-0.5, 2.0)), infsup (-0.5, 1.0))));
%!test
%! assert (all (eq (absrev (infsup (-1.0, 1.0), infsup (-inf, inf)), infsup (-1.0, 1.0))));
%!test
%! assert (all (eq (absrev (infsup (-1.0, 0.0), infsup (-inf, inf)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (absrev (infsup (0.0, inf), infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (absrev (infsup (-inf, inf), infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (absrev (infsup (-inf, 0.0), infsup (-inf, inf)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (absrev (infsup (1.0, inf), infsup (-inf, 0.0)), infsup (-inf, -1.0))));
%!test
%! assert (all (eq (absrev (infsup (-1.0, inf), infsup (-inf, inf)), infsup (-inf, inf))));
%!test
%! assert (all (eq (absrev (infsup (-inf, -1.0), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (absrev (infsup (-inf, 1.0), infsup (-inf, inf)), infsup (-1.0, 1.0))));
